package ots

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"fmt"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/errors"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

var TriggerQueryJointer = "?TriggerARN="

func (client *Client) GetTrigger(request *GetTriggerRequest) (response *GetTriggerResponse, err error) {
	response = CreateGetTriggerResponse()
	err = client.DoAction(request, response)
	return
}

func (client *Client) GetTriggerWithChan(request *GetTriggerRequest) (<-chan *GetTriggerResponse, <-chan error) {
	responseChan := make(chan *GetTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTrigger(request)
		responseChan <- response
		errChan <- err
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

func (client *Client) GetTriggerWithCallback(request *GetTriggerRequest, callback func(response *GetTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTriggerResponse
		var err error
		defer close(result)
		response, err = client.GetTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

type GetTriggerRequest struct {
	*requests.RoaRequest
	InstanceName string `position:"Path" name:"InstanceName"`
	TriggerName  string `position:"Path" name:"TriggerName"`
	ApiVersion   string `position:"Path" name:"ApiVersion"`
	TableName    string `position:"Path" name:"TableName"`
}

type GetTriggerResponse struct {
	*responses.BaseResponse
}

func (resp *GetTriggerResponse) GetBody() (body *GetTriggerResponseBody, err error) {
	body = &GetTriggerResponseBody{}
	bodyBuf := resp.GetHttpContentBytes()
	err = json.Unmarshal(bodyBuf, body)
	if err != nil {
		errorMsg := fmt.Sprintf(CanNotUnmarshalRequestBodyMessage, string(bodyBuf))
		return nil, errors.NewClientError(CanNotUnmarshalRequestBodyCode, errorMsg, err)
	}
	return
}

func NewGetTriggerRequest(domain, instance, table, trigger, triggerArn string) (request *GetTriggerRequest) {
	triggerName := trigger
	if triggerArn != "" {
		triggerName += (TriggerQueryJointer + triggerArn)
	}
	request = &GetTriggerRequest{
		RoaRequest:   &requests.RoaRequest{},
		InstanceName: instance,
		TableName:    table,
		TriggerName:  triggerName,
		ApiVersion:   ApiVersion,
	}
	request.InitWithApiInfo("Ots", "2017-11-11", "GetTrigger", "/[ApiVersion]/instance/[InstanceName]/table/[TableName]/trigger/[TriggerName]", "", "")
	request.Domain = domain
	return
}

func CreateGetTriggerResponse() (response *GetTriggerResponse) {
	response = &GetTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
