package ots

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"fmt"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/errors"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

func (client *Client) ListTrigger(request *ListTriggerRequest) (response *ListTriggerResponse, err error) {
	response = CreateListTriggerResponse()
	err = client.DoAction(request, response)
	return
}

func (client *Client) ListTriggerWithChan(request *ListTriggerRequest) (<-chan *ListTriggerResponse, <-chan error) {
	responseChan := make(chan *ListTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTrigger(request)
		responseChan <- response
		errChan <- err
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

func (client *Client) ListTriggerWithCallback(request *ListTriggerRequest, callback func(response *ListTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTriggerResponse
		var err error
		defer close(result)
		response, err = client.ListTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

type ListTriggerRequest struct {
	*requests.RoaRequest
	InstanceName string `position:"Path" name:"InstanceName"`
	ApiVersion   string `position:"Path" name:"ApiVersion"`
	TableName    string `position:"Path" name:"TableName"`
}

type ListTriggerResponse struct {
	*responses.BaseResponse
}

func (resp *ListTriggerResponse) GetBody() (body *ListTriggerResponseBody, err error) {
	body = &ListTriggerResponseBody{}
	bodyBuf := resp.GetHttpContentBytes()
	err = json.Unmarshal(bodyBuf, body)
	if err != nil {
		errorMsg := fmt.Sprintf(CanNotUnmarshalRequestBodyMessage, string(bodyBuf))
		return nil, errors.NewClientError(CanNotUnmarshalRequestBodyCode, errorMsg, err)
	}
	return
}

func NewListTriggerRequest(domain, instance, table string) (request *ListTriggerRequest) {
	request = &ListTriggerRequest{
		RoaRequest:   &requests.RoaRequest{},
		InstanceName: instance,
		TableName:    table,
		ApiVersion:   ApiVersion,
	}
	request.InitWithApiInfo("Ots", "2017-11-11", "ListTrigger", "/[ApiVersion]/instance/[InstanceName]/table/[TableName]/trigger", "", "")
	request.Domain = domain
	return
}

func CreateListTriggerResponse() (response *ListTriggerResponse) {
	response = &ListTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
