package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDomainRealTimeHttpCodeData invokes the scdn.DescribeScdnDomainRealTimeHttpCodeData API synchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainrealtimehttpcodedata.html
func (client *Client) DescribeScdnDomainRealTimeHttpCodeData(request *DescribeScdnDomainRealTimeHttpCodeDataRequest) (response *DescribeScdnDomainRealTimeHttpCodeDataResponse, err error) {
	response = CreateDescribeScdnDomainRealTimeHttpCodeDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDomainRealTimeHttpCodeDataWithChan invokes the scdn.DescribeScdnDomainRealTimeHttpCodeData API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainrealtimehttpcodedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnDomainRealTimeHttpCodeDataWithChan(request *DescribeScdnDomainRealTimeHttpCodeDataRequest) (<-chan *DescribeScdnDomainRealTimeHttpCodeDataResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDomainRealTimeHttpCodeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDomainRealTimeHttpCodeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDomainRealTimeHttpCodeDataWithCallback invokes the scdn.DescribeScdnDomainRealTimeHttpCodeData API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainrealtimehttpcodedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnDomainRealTimeHttpCodeDataWithCallback(request *DescribeScdnDomainRealTimeHttpCodeDataRequest, callback func(response *DescribeScdnDomainRealTimeHttpCodeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDomainRealTimeHttpCodeDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDomainRealTimeHttpCodeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDomainRealTimeHttpCodeDataRequest is the request struct for api DescribeScdnDomainRealTimeHttpCodeData
type DescribeScdnDomainRealTimeHttpCodeDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeScdnDomainRealTimeHttpCodeDataResponse is the response struct for api DescribeScdnDomainRealTimeHttpCodeData
type DescribeScdnDomainRealTimeHttpCodeDataResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	DomainName           string               `json:"DomainName" xml:"DomainName"`
	StartTime            string               `json:"StartTime" xml:"StartTime"`
	EndTime              string               `json:"EndTime" xml:"EndTime"`
	DataInterval         string               `json:"DataInterval" xml:"DataInterval"`
	RealTimeHttpCodeData RealTimeHttpCodeData `json:"RealTimeHttpCodeData" xml:"RealTimeHttpCodeData"`
}

// CreateDescribeScdnDomainRealTimeHttpCodeDataRequest creates a request to invoke DescribeScdnDomainRealTimeHttpCodeData API
func CreateDescribeScdnDomainRealTimeHttpCodeDataRequest() (request *DescribeScdnDomainRealTimeHttpCodeDataRequest) {
	request = &DescribeScdnDomainRealTimeHttpCodeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDomainRealTimeHttpCodeData", "scdn", "openAPI")
	return
}

// CreateDescribeScdnDomainRealTimeHttpCodeDataResponse creates a response to parse from DescribeScdnDomainRealTimeHttpCodeData response
func CreateDescribeScdnDomainRealTimeHttpCodeDataResponse() (response *DescribeScdnDomainRealTimeHttpCodeDataResponse) {
	response = &DescribeScdnDomainRealTimeHttpCodeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
