// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/expr/v1alpha1/checked.proto

package expr

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_struct "github.com/golang/protobuf/ptypes/struct"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// CEL primitive types.
type Type_PrimitiveType int32

const (
	// Unspecified type.
	Type_PRIMITIVE_TYPE_UNSPECIFIED Type_PrimitiveType = 0
	// Boolean type.
	Type_BOOL Type_PrimitiveType = 1
	// Int64 type.
	//
	// Proto-based integer values are widened to int64.
	Type_INT64 Type_PrimitiveType = 2
	// Uint64 type.
	//
	// Proto-based unsigned integer values are widened to uint64.
	Type_UINT64 Type_PrimitiveType = 3
	// Double type.
	//
	// Proto-based float values are widened to double values.
	Type_DOUBLE Type_PrimitiveType = 4
	// String type.
	Type_STRING Type_PrimitiveType = 5
	// Bytes type.
	Type_BYTES Type_PrimitiveType = 6
)

var Type_PrimitiveType_name = map[int32]string{
	0: "PRIMITIVE_TYPE_UNSPECIFIED",
	1: "BOOL",
	2: "INT64",
	3: "UINT64",
	4: "DOUBLE",
	5: "STRING",
	6: "BYTES",
}

var Type_PrimitiveType_value = map[string]int32{
	"PRIMITIVE_TYPE_UNSPECIFIED": 0,
	"BOOL":                       1,
	"INT64":                      2,
	"UINT64":                     3,
	"DOUBLE":                     4,
	"STRING":                     5,
	"BYTES":                      6,
}

func (x Type_PrimitiveType) String() string {
	return proto.EnumName(Type_PrimitiveType_name, int32(x))
}

func (Type_PrimitiveType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 0}
}

// Well-known protobuf types treated with first-class support in CEL.
type Type_WellKnownType int32

const (
	// Unspecified type.
	Type_WELL_KNOWN_TYPE_UNSPECIFIED Type_WellKnownType = 0
	// Well-known protobuf.Any type.
	//
	// Any types are a polymorphic message type. During type-checking they are
	// treated like `DYN` types, but at runtime they are resolved to a specific
	// message type specified at evaluation time.
	Type_ANY Type_WellKnownType = 1
	// Well-known protobuf.Timestamp type, internally referenced as `timestamp`.
	Type_TIMESTAMP Type_WellKnownType = 2
	// Well-known protobuf.Duration type, internally referenced as `duration`.
	Type_DURATION Type_WellKnownType = 3
)

var Type_WellKnownType_name = map[int32]string{
	0: "WELL_KNOWN_TYPE_UNSPECIFIED",
	1: "ANY",
	2: "TIMESTAMP",
	3: "DURATION",
}

var Type_WellKnownType_value = map[string]int32{
	"WELL_KNOWN_TYPE_UNSPECIFIED": 0,
	"ANY":                         1,
	"TIMESTAMP":                   2,
	"DURATION":                    3,
}

func (x Type_WellKnownType) String() string {
	return proto.EnumName(Type_WellKnownType_name, int32(x))
}

func (Type_WellKnownType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 1}
}

// A CEL expression which has been successfully type checked.
type CheckedExpr struct {
	// A map from expression ids to resolved references.
	//
	// The following entries are in this table:
	//
	// - An Ident or Select expression is represented here if it resolves to a
	//   declaration. For instance, if `a.b.c` is represented by
	//   `select(select(id(a), b), c)`, and `a.b` resolves to a declaration,
	//   while `c` is a field selection, then the reference is attached to the
	//   nested select expression (but not to the id or or the outer select).
	//   In turn, if `a` resolves to a declaration and `b.c` are field selections,
	//   the reference is attached to the ident expression.
	// - Every Call expression has an entry here, identifying the function being
	//   called.
	// - Every CreateStruct expression for a message has an entry, identifying
	//   the message.
	ReferenceMap map[int64]*Reference `protobuf:"bytes,2,rep,name=reference_map,json=referenceMap,proto3" json:"reference_map,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A map from expression ids to types.
	//
	// Every expression node which has a type different than DYN has a mapping
	// here. If an expression has type DYN, it is omitted from this map to save
	// space.
	TypeMap map[int64]*Type `protobuf:"bytes,3,rep,name=type_map,json=typeMap,proto3" json:"type_map,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The source info derived from input that generated the parsed `expr` and
	// any optimizations made during the type-checking pass.
	SourceInfo *SourceInfo `protobuf:"bytes,5,opt,name=source_info,json=sourceInfo,proto3" json:"source_info,omitempty"`
	// The checked expression. Semantically equivalent to the parsed `expr`, but
	// may have structural differences.
	Expr                 *Expr    `protobuf:"bytes,4,opt,name=expr,proto3" json:"expr,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckedExpr) Reset()         { *m = CheckedExpr{} }
func (m *CheckedExpr) String() string { return proto.CompactTextString(m) }
func (*CheckedExpr) ProtoMessage()    {}
func (*CheckedExpr) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{0}
}

func (m *CheckedExpr) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckedExpr.Unmarshal(m, b)
}
func (m *CheckedExpr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckedExpr.Marshal(b, m, deterministic)
}
func (m *CheckedExpr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckedExpr.Merge(m, src)
}
func (m *CheckedExpr) XXX_Size() int {
	return xxx_messageInfo_CheckedExpr.Size(m)
}
func (m *CheckedExpr) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckedExpr.DiscardUnknown(m)
}

var xxx_messageInfo_CheckedExpr proto.InternalMessageInfo

func (m *CheckedExpr) GetReferenceMap() map[int64]*Reference {
	if m != nil {
		return m.ReferenceMap
	}
	return nil
}

func (m *CheckedExpr) GetTypeMap() map[int64]*Type {
	if m != nil {
		return m.TypeMap
	}
	return nil
}

func (m *CheckedExpr) GetSourceInfo() *SourceInfo {
	if m != nil {
		return m.SourceInfo
	}
	return nil
}

func (m *CheckedExpr) GetExpr() *Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

// Represents a CEL type.
type Type struct {
	// The kind of type.
	//
	// Types that are valid to be assigned to TypeKind:
	//	*Type_Dyn
	//	*Type_Null
	//	*Type_Primitive
	//	*Type_Wrapper
	//	*Type_WellKnown
	//	*Type_ListType_
	//	*Type_MapType_
	//	*Type_Function
	//	*Type_MessageType
	//	*Type_TypeParam
	//	*Type_Type
	//	*Type_Error
	//	*Type_AbstractType_
	TypeKind             isType_TypeKind `protobuf_oneof:"type_kind"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Type) Reset()         { *m = Type{} }
func (m *Type) String() string { return proto.CompactTextString(m) }
func (*Type) ProtoMessage()    {}
func (*Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1}
}

func (m *Type) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Type.Unmarshal(m, b)
}
func (m *Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Type.Marshal(b, m, deterministic)
}
func (m *Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type.Merge(m, src)
}
func (m *Type) XXX_Size() int {
	return xxx_messageInfo_Type.Size(m)
}
func (m *Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Type.DiscardUnknown(m)
}

var xxx_messageInfo_Type proto.InternalMessageInfo

type isType_TypeKind interface {
	isType_TypeKind()
}

type Type_Dyn struct {
	Dyn *empty.Empty `protobuf:"bytes,1,opt,name=dyn,proto3,oneof"`
}

type Type_Null struct {
	Null _struct.NullValue `protobuf:"varint,2,opt,name=null,proto3,enum=google.protobuf.NullValue,oneof"`
}

type Type_Primitive struct {
	Primitive Type_PrimitiveType `protobuf:"varint,3,opt,name=primitive,proto3,enum=google.api.expr.v1alpha1.Type_PrimitiveType,oneof"`
}

type Type_Wrapper struct {
	Wrapper Type_PrimitiveType `protobuf:"varint,4,opt,name=wrapper,proto3,enum=google.api.expr.v1alpha1.Type_PrimitiveType,oneof"`
}

type Type_WellKnown struct {
	WellKnown Type_WellKnownType `protobuf:"varint,5,opt,name=well_known,json=wellKnown,proto3,enum=google.api.expr.v1alpha1.Type_WellKnownType,oneof"`
}

type Type_ListType_ struct {
	ListType *Type_ListType `protobuf:"bytes,6,opt,name=list_type,json=listType,proto3,oneof"`
}

type Type_MapType_ struct {
	MapType *Type_MapType `protobuf:"bytes,7,opt,name=map_type,json=mapType,proto3,oneof"`
}

type Type_Function struct {
	Function *Type_FunctionType `protobuf:"bytes,8,opt,name=function,proto3,oneof"`
}

type Type_MessageType struct {
	MessageType string `protobuf:"bytes,9,opt,name=message_type,json=messageType,proto3,oneof"`
}

type Type_TypeParam struct {
	TypeParam string `protobuf:"bytes,10,opt,name=type_param,json=typeParam,proto3,oneof"`
}

type Type_Type struct {
	Type *Type `protobuf:"bytes,11,opt,name=type,proto3,oneof"`
}

type Type_Error struct {
	Error *empty.Empty `protobuf:"bytes,12,opt,name=error,proto3,oneof"`
}

type Type_AbstractType_ struct {
	AbstractType *Type_AbstractType `protobuf:"bytes,14,opt,name=abstract_type,json=abstractType,proto3,oneof"`
}

func (*Type_Dyn) isType_TypeKind() {}

func (*Type_Null) isType_TypeKind() {}

func (*Type_Primitive) isType_TypeKind() {}

func (*Type_Wrapper) isType_TypeKind() {}

func (*Type_WellKnown) isType_TypeKind() {}

func (*Type_ListType_) isType_TypeKind() {}

func (*Type_MapType_) isType_TypeKind() {}

func (*Type_Function) isType_TypeKind() {}

func (*Type_MessageType) isType_TypeKind() {}

func (*Type_TypeParam) isType_TypeKind() {}

func (*Type_Type) isType_TypeKind() {}

func (*Type_Error) isType_TypeKind() {}

func (*Type_AbstractType_) isType_TypeKind() {}

func (m *Type) GetTypeKind() isType_TypeKind {
	if m != nil {
		return m.TypeKind
	}
	return nil
}

func (m *Type) GetDyn() *empty.Empty {
	if x, ok := m.GetTypeKind().(*Type_Dyn); ok {
		return x.Dyn
	}
	return nil
}

func (m *Type) GetNull() _struct.NullValue {
	if x, ok := m.GetTypeKind().(*Type_Null); ok {
		return x.Null
	}
	return _struct.NullValue_NULL_VALUE
}

func (m *Type) GetPrimitive() Type_PrimitiveType {
	if x, ok := m.GetTypeKind().(*Type_Primitive); ok {
		return x.Primitive
	}
	return Type_PRIMITIVE_TYPE_UNSPECIFIED
}

func (m *Type) GetWrapper() Type_PrimitiveType {
	if x, ok := m.GetTypeKind().(*Type_Wrapper); ok {
		return x.Wrapper
	}
	return Type_PRIMITIVE_TYPE_UNSPECIFIED
}

func (m *Type) GetWellKnown() Type_WellKnownType {
	if x, ok := m.GetTypeKind().(*Type_WellKnown); ok {
		return x.WellKnown
	}
	return Type_WELL_KNOWN_TYPE_UNSPECIFIED
}

func (m *Type) GetListType() *Type_ListType {
	if x, ok := m.GetTypeKind().(*Type_ListType_); ok {
		return x.ListType
	}
	return nil
}

func (m *Type) GetMapType() *Type_MapType {
	if x, ok := m.GetTypeKind().(*Type_MapType_); ok {
		return x.MapType
	}
	return nil
}

func (m *Type) GetFunction() *Type_FunctionType {
	if x, ok := m.GetTypeKind().(*Type_Function); ok {
		return x.Function
	}
	return nil
}

func (m *Type) GetMessageType() string {
	if x, ok := m.GetTypeKind().(*Type_MessageType); ok {
		return x.MessageType
	}
	return ""
}

func (m *Type) GetTypeParam() string {
	if x, ok := m.GetTypeKind().(*Type_TypeParam); ok {
		return x.TypeParam
	}
	return ""
}

func (m *Type) GetType() *Type {
	if x, ok := m.GetTypeKind().(*Type_Type); ok {
		return x.Type
	}
	return nil
}

func (m *Type) GetError() *empty.Empty {
	if x, ok := m.GetTypeKind().(*Type_Error); ok {
		return x.Error
	}
	return nil
}

func (m *Type) GetAbstractType() *Type_AbstractType {
	if x, ok := m.GetTypeKind().(*Type_AbstractType_); ok {
		return x.AbstractType
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Type) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Type_OneofMarshaler, _Type_OneofUnmarshaler, _Type_OneofSizer, []interface{}{
		(*Type_Dyn)(nil),
		(*Type_Null)(nil),
		(*Type_Primitive)(nil),
		(*Type_Wrapper)(nil),
		(*Type_WellKnown)(nil),
		(*Type_ListType_)(nil),
		(*Type_MapType_)(nil),
		(*Type_Function)(nil),
		(*Type_MessageType)(nil),
		(*Type_TypeParam)(nil),
		(*Type_Type)(nil),
		(*Type_Error)(nil),
		(*Type_AbstractType_)(nil),
	}
}

func _Type_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Type)
	// type_kind
	switch x := m.TypeKind.(type) {
	case *Type_Dyn:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Dyn); err != nil {
			return err
		}
	case *Type_Null:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Null))
	case *Type_Primitive:
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Primitive))
	case *Type_Wrapper:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Wrapper))
	case *Type_WellKnown:
		b.EncodeVarint(5<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.WellKnown))
	case *Type_ListType_:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ListType); err != nil {
			return err
		}
	case *Type_MapType_:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MapType); err != nil {
			return err
		}
	case *Type_Function:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Function); err != nil {
			return err
		}
	case *Type_MessageType:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.MessageType)
	case *Type_TypeParam:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.TypeParam)
	case *Type_Type:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Type); err != nil {
			return err
		}
	case *Type_Error:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Error); err != nil {
			return err
		}
	case *Type_AbstractType_:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AbstractType); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Type.TypeKind has unexpected type %T", x)
	}
	return nil
}

func _Type_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Type)
	switch tag {
	case 1: // type_kind.dyn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(empty.Empty)
		err := b.DecodeMessage(msg)
		m.TypeKind = &Type_Dyn{msg}
		return true, err
	case 2: // type_kind.null
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.TypeKind = &Type_Null{_struct.NullValue(x)}
		return true, err
	case 3: // type_kind.primitive
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.TypeKind = &Type_Primitive{Type_PrimitiveType(x)}
		return true, err
	case 4: // type_kind.wrapper
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.TypeKind = &Type_Wrapper{Type_PrimitiveType(x)}
		return true, err
	case 5: // type_kind.well_known
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.TypeKind = &Type_WellKnown{Type_WellKnownType(x)}
		return true, err
	case 6: // type_kind.list_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Type_ListType)
		err := b.DecodeMessage(msg)
		m.TypeKind = &Type_ListType_{msg}
		return true, err
	case 7: // type_kind.map_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Type_MapType)
		err := b.DecodeMessage(msg)
		m.TypeKind = &Type_MapType_{msg}
		return true, err
	case 8: // type_kind.function
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Type_FunctionType)
		err := b.DecodeMessage(msg)
		m.TypeKind = &Type_Function{msg}
		return true, err
	case 9: // type_kind.message_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.TypeKind = &Type_MessageType{x}
		return true, err
	case 10: // type_kind.type_param
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.TypeKind = &Type_TypeParam{x}
		return true, err
	case 11: // type_kind.type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Type)
		err := b.DecodeMessage(msg)
		m.TypeKind = &Type_Type{msg}
		return true, err
	case 12: // type_kind.error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(empty.Empty)
		err := b.DecodeMessage(msg)
		m.TypeKind = &Type_Error{msg}
		return true, err
	case 14: // type_kind.abstract_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Type_AbstractType)
		err := b.DecodeMessage(msg)
		m.TypeKind = &Type_AbstractType_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Type_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Type)
	// type_kind
	switch x := m.TypeKind.(type) {
	case *Type_Dyn:
		s := proto.Size(x.Dyn)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Type_Null:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Null))
	case *Type_Primitive:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Primitive))
	case *Type_Wrapper:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Wrapper))
	case *Type_WellKnown:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.WellKnown))
	case *Type_ListType_:
		s := proto.Size(x.ListType)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Type_MapType_:
		s := proto.Size(x.MapType)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Type_Function:
		s := proto.Size(x.Function)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Type_MessageType:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.MessageType)))
		n += len(x.MessageType)
	case *Type_TypeParam:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.TypeParam)))
		n += len(x.TypeParam)
	case *Type_Type:
		s := proto.Size(x.Type)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Type_Error:
		s := proto.Size(x.Error)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Type_AbstractType_:
		s := proto.Size(x.AbstractType)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// List type with typed elements, e.g. `list<example.proto.MyMessage>`.
type Type_ListType struct {
	// The element type.
	ElemType             *Type    `protobuf:"bytes,1,opt,name=elem_type,json=elemType,proto3" json:"elem_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Type_ListType) Reset()         { *m = Type_ListType{} }
func (m *Type_ListType) String() string { return proto.CompactTextString(m) }
func (*Type_ListType) ProtoMessage()    {}
func (*Type_ListType) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 0}
}

func (m *Type_ListType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Type_ListType.Unmarshal(m, b)
}
func (m *Type_ListType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Type_ListType.Marshal(b, m, deterministic)
}
func (m *Type_ListType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type_ListType.Merge(m, src)
}
func (m *Type_ListType) XXX_Size() int {
	return xxx_messageInfo_Type_ListType.Size(m)
}
func (m *Type_ListType) XXX_DiscardUnknown() {
	xxx_messageInfo_Type_ListType.DiscardUnknown(m)
}

var xxx_messageInfo_Type_ListType proto.InternalMessageInfo

func (m *Type_ListType) GetElemType() *Type {
	if m != nil {
		return m.ElemType
	}
	return nil
}

// Map type with parameterized key and value types, e.g. `map<string, int>`.
type Type_MapType struct {
	// The type of the key.
	KeyType *Type `protobuf:"bytes,1,opt,name=key_type,json=keyType,proto3" json:"key_type,omitempty"`
	// The type of the value.
	ValueType            *Type    `protobuf:"bytes,2,opt,name=value_type,json=valueType,proto3" json:"value_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Type_MapType) Reset()         { *m = Type_MapType{} }
func (m *Type_MapType) String() string { return proto.CompactTextString(m) }
func (*Type_MapType) ProtoMessage()    {}
func (*Type_MapType) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 1}
}

func (m *Type_MapType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Type_MapType.Unmarshal(m, b)
}
func (m *Type_MapType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Type_MapType.Marshal(b, m, deterministic)
}
func (m *Type_MapType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type_MapType.Merge(m, src)
}
func (m *Type_MapType) XXX_Size() int {
	return xxx_messageInfo_Type_MapType.Size(m)
}
func (m *Type_MapType) XXX_DiscardUnknown() {
	xxx_messageInfo_Type_MapType.DiscardUnknown(m)
}

var xxx_messageInfo_Type_MapType proto.InternalMessageInfo

func (m *Type_MapType) GetKeyType() *Type {
	if m != nil {
		return m.KeyType
	}
	return nil
}

func (m *Type_MapType) GetValueType() *Type {
	if m != nil {
		return m.ValueType
	}
	return nil
}

// Function type with result and arg types.
type Type_FunctionType struct {
	// Result type of the function.
	ResultType *Type `protobuf:"bytes,1,opt,name=result_type,json=resultType,proto3" json:"result_type,omitempty"`
	// Argument types of the function.
	ArgTypes             []*Type  `protobuf:"bytes,2,rep,name=arg_types,json=argTypes,proto3" json:"arg_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Type_FunctionType) Reset()         { *m = Type_FunctionType{} }
func (m *Type_FunctionType) String() string { return proto.CompactTextString(m) }
func (*Type_FunctionType) ProtoMessage()    {}
func (*Type_FunctionType) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 2}
}

func (m *Type_FunctionType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Type_FunctionType.Unmarshal(m, b)
}
func (m *Type_FunctionType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Type_FunctionType.Marshal(b, m, deterministic)
}
func (m *Type_FunctionType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type_FunctionType.Merge(m, src)
}
func (m *Type_FunctionType) XXX_Size() int {
	return xxx_messageInfo_Type_FunctionType.Size(m)
}
func (m *Type_FunctionType) XXX_DiscardUnknown() {
	xxx_messageInfo_Type_FunctionType.DiscardUnknown(m)
}

var xxx_messageInfo_Type_FunctionType proto.InternalMessageInfo

func (m *Type_FunctionType) GetResultType() *Type {
	if m != nil {
		return m.ResultType
	}
	return nil
}

func (m *Type_FunctionType) GetArgTypes() []*Type {
	if m != nil {
		return m.ArgTypes
	}
	return nil
}

// Application defined abstract type.
type Type_AbstractType struct {
	// The fully qualified name of this abstract type.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Parameter types for this abstract type.
	ParameterTypes       []*Type  `protobuf:"bytes,2,rep,name=parameter_types,json=parameterTypes,proto3" json:"parameter_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Type_AbstractType) Reset()         { *m = Type_AbstractType{} }
func (m *Type_AbstractType) String() string { return proto.CompactTextString(m) }
func (*Type_AbstractType) ProtoMessage()    {}
func (*Type_AbstractType) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{1, 3}
}

func (m *Type_AbstractType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Type_AbstractType.Unmarshal(m, b)
}
func (m *Type_AbstractType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Type_AbstractType.Marshal(b, m, deterministic)
}
func (m *Type_AbstractType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type_AbstractType.Merge(m, src)
}
func (m *Type_AbstractType) XXX_Size() int {
	return xxx_messageInfo_Type_AbstractType.Size(m)
}
func (m *Type_AbstractType) XXX_DiscardUnknown() {
	xxx_messageInfo_Type_AbstractType.DiscardUnknown(m)
}

var xxx_messageInfo_Type_AbstractType proto.InternalMessageInfo

func (m *Type_AbstractType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Type_AbstractType) GetParameterTypes() []*Type {
	if m != nil {
		return m.ParameterTypes
	}
	return nil
}

// Represents a declaration of a named value or function.
//
// A declaration is part of the contract between the expression, the agent
// evaluating that expression, and the caller requesting evaluation.
type Decl struct {
	// The fully qualified name of the declaration.
	//
	// Declarations are organized in containers and this represents the full path
	// to the declaration in its container, as in `google.api.expr.Decl`.
	//
	// Declarations used as
	// [FunctionDecl.Overload][google.api.expr.v1alpha1.Decl.FunctionDecl.Overload]
	// parameters may or may not have a name depending on whether the overload is
	// function declaration or a function definition containing a result
	// [Expr][google.api.expr.v1alpha1.Expr].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The declaration kind.
	//
	// Types that are valid to be assigned to DeclKind:
	//	*Decl_Ident
	//	*Decl_Function
	DeclKind             isDecl_DeclKind `protobuf_oneof:"decl_kind"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Decl) Reset()         { *m = Decl{} }
func (m *Decl) String() string { return proto.CompactTextString(m) }
func (*Decl) ProtoMessage()    {}
func (*Decl) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{2}
}

func (m *Decl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Decl.Unmarshal(m, b)
}
func (m *Decl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Decl.Marshal(b, m, deterministic)
}
func (m *Decl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Decl.Merge(m, src)
}
func (m *Decl) XXX_Size() int {
	return xxx_messageInfo_Decl.Size(m)
}
func (m *Decl) XXX_DiscardUnknown() {
	xxx_messageInfo_Decl.DiscardUnknown(m)
}

var xxx_messageInfo_Decl proto.InternalMessageInfo

func (m *Decl) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isDecl_DeclKind interface {
	isDecl_DeclKind()
}

type Decl_Ident struct {
	Ident *Decl_IdentDecl `protobuf:"bytes,2,opt,name=ident,proto3,oneof"`
}

type Decl_Function struct {
	Function *Decl_FunctionDecl `protobuf:"bytes,3,opt,name=function,proto3,oneof"`
}

func (*Decl_Ident) isDecl_DeclKind() {}

func (*Decl_Function) isDecl_DeclKind() {}

func (m *Decl) GetDeclKind() isDecl_DeclKind {
	if m != nil {
		return m.DeclKind
	}
	return nil
}

func (m *Decl) GetIdent() *Decl_IdentDecl {
	if x, ok := m.GetDeclKind().(*Decl_Ident); ok {
		return x.Ident
	}
	return nil
}

func (m *Decl) GetFunction() *Decl_FunctionDecl {
	if x, ok := m.GetDeclKind().(*Decl_Function); ok {
		return x.Function
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Decl) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Decl_OneofMarshaler, _Decl_OneofUnmarshaler, _Decl_OneofSizer, []interface{}{
		(*Decl_Ident)(nil),
		(*Decl_Function)(nil),
	}
}

func _Decl_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Decl)
	// decl_kind
	switch x := m.DeclKind.(type) {
	case *Decl_Ident:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Ident); err != nil {
			return err
		}
	case *Decl_Function:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Function); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Decl.DeclKind has unexpected type %T", x)
	}
	return nil
}

func _Decl_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Decl)
	switch tag {
	case 2: // decl_kind.ident
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Decl_IdentDecl)
		err := b.DecodeMessage(msg)
		m.DeclKind = &Decl_Ident{msg}
		return true, err
	case 3: // decl_kind.function
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Decl_FunctionDecl)
		err := b.DecodeMessage(msg)
		m.DeclKind = &Decl_Function{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Decl_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Decl)
	// decl_kind
	switch x := m.DeclKind.(type) {
	case *Decl_Ident:
		s := proto.Size(x.Ident)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Decl_Function:
		s := proto.Size(x.Function)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Identifier declaration which specifies its type and optional `Expr` value.
//
// An identifier without a value is a declaration that must be provided at
// evaluation time. An identifier with a value should resolve to a constant,
// but may be used in conjunction with other identifiers bound at evaluation
// time.
type Decl_IdentDecl struct {
	// Required. The type of the identifier.
	Type *Type `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The constant value of the identifier. If not specified, the identifier
	// must be supplied at evaluation time.
	Value *Literal `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Documentation string for the identifier.
	Doc                  string   `protobuf:"bytes,3,opt,name=doc,proto3" json:"doc,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Decl_IdentDecl) Reset()         { *m = Decl_IdentDecl{} }
func (m *Decl_IdentDecl) String() string { return proto.CompactTextString(m) }
func (*Decl_IdentDecl) ProtoMessage()    {}
func (*Decl_IdentDecl) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{2, 0}
}

func (m *Decl_IdentDecl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Decl_IdentDecl.Unmarshal(m, b)
}
func (m *Decl_IdentDecl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Decl_IdentDecl.Marshal(b, m, deterministic)
}
func (m *Decl_IdentDecl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Decl_IdentDecl.Merge(m, src)
}
func (m *Decl_IdentDecl) XXX_Size() int {
	return xxx_messageInfo_Decl_IdentDecl.Size(m)
}
func (m *Decl_IdentDecl) XXX_DiscardUnknown() {
	xxx_messageInfo_Decl_IdentDecl.DiscardUnknown(m)
}

var xxx_messageInfo_Decl_IdentDecl proto.InternalMessageInfo

func (m *Decl_IdentDecl) GetType() *Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Decl_IdentDecl) GetValue() *Literal {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Decl_IdentDecl) GetDoc() string {
	if m != nil {
		return m.Doc
	}
	return ""
}

// Function declaration specifies one or more overloads which indicate the
// function's parameter types and return type, and may optionally specify a
// function definition in terms of CEL expressions.
//
// Functions have no observable side-effects (there may be side-effects like
// logging which are not observable from CEL).
type Decl_FunctionDecl struct {
	// Required. List of function overloads, must contain at least one overload.
	Overloads            []*Decl_FunctionDecl_Overload `protobuf:"bytes,1,rep,name=overloads,proto3" json:"overloads,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *Decl_FunctionDecl) Reset()         { *m = Decl_FunctionDecl{} }
func (m *Decl_FunctionDecl) String() string { return proto.CompactTextString(m) }
func (*Decl_FunctionDecl) ProtoMessage()    {}
func (*Decl_FunctionDecl) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{2, 1}
}

func (m *Decl_FunctionDecl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Decl_FunctionDecl.Unmarshal(m, b)
}
func (m *Decl_FunctionDecl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Decl_FunctionDecl.Marshal(b, m, deterministic)
}
func (m *Decl_FunctionDecl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Decl_FunctionDecl.Merge(m, src)
}
func (m *Decl_FunctionDecl) XXX_Size() int {
	return xxx_messageInfo_Decl_FunctionDecl.Size(m)
}
func (m *Decl_FunctionDecl) XXX_DiscardUnknown() {
	xxx_messageInfo_Decl_FunctionDecl.DiscardUnknown(m)
}

var xxx_messageInfo_Decl_FunctionDecl proto.InternalMessageInfo

func (m *Decl_FunctionDecl) GetOverloads() []*Decl_FunctionDecl_Overload {
	if m != nil {
		return m.Overloads
	}
	return nil
}

// An overload indicates a function's parameter types and return type, and
// may optionally include a function body described in terms of
// [Expr][google.api.expr.v1alpha1.Expr] values.
//
// Functions overloads are declared in either a function or method
// call-style. For methods, the `params[0]` is the expected type of the
// target receiver.
//
// Overloads must have non-overlapping argument types after erasure of all
// parameterized type variables (similar as type erasure in Java).
type Decl_FunctionDecl_Overload struct {
	// Required. Globally unique overload name of the function which reflects
	// the function name and argument types.
	//
	// This will be used by a [Reference][google.api.expr.v1alpha1.Reference]
	// to indicate the `overload_id` that was resolved for the function
	// `name`.
	OverloadId string `protobuf:"bytes,1,opt,name=overload_id,json=overloadId,proto3" json:"overload_id,omitempty"`
	// List of function parameter [Type][google.api.expr.v1alpha1.Type]
	// values.
	//
	// Param types are disjoint after generic type parameters have been
	// replaced with the type `DYN`. Since the `DYN` type is compatible with
	// any other type, this means that if `A` is a type parameter, the
	// function types `int<A>` and `int<int>` are not disjoint. Likewise,
	// `map<string, string>` is not disjoint from `map<K, V>`.
	//
	// When the `result_type` of a function is a generic type param, the
	// type param name also appears as the `type` of on at least one params.
	Params []*Type `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty"`
	// The type param names associated with the function declaration.
	//
	// For example, `function ex<K,V>(K key, map<K, V> map) : V` would yield
	// the type params of `K, V`.
	TypeParams []string `protobuf:"bytes,3,rep,name=type_params,json=typeParams,proto3" json:"type_params,omitempty"`
	// Required. The result type of the function. For example, the operator
	// `string.isEmpty()` would have `result_type` of `kind: BOOL`.
	ResultType *Type `protobuf:"bytes,4,opt,name=result_type,json=resultType,proto3" json:"result_type,omitempty"`
	// Whether the function is to be used in a method call-style `x.f(...)`
	// of a function call-style `f(x, ...)`.
	//
	// For methods, the first parameter declaration, `params[0]` is the
	// expected type of the target receiver.
	IsInstanceFunction bool `protobuf:"varint,5,opt,name=is_instance_function,json=isInstanceFunction,proto3" json:"is_instance_function,omitempty"`
	// Documentation string for the overload.
	Doc                  string   `protobuf:"bytes,6,opt,name=doc,proto3" json:"doc,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Decl_FunctionDecl_Overload) Reset()         { *m = Decl_FunctionDecl_Overload{} }
func (m *Decl_FunctionDecl_Overload) String() string { return proto.CompactTextString(m) }
func (*Decl_FunctionDecl_Overload) ProtoMessage()    {}
func (*Decl_FunctionDecl_Overload) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{2, 1, 0}
}

func (m *Decl_FunctionDecl_Overload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Decl_FunctionDecl_Overload.Unmarshal(m, b)
}
func (m *Decl_FunctionDecl_Overload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Decl_FunctionDecl_Overload.Marshal(b, m, deterministic)
}
func (m *Decl_FunctionDecl_Overload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Decl_FunctionDecl_Overload.Merge(m, src)
}
func (m *Decl_FunctionDecl_Overload) XXX_Size() int {
	return xxx_messageInfo_Decl_FunctionDecl_Overload.Size(m)
}
func (m *Decl_FunctionDecl_Overload) XXX_DiscardUnknown() {
	xxx_messageInfo_Decl_FunctionDecl_Overload.DiscardUnknown(m)
}

var xxx_messageInfo_Decl_FunctionDecl_Overload proto.InternalMessageInfo

func (m *Decl_FunctionDecl_Overload) GetOverloadId() string {
	if m != nil {
		return m.OverloadId
	}
	return ""
}

func (m *Decl_FunctionDecl_Overload) GetParams() []*Type {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *Decl_FunctionDecl_Overload) GetTypeParams() []string {
	if m != nil {
		return m.TypeParams
	}
	return nil
}

func (m *Decl_FunctionDecl_Overload) GetResultType() *Type {
	if m != nil {
		return m.ResultType
	}
	return nil
}

func (m *Decl_FunctionDecl_Overload) GetIsInstanceFunction() bool {
	if m != nil {
		return m.IsInstanceFunction
	}
	return false
}

func (m *Decl_FunctionDecl_Overload) GetDoc() string {
	if m != nil {
		return m.Doc
	}
	return ""
}

// Describes a resolved reference to a declaration.
type Reference struct {
	// The fully qualified name of the declaration.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// For references to functions, this is a list of `Overload.overload_id`
	// values which match according to typing rules.
	//
	// If the list has more than one element, overload resolution among the
	// presented candidates must happen at runtime because of dynamic types. The
	// type checker attempts to narrow down this list as much as possible.
	//
	// Empty if this is not a reference to a
	// [Decl.FunctionDecl][google.api.expr.v1alpha1.Decl.FunctionDecl].
	OverloadId []string `protobuf:"bytes,3,rep,name=overload_id,json=overloadId,proto3" json:"overload_id,omitempty"`
	// For references to constants, this may contain the value of the
	// constant if known at compile time.
	Value                *Literal `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Reference) Reset()         { *m = Reference{} }
func (m *Reference) String() string { return proto.CompactTextString(m) }
func (*Reference) ProtoMessage()    {}
func (*Reference) Descriptor() ([]byte, []int) {
	return fileDescriptor_30a741de3e790389, []int{3}
}

func (m *Reference) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Reference.Unmarshal(m, b)
}
func (m *Reference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Reference.Marshal(b, m, deterministic)
}
func (m *Reference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Reference.Merge(m, src)
}
func (m *Reference) XXX_Size() int {
	return xxx_messageInfo_Reference.Size(m)
}
func (m *Reference) XXX_DiscardUnknown() {
	xxx_messageInfo_Reference.DiscardUnknown(m)
}

var xxx_messageInfo_Reference proto.InternalMessageInfo

func (m *Reference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Reference) GetOverloadId() []string {
	if m != nil {
		return m.OverloadId
	}
	return nil
}

func (m *Reference) GetValue() *Literal {
	if m != nil {
		return m.Value
	}
	return nil
}

func init() {
	proto.RegisterType((*CheckedExpr)(nil), "google.api.expr.v1alpha1.CheckedExpr")
	proto.RegisterMapType((map[int64]*Reference)(nil), "google.api.expr.v1alpha1.CheckedExpr.ReferenceMapEntry")
	proto.RegisterMapType((map[int64]*Type)(nil), "google.api.expr.v1alpha1.CheckedExpr.TypeMapEntry")
	proto.RegisterType((*Type)(nil), "google.api.expr.v1alpha1.Type")
	proto.RegisterType((*Type_ListType)(nil), "google.api.expr.v1alpha1.Type.ListType")
	proto.RegisterType((*Type_MapType)(nil), "google.api.expr.v1alpha1.Type.MapType")
	proto.RegisterType((*Type_FunctionType)(nil), "google.api.expr.v1alpha1.Type.FunctionType")
	proto.RegisterType((*Type_AbstractType)(nil), "google.api.expr.v1alpha1.Type.AbstractType")
	proto.RegisterType((*Decl)(nil), "google.api.expr.v1alpha1.Decl")
	proto.RegisterType((*Decl_IdentDecl)(nil), "google.api.expr.v1alpha1.Decl.IdentDecl")
	proto.RegisterType((*Decl_FunctionDecl)(nil), "google.api.expr.v1alpha1.Decl.FunctionDecl")
	proto.RegisterType((*Decl_FunctionDecl_Overload)(nil), "google.api.expr.v1alpha1.Decl.FunctionDecl.Overload")
	proto.RegisterType((*Reference)(nil), "google.api.expr.v1alpha1.Reference")
	proto.RegisterEnum("google.api.expr.v1alpha1.Type_PrimitiveType", Type_PrimitiveType_name, Type_PrimitiveType_value)
	proto.RegisterEnum("google.api.expr.v1alpha1.Type_WellKnownType", Type_WellKnownType_name, Type_WellKnownType_value)
}

func init() {
	proto.RegisterFile("google/api/expr/v1alpha1/checked.proto", fileDescriptor_30a741de3e790389)
}

var fileDescriptor_30a741de3e790389 = []byte{
	// 1142 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0x5d, 0x6f, 0xdb, 0x36,
	0x14, 0x8d, 0x2c, 0xd9, 0x96, 0xae, 0x9c, 0xcc, 0x23, 0x86, 0x41, 0x50, 0x8b, 0x26, 0x4b, 0xb7,
	0x2e, 0xd8, 0x06, 0xb9, 0xf5, 0x82, 0x76, 0x5d, 0x37, 0x6c, 0x71, 0xa2, 0x24, 0x42, 0xfd, 0x05,
	0xc5, 0x49, 0x90, 0x62, 0x80, 0xc1, 0xc8, 0x8c, 0x2b, 0x58, 0x96, 0x04, 0x4a, 0x4e, 0xe2, 0xe7,
	0x3d, 0x6d, 0xd8, 0xaf, 0xd9, 0xaf, 0xd8, 0xaf, 0xd9, 0xeb, 0xf6, 0x58, 0x90, 0x92, 0x1c, 0xe7,
	0xc3, 0xb5, 0xfd, 0x76, 0x45, 0x9e, 0x73, 0x78, 0x79, 0x79, 0x2e, 0x29, 0x78, 0xd6, 0x0f, 0x82,
	0xbe, 0x47, 0x2a, 0x38, 0x74, 0x2b, 0xe4, 0x3a, 0xa4, 0x95, 0xcb, 0x17, 0xd8, 0x0b, 0xdf, 0xe3,
	0x17, 0x15, 0xe7, 0x3d, 0x71, 0x06, 0xa4, 0x67, 0x84, 0x34, 0x88, 0x03, 0xa4, 0x25, 0x38, 0x03,
	0x87, 0xae, 0xc1, 0x70, 0x46, 0x86, 0xd3, 0xbf, 0x9a, 0xa9, 0x10, 0x8d, 0xfd, 0x18, 0x5f, 0x27,
	0x02, 0xfa, 0xa3, 0x14, 0xc6, 0xbf, 0xce, 0x47, 0x17, 0x15, 0x32, 0x0c, 0xe3, 0x71, 0x3a, 0xf9,
	0xf8, 0xee, 0x64, 0x14, 0xd3, 0x91, 0x13, 0x27, 0xb3, 0x9b, 0xff, 0x89, 0xa0, 0xee, 0x26, 0xd9,
	0x98, 0xd7, 0x21, 0x45, 0xbf, 0xc1, 0x2a, 0x25, 0x17, 0x84, 0x12, 0xdf, 0x21, 0xdd, 0x21, 0x0e,
	0xb5, 0xdc, 0x86, 0xb8, 0xa5, 0x56, 0x5f, 0x19, 0xb3, 0x72, 0x34, 0xa6, 0xd8, 0x86, 0x9d, 0x51,
	0x1b, 0x38, 0x34, 0xfd, 0x98, 0x8e, 0xed, 0x12, 0x9d, 0x1a, 0x42, 0x0d, 0x90, 0xe3, 0x71, 0x98,
	0x08, 0x8b, 0x5c, 0xb8, 0xba, 0x98, 0x70, 0x67, 0x1c, 0xde, 0x68, 0x16, 0xe3, 0xe4, 0x0b, 0x99,
	0xa0, 0x46, 0xc1, 0x88, 0x3a, 0xa4, 0xeb, 0xfa, 0x17, 0x81, 0x96, 0xdf, 0x10, 0xb6, 0xd4, 0xea,
	0x97, 0xb3, 0x15, 0x8f, 0x38, 0xd8, 0xf2, 0x2f, 0x02, 0x1b, 0xa2, 0x49, 0x8c, 0xaa, 0x20, 0x31,
	0x9c, 0x26, 0x71, 0xfe, 0x93, 0xd9, 0x7c, 0x96, 0x8a, 0xcd, 0xb1, 0x7a, 0x0f, 0x3e, 0xbd, 0xb7,
	0x59, 0x54, 0x06, 0x71, 0x40, 0xc6, 0x9a, 0xb0, 0x21, 0x6c, 0x89, 0x36, 0x0b, 0xd1, 0x6b, 0xc8,
	0x5f, 0x62, 0x6f, 0x44, 0xb4, 0x1c, 0xd7, 0x7e, 0x3a, 0x5b, 0x7b, 0xa2, 0x66, 0x27, 0x8c, 0x1f,
	0x73, 0x3f, 0x08, 0xfa, 0x3b, 0x28, 0x4d, 0xef, 0xfc, 0x81, 0x05, 0xb6, 0x6f, 0x2f, 0xf0, 0x91,
	0xe4, 0x99, 0xd0, 0x94, 0xf6, 0xe6, 0x3f, 0x2a, 0x48, 0x6c, 0x0c, 0x7d, 0x03, 0x62, 0x6f, 0xec,
	0x73, 0x51, 0xb5, 0xfa, 0x79, 0x26, 0x90, 0xd9, 0xc5, 0x30, 0x99, 0x97, 0x0e, 0x57, 0x6c, 0x06,
	0x42, 0xcf, 0x41, 0xf2, 0x47, 0x9e, 0xc7, 0x57, 0x5b, 0xab, 0xea, 0xf7, 0xc0, 0xcd, 0x91, 0xe7,
	0x9d, 0xb0, 0x25, 0x0e, 0x57, 0x6c, 0x8e, 0x44, 0x75, 0x50, 0x42, 0xea, 0x0e, 0xdd, 0xd8, 0xbd,
	0x24, 0x9a, 0xc8, 0x69, 0xdf, 0x7d, 0x3c, 0x49, 0xa3, 0x9d, 0xe1, 0xd9, 0xd7, 0xe1, 0x8a, 0x7d,
	0x23, 0x80, 0x0e, 0xa1, 0x78, 0x45, 0x71, 0x18, 0x92, 0xe4, 0xb4, 0x96, 0xd7, 0xca, 0xe8, 0xa8,
	0x01, 0x70, 0x45, 0x3c, 0xaf, 0x3b, 0xf0, 0x83, 0x2b, 0x9f, 0x5b, 0x67, 0xbe, 0xd8, 0x29, 0xf1,
	0xbc, 0xb7, 0x0c, 0x9f, 0x25, 0x76, 0x95, 0x0d, 0xa0, 0x7d, 0x50, 0x3c, 0x37, 0x8a, 0xbb, 0xcc,
	0x9a, 0x5a, 0x81, 0x97, 0xf2, 0xeb, 0x39, 0x6a, 0x75, 0x37, 0x8a, 0x53, 0x21, 0xd9, 0x4b, 0x63,
	0xb4, 0x0b, 0xf2, 0x10, 0x87, 0x89, 0x4c, 0x91, 0xcb, 0x3c, 0x9b, 0x23, 0xd3, 0xc0, 0x61, 0xb6,
	0xb7, 0x61, 0x12, 0x22, 0x0b, 0xe4, 0x8b, 0x91, 0xef, 0xc4, 0x6e, 0xe0, 0x6b, 0x32, 0x17, 0xf9,
	0x76, 0x8e, 0xc8, 0x7e, 0x0a, 0xcf, 0xf2, 0xc9, 0xe8, 0xe8, 0x29, 0x94, 0x86, 0x24, 0x8a, 0x70,
	0x9f, 0x24, 0x39, 0x29, 0x1b, 0xc2, 0x96, 0x72, 0xb8, 0x62, 0xab, 0xe9, 0x28, 0x5f, 0x6f, 0x1d,
	0x80, 0xb7, 0x75, 0x88, 0x29, 0x1e, 0x6a, 0x90, 0x42, 0x14, 0x36, 0xd6, 0x66, 0x43, 0x68, 0x1b,
	0x24, 0xce, 0x56, 0x17, 0x31, 0x29, 0xb3, 0x0e, 0x43, 0x23, 0x03, 0xf2, 0x84, 0xd2, 0x80, 0x6a,
	0xa5, 0x39, 0xd6, 0x4c, 0x60, 0xc8, 0x86, 0x55, 0x7c, 0x1e, 0xc5, 0x14, 0x3b, 0xe9, 0x39, 0xac,
	0x2d, 0xb4, 0xf7, 0x9d, 0x94, 0x93, 0xae, 0x5d, 0xc2, 0x53, 0xdf, 0xfa, 0x01, 0xc8, 0xd9, 0x39,
	0xa1, 0x37, 0xa0, 0x10, 0x8f, 0x0c, 0x13, 0x6d, 0x61, 0xa1, 0x7e, 0x93, 0x19, 0x81, 0x0b, 0xfd,
	0x2e, 0x40, 0x31, 0x3d, 0x2a, 0xf4, 0x1a, 0xe4, 0x01, 0x19, 0x2f, 0xa3, 0x53, 0x1c, 0x90, 0x31,
	0xa7, 0xfe, 0x0c, 0xc0, 0x5b, 0x38, 0x21, 0x2f, 0xd6, 0xf4, 0x0a, 0x67, 0xf0, 0x2c, 0xfe, 0x12,
	0xa0, 0x34, 0x7d, 0xd6, 0xe8, 0x17, 0x50, 0x29, 0x89, 0x46, 0x5e, 0xbc, 0x4c, 0x36, 0x90, 0x50,
	0xb2, 0xa2, 0x60, 0xda, 0xe7, 0xec, 0x28, 0x7d, 0x2c, 0xe6, 0x16, 0x05, 0xd3, 0x3e, 0x0b, 0x22,
	0x7d, 0x00, 0xa5, 0xe9, 0xea, 0x23, 0x04, 0x92, 0x8f, 0x87, 0x49, 0x1a, 0x8a, 0xcd, 0x63, 0x74,
	0x00, 0x9f, 0x70, 0x5f, 0x91, 0x98, 0xd0, 0xa5, 0x96, 0x59, 0x9b, 0xd0, 0xf8, 0x62, 0x9b, 0x11,
	0xac, 0xde, 0xba, 0x0d, 0xd0, 0x13, 0xd0, 0xdb, 0xb6, 0xd5, 0xb0, 0x3a, 0xd6, 0x89, 0xd9, 0xed,
	0x9c, 0xb5, 0xcd, 0xee, 0x71, 0xf3, 0xa8, 0x6d, 0xee, 0x5a, 0xfb, 0x96, 0xb9, 0x57, 0x5e, 0x41,
	0x32, 0x48, 0xb5, 0x56, 0xab, 0x5e, 0x16, 0x90, 0x02, 0x79, 0xab, 0xd9, 0x79, 0xb9, 0x5d, 0xce,
	0x21, 0x80, 0xc2, 0x71, 0x12, 0x8b, 0x2c, 0xde, 0x6b, 0x1d, 0xd7, 0xea, 0x66, 0x59, 0x62, 0xf1,
	0x51, 0xc7, 0xb6, 0x9a, 0x07, 0xe5, 0x3c, 0x83, 0xd7, 0xce, 0x3a, 0xe6, 0x51, 0xb9, 0xb0, 0x79,
	0x02, 0xab, 0xb7, 0x6e, 0x0d, 0xb4, 0x0e, 0x8f, 0x4e, 0xcd, 0x7a, 0xbd, 0xfb, 0xb6, 0xd9, 0x3a,
	0x6d, 0x3e, 0xb4, 0x6a, 0x11, 0xc4, 0x9d, 0xe6, 0x59, 0x59, 0x40, 0xab, 0xa0, 0x74, 0xac, 0x86,
	0x79, 0xd4, 0xd9, 0x69, 0xb4, 0xcb, 0x39, 0x54, 0x02, 0x79, 0xef, 0xd8, 0xde, 0xe9, 0x58, 0xad,
	0x66, 0x59, 0xac, 0xa9, 0xc0, 0xdb, 0xab, 0x3b, 0x70, 0xfd, 0xde, 0xe6, 0xdf, 0x79, 0x90, 0xf6,
	0x88, 0xe3, 0x3d, 0x58, 0xbf, 0x5f, 0x21, 0xef, 0xf6, 0x88, 0x1f, 0xa7, 0x66, 0xd9, 0x9a, 0x5d,
	0x35, 0x26, 0x61, 0x58, 0x0c, 0xcb, 0x22, 0xd6, 0x57, 0x9c, 0x78, 0xeb, 0x3a, 0x11, 0xe7, 0xb5,
	0x14, 0x17, 0xc9, 0x2c, 0x96, 0xea, 0x4c, 0xe8, 0xfa, 0x9f, 0x02, 0x28, 0x93, 0x15, 0xd8, 0xc3,
	0xbb, 0x84, 0xeb, 0x92, 0x4b, 0xe1, 0xd5, 0xed, 0x07, 0xef, 0x8b, 0xd9, 0xa4, 0xba, 0x1b, 0x13,
	0x8a, 0xbd, 0xf4, 0xcd, 0x63, 0x6f, 0x67, 0x2f, 0x70, 0xf8, 0x06, 0x14, 0x9b, 0x85, 0xfa, 0xbf,
	0xb9, 0x9b, 0x66, 0xe0, 0xf9, 0xd8, 0xa0, 0x04, 0x97, 0x84, 0x7a, 0x01, 0xee, 0x45, 0x9a, 0xc0,
	0x4d, 0xb6, 0xbd, 0xc4, 0x4e, 0x8d, 0x56, 0x4a, 0xb6, 0x6f, 0x64, 0xf4, 0x3f, 0x72, 0x20, 0x67,
	0xe3, 0x68, 0x1d, 0xd4, 0x6c, 0xa6, 0xeb, 0xf6, 0xd2, 0x63, 0x82, 0x6c, 0xc8, 0xea, 0xa1, 0x97,
	0x50, 0xe0, 0xae, 0x5d, 0xd4, 0xe3, 0x29, 0x9a, 0x09, 0xdf, 0xdc, 0xc0, 0x11, 0xff, 0xb7, 0x52,
	0x6c, 0x98, 0x5c, 0xc0, 0xd1, 0xdd, 0x3e, 0x97, 0x96, 0xee, 0xf3, 0xe7, 0xf0, 0x99, 0x1b, 0x75,
	0x5d, 0x3f, 0x8a, 0x31, 0xfb, 0x35, 0x9c, 0x18, 0x82, 0xbd, 0x9c, 0xb2, 0x8d, 0xdc, 0xc8, 0x4a,
	0xa7, 0xb2, 0x8a, 0x64, 0x05, 0x2f, 0x4c, 0x0a, 0xce, 0x4c, 0xdb, 0x23, 0x8e, 0x97, 0x98, 0x76,
	0x0c, 0xca, 0xe4, 0x9f, 0xe7, 0x41, 0xe3, 0xde, 0x29, 0x56, 0xba, 0xa7, 0xa9, 0x62, 0x4d, 0xac,
	0x20, 0x2d, 0x67, 0x85, 0x9a, 0x07, 0x8f, 0x9d, 0x60, 0x38, 0x13, 0x5e, 0x53, 0xd8, 0x69, 0xb6,
	0xd9, 0x2b, 0xd3, 0x16, 0xde, 0xfd, 0x94, 0xc2, 0xfa, 0x81, 0x87, 0xfd, 0xbe, 0x11, 0xd0, 0x7e,
	0xa5, 0x4f, 0x7c, 0xfe, 0x06, 0x55, 0x92, 0x29, 0x1c, 0xba, 0xd1, 0xfd, 0x5f, 0xf4, 0x37, 0xec,
	0xeb, 0x7f, 0x41, 0x38, 0x2f, 0x70, 0xec, 0xf7, 0x1f, 0x02, 0x00, 0x00, 0xff, 0xff, 0xa6, 0xfb,
	0xf6, 0x58, 0x0f, 0x0c, 0x00, 0x00,
}
