// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

package datatransfer

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	math "math"
)

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Parameter type.
type DataSourceParameter_Type int32

const (
	// Type unspecified.
	DataSourceParameter_TYPE_UNSPECIFIED DataSourceParameter_Type = 0
	// String parameter.
	DataSourceParameter_STRING DataSourceParameter_Type = 1
	// Integer parameter (64-bits).
	// Will be serialized to json as string.
	DataSourceParameter_INTEGER DataSourceParameter_Type = 2
	// Double precision floating point parameter.
	DataSourceParameter_DOUBLE DataSourceParameter_Type = 3
	// Boolean parameter.
	DataSourceParameter_BOOLEAN DataSourceParameter_Type = 4
	// Record parameter.
	DataSourceParameter_RECORD DataSourceParameter_Type = 5
	// Page ID for a Google+ Page.
	DataSourceParameter_PLUS_PAGE DataSourceParameter_Type = 6
)

var DataSourceParameter_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "STRING",
	2: "INTEGER",
	3: "DOUBLE",
	4: "BOOLEAN",
	5: "RECORD",
	6: "PLUS_PAGE",
}

var DataSourceParameter_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"STRING":           1,
	"INTEGER":          2,
	"DOUBLE":           3,
	"BOOLEAN":          4,
	"RECORD":           5,
	"PLUS_PAGE":        6,
}

func (x DataSourceParameter_Type) String() string {
	return proto.EnumName(DataSourceParameter_Type_name, int32(x))
}

func (DataSourceParameter_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{0, 0}
}

// The type of authorization needed for this data source.
type DataSource_AuthorizationType int32

const (
	// Type unspecified.
	DataSource_AUTHORIZATION_TYPE_UNSPECIFIED DataSource_AuthorizationType = 0
	// Use OAuth 2 authorization codes that can be exchanged
	// for a refresh token on the backend.
	DataSource_AUTHORIZATION_CODE DataSource_AuthorizationType = 1
	// Return an authorization code for a given Google+ page that can then be
	// exchanged for a refresh token on the backend.
	DataSource_GOOGLE_PLUS_AUTHORIZATION_CODE DataSource_AuthorizationType = 2
)

var DataSource_AuthorizationType_name = map[int32]string{
	0: "AUTHORIZATION_TYPE_UNSPECIFIED",
	1: "AUTHORIZATION_CODE",
	2: "GOOGLE_PLUS_AUTHORIZATION_CODE",
}

var DataSource_AuthorizationType_value = map[string]int32{
	"AUTHORIZATION_TYPE_UNSPECIFIED": 0,
	"AUTHORIZATION_CODE":             1,
	"GOOGLE_PLUS_AUTHORIZATION_CODE": 2,
}

func (x DataSource_AuthorizationType) String() string {
	return proto.EnumName(DataSource_AuthorizationType_name, int32(x))
}

func (DataSource_AuthorizationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{1, 0}
}

// Represents how the data source supports data auto refresh.
type DataSource_DataRefreshType int32

const (
	// The data source won't support data auto refresh, which is default value.
	DataSource_DATA_REFRESH_TYPE_UNSPECIFIED DataSource_DataRefreshType = 0
	// The data source supports data auto refresh, and runs will be scheduled
	// for the past few days. Does not allow custom values to be set for each
	// transfer config.
	DataSource_SLIDING_WINDOW DataSource_DataRefreshType = 1
	// The data source supports data auto refresh, and runs will be scheduled
	// for the past few days. Allows custom values to be set for each transfer
	// config.
	DataSource_CUSTOM_SLIDING_WINDOW DataSource_DataRefreshType = 2
)

var DataSource_DataRefreshType_name = map[int32]string{
	0: "DATA_REFRESH_TYPE_UNSPECIFIED",
	1: "SLIDING_WINDOW",
	2: "CUSTOM_SLIDING_WINDOW",
}

var DataSource_DataRefreshType_value = map[string]int32{
	"DATA_REFRESH_TYPE_UNSPECIFIED": 0,
	"SLIDING_WINDOW":                1,
	"CUSTOM_SLIDING_WINDOW":         2,
}

func (x DataSource_DataRefreshType) String() string {
	return proto.EnumName(DataSource_DataRefreshType_name, int32(x))
}

func (DataSource_DataRefreshType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{1, 1}
}

// Represents which runs should be pulled.
type ListTransferRunsRequest_RunAttempt int32

const (
	// All runs should be returned.
	ListTransferRunsRequest_RUN_ATTEMPT_UNSPECIFIED ListTransferRunsRequest_RunAttempt = 0
	// Only latest run per day should be returned.
	ListTransferRunsRequest_LATEST ListTransferRunsRequest_RunAttempt = 1
)

var ListTransferRunsRequest_RunAttempt_name = map[int32]string{
	0: "RUN_ATTEMPT_UNSPECIFIED",
	1: "LATEST",
}

var ListTransferRunsRequest_RunAttempt_value = map[string]int32{
	"RUN_ATTEMPT_UNSPECIFIED": 0,
	"LATEST":                  1,
}

func (x ListTransferRunsRequest_RunAttempt) String() string {
	return proto.EnumName(ListTransferRunsRequest_RunAttempt_name, int32(x))
}

func (ListTransferRunsRequest_RunAttempt) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{13, 0}
}

// Represents a data source parameter with validation rules, so that
// parameters can be rendered in the UI. These parameters are given to us by
// supported data sources, and include all needed information for rendering
// and validation.
// Thus, whoever uses this api can decide to generate either generic ui,
// or custom data source specific forms.
type DataSourceParameter struct {
	// Parameter identifier.
	ParamId string `protobuf:"bytes,1,opt,name=param_id,json=paramId,proto3" json:"param_id,omitempty"`
	// Parameter display name in the user interface.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Parameter description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Parameter type.
	Type DataSourceParameter_Type `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.bigquery.datatransfer.v1.DataSourceParameter_Type" json:"type,omitempty"`
	// Is parameter required.
	Required bool `protobuf:"varint,5,opt,name=required,proto3" json:"required,omitempty"`
	// Can parameter have multiple values.
	Repeated bool `protobuf:"varint,6,opt,name=repeated,proto3" json:"repeated,omitempty"`
	// Regular expression which can be used for parameter validation.
	ValidationRegex string `protobuf:"bytes,7,opt,name=validation_regex,json=validationRegex,proto3" json:"validation_regex,omitempty"`
	// All possible values for the parameter.
	AllowedValues []string `protobuf:"bytes,8,rep,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
	// For integer and double values specifies minimum allowed value.
	MinValue *wrappers.DoubleValue `protobuf:"bytes,9,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// For integer and double values specifies maxminum allowed value.
	MaxValue *wrappers.DoubleValue `protobuf:"bytes,10,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// When parameter is a record, describes child fields.
	Fields []*DataSourceParameter `protobuf:"bytes,11,rep,name=fields,proto3" json:"fields,omitempty"`
	// Description of the requirements for this field, in case the user input does
	// not fulfill the regex pattern or min/max values.
	ValidationDescription string `protobuf:"bytes,12,opt,name=validation_description,json=validationDescription,proto3" json:"validation_description,omitempty"`
	// URL to a help document to further explain the naming requirements.
	ValidationHelpUrl string `protobuf:"bytes,13,opt,name=validation_help_url,json=validationHelpUrl,proto3" json:"validation_help_url,omitempty"`
	// Cannot be changed after initial creation.
	Immutable bool `protobuf:"varint,14,opt,name=immutable,proto3" json:"immutable,omitempty"`
	// If set to true, schema should be taken from the parent with the same
	// parameter_id. Only applicable when parameter type is RECORD.
	Recurse              bool     `protobuf:"varint,15,opt,name=recurse,proto3" json:"recurse,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataSourceParameter) Reset()         { *m = DataSourceParameter{} }
func (m *DataSourceParameter) String() string { return proto.CompactTextString(m) }
func (*DataSourceParameter) ProtoMessage()    {}
func (*DataSourceParameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{0}
}

func (m *DataSourceParameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataSourceParameter.Unmarshal(m, b)
}
func (m *DataSourceParameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataSourceParameter.Marshal(b, m, deterministic)
}
func (m *DataSourceParameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataSourceParameter.Merge(m, src)
}
func (m *DataSourceParameter) XXX_Size() int {
	return xxx_messageInfo_DataSourceParameter.Size(m)
}
func (m *DataSourceParameter) XXX_DiscardUnknown() {
	xxx_messageInfo_DataSourceParameter.DiscardUnknown(m)
}

var xxx_messageInfo_DataSourceParameter proto.InternalMessageInfo

func (m *DataSourceParameter) GetParamId() string {
	if m != nil {
		return m.ParamId
	}
	return ""
}

func (m *DataSourceParameter) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *DataSourceParameter) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DataSourceParameter) GetType() DataSourceParameter_Type {
	if m != nil {
		return m.Type
	}
	return DataSourceParameter_TYPE_UNSPECIFIED
}

func (m *DataSourceParameter) GetRequired() bool {
	if m != nil {
		return m.Required
	}
	return false
}

func (m *DataSourceParameter) GetRepeated() bool {
	if m != nil {
		return m.Repeated
	}
	return false
}

func (m *DataSourceParameter) GetValidationRegex() string {
	if m != nil {
		return m.ValidationRegex
	}
	return ""
}

func (m *DataSourceParameter) GetAllowedValues() []string {
	if m != nil {
		return m.AllowedValues
	}
	return nil
}

func (m *DataSourceParameter) GetMinValue() *wrappers.DoubleValue {
	if m != nil {
		return m.MinValue
	}
	return nil
}

func (m *DataSourceParameter) GetMaxValue() *wrappers.DoubleValue {
	if m != nil {
		return m.MaxValue
	}
	return nil
}

func (m *DataSourceParameter) GetFields() []*DataSourceParameter {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *DataSourceParameter) GetValidationDescription() string {
	if m != nil {
		return m.ValidationDescription
	}
	return ""
}

func (m *DataSourceParameter) GetValidationHelpUrl() string {
	if m != nil {
		return m.ValidationHelpUrl
	}
	return ""
}

func (m *DataSourceParameter) GetImmutable() bool {
	if m != nil {
		return m.Immutable
	}
	return false
}

func (m *DataSourceParameter) GetRecurse() bool {
	if m != nil {
		return m.Recurse
	}
	return false
}

// Represents data source metadata. Metadata is sufficient to
// render UI and request proper OAuth tokens.
type DataSource struct {
	// Output only. Data source resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Data source id.
	DataSourceId string `protobuf:"bytes,2,opt,name=data_source_id,json=dataSourceId,proto3" json:"data_source_id,omitempty"`
	// User friendly data source name.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// User friendly data source description string.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Data source client id which should be used to receive refresh token.
	// When not supplied, no offline credentials are populated for data transfer.
	ClientId string `protobuf:"bytes,5,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Api auth scopes for which refresh token needs to be obtained. Only valid
	// when `client_id` is specified. Ignored otherwise. These are scopes needed
	// by a data source to prepare data and ingest them into BigQuery,
	// e.g., https://www.googleapis.com/auth/bigquery
	Scopes []string `protobuf:"bytes,6,rep,name=scopes,proto3" json:"scopes,omitempty"`
	// Deprecated. This field has no effect.
	TransferType TransferType `protobuf:"varint,7,opt,name=transfer_type,json=transferType,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferType" json:"transfer_type,omitempty"`
	// Indicates whether the data source supports multiple transfers
	// to different BigQuery targets.
	SupportsMultipleTransfers bool `protobuf:"varint,8,opt,name=supports_multiple_transfers,json=supportsMultipleTransfers,proto3" json:"supports_multiple_transfers,omitempty"`
	// The number of seconds to wait for an update from the data source
	// before BigQuery marks the transfer as failed.
	UpdateDeadlineSeconds int32 `protobuf:"varint,9,opt,name=update_deadline_seconds,json=updateDeadlineSeconds,proto3" json:"update_deadline_seconds,omitempty"`
	// Default data transfer schedule.
	// Examples of valid schedules include:
	// `1st,3rd monday of month 15:30`,
	// `every wed,fri of jan,jun 13:15`, and
	// `first sunday of quarter 00:00`.
	DefaultSchedule string `protobuf:"bytes,10,opt,name=default_schedule,json=defaultSchedule,proto3" json:"default_schedule,omitempty"`
	// Specifies whether the data source supports a user defined schedule, or
	// operates on the default schedule.
	// When set to `true`, user can override default schedule.
	SupportsCustomSchedule bool `protobuf:"varint,11,opt,name=supports_custom_schedule,json=supportsCustomSchedule,proto3" json:"supports_custom_schedule,omitempty"`
	// Data source parameters.
	Parameters []*DataSourceParameter `protobuf:"bytes,12,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Url for the help document for this data source.
	HelpUrl string `protobuf:"bytes,13,opt,name=help_url,json=helpUrl,proto3" json:"help_url,omitempty"`
	// Indicates the type of authorization.
	AuthorizationType DataSource_AuthorizationType `protobuf:"varint,14,opt,name=authorization_type,json=authorizationType,proto3,enum=google.cloud.bigquery.datatransfer.v1.DataSource_AuthorizationType" json:"authorization_type,omitempty"`
	// Specifies whether the data source supports automatic data refresh for the
	// past few days, and how it's supported.
	// For some data sources, data might not be complete until a few days later,
	// so it's useful to refresh data automatically.
	DataRefreshType DataSource_DataRefreshType `protobuf:"varint,15,opt,name=data_refresh_type,json=dataRefreshType,proto3,enum=google.cloud.bigquery.datatransfer.v1.DataSource_DataRefreshType" json:"data_refresh_type,omitempty"`
	// Default data refresh window on days.
	// Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
	DefaultDataRefreshWindowDays int32 `protobuf:"varint,16,opt,name=default_data_refresh_window_days,json=defaultDataRefreshWindowDays,proto3" json:"default_data_refresh_window_days,omitempty"`
	// Disables backfilling and manual run scheduling
	// for the data source.
	ManualRunsDisabled bool `protobuf:"varint,17,opt,name=manual_runs_disabled,json=manualRunsDisabled,proto3" json:"manual_runs_disabled,omitempty"`
	// The minimum interval for scheduler to schedule runs.
	MinimumScheduleInterval *duration.Duration `protobuf:"bytes,18,opt,name=minimum_schedule_interval,json=minimumScheduleInterval,proto3" json:"minimum_schedule_interval,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}           `json:"-"`
	XXX_unrecognized        []byte             `json:"-"`
	XXX_sizecache           int32              `json:"-"`
}

func (m *DataSource) Reset()         { *m = DataSource{} }
func (m *DataSource) String() string { return proto.CompactTextString(m) }
func (*DataSource) ProtoMessage()    {}
func (*DataSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{1}
}

func (m *DataSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataSource.Unmarshal(m, b)
}
func (m *DataSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataSource.Marshal(b, m, deterministic)
}
func (m *DataSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataSource.Merge(m, src)
}
func (m *DataSource) XXX_Size() int {
	return xxx_messageInfo_DataSource.Size(m)
}
func (m *DataSource) XXX_DiscardUnknown() {
	xxx_messageInfo_DataSource.DiscardUnknown(m)
}

var xxx_messageInfo_DataSource proto.InternalMessageInfo

func (m *DataSource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DataSource) GetDataSourceId() string {
	if m != nil {
		return m.DataSourceId
	}
	return ""
}

func (m *DataSource) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *DataSource) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DataSource) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *DataSource) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *DataSource) GetTransferType() TransferType {
	if m != nil {
		return m.TransferType
	}
	return TransferType_TRANSFER_TYPE_UNSPECIFIED
}

func (m *DataSource) GetSupportsMultipleTransfers() bool {
	if m != nil {
		return m.SupportsMultipleTransfers
	}
	return false
}

func (m *DataSource) GetUpdateDeadlineSeconds() int32 {
	if m != nil {
		return m.UpdateDeadlineSeconds
	}
	return 0
}

func (m *DataSource) GetDefaultSchedule() string {
	if m != nil {
		return m.DefaultSchedule
	}
	return ""
}

func (m *DataSource) GetSupportsCustomSchedule() bool {
	if m != nil {
		return m.SupportsCustomSchedule
	}
	return false
}

func (m *DataSource) GetParameters() []*DataSourceParameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *DataSource) GetHelpUrl() string {
	if m != nil {
		return m.HelpUrl
	}
	return ""
}

func (m *DataSource) GetAuthorizationType() DataSource_AuthorizationType {
	if m != nil {
		return m.AuthorizationType
	}
	return DataSource_AUTHORIZATION_TYPE_UNSPECIFIED
}

func (m *DataSource) GetDataRefreshType() DataSource_DataRefreshType {
	if m != nil {
		return m.DataRefreshType
	}
	return DataSource_DATA_REFRESH_TYPE_UNSPECIFIED
}

func (m *DataSource) GetDefaultDataRefreshWindowDays() int32 {
	if m != nil {
		return m.DefaultDataRefreshWindowDays
	}
	return 0
}

func (m *DataSource) GetManualRunsDisabled() bool {
	if m != nil {
		return m.ManualRunsDisabled
	}
	return false
}

func (m *DataSource) GetMinimumScheduleInterval() *duration.Duration {
	if m != nil {
		return m.MinimumScheduleInterval
	}
	return nil
}

// A request to get data source info.
type GetDataSourceRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/dataSources/{data_source_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDataSourceRequest) Reset()         { *m = GetDataSourceRequest{} }
func (m *GetDataSourceRequest) String() string { return proto.CompactTextString(m) }
func (*GetDataSourceRequest) ProtoMessage()    {}
func (*GetDataSourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{2}
}

func (m *GetDataSourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDataSourceRequest.Unmarshal(m, b)
}
func (m *GetDataSourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDataSourceRequest.Marshal(b, m, deterministic)
}
func (m *GetDataSourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDataSourceRequest.Merge(m, src)
}
func (m *GetDataSourceRequest) XXX_Size() int {
	return xxx_messageInfo_GetDataSourceRequest.Size(m)
}
func (m *GetDataSourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDataSourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDataSourceRequest proto.InternalMessageInfo

func (m *GetDataSourceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list supported data sources and their data transfer settings.
type ListDataSourcesRequest struct {
	// The BigQuery project id for which data sources should be returned.
	// Must be in the form: `projects/{project_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListDataSourcesRequest` list results. For multiple-page
	// results, `ListDataSourcesResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize             int32    `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDataSourcesRequest) Reset()         { *m = ListDataSourcesRequest{} }
func (m *ListDataSourcesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDataSourcesRequest) ProtoMessage()    {}
func (*ListDataSourcesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{3}
}

func (m *ListDataSourcesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDataSourcesRequest.Unmarshal(m, b)
}
func (m *ListDataSourcesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDataSourcesRequest.Marshal(b, m, deterministic)
}
func (m *ListDataSourcesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDataSourcesRequest.Merge(m, src)
}
func (m *ListDataSourcesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDataSourcesRequest.Size(m)
}
func (m *ListDataSourcesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDataSourcesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDataSourcesRequest proto.InternalMessageInfo

func (m *ListDataSourcesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDataSourcesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListDataSourcesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Returns list of supported data sources and their metadata.
type ListDataSourcesResponse struct {
	// List of supported data sources and their transfer settings.
	DataSources []*DataSource `protobuf:"bytes,1,rep,name=data_sources,json=dataSources,proto3" json:"data_sources,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListDataSourcesRequest.page_token`
	// to request the next page of list results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDataSourcesResponse) Reset()         { *m = ListDataSourcesResponse{} }
func (m *ListDataSourcesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDataSourcesResponse) ProtoMessage()    {}
func (*ListDataSourcesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{4}
}

func (m *ListDataSourcesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDataSourcesResponse.Unmarshal(m, b)
}
func (m *ListDataSourcesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDataSourcesResponse.Marshal(b, m, deterministic)
}
func (m *ListDataSourcesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDataSourcesResponse.Merge(m, src)
}
func (m *ListDataSourcesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDataSourcesResponse.Size(m)
}
func (m *ListDataSourcesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDataSourcesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDataSourcesResponse proto.InternalMessageInfo

func (m *ListDataSourcesResponse) GetDataSources() []*DataSource {
	if m != nil {
		return m.DataSources
	}
	return nil
}

func (m *ListDataSourcesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to create a data transfer configuration. If new credentials are
// needed for this transfer configuration, an authorization code must be
// provided. If an authorization code is provided, the transfer configuration
// will be associated with the user id corresponding to the
// authorization code. Otherwise, the transfer configuration will be associated
// with the calling user.
type CreateTransferConfigRequest struct {
	// The BigQuery project id where the transfer configuration should be created.
	// Must be in the format /projects/{project_id}/locations/{location_id}
	// If specified location and location of the destination bigquery dataset
	// do not match - the request will fail.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Data transfer configuration to create.
	TransferConfig *TransferConfig `protobuf:"bytes,2,opt,name=transfer_config,json=transferConfig,proto3" json:"transfer_config,omitempty"`
	// Optional OAuth2 authorization code to use with this transfer configuration.
	// This is required if new credentials are needed, as indicated by
	// `CheckValidCreds`.
	// In order to obtain authorization_code, please make a
	// request to
	// https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?client_id=<datatransferapiclientid>&scope=<data_source_scopes>&redirect_uri=<redirect_uri>
	//
	// * client_id should be OAuth client_id of BigQuery DTS API for the given
	//   data source returned by ListDataSources method.
	// * data_source_scopes are the scopes returned by ListDataSources method.
	// * redirect_uri is an optional parameter. If not specified, then
	//   authorization code is posted to the opener of authorization flow window.
	//   Otherwise it will be sent to the redirect uri. A special value of
	//   urn:ietf:wg:oauth:2.0:oob means that authorization code should be
	//   returned in the title bar of the browser, with the page text prompting
	//   the user to copy the code and paste it in the application.
	AuthorizationCode    string   `protobuf:"bytes,3,opt,name=authorization_code,json=authorizationCode,proto3" json:"authorization_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTransferConfigRequest) Reset()         { *m = CreateTransferConfigRequest{} }
func (m *CreateTransferConfigRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTransferConfigRequest) ProtoMessage()    {}
func (*CreateTransferConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{5}
}

func (m *CreateTransferConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTransferConfigRequest.Unmarshal(m, b)
}
func (m *CreateTransferConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTransferConfigRequest.Marshal(b, m, deterministic)
}
func (m *CreateTransferConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTransferConfigRequest.Merge(m, src)
}
func (m *CreateTransferConfigRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTransferConfigRequest.Size(m)
}
func (m *CreateTransferConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTransferConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTransferConfigRequest proto.InternalMessageInfo

func (m *CreateTransferConfigRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTransferConfigRequest) GetTransferConfig() *TransferConfig {
	if m != nil {
		return m.TransferConfig
	}
	return nil
}

func (m *CreateTransferConfigRequest) GetAuthorizationCode() string {
	if m != nil {
		return m.AuthorizationCode
	}
	return ""
}

// A request to update a transfer configuration. To update the user id of the
// transfer configuration, an authorization code needs to be provided.
type UpdateTransferConfigRequest struct {
	// Data transfer configuration to create.
	TransferConfig *TransferConfig `protobuf:"bytes,1,opt,name=transfer_config,json=transferConfig,proto3" json:"transfer_config,omitempty"`
	// Optional OAuth2 authorization code to use with this transfer configuration.
	// If it is provided, the transfer configuration will be associated with the
	// authorizing user.
	// In order to obtain authorization_code, please make a
	// request to
	// https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?client_id=<datatransferapiclientid>&scope=<data_source_scopes>&redirect_uri=<redirect_uri>
	//
	// * client_id should be OAuth client_id of BigQuery DTS API for the given
	//   data source returned by ListDataSources method.
	// * data_source_scopes are the scopes returned by ListDataSources method.
	// * redirect_uri is an optional parameter. If not specified, then
	//   authorization code is posted to the opener of authorization flow window.
	//   Otherwise it will be sent to the redirect uri. A special value of
	//   urn:ietf:wg:oauth:2.0:oob means that authorization code should be
	//   returned in the title bar of the browser, with the page text prompting
	//   the user to copy the code and paste it in the application.
	AuthorizationCode string `protobuf:"bytes,3,opt,name=authorization_code,json=authorizationCode,proto3" json:"authorization_code,omitempty"`
	// Required list of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTransferConfigRequest) Reset()         { *m = UpdateTransferConfigRequest{} }
func (m *UpdateTransferConfigRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTransferConfigRequest) ProtoMessage()    {}
func (*UpdateTransferConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{6}
}

func (m *UpdateTransferConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTransferConfigRequest.Unmarshal(m, b)
}
func (m *UpdateTransferConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTransferConfigRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTransferConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTransferConfigRequest.Merge(m, src)
}
func (m *UpdateTransferConfigRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTransferConfigRequest.Size(m)
}
func (m *UpdateTransferConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTransferConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTransferConfigRequest proto.InternalMessageInfo

func (m *UpdateTransferConfigRequest) GetTransferConfig() *TransferConfig {
	if m != nil {
		return m.TransferConfig
	}
	return nil
}

func (m *UpdateTransferConfigRequest) GetAuthorizationCode() string {
	if m != nil {
		return m.AuthorizationCode
	}
	return ""
}

func (m *UpdateTransferConfigRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// A request to get data transfer information.
type GetTransferConfigRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTransferConfigRequest) Reset()         { *m = GetTransferConfigRequest{} }
func (m *GetTransferConfigRequest) String() string { return proto.CompactTextString(m) }
func (*GetTransferConfigRequest) ProtoMessage()    {}
func (*GetTransferConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{7}
}

func (m *GetTransferConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTransferConfigRequest.Unmarshal(m, b)
}
func (m *GetTransferConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTransferConfigRequest.Marshal(b, m, deterministic)
}
func (m *GetTransferConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTransferConfigRequest.Merge(m, src)
}
func (m *GetTransferConfigRequest) XXX_Size() int {
	return xxx_messageInfo_GetTransferConfigRequest.Size(m)
}
func (m *GetTransferConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTransferConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTransferConfigRequest proto.InternalMessageInfo

func (m *GetTransferConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to delete data transfer information. All associated transfer runs
// and log messages will be deleted as well.
type DeleteTransferConfigRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTransferConfigRequest) Reset()         { *m = DeleteTransferConfigRequest{} }
func (m *DeleteTransferConfigRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTransferConfigRequest) ProtoMessage()    {}
func (*DeleteTransferConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{8}
}

func (m *DeleteTransferConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTransferConfigRequest.Unmarshal(m, b)
}
func (m *DeleteTransferConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTransferConfigRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTransferConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTransferConfigRequest.Merge(m, src)
}
func (m *DeleteTransferConfigRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTransferConfigRequest.Size(m)
}
func (m *DeleteTransferConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTransferConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTransferConfigRequest proto.InternalMessageInfo

func (m *DeleteTransferConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to get data transfer run information.
type GetTransferRunRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTransferRunRequest) Reset()         { *m = GetTransferRunRequest{} }
func (m *GetTransferRunRequest) String() string { return proto.CompactTextString(m) }
func (*GetTransferRunRequest) ProtoMessage()    {}
func (*GetTransferRunRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{9}
}

func (m *GetTransferRunRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTransferRunRequest.Unmarshal(m, b)
}
func (m *GetTransferRunRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTransferRunRequest.Marshal(b, m, deterministic)
}
func (m *GetTransferRunRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTransferRunRequest.Merge(m, src)
}
func (m *GetTransferRunRequest) XXX_Size() int {
	return xxx_messageInfo_GetTransferRunRequest.Size(m)
}
func (m *GetTransferRunRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTransferRunRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTransferRunRequest proto.InternalMessageInfo

func (m *GetTransferRunRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to delete data transfer run information.
type DeleteTransferRunRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTransferRunRequest) Reset()         { *m = DeleteTransferRunRequest{} }
func (m *DeleteTransferRunRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTransferRunRequest) ProtoMessage()    {}
func (*DeleteTransferRunRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{10}
}

func (m *DeleteTransferRunRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTransferRunRequest.Unmarshal(m, b)
}
func (m *DeleteTransferRunRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTransferRunRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTransferRunRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTransferRunRequest.Merge(m, src)
}
func (m *DeleteTransferRunRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTransferRunRequest.Size(m)
}
func (m *DeleteTransferRunRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTransferRunRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTransferRunRequest proto.InternalMessageInfo

func (m *DeleteTransferRunRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to list data transfers configured for a BigQuery project.
type ListTransferConfigsRequest struct {
	// The BigQuery project id for which data sources
	// should be returned: `projects/{project_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// When specified, only configurations of requested data sources are returned.
	DataSourceIds []string `protobuf:"bytes,2,rep,name=data_source_ids,json=dataSourceIds,proto3" json:"data_source_ids,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransfersRequest` list results. For multiple-page
	// results, `ListTransfersResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize             int32    `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTransferConfigsRequest) Reset()         { *m = ListTransferConfigsRequest{} }
func (m *ListTransferConfigsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTransferConfigsRequest) ProtoMessage()    {}
func (*ListTransferConfigsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{11}
}

func (m *ListTransferConfigsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferConfigsRequest.Unmarshal(m, b)
}
func (m *ListTransferConfigsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferConfigsRequest.Marshal(b, m, deterministic)
}
func (m *ListTransferConfigsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferConfigsRequest.Merge(m, src)
}
func (m *ListTransferConfigsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTransferConfigsRequest.Size(m)
}
func (m *ListTransferConfigsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferConfigsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferConfigsRequest proto.InternalMessageInfo

func (m *ListTransferConfigsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTransferConfigsRequest) GetDataSourceIds() []string {
	if m != nil {
		return m.DataSourceIds
	}
	return nil
}

func (m *ListTransferConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTransferConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The returned list of pipelines in the project.
type ListTransferConfigsResponse struct {
	// Output only. The stored pipeline transfer configurations.
	TransferConfigs []*TransferConfig `protobuf:"bytes,1,rep,name=transfer_configs,json=transferConfigs,proto3" json:"transfer_configs,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListTransferConfigsRequest.page_token`
	// to request the next page of list results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTransferConfigsResponse) Reset()         { *m = ListTransferConfigsResponse{} }
func (m *ListTransferConfigsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTransferConfigsResponse) ProtoMessage()    {}
func (*ListTransferConfigsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{12}
}

func (m *ListTransferConfigsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferConfigsResponse.Unmarshal(m, b)
}
func (m *ListTransferConfigsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferConfigsResponse.Marshal(b, m, deterministic)
}
func (m *ListTransferConfigsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferConfigsResponse.Merge(m, src)
}
func (m *ListTransferConfigsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTransferConfigsResponse.Size(m)
}
func (m *ListTransferConfigsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferConfigsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferConfigsResponse proto.InternalMessageInfo

func (m *ListTransferConfigsResponse) GetTransferConfigs() []*TransferConfig {
	if m != nil {
		return m.TransferConfigs
	}
	return nil
}

func (m *ListTransferConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to list data transfer runs. UI can use this method to show/filter
// specific data transfer runs. The data source can use this method to request
// all scheduled transfer runs.
type ListTransferRunsRequest struct {
	// Name of transfer configuration for which transfer runs should be retrieved.
	// Format of transfer configuration resource name is:
	// `projects/{project_id}/transferConfigs/{config_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// When specified, only transfer runs with requested states are returned.
	States []TransferState `protobuf:"varint,2,rep,packed,name=states,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferState" json:"states,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransferRunsRequest` list results. For multiple-page
	// results, `ListTransferRunsResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Indicates how run attempts are to be pulled.
	RunAttempt           ListTransferRunsRequest_RunAttempt `protobuf:"varint,5,opt,name=run_attempt,json=runAttempt,proto3,enum=google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest_RunAttempt" json:"run_attempt,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ListTransferRunsRequest) Reset()         { *m = ListTransferRunsRequest{} }
func (m *ListTransferRunsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTransferRunsRequest) ProtoMessage()    {}
func (*ListTransferRunsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{13}
}

func (m *ListTransferRunsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferRunsRequest.Unmarshal(m, b)
}
func (m *ListTransferRunsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferRunsRequest.Marshal(b, m, deterministic)
}
func (m *ListTransferRunsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferRunsRequest.Merge(m, src)
}
func (m *ListTransferRunsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTransferRunsRequest.Size(m)
}
func (m *ListTransferRunsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferRunsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferRunsRequest proto.InternalMessageInfo

func (m *ListTransferRunsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTransferRunsRequest) GetStates() []TransferState {
	if m != nil {
		return m.States
	}
	return nil
}

func (m *ListTransferRunsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTransferRunsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTransferRunsRequest) GetRunAttempt() ListTransferRunsRequest_RunAttempt {
	if m != nil {
		return m.RunAttempt
	}
	return ListTransferRunsRequest_RUN_ATTEMPT_UNSPECIFIED
}

// The returned list of pipelines in the project.
type ListTransferRunsResponse struct {
	// Output only. The stored pipeline transfer runs.
	TransferRuns []*TransferRun `protobuf:"bytes,1,rep,name=transfer_runs,json=transferRuns,proto3" json:"transfer_runs,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListTransferRunsRequest.page_token`
	// to request the next page of list results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTransferRunsResponse) Reset()         { *m = ListTransferRunsResponse{} }
func (m *ListTransferRunsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTransferRunsResponse) ProtoMessage()    {}
func (*ListTransferRunsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{14}
}

func (m *ListTransferRunsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferRunsResponse.Unmarshal(m, b)
}
func (m *ListTransferRunsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferRunsResponse.Marshal(b, m, deterministic)
}
func (m *ListTransferRunsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferRunsResponse.Merge(m, src)
}
func (m *ListTransferRunsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTransferRunsResponse.Size(m)
}
func (m *ListTransferRunsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferRunsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferRunsResponse proto.InternalMessageInfo

func (m *ListTransferRunsResponse) GetTransferRuns() []*TransferRun {
	if m != nil {
		return m.TransferRuns
	}
	return nil
}

func (m *ListTransferRunsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to get user facing log messages associated with data transfer run.
type ListTransferLogsRequest struct {
	// Transfer run name in the form:
	// `projects/{project_id}/transferConfigs/{config_Id}/runs/{run_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransferLogsRequest` list results. For multiple-page
	// results, `ListTransferLogsResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Message types to return. If not populated - INFO, WARNING and ERROR
	// messages are returned.
	MessageTypes         []TransferMessage_MessageSeverity `protobuf:"varint,6,rep,packed,name=message_types,json=messageTypes,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferMessage_MessageSeverity" json:"message_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ListTransferLogsRequest) Reset()         { *m = ListTransferLogsRequest{} }
func (m *ListTransferLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTransferLogsRequest) ProtoMessage()    {}
func (*ListTransferLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{15}
}

func (m *ListTransferLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferLogsRequest.Unmarshal(m, b)
}
func (m *ListTransferLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferLogsRequest.Marshal(b, m, deterministic)
}
func (m *ListTransferLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferLogsRequest.Merge(m, src)
}
func (m *ListTransferLogsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTransferLogsRequest.Size(m)
}
func (m *ListTransferLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferLogsRequest proto.InternalMessageInfo

func (m *ListTransferLogsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTransferLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTransferLogsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTransferLogsRequest) GetMessageTypes() []TransferMessage_MessageSeverity {
	if m != nil {
		return m.MessageTypes
	}
	return nil
}

// The returned list transfer run messages.
type ListTransferLogsResponse struct {
	// Output only. The stored pipeline transfer messages.
	TransferMessages []*TransferMessage `protobuf:"bytes,1,rep,name=transfer_messages,json=transferMessages,proto3" json:"transfer_messages,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `GetTransferRunLogRequest.page_token`
	// to request the next page of list results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTransferLogsResponse) Reset()         { *m = ListTransferLogsResponse{} }
func (m *ListTransferLogsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTransferLogsResponse) ProtoMessage()    {}
func (*ListTransferLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{16}
}

func (m *ListTransferLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferLogsResponse.Unmarshal(m, b)
}
func (m *ListTransferLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferLogsResponse.Marshal(b, m, deterministic)
}
func (m *ListTransferLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferLogsResponse.Merge(m, src)
}
func (m *ListTransferLogsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTransferLogsResponse.Size(m)
}
func (m *ListTransferLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferLogsResponse proto.InternalMessageInfo

func (m *ListTransferLogsResponse) GetTransferMessages() []*TransferMessage {
	if m != nil {
		return m.TransferMessages
	}
	return nil
}

func (m *ListTransferLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to determine whether the user has valid credentials. This method
// is used to limit the number of OAuth popups in the user interface. The
// user id is inferred from the API call context.
// If the data source has the Google+ authorization type, this method
// returns false, as it cannot be determined whether the credentials are
// already valid merely based on the user id.
type CheckValidCredsRequest struct {
	// The data source in the form:
	// `projects/{project_id}/dataSources/{data_source_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckValidCredsRequest) Reset()         { *m = CheckValidCredsRequest{} }
func (m *CheckValidCredsRequest) String() string { return proto.CompactTextString(m) }
func (*CheckValidCredsRequest) ProtoMessage()    {}
func (*CheckValidCredsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{17}
}

func (m *CheckValidCredsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckValidCredsRequest.Unmarshal(m, b)
}
func (m *CheckValidCredsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckValidCredsRequest.Marshal(b, m, deterministic)
}
func (m *CheckValidCredsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckValidCredsRequest.Merge(m, src)
}
func (m *CheckValidCredsRequest) XXX_Size() int {
	return xxx_messageInfo_CheckValidCredsRequest.Size(m)
}
func (m *CheckValidCredsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckValidCredsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckValidCredsRequest proto.InternalMessageInfo

func (m *CheckValidCredsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A response indicating whether the credentials exist and are valid.
type CheckValidCredsResponse struct {
	// If set to `true`, the credentials exist and are valid.
	HasValidCreds        bool     `protobuf:"varint,1,opt,name=has_valid_creds,json=hasValidCreds,proto3" json:"has_valid_creds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckValidCredsResponse) Reset()         { *m = CheckValidCredsResponse{} }
func (m *CheckValidCredsResponse) String() string { return proto.CompactTextString(m) }
func (*CheckValidCredsResponse) ProtoMessage()    {}
func (*CheckValidCredsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{18}
}

func (m *CheckValidCredsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckValidCredsResponse.Unmarshal(m, b)
}
func (m *CheckValidCredsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckValidCredsResponse.Marshal(b, m, deterministic)
}
func (m *CheckValidCredsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckValidCredsResponse.Merge(m, src)
}
func (m *CheckValidCredsResponse) XXX_Size() int {
	return xxx_messageInfo_CheckValidCredsResponse.Size(m)
}
func (m *CheckValidCredsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckValidCredsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckValidCredsResponse proto.InternalMessageInfo

func (m *CheckValidCredsResponse) GetHasValidCreds() bool {
	if m != nil {
		return m.HasValidCreds
	}
	return false
}

// A request to schedule transfer runs for a time range.
type ScheduleTransferRunsRequest struct {
	// Transfer configuration name in the form:
	// `projects/{project_id}/transferConfigs/{config_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Start time of the range of transfer runs. For example,
	// `"2017-05-25T00:00:00+00:00"`.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the range of transfer runs. For example,
	// `"2017-05-30T00:00:00+00:00"`.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ScheduleTransferRunsRequest) Reset()         { *m = ScheduleTransferRunsRequest{} }
func (m *ScheduleTransferRunsRequest) String() string { return proto.CompactTextString(m) }
func (*ScheduleTransferRunsRequest) ProtoMessage()    {}
func (*ScheduleTransferRunsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{19}
}

func (m *ScheduleTransferRunsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScheduleTransferRunsRequest.Unmarshal(m, b)
}
func (m *ScheduleTransferRunsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScheduleTransferRunsRequest.Marshal(b, m, deterministic)
}
func (m *ScheduleTransferRunsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScheduleTransferRunsRequest.Merge(m, src)
}
func (m *ScheduleTransferRunsRequest) XXX_Size() int {
	return xxx_messageInfo_ScheduleTransferRunsRequest.Size(m)
}
func (m *ScheduleTransferRunsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ScheduleTransferRunsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ScheduleTransferRunsRequest proto.InternalMessageInfo

func (m *ScheduleTransferRunsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ScheduleTransferRunsRequest) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ScheduleTransferRunsRequest) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// A response to schedule transfer runs for a time range.
type ScheduleTransferRunsResponse struct {
	// The transfer runs that were scheduled.
	Runs                 []*TransferRun `protobuf:"bytes,1,rep,name=runs,proto3" json:"runs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ScheduleTransferRunsResponse) Reset()         { *m = ScheduleTransferRunsResponse{} }
func (m *ScheduleTransferRunsResponse) String() string { return proto.CompactTextString(m) }
func (*ScheduleTransferRunsResponse) ProtoMessage()    {}
func (*ScheduleTransferRunsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{20}
}

func (m *ScheduleTransferRunsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScheduleTransferRunsResponse.Unmarshal(m, b)
}
func (m *ScheduleTransferRunsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScheduleTransferRunsResponse.Marshal(b, m, deterministic)
}
func (m *ScheduleTransferRunsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScheduleTransferRunsResponse.Merge(m, src)
}
func (m *ScheduleTransferRunsResponse) XXX_Size() int {
	return xxx_messageInfo_ScheduleTransferRunsResponse.Size(m)
}
func (m *ScheduleTransferRunsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ScheduleTransferRunsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ScheduleTransferRunsResponse proto.InternalMessageInfo

func (m *ScheduleTransferRunsResponse) GetRuns() []*TransferRun {
	if m != nil {
		return m.Runs
	}
	return nil
}

func init() {
	proto.RegisterType((*DataSourceParameter)(nil), "google.cloud.bigquery.datatransfer.v1.DataSourceParameter")
	proto.RegisterType((*DataSource)(nil), "google.cloud.bigquery.datatransfer.v1.DataSource")
	proto.RegisterType((*GetDataSourceRequest)(nil), "google.cloud.bigquery.datatransfer.v1.GetDataSourceRequest")
	proto.RegisterType((*ListDataSourcesRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListDataSourcesRequest")
	proto.RegisterType((*ListDataSourcesResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse")
	proto.RegisterType((*CreateTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest")
	proto.RegisterType((*UpdateTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest")
	proto.RegisterType((*GetTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.GetTransferConfigRequest")
	proto.RegisterType((*DeleteTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.DeleteTransferConfigRequest")
	proto.RegisterType((*GetTransferRunRequest)(nil), "google.cloud.bigquery.datatransfer.v1.GetTransferRunRequest")
	proto.RegisterType((*DeleteTransferRunRequest)(nil), "google.cloud.bigquery.datatransfer.v1.DeleteTransferRunRequest")
	proto.RegisterType((*ListTransferConfigsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferConfigsRequest")
	proto.RegisterType((*ListTransferConfigsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse")
	proto.RegisterType((*ListTransferRunsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest")
	proto.RegisterType((*ListTransferRunsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse")
	proto.RegisterType((*ListTransferLogsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest")
	proto.RegisterType((*ListTransferLogsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse")
	proto.RegisterType((*CheckValidCredsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.CheckValidCredsRequest")
	proto.RegisterType((*CheckValidCredsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.CheckValidCredsResponse")
	proto.RegisterType((*ScheduleTransferRunsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest")
	proto.RegisterType((*ScheduleTransferRunsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse")
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.DataSourceParameter_Type", DataSourceParameter_Type_name, DataSourceParameter_Type_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.DataSource_AuthorizationType", DataSource_AuthorizationType_name, DataSource_AuthorizationType_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.DataSource_DataRefreshType", DataSource_DataRefreshType_name, DataSource_DataRefreshType_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest_RunAttempt", ListTransferRunsRequest_RunAttempt_name, ListTransferRunsRequest_RunAttempt_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DataTransferServiceClient is the client API for DataTransferService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataTransferServiceClient interface {
	// Retrieves a supported data source and returns its settings,
	// which can be used for UI rendering.
	GetDataSource(ctx context.Context, in *GetDataSourceRequest, opts ...grpc.CallOption) (*DataSource, error)
	// Lists supported data sources and returns their settings,
	// which can be used for UI rendering.
	ListDataSources(ctx context.Context, in *ListDataSourcesRequest, opts ...grpc.CallOption) (*ListDataSourcesResponse, error)
	// Creates a new data transfer configuration.
	CreateTransferConfig(ctx context.Context, in *CreateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Updates a data transfer configuration.
	// All fields must be set, even if they are not updated.
	UpdateTransferConfig(ctx context.Context, in *UpdateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Deletes a data transfer configuration,
	// including any associated transfer runs and logs.
	DeleteTransferConfig(ctx context.Context, in *DeleteTransferConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns information about a data transfer config.
	GetTransferConfig(ctx context.Context, in *GetTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Returns information about all data transfers in the project.
	ListTransferConfigs(ctx context.Context, in *ListTransferConfigsRequest, opts ...grpc.CallOption) (*ListTransferConfigsResponse, error)
	// Creates transfer runs for a time range [start_time, end_time].
	// For each date - or whatever granularity the data source supports - in the
	// range, one transfer run is created.
	// Note that runs are created per UTC time in the time range.
	ScheduleTransferRuns(ctx context.Context, in *ScheduleTransferRunsRequest, opts ...grpc.CallOption) (*ScheduleTransferRunsResponse, error)
	// Returns information about the particular transfer run.
	GetTransferRun(ctx context.Context, in *GetTransferRunRequest, opts ...grpc.CallOption) (*TransferRun, error)
	// Deletes the specified transfer run.
	DeleteTransferRun(ctx context.Context, in *DeleteTransferRunRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns information about running and completed jobs.
	ListTransferRuns(ctx context.Context, in *ListTransferRunsRequest, opts ...grpc.CallOption) (*ListTransferRunsResponse, error)
	// Returns user facing log messages for the data transfer run.
	ListTransferLogs(ctx context.Context, in *ListTransferLogsRequest, opts ...grpc.CallOption) (*ListTransferLogsResponse, error)
	// Returns true if valid credentials exist for the given data source and
	// requesting user.
	// Some data sources doesn't support service account, so we need to talk to
	// them on behalf of the end user. This API just checks whether we have OAuth
	// token for the particular user, which is a pre-requisite before user can
	// create a transfer config.
	CheckValidCreds(ctx context.Context, in *CheckValidCredsRequest, opts ...grpc.CallOption) (*CheckValidCredsResponse, error)
}

type dataTransferServiceClient struct {
	cc *grpc.ClientConn
}

func NewDataTransferServiceClient(cc *grpc.ClientConn) DataTransferServiceClient {
	return &dataTransferServiceClient{cc}
}

func (c *dataTransferServiceClient) GetDataSource(ctx context.Context, in *GetDataSourceRequest, opts ...grpc.CallOption) (*DataSource, error) {
	out := new(DataSource)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetDataSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListDataSources(ctx context.Context, in *ListDataSourcesRequest, opts ...grpc.CallOption) (*ListDataSourcesResponse, error) {
	out := new(ListDataSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListDataSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) CreateTransferConfig(ctx context.Context, in *CreateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CreateTransferConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) UpdateTransferConfig(ctx context.Context, in *UpdateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/UpdateTransferConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) DeleteTransferConfig(ctx context.Context, in *DeleteTransferConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetTransferConfig(ctx context.Context, in *GetTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferConfigs(ctx context.Context, in *ListTransferConfigsRequest, opts ...grpc.CallOption) (*ListTransferConfigsResponse, error) {
	out := new(ListTransferConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ScheduleTransferRuns(ctx context.Context, in *ScheduleTransferRunsRequest, opts ...grpc.CallOption) (*ScheduleTransferRunsResponse, error) {
	out := new(ScheduleTransferRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ScheduleTransferRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetTransferRun(ctx context.Context, in *GetTransferRunRequest, opts ...grpc.CallOption) (*TransferRun, error) {
	out := new(TransferRun)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) DeleteTransferRun(ctx context.Context, in *DeleteTransferRunRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferRuns(ctx context.Context, in *ListTransferRunsRequest, opts ...grpc.CallOption) (*ListTransferRunsResponse, error) {
	out := new(ListTransferRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferLogs(ctx context.Context, in *ListTransferLogsRequest, opts ...grpc.CallOption) (*ListTransferLogsResponse, error) {
	out := new(ListTransferLogsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) CheckValidCreds(ctx context.Context, in *CheckValidCredsRequest, opts ...grpc.CallOption) (*CheckValidCredsResponse, error) {
	out := new(CheckValidCredsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CheckValidCreds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataTransferServiceServer is the server API for DataTransferService service.
type DataTransferServiceServer interface {
	// Retrieves a supported data source and returns its settings,
	// which can be used for UI rendering.
	GetDataSource(context.Context, *GetDataSourceRequest) (*DataSource, error)
	// Lists supported data sources and returns their settings,
	// which can be used for UI rendering.
	ListDataSources(context.Context, *ListDataSourcesRequest) (*ListDataSourcesResponse, error)
	// Creates a new data transfer configuration.
	CreateTransferConfig(context.Context, *CreateTransferConfigRequest) (*TransferConfig, error)
	// Updates a data transfer configuration.
	// All fields must be set, even if they are not updated.
	UpdateTransferConfig(context.Context, *UpdateTransferConfigRequest) (*TransferConfig, error)
	// Deletes a data transfer configuration,
	// including any associated transfer runs and logs.
	DeleteTransferConfig(context.Context, *DeleteTransferConfigRequest) (*empty.Empty, error)
	// Returns information about a data transfer config.
	GetTransferConfig(context.Context, *GetTransferConfigRequest) (*TransferConfig, error)
	// Returns information about all data transfers in the project.
	ListTransferConfigs(context.Context, *ListTransferConfigsRequest) (*ListTransferConfigsResponse, error)
	// Creates transfer runs for a time range [start_time, end_time].
	// For each date - or whatever granularity the data source supports - in the
	// range, one transfer run is created.
	// Note that runs are created per UTC time in the time range.
	ScheduleTransferRuns(context.Context, *ScheduleTransferRunsRequest) (*ScheduleTransferRunsResponse, error)
	// Returns information about the particular transfer run.
	GetTransferRun(context.Context, *GetTransferRunRequest) (*TransferRun, error)
	// Deletes the specified transfer run.
	DeleteTransferRun(context.Context, *DeleteTransferRunRequest) (*empty.Empty, error)
	// Returns information about running and completed jobs.
	ListTransferRuns(context.Context, *ListTransferRunsRequest) (*ListTransferRunsResponse, error)
	// Returns user facing log messages for the data transfer run.
	ListTransferLogs(context.Context, *ListTransferLogsRequest) (*ListTransferLogsResponse, error)
	// Returns true if valid credentials exist for the given data source and
	// requesting user.
	// Some data sources doesn't support service account, so we need to talk to
	// them on behalf of the end user. This API just checks whether we have OAuth
	// token for the particular user, which is a pre-requisite before user can
	// create a transfer config.
	CheckValidCreds(context.Context, *CheckValidCredsRequest) (*CheckValidCredsResponse, error)
}

func RegisterDataTransferServiceServer(s *grpc.Server, srv DataTransferServiceServer) {
	s.RegisterService(&_DataTransferService_serviceDesc, srv)
}

func _DataTransferService_GetDataSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetDataSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetDataSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetDataSource(ctx, req.(*GetDataSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListDataSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListDataSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListDataSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListDataSources(ctx, req.(*ListDataSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_CreateTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).CreateTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CreateTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).CreateTransferConfig(ctx, req.(*CreateTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_UpdateTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).UpdateTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/UpdateTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).UpdateTransferConfig(ctx, req.(*UpdateTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_DeleteTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).DeleteTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).DeleteTransferConfig(ctx, req.(*DeleteTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetTransferConfig(ctx, req.(*GetTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferConfigs(ctx, req.(*ListTransferConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ScheduleTransferRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScheduleTransferRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ScheduleTransferRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ScheduleTransferRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ScheduleTransferRuns(ctx, req.(*ScheduleTransferRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetTransferRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetTransferRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetTransferRun(ctx, req.(*GetTransferRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_DeleteTransferRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransferRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).DeleteTransferRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).DeleteTransferRun(ctx, req.(*DeleteTransferRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferRuns(ctx, req.(*ListTransferRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferLogs(ctx, req.(*ListTransferLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_CheckValidCreds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckValidCredsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).CheckValidCreds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CheckValidCreds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).CheckValidCreds(ctx, req.(*CheckValidCredsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataTransferService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.datatransfer.v1.DataTransferService",
	HandlerType: (*DataTransferServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDataSource",
			Handler:    _DataTransferService_GetDataSource_Handler,
		},
		{
			MethodName: "ListDataSources",
			Handler:    _DataTransferService_ListDataSources_Handler,
		},
		{
			MethodName: "CreateTransferConfig",
			Handler:    _DataTransferService_CreateTransferConfig_Handler,
		},
		{
			MethodName: "UpdateTransferConfig",
			Handler:    _DataTransferService_UpdateTransferConfig_Handler,
		},
		{
			MethodName: "DeleteTransferConfig",
			Handler:    _DataTransferService_DeleteTransferConfig_Handler,
		},
		{
			MethodName: "GetTransferConfig",
			Handler:    _DataTransferService_GetTransferConfig_Handler,
		},
		{
			MethodName: "ListTransferConfigs",
			Handler:    _DataTransferService_ListTransferConfigs_Handler,
		},
		{
			MethodName: "ScheduleTransferRuns",
			Handler:    _DataTransferService_ScheduleTransferRuns_Handler,
		},
		{
			MethodName: "GetTransferRun",
			Handler:    _DataTransferService_GetTransferRun_Handler,
		},
		{
			MethodName: "DeleteTransferRun",
			Handler:    _DataTransferService_DeleteTransferRun_Handler,
		},
		{
			MethodName: "ListTransferRuns",
			Handler:    _DataTransferService_ListTransferRuns_Handler,
		},
		{
			MethodName: "ListTransferLogs",
			Handler:    _DataTransferService_ListTransferLogs_Handler,
		},
		{
			MethodName: "CheckValidCreds",
			Handler:    _DataTransferService_CheckValidCreds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/datatransfer/v1/datatransfer.proto",
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/datatransfer/v1/datatransfer.proto", fileDescriptor_8edec8f64c27b8a4)
}

var fileDescriptor_8edec8f64c27b8a4 = []byte{
	// 2343 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x5a, 0xcf, 0x6f, 0xdb, 0xc8,
	0xf5, 0xff, 0x52, 0xfe, 0xfd, 0x64, 0x5b, 0xf2, 0xc4, 0x71, 0x18, 0x39, 0xbb, 0x5f, 0x2f, 0xdb,
	0x64, 0x1d, 0xb7, 0x95, 0xd6, 0xca, 0x26, 0xcd, 0x3a, 0x4d, 0x02, 0x59, 0x92, 0x1d, 0x15, 0x8e,
	0xe5, 0xa5, 0xe4, 0x64, 0x6b, 0x04, 0xcb, 0x65, 0xc4, 0xb1, 0xcc, 0x0d, 0x45, 0x32, 0x1c, 0xd2,
	0x89, 0x53, 0xa4, 0x87, 0x45, 0x50, 0x60, 0xd1, 0xde, 0xf6, 0xb0, 0x05, 0x8a, 0x5e, 0x7a, 0x69,
	0xb7, 0x40, 0xff, 0x84, 0xde, 0x7a, 0xea, 0xb5, 0xb7, 0x3d, 0xb4, 0x40, 0xdb, 0x4b, 0x6f, 0x05,
	0x7a, 0xe9, 0xa1, 0x87, 0x62, 0x86, 0x43, 0x89, 0x92, 0x68, 0x8b, 0x92, 0x0b, 0xf4, 0x64, 0xcd,
	0xbc, 0x1f, 0x33, 0xef, 0xc7, 0xe7, 0xcd, 0x7b, 0x84, 0xe1, 0x76, 0xd3, 0xb2, 0x9a, 0x06, 0xce,
	0x35, 0x0c, 0xcb, 0xd3, 0x72, 0x4f, 0xf5, 0xe6, 0x73, 0x0f, 0x3b, 0x27, 0x39, 0x4d, 0x75, 0x55,
	0xd7, 0x51, 0x4d, 0x72, 0x88, 0x9d, 0xdc, 0xf1, 0x7a, 0xd7, 0x3a, 0x6b, 0x3b, 0x96, 0x6b, 0xa1,
	0xab, 0xbe, 0x64, 0x96, 0x49, 0x66, 0x03, 0xc9, 0x6c, 0x17, 0xe7, 0xf1, 0x7a, 0xe6, 0x0a, 0x3f,
	0x40, 0xb5, 0xf5, 0x9c, 0x6a, 0x9a, 0x96, 0xab, 0xba, 0xba, 0x65, 0x12, 0x5f, 0x49, 0xe6, 0xfd,
	0x78, 0xc7, 0x77, 0x1f, 0x9d, 0x79, 0x9b, 0x4b, 0xb1, 0xd5, 0x53, 0xef, 0x30, 0xa7, 0x79, 0x0e,
	0x53, 0xcb, 0xe9, 0xcb, 0xbd, 0x74, 0xdc, 0xb2, 0xdd, 0x13, 0x4e, 0x5c, 0xe9, 0x25, 0x1e, 0xea,
	0xd8, 0xd0, 0x94, 0x96, 0x4a, 0x9e, 0x71, 0x8e, 0xff, 0xef, 0xe5, 0x70, 0xf5, 0x16, 0x26, 0xae,
	0xda, 0xb2, 0x4f, 0x3b, 0xff, 0x85, 0xa3, 0xda, 0x36, 0x76, 0xb8, 0x55, 0xd2, 0xaf, 0x27, 0xe1,
	0x42, 0x49, 0x75, 0xd5, 0x9a, 0xe5, 0x39, 0x0d, 0xbc, 0xa7, 0x3a, 0x6a, 0x0b, 0xbb, 0xd8, 0x41,
	0x97, 0x61, 0xda, 0xa6, 0x0b, 0x45, 0xd7, 0x44, 0x61, 0x45, 0x58, 0x9d, 0x91, 0xa7, 0xd8, 0xba,
	0xa2, 0xa1, 0x77, 0x60, 0x56, 0xd3, 0x89, 0x6d, 0xa8, 0x27, 0x8a, 0xa9, 0xb6, 0xb0, 0x98, 0x60,
	0xe4, 0x24, 0xdf, 0xdb, 0x55, 0x5b, 0x18, 0xad, 0x40, 0x52, 0xc3, 0xa4, 0xe1, 0xe8, 0x36, 0x35,
	0x55, 0x1c, 0xe3, 0x1c, 0x9d, 0x2d, 0x54, 0x83, 0x71, 0xf7, 0xc4, 0xc6, 0xe2, 0xf8, 0x8a, 0xb0,
	0x3a, 0x9f, 0xbf, 0x9f, 0x8d, 0x15, 0xa1, 0x6c, 0xc4, 0x4d, 0xb3, 0xf5, 0x13, 0x1b, 0xcb, 0x4c,
	0x19, 0xca, 0xc0, 0xb4, 0x83, 0x9f, 0x7b, 0xba, 0x83, 0x35, 0x71, 0x62, 0x45, 0x58, 0x9d, 0x96,
	0xdb, 0x6b, 0x9f, 0x66, 0x63, 0xd5, 0xc5, 0x9a, 0x38, 0x19, 0xd0, 0xfc, 0x35, 0xba, 0x0e, 0xe9,
	0x63, 0xd5, 0xd0, 0x35, 0x16, 0x18, 0xc5, 0xc1, 0x4d, 0xfc, 0x52, 0x9c, 0x62, 0x77, 0x4e, 0x75,
	0xf6, 0x65, 0xba, 0x8d, 0xae, 0xc2, 0xbc, 0x6a, 0x18, 0xd6, 0x0b, 0xac, 0x29, 0xc7, 0xaa, 0xe1,
	0x61, 0x22, 0x4e, 0xaf, 0x8c, 0xad, 0xce, 0xc8, 0x73, 0x7c, 0xf7, 0x11, 0xdb, 0x44, 0x1f, 0xc0,
	0x4c, 0x4b, 0x37, 0x7d, 0x16, 0x71, 0x66, 0x45, 0x58, 0x4d, 0xe6, 0xaf, 0x04, 0x36, 0x06, 0xa1,
	0xc8, 0x96, 0x2c, 0xef, 0xa9, 0x81, 0x99, 0x84, 0x3c, 0xdd, 0xd2, 0x4d, 0xf6, 0x8b, 0x89, 0xaa,
	0x2f, 0xb9, 0x28, 0xc4, 0x12, 0x55, 0x5f, 0xfa, 0xa2, 0x32, 0x4c, 0xb2, 0x0c, 0x21, 0x62, 0x72,
	0x65, 0x6c, 0x35, 0x99, 0xdf, 0x18, 0xdd, 0xad, 0x32, 0xd7, 0x84, 0x6e, 0xc2, 0x52, 0xc8, 0x37,
	0xe1, 0xa8, 0xce, 0x32, 0x0f, 0x5d, 0xec, 0x50, 0x4b, 0xa1, 0xf8, 0x66, 0xe1, 0x42, 0x48, 0xec,
	0x08, 0x1b, 0xb6, 0xe2, 0x39, 0x86, 0x38, 0xc7, 0x64, 0x16, 0x3a, 0xa4, 0x07, 0xd8, 0xb0, 0xf7,
	0x1d, 0x03, 0x5d, 0x81, 0x19, 0xbd, 0xd5, 0xf2, 0x5c, 0xf5, 0xa9, 0x81, 0xc5, 0x79, 0x16, 0x9f,
	0xce, 0x06, 0x12, 0x61, 0xca, 0xc1, 0x0d, 0xcf, 0x21, 0x58, 0x4c, 0x31, 0x5a, 0xb0, 0x94, 0x74,
	0x18, 0xa7, 0x09, 0x80, 0x16, 0x21, 0x5d, 0xff, 0xc1, 0x5e, 0x59, 0xd9, 0xdf, 0xad, 0xed, 0x95,
	0x8b, 0x95, 0xad, 0x4a, 0xb9, 0x94, 0xfe, 0x3f, 0x04, 0x30, 0x59, 0xab, 0xcb, 0x95, 0xdd, 0xed,
	0xb4, 0x80, 0x92, 0x30, 0x55, 0xd9, 0xad, 0x97, 0xb7, 0xcb, 0x72, 0x3a, 0x41, 0x09, 0xa5, 0xea,
	0xfe, 0xe6, 0x4e, 0x39, 0x3d, 0x46, 0x09, 0x9b, 0xd5, 0xea, 0x4e, 0xb9, 0xb0, 0x9b, 0x1e, 0xa7,
	0x04, 0xb9, 0x5c, 0xac, 0xca, 0xa5, 0xf4, 0x04, 0x9a, 0x83, 0x99, 0xbd, 0x9d, 0xfd, 0x9a, 0xb2,
	0x57, 0xd8, 0x2e, 0xa7, 0x27, 0xa5, 0x7f, 0xcf, 0x00, 0x74, 0x3c, 0x85, 0x10, 0x8c, 0xb3, 0xf4,
	0xf7, 0xd1, 0xc1, 0x7e, 0xa3, 0x6f, 0xc2, 0x3c, 0xf5, 0xad, 0x42, 0x18, 0x0b, 0xc5, 0x8e, 0x0f,
	0x8e, 0x59, 0xad, 0x2d, 0x17, 0x01, 0xa0, 0xb1, 0x81, 0x00, 0x1a, 0xef, 0x07, 0xd0, 0x32, 0xcc,
	0x34, 0x0c, 0x1d, 0x9b, 0x2e, 0x3d, 0x65, 0x82, 0xd1, 0xa7, 0xfd, 0x8d, 0x8a, 0x86, 0x96, 0x60,
	0x92, 0x34, 0x2c, 0x1b, 0x13, 0x71, 0x92, 0x65, 0x27, 0x5f, 0xa1, 0x8f, 0x60, 0x2e, 0x88, 0xbb,
	0xc2, 0xe0, 0x37, 0xc5, 0xe0, 0x77, 0x23, 0x66, 0x9e, 0xd4, 0xf9, 0x6f, 0x06, 0xb9, 0x59, 0x37,
	0xb4, 0x42, 0xf7, 0x60, 0x99, 0x78, 0xb6, 0x6d, 0x39, 0x2e, 0x51, 0x5a, 0x9e, 0xe1, 0xea, 0xb6,
	0x81, 0x95, 0x80, 0x83, 0x82, 0x84, 0x46, 0xed, 0x72, 0xc0, 0xf2, 0x90, 0x73, 0x04, 0x0a, 0x09,
	0xba, 0x05, 0x97, 0x3c, 0x5b, 0x53, 0x5d, 0xac, 0x68, 0x58, 0xd5, 0x0c, 0xdd, 0xc4, 0x0a, 0xc1,
	0x0d, 0xcb, 0xd4, 0x08, 0x83, 0xcf, 0x84, 0x7c, 0xd1, 0x27, 0x97, 0x38, 0xb5, 0xe6, 0x13, 0x29,
	0x74, 0x35, 0x7c, 0xa8, 0x7a, 0x86, 0xab, 0x90, 0xc6, 0x11, 0xd6, 0x3c, 0xc3, 0x07, 0xcd, 0x8c,
	0x9c, 0xe2, 0xfb, 0x35, 0xbe, 0x8d, 0x6e, 0x83, 0xd8, 0xbe, 0x62, 0xc3, 0x23, 0xae, 0xd5, 0xea,
	0x88, 0x24, 0xd9, 0xfd, 0x96, 0x02, 0x7a, 0x91, 0x91, 0xdb, 0x92, 0x07, 0x00, 0x76, 0x00, 0x0c,
	0x22, 0xce, 0x9e, 0x1b, 0x5b, 0x21, 0x6d, 0xb4, 0xd0, 0xf6, 0xa0, 0x63, 0xea, 0x88, 0x63, 0xc2,
	0x01, 0xa4, 0x7a, 0xee, 0x91, 0xe5, 0xe8, 0xaf, 0x7c, 0x18, 0xb1, 0x90, 0xcd, 0xb3, 0x90, 0x15,
	0x87, 0x3e, 0x3e, 0x5b, 0x08, 0xeb, 0x62, 0x21, 0x5c, 0x50, 0x7b, 0xb7, 0x50, 0x0b, 0x16, 0x58,
	0x06, 0x3b, 0xf8, 0xd0, 0xc1, 0xe4, 0xc8, 0x3f, 0x32, 0xc5, 0x8e, 0x2c, 0x0c, 0x7f, 0x24, 0xfd,
	0x29, 0xfb, 0x9a, 0xd8, 0x81, 0x29, 0xad, 0x7b, 0x03, 0x6d, 0xc1, 0x4a, 0x10, 0xbe, 0xae, 0x63,
	0x5f, 0xe8, 0xa6, 0x66, 0xbd, 0x50, 0x34, 0xf5, 0x84, 0x88, 0x69, 0x16, 0xff, 0x2b, 0x9c, 0x2f,
	0xa4, 0xf2, 0x31, 0x63, 0x2a, 0xa9, 0x27, 0x04, 0xbd, 0x07, 0x8b, 0x2d, 0xd5, 0xf4, 0x54, 0x43,
	0x71, 0x3c, 0x93, 0x28, 0x9a, 0x4e, 0x68, 0xdd, 0xd0, 0xc4, 0x05, 0x16, 0x57, 0xe4, 0xd3, 0x64,
	0xcf, 0x24, 0x25, 0x4e, 0x41, 0xfb, 0x70, 0xb9, 0xa5, 0x9b, 0x7a, 0xcb, 0xeb, 0x64, 0x81, 0xa2,
	0x9b, 0x2e, 0x76, 0x8e, 0x55, 0x43, 0x44, 0xac, 0xec, 0x5e, 0xee, 0x2f, 0xbb, 0xfc, 0xf1, 0x96,
	0x2f, 0x71, 0xd9, 0x20, 0x45, 0x2a, 0x5c, 0x52, 0x22, 0xb0, 0xd0, 0xe7, 0x67, 0x24, 0xc1, 0xdb,
	0x85, 0xfd, 0xfa, 0x83, 0xaa, 0x5c, 0x39, 0x28, 0xd4, 0x2b, 0xd5, 0x5d, 0x25, 0xa2, 0x54, 0x2d,
	0x01, 0xea, 0xe6, 0x29, 0x56, 0x4b, 0xe5, 0xb4, 0x40, 0x65, 0xb7, 0xab, 0xd5, 0xed, 0x9d, 0xb2,
	0xc2, 0x6a, 0x51, 0x04, 0x4f, 0x42, 0x6a, 0x40, 0xaa, 0xc7, 0xd3, 0xe8, 0x1d, 0x78, 0xab, 0x54,
	0xa8, 0x17, 0x14, 0xb9, 0xbc, 0x25, 0x97, 0x6b, 0x0f, 0xa2, 0x4e, 0x44, 0x30, 0x5f, 0xdb, 0xa9,
	0x94, 0x2a, 0xbb, 0xdb, 0xca, 0xe3, 0xca, 0x6e, 0xa9, 0xfa, 0x38, 0x2d, 0xa0, 0xcb, 0x70, 0xb1,
	0xb8, 0x5f, 0xab, 0x57, 0x1f, 0x2a, 0x3d, 0xa4, 0x84, 0xb4, 0x06, 0x8b, 0xdb, 0xd8, 0xed, 0x04,
	0x57, 0xc6, 0xcf, 0x3d, 0x4c, 0xdc, 0xa8, 0x3a, 0x28, 0x19, 0xb0, 0xb4, 0xa3, 0x93, 0x10, 0x33,
	0x09, 0xb8, 0x97, 0x60, 0xd2, 0x56, 0x1d, 0x6c, 0xba, 0x9c, 0x9f, 0xaf, 0xd0, 0x5b, 0x14, 0x62,
	0x4d, 0xac, 0xb8, 0xd6, 0x33, 0x1c, 0x34, 0x0c, 0x33, 0x74, 0xa7, 0x4e, 0x37, 0x68, 0xb5, 0x63,
	0x64, 0xa2, 0xbf, 0xf2, 0x7b, 0x86, 0x09, 0x79, 0x9a, 0x6e, 0xd4, 0xf4, 0x57, 0x58, 0xfa, 0x52,
	0x80, 0x4b, 0x7d, 0xc7, 0x11, 0xdb, 0x32, 0x09, 0x46, 0x75, 0x98, 0x0d, 0x55, 0x64, 0x22, 0x0a,
	0x0c, 0xbc, 0xeb, 0x43, 0xa7, 0xb2, 0x9c, 0xec, 0x94, 0x70, 0x82, 0xae, 0x41, 0xca, 0xc4, 0x2f,
	0x5d, 0x25, 0x74, 0x65, 0xbf, 0xd0, 0xcf, 0xd1, 0xed, 0xbd, 0xe0, 0xda, 0xd2, 0xef, 0x05, 0x58,
	0x2e, 0x3a, 0xb4, 0xc9, 0x08, 0x2a, 0x5d, 0xd1, 0x32, 0x0f, 0xf5, 0xe6, 0x20, 0x6f, 0x7c, 0x0c,
	0xa9, 0x76, 0x9d, 0x6e, 0x30, 0x09, 0xa6, 0x3f, 0x99, 0xbf, 0x39, 0x64, 0xa5, 0xe6, 0xc7, 0xcd,
	0xbb, 0x5d, 0x6b, 0xf4, 0x9d, 0xde, 0xca, 0xd2, 0xb0, 0xb4, 0xe0, 0x1d, 0xea, 0x2e, 0x0a, 0x45,
	0x4b, 0xc3, 0xd2, 0xdf, 0x05, 0x58, 0xde, 0x67, 0xe5, 0x37, 0xda, 0x8c, 0x88, 0xeb, 0x0a, 0xff,
	0xbb, 0xeb, 0xa2, 0x3b, 0x90, 0xe4, 0x6f, 0x09, 0xed, 0x94, 0x59, 0xba, 0x24, 0xf3, 0x99, 0x3e,
	0x30, 0x6f, 0xd1, 0x06, 0xe7, 0xa1, 0x4a, 0x9e, 0xc9, 0xe0, 0xb3, 0xd3, 0xdf, 0x52, 0x16, 0xc4,
	0x6d, 0xec, 0x46, 0xdb, 0x19, 0x95, 0xea, 0xeb, 0xb0, 0x5c, 0xc2, 0x06, 0x3e, 0xcd, 0x35, 0x51,
	0x22, 0xdf, 0x82, 0x8b, 0xa1, 0x23, 0x64, 0xcf, 0x3c, 0x8b, 0x39, 0x0b, 0x62, 0xb7, 0xfe, 0x01,
	0xfc, 0x3f, 0x13, 0x20, 0x43, 0xc1, 0xd0, 0x7d, 0x9d, 0x81, 0xf8, 0xbb, 0x06, 0xa9, 0xee, 0xce,
	0x85, 0x88, 0x09, 0xbf, 0xb1, 0x0d, 0xb7, 0x2e, 0xe4, 0x5c, 0x38, 0xfd, 0x95, 0x00, 0xcb, 0x91,
	0x57, 0xe3, 0x58, 0xfd, 0x04, 0xd2, 0x3d, 0x69, 0x14, 0xe0, 0x75, 0xc4, 0x3c, 0x4a, 0x75, 0xe7,
	0x51, 0x7c, 0xdc, 0xfe, 0x29, 0xe1, 0x57, 0x94, 0x90, 0xcf, 0x07, 0x7a, 0x70, 0x07, 0x26, 0x89,
	0xab, 0xba, 0xd8, 0x77, 0xdc, 0x7c, 0xfe, 0xfd, 0x21, 0xef, 0x5c, 0xa3, 0xc2, 0x32, 0xd7, 0x71,
	0x1e, 0x3f, 0xa3, 0x4f, 0x21, 0xe9, 0x78, 0xa6, 0xa2, 0xba, 0x2e, 0x1d, 0x26, 0x59, 0x73, 0x38,
	0x9f, 0xaf, 0xc4, 0xbc, 0xce, 0x29, 0x66, 0x67, 0x65, 0xcf, 0x2c, 0xf8, 0x0a, 0x65, 0x70, 0xda,
	0xbf, 0xa5, 0x9b, 0x00, 0x1d, 0x0a, 0x5a, 0x86, 0x4b, 0xf2, 0xfe, 0xae, 0x52, 0xa8, 0xd7, 0xcb,
	0x0f, 0xf7, 0xea, 0xfd, 0xcd, 0xf8, 0x4e, 0xa1, 0x5e, 0xae, 0xd5, 0xd3, 0x82, 0xf4, 0x73, 0x01,
	0xc4, 0xfe, 0x93, 0x78, 0x1e, 0x3c, 0x0e, 0x75, 0xa9, 0xf4, 0x39, 0xe7, 0x49, 0x90, 0x1f, 0xd2,
	0xa1, 0x14, 0x28, 0xed, 0x26, 0x95, 0x1e, 0x10, 0x3b, 0xfc, 0x5f, 0x0b, 0xdd, 0xe1, 0xdf, 0xb1,
	0x9a, 0x43, 0x3e, 0x60, 0xe3, 0x67, 0x06, 0x6c, 0xa2, 0x27, 0x60, 0xcf, 0x60, 0xae, 0x85, 0x09,
	0x61, 0xe2, 0x27, 0x41, 0xd7, 0x3e, 0x9f, 0xdf, 0x1a, 0xd2, 0xe0, 0x87, 0xbe, 0x8e, 0x2c, 0xff,
	0x5b, 0xc3, 0xc7, 0xd8, 0xd1, 0xdd, 0x13, 0x79, 0x96, 0x2b, 0xa7, 0x8d, 0x01, 0xa1, 0x28, 0x14,
	0xfb, 0x8d, 0xe3, 0xae, 0x6f, 0xc0, 0x42, 0xdb, 0xf5, 0x5c, 0x2a, 0x70, 0xff, 0xad, 0xd1, 0x6e,
	0x23, 0xb7, 0x31, 0xcd, 0x37, 0xe2, 0x87, 0xe1, 0xdb, 0xb0, 0x54, 0x3c, 0xc2, 0x8d, 0x67, 0x8f,
	0xe8, 0xb4, 0x58, 0x74, 0xb0, 0x46, 0xce, 0x2a, 0x7c, 0x05, 0xb8, 0xd4, 0xc7, 0xcd, 0xad, 0xba,
	0x06, 0xa9, 0x23, 0x95, 0x28, 0x6c, 0xea, 0x54, 0x1a, 0x94, 0xc4, 0x24, 0xa7, 0xe5, 0xb9, 0x23,
	0x95, 0x74, 0xf8, 0x59, 0x81, 0x0a, 0x3a, 0xba, 0x61, 0xa0, 0xff, 0x01, 0x00, 0x71, 0x55, 0xc7,
	0x55, 0x5c, 0x9d, 0x7f, 0x0f, 0x89, 0x7a, 0x6f, 0xea, 0xc1, 0xa7, 0x19, 0x79, 0x86, 0x71, 0xd3,
	0x35, 0xba, 0x09, 0xd3, 0xd8, 0xd4, 0x7c, 0xc1, 0xb1, 0x81, 0x82, 0x53, 0xd8, 0xd4, 0xe8, 0x4a,
	0x3a, 0x84, 0x2b, 0xd1, 0x17, 0xe5, 0x16, 0x6f, 0xc1, 0xf8, 0x39, 0x91, 0xc3, 0xe4, 0xf3, 0x3f,
	0x5e, 0xf6, 0x3f, 0x0f, 0xb5, 0x8b, 0x14, 0x76, 0x8e, 0xf5, 0x06, 0x46, 0x7f, 0x16, 0x60, 0xae,
	0xab, 0x1b, 0x44, 0x77, 0x62, 0x9e, 0x11, 0xd5, 0x43, 0x66, 0x86, 0xef, 0xc7, 0xa4, 0x8f, 0x3f,
	0xfb, 0xe3, 0xdf, 0xbe, 0x48, 0x7c, 0x84, 0x72, 0xb9, 0xe3, 0xf5, 0xdc, 0x0f, 0x69, 0x06, 0xdc,
	0xb5, 0x1d, 0xeb, 0x53, 0xdc, 0x70, 0x49, 0x6e, 0x2d, 0x67, 0x58, 0x0d, 0xff, 0xe3, 0x5d, 0x6e,
	0x2d, 0x17, 0x6a, 0xdc, 0x72, 0x6b, 0xaf, 0x0f, 0xae, 0xa2, 0x6f, 0x44, 0x8a, 0x74, 0xb3, 0xa1,
	0x7f, 0x08, 0x90, 0xea, 0x69, 0x2a, 0xd1, 0xdd, 0x21, 0x6a, 0x68, 0x7f, 0xef, 0x9b, 0xb9, 0x37,
	0xaa, 0xb8, 0x1f, 0xd4, 0x1e, 0x93, 0xfd, 0xdc, 0x3b, 0xc5, 0xe8, 0xd7, 0x61, 0x73, 0xda, 0x26,
	0xf7, 0x89, 0x74, 0xb1, 0xa1, 0x5f, 0x24, 0x60, 0x31, 0xaa, 0x5b, 0x45, 0x9b, 0x31, 0x2f, 0x7e,
	0x46, 0xab, 0x9b, 0x19, 0xed, 0x09, 0x97, 0x3e, 0x17, 0x98, 0xd1, 0x9f, 0x09, 0xd2, 0x8d, 0x38,
	0x56, 0xf7, 0x3c, 0xf8, 0x1b, 0xbd, 0x7d, 0xe9, 0xc1, 0x86, 0xf4, 0xee, 0x69, 0xae, 0x18, 0x24,
	0x8b, 0x7e, 0x97, 0x80, 0xc5, 0xa8, 0x36, 0x38, 0xb6, 0x7f, 0xce, 0xe8, 0xa1, 0x47, 0xf5, 0xcf,
	0x57, 0xbe, 0x7f, 0x7e, 0x29, 0xe4, 0x8b, 0xcc, 0xae, 0x9e, 0x3b, 0x67, 0xcf, 0x02, 0x46, 0x8f,
	0xc1, 0xb9, 0xb5, 0xd7, 0xfd, 0xfe, 0xfa, 0x7e, 0xfe, 0xbb, 0xb1, 0xf4, 0xc6, 0xd0, 0x85, 0xbe,
	0x16, 0x60, 0x31, 0xaa, 0x57, 0x8e, 0xed, 0xbf, 0x33, 0x1a, 0xed, 0xcc, 0x52, 0x5f, 0xd9, 0x2c,
	0xb7, 0x6c, 0xf7, 0x44, 0x3a, 0x64, 0xfe, 0xf9, 0x64, 0xed, 0xc6, 0xc0, 0x3a, 0xd1, 0x6f, 0xc2,
	0xc1, 0xf5, 0xb5, 0x77, 0x23, 0xc5, 0xfa, 0x59, 0xd1, 0x3f, 0x05, 0x58, 0xe8, 0x1b, 0x1c, 0xd0,
	0xfd, 0xf8, 0x55, 0xf1, 0xbf, 0x9a, 0x16, 0xdc, 0x6a, 0x34, 0x9a, 0xd5, 0x28, 0xb6, 0xd5, 0x6f,
	0x12, 0x70, 0x21, 0xa2, 0xa5, 0x47, 0x85, 0x11, 0xba, 0xcd, 0xee, 0x49, 0x25, 0xb3, 0x79, 0x1e,
	0x15, 0xbc, 0x62, 0x76, 0xbb, 0x61, 0xb8, 0xda, 0xd1, 0x76, 0xc3, 0xe0, 0x52, 0x81, 0x7e, 0x9b,
	0x80, 0xc5, 0xa8, 0xf7, 0x38, 0x76, 0x66, 0x9f, 0xd1, 0x75, 0x64, 0x8a, 0xe7, 0xd2, 0xc1, 0x3d,
	0xf1, 0x13, 0xbf, 0x4e, 0xbc, 0x11, 0xa4, 0xcd, 0xc1, 0xbe, 0x88, 0x42, 0x73, 0xf0, 0x91, 0x8c,
	0x6a, 0xdd, 0x10, 0xd6, 0x0e, 0xee, 0x48, 0xb7, 0x4e, 0x51, 0x34, 0x58, 0x18, 0xfd, 0x4b, 0x80,
	0xf9, 0xee, 0x11, 0x18, 0x7d, 0x6f, 0x78, 0xa4, 0x74, 0x26, 0xe1, 0xcc, 0x08, 0x1d, 0x8e, 0xe4,
	0x32, 0x8f, 0x98, 0x68, 0x63, 0x78, 0x8c, 0xe4, 0x68, 0x73, 0x44, 0xa1, 0xf2, 0x1e, 0xca, 0xc6,
	0x83, 0x4a, 0x20, 0x81, 0xfe, 0x22, 0xc0, 0x42, 0xdf, 0x40, 0x1f, 0xbb, 0x4e, 0x9c, 0xf6, 0x29,
	0xe0, 0xd4, 0xf2, 0xc7, 0x8d, 0x5c, 0x3b, 0x97, 0x91, 0x6b, 0xc3, 0x1a, 0xf9, 0x79, 0x02, 0xd2,
	0xbd, 0xe3, 0x1d, 0xba, 0x77, 0xbe, 0x09, 0x34, 0x73, 0x7f, 0x64, 0x79, 0x8e, 0x81, 0xee, 0x80,
	0x0f, 0x8b, 0x00, 0x66, 0x5c, 0x3b, 0xe0, 0x71, 0xd2, 0x9e, 0x49, 0xa0, 0xaf, 0x7a, 0x7c, 0x41,
	0xe7, 0xad, 0x91, 0x7c, 0x11, 0x9a, 0x42, 0x47, 0xf2, 0x45, 0x78, 0xd0, 0x93, 0xbe, 0xf0, 0xeb,
	0xc1, 0x4f, 0x05, 0x54, 0x19, 0xc5, 0x1b, 0x41, 0xa4, 0xdb, 0x14, 0xaa, 0xfc, 0xe0, 0x3e, 0xba,
	0x1b, 0xd7, 0x39, 0x91, 0x0a, 0xd0, 0x97, 0x09, 0x48, 0xf5, 0x0c, 0x71, 0xb1, 0x9b, 0xee, 0xe8,
	0x51, 0x31, 0x76, 0xd3, 0x7d, 0xca, 0xec, 0x28, 0xbd, 0xf1, 0x1d, 0xf5, 0x23, 0xe9, 0xfe, 0x90,
	0x83, 0xc6, 0x46, 0xa3, 0x5b, 0x23, 0x2d, 0x9a, 0xb7, 0xa5, 0x1b, 0x31, 0x66, 0x8f, 0x08, 0xc9,
	0xcd, 0xbf, 0x0a, 0x70, 0xbd, 0x61, 0xb5, 0xe2, 0x19, 0xb3, 0xb9, 0x10, 0x9e, 0xd9, 0xf6, 0x68,
	0x45, 0xd8, 0x13, 0x0e, 0x3e, 0xe4, 0xb2, 0x4d, 0xcb, 0x50, 0xcd, 0x66, 0xd6, 0x72, 0x9a, 0xb9,
	0x26, 0x36, 0x59, 0xbd, 0xc8, 0xf9, 0x24, 0xd5, 0xd6, 0xc9, 0x80, 0xff, 0x6f, 0xb8, 0x13, 0x5e,
	0xff, 0x26, 0x71, 0x75, 0xdb, 0xd7, 0x59, 0x64, 0xf7, 0xd9, 0xd4, 0x9b, 0x1f, 0xb2, 0xfb, 0x84,
	0x8f, 0xcf, 0x3e, 0x5a, 0xff, 0x43, 0xc0, 0xf7, 0x84, 0xf1, 0x3d, 0x09, 0xf8, 0x9e, 0x84, 0xf9,
	0x9e, 0x3c, 0x5a, 0x7f, 0x3a, 0xc9, 0x6e, 0x73, 0xe3, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x48,
	0xcd, 0xb8, 0x10, 0xeb, 0x21, 0x00, 0x00,
}
