// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/kms/v1/service.proto

package kms

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/struct"
	_ "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	math "math"
)

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [KeyManagementService.ListKeyRings][google.cloud.kms.v1.KeyManagementService.ListKeyRings].
type ListKeyRingsRequest struct {
	// Required. The resource name of the location associated with the
	// [KeyRings][google.cloud.kms.v1.KeyRing], in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of [KeyRings][google.cloud.kms.v1.KeyRing] to include in the
	// response.  Further [KeyRings][google.cloud.kms.v1.KeyRing] can subsequently be obtained by
	// including the [ListKeyRingsResponse.next_page_token][google.cloud.kms.v1.ListKeyRingsResponse.next_page_token] in a subsequent
	// request.  If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token, returned earlier via
	// [ListKeyRingsResponse.next_page_token][google.cloud.kms.v1.ListKeyRingsResponse.next_page_token].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeyRingsRequest) Reset()         { *m = ListKeyRingsRequest{} }
func (m *ListKeyRingsRequest) String() string { return proto.CompactTextString(m) }
func (*ListKeyRingsRequest) ProtoMessage()    {}
func (*ListKeyRingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{0}
}

func (m *ListKeyRingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeyRingsRequest.Unmarshal(m, b)
}
func (m *ListKeyRingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeyRingsRequest.Marshal(b, m, deterministic)
}
func (m *ListKeyRingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeyRingsRequest.Merge(m, src)
}
func (m *ListKeyRingsRequest) XXX_Size() int {
	return xxx_messageInfo_ListKeyRingsRequest.Size(m)
}
func (m *ListKeyRingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeyRingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeyRingsRequest proto.InternalMessageInfo

func (m *ListKeyRingsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListKeyRingsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListKeyRingsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Request message for [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
type ListCryptoKeysRequest struct {
	// Required. The resource name of the [KeyRing][google.cloud.kms.v1.KeyRing] to list, in the format
	// `projects/*/locations/*/keyRings/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of [CryptoKeys][google.cloud.kms.v1.CryptoKey] to include in the
	// response.  Further [CryptoKeys][google.cloud.kms.v1.CryptoKey] can subsequently be obtained by
	// including the [ListCryptoKeysResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeysResponse.next_page_token] in a subsequent
	// request.  If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token, returned earlier via
	// [ListCryptoKeysResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeysResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The fields of the primary version to include in the response.
	VersionView          CryptoKeyVersion_CryptoKeyVersionView `protobuf:"varint,4,opt,name=version_view,json=versionView,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionView" json:"version_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *ListCryptoKeysRequest) Reset()         { *m = ListCryptoKeysRequest{} }
func (m *ListCryptoKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeysRequest) ProtoMessage()    {}
func (*ListCryptoKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{1}
}

func (m *ListCryptoKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeysRequest.Unmarshal(m, b)
}
func (m *ListCryptoKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListCryptoKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeysRequest.Merge(m, src)
}
func (m *ListCryptoKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeysRequest.Size(m)
}
func (m *ListCryptoKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeysRequest proto.InternalMessageInfo

func (m *ListCryptoKeysRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListCryptoKeysRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListCryptoKeysRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListCryptoKeysRequest) GetVersionView() CryptoKeyVersion_CryptoKeyVersionView {
	if m != nil {
		return m.VersionView
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED
}

// Request message for [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions].
type ListCryptoKeyVersionsRequest struct {
	// Required. The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to list, in the format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] to
	// include in the response. Further [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] can
	// subsequently be obtained by including the
	// [ListCryptoKeyVersionsResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeyVersionsResponse.next_page_token] in a subsequent request.
	// If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token, returned earlier via
	// [ListCryptoKeyVersionsResponse.next_page_token][google.cloud.kms.v1.ListCryptoKeyVersionsResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The fields to include in the response.
	View                 CryptoKeyVersion_CryptoKeyVersionView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionView" json:"view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *ListCryptoKeyVersionsRequest) Reset()         { *m = ListCryptoKeyVersionsRequest{} }
func (m *ListCryptoKeyVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeyVersionsRequest) ProtoMessage()    {}
func (*ListCryptoKeyVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{2}
}

func (m *ListCryptoKeyVersionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeyVersionsRequest.Unmarshal(m, b)
}
func (m *ListCryptoKeyVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeyVersionsRequest.Marshal(b, m, deterministic)
}
func (m *ListCryptoKeyVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeyVersionsRequest.Merge(m, src)
}
func (m *ListCryptoKeyVersionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeyVersionsRequest.Size(m)
}
func (m *ListCryptoKeyVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeyVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeyVersionsRequest proto.InternalMessageInfo

func (m *ListCryptoKeyVersionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListCryptoKeyVersionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListCryptoKeyVersionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListCryptoKeyVersionsRequest) GetView() CryptoKeyVersion_CryptoKeyVersionView {
	if m != nil {
		return m.View
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED
}

// Response message for [KeyManagementService.ListKeyRings][google.cloud.kms.v1.KeyManagementService.ListKeyRings].
type ListKeyRingsResponse struct {
	// The list of [KeyRings][google.cloud.kms.v1.KeyRing].
	KeyRings []*KeyRing `protobuf:"bytes,1,rep,name=key_rings,json=keyRings,proto3" json:"key_rings,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListKeyRingsRequest.page_token][google.cloud.kms.v1.ListKeyRingsRequest.page_token] to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [KeyRings][google.cloud.kms.v1.KeyRing] that matched the query.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeyRingsResponse) Reset()         { *m = ListKeyRingsResponse{} }
func (m *ListKeyRingsResponse) String() string { return proto.CompactTextString(m) }
func (*ListKeyRingsResponse) ProtoMessage()    {}
func (*ListKeyRingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{3}
}

func (m *ListKeyRingsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeyRingsResponse.Unmarshal(m, b)
}
func (m *ListKeyRingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeyRingsResponse.Marshal(b, m, deterministic)
}
func (m *ListKeyRingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeyRingsResponse.Merge(m, src)
}
func (m *ListKeyRingsResponse) XXX_Size() int {
	return xxx_messageInfo_ListKeyRingsResponse.Size(m)
}
func (m *ListKeyRingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeyRingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeyRingsResponse proto.InternalMessageInfo

func (m *ListKeyRingsResponse) GetKeyRings() []*KeyRing {
	if m != nil {
		return m.KeyRings
	}
	return nil
}

func (m *ListKeyRingsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListKeyRingsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Response message for [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
type ListCryptoKeysResponse struct {
	// The list of [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	CryptoKeys []*CryptoKey `protobuf:"bytes,1,rep,name=crypto_keys,json=cryptoKeys,proto3" json:"crypto_keys,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListCryptoKeysRequest.page_token][google.cloud.kms.v1.ListCryptoKeysRequest.page_token] to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [CryptoKeys][google.cloud.kms.v1.CryptoKey] that matched the query.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCryptoKeysResponse) Reset()         { *m = ListCryptoKeysResponse{} }
func (m *ListCryptoKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeysResponse) ProtoMessage()    {}
func (*ListCryptoKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{4}
}

func (m *ListCryptoKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeysResponse.Unmarshal(m, b)
}
func (m *ListCryptoKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListCryptoKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeysResponse.Merge(m, src)
}
func (m *ListCryptoKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeysResponse.Size(m)
}
func (m *ListCryptoKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeysResponse proto.InternalMessageInfo

func (m *ListCryptoKeysResponse) GetCryptoKeys() []*CryptoKey {
	if m != nil {
		return m.CryptoKeys
	}
	return nil
}

func (m *ListCryptoKeysResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListCryptoKeysResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Response message for [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions].
type ListCryptoKeyVersionsResponse struct {
	// The list of [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	CryptoKeyVersions []*CryptoKeyVersion `protobuf:"bytes,1,rep,name=crypto_key_versions,json=cryptoKeyVersions,proto3" json:"crypto_key_versions,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListCryptoKeyVersionsRequest.page_token][google.cloud.kms.v1.ListCryptoKeyVersionsRequest.page_token] to retrieve the next page of
	// results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] that matched the
	// query.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCryptoKeyVersionsResponse) Reset()         { *m = ListCryptoKeyVersionsResponse{} }
func (m *ListCryptoKeyVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListCryptoKeyVersionsResponse) ProtoMessage()    {}
func (*ListCryptoKeyVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{5}
}

func (m *ListCryptoKeyVersionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListCryptoKeyVersionsResponse.Unmarshal(m, b)
}
func (m *ListCryptoKeyVersionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListCryptoKeyVersionsResponse.Marshal(b, m, deterministic)
}
func (m *ListCryptoKeyVersionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCryptoKeyVersionsResponse.Merge(m, src)
}
func (m *ListCryptoKeyVersionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListCryptoKeyVersionsResponse.Size(m)
}
func (m *ListCryptoKeyVersionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCryptoKeyVersionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListCryptoKeyVersionsResponse proto.InternalMessageInfo

func (m *ListCryptoKeyVersionsResponse) GetCryptoKeyVersions() []*CryptoKeyVersion {
	if m != nil {
		return m.CryptoKeyVersions
	}
	return nil
}

func (m *ListCryptoKeyVersionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListCryptoKeyVersionsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for [KeyManagementService.GetKeyRing][google.cloud.kms.v1.KeyManagementService.GetKeyRing].
type GetKeyRingRequest struct {
	// The [name][google.cloud.kms.v1.KeyRing.name] of the [KeyRing][google.cloud.kms.v1.KeyRing] to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetKeyRingRequest) Reset()         { *m = GetKeyRingRequest{} }
func (m *GetKeyRingRequest) String() string { return proto.CompactTextString(m) }
func (*GetKeyRingRequest) ProtoMessage()    {}
func (*GetKeyRingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{6}
}

func (m *GetKeyRingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetKeyRingRequest.Unmarshal(m, b)
}
func (m *GetKeyRingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetKeyRingRequest.Marshal(b, m, deterministic)
}
func (m *GetKeyRingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetKeyRingRequest.Merge(m, src)
}
func (m *GetKeyRingRequest) XXX_Size() int {
	return xxx_messageInfo_GetKeyRingRequest.Size(m)
}
func (m *GetKeyRingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetKeyRingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetKeyRingRequest proto.InternalMessageInfo

func (m *GetKeyRingRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.GetCryptoKey][google.cloud.kms.v1.KeyManagementService.GetCryptoKey].
type GetCryptoKeyRequest struct {
	// The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCryptoKeyRequest) Reset()         { *m = GetCryptoKeyRequest{} }
func (m *GetCryptoKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetCryptoKeyRequest) ProtoMessage()    {}
func (*GetCryptoKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{7}
}

func (m *GetCryptoKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCryptoKeyRequest.Unmarshal(m, b)
}
func (m *GetCryptoKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCryptoKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetCryptoKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCryptoKeyRequest.Merge(m, src)
}
func (m *GetCryptoKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetCryptoKeyRequest.Size(m)
}
func (m *GetCryptoKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCryptoKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCryptoKeyRequest proto.InternalMessageInfo

func (m *GetCryptoKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.GetCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.GetCryptoKeyVersion].
type GetCryptoKeyVersionRequest struct {
	// The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCryptoKeyVersionRequest) Reset()         { *m = GetCryptoKeyVersionRequest{} }
func (m *GetCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*GetCryptoKeyVersionRequest) ProtoMessage()    {}
func (*GetCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{8}
}

func (m *GetCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *GetCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *GetCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCryptoKeyVersionRequest.Merge(m, src)
}
func (m *GetCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_GetCryptoKeyVersionRequest.Size(m)
}
func (m *GetCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *GetCryptoKeyVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
type GetPublicKeyRequest struct {
	// The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key to
	// get.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetPublicKeyRequest) Reset()         { *m = GetPublicKeyRequest{} }
func (m *GetPublicKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetPublicKeyRequest) ProtoMessage()    {}
func (*GetPublicKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{9}
}

func (m *GetPublicKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetPublicKeyRequest.Unmarshal(m, b)
}
func (m *GetPublicKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetPublicKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetPublicKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPublicKeyRequest.Merge(m, src)
}
func (m *GetPublicKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetPublicKeyRequest.Size(m)
}
func (m *GetPublicKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPublicKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPublicKeyRequest proto.InternalMessageInfo

func (m *GetPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.CreateKeyRing][google.cloud.kms.v1.KeyManagementService.CreateKeyRing].
type CreateKeyRingRequest struct {
	// Required. The resource name of the location associated with the
	// [KeyRings][google.cloud.kms.v1.KeyRing], in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. It must be unique within a location and match the regular
	// expression `[a-zA-Z0-9_-]{1,63}`
	KeyRingId string `protobuf:"bytes,2,opt,name=key_ring_id,json=keyRingId,proto3" json:"key_ring_id,omitempty"`
	// A [KeyRing][google.cloud.kms.v1.KeyRing] with initial field values.
	KeyRing              *KeyRing `protobuf:"bytes,3,opt,name=key_ring,json=keyRing,proto3" json:"key_ring,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateKeyRingRequest) Reset()         { *m = CreateKeyRingRequest{} }
func (m *CreateKeyRingRequest) String() string { return proto.CompactTextString(m) }
func (*CreateKeyRingRequest) ProtoMessage()    {}
func (*CreateKeyRingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{10}
}

func (m *CreateKeyRingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateKeyRingRequest.Unmarshal(m, b)
}
func (m *CreateKeyRingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateKeyRingRequest.Marshal(b, m, deterministic)
}
func (m *CreateKeyRingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateKeyRingRequest.Merge(m, src)
}
func (m *CreateKeyRingRequest) XXX_Size() int {
	return xxx_messageInfo_CreateKeyRingRequest.Size(m)
}
func (m *CreateKeyRingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateKeyRingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateKeyRingRequest proto.InternalMessageInfo

func (m *CreateKeyRingRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateKeyRingRequest) GetKeyRingId() string {
	if m != nil {
		return m.KeyRingId
	}
	return ""
}

func (m *CreateKeyRingRequest) GetKeyRing() *KeyRing {
	if m != nil {
		return m.KeyRing
	}
	return nil
}

// Request message for [KeyManagementService.CreateCryptoKey][google.cloud.kms.v1.KeyManagementService.CreateCryptoKey].
type CreateCryptoKeyRequest struct {
	// Required. The [name][google.cloud.kms.v1.KeyRing.name] of the KeyRing associated with the
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. It must be unique within a KeyRing and match the regular
	// expression `[a-zA-Z0-9_-]{1,63}`
	CryptoKeyId string `protobuf:"bytes,2,opt,name=crypto_key_id,json=cryptoKeyId,proto3" json:"crypto_key_id,omitempty"`
	// A [CryptoKey][google.cloud.kms.v1.CryptoKey] with initial field values.
	CryptoKey            *CryptoKey `protobuf:"bytes,3,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CreateCryptoKeyRequest) Reset()         { *m = CreateCryptoKeyRequest{} }
func (m *CreateCryptoKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateCryptoKeyRequest) ProtoMessage()    {}
func (*CreateCryptoKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{11}
}

func (m *CreateCryptoKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateCryptoKeyRequest.Unmarshal(m, b)
}
func (m *CreateCryptoKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateCryptoKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateCryptoKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateCryptoKeyRequest.Merge(m, src)
}
func (m *CreateCryptoKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateCryptoKeyRequest.Size(m)
}
func (m *CreateCryptoKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateCryptoKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateCryptoKeyRequest proto.InternalMessageInfo

func (m *CreateCryptoKeyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateCryptoKeyRequest) GetCryptoKeyId() string {
	if m != nil {
		return m.CryptoKeyId
	}
	return ""
}

func (m *CreateCryptoKeyRequest) GetCryptoKey() *CryptoKey {
	if m != nil {
		return m.CryptoKey
	}
	return nil
}

// Request message for [KeyManagementService.CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion].
type CreateCryptoKeyVersionRequest struct {
	// Required. The [name][google.cloud.kms.v1.CryptoKey.name] of the [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with
	// the [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with initial field values.
	CryptoKeyVersion     *CryptoKeyVersion `protobuf:"bytes,2,opt,name=crypto_key_version,json=cryptoKeyVersion,proto3" json:"crypto_key_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateCryptoKeyVersionRequest) Reset()         { *m = CreateCryptoKeyVersionRequest{} }
func (m *CreateCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateCryptoKeyVersionRequest) ProtoMessage()    {}
func (*CreateCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{12}
}

func (m *CreateCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *CreateCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *CreateCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateCryptoKeyVersionRequest.Merge(m, src)
}
func (m *CreateCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateCryptoKeyVersionRequest.Size(m)
}
func (m *CreateCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *CreateCryptoKeyVersionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateCryptoKeyVersionRequest) GetCryptoKeyVersion() *CryptoKeyVersion {
	if m != nil {
		return m.CryptoKeyVersion
	}
	return nil
}

// Request message for [KeyManagementService.UpdateCryptoKey][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKey].
type UpdateCryptoKeyRequest struct {
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] with updated values.
	CryptoKey *CryptoKey `protobuf:"bytes,1,opt,name=crypto_key,json=cryptoKey,proto3" json:"crypto_key,omitempty"`
	// Required list of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateCryptoKeyRequest) Reset()         { *m = UpdateCryptoKeyRequest{} }
func (m *UpdateCryptoKeyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCryptoKeyRequest) ProtoMessage()    {}
func (*UpdateCryptoKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{13}
}

func (m *UpdateCryptoKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCryptoKeyRequest.Unmarshal(m, b)
}
func (m *UpdateCryptoKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCryptoKeyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateCryptoKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCryptoKeyRequest.Merge(m, src)
}
func (m *UpdateCryptoKeyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCryptoKeyRequest.Size(m)
}
func (m *UpdateCryptoKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCryptoKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCryptoKeyRequest proto.InternalMessageInfo

func (m *UpdateCryptoKeyRequest) GetCryptoKey() *CryptoKey {
	if m != nil {
		return m.CryptoKey
	}
	return nil
}

func (m *UpdateCryptoKeyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [KeyManagementService.UpdateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyVersion].
type UpdateCryptoKeyVersionRequest struct {
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with updated values.
	CryptoKeyVersion *CryptoKeyVersion `protobuf:"bytes,1,opt,name=crypto_key_version,json=cryptoKeyVersion,proto3" json:"crypto_key_version,omitempty"`
	// Required list of fields to be updated in this request.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateCryptoKeyVersionRequest) Reset()         { *m = UpdateCryptoKeyVersionRequest{} }
func (m *UpdateCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCryptoKeyVersionRequest) ProtoMessage()    {}
func (*UpdateCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{14}
}

func (m *UpdateCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCryptoKeyVersionRequest.Merge(m, src)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCryptoKeyVersionRequest.Size(m)
}
func (m *UpdateCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *UpdateCryptoKeyVersionRequest) GetCryptoKeyVersion() *CryptoKeyVersion {
	if m != nil {
		return m.CryptoKeyVersion
	}
	return nil
}

func (m *UpdateCryptoKeyVersionRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
type EncryptRequest struct {
	// Required. The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] or [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// to use for encryption.
	//
	// If a [CryptoKey][google.cloud.kms.v1.CryptoKey] is specified, the server will use its
	// [primary version][google.cloud.kms.v1.CryptoKey.primary].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The data to encrypt. Must be no larger than 64KiB.
	//
	// The maximum size depends on the key version's
	// [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level]. For
	// [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE] keys, the plaintext must be no larger
	// than 64KiB. For [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of the
	// plaintext and additional_authenticated_data fields must be no larger than
	// 8KiB.
	Plaintext []byte `protobuf:"bytes,2,opt,name=plaintext,proto3" json:"plaintext,omitempty"`
	// Optional data that, if specified, must also be provided during decryption
	// through [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
	//
	// The maximum size depends on the key version's
	// [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level]. For
	// [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE] keys, the AAD must be no larger than
	// 64KiB. For [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] keys, the combined length of the
	// plaintext and additional_authenticated_data fields must be no larger than
	// 8KiB.
	AdditionalAuthenticatedData []byte   `protobuf:"bytes,3,opt,name=additional_authenticated_data,json=additionalAuthenticatedData,proto3" json:"additional_authenticated_data,omitempty"`
	XXX_NoUnkeyedLiteral        struct{} `json:"-"`
	XXX_unrecognized            []byte   `json:"-"`
	XXX_sizecache               int32    `json:"-"`
}

func (m *EncryptRequest) Reset()         { *m = EncryptRequest{} }
func (m *EncryptRequest) String() string { return proto.CompactTextString(m) }
func (*EncryptRequest) ProtoMessage()    {}
func (*EncryptRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{15}
}

func (m *EncryptRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptRequest.Unmarshal(m, b)
}
func (m *EncryptRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptRequest.Marshal(b, m, deterministic)
}
func (m *EncryptRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptRequest.Merge(m, src)
}
func (m *EncryptRequest) XXX_Size() int {
	return xxx_messageInfo_EncryptRequest.Size(m)
}
func (m *EncryptRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptRequest proto.InternalMessageInfo

func (m *EncryptRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EncryptRequest) GetPlaintext() []byte {
	if m != nil {
		return m.Plaintext
	}
	return nil
}

func (m *EncryptRequest) GetAdditionalAuthenticatedData() []byte {
	if m != nil {
		return m.AdditionalAuthenticatedData
	}
	return nil
}

// Request message for [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
type DecryptRequest struct {
	// Required. The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption.
	// The server will choose the appropriate version.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The encrypted data originally returned in
	// [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
	Ciphertext []byte `protobuf:"bytes,2,opt,name=ciphertext,proto3" json:"ciphertext,omitempty"`
	// Optional data that must match the data originally supplied in
	// [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
	AdditionalAuthenticatedData []byte   `protobuf:"bytes,3,opt,name=additional_authenticated_data,json=additionalAuthenticatedData,proto3" json:"additional_authenticated_data,omitempty"`
	XXX_NoUnkeyedLiteral        struct{} `json:"-"`
	XXX_unrecognized            []byte   `json:"-"`
	XXX_sizecache               int32    `json:"-"`
}

func (m *DecryptRequest) Reset()         { *m = DecryptRequest{} }
func (m *DecryptRequest) String() string { return proto.CompactTextString(m) }
func (*DecryptRequest) ProtoMessage()    {}
func (*DecryptRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{16}
}

func (m *DecryptRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DecryptRequest.Unmarshal(m, b)
}
func (m *DecryptRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DecryptRequest.Marshal(b, m, deterministic)
}
func (m *DecryptRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DecryptRequest.Merge(m, src)
}
func (m *DecryptRequest) XXX_Size() int {
	return xxx_messageInfo_DecryptRequest.Size(m)
}
func (m *DecryptRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DecryptRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DecryptRequest proto.InternalMessageInfo

func (m *DecryptRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DecryptRequest) GetCiphertext() []byte {
	if m != nil {
		return m.Ciphertext
	}
	return nil
}

func (m *DecryptRequest) GetAdditionalAuthenticatedData() []byte {
	if m != nil {
		return m.AdditionalAuthenticatedData
	}
	return nil
}

// Request message for [KeyManagementService.AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign].
type AsymmetricSignRequest struct {
	// Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for signing.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The digest of the data to sign. The digest must be produced with
	// the same digest algorithm as specified by the key version's
	// [algorithm][google.cloud.kms.v1.CryptoKeyVersion.algorithm].
	Digest               *Digest  `protobuf:"bytes,3,opt,name=digest,proto3" json:"digest,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AsymmetricSignRequest) Reset()         { *m = AsymmetricSignRequest{} }
func (m *AsymmetricSignRequest) String() string { return proto.CompactTextString(m) }
func (*AsymmetricSignRequest) ProtoMessage()    {}
func (*AsymmetricSignRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{17}
}

func (m *AsymmetricSignRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsymmetricSignRequest.Unmarshal(m, b)
}
func (m *AsymmetricSignRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsymmetricSignRequest.Marshal(b, m, deterministic)
}
func (m *AsymmetricSignRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsymmetricSignRequest.Merge(m, src)
}
func (m *AsymmetricSignRequest) XXX_Size() int {
	return xxx_messageInfo_AsymmetricSignRequest.Size(m)
}
func (m *AsymmetricSignRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AsymmetricSignRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AsymmetricSignRequest proto.InternalMessageInfo

func (m *AsymmetricSignRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AsymmetricSignRequest) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

// Request message for [KeyManagementService.AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt].
type AsymmetricDecryptRequest struct {
	// Required. The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
	// decryption.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The data encrypted with the named [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s public
	// key using OAEP.
	Ciphertext           []byte   `protobuf:"bytes,3,opt,name=ciphertext,proto3" json:"ciphertext,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AsymmetricDecryptRequest) Reset()         { *m = AsymmetricDecryptRequest{} }
func (m *AsymmetricDecryptRequest) String() string { return proto.CompactTextString(m) }
func (*AsymmetricDecryptRequest) ProtoMessage()    {}
func (*AsymmetricDecryptRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{18}
}

func (m *AsymmetricDecryptRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsymmetricDecryptRequest.Unmarshal(m, b)
}
func (m *AsymmetricDecryptRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsymmetricDecryptRequest.Marshal(b, m, deterministic)
}
func (m *AsymmetricDecryptRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsymmetricDecryptRequest.Merge(m, src)
}
func (m *AsymmetricDecryptRequest) XXX_Size() int {
	return xxx_messageInfo_AsymmetricDecryptRequest.Size(m)
}
func (m *AsymmetricDecryptRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AsymmetricDecryptRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AsymmetricDecryptRequest proto.InternalMessageInfo

func (m *AsymmetricDecryptRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AsymmetricDecryptRequest) GetCiphertext() []byte {
	if m != nil {
		return m.Ciphertext
	}
	return nil
}

// Response message for [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
type DecryptResponse struct {
	// The decrypted data originally supplied in [EncryptRequest.plaintext][google.cloud.kms.v1.EncryptRequest.plaintext].
	Plaintext            []byte   `protobuf:"bytes,1,opt,name=plaintext,proto3" json:"plaintext,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DecryptResponse) Reset()         { *m = DecryptResponse{} }
func (m *DecryptResponse) String() string { return proto.CompactTextString(m) }
func (*DecryptResponse) ProtoMessage()    {}
func (*DecryptResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{19}
}

func (m *DecryptResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DecryptResponse.Unmarshal(m, b)
}
func (m *DecryptResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DecryptResponse.Marshal(b, m, deterministic)
}
func (m *DecryptResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DecryptResponse.Merge(m, src)
}
func (m *DecryptResponse) XXX_Size() int {
	return xxx_messageInfo_DecryptResponse.Size(m)
}
func (m *DecryptResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DecryptResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DecryptResponse proto.InternalMessageInfo

func (m *DecryptResponse) GetPlaintext() []byte {
	if m != nil {
		return m.Plaintext
	}
	return nil
}

// Response message for [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
type EncryptResponse struct {
	// The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] used in encryption.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The encrypted data.
	Ciphertext           []byte   `protobuf:"bytes,2,opt,name=ciphertext,proto3" json:"ciphertext,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptResponse) Reset()         { *m = EncryptResponse{} }
func (m *EncryptResponse) String() string { return proto.CompactTextString(m) }
func (*EncryptResponse) ProtoMessage()    {}
func (*EncryptResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{20}
}

func (m *EncryptResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptResponse.Unmarshal(m, b)
}
func (m *EncryptResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptResponse.Marshal(b, m, deterministic)
}
func (m *EncryptResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptResponse.Merge(m, src)
}
func (m *EncryptResponse) XXX_Size() int {
	return xxx_messageInfo_EncryptResponse.Size(m)
}
func (m *EncryptResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptResponse proto.InternalMessageInfo

func (m *EncryptResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EncryptResponse) GetCiphertext() []byte {
	if m != nil {
		return m.Ciphertext
	}
	return nil
}

// Response message for [KeyManagementService.AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign].
type AsymmetricSignResponse struct {
	// The created signature.
	Signature            []byte   `protobuf:"bytes,1,opt,name=signature,proto3" json:"signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AsymmetricSignResponse) Reset()         { *m = AsymmetricSignResponse{} }
func (m *AsymmetricSignResponse) String() string { return proto.CompactTextString(m) }
func (*AsymmetricSignResponse) ProtoMessage()    {}
func (*AsymmetricSignResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{21}
}

func (m *AsymmetricSignResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsymmetricSignResponse.Unmarshal(m, b)
}
func (m *AsymmetricSignResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsymmetricSignResponse.Marshal(b, m, deterministic)
}
func (m *AsymmetricSignResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsymmetricSignResponse.Merge(m, src)
}
func (m *AsymmetricSignResponse) XXX_Size() int {
	return xxx_messageInfo_AsymmetricSignResponse.Size(m)
}
func (m *AsymmetricSignResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AsymmetricSignResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AsymmetricSignResponse proto.InternalMessageInfo

func (m *AsymmetricSignResponse) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

// Response message for [KeyManagementService.AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt].
type AsymmetricDecryptResponse struct {
	// The decrypted data originally encrypted with the matching public key.
	Plaintext            []byte   `protobuf:"bytes,1,opt,name=plaintext,proto3" json:"plaintext,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AsymmetricDecryptResponse) Reset()         { *m = AsymmetricDecryptResponse{} }
func (m *AsymmetricDecryptResponse) String() string { return proto.CompactTextString(m) }
func (*AsymmetricDecryptResponse) ProtoMessage()    {}
func (*AsymmetricDecryptResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{22}
}

func (m *AsymmetricDecryptResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AsymmetricDecryptResponse.Unmarshal(m, b)
}
func (m *AsymmetricDecryptResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AsymmetricDecryptResponse.Marshal(b, m, deterministic)
}
func (m *AsymmetricDecryptResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AsymmetricDecryptResponse.Merge(m, src)
}
func (m *AsymmetricDecryptResponse) XXX_Size() int {
	return xxx_messageInfo_AsymmetricDecryptResponse.Size(m)
}
func (m *AsymmetricDecryptResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AsymmetricDecryptResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AsymmetricDecryptResponse proto.InternalMessageInfo

func (m *AsymmetricDecryptResponse) GetPlaintext() []byte {
	if m != nil {
		return m.Plaintext
	}
	return nil
}

// Request message for [KeyManagementService.UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
type UpdateCryptoKeyPrimaryVersionRequest struct {
	// The resource name of the [CryptoKey][google.cloud.kms.v1.CryptoKey] to update.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The id of the child [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use as primary.
	CryptoKeyVersionId   string   `protobuf:"bytes,2,opt,name=crypto_key_version_id,json=cryptoKeyVersionId,proto3" json:"crypto_key_version_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateCryptoKeyPrimaryVersionRequest) Reset()         { *m = UpdateCryptoKeyPrimaryVersionRequest{} }
func (m *UpdateCryptoKeyPrimaryVersionRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateCryptoKeyPrimaryVersionRequest) ProtoMessage()    {}
func (*UpdateCryptoKeyPrimaryVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{23}
}

func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Unmarshal(m, b)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Marshal(b, m, deterministic)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Merge(m, src)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.Size(m)
}
func (m *UpdateCryptoKeyPrimaryVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateCryptoKeyPrimaryVersionRequest proto.InternalMessageInfo

func (m *UpdateCryptoKeyPrimaryVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateCryptoKeyPrimaryVersionRequest) GetCryptoKeyVersionId() string {
	if m != nil {
		return m.CryptoKeyVersionId
	}
	return ""
}

// Request message for [KeyManagementService.DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion].
type DestroyCryptoKeyVersionRequest struct {
	// The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to destroy.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DestroyCryptoKeyVersionRequest) Reset()         { *m = DestroyCryptoKeyVersionRequest{} }
func (m *DestroyCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*DestroyCryptoKeyVersionRequest) ProtoMessage()    {}
func (*DestroyCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{24}
}

func (m *DestroyCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DestroyCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DestroyCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DestroyCryptoKeyVersionRequest.Merge(m, src)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_DestroyCryptoKeyVersionRequest.Size(m)
}
func (m *DestroyCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DestroyCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DestroyCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *DestroyCryptoKeyVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [KeyManagementService.RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion].
type RestoreCryptoKeyVersionRequest struct {
	// The resource name of the [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to restore.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RestoreCryptoKeyVersionRequest) Reset()         { *m = RestoreCryptoKeyVersionRequest{} }
func (m *RestoreCryptoKeyVersionRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreCryptoKeyVersionRequest) ProtoMessage()    {}
func (*RestoreCryptoKeyVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{25}
}

func (m *RestoreCryptoKeyVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreCryptoKeyVersionRequest.Unmarshal(m, b)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreCryptoKeyVersionRequest.Marshal(b, m, deterministic)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreCryptoKeyVersionRequest.Merge(m, src)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreCryptoKeyVersionRequest.Size(m)
}
func (m *RestoreCryptoKeyVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreCryptoKeyVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreCryptoKeyVersionRequest proto.InternalMessageInfo

func (m *RestoreCryptoKeyVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A [Digest][google.cloud.kms.v1.Digest] holds a cryptographic message digest.
type Digest struct {
	// Required. The message digest.
	//
	// Types that are valid to be assigned to Digest:
	//	*Digest_Sha256
	//	*Digest_Sha384
	//	*Digest_Sha512
	Digest               isDigest_Digest `protobuf_oneof:"digest"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Digest) Reset()         { *m = Digest{} }
func (m *Digest) String() string { return proto.CompactTextString(m) }
func (*Digest) ProtoMessage()    {}
func (*Digest) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{26}
}

func (m *Digest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Digest.Unmarshal(m, b)
}
func (m *Digest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Digest.Marshal(b, m, deterministic)
}
func (m *Digest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Digest.Merge(m, src)
}
func (m *Digest) XXX_Size() int {
	return xxx_messageInfo_Digest.Size(m)
}
func (m *Digest) XXX_DiscardUnknown() {
	xxx_messageInfo_Digest.DiscardUnknown(m)
}

var xxx_messageInfo_Digest proto.InternalMessageInfo

type isDigest_Digest interface {
	isDigest_Digest()
}

type Digest_Sha256 struct {
	Sha256 []byte `protobuf:"bytes,1,opt,name=sha256,proto3,oneof"`
}

type Digest_Sha384 struct {
	Sha384 []byte `protobuf:"bytes,2,opt,name=sha384,proto3,oneof"`
}

type Digest_Sha512 struct {
	Sha512 []byte `protobuf:"bytes,3,opt,name=sha512,proto3,oneof"`
}

func (*Digest_Sha256) isDigest_Digest() {}

func (*Digest_Sha384) isDigest_Digest() {}

func (*Digest_Sha512) isDigest_Digest() {}

func (m *Digest) GetDigest() isDigest_Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

func (m *Digest) GetSha256() []byte {
	if x, ok := m.GetDigest().(*Digest_Sha256); ok {
		return x.Sha256
	}
	return nil
}

func (m *Digest) GetSha384() []byte {
	if x, ok := m.GetDigest().(*Digest_Sha384); ok {
		return x.Sha384
	}
	return nil
}

func (m *Digest) GetSha512() []byte {
	if x, ok := m.GetDigest().(*Digest_Sha512); ok {
		return x.Sha512
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Digest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Digest_OneofMarshaler, _Digest_OneofUnmarshaler, _Digest_OneofSizer, []interface{}{
		(*Digest_Sha256)(nil),
		(*Digest_Sha384)(nil),
		(*Digest_Sha512)(nil),
	}
}

func _Digest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Digest)
	// digest
	switch x := m.Digest.(type) {
	case *Digest_Sha256:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Sha256)
	case *Digest_Sha384:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Sha384)
	case *Digest_Sha512:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Sha512)
	case nil:
	default:
		return fmt.Errorf("Digest.Digest has unexpected type %T", x)
	}
	return nil
}

func _Digest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Digest)
	switch tag {
	case 1: // digest.sha256
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Digest = &Digest_Sha256{x}
		return true, err
	case 2: // digest.sha384
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Digest = &Digest_Sha384{x}
		return true, err
	case 3: // digest.sha512
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Digest = &Digest_Sha512{x}
		return true, err
	default:
		return false, nil
	}
}

func _Digest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Digest)
	// digest
	switch x := m.Digest.(type) {
	case *Digest_Sha256:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Sha256)))
		n += len(x.Sha256)
	case *Digest_Sha384:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Sha384)))
		n += len(x.Sha384)
	case *Digest_Sha512:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Sha512)))
		n += len(x.Sha512)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Cloud KMS metadata for the given [google.cloud.location.Location][google.cloud.location.Location].
type LocationMetadata struct {
	// Indicates whether [CryptoKeys][google.cloud.kms.v1.CryptoKey] with
	// [protection_level][google.cloud.kms.v1.CryptoKeyVersionTemplate.protection_level]
	// [HSM][google.cloud.kms.v1.ProtectionLevel.HSM] can be created in this location.
	HsmAvailable         bool     `protobuf:"varint,1,opt,name=hsm_available,json=hsmAvailable,proto3" json:"hsm_available,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LocationMetadata) Reset()         { *m = LocationMetadata{} }
func (m *LocationMetadata) String() string { return proto.CompactTextString(m) }
func (*LocationMetadata) ProtoMessage()    {}
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_723aeaeb61739a25, []int{27}
}

func (m *LocationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationMetadata.Unmarshal(m, b)
}
func (m *LocationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationMetadata.Marshal(b, m, deterministic)
}
func (m *LocationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationMetadata.Merge(m, src)
}
func (m *LocationMetadata) XXX_Size() int {
	return xxx_messageInfo_LocationMetadata.Size(m)
}
func (m *LocationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LocationMetadata proto.InternalMessageInfo

func (m *LocationMetadata) GetHsmAvailable() bool {
	if m != nil {
		return m.HsmAvailable
	}
	return false
}

func init() {
	proto.RegisterType((*ListKeyRingsRequest)(nil), "google.cloud.kms.v1.ListKeyRingsRequest")
	proto.RegisterType((*ListCryptoKeysRequest)(nil), "google.cloud.kms.v1.ListCryptoKeysRequest")
	proto.RegisterType((*ListCryptoKeyVersionsRequest)(nil), "google.cloud.kms.v1.ListCryptoKeyVersionsRequest")
	proto.RegisterType((*ListKeyRingsResponse)(nil), "google.cloud.kms.v1.ListKeyRingsResponse")
	proto.RegisterType((*ListCryptoKeysResponse)(nil), "google.cloud.kms.v1.ListCryptoKeysResponse")
	proto.RegisterType((*ListCryptoKeyVersionsResponse)(nil), "google.cloud.kms.v1.ListCryptoKeyVersionsResponse")
	proto.RegisterType((*GetKeyRingRequest)(nil), "google.cloud.kms.v1.GetKeyRingRequest")
	proto.RegisterType((*GetCryptoKeyRequest)(nil), "google.cloud.kms.v1.GetCryptoKeyRequest")
	proto.RegisterType((*GetCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.GetCryptoKeyVersionRequest")
	proto.RegisterType((*GetPublicKeyRequest)(nil), "google.cloud.kms.v1.GetPublicKeyRequest")
	proto.RegisterType((*CreateKeyRingRequest)(nil), "google.cloud.kms.v1.CreateKeyRingRequest")
	proto.RegisterType((*CreateCryptoKeyRequest)(nil), "google.cloud.kms.v1.CreateCryptoKeyRequest")
	proto.RegisterType((*CreateCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.CreateCryptoKeyVersionRequest")
	proto.RegisterType((*UpdateCryptoKeyRequest)(nil), "google.cloud.kms.v1.UpdateCryptoKeyRequest")
	proto.RegisterType((*UpdateCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.UpdateCryptoKeyVersionRequest")
	proto.RegisterType((*EncryptRequest)(nil), "google.cloud.kms.v1.EncryptRequest")
	proto.RegisterType((*DecryptRequest)(nil), "google.cloud.kms.v1.DecryptRequest")
	proto.RegisterType((*AsymmetricSignRequest)(nil), "google.cloud.kms.v1.AsymmetricSignRequest")
	proto.RegisterType((*AsymmetricDecryptRequest)(nil), "google.cloud.kms.v1.AsymmetricDecryptRequest")
	proto.RegisterType((*DecryptResponse)(nil), "google.cloud.kms.v1.DecryptResponse")
	proto.RegisterType((*EncryptResponse)(nil), "google.cloud.kms.v1.EncryptResponse")
	proto.RegisterType((*AsymmetricSignResponse)(nil), "google.cloud.kms.v1.AsymmetricSignResponse")
	proto.RegisterType((*AsymmetricDecryptResponse)(nil), "google.cloud.kms.v1.AsymmetricDecryptResponse")
	proto.RegisterType((*UpdateCryptoKeyPrimaryVersionRequest)(nil), "google.cloud.kms.v1.UpdateCryptoKeyPrimaryVersionRequest")
	proto.RegisterType((*DestroyCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.DestroyCryptoKeyVersionRequest")
	proto.RegisterType((*RestoreCryptoKeyVersionRequest)(nil), "google.cloud.kms.v1.RestoreCryptoKeyVersionRequest")
	proto.RegisterType((*Digest)(nil), "google.cloud.kms.v1.Digest")
	proto.RegisterType((*LocationMetadata)(nil), "google.cloud.kms.v1.LocationMetadata")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// KeyManagementServiceClient is the client API for KeyManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KeyManagementServiceClient interface {
	// Lists [KeyRings][google.cloud.kms.v1.KeyRing].
	ListKeyRings(ctx context.Context, in *ListKeyRingsRequest, opts ...grpc.CallOption) (*ListKeyRingsResponse, error)
	// Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	ListCryptoKeys(ctx context.Context, in *ListCryptoKeysRequest, opts ...grpc.CallOption) (*ListCryptoKeysResponse, error)
	// Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	ListCryptoKeyVersions(ctx context.Context, in *ListCryptoKeyVersionsRequest, opts ...grpc.CallOption) (*ListCryptoKeyVersionsResponse, error)
	// Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
	GetKeyRing(ctx context.Context, in *GetKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error)
	// Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey], as well as its
	// [primary][google.cloud.kms.v1.CryptoKey.primary] [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKey(ctx context.Context, in *GetCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Returns metadata for a given [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKeyVersion(ctx context.Context, in *GetCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Returns the public key for the given [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN] or
	// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
	GetPublicKey(ctx context.Context, in *GetPublicKeyRequest, opts ...grpc.CallOption) (*PublicKey, error)
	// Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and Location.
	CreateKeyRing(ctx context.Context, in *CreateKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error)
	// Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] and
	// [CryptoKey.version_template.algorithm][google.cloud.kms.v1.CryptoKeyVersionTemplate.algorithm]
	// are required.
	CreateCryptoKey(ctx context.Context, in *CreateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	//
	// The server will assign the next sequential id. If unset,
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
	CreateCryptoKeyVersion(ctx context.Context, in *CreateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	UpdateCryptoKey(ctx context.Context, in *UpdateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s metadata.
	//
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] and
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED] using this
	// method. See [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion] and [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] to
	// move between other states.
	UpdateCryptoKeyVersion(ctx context.Context, in *UpdateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Encrypts data, so that it can only be recovered by a call to [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
	// The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Encrypt(ctx context.Context, in *EncryptRequest, opts ...grpc.CallOption) (*EncryptResponse, error)
	// Decrypts data that was protected by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]. The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// must be [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Decrypt(ctx context.Context, in *DecryptRequest, opts ...grpc.CallOption) (*DecryptResponse, error)
	// Signs data using a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// ASYMMETRIC_SIGN, producing a signature that can be verified with the public
	// key retrieved from [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
	AsymmetricSign(ctx context.Context, in *AsymmetricSignRequest, opts ...grpc.CallOption) (*AsymmetricSignResponse, error)
	// Decrypts data that was encrypted with a public key retrieved from
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey] corresponding to a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] ASYMMETRIC_DECRYPT.
	AsymmetricDecrypt(ctx context.Context, in *AsymmetricDecryptRequest, opts ...grpc.CallOption) (*AsymmetricDecryptResponse, error)
	// Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that will be used in [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
	//
	// Returns an error if called on an asymmetric key.
	UpdateCryptoKeyPrimaryVersion(ctx context.Context, in *UpdateCryptoKeyPrimaryVersionRequest, opts ...grpc.CallOption) (*CryptoKey, error)
	// Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for destruction.
	//
	// Upon calling this method, [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be set to a time 24
	// hours in the future, at which point the [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be changed to
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED], and the key
	// material will be irrevocably destroyed.
	//
	// Before the [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is reached,
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] may be called to reverse the process.
	DestroyCryptoKeyVersion(ctx context.Context, in *DestroyCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
	// Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// state.
	//
	// Upon restoration of the CryptoKeyVersion, [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be set to [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be cleared.
	RestoreCryptoKeyVersion(ctx context.Context, in *RestoreCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error)
}

type keyManagementServiceClient struct {
	cc *grpc.ClientConn
}

func NewKeyManagementServiceClient(cc *grpc.ClientConn) KeyManagementServiceClient {
	return &keyManagementServiceClient{cc}
}

func (c *keyManagementServiceClient) ListKeyRings(ctx context.Context, in *ListKeyRingsRequest, opts ...grpc.CallOption) (*ListKeyRingsResponse, error) {
	out := new(ListKeyRingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ListKeyRings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ListCryptoKeys(ctx context.Context, in *ListCryptoKeysRequest, opts ...grpc.CallOption) (*ListCryptoKeysResponse, error) {
	out := new(ListCryptoKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) ListCryptoKeyVersions(ctx context.Context, in *ListCryptoKeyVersionsRequest, opts ...grpc.CallOption) (*ListCryptoKeyVersionsResponse, error) {
	out := new(ListCryptoKeyVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeyVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetKeyRing(ctx context.Context, in *GetKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error) {
	out := new(KeyRing)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetKeyRing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetCryptoKey(ctx context.Context, in *GetCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetCryptoKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetCryptoKeyVersion(ctx context.Context, in *GetCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) GetPublicKey(ctx context.Context, in *GetPublicKeyRequest, opts ...grpc.CallOption) (*PublicKey, error) {
	out := new(PublicKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/GetPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateKeyRing(ctx context.Context, in *CreateKeyRingRequest, opts ...grpc.CallOption) (*KeyRing, error) {
	out := new(KeyRing)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/CreateKeyRing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateCryptoKey(ctx context.Context, in *CreateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) CreateCryptoKeyVersion(ctx context.Context, in *CreateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKey(ctx context.Context, in *UpdateCryptoKeyRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKeyVersion(ctx context.Context, in *UpdateCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) Encrypt(ctx context.Context, in *EncryptRequest, opts ...grpc.CallOption) (*EncryptResponse, error) {
	out := new(EncryptResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/Encrypt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) Decrypt(ctx context.Context, in *DecryptRequest, opts ...grpc.CallOption) (*DecryptResponse, error) {
	out := new(DecryptResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/Decrypt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) AsymmetricSign(ctx context.Context, in *AsymmetricSignRequest, opts ...grpc.CallOption) (*AsymmetricSignResponse, error) {
	out := new(AsymmetricSignResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/AsymmetricSign", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) AsymmetricDecrypt(ctx context.Context, in *AsymmetricDecryptRequest, opts ...grpc.CallOption) (*AsymmetricDecryptResponse, error) {
	out := new(AsymmetricDecryptResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/AsymmetricDecrypt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) UpdateCryptoKeyPrimaryVersion(ctx context.Context, in *UpdateCryptoKeyPrimaryVersionRequest, opts ...grpc.CallOption) (*CryptoKey, error) {
	out := new(CryptoKey)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyPrimaryVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) DestroyCryptoKeyVersion(ctx context.Context, in *DestroyCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/DestroyCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyManagementServiceClient) RestoreCryptoKeyVersion(ctx context.Context, in *RestoreCryptoKeyVersionRequest, opts ...grpc.CallOption) (*CryptoKeyVersion, error) {
	out := new(CryptoKeyVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.kms.v1.KeyManagementService/RestoreCryptoKeyVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeyManagementServiceServer is the server API for KeyManagementService service.
type KeyManagementServiceServer interface {
	// Lists [KeyRings][google.cloud.kms.v1.KeyRing].
	ListKeyRings(context.Context, *ListKeyRingsRequest) (*ListKeyRingsResponse, error)
	// Lists [CryptoKeys][google.cloud.kms.v1.CryptoKey].
	ListCryptoKeys(context.Context, *ListCryptoKeysRequest) (*ListCryptoKeysResponse, error)
	// Lists [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion].
	ListCryptoKeyVersions(context.Context, *ListCryptoKeyVersionsRequest) (*ListCryptoKeyVersionsResponse, error)
	// Returns metadata for a given [KeyRing][google.cloud.kms.v1.KeyRing].
	GetKeyRing(context.Context, *GetKeyRingRequest) (*KeyRing, error)
	// Returns metadata for a given [CryptoKey][google.cloud.kms.v1.CryptoKey], as well as its
	// [primary][google.cloud.kms.v1.CryptoKey.primary] [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKey(context.Context, *GetCryptoKeyRequest) (*CryptoKey, error)
	// Returns metadata for a given [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	GetCryptoKeyVersion(context.Context, *GetCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Returns the public key for the given [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. The
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN] or
	// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
	GetPublicKey(context.Context, *GetPublicKeyRequest) (*PublicKey, error)
	// Create a new [KeyRing][google.cloud.kms.v1.KeyRing] in a given Project and Location.
	CreateKeyRing(context.Context, *CreateKeyRingRequest) (*KeyRing, error)
	// Create a new [CryptoKey][google.cloud.kms.v1.CryptoKey] within a [KeyRing][google.cloud.kms.v1.KeyRing].
	//
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] and
	// [CryptoKey.version_template.algorithm][google.cloud.kms.v1.CryptoKeyVersionTemplate.algorithm]
	// are required.
	CreateCryptoKey(context.Context, *CreateCryptoKeyRequest) (*CryptoKey, error)
	// Create a new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	//
	// The server will assign the next sequential id. If unset,
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED].
	CreateCryptoKeyVersion(context.Context, *CreateCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Update a [CryptoKey][google.cloud.kms.v1.CryptoKey].
	UpdateCryptoKey(context.Context, *UpdateCryptoKeyRequest) (*CryptoKey, error)
	// Update a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s metadata.
	//
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] may be changed between
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED] and
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED] using this
	// method. See [DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion] and [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] to
	// move between other states.
	UpdateCryptoKeyVersion(context.Context, *UpdateCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Encrypts data, so that it can only be recovered by a call to [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
	// The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] must be
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Encrypt(context.Context, *EncryptRequest) (*EncryptResponse, error)
	// Decrypts data that was protected by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt]. The [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// must be [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Decrypt(context.Context, *DecryptRequest) (*DecryptResponse, error)
	// Signs data using a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// ASYMMETRIC_SIGN, producing a signature that can be verified with the public
	// key retrieved from [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
	AsymmetricSign(context.Context, *AsymmetricSignRequest) (*AsymmetricSignResponse, error)
	// Decrypts data that was encrypted with a public key retrieved from
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey] corresponding to a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] with
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] ASYMMETRIC_DECRYPT.
	AsymmetricDecrypt(context.Context, *AsymmetricDecryptRequest) (*AsymmetricDecryptResponse, error)
	// Update the version of a [CryptoKey][google.cloud.kms.v1.CryptoKey] that will be used in [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
	//
	// Returns an error if called on an asymmetric key.
	UpdateCryptoKeyPrimaryVersion(context.Context, *UpdateCryptoKeyPrimaryVersionRequest) (*CryptoKey, error)
	// Schedule a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] for destruction.
	//
	// Upon calling this method, [CryptoKeyVersion.state][google.cloud.kms.v1.CryptoKeyVersion.state] will be set to
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be set to a time 24
	// hours in the future, at which point the [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be changed to
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED], and the key
	// material will be irrevocably destroyed.
	//
	// Before the [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] is reached,
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion] may be called to reverse the process.
	DestroyCryptoKeyVersion(context.Context, *DestroyCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
	// Restore a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED]
	// state.
	//
	// Upon restoration of the CryptoKeyVersion, [state][google.cloud.kms.v1.CryptoKeyVersion.state]
	// will be set to [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED],
	// and [destroy_time][google.cloud.kms.v1.CryptoKeyVersion.destroy_time] will be cleared.
	RestoreCryptoKeyVersion(context.Context, *RestoreCryptoKeyVersionRequest) (*CryptoKeyVersion, error)
}

func RegisterKeyManagementServiceServer(s *grpc.Server, srv KeyManagementServiceServer) {
	s.RegisterService(&_KeyManagementService_serviceDesc, srv)
}

func _KeyManagementService_ListKeyRings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeyRingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListKeyRings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ListKeyRings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListKeyRings(ctx, req.(*ListKeyRingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ListCryptoKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCryptoKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListCryptoKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListCryptoKeys(ctx, req.(*ListCryptoKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_ListCryptoKeyVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCryptoKeyVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).ListCryptoKeyVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/ListCryptoKeyVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).ListCryptoKeyVersions(ctx, req.(*ListCryptoKeyVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetKeyRing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetKeyRing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetKeyRing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetKeyRing(ctx, req.(*GetKeyRingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetCryptoKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetCryptoKey(ctx, req.(*GetCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetCryptoKeyVersion(ctx, req.(*GetCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_GetPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).GetPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/GetPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).GetPublicKey(ctx, req.(*GetPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateKeyRing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateKeyRing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/CreateKeyRing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateKeyRing(ctx, req.(*CreateKeyRingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateCryptoKey(ctx, req.(*CreateCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_CreateCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).CreateCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/CreateCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).CreateCryptoKeyVersion(ctx, req.(*CreateCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKey(ctx, req.(*UpdateCryptoKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyVersion(ctx, req.(*UpdateCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_Encrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EncryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).Encrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/Encrypt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).Encrypt(ctx, req.(*EncryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_Decrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DecryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).Decrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/Decrypt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).Decrypt(ctx, req.(*DecryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_AsymmetricSign_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsymmetricSignRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).AsymmetricSign(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/AsymmetricSign",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).AsymmetricSign(ctx, req.(*AsymmetricSignRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_AsymmetricDecrypt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsymmetricDecryptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).AsymmetricDecrypt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/AsymmetricDecrypt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).AsymmetricDecrypt(ctx, req.(*AsymmetricDecryptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_UpdateCryptoKeyPrimaryVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCryptoKeyPrimaryVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyPrimaryVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/UpdateCryptoKeyPrimaryVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).UpdateCryptoKeyPrimaryVersion(ctx, req.(*UpdateCryptoKeyPrimaryVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_DestroyCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).DestroyCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/DestroyCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).DestroyCryptoKeyVersion(ctx, req.(*DestroyCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyManagementService_RestoreCryptoKeyVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreCryptoKeyVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyManagementServiceServer).RestoreCryptoKeyVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.kms.v1.KeyManagementService/RestoreCryptoKeyVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyManagementServiceServer).RestoreCryptoKeyVersion(ctx, req.(*RestoreCryptoKeyVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _KeyManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.v1.KeyManagementService",
	HandlerType: (*KeyManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListKeyRings",
			Handler:    _KeyManagementService_ListKeyRings_Handler,
		},
		{
			MethodName: "ListCryptoKeys",
			Handler:    _KeyManagementService_ListCryptoKeys_Handler,
		},
		{
			MethodName: "ListCryptoKeyVersions",
			Handler:    _KeyManagementService_ListCryptoKeyVersions_Handler,
		},
		{
			MethodName: "GetKeyRing",
			Handler:    _KeyManagementService_GetKeyRing_Handler,
		},
		{
			MethodName: "GetCryptoKey",
			Handler:    _KeyManagementService_GetCryptoKey_Handler,
		},
		{
			MethodName: "GetCryptoKeyVersion",
			Handler:    _KeyManagementService_GetCryptoKeyVersion_Handler,
		},
		{
			MethodName: "GetPublicKey",
			Handler:    _KeyManagementService_GetPublicKey_Handler,
		},
		{
			MethodName: "CreateKeyRing",
			Handler:    _KeyManagementService_CreateKeyRing_Handler,
		},
		{
			MethodName: "CreateCryptoKey",
			Handler:    _KeyManagementService_CreateCryptoKey_Handler,
		},
		{
			MethodName: "CreateCryptoKeyVersion",
			Handler:    _KeyManagementService_CreateCryptoKeyVersion_Handler,
		},
		{
			MethodName: "UpdateCryptoKey",
			Handler:    _KeyManagementService_UpdateCryptoKey_Handler,
		},
		{
			MethodName: "UpdateCryptoKeyVersion",
			Handler:    _KeyManagementService_UpdateCryptoKeyVersion_Handler,
		},
		{
			MethodName: "Encrypt",
			Handler:    _KeyManagementService_Encrypt_Handler,
		},
		{
			MethodName: "Decrypt",
			Handler:    _KeyManagementService_Decrypt_Handler,
		},
		{
			MethodName: "AsymmetricSign",
			Handler:    _KeyManagementService_AsymmetricSign_Handler,
		},
		{
			MethodName: "AsymmetricDecrypt",
			Handler:    _KeyManagementService_AsymmetricDecrypt_Handler,
		},
		{
			MethodName: "UpdateCryptoKeyPrimaryVersion",
			Handler:    _KeyManagementService_UpdateCryptoKeyPrimaryVersion_Handler,
		},
		{
			MethodName: "DestroyCryptoKeyVersion",
			Handler:    _KeyManagementService_DestroyCryptoKeyVersion_Handler,
		},
		{
			MethodName: "RestoreCryptoKeyVersion",
			Handler:    _KeyManagementService_RestoreCryptoKeyVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/v1/service.proto",
}

func init() { proto.RegisterFile("google/cloud/kms/v1/service.proto", fileDescriptor_723aeaeb61739a25) }

var fileDescriptor_723aeaeb61739a25 = []byte{
	// 1666 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0xcd, 0x73, 0x1b, 0xc5,
	0x12, 0x7f, 0x63, 0xe7, 0x39, 0x76, 0xfb, 0x2b, 0x19, 0x27, 0x8e, 0x9f, 0x62, 0xbb, 0xfc, 0x26,
	0x79, 0x79, 0x8e, 0x03, 0x12, 0x92, 0x9d, 0x0f, 0x2b, 0x15, 0x28, 0x3b, 0x4e, 0x4c, 0xca, 0x71,
	0x70, 0xad, 0xb1, 0x21, 0x29, 0x53, 0xf2, 0x58, 0x3b, 0x91, 0x37, 0xd2, 0xee, 0x8a, 0xdd, 0x95,
	0x12, 0x05, 0x72, 0xe1, 0x00, 0x39, 0xe4, 0x16, 0x0e, 0xa1, 0xb8, 0x50, 0x70, 0xa3, 0xe0, 0xc0,
	0x0d, 0x0e, 0x5c, 0x28, 0x4e, 0xa9, 0xe2, 0x02, 0x95, 0xe2, 0x96, 0x13, 0xff, 0x00, 0x37, 0x8e,
	0xd4, 0xce, 0xce, 0xae, 0xb4, 0xab, 0x5d, 0x7d, 0x45, 0x29, 0x6e, 0xde, 0x99, 0x9e, 0x9e, 0xdf,
	0xaf, 0xfb, 0x37, 0x33, 0xdd, 0x32, 0xfc, 0x37, 0xa7, 0xeb, 0xb9, 0x02, 0x4b, 0x64, 0x0b, 0x7a,
	0x49, 0x4e, 0xe4, 0x55, 0x33, 0x51, 0x4e, 0x26, 0x4c, 0x66, 0x94, 0x95, 0x2c, 0x8b, 0x17, 0x0d,
	0xdd, 0xd2, 0xf1, 0x98, 0x63, 0x12, 0xe7, 0x26, 0xf1, 0xbc, 0x6a, 0xc6, 0xcb, 0xc9, 0xd8, 0xa4,
	0x58, 0x47, 0x8b, 0x4a, 0x82, 0x6a, 0x9a, 0x6e, 0x51, 0x4b, 0xd1, 0x35, 0xd3, 0x59, 0x12, 0x3b,
	0x11, 0xe6, 0xd5, 0x60, 0xa6, 0x5e, 0x32, 0xb2, 0xcc, 0x35, 0x9a, 0x11, 0x46, 0xfc, 0x6b, 0xaf,
	0x74, 0x3b, 0x71, 0x5b, 0x61, 0x05, 0x39, 0xa3, 0x52, 0x33, 0x2f, 0x2c, 0x26, 0x83, 0x16, 0xa6,
	0x65, 0x94, 0xb2, 0x96, 0x98, 0x9d, 0x0e, 0xce, 0xde, 0x35, 0x68, 0xb1, 0xc8, 0x0c, 0xe1, 0x9f,
	0x28, 0x30, 0x76, 0x5d, 0x31, 0xad, 0x35, 0x56, 0x91, 0x14, 0x2d, 0x67, 0x4a, 0xec, 0xfd, 0x12,
	0x33, 0x2d, 0x3c, 0x0e, 0x7d, 0x45, 0x6a, 0x30, 0xcd, 0x9a, 0x40, 0x33, 0x68, 0x76, 0x40, 0x12,
	0x5f, 0xf8, 0x38, 0x0c, 0x14, 0x69, 0x8e, 0x65, 0x4c, 0xe5, 0x3e, 0x9b, 0xe8, 0x99, 0x41, 0xb3,
	0xff, 0x96, 0xfa, 0xed, 0x81, 0x4d, 0xe5, 0x3e, 0xc3, 0x53, 0x00, 0x7c, 0xd2, 0xd2, 0xf3, 0x4c,
	0x9b, 0xe8, 0xe5, 0x0b, 0xb9, 0xf9, 0xdb, 0xf6, 0x00, 0x79, 0x8a, 0xe0, 0xa8, 0xbd, 0xd7, 0x65,
	0xa3, 0x52, 0xb4, 0xf4, 0x35, 0x56, 0x79, 0x99, 0xbb, 0xe1, 0xf7, 0x60, 0xa8, 0xcc, 0x0c, 0x53,
	0xd1, 0xb5, 0x4c, 0x59, 0x61, 0x77, 0x27, 0x0e, 0xcc, 0xa0, 0xd9, 0x91, 0x54, 0x3a, 0x1e, 0x92,
	0xa7, 0xb8, 0x87, 0x68, 0xdb, 0x59, 0x51, 0x37, 0xb0, 0xad, 0xb0, 0xbb, 0xd2, 0x60, 0xb9, 0xfa,
	0x41, 0x7e, 0x42, 0x30, 0xe9, 0x23, 0x23, 0x2c, 0x5f, 0x2a, 0xa7, 0x1b, 0x70, 0xa0, 0x4b, 0x5c,
	0xb8, 0x1f, 0xf2, 0x04, 0xc1, 0x11, 0x7f, 0xf6, 0xcd, 0xa2, 0xae, 0x99, 0x0c, 0x2f, 0xc2, 0x40,
	0x9e, 0x55, 0x32, 0x86, 0x3d, 0x38, 0x81, 0x66, 0x7a, 0x67, 0x07, 0x53, 0x93, 0xa1, 0xbb, 0x89,
	0x95, 0x52, 0x7f, 0x5e, 0xb8, 0xc0, 0xa7, 0x60, 0x54, 0x63, 0xf7, 0xac, 0x4c, 0x0d, 0x8f, 0x1e,
	0xce, 0x63, 0xd8, 0x1e, 0xde, 0xf0, 0xb8, 0x4c, 0x01, 0x58, 0xba, 0x45, 0x0b, 0x4e, 0x20, 0x7a,
	0x79, 0x20, 0x06, 0xf8, 0x88, 0x1d, 0x09, 0xf2, 0x05, 0x82, 0xf1, 0xa0, 0x58, 0x04, 0xb8, 0x37,
	0x60, 0x30, 0xcb, 0x47, 0x33, 0x79, 0x56, 0x71, 0xe1, 0x4d, 0x37, 0x0e, 0x86, 0x04, 0x59, 0xcf,
	0x51, 0xb7, 0x20, 0xfe, 0x88, 0x60, 0x2a, 0x42, 0x02, 0x02, 0xe9, 0x16, 0x8c, 0x55, 0x91, 0x66,
	0x84, 0x7c, 0x5c, 0xc4, 0xff, 0x6b, 0x29, 0x7d, 0xd2, 0xe1, 0x6c, 0xd0, 0x7d, 0xb7, 0xf0, 0xff,
	0x1f, 0x0e, 0xaf, 0x32, 0x37, 0xf7, 0xae, 0x6c, 0x31, 0x1c, 0xd0, 0xa8, 0xca, 0x84, 0x68, 0xf9,
	0xdf, 0xe4, 0x34, 0x8c, 0xad, 0xb2, 0x2a, 0xcd, 0x46, 0xa6, 0xaf, 0x41, 0xac, 0xd6, 0xd4, 0x25,
	0xd1, 0xd4, 0xf9, 0x46, 0x69, 0xaf, 0xa0, 0x64, 0x9b, 0x38, 0xff, 0x04, 0xc1, 0x91, 0xcb, 0x06,
	0xa3, 0x16, 0x0b, 0x80, 0x8e, 0x3a, 0x6b, 0xd3, 0x30, 0xe8, 0xca, 0x38, 0xa3, 0xc8, 0x22, 0x48,
	0x03, 0x42, 0xaa, 0xd7, 0x64, 0x7c, 0x1e, 0xfa, 0xdd, 0x79, 0x1e, 0x9e, 0x66, 0x2a, 0x3f, 0x28,
	0x96, 0x92, 0xc7, 0x08, 0xc6, 0x1d, 0x24, 0x75, 0x51, 0x89, 0xc2, 0x42, 0x60, 0xb8, 0x46, 0x0b,
	0x1e, 0x9a, 0x41, 0x2f, 0xbd, 0xd7, 0x64, 0x7c, 0x09, 0xa0, 0x6a, 0x23, 0x10, 0x35, 0x13, 0xf6,
	0x80, 0xe7, 0x80, 0x3c, 0x42, 0x30, 0x15, 0x40, 0x15, 0x48, 0x40, 0x14, 0xb8, 0x4d, 0xc0, 0xf5,
	0x42, 0xe5, 0x08, 0x5b, 0xd6, 0xe9, 0xa1, 0xa0, 0x4e, 0xc9, 0xa7, 0x08, 0xc6, 0xb7, 0x8a, 0x72,
	0x58, 0x90, 0xfc, 0x44, 0x51, 0x9b, 0x44, 0xf1, 0x45, 0x18, 0x2c, 0x71, 0xc7, 0xfc, 0x1d, 0x14,
	0x38, 0x63, 0xee, 0x7a, 0xf7, 0xa9, 0x8b, 0x5f, 0xb5, 0x9f, 0xca, 0x75, 0x6a, 0xe6, 0x25, 0x70,
	0xcc, 0xed, 0xbf, 0xc9, 0x77, 0x08, 0xa6, 0x02, 0xb0, 0x02, 0x51, 0x0a, 0x8f, 0x06, 0x7a, 0xa1,
	0x68, 0xbc, 0x18, 0xe6, 0x8f, 0x11, 0x8c, 0x5c, 0xd1, 0xb8, 0xcf, 0x06, 0x07, 0x04, 0x4f, 0xc2,
	0x40, 0xb1, 0x40, 0x15, 0xcd, 0x62, 0xf7, 0x2c, 0xbe, 0xc3, 0x90, 0x54, 0x1d, 0xc0, 0xcb, 0x30,
	0x45, 0x65, 0x59, 0xb1, 0x4b, 0x10, 0x5a, 0xc8, 0xd0, 0x92, 0xb5, 0xcf, 0x34, 0x4b, 0xc9, 0x52,
	0x8b, 0xc9, 0x19, 0x99, 0x5a, 0x94, 0x0b, 0x6e, 0x48, 0x3a, 0x5e, 0x35, 0x5a, 0xaa, 0xb5, 0x59,
	0xa1, 0x16, 0x25, 0x0f, 0x11, 0x8c, 0xac, 0xb0, 0xa6, 0x40, 0xa6, 0x01, 0xb2, 0x4a, 0x71, 0x9f,
	0x19, 0x35, 0x48, 0x6a, 0x46, 0xba, 0x02, 0x65, 0x17, 0x8e, 0x2e, 0x99, 0x15, 0x55, 0x65, 0x96,
	0xa1, 0x64, 0x37, 0x95, 0x5c, 0xa3, 0x5b, 0x06, 0xcf, 0x43, 0x9f, 0xac, 0xe4, 0x98, 0x69, 0x89,
	0x53, 0x75, 0x3c, 0x34, 0x8d, 0x2b, 0xdc, 0x44, 0x12, 0xa6, 0xe4, 0x06, 0x4c, 0x54, 0x77, 0x68,
	0x9b, 0x75, 0x6f, 0x90, 0x35, 0x49, 0xc0, 0xa8, 0xe7, 0x45, 0xbc, 0x10, 0xbe, 0x8c, 0xa1, 0x40,
	0xc6, 0xc8, 0x15, 0x18, 0xf5, 0xb2, 0x2e, 0x16, 0x74, 0x10, 0x6d, 0x72, 0x0e, 0xc6, 0x83, 0x91,
	0xaa, 0x6e, 0x6f, 0x2a, 0x39, 0x8d, 0x5a, 0x25, 0x83, 0xb9, 0xdb, 0x7b, 0x03, 0x64, 0x11, 0xfe,
	0x13, 0xc2, 0xbf, 0x25, 0xe4, 0x2a, 0x9c, 0x0c, 0x9c, 0xb1, 0x0d, 0x43, 0x51, 0xa9, 0xd1, 0xc2,
	0x8b, 0x80, 0x93, 0x70, 0xb4, 0xfe, 0xf8, 0x55, 0x6f, 0x4c, 0x1c, 0x3c, 0x5a, 0xd7, 0x64, 0xb2,
	0x00, 0xd3, 0x2b, 0xcc, 0xb4, 0x0c, 0xbd, 0xd2, 0xce, 0xd3, 0xb3, 0x00, 0xd3, 0x12, 0x33, 0x2d,
	0xdd, 0x60, 0xed, 0xac, 0xda, 0x85, 0x3e, 0x47, 0x27, 0x78, 0x02, 0xfa, 0xcc, 0x7d, 0x9a, 0x3a,
	0x7b, 0xce, 0xe1, 0xff, 0xe6, 0xbf, 0x24, 0xf1, 0x2d, 0x66, 0xe6, 0x2f, 0x2c, 0x38, 0xd9, 0x10,
	0x33, 0xf3, 0x17, 0x16, 0xc4, 0xcc, 0xd9, 0x64, 0xca, 0xd1, 0x87, 0x98, 0x39, 0x9b, 0x4c, 0x2d,
	0xf7, 0xbb, 0x12, 0x25, 0xe7, 0xe1, 0xd0, 0x75, 0x3d, 0xcb, 0x7b, 0x85, 0x75, 0x66, 0x51, 0xfb,
	0x40, 0xe0, 0x13, 0x30, 0xbc, 0x6f, 0xaa, 0x19, 0x5a, 0xa6, 0x4a, 0x81, 0xee, 0x15, 0x1c, 0x48,
	0xfd, 0xd2, 0xd0, 0xbe, 0xa9, 0x2e, 0xb9, 0x63, 0xa9, 0x5f, 0x26, 0xe1, 0xc8, 0x1a, 0xab, 0xac,
	0x53, 0x8d, 0xe6, 0x98, 0xca, 0x34, 0x6b, 0xd3, 0xe9, 0x51, 0xf0, 0x67, 0x08, 0x86, 0x6a, 0x0b,
	0x3d, 0x3c, 0x1b, 0xaa, 0xff, 0x90, 0x4e, 0x20, 0x76, 0xba, 0x05, 0x4b, 0x47, 0x12, 0x64, 0xe1,
	0xa3, 0xdf, 0xfe, 0x78, 0xdc, 0x13, 0xc7, 0xaf, 0xd8, 0x8d, 0xcc, 0x07, 0xce, 0xd3, 0x72, 0xa9,
	0x68, 0xe8, 0x77, 0x58, 0xd6, 0x32, 0x13, 0x73, 0x89, 0x82, 0x20, 0x65, 0x26, 0xe6, 0x1e, 0x24,
	0xbc, 0x82, 0xf1, 0x1b, 0x04, 0x23, 0xfe, 0x4a, 0x0f, 0xcf, 0x45, 0xee, 0x59, 0xd7, 0x3b, 0xc4,
	0xce, 0xb4, 0x64, 0x2b, 0x10, 0x2e, 0x71, 0x84, 0x17, 0xf1, 0x62, 0x73, 0x84, 0x1e, 0x40, 0x1b,
	0x6c, 0x4d, 0xf1, 0xf8, 0x2c, 0xd8, 0xc5, 0x78, 0x65, 0x59, 0xb2, 0x39, 0x92, 0x40, 0x93, 0x10,
	0x4b, 0xb5, 0xb3, 0x44, 0x70, 0xd8, 0xe2, 0x1c, 0xde, 0xc2, 0xeb, 0x6d, 0x71, 0xa8, 0xa1, 0xe0,
	0x23, 0xe4, 0xa1, 0x7f, 0x88, 0x00, 0xaa, 0xe5, 0x20, 0x3e, 0x15, 0x8a, 0xac, 0xae, 0x5e, 0x8c,
	0x35, 0x2c, 0x98, 0x02, 0x8a, 0xb0, 0x8f, 0x4f, 0x0b, 0xd1, 0xc6, 0x9f, 0x23, 0x18, 0xaa, 0xad,
	0x22, 0x23, 0xd4, 0x1a, 0x52, 0x93, 0xc6, 0x9a, 0x14, 0x11, 0x01, 0x01, 0xb4, 0x06, 0xc8, 0x1f,
	0x3a, 0xfc, 0x33, 0xf2, 0x97, 0xc3, 0xee, 0x03, 0x9f, 0x68, 0x0a, 0xd2, 0x7f, 0xb9, 0xc4, 0x5a,
	0x2b, 0x25, 0x02, 0xf9, 0xee, 0x00, 0x72, 0x7d, 0xb2, 0x6d, 0x1a, 0x3f, 0x38, 0x41, 0xf6, 0x0a,
	0xef, 0xe8, 0x20, 0x07, 0x6b, 0xf3, 0x88, 0x20, 0x7b, 0x66, 0x24, 0xc3, 0x11, 0xdf, 0xc4, 0xef,
	0x74, 0x15, 0x71, 0xa2, 0xe8, 0x41, 0x7d, 0x82, 0x60, 0xd8, 0xd7, 0x08, 0xe0, 0xd3, 0x11, 0xb1,
	0xac, 0x6f, 0x16, 0x9a, 0x28, 0xf6, 0x75, 0x8e, 0xfd, 0x02, 0x69, 0xeb, 0x0e, 0x4b, 0x7b, 0x6d,
	0x04, 0xfe, 0x16, 0xc1, 0x68, 0xa0, 0x06, 0xc7, 0x67, 0x1a, 0x80, 0x6b, 0x5b, 0xc1, 0xeb, 0x1c,
	0xe0, 0x2a, 0xe9, 0xfc, 0x0a, 0x4b, 0xd7, 0xd4, 0xde, 0xf8, 0x79, 0x7d, 0x27, 0xe3, 0x0a, 0x3a,
	0xd5, 0x0a, 0xec, 0xce, 0x34, 0xad, 0x70, 0x12, 0x59, 0xd2, 0xdd, 0x3b, 0x2c, 0x1d, 0x52, 0xb6,
	0xe3, 0xef, 0x11, 0x8c, 0x06, 0x4a, 0x91, 0x88, 0x84, 0x84, 0xf7, 0x2a, 0x4d, 0x13, 0xf2, 0x2e,
	0xe7, 0x22, 0xa5, 0x56, 0x38, 0x97, 0x2a, 0x82, 0x78, 0x27, 0xb7, 0x8b, 0x2f, 0x37, 0x7f, 0xd6,
	0x37, 0x50, 0x8d, 0x73, 0xd3, 0xb0, 0xad, 0x69, 0x35, 0x37, 0x1f, 0x72, 0x3e, 0xe5, 0xd4, 0x6e,
	0x80, 0x8f, 0x1b, 0xd1, 0x78, 0xb7, 0x0e, 0x74, 0x68, 0xba, 0xbe, 0x42, 0x70, 0x50, 0xd4, 0xbc,
	0xf8, 0x44, 0x28, 0x60, 0x7f, 0x1f, 0x14, 0x3b, 0xd9, 0xd8, 0x48, 0x3c, 0x9a, 0xee, 0xa9, 0x59,
	0xee, 0xf4, 0x4a, 0x9a, 0x7b, 0x90, 0x66, 0x8e, 0xcf, 0x34, 0x9a, 0xc3, 0x5f, 0x22, 0x38, 0x28,
	0x0a, 0xe2, 0x08, 0x94, 0xfe, 0x76, 0x21, 0x02, 0x65, 0xa0, 0xa6, 0x26, 0xd7, 0x39, 0xca, 0xab,
	0x64, 0xa9, 0xe3, 0xd7, 0x29, 0x2d, 0x33, 0x0f, 0xe4, 0xaf, 0x08, 0x46, 0xfc, 0x75, 0x7f, 0x44,
	0x61, 0x15, 0xda, 0x46, 0x45, 0x14, 0x56, 0xe1, 0x8d, 0x04, 0xc9, 0x71, 0xe4, 0x94, 0xec, 0x74,
	0xf5, 0xca, 0x4f, 0x53, 0xdf, 0x6e, 0x36, 0xa9, 0xe7, 0x08, 0x0e, 0xd7, 0x35, 0x25, 0xf8, 0xd5,
	0x26, 0x58, 0x03, 0xd9, 0x88, 0xb7, 0x6a, 0x2e, 0xd8, 0xdd, 0xe1, 0xec, 0x64, 0x92, 0x79, 0x59,
	0xec, 0x56, 0xaa, 0x59, 0x7b, 0x56, 0xff, 0xf3, 0x84, 0xbf, 0x75, 0xc2, 0x8b, 0xad, 0x9c, 0xfd,
	0xd0, 0x76, 0xab, 0xe9, 0x5d, 0x76, 0x93, 0x13, 0xdd, 0x24, 0x37, 0x3a, 0x17, 0xa0, 0xf3, 0xab,
	0x85, 0x7f, 0x7b, 0x9b, 0xd7, 0xef, 0x08, 0x8e, 0x45, 0xf4, 0x68, 0x78, 0x3e, 0xe2, 0x74, 0x34,
	0xea, 0xe8, 0x5a, 0xbd, 0xce, 0x76, 0x39, 0xa5, 0x5b, 0x64, 0xab, 0xbb, 0xb9, 0x93, 0x1d, 0x70,
	0x2e, 0xb3, 0x88, 0x3e, 0x32, 0x82, 0x59, 0xe3, 0xae, 0xf3, 0x1f, 0x66, 0x66, 0x38, 0xe0, 0xd2,
	0x68, 0x6e, 0xf9, 0x11, 0x82, 0x63, 0x59, 0x5d, 0x0d, 0x83, 0xb3, 0xdc, 0xbf, 0xa6, 0x9a, 0x1b,
	0x86, 0x6e, 0xe9, 0x1b, 0xe8, 0xd6, 0x39, 0x61, 0x90, 0xd3, 0x0b, 0x54, 0xcb, 0xc5, 0x75, 0x23,
	0x97, 0xc8, 0x31, 0x8d, 0xff, 0xa6, 0x95, 0x70, 0xa6, 0x68, 0x51, 0x31, 0x7d, 0xff, 0xe8, 0xba,
	0x98, 0x57, 0xcd, 0xbf, 0x10, 0xfa, 0xba, 0x67, 0x6c, 0xd5, 0x59, 0x7b, 0x99, 0x3b, 0x5f, 0x53,
	0xcd, 0xf8, 0x76, 0xf2, 0xa9, 0x3b, 0xba, 0xc3, 0x47, 0x77, 0xd6, 0x54, 0x73, 0x67, 0x3b, 0xb9,
	0xd7, 0xc7, 0x3d, 0xce, 0xff, 0x1d, 0x00, 0x00, 0xff, 0xff, 0xac, 0x72, 0x95, 0x44, 0x8f, 0x1b,
	0x00, 0x00,
}
