// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package cloudbuild

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/api/httpbody"
	_ "google.golang.org/genproto/googleapis/cloud/audit"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	math "math"
)

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Possible status of a build or build step.
type Build_Status int32

const (
	// Status of the build is unknown.
	Build_STATUS_UNKNOWN Build_Status = 0
	// Build or step is queued; work has not yet begun.
	Build_QUEUED Build_Status = 1
	// Build or step is being executed.
	Build_WORKING Build_Status = 2
	// Build or step finished successfully.
	Build_SUCCESS Build_Status = 3
	// Build or step failed to complete successfully.
	Build_FAILURE Build_Status = 4
	// Build or step failed due to an internal cause.
	Build_INTERNAL_ERROR Build_Status = 5
	// Build or step took longer than was allowed.
	Build_TIMEOUT Build_Status = 6
	// Build or step was canceled by a user.
	Build_CANCELLED Build_Status = 7
)

var Build_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "QUEUED",
	2: "WORKING",
	3: "SUCCESS",
	4: "FAILURE",
	5: "INTERNAL_ERROR",
	6: "TIMEOUT",
	7: "CANCELLED",
}

var Build_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"QUEUED":         1,
	"WORKING":        2,
	"SUCCESS":        3,
	"FAILURE":        4,
	"INTERNAL_ERROR": 5,
	"TIMEOUT":        6,
	"CANCELLED":      7,
}

func (x Build_Status) String() string {
	return proto.EnumName(Build_Status_name, int32(x))
}

func (Build_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{10, 0}
}

// Specifies the hash algorithm, if any.
type Hash_HashType int32

const (
	// No hash requested.
	Hash_NONE Hash_HashType = 0
	// Use a sha256 hash.
	Hash_SHA256 Hash_HashType = 1
	// Use a md5 hash.
	Hash_MD5 Hash_HashType = 2
)

var Hash_HashType_name = map[int32]string{
	0: "NONE",
	1: "SHA256",
	2: "MD5",
}

var Hash_HashType_value = map[string]int32{
	"NONE":   0,
	"SHA256": 1,
	"MD5":    2,
}

func (x Hash_HashType) String() string {
	return proto.EnumName(Hash_HashType_name, int32(x))
}

func (Hash_HashType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{16, 0}
}

// Specifies the manner in which the build should be verified, if at all.
type BuildOptions_VerifyOption int32

const (
	// Not a verifiable build. (default)
	BuildOptions_NOT_VERIFIED BuildOptions_VerifyOption = 0
	// Verified build.
	BuildOptions_VERIFIED BuildOptions_VerifyOption = 1
)

var BuildOptions_VerifyOption_name = map[int32]string{
	0: "NOT_VERIFIED",
	1: "VERIFIED",
}

var BuildOptions_VerifyOption_value = map[string]int32{
	"NOT_VERIFIED": 0,
	"VERIFIED":     1,
}

func (x BuildOptions_VerifyOption) String() string {
	return proto.EnumName(BuildOptions_VerifyOption_name, int32(x))
}

func (BuildOptions_VerifyOption) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{30, 0}
}

// Supported VM sizes.
type BuildOptions_MachineType int32

const (
	// Standard machine type.
	BuildOptions_UNSPECIFIED BuildOptions_MachineType = 0
	// Highcpu machine with 8 CPUs.
	BuildOptions_N1_HIGHCPU_8 BuildOptions_MachineType = 1
	// Highcpu machine with 32 CPUs.
	BuildOptions_N1_HIGHCPU_32 BuildOptions_MachineType = 2
)

var BuildOptions_MachineType_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "N1_HIGHCPU_8",
	2: "N1_HIGHCPU_32",
}

var BuildOptions_MachineType_value = map[string]int32{
	"UNSPECIFIED":   0,
	"N1_HIGHCPU_8":  1,
	"N1_HIGHCPU_32": 2,
}

func (x BuildOptions_MachineType) String() string {
	return proto.EnumName(BuildOptions_MachineType_name, int32(x))
}

func (BuildOptions_MachineType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{30, 1}
}

// Specifies the behavior when there is an error in the substitution checks.
type BuildOptions_SubstitutionOption int32

const (
	// Fails the build if error in substitutions checks, like missing
	// a substitution in the template or in the map.
	BuildOptions_MUST_MATCH BuildOptions_SubstitutionOption = 0
	// Do not fail the build if error in substitutions checks.
	BuildOptions_ALLOW_LOOSE BuildOptions_SubstitutionOption = 1
)

var BuildOptions_SubstitutionOption_name = map[int32]string{
	0: "MUST_MATCH",
	1: "ALLOW_LOOSE",
}

var BuildOptions_SubstitutionOption_value = map[string]int32{
	"MUST_MATCH":  0,
	"ALLOW_LOOSE": 1,
}

func (x BuildOptions_SubstitutionOption) String() string {
	return proto.EnumName(BuildOptions_SubstitutionOption_name, int32(x))
}

func (BuildOptions_SubstitutionOption) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{30, 2}
}

// Specifies the behavior when writing build logs to Google Cloud Storage.
type BuildOptions_LogStreamingOption int32

const (
	// Service may automatically determine build log streaming behavior.
	BuildOptions_STREAM_DEFAULT BuildOptions_LogStreamingOption = 0
	// Build logs should be streamed to Google Cloud Storage.
	BuildOptions_STREAM_ON BuildOptions_LogStreamingOption = 1
	// Build logs should not be streamed to Google Cloud Storage; they will be
	// written when the build is completed.
	BuildOptions_STREAM_OFF BuildOptions_LogStreamingOption = 2
)

var BuildOptions_LogStreamingOption_name = map[int32]string{
	0: "STREAM_DEFAULT",
	1: "STREAM_ON",
	2: "STREAM_OFF",
}

var BuildOptions_LogStreamingOption_value = map[string]int32{
	"STREAM_DEFAULT": 0,
	"STREAM_ON":      1,
	"STREAM_OFF":     2,
}

func (x BuildOptions_LogStreamingOption) String() string {
	return proto.EnumName(BuildOptions_LogStreamingOption_name, int32(x))
}

func (BuildOptions_LogStreamingOption) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{30, 3}
}

// Specifies a build to retry.
type RetryBuildRequest struct {
	// ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Build ID of the original build.
	Id                   string   `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RetryBuildRequest) Reset()         { *m = RetryBuildRequest{} }
func (m *RetryBuildRequest) String() string { return proto.CompactTextString(m) }
func (*RetryBuildRequest) ProtoMessage()    {}
func (*RetryBuildRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{0}
}

func (m *RetryBuildRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RetryBuildRequest.Unmarshal(m, b)
}
func (m *RetryBuildRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RetryBuildRequest.Marshal(b, m, deterministic)
}
func (m *RetryBuildRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RetryBuildRequest.Merge(m, src)
}
func (m *RetryBuildRequest) XXX_Size() int {
	return xxx_messageInfo_RetryBuildRequest.Size(m)
}
func (m *RetryBuildRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RetryBuildRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RetryBuildRequest proto.InternalMessageInfo

func (m *RetryBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RetryBuildRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Specifies a build trigger to run and the source to use.
type RunBuildTriggerRequest struct {
	// ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// ID of the trigger.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Source to build against this trigger.
	Source               *RepoSource `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RunBuildTriggerRequest) Reset()         { *m = RunBuildTriggerRequest{} }
func (m *RunBuildTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*RunBuildTriggerRequest) ProtoMessage()    {}
func (*RunBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{1}
}

func (m *RunBuildTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunBuildTriggerRequest.Unmarshal(m, b)
}
func (m *RunBuildTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunBuildTriggerRequest.Marshal(b, m, deterministic)
}
func (m *RunBuildTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunBuildTriggerRequest.Merge(m, src)
}
func (m *RunBuildTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_RunBuildTriggerRequest.Size(m)
}
func (m *RunBuildTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunBuildTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunBuildTriggerRequest proto.InternalMessageInfo

func (m *RunBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RunBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

func (m *RunBuildTriggerRequest) GetSource() *RepoSource {
	if m != nil {
		return m.Source
	}
	return nil
}

// Location of the source in an archive file in Google Cloud Storage.
type StorageSource struct {
	// Google Cloud Storage bucket containing the source (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Google Cloud Storage object containing the source.
	//
	// This object must be a gzipped archive file (`.tar.gz`) containing source to
	// build.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Google Cloud Storage generation for the object. If the generation is
	// omitted, the latest generation will be used.
	Generation           int64    `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StorageSource) Reset()         { *m = StorageSource{} }
func (m *StorageSource) String() string { return proto.CompactTextString(m) }
func (*StorageSource) ProtoMessage()    {}
func (*StorageSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{2}
}

func (m *StorageSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageSource.Unmarshal(m, b)
}
func (m *StorageSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageSource.Marshal(b, m, deterministic)
}
func (m *StorageSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageSource.Merge(m, src)
}
func (m *StorageSource) XXX_Size() int {
	return xxx_messageInfo_StorageSource.Size(m)
}
func (m *StorageSource) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageSource.DiscardUnknown(m)
}

var xxx_messageInfo_StorageSource proto.InternalMessageInfo

func (m *StorageSource) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *StorageSource) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *StorageSource) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

// Location of the source in a Google Cloud Source Repository.
type RepoSource struct {
	// ID of the project that owns the Cloud Source Repository. If omitted, the
	// project ID requesting the build is assumed.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Name of the Cloud Source Repository. If omitted, the name "default" is
	// assumed.
	RepoName string `protobuf:"bytes,2,opt,name=repo_name,json=repoName,proto3" json:"repo_name,omitempty"`
	// A revision within the Cloud Source Repository must be specified in
	// one of these ways.
	//
	// Types that are valid to be assigned to Revision:
	//	*RepoSource_BranchName
	//	*RepoSource_TagName
	//	*RepoSource_CommitSha
	Revision isRepoSource_Revision `protobuf_oneof:"revision"`
	// Directory, relative to the source root, in which to run the build.
	//
	// This must be a relative path. If a step's `dir` is specified and is an
	// absolute path, this value is ignored for that step's execution.
	Dir                  string   `protobuf:"bytes,7,opt,name=dir,proto3" json:"dir,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RepoSource) Reset()         { *m = RepoSource{} }
func (m *RepoSource) String() string { return proto.CompactTextString(m) }
func (*RepoSource) ProtoMessage()    {}
func (*RepoSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{3}
}

func (m *RepoSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RepoSource.Unmarshal(m, b)
}
func (m *RepoSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RepoSource.Marshal(b, m, deterministic)
}
func (m *RepoSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RepoSource.Merge(m, src)
}
func (m *RepoSource) XXX_Size() int {
	return xxx_messageInfo_RepoSource.Size(m)
}
func (m *RepoSource) XXX_DiscardUnknown() {
	xxx_messageInfo_RepoSource.DiscardUnknown(m)
}

var xxx_messageInfo_RepoSource proto.InternalMessageInfo

func (m *RepoSource) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RepoSource) GetRepoName() string {
	if m != nil {
		return m.RepoName
	}
	return ""
}

type isRepoSource_Revision interface {
	isRepoSource_Revision()
}

type RepoSource_BranchName struct {
	BranchName string `protobuf:"bytes,3,opt,name=branch_name,json=branchName,proto3,oneof"`
}

type RepoSource_TagName struct {
	TagName string `protobuf:"bytes,4,opt,name=tag_name,json=tagName,proto3,oneof"`
}

type RepoSource_CommitSha struct {
	CommitSha string `protobuf:"bytes,5,opt,name=commit_sha,json=commitSha,proto3,oneof"`
}

func (*RepoSource_BranchName) isRepoSource_Revision() {}

func (*RepoSource_TagName) isRepoSource_Revision() {}

func (*RepoSource_CommitSha) isRepoSource_Revision() {}

func (m *RepoSource) GetRevision() isRepoSource_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *RepoSource) GetBranchName() string {
	if x, ok := m.GetRevision().(*RepoSource_BranchName); ok {
		return x.BranchName
	}
	return ""
}

func (m *RepoSource) GetTagName() string {
	if x, ok := m.GetRevision().(*RepoSource_TagName); ok {
		return x.TagName
	}
	return ""
}

func (m *RepoSource) GetCommitSha() string {
	if x, ok := m.GetRevision().(*RepoSource_CommitSha); ok {
		return x.CommitSha
	}
	return ""
}

func (m *RepoSource) GetDir() string {
	if m != nil {
		return m.Dir
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RepoSource) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RepoSource_OneofMarshaler, _RepoSource_OneofUnmarshaler, _RepoSource_OneofSizer, []interface{}{
		(*RepoSource_BranchName)(nil),
		(*RepoSource_TagName)(nil),
		(*RepoSource_CommitSha)(nil),
	}
}

func _RepoSource_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RepoSource)
	// revision
	switch x := m.Revision.(type) {
	case *RepoSource_BranchName:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.BranchName)
	case *RepoSource_TagName:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.TagName)
	case *RepoSource_CommitSha:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.CommitSha)
	case nil:
	default:
		return fmt.Errorf("RepoSource.Revision has unexpected type %T", x)
	}
	return nil
}

func _RepoSource_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RepoSource)
	switch tag {
	case 3: // revision.branch_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Revision = &RepoSource_BranchName{x}
		return true, err
	case 4: // revision.tag_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Revision = &RepoSource_TagName{x}
		return true, err
	case 5: // revision.commit_sha
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Revision = &RepoSource_CommitSha{x}
		return true, err
	default:
		return false, nil
	}
}

func _RepoSource_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RepoSource)
	// revision
	switch x := m.Revision.(type) {
	case *RepoSource_BranchName:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.BranchName)))
		n += len(x.BranchName)
	case *RepoSource_TagName:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.TagName)))
		n += len(x.TagName)
	case *RepoSource_CommitSha:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.CommitSha)))
		n += len(x.CommitSha)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Location of the source in a supported storage service.
type Source struct {
	// Location of source.
	//
	// Types that are valid to be assigned to Source:
	//	*Source_StorageSource
	//	*Source_RepoSource
	Source               isSource_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Source) Reset()         { *m = Source{} }
func (m *Source) String() string { return proto.CompactTextString(m) }
func (*Source) ProtoMessage()    {}
func (*Source) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{4}
}

func (m *Source) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Source.Unmarshal(m, b)
}
func (m *Source) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Source.Marshal(b, m, deterministic)
}
func (m *Source) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Source.Merge(m, src)
}
func (m *Source) XXX_Size() int {
	return xxx_messageInfo_Source.Size(m)
}
func (m *Source) XXX_DiscardUnknown() {
	xxx_messageInfo_Source.DiscardUnknown(m)
}

var xxx_messageInfo_Source proto.InternalMessageInfo

type isSource_Source interface {
	isSource_Source()
}

type Source_StorageSource struct {
	StorageSource *StorageSource `protobuf:"bytes,2,opt,name=storage_source,json=storageSource,proto3,oneof"`
}

type Source_RepoSource struct {
	RepoSource *RepoSource `protobuf:"bytes,3,opt,name=repo_source,json=repoSource,proto3,oneof"`
}

func (*Source_StorageSource) isSource_Source() {}

func (*Source_RepoSource) isSource_Source() {}

func (m *Source) GetSource() isSource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Source) GetStorageSource() *StorageSource {
	if x, ok := m.GetSource().(*Source_StorageSource); ok {
		return x.StorageSource
	}
	return nil
}

func (m *Source) GetRepoSource() *RepoSource {
	if x, ok := m.GetSource().(*Source_RepoSource); ok {
		return x.RepoSource
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Source) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Source_OneofMarshaler, _Source_OneofUnmarshaler, _Source_OneofSizer, []interface{}{
		(*Source_StorageSource)(nil),
		(*Source_RepoSource)(nil),
	}
}

func _Source_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Source)
	// source
	switch x := m.Source.(type) {
	case *Source_StorageSource:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StorageSource); err != nil {
			return err
		}
	case *Source_RepoSource:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RepoSource); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Source.Source has unexpected type %T", x)
	}
	return nil
}

func _Source_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Source)
	switch tag {
	case 2: // source.storage_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StorageSource)
		err := b.DecodeMessage(msg)
		m.Source = &Source_StorageSource{msg}
		return true, err
	case 3: // source.repo_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RepoSource)
		err := b.DecodeMessage(msg)
		m.Source = &Source_RepoSource{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Source_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Source)
	// source
	switch x := m.Source.(type) {
	case *Source_StorageSource:
		s := proto.Size(x.StorageSource)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Source_RepoSource:
		s := proto.Size(x.RepoSource)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// An image built by the pipeline.
type BuiltImage struct {
	// Name used to push the container image to Google Container Registry, as
	// presented to `docker push`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Docker Registry 2.0 digest.
	Digest string `protobuf:"bytes,3,opt,name=digest,proto3" json:"digest,omitempty"`
	// Output only. Stores timing information for pushing the specified image.
	PushTiming           *TimeSpan `protobuf:"bytes,4,opt,name=push_timing,json=pushTiming,proto3" json:"push_timing,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BuiltImage) Reset()         { *m = BuiltImage{} }
func (m *BuiltImage) String() string { return proto.CompactTextString(m) }
func (*BuiltImage) ProtoMessage()    {}
func (*BuiltImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{5}
}

func (m *BuiltImage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuiltImage.Unmarshal(m, b)
}
func (m *BuiltImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuiltImage.Marshal(b, m, deterministic)
}
func (m *BuiltImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuiltImage.Merge(m, src)
}
func (m *BuiltImage) XXX_Size() int {
	return xxx_messageInfo_BuiltImage.Size(m)
}
func (m *BuiltImage) XXX_DiscardUnknown() {
	xxx_messageInfo_BuiltImage.DiscardUnknown(m)
}

var xxx_messageInfo_BuiltImage proto.InternalMessageInfo

func (m *BuiltImage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BuiltImage) GetDigest() string {
	if m != nil {
		return m.Digest
	}
	return ""
}

func (m *BuiltImage) GetPushTiming() *TimeSpan {
	if m != nil {
		return m.PushTiming
	}
	return nil
}

// A step in the build pipeline.
type BuildStep struct {
	// Required. The name of the container image that will run this particular
	// build step.
	//
	// If the image is available in the host's Docker daemon's cache, it
	// will be run directly. If not, the host will attempt to pull the image
	// first, using the builder service account's credentials if necessary.
	//
	// The Docker daemon's cache will already have the latest versions of all of
	// the officially supported build steps
	// ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
	// The Docker daemon will also have cached many of the layers for some popular
	// images, like "ubuntu", "debian", but they will be refreshed at the time you
	// attempt to use them.
	//
	// If you built an image in a previous build step, it will be stored in the
	// host's Docker daemon's cache and is available to use as the name for a
	// later build step.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of environment variable definitions to be used when running a step.
	//
	// The elements are of the form "KEY=VALUE" for the environment variable "KEY"
	// being given the value "VALUE".
	Env []string `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty"`
	// A list of arguments that will be presented to the step when it is started.
	//
	// If the image used to run the step's container has an entrypoint, the `args`
	// are used as arguments to that entrypoint. If the image does not define
	// an entrypoint, the first element in args is used as the entrypoint,
	// and the remainder will be used as arguments.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Working directory to use when running this step's container.
	//
	// If this value is a relative path, it is relative to the build's working
	// directory. If this value is absolute, it may be outside the build's working
	// directory, in which case the contents of the path may not be persisted
	// across build step executions, unless a `volume` for that path is specified.
	//
	// If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
	// which specifies an absolute path, the `RepoSource` `dir` is ignored for
	// the step's execution.
	Dir string `protobuf:"bytes,4,opt,name=dir,proto3" json:"dir,omitempty"`
	// Unique identifier for this build step, used in `wait_for` to
	// reference this build step as a dependency.
	Id string `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
	// The ID(s) of the step(s) that this build step depends on.
	// This build step will not start until all the build steps in `wait_for`
	// have completed successfully. If `wait_for` is empty, this build step will
	// start when all previous build steps in the `Build.Steps` list have
	// completed successfully.
	WaitFor []string `protobuf:"bytes,6,rep,name=wait_for,json=waitFor,proto3" json:"wait_for,omitempty"`
	// Entrypoint to be used instead of the build step image's default entrypoint.
	// If unset, the image's default entrypoint is used.
	Entrypoint string `protobuf:"bytes,7,opt,name=entrypoint,proto3" json:"entrypoint,omitempty"`
	// A list of environment variables which are encrypted using a Cloud Key
	// Management Service crypto key. These values must be specified in the
	// build's `Secret`.
	SecretEnv []string `protobuf:"bytes,8,rep,name=secret_env,json=secretEnv,proto3" json:"secret_env,omitempty"`
	// List of volumes to mount into the build step.
	//
	// Each volume will be created as an empty volume prior to execution of the
	// build step. Upon completion of the build, volumes and their contents will
	// be discarded.
	//
	// Using a named volume in only one step is not valid as it is indicative
	// of a mis-configured build request.
	Volumes []*Volume `protobuf:"bytes,9,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// Output only. Stores timing information for executing this build step.
	Timing *TimeSpan `protobuf:"bytes,10,opt,name=timing,proto3" json:"timing,omitempty"`
	// Time limit for executing this build step. If not defined, the step has no
	// time limit and will be allowed to continue to run until either it completes
	// or the build itself times out.
	Timeout *duration.Duration `protobuf:"bytes,11,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Output only. Status of the build step. At this time, build step status is
	// only updated on build completion; step status is not updated in real-time
	// as the build progresses.
	Status               Build_Status `protobuf:"varint,12,opt,name=status,proto3,enum=google.devtools.cloudbuild.v1.Build_Status" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *BuildStep) Reset()         { *m = BuildStep{} }
func (m *BuildStep) String() string { return proto.CompactTextString(m) }
func (*BuildStep) ProtoMessage()    {}
func (*BuildStep) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{6}
}

func (m *BuildStep) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildStep.Unmarshal(m, b)
}
func (m *BuildStep) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildStep.Marshal(b, m, deterministic)
}
func (m *BuildStep) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildStep.Merge(m, src)
}
func (m *BuildStep) XXX_Size() int {
	return xxx_messageInfo_BuildStep.Size(m)
}
func (m *BuildStep) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildStep.DiscardUnknown(m)
}

var xxx_messageInfo_BuildStep proto.InternalMessageInfo

func (m *BuildStep) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BuildStep) GetEnv() []string {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *BuildStep) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *BuildStep) GetDir() string {
	if m != nil {
		return m.Dir
	}
	return ""
}

func (m *BuildStep) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BuildStep) GetWaitFor() []string {
	if m != nil {
		return m.WaitFor
	}
	return nil
}

func (m *BuildStep) GetEntrypoint() string {
	if m != nil {
		return m.Entrypoint
	}
	return ""
}

func (m *BuildStep) GetSecretEnv() []string {
	if m != nil {
		return m.SecretEnv
	}
	return nil
}

func (m *BuildStep) GetVolumes() []*Volume {
	if m != nil {
		return m.Volumes
	}
	return nil
}

func (m *BuildStep) GetTiming() *TimeSpan {
	if m != nil {
		return m.Timing
	}
	return nil
}

func (m *BuildStep) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *BuildStep) GetStatus() Build_Status {
	if m != nil {
		return m.Status
	}
	return Build_STATUS_UNKNOWN
}

// Volume describes a Docker container volume which is mounted into build steps
// in order to persist files across build step execution.
type Volume struct {
	// Name of the volume to mount.
	//
	// Volume names must be unique per build step and must be valid names for
	// Docker volumes. Each named volume must be used by at least two build steps.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Path at which to mount the volume.
	//
	// Paths must be absolute and cannot conflict with other volume paths on the
	// same build step or with certain reserved volume paths.
	Path                 string   `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Volume) Reset()         { *m = Volume{} }
func (m *Volume) String() string { return proto.CompactTextString(m) }
func (*Volume) ProtoMessage()    {}
func (*Volume) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{7}
}

func (m *Volume) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Volume.Unmarshal(m, b)
}
func (m *Volume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Volume.Marshal(b, m, deterministic)
}
func (m *Volume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Volume.Merge(m, src)
}
func (m *Volume) XXX_Size() int {
	return xxx_messageInfo_Volume.Size(m)
}
func (m *Volume) XXX_DiscardUnknown() {
	xxx_messageInfo_Volume.DiscardUnknown(m)
}

var xxx_messageInfo_Volume proto.InternalMessageInfo

func (m *Volume) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Volume) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// Artifacts created by the build pipeline.
type Results struct {
	// Container images that were built as a part of the build.
	Images []*BuiltImage `protobuf:"bytes,2,rep,name=images,proto3" json:"images,omitempty"`
	// List of build step digests, in the order corresponding to build step
	// indices.
	BuildStepImages []string `protobuf:"bytes,3,rep,name=build_step_images,json=buildStepImages,proto3" json:"build_step_images,omitempty"`
	// Path to the artifact manifest. Only populated when artifacts are uploaded.
	ArtifactManifest string `protobuf:"bytes,4,opt,name=artifact_manifest,json=artifactManifest,proto3" json:"artifact_manifest,omitempty"`
	// Number of artifacts uploaded. Only populated when artifacts are uploaded.
	NumArtifacts         int64    `protobuf:"varint,5,opt,name=num_artifacts,json=numArtifacts,proto3" json:"num_artifacts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Results) Reset()         { *m = Results{} }
func (m *Results) String() string { return proto.CompactTextString(m) }
func (*Results) ProtoMessage()    {}
func (*Results) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{8}
}

func (m *Results) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Results.Unmarshal(m, b)
}
func (m *Results) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Results.Marshal(b, m, deterministic)
}
func (m *Results) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Results.Merge(m, src)
}
func (m *Results) XXX_Size() int {
	return xxx_messageInfo_Results.Size(m)
}
func (m *Results) XXX_DiscardUnknown() {
	xxx_messageInfo_Results.DiscardUnknown(m)
}

var xxx_messageInfo_Results proto.InternalMessageInfo

func (m *Results) GetImages() []*BuiltImage {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Results) GetBuildStepImages() []string {
	if m != nil {
		return m.BuildStepImages
	}
	return nil
}

func (m *Results) GetArtifactManifest() string {
	if m != nil {
		return m.ArtifactManifest
	}
	return ""
}

func (m *Results) GetNumArtifacts() int64 {
	if m != nil {
		return m.NumArtifacts
	}
	return 0
}

// An artifact that was uploaded during a build. This
// is a single record in the artifact manifest JSON file.
type ArtifactResult struct {
	// The path of an artifact in a Google Cloud Storage bucket, with the
	// generation number. For example,
	// `gs://mybucket/path/to/output.jar#generation`.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The file hash of the artifact.
	FileHash             []*FileHashes `protobuf:"bytes,2,rep,name=file_hash,json=fileHash,proto3" json:"file_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ArtifactResult) Reset()         { *m = ArtifactResult{} }
func (m *ArtifactResult) String() string { return proto.CompactTextString(m) }
func (*ArtifactResult) ProtoMessage()    {}
func (*ArtifactResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{9}
}

func (m *ArtifactResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArtifactResult.Unmarshal(m, b)
}
func (m *ArtifactResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArtifactResult.Marshal(b, m, deterministic)
}
func (m *ArtifactResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArtifactResult.Merge(m, src)
}
func (m *ArtifactResult) XXX_Size() int {
	return xxx_messageInfo_ArtifactResult.Size(m)
}
func (m *ArtifactResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ArtifactResult.DiscardUnknown(m)
}

var xxx_messageInfo_ArtifactResult proto.InternalMessageInfo

func (m *ArtifactResult) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *ArtifactResult) GetFileHash() []*FileHashes {
	if m != nil {
		return m.FileHash
	}
	return nil
}

// A build resource in the Cloud Build API.
//
// At a high level, a `Build` describes where to find source code, how to build
// it (for example, the builder image to run on the source), and where to store
// the built artifacts.
//
// Fields can include the following variables, which will be expanded when the
// build is created:
//
// - $PROJECT_ID: the project ID of the build.
// - $BUILD_ID: the autogenerated ID of the build.
// - $REPO_NAME: the source repository name specified by RepoSource.
// - $BRANCH_NAME: the branch name specified by RepoSource.
// - $TAG_NAME: the tag name specified by RepoSource.
// - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
//   resolved from the specified branch or tag.
// - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
type Build struct {
	// Output only. Unique identifier of the build.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. ID of the project.
	ProjectId string `protobuf:"bytes,16,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Output only. Status of the build.
	Status Build_Status `protobuf:"varint,2,opt,name=status,proto3,enum=google.devtools.cloudbuild.v1.Build_Status" json:"status,omitempty"`
	// Output only. Customer-readable message about the current status.
	StatusDetail string `protobuf:"bytes,24,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// The location of the source files to build.
	Source *Source `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// Required. The operations to be performed on the workspace.
	Steps []*BuildStep `protobuf:"bytes,11,rep,name=steps,proto3" json:"steps,omitempty"`
	// Output only. Results of the build.
	Results *Results `protobuf:"bytes,10,opt,name=results,proto3" json:"results,omitempty"`
	// Output only. Time at which the request to create the build was received.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which execution of the build was started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time at which execution of the build was finished.
	//
	// The difference between finish_time and start_time is the duration of the
	// build's execution.
	FinishTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	// Amount of time that this build should be allowed to run, to second
	// granularity. If this amount of time elapses, work on the build will cease
	// and the build status will be `TIMEOUT`.
	//
	// Default time is ten minutes.
	Timeout *duration.Duration `protobuf:"bytes,12,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// A list of images to be pushed upon the successful completion of all build
	// steps.
	//
	// The images are pushed using the builder service account's credentials.
	//
	// The digests of the pushed images will be stored in the `Build` resource's
	// results field.
	//
	// If any of the images fail to be pushed, the build status is marked
	// `FAILURE`.
	Images []string `protobuf:"bytes,13,rep,name=images,proto3" json:"images,omitempty"`
	// Artifacts produced by the build that should be uploaded upon
	// successful completion of all build steps.
	Artifacts *Artifacts `protobuf:"bytes,37,opt,name=artifacts,proto3" json:"artifacts,omitempty"`
	// Google Cloud Storage bucket where logs should be written (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	// Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
	LogsBucket string `protobuf:"bytes,19,opt,name=logs_bucket,json=logsBucket,proto3" json:"logs_bucket,omitempty"`
	// Output only. A permanent fixed identifier for source.
	SourceProvenance *SourceProvenance `protobuf:"bytes,21,opt,name=source_provenance,json=sourceProvenance,proto3" json:"source_provenance,omitempty"`
	// Output only. The ID of the `BuildTrigger` that triggered this build, if it
	// was triggered automatically.
	BuildTriggerId string `protobuf:"bytes,22,opt,name=build_trigger_id,json=buildTriggerId,proto3" json:"build_trigger_id,omitempty"`
	// Special options for this build.
	Options *BuildOptions `protobuf:"bytes,23,opt,name=options,proto3" json:"options,omitempty"`
	// Output only. URL to logs for this build in Google Cloud Console.
	LogUrl string `protobuf:"bytes,25,opt,name=log_url,json=logUrl,proto3" json:"log_url,omitempty"`
	// Substitutions data for `Build` resource.
	Substitutions map[string]string `protobuf:"bytes,29,rep,name=substitutions,proto3" json:"substitutions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Tags for annotation of a `Build`. These are not docker tags.
	Tags []string `protobuf:"bytes,31,rep,name=tags,proto3" json:"tags,omitempty"`
	// Secrets to decrypt using Cloud Key Management Service.
	Secrets []*Secret `protobuf:"bytes,32,rep,name=secrets,proto3" json:"secrets,omitempty"`
	// Output only. Stores timing information for phases of the build. Valid keys
	// are:
	//
	// * BUILD: time to execute all build steps
	// * PUSH: time to push all specified images.
	// * FETCHSOURCE: time to fetch source.
	//
	// If the build does not specify source or images,
	// these keys will not be included.
	Timing               map[string]*TimeSpan `protobuf:"bytes,33,rep,name=timing,proto3" json:"timing,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Build) Reset()         { *m = Build{} }
func (m *Build) String() string { return proto.CompactTextString(m) }
func (*Build) ProtoMessage()    {}
func (*Build) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{10}
}

func (m *Build) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Build.Unmarshal(m, b)
}
func (m *Build) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Build.Marshal(b, m, deterministic)
}
func (m *Build) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Build.Merge(m, src)
}
func (m *Build) XXX_Size() int {
	return xxx_messageInfo_Build.Size(m)
}
func (m *Build) XXX_DiscardUnknown() {
	xxx_messageInfo_Build.DiscardUnknown(m)
}

var xxx_messageInfo_Build proto.InternalMessageInfo

func (m *Build) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Build) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Build) GetStatus() Build_Status {
	if m != nil {
		return m.Status
	}
	return Build_STATUS_UNKNOWN
}

func (m *Build) GetStatusDetail() string {
	if m != nil {
		return m.StatusDetail
	}
	return ""
}

func (m *Build) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Build) GetSteps() []*BuildStep {
	if m != nil {
		return m.Steps
	}
	return nil
}

func (m *Build) GetResults() *Results {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *Build) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Build) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Build) GetFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

func (m *Build) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *Build) GetImages() []string {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Build) GetArtifacts() *Artifacts {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

func (m *Build) GetLogsBucket() string {
	if m != nil {
		return m.LogsBucket
	}
	return ""
}

func (m *Build) GetSourceProvenance() *SourceProvenance {
	if m != nil {
		return m.SourceProvenance
	}
	return nil
}

func (m *Build) GetBuildTriggerId() string {
	if m != nil {
		return m.BuildTriggerId
	}
	return ""
}

func (m *Build) GetOptions() *BuildOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *Build) GetLogUrl() string {
	if m != nil {
		return m.LogUrl
	}
	return ""
}

func (m *Build) GetSubstitutions() map[string]string {
	if m != nil {
		return m.Substitutions
	}
	return nil
}

func (m *Build) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Build) GetSecrets() []*Secret {
	if m != nil {
		return m.Secrets
	}
	return nil
}

func (m *Build) GetTiming() map[string]*TimeSpan {
	if m != nil {
		return m.Timing
	}
	return nil
}

// Artifacts produced by a build that should be uploaded upon
// successful completion of all build steps.
type Artifacts struct {
	// A list of images to be pushed upon the successful completion of all build
	// steps.
	//
	// The images will be pushed using the builder service account's credentials.
	//
	// The digests of the pushed images will be stored in the Build resource's
	// results field.
	//
	// If any of the images fail to be pushed, the build is marked FAILURE.
	Images []string `protobuf:"bytes,1,rep,name=images,proto3" json:"images,omitempty"`
	// A list of objects to be uploaded to Cloud Storage upon successful
	// completion of all build steps.
	//
	// Files in the workspace matching specified paths globs will be uploaded to
	// the specified Cloud Storage location using the builder service account's
	// credentials.
	//
	// The location and generation of the uploaded objects will be stored in the
	// Build resource's results field.
	//
	// If any objects fail to be pushed, the build is marked FAILURE.
	Objects              *Artifacts_ArtifactObjects `protobuf:"bytes,2,opt,name=objects,proto3" json:"objects,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *Artifacts) Reset()         { *m = Artifacts{} }
func (m *Artifacts) String() string { return proto.CompactTextString(m) }
func (*Artifacts) ProtoMessage()    {}
func (*Artifacts) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{11}
}

func (m *Artifacts) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Artifacts.Unmarshal(m, b)
}
func (m *Artifacts) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Artifacts.Marshal(b, m, deterministic)
}
func (m *Artifacts) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Artifacts.Merge(m, src)
}
func (m *Artifacts) XXX_Size() int {
	return xxx_messageInfo_Artifacts.Size(m)
}
func (m *Artifacts) XXX_DiscardUnknown() {
	xxx_messageInfo_Artifacts.DiscardUnknown(m)
}

var xxx_messageInfo_Artifacts proto.InternalMessageInfo

func (m *Artifacts) GetImages() []string {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Artifacts) GetObjects() *Artifacts_ArtifactObjects {
	if m != nil {
		return m.Objects
	}
	return nil
}

// Files in the workspace to upload to Cloud Storage upon successful
// completion of all build steps.
type Artifacts_ArtifactObjects struct {
	// Cloud Storage bucket and optional object path, in the form
	// "gs://bucket/path/to/somewhere/". (see [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	//
	// Files in the workspace matching any path pattern will be uploaded to
	// Cloud Storage with this location as a prefix.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Path globs used to match files in the build's workspace.
	Paths []string `protobuf:"bytes,2,rep,name=paths,proto3" json:"paths,omitempty"`
	// Output only. Stores timing information for pushing all artifact objects.
	Timing               *TimeSpan `protobuf:"bytes,3,opt,name=timing,proto3" json:"timing,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Artifacts_ArtifactObjects) Reset()         { *m = Artifacts_ArtifactObjects{} }
func (m *Artifacts_ArtifactObjects) String() string { return proto.CompactTextString(m) }
func (*Artifacts_ArtifactObjects) ProtoMessage()    {}
func (*Artifacts_ArtifactObjects) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{11, 0}
}

func (m *Artifacts_ArtifactObjects) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Artifacts_ArtifactObjects.Unmarshal(m, b)
}
func (m *Artifacts_ArtifactObjects) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Artifacts_ArtifactObjects.Marshal(b, m, deterministic)
}
func (m *Artifacts_ArtifactObjects) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Artifacts_ArtifactObjects.Merge(m, src)
}
func (m *Artifacts_ArtifactObjects) XXX_Size() int {
	return xxx_messageInfo_Artifacts_ArtifactObjects.Size(m)
}
func (m *Artifacts_ArtifactObjects) XXX_DiscardUnknown() {
	xxx_messageInfo_Artifacts_ArtifactObjects.DiscardUnknown(m)
}

var xxx_messageInfo_Artifacts_ArtifactObjects proto.InternalMessageInfo

func (m *Artifacts_ArtifactObjects) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Artifacts_ArtifactObjects) GetPaths() []string {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *Artifacts_ArtifactObjects) GetTiming() *TimeSpan {
	if m != nil {
		return m.Timing
	}
	return nil
}

// Start and end times for a build execution phase.
type TimeSpan struct {
	// Start of time span.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End of time span.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TimeSpan) Reset()         { *m = TimeSpan{} }
func (m *TimeSpan) String() string { return proto.CompactTextString(m) }
func (*TimeSpan) ProtoMessage()    {}
func (*TimeSpan) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{12}
}

func (m *TimeSpan) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeSpan.Unmarshal(m, b)
}
func (m *TimeSpan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeSpan.Marshal(b, m, deterministic)
}
func (m *TimeSpan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeSpan.Merge(m, src)
}
func (m *TimeSpan) XXX_Size() int {
	return xxx_messageInfo_TimeSpan.Size(m)
}
func (m *TimeSpan) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeSpan.DiscardUnknown(m)
}

var xxx_messageInfo_TimeSpan proto.InternalMessageInfo

func (m *TimeSpan) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TimeSpan) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Metadata for build operations.
type BuildOperationMetadata struct {
	// The build that the operation is tracking.
	Build                *Build   `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildOperationMetadata) Reset()         { *m = BuildOperationMetadata{} }
func (m *BuildOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*BuildOperationMetadata) ProtoMessage()    {}
func (*BuildOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{13}
}

func (m *BuildOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildOperationMetadata.Unmarshal(m, b)
}
func (m *BuildOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildOperationMetadata.Marshal(b, m, deterministic)
}
func (m *BuildOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildOperationMetadata.Merge(m, src)
}
func (m *BuildOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_BuildOperationMetadata.Size(m)
}
func (m *BuildOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BuildOperationMetadata proto.InternalMessageInfo

func (m *BuildOperationMetadata) GetBuild() *Build {
	if m != nil {
		return m.Build
	}
	return nil
}

// Provenance of the source. Ways to find the original source, or verify that
// some source was used for this build.
type SourceProvenance struct {
	// A copy of the build's `source.storage_source`, if exists, with any
	// generations resolved.
	ResolvedStorageSource *StorageSource `protobuf:"bytes,3,opt,name=resolved_storage_source,json=resolvedStorageSource,proto3" json:"resolved_storage_source,omitempty"`
	// A copy of the build's `source.repo_source`, if exists, with any
	// revisions resolved.
	ResolvedRepoSource *RepoSource `protobuf:"bytes,6,opt,name=resolved_repo_source,json=resolvedRepoSource,proto3" json:"resolved_repo_source,omitempty"`
	// Output only. Hash(es) of the build source, which can be used to verify that
	// the originalsource integrity was maintained in the build. Note that
	// `FileHashes` willonly be populated if `BuildOptions` has requested a
	// `SourceProvenanceHash`.
	//
	// The keys to this map are file paths used as build source and the values
	// contain the hash values for those files.
	//
	// If the build source came in a single package such as a gzipped tarfile
	// (`.tar.gz`), the `FileHash` will be for the single path to that file.
	FileHashes           map[string]*FileHashes `protobuf:"bytes,4,rep,name=file_hashes,json=fileHashes,proto3" json:"file_hashes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *SourceProvenance) Reset()         { *m = SourceProvenance{} }
func (m *SourceProvenance) String() string { return proto.CompactTextString(m) }
func (*SourceProvenance) ProtoMessage()    {}
func (*SourceProvenance) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{14}
}

func (m *SourceProvenance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourceProvenance.Unmarshal(m, b)
}
func (m *SourceProvenance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourceProvenance.Marshal(b, m, deterministic)
}
func (m *SourceProvenance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceProvenance.Merge(m, src)
}
func (m *SourceProvenance) XXX_Size() int {
	return xxx_messageInfo_SourceProvenance.Size(m)
}
func (m *SourceProvenance) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceProvenance.DiscardUnknown(m)
}

var xxx_messageInfo_SourceProvenance proto.InternalMessageInfo

func (m *SourceProvenance) GetResolvedStorageSource() *StorageSource {
	if m != nil {
		return m.ResolvedStorageSource
	}
	return nil
}

func (m *SourceProvenance) GetResolvedRepoSource() *RepoSource {
	if m != nil {
		return m.ResolvedRepoSource
	}
	return nil
}

func (m *SourceProvenance) GetFileHashes() map[string]*FileHashes {
	if m != nil {
		return m.FileHashes
	}
	return nil
}

// Container message for hashes of byte content of files, used in
// SourceProvenance messages to verify integrity of source input to the build.
type FileHashes struct {
	// Collection of file hashes.
	FileHash             []*Hash  `protobuf:"bytes,1,rep,name=file_hash,json=fileHash,proto3" json:"file_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FileHashes) Reset()         { *m = FileHashes{} }
func (m *FileHashes) String() string { return proto.CompactTextString(m) }
func (*FileHashes) ProtoMessage()    {}
func (*FileHashes) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{15}
}

func (m *FileHashes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileHashes.Unmarshal(m, b)
}
func (m *FileHashes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileHashes.Marshal(b, m, deterministic)
}
func (m *FileHashes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileHashes.Merge(m, src)
}
func (m *FileHashes) XXX_Size() int {
	return xxx_messageInfo_FileHashes.Size(m)
}
func (m *FileHashes) XXX_DiscardUnknown() {
	xxx_messageInfo_FileHashes.DiscardUnknown(m)
}

var xxx_messageInfo_FileHashes proto.InternalMessageInfo

func (m *FileHashes) GetFileHash() []*Hash {
	if m != nil {
		return m.FileHash
	}
	return nil
}

// Container message for hash values.
type Hash struct {
	// The type of hash that was performed.
	Type Hash_HashType `protobuf:"varint,1,opt,name=type,proto3,enum=google.devtools.cloudbuild.v1.Hash_HashType" json:"type,omitempty"`
	// The hash value.
	Value                []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Hash) Reset()         { *m = Hash{} }
func (m *Hash) String() string { return proto.CompactTextString(m) }
func (*Hash) ProtoMessage()    {}
func (*Hash) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{16}
}

func (m *Hash) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Hash.Unmarshal(m, b)
}
func (m *Hash) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Hash.Marshal(b, m, deterministic)
}
func (m *Hash) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Hash.Merge(m, src)
}
func (m *Hash) XXX_Size() int {
	return xxx_messageInfo_Hash.Size(m)
}
func (m *Hash) XXX_DiscardUnknown() {
	xxx_messageInfo_Hash.DiscardUnknown(m)
}

var xxx_messageInfo_Hash proto.InternalMessageInfo

func (m *Hash) GetType() Hash_HashType {
	if m != nil {
		return m.Type
	}
	return Hash_NONE
}

func (m *Hash) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// Pairs a set of secret environment variables containing encrypted
// values with the Cloud KMS key to use to decrypt the value.
type Secret struct {
	// Cloud KMS key name to use to decrypt these envs.
	KmsKeyName string `protobuf:"bytes,1,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Map of environment variable name to its encrypted value.
	//
	// Secret environment variables must be unique across all of a build's
	// secrets, and must be used by at least one build step. Values can be at most
	// 1 KB in size. There can be at most ten secret values across all of a
	// build's secrets.
	SecretEnv            map[string][]byte `protobuf:"bytes,3,rep,name=secret_env,json=secretEnv,proto3" json:"secret_env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Secret) Reset()         { *m = Secret{} }
func (m *Secret) String() string { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()    {}
func (*Secret) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{17}
}

func (m *Secret) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Secret.Unmarshal(m, b)
}
func (m *Secret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Secret.Marshal(b, m, deterministic)
}
func (m *Secret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Secret.Merge(m, src)
}
func (m *Secret) XXX_Size() int {
	return xxx_messageInfo_Secret.Size(m)
}
func (m *Secret) XXX_DiscardUnknown() {
	xxx_messageInfo_Secret.DiscardUnknown(m)
}

var xxx_messageInfo_Secret proto.InternalMessageInfo

func (m *Secret) GetKmsKeyName() string {
	if m != nil {
		return m.KmsKeyName
	}
	return ""
}

func (m *Secret) GetSecretEnv() map[string][]byte {
	if m != nil {
		return m.SecretEnv
	}
	return nil
}

// Request to create a new build.
type CreateBuildRequest struct {
	// ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Build resource to create.
	Build                *Build   `protobuf:"bytes,2,opt,name=build,proto3" json:"build,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateBuildRequest) Reset()         { *m = CreateBuildRequest{} }
func (m *CreateBuildRequest) String() string { return proto.CompactTextString(m) }
func (*CreateBuildRequest) ProtoMessage()    {}
func (*CreateBuildRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{18}
}

func (m *CreateBuildRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateBuildRequest.Unmarshal(m, b)
}
func (m *CreateBuildRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateBuildRequest.Marshal(b, m, deterministic)
}
func (m *CreateBuildRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateBuildRequest.Merge(m, src)
}
func (m *CreateBuildRequest) XXX_Size() int {
	return xxx_messageInfo_CreateBuildRequest.Size(m)
}
func (m *CreateBuildRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateBuildRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateBuildRequest proto.InternalMessageInfo

func (m *CreateBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateBuildRequest) GetBuild() *Build {
	if m != nil {
		return m.Build
	}
	return nil
}

// Request to get a build.
type GetBuildRequest struct {
	// ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// ID of the build.
	Id                   string   `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBuildRequest) Reset()         { *m = GetBuildRequest{} }
func (m *GetBuildRequest) String() string { return proto.CompactTextString(m) }
func (*GetBuildRequest) ProtoMessage()    {}
func (*GetBuildRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{19}
}

func (m *GetBuildRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBuildRequest.Unmarshal(m, b)
}
func (m *GetBuildRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBuildRequest.Marshal(b, m, deterministic)
}
func (m *GetBuildRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBuildRequest.Merge(m, src)
}
func (m *GetBuildRequest) XXX_Size() int {
	return xxx_messageInfo_GetBuildRequest.Size(m)
}
func (m *GetBuildRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBuildRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBuildRequest proto.InternalMessageInfo

func (m *GetBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetBuildRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Request to list builds.
type ListBuildsRequest struct {
	// ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Number of results to return in the list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The raw filter text to constrain the results.
	Filter               string   `protobuf:"bytes,8,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBuildsRequest) Reset()         { *m = ListBuildsRequest{} }
func (m *ListBuildsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBuildsRequest) ProtoMessage()    {}
func (*ListBuildsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{20}
}

func (m *ListBuildsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildsRequest.Unmarshal(m, b)
}
func (m *ListBuildsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildsRequest.Marshal(b, m, deterministic)
}
func (m *ListBuildsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildsRequest.Merge(m, src)
}
func (m *ListBuildsRequest) XXX_Size() int {
	return xxx_messageInfo_ListBuildsRequest.Size(m)
}
func (m *ListBuildsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildsRequest proto.InternalMessageInfo

func (m *ListBuildsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListBuildsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListBuildsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListBuildsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response including listed builds.
type ListBuildsResponse struct {
	// Builds will be sorted by `create_time`, descending.
	Builds []*Build `protobuf:"bytes,1,rep,name=builds,proto3" json:"builds,omitempty"`
	// Token to receive the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBuildsResponse) Reset()         { *m = ListBuildsResponse{} }
func (m *ListBuildsResponse) String() string { return proto.CompactTextString(m) }
func (*ListBuildsResponse) ProtoMessage()    {}
func (*ListBuildsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{21}
}

func (m *ListBuildsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildsResponse.Unmarshal(m, b)
}
func (m *ListBuildsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildsResponse.Marshal(b, m, deterministic)
}
func (m *ListBuildsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildsResponse.Merge(m, src)
}
func (m *ListBuildsResponse) XXX_Size() int {
	return xxx_messageInfo_ListBuildsResponse.Size(m)
}
func (m *ListBuildsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildsResponse proto.InternalMessageInfo

func (m *ListBuildsResponse) GetBuilds() []*Build {
	if m != nil {
		return m.Builds
	}
	return nil
}

func (m *ListBuildsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to cancel an ongoing build.
type CancelBuildRequest struct {
	// ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// ID of the build.
	Id                   string   `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelBuildRequest) Reset()         { *m = CancelBuildRequest{} }
func (m *CancelBuildRequest) String() string { return proto.CompactTextString(m) }
func (*CancelBuildRequest) ProtoMessage()    {}
func (*CancelBuildRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{22}
}

func (m *CancelBuildRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelBuildRequest.Unmarshal(m, b)
}
func (m *CancelBuildRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelBuildRequest.Marshal(b, m, deterministic)
}
func (m *CancelBuildRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelBuildRequest.Merge(m, src)
}
func (m *CancelBuildRequest) XXX_Size() int {
	return xxx_messageInfo_CancelBuildRequest.Size(m)
}
func (m *CancelBuildRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelBuildRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelBuildRequest proto.InternalMessageInfo

func (m *CancelBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CancelBuildRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Configuration for an automated build in response to source repository
// changes.
type BuildTrigger struct {
	// Output only. Unique identifier of the trigger.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human-readable description of this trigger.
	Description string `protobuf:"bytes,10,opt,name=description,proto3" json:"description,omitempty"`
	// Template describing the types of source changes to trigger a build.
	//
	// Branch and tag names in trigger templates are interpreted as regular
	// expressions. Any branch or tag change that matches that regular expression
	// will trigger a build.
	TriggerTemplate *RepoSource `protobuf:"bytes,7,opt,name=trigger_template,json=triggerTemplate,proto3" json:"trigger_template,omitempty"`
	// Template describing the Build request to make when the trigger is matched.
	//
	// Types that are valid to be assigned to BuildTemplate:
	//	*BuildTrigger_Build
	//	*BuildTrigger_Filename
	BuildTemplate isBuildTrigger_BuildTemplate `protobuf_oneof:"build_template"`
	// Output only. Time when the trigger was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// If true, the trigger will never result in a build.
	Disabled bool `protobuf:"varint,9,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Substitutions data for Build resource.
	Substitutions        map[string]string `protobuf:"bytes,11,rep,name=substitutions,proto3" json:"substitutions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BuildTrigger) Reset()         { *m = BuildTrigger{} }
func (m *BuildTrigger) String() string { return proto.CompactTextString(m) }
func (*BuildTrigger) ProtoMessage()    {}
func (*BuildTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{23}
}

func (m *BuildTrigger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildTrigger.Unmarshal(m, b)
}
func (m *BuildTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildTrigger.Marshal(b, m, deterministic)
}
func (m *BuildTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildTrigger.Merge(m, src)
}
func (m *BuildTrigger) XXX_Size() int {
	return xxx_messageInfo_BuildTrigger.Size(m)
}
func (m *BuildTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_BuildTrigger proto.InternalMessageInfo

func (m *BuildTrigger) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BuildTrigger) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *BuildTrigger) GetTriggerTemplate() *RepoSource {
	if m != nil {
		return m.TriggerTemplate
	}
	return nil
}

type isBuildTrigger_BuildTemplate interface {
	isBuildTrigger_BuildTemplate()
}

type BuildTrigger_Build struct {
	Build *Build `protobuf:"bytes,4,opt,name=build,proto3,oneof"`
}

type BuildTrigger_Filename struct {
	Filename string `protobuf:"bytes,8,opt,name=filename,proto3,oneof"`
}

func (*BuildTrigger_Build) isBuildTrigger_BuildTemplate() {}

func (*BuildTrigger_Filename) isBuildTrigger_BuildTemplate() {}

func (m *BuildTrigger) GetBuildTemplate() isBuildTrigger_BuildTemplate {
	if m != nil {
		return m.BuildTemplate
	}
	return nil
}

func (m *BuildTrigger) GetBuild() *Build {
	if x, ok := m.GetBuildTemplate().(*BuildTrigger_Build); ok {
		return x.Build
	}
	return nil
}

func (m *BuildTrigger) GetFilename() string {
	if x, ok := m.GetBuildTemplate().(*BuildTrigger_Filename); ok {
		return x.Filename
	}
	return ""
}

func (m *BuildTrigger) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *BuildTrigger) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

func (m *BuildTrigger) GetSubstitutions() map[string]string {
	if m != nil {
		return m.Substitutions
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BuildTrigger) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BuildTrigger_OneofMarshaler, _BuildTrigger_OneofUnmarshaler, _BuildTrigger_OneofSizer, []interface{}{
		(*BuildTrigger_Build)(nil),
		(*BuildTrigger_Filename)(nil),
	}
}

func _BuildTrigger_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BuildTrigger)
	// build_template
	switch x := m.BuildTemplate.(type) {
	case *BuildTrigger_Build:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Build); err != nil {
			return err
		}
	case *BuildTrigger_Filename:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Filename)
	case nil:
	default:
		return fmt.Errorf("BuildTrigger.BuildTemplate has unexpected type %T", x)
	}
	return nil
}

func _BuildTrigger_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BuildTrigger)
	switch tag {
	case 4: // build_template.build
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Build)
		err := b.DecodeMessage(msg)
		m.BuildTemplate = &BuildTrigger_Build{msg}
		return true, err
	case 8: // build_template.filename
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.BuildTemplate = &BuildTrigger_Filename{x}
		return true, err
	default:
		return false, nil
	}
}

func _BuildTrigger_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BuildTrigger)
	// build_template
	switch x := m.BuildTemplate.(type) {
	case *BuildTrigger_Build:
		s := proto.Size(x.Build)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BuildTrigger_Filename:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Filename)))
		n += len(x.Filename)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request to create a new `BuildTrigger`.
type CreateBuildTriggerRequest struct {
	// ID of the project for which to configure automatic builds.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// `BuildTrigger` to create.
	Trigger              *BuildTrigger `protobuf:"bytes,2,opt,name=trigger,proto3" json:"trigger,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateBuildTriggerRequest) Reset()         { *m = CreateBuildTriggerRequest{} }
func (m *CreateBuildTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*CreateBuildTriggerRequest) ProtoMessage()    {}
func (*CreateBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{24}
}

func (m *CreateBuildTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateBuildTriggerRequest.Unmarshal(m, b)
}
func (m *CreateBuildTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateBuildTriggerRequest.Marshal(b, m, deterministic)
}
func (m *CreateBuildTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateBuildTriggerRequest.Merge(m, src)
}
func (m *CreateBuildTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_CreateBuildTriggerRequest.Size(m)
}
func (m *CreateBuildTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateBuildTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateBuildTriggerRequest proto.InternalMessageInfo

func (m *CreateBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateBuildTriggerRequest) GetTrigger() *BuildTrigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

// Returns the `BuildTrigger` with the specified ID.
type GetBuildTriggerRequest struct {
	// ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// ID of the `BuildTrigger` to get.
	TriggerId            string   `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBuildTriggerRequest) Reset()         { *m = GetBuildTriggerRequest{} }
func (m *GetBuildTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*GetBuildTriggerRequest) ProtoMessage()    {}
func (*GetBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{25}
}

func (m *GetBuildTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBuildTriggerRequest.Unmarshal(m, b)
}
func (m *GetBuildTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBuildTriggerRequest.Marshal(b, m, deterministic)
}
func (m *GetBuildTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBuildTriggerRequest.Merge(m, src)
}
func (m *GetBuildTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_GetBuildTriggerRequest.Size(m)
}
func (m *GetBuildTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBuildTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBuildTriggerRequest proto.InternalMessageInfo

func (m *GetBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

// Request to list existing `BuildTriggers`.
type ListBuildTriggersRequest struct {
	// ID of the project for which to list BuildTriggers.
	ProjectId            string   `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBuildTriggersRequest) Reset()         { *m = ListBuildTriggersRequest{} }
func (m *ListBuildTriggersRequest) String() string { return proto.CompactTextString(m) }
func (*ListBuildTriggersRequest) ProtoMessage()    {}
func (*ListBuildTriggersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{26}
}

func (m *ListBuildTriggersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildTriggersRequest.Unmarshal(m, b)
}
func (m *ListBuildTriggersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildTriggersRequest.Marshal(b, m, deterministic)
}
func (m *ListBuildTriggersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildTriggersRequest.Merge(m, src)
}
func (m *ListBuildTriggersRequest) XXX_Size() int {
	return xxx_messageInfo_ListBuildTriggersRequest.Size(m)
}
func (m *ListBuildTriggersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildTriggersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildTriggersRequest proto.InternalMessageInfo

func (m *ListBuildTriggersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Response containing existing `BuildTriggers`.
type ListBuildTriggersResponse struct {
	// `BuildTriggers` for the project, sorted by `create_time` descending.
	Triggers             []*BuildTrigger `protobuf:"bytes,1,rep,name=triggers,proto3" json:"triggers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListBuildTriggersResponse) Reset()         { *m = ListBuildTriggersResponse{} }
func (m *ListBuildTriggersResponse) String() string { return proto.CompactTextString(m) }
func (*ListBuildTriggersResponse) ProtoMessage()    {}
func (*ListBuildTriggersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{27}
}

func (m *ListBuildTriggersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildTriggersResponse.Unmarshal(m, b)
}
func (m *ListBuildTriggersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildTriggersResponse.Marshal(b, m, deterministic)
}
func (m *ListBuildTriggersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildTriggersResponse.Merge(m, src)
}
func (m *ListBuildTriggersResponse) XXX_Size() int {
	return xxx_messageInfo_ListBuildTriggersResponse.Size(m)
}
func (m *ListBuildTriggersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildTriggersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildTriggersResponse proto.InternalMessageInfo

func (m *ListBuildTriggersResponse) GetTriggers() []*BuildTrigger {
	if m != nil {
		return m.Triggers
	}
	return nil
}

// Request to delete a `BuildTrigger`.
type DeleteBuildTriggerRequest struct {
	// ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// ID of the `BuildTrigger` to delete.
	TriggerId            string   `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteBuildTriggerRequest) Reset()         { *m = DeleteBuildTriggerRequest{} }
func (m *DeleteBuildTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteBuildTriggerRequest) ProtoMessage()    {}
func (*DeleteBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{28}
}

func (m *DeleteBuildTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteBuildTriggerRequest.Unmarshal(m, b)
}
func (m *DeleteBuildTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteBuildTriggerRequest.Marshal(b, m, deterministic)
}
func (m *DeleteBuildTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteBuildTriggerRequest.Merge(m, src)
}
func (m *DeleteBuildTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteBuildTriggerRequest.Size(m)
}
func (m *DeleteBuildTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteBuildTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteBuildTriggerRequest proto.InternalMessageInfo

func (m *DeleteBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

// Request to update an existing `BuildTrigger`.
type UpdateBuildTriggerRequest struct {
	// ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// ID of the `BuildTrigger` to update.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// `BuildTrigger` to update.
	Trigger              *BuildTrigger `protobuf:"bytes,3,opt,name=trigger,proto3" json:"trigger,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *UpdateBuildTriggerRequest) Reset()         { *m = UpdateBuildTriggerRequest{} }
func (m *UpdateBuildTriggerRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBuildTriggerRequest) ProtoMessage()    {}
func (*UpdateBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{29}
}

func (m *UpdateBuildTriggerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateBuildTriggerRequest.Unmarshal(m, b)
}
func (m *UpdateBuildTriggerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateBuildTriggerRequest.Marshal(b, m, deterministic)
}
func (m *UpdateBuildTriggerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBuildTriggerRequest.Merge(m, src)
}
func (m *UpdateBuildTriggerRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateBuildTriggerRequest.Size(m)
}
func (m *UpdateBuildTriggerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBuildTriggerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBuildTriggerRequest proto.InternalMessageInfo

func (m *UpdateBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

func (m *UpdateBuildTriggerRequest) GetTrigger() *BuildTrigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

// Optional arguments to enable specific features of builds.
type BuildOptions struct {
	// Requested hash for SourceProvenance.
	SourceProvenanceHash []Hash_HashType `protobuf:"varint,1,rep,packed,name=source_provenance_hash,json=sourceProvenanceHash,proto3,enum=google.devtools.cloudbuild.v1.Hash_HashType" json:"source_provenance_hash,omitempty"`
	// Requested verifiability options.
	RequestedVerifyOption BuildOptions_VerifyOption `protobuf:"varint,2,opt,name=requested_verify_option,json=requestedVerifyOption,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_VerifyOption" json:"requested_verify_option,omitempty"`
	// Compute Engine machine type on which to run the build.
	MachineType BuildOptions_MachineType `protobuf:"varint,3,opt,name=machine_type,json=machineType,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_MachineType" json:"machine_type,omitempty"`
	// Requested disk size for the VM that runs the build. Note that this is *NOT*
	// "disk free"; some of the space will be used by the operating system and
	// build utilities. Also note that this is the minimum disk size that will be
	// allocated for the build -- the build may run with a larger disk than
	// requested. At present, the maximum disk size is 1000GB; builds that request
	// more than the maximum are rejected with an error.
	DiskSizeGb int64 `protobuf:"varint,6,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Option to specify behavior when there is an error in the substitution
	// checks.
	SubstitutionOption BuildOptions_SubstitutionOption `protobuf:"varint,4,opt,name=substitution_option,json=substitutionOption,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_SubstitutionOption" json:"substitution_option,omitempty"`
	// Option to define build log streaming behavior to Google Cloud
	// Storage.
	LogStreamingOption   BuildOptions_LogStreamingOption `protobuf:"varint,5,opt,name=log_streaming_option,json=logStreamingOption,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_LogStreamingOption" json:"log_streaming_option,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *BuildOptions) Reset()         { *m = BuildOptions{} }
func (m *BuildOptions) String() string { return proto.CompactTextString(m) }
func (*BuildOptions) ProtoMessage()    {}
func (*BuildOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_8a9099620ac1526a, []int{30}
}

func (m *BuildOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildOptions.Unmarshal(m, b)
}
func (m *BuildOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildOptions.Marshal(b, m, deterministic)
}
func (m *BuildOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildOptions.Merge(m, src)
}
func (m *BuildOptions) XXX_Size() int {
	return xxx_messageInfo_BuildOptions.Size(m)
}
func (m *BuildOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildOptions.DiscardUnknown(m)
}

var xxx_messageInfo_BuildOptions proto.InternalMessageInfo

func (m *BuildOptions) GetSourceProvenanceHash() []Hash_HashType {
	if m != nil {
		return m.SourceProvenanceHash
	}
	return nil
}

func (m *BuildOptions) GetRequestedVerifyOption() BuildOptions_VerifyOption {
	if m != nil {
		return m.RequestedVerifyOption
	}
	return BuildOptions_NOT_VERIFIED
}

func (m *BuildOptions) GetMachineType() BuildOptions_MachineType {
	if m != nil {
		return m.MachineType
	}
	return BuildOptions_UNSPECIFIED
}

func (m *BuildOptions) GetDiskSizeGb() int64 {
	if m != nil {
		return m.DiskSizeGb
	}
	return 0
}

func (m *BuildOptions) GetSubstitutionOption() BuildOptions_SubstitutionOption {
	if m != nil {
		return m.SubstitutionOption
	}
	return BuildOptions_MUST_MATCH
}

func (m *BuildOptions) GetLogStreamingOption() BuildOptions_LogStreamingOption {
	if m != nil {
		return m.LogStreamingOption
	}
	return BuildOptions_STREAM_DEFAULT
}

func init() {
	proto.RegisterType((*RetryBuildRequest)(nil), "google.devtools.cloudbuild.v1.RetryBuildRequest")
	proto.RegisterType((*RunBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.RunBuildTriggerRequest")
	proto.RegisterType((*StorageSource)(nil), "google.devtools.cloudbuild.v1.StorageSource")
	proto.RegisterType((*RepoSource)(nil), "google.devtools.cloudbuild.v1.RepoSource")
	proto.RegisterType((*Source)(nil), "google.devtools.cloudbuild.v1.Source")
	proto.RegisterType((*BuiltImage)(nil), "google.devtools.cloudbuild.v1.BuiltImage")
	proto.RegisterType((*BuildStep)(nil), "google.devtools.cloudbuild.v1.BuildStep")
	proto.RegisterType((*Volume)(nil), "google.devtools.cloudbuild.v1.Volume")
	proto.RegisterType((*Results)(nil), "google.devtools.cloudbuild.v1.Results")
	proto.RegisterType((*ArtifactResult)(nil), "google.devtools.cloudbuild.v1.ArtifactResult")
	proto.RegisterType((*Build)(nil), "google.devtools.cloudbuild.v1.Build")
	proto.RegisterMapType((map[string]string)(nil), "google.devtools.cloudbuild.v1.Build.SubstitutionsEntry")
	proto.RegisterMapType((map[string]*TimeSpan)(nil), "google.devtools.cloudbuild.v1.Build.TimingEntry")
	proto.RegisterType((*Artifacts)(nil), "google.devtools.cloudbuild.v1.Artifacts")
	proto.RegisterType((*Artifacts_ArtifactObjects)(nil), "google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects")
	proto.RegisterType((*TimeSpan)(nil), "google.devtools.cloudbuild.v1.TimeSpan")
	proto.RegisterType((*BuildOperationMetadata)(nil), "google.devtools.cloudbuild.v1.BuildOperationMetadata")
	proto.RegisterType((*SourceProvenance)(nil), "google.devtools.cloudbuild.v1.SourceProvenance")
	proto.RegisterMapType((map[string]*FileHashes)(nil), "google.devtools.cloudbuild.v1.SourceProvenance.FileHashesEntry")
	proto.RegisterType((*FileHashes)(nil), "google.devtools.cloudbuild.v1.FileHashes")
	proto.RegisterType((*Hash)(nil), "google.devtools.cloudbuild.v1.Hash")
	proto.RegisterType((*Secret)(nil), "google.devtools.cloudbuild.v1.Secret")
	proto.RegisterMapType((map[string][]byte)(nil), "google.devtools.cloudbuild.v1.Secret.SecretEnvEntry")
	proto.RegisterType((*CreateBuildRequest)(nil), "google.devtools.cloudbuild.v1.CreateBuildRequest")
	proto.RegisterType((*GetBuildRequest)(nil), "google.devtools.cloudbuild.v1.GetBuildRequest")
	proto.RegisterType((*ListBuildsRequest)(nil), "google.devtools.cloudbuild.v1.ListBuildsRequest")
	proto.RegisterType((*ListBuildsResponse)(nil), "google.devtools.cloudbuild.v1.ListBuildsResponse")
	proto.RegisterType((*CancelBuildRequest)(nil), "google.devtools.cloudbuild.v1.CancelBuildRequest")
	proto.RegisterType((*BuildTrigger)(nil), "google.devtools.cloudbuild.v1.BuildTrigger")
	proto.RegisterMapType((map[string]string)(nil), "google.devtools.cloudbuild.v1.BuildTrigger.SubstitutionsEntry")
	proto.RegisterType((*CreateBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.CreateBuildTriggerRequest")
	proto.RegisterType((*GetBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.GetBuildTriggerRequest")
	proto.RegisterType((*ListBuildTriggersRequest)(nil), "google.devtools.cloudbuild.v1.ListBuildTriggersRequest")
	proto.RegisterType((*ListBuildTriggersResponse)(nil), "google.devtools.cloudbuild.v1.ListBuildTriggersResponse")
	proto.RegisterType((*DeleteBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.DeleteBuildTriggerRequest")
	proto.RegisterType((*UpdateBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.UpdateBuildTriggerRequest")
	proto.RegisterType((*BuildOptions)(nil), "google.devtools.cloudbuild.v1.BuildOptions")
	proto.RegisterEnum("google.devtools.cloudbuild.v1.Build_Status", Build_Status_name, Build_Status_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.Hash_HashType", Hash_HashType_name, Hash_HashType_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_VerifyOption", BuildOptions_VerifyOption_name, BuildOptions_VerifyOption_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_MachineType", BuildOptions_MachineType_name, BuildOptions_MachineType_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_SubstitutionOption", BuildOptions_SubstitutionOption_name, BuildOptions_SubstitutionOption_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_LogStreamingOption", BuildOptions_LogStreamingOption_name, BuildOptions_LogStreamingOption_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CloudBuildClient is the client API for CloudBuild service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudBuildClient interface {
	// Starts a build with the specified configuration.
	//
	// This method returns a long-running `Operation`, which includes the build
	// ID. Pass the build ID to `GetBuild` to determine the build status (such as
	// `SUCCESS` or `FAILURE`).
	CreateBuild(ctx context.Context, in *CreateBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Returns information about a previously requested build.
	//
	// The `Build` that is returned includes its status (such as `SUCCESS`,
	// `FAILURE`, or `WORKING`), and timing information.
	GetBuild(ctx context.Context, in *GetBuildRequest, opts ...grpc.CallOption) (*Build, error)
	// Lists previously requested builds.
	//
	// Previously requested builds may still be in-progress, or may have finished
	// successfully or unsuccessfully.
	ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error)
	// Cancels a build in progress.
	CancelBuild(ctx context.Context, in *CancelBuildRequest, opts ...grpc.CallOption) (*Build, error)
	// Creates a new build based on the specified build.
	//
	// This method creates a new build using the original build request, which may
	// or may not result in an identical build.
	//
	// For triggered builds:
	//
	// * Triggered builds resolve to a precise revision; therefore a retry of a
	// triggered build will result in a build that uses the same revision.
	//
	// For non-triggered builds that specify `RepoSource`:
	//
	// * If the original build built from the tip of a branch, the retried build
	// will build from the tip of that branch, which may not be the same revision
	// as the original build.
	// * If the original build specified a commit sha or revision ID, the retried
	// build will use the identical source.
	//
	// For builds that specify `StorageSource`:
	//
	// * If the original build pulled source from Google Cloud Storage without
	// specifying the generation of the object, the new build will use the current
	// object, which may be different from the original build source.
	// * If the original build pulled source from Cloud Storage and specified the
	// generation of the object, the new build will attempt to use the same
	// object, which may or may not be available depending on the bucket's
	// lifecycle management settings.
	RetryBuild(ctx context.Context, in *RetryBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a new `BuildTrigger`.
	//
	// This API is experimental.
	CreateBuildTrigger(ctx context.Context, in *CreateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Returns information about a `BuildTrigger`.
	//
	// This API is experimental.
	GetBuildTrigger(ctx context.Context, in *GetBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Lists existing `BuildTrigger`s.
	//
	// This API is experimental.
	ListBuildTriggers(ctx context.Context, in *ListBuildTriggersRequest, opts ...grpc.CallOption) (*ListBuildTriggersResponse, error)
	// Deletes a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	DeleteBuildTrigger(ctx context.Context, in *DeleteBuildTriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	UpdateBuildTrigger(ctx context.Context, in *UpdateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Runs a `BuildTrigger` at a particular source revision.
	RunBuildTrigger(ctx context.Context, in *RunBuildTriggerRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type cloudBuildClient struct {
	cc *grpc.ClientConn
}

func NewCloudBuildClient(cc *grpc.ClientConn) CloudBuildClient {
	return &cloudBuildClient{cc}
}

func (c *cloudBuildClient) CreateBuild(ctx context.Context, in *CreateBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) GetBuild(ctx context.Context, in *GetBuildRequest, opts ...grpc.CallOption) (*Build, error) {
	out := new(Build)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/GetBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error) {
	out := new(ListBuildsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/ListBuilds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) CancelBuild(ctx context.Context, in *CancelBuildRequest, opts ...grpc.CallOption) (*Build, error) {
	out := new(Build)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CancelBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) RetryBuild(ctx context.Context, in *RetryBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/RetryBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) CreateBuildTrigger(ctx context.Context, in *CreateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) GetBuildTrigger(ctx context.Context, in *GetBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/GetBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) ListBuildTriggers(ctx context.Context, in *ListBuildTriggersRequest, opts ...grpc.CallOption) (*ListBuildTriggersResponse, error) {
	out := new(ListBuildTriggersResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/ListBuildTriggers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) DeleteBuildTrigger(ctx context.Context, in *DeleteBuildTriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/DeleteBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) UpdateBuildTrigger(ctx context.Context, in *UpdateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/UpdateBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) RunBuildTrigger(ctx context.Context, in *RunBuildTriggerRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/RunBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudBuildServer is the server API for CloudBuild service.
type CloudBuildServer interface {
	// Starts a build with the specified configuration.
	//
	// This method returns a long-running `Operation`, which includes the build
	// ID. Pass the build ID to `GetBuild` to determine the build status (such as
	// `SUCCESS` or `FAILURE`).
	CreateBuild(context.Context, *CreateBuildRequest) (*longrunning.Operation, error)
	// Returns information about a previously requested build.
	//
	// The `Build` that is returned includes its status (such as `SUCCESS`,
	// `FAILURE`, or `WORKING`), and timing information.
	GetBuild(context.Context, *GetBuildRequest) (*Build, error)
	// Lists previously requested builds.
	//
	// Previously requested builds may still be in-progress, or may have finished
	// successfully or unsuccessfully.
	ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error)
	// Cancels a build in progress.
	CancelBuild(context.Context, *CancelBuildRequest) (*Build, error)
	// Creates a new build based on the specified build.
	//
	// This method creates a new build using the original build request, which may
	// or may not result in an identical build.
	//
	// For triggered builds:
	//
	// * Triggered builds resolve to a precise revision; therefore a retry of a
	// triggered build will result in a build that uses the same revision.
	//
	// For non-triggered builds that specify `RepoSource`:
	//
	// * If the original build built from the tip of a branch, the retried build
	// will build from the tip of that branch, which may not be the same revision
	// as the original build.
	// * If the original build specified a commit sha or revision ID, the retried
	// build will use the identical source.
	//
	// For builds that specify `StorageSource`:
	//
	// * If the original build pulled source from Google Cloud Storage without
	// specifying the generation of the object, the new build will use the current
	// object, which may be different from the original build source.
	// * If the original build pulled source from Cloud Storage and specified the
	// generation of the object, the new build will attempt to use the same
	// object, which may or may not be available depending on the bucket's
	// lifecycle management settings.
	RetryBuild(context.Context, *RetryBuildRequest) (*longrunning.Operation, error)
	// Creates a new `BuildTrigger`.
	//
	// This API is experimental.
	CreateBuildTrigger(context.Context, *CreateBuildTriggerRequest) (*BuildTrigger, error)
	// Returns information about a `BuildTrigger`.
	//
	// This API is experimental.
	GetBuildTrigger(context.Context, *GetBuildTriggerRequest) (*BuildTrigger, error)
	// Lists existing `BuildTrigger`s.
	//
	// This API is experimental.
	ListBuildTriggers(context.Context, *ListBuildTriggersRequest) (*ListBuildTriggersResponse, error)
	// Deletes a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	DeleteBuildTrigger(context.Context, *DeleteBuildTriggerRequest) (*empty.Empty, error)
	// Updates a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	UpdateBuildTrigger(context.Context, *UpdateBuildTriggerRequest) (*BuildTrigger, error)
	// Runs a `BuildTrigger` at a particular source revision.
	RunBuildTrigger(context.Context, *RunBuildTriggerRequest) (*longrunning.Operation, error)
}

func RegisterCloudBuildServer(s *grpc.Server, srv CloudBuildServer) {
	s.RegisterService(&_CloudBuild_serviceDesc, srv)
}

func _CloudBuild_CreateBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CreateBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CreateBuild(ctx, req.(*CreateBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_GetBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).GetBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/GetBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).GetBuild(ctx, req.(*GetBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_ListBuilds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).ListBuilds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/ListBuilds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).ListBuilds(ctx, req.(*ListBuildsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_CancelBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CancelBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CancelBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CancelBuild(ctx, req.(*CancelBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_RetryBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetryBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).RetryBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/RetryBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).RetryBuild(ctx, req.(*RetryBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_CreateBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CreateBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CreateBuildTrigger(ctx, req.(*CreateBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_GetBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).GetBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/GetBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).GetBuildTrigger(ctx, req.(*GetBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_ListBuildTriggers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildTriggersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).ListBuildTriggers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/ListBuildTriggers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).ListBuildTriggers(ctx, req.(*ListBuildTriggersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_DeleteBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).DeleteBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/DeleteBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).DeleteBuildTrigger(ctx, req.(*DeleteBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_UpdateBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).UpdateBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/UpdateBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).UpdateBuildTrigger(ctx, req.(*UpdateBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_RunBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).RunBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/RunBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).RunBuildTrigger(ctx, req.(*RunBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudBuild_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.cloudbuild.v1.CloudBuild",
	HandlerType: (*CloudBuildServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBuild",
			Handler:    _CloudBuild_CreateBuild_Handler,
		},
		{
			MethodName: "GetBuild",
			Handler:    _CloudBuild_GetBuild_Handler,
		},
		{
			MethodName: "ListBuilds",
			Handler:    _CloudBuild_ListBuilds_Handler,
		},
		{
			MethodName: "CancelBuild",
			Handler:    _CloudBuild_CancelBuild_Handler,
		},
		{
			MethodName: "RetryBuild",
			Handler:    _CloudBuild_RetryBuild_Handler,
		},
		{
			MethodName: "CreateBuildTrigger",
			Handler:    _CloudBuild_CreateBuildTrigger_Handler,
		},
		{
			MethodName: "GetBuildTrigger",
			Handler:    _CloudBuild_GetBuildTrigger_Handler,
		},
		{
			MethodName: "ListBuildTriggers",
			Handler:    _CloudBuild_ListBuildTriggers_Handler,
		},
		{
			MethodName: "DeleteBuildTrigger",
			Handler:    _CloudBuild_DeleteBuildTrigger_Handler,
		},
		{
			MethodName: "UpdateBuildTrigger",
			Handler:    _CloudBuild_UpdateBuildTrigger_Handler,
		},
		{
			MethodName: "RunBuildTrigger",
			Handler:    _CloudBuild_RunBuildTrigger_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/cloudbuild/v1/cloudbuild.proto",
}

func init() {
	proto.RegisterFile("google/devtools/cloudbuild/v1/cloudbuild.proto", fileDescriptor_8a9099620ac1526a)
}

var fileDescriptor_8a9099620ac1526a = []byte{
	// 2755 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x5a, 0xdb, 0x6f, 0x23, 0x57,
	0x19, 0xdf, 0xb1, 0x13, 0x5f, 0x3e, 0xe7, 0x32, 0x7b, 0xba, 0x4d, 0x1d, 0x6f, 0xb7, 0x9b, 0x4e,
	0x6f, 0xe9, 0x6e, 0x6b, 0x37, 0x59, 0xb6, 0xbb, 0x4d, 0x2f, 0xbb, 0x89, 0xe3, 0x5c, 0xd4, 0xc4,
	0x59, 0xc6, 0xf6, 0x56, 0x14, 0xd0, 0x30, 0xf6, 0x9c, 0x38, 0x43, 0xc6, 0x33, 0xc3, 0x9c, 0x63,
	0x43, 0x5a, 0x2a, 0x44, 0x05, 0x48, 0x3c, 0x81, 0x84, 0x78, 0x40, 0x3c, 0x70, 0x79, 0x46, 0x08,
	0xc1, 0x03, 0x12, 0x52, 0x9f, 0x91, 0x78, 0xe5, 0x89, 0x77, 0xfe, 0x0e, 0x84, 0xce, 0x65, 0xec,
	0xb1, 0xbd, 0xdb, 0xf1, 0xec, 0xc2, 0x4b, 0x32, 0xe7, 0x3b, 0xe7, 0xfb, 0xce, 0x77, 0xbe, 0xdb,
	0xf9, 0x7d, 0x33, 0x86, 0x72, 0xd7, 0xf3, 0xba, 0x0e, 0xae, 0x58, 0x78, 0x40, 0x3d, 0xcf, 0x21,
	0x95, 0x8e, 0xe3, 0xf5, 0xad, 0x76, 0xdf, 0x76, 0xac, 0xca, 0x60, 0x23, 0x32, 0x2a, 0xfb, 0x81,
	0x47, 0x3d, 0x74, 0x4d, 0xac, 0x2f, 0x87, 0xeb, 0xcb, 0x91, 0x15, 0x83, 0x8d, 0xd2, 0xf3, 0x52,
	0x9c, 0xe9, 0xdb, 0x15, 0xd3, 0x75, 0x3d, 0x6a, 0x52, 0xdb, 0x73, 0x89, 0x60, 0x2e, 0xad, 0x46,
	0x66, 0xcf, 0x28, 0xf5, 0xdb, 0x9e, 0x75, 0x21, 0xa7, 0x34, 0x39, 0xc5, 0xc5, 0x55, 0xcc, 0xbe,
	0x65, 0x53, 0xf1, 0xd7, 0x70, 0xbc, 0xae, 0x5c, 0xf3, 0x92, 0x5c, 0xe3, 0x78, 0x6e, 0x37, 0xe8,
	0xbb, 0xae, 0xed, 0x76, 0x2b, 0x9e, 0x8f, 0x83, 0xb1, 0x3d, 0x5e, 0x90, 0x8b, 0xf8, 0xa8, 0xdd,
	0x3f, 0xad, 0x58, 0x7d, 0xb1, 0x40, 0xce, 0x5f, 0x9d, 0x9c, 0xc7, 0x3d, 0x9f, 0x86, 0x5a, 0x5c,
	0x9f, 0x9c, 0xa4, 0x76, 0x0f, 0x13, 0x6a, 0xf6, 0x7c, 0xb1, 0x40, 0xdb, 0x81, 0xcb, 0x3a, 0xa6,
	0xc1, 0xc5, 0x0e, 0x3b, 0xb0, 0x8e, 0xbf, 0xd3, 0xc7, 0x84, 0xa2, 0x6b, 0x00, 0x7e, 0xe0, 0x7d,
	0x1b, 0x77, 0xa8, 0x61, 0x5b, 0x45, 0x65, 0x4d, 0x59, 0xcf, 0xeb, 0x79, 0x49, 0x39, 0xb4, 0xd0,
	0x12, 0xa4, 0x6c, 0xab, 0x98, 0xe2, 0xe4, 0x94, 0x6d, 0x69, 0xbf, 0x52, 0x60, 0x45, 0xef, 0xbb,
	0x5c, 0x44, 0x33, 0xb0, 0xbb, 0x5d, 0x1c, 0xcc, 0x28, 0xe9, 0x1a, 0x00, 0x15, 0x0c, 0xc6, 0x50,
	0x62, 0x5e, 0x52, 0x0e, 0x2d, 0xb4, 0x0d, 0x19, 0xe2, 0xf5, 0x83, 0x0e, 0x2e, 0xa6, 0xd7, 0x94,
	0xf5, 0xc2, 0xe6, 0xeb, 0xe5, 0x2f, 0x75, 0x56, 0x59, 0xc7, 0xbe, 0xd7, 0xe0, 0x0c, 0xba, 0x64,
	0xd4, 0x0c, 0x58, 0x6c, 0x50, 0x2f, 0x30, 0xbb, 0x58, 0x4c, 0xa0, 0x15, 0xc8, 0xb4, 0xfb, 0x9d,
	0x73, 0x4c, 0xa5, 0x36, 0x72, 0xc4, 0xe8, 0x5e, 0x9b, 0xa9, 0x25, 0xd5, 0x90, 0x23, 0xf4, 0x02,
	0x40, 0x17, 0xbb, 0xd2, 0x27, 0x5c, 0x8f, 0xb4, 0x1e, 0xa1, 0x68, 0x7f, 0x57, 0x00, 0x46, 0xfb,
	0xc6, 0x1d, 0xf8, 0x2a, 0xe4, 0x03, 0xec, 0x7b, 0x86, 0x6b, 0xf6, 0xb0, 0xdc, 0x28, 0xc7, 0x08,
	0x75, 0xb3, 0x87, 0xd1, 0x8b, 0x50, 0x68, 0x07, 0xa6, 0xdb, 0x39, 0x13, 0xd3, 0x6c, 0xaf, 0xfc,
	0xc1, 0x25, 0x1d, 0x04, 0x91, 0x2f, 0xb9, 0x0a, 0x39, 0x6a, 0x76, 0xc5, 0xfc, 0x9c, 0x9c, 0xcf,
	0x52, 0xb3, 0xcb, 0x27, 0xaf, 0x03, 0x74, 0xbc, 0x5e, 0xcf, 0xa6, 0x06, 0x39, 0x33, 0x8b, 0xf3,
	0x72, 0x3a, 0x2f, 0x68, 0x8d, 0x33, 0x13, 0xa9, 0x90, 0xb6, 0xec, 0xa0, 0x98, 0xe5, 0xfb, 0xb2,
	0xc7, 0x1d, 0x80, 0x5c, 0x80, 0x07, 0x36, 0x61, 0x27, 0xf9, 0xab, 0x02, 0x19, 0x79, 0x8a, 0x16,
	0x2c, 0x11, 0x61, 0x35, 0x43, 0x3a, 0x20, 0xc5, 0x1d, 0xf0, 0x46, 0x8c, 0x03, 0xc6, 0x4c, 0x7d,
	0x70, 0x49, 0x5f, 0x24, 0x63, 0xb6, 0x3f, 0x82, 0x02, 0x3f, 0xfd, 0x13, 0x3a, 0x95, 0xd9, 0x22,
	0x18, 0x8e, 0x76, 0x72, 0x61, 0x74, 0x68, 0x9f, 0x2b, 0x00, 0x2c, 0xfa, 0xe8, 0x61, 0xcf, 0xec,
	0x62, 0x84, 0x60, 0x8e, 0x1b, 0x48, 0x58, 0x9f, 0x3f, 0x33, 0xf7, 0x5a, 0x76, 0x17, 0x13, 0x2a,
	0xcc, 0xaa, 0xcb, 0x11, 0x3a, 0x80, 0x82, 0xdf, 0x27, 0x67, 0x06, 0xb5, 0x7b, 0xb6, 0xdb, 0xe5,
	0x36, 0x2d, 0x6c, 0xbe, 0x16, 0xa3, 0x52, 0xd3, 0xee, 0xe1, 0x86, 0x6f, 0xba, 0x3a, 0x30, 0xde,
	0x26, 0x67, 0xd5, 0xbe, 0x48, 0x43, 0x9e, 0xa7, 0x40, 0x83, 0x62, 0xff, 0x91, 0x3a, 0xa8, 0x90,
	0xc6, 0xee, 0xa0, 0x98, 0x5a, 0x4b, 0x33, 0xf3, 0x63, 0x77, 0xc0, 0x56, 0x99, 0x41, 0x97, 0x14,
	0xd3, 0x9c, 0xc4, 0x9f, 0x43, 0x27, 0xcd, 0x0d, 0x9d, 0x24, 0xf3, 0x6d, 0x3e, 0xcc, 0x37, 0xb4,
	0x0a, 0xb9, 0xef, 0x9a, 0x36, 0x35, 0x4e, 0xbd, 0xa0, 0x98, 0xe1, 0x9c, 0x59, 0x36, 0xde, 0xf3,
	0x02, 0x16, 0xad, 0xd8, 0xa5, 0xc1, 0x85, 0xef, 0xd9, 0x2e, 0x95, 0x8e, 0x8e, 0x50, 0x58, 0x78,
	0x12, 0xdc, 0x09, 0x30, 0x35, 0x98, 0x26, 0x39, 0xce, 0x9c, 0x17, 0x94, 0x9a, 0x3b, 0x40, 0xf7,
	0x20, 0x3b, 0xf0, 0x9c, 0x7e, 0x0f, 0x93, 0x62, 0x7e, 0x2d, 0xbd, 0x5e, 0xd8, 0x7c, 0x25, 0xc6,
	0x12, 0x0f, 0xf9, 0x6a, 0x3d, 0xe4, 0x42, 0xf7, 0x20, 0x23, 0x2d, 0x09, 0xc9, 0x2c, 0x29, 0xd9,
	0xd0, 0x2d, 0xc8, 0xb2, 0x12, 0xe5, 0xf5, 0x69, 0xb1, 0xc0, 0x25, 0xac, 0x86, 0x12, 0xc2, 0x12,
	0x56, 0xde, 0x95, 0xf5, 0x4f, 0x0f, 0x57, 0xa2, 0x2a, 0x64, 0x08, 0x35, 0x69, 0x9f, 0x14, 0x17,
	0xd6, 0x94, 0xf5, 0xa5, 0xcd, 0x9b, 0x31, 0xbb, 0x72, 0x37, 0x95, 0x1b, 0x9c, 0x45, 0x97, 0xac,
	0xda, 0x5b, 0x90, 0x11, 0xa7, 0x79, 0xa4, 0xef, 0x10, 0xcc, 0xf9, 0x26, 0x3d, 0x93, 0x39, 0xcb,
	0x9f, 0xb5, 0x7f, 0x28, 0x90, 0xd5, 0x31, 0xe9, 0x3b, 0x94, 0xb0, 0x52, 0x65, 0xb3, 0xe0, 0x23,
	0xdc, 0xbd, 0xf1, 0x51, 0x3d, 0x0a, 0x57, 0x5d, 0x32, 0xa2, 0x1b, 0x70, 0x99, 0x4f, 0x1b, 0x84,
	0x62, 0xdf, 0x90, 0xd2, 0x44, 0x64, 0x2c, 0xb7, 0xc3, 0xc0, 0x3a, 0x14, 0x6b, 0x6f, 0xc2, 0x65,
	0x33, 0xa0, 0xf6, 0xa9, 0xd9, 0xa1, 0x46, 0xcf, 0x74, 0xed, 0x53, 0x16, 0xd9, 0x22, 0x64, 0xd4,
	0x70, 0xe2, 0x58, 0xd2, 0xd1, 0x4b, 0xb0, 0xe8, 0xf6, 0x7b, 0x46, 0x48, 0x27, 0x3c, 0x94, 0xd2,
	0xfa, 0x82, 0xdb, 0xef, 0x6d, 0x87, 0x34, 0x8d, 0xc2, 0x52, 0x38, 0x10, 0x67, 0x42, 0x25, 0xc8,
	0x39, 0x5e, 0x47, 0xd4, 0x3d, 0x61, 0x8a, 0xe1, 0x18, 0xed, 0x41, 0xfe, 0xd4, 0x76, 0xb0, 0x71,
	0x66, 0x92, 0xb3, 0x19, 0x4f, 0xbc, 0x67, 0x3b, 0xf8, 0xc0, 0x24, 0x67, 0x98, 0xe8, 0xb9, 0x53,
	0xf9, 0xac, 0xfd, 0xab, 0x00, 0xf3, 0xdc, 0x1b, 0x32, 0xc8, 0x95, 0x61, 0x90, 0x8f, 0x17, 0x52,
	0x75, 0xb2, 0x90, 0x8e, 0x5c, 0x9e, 0x7a, 0x62, 0x97, 0x33, 0xc3, 0x88, 0x27, 0xc3, 0xc2, 0xd4,
	0xb4, 0x9d, 0x62, 0x91, 0x6f, 0xb3, 0x20, 0x88, 0xbb, 0x9c, 0x86, 0xde, 0x9f, 0xb8, 0x84, 0xe2,
	0x52, 0x62, 0xfc, 0x02, 0x42, 0x1f, 0xc0, 0x3c, 0xf3, 0x27, 0x29, 0x16, 0xb8, 0x95, 0xd6, 0x67,
	0xd1, 0x93, 0x39, 0x5a, 0x17, 0x6c, 0xe8, 0x3e, 0x64, 0x03, 0x11, 0x63, 0x32, 0xa5, 0x5e, 0x8d,
	0xad, 0x97, 0x7c, 0xb5, 0x1e, 0xb2, 0xa1, 0x77, 0xa1, 0xd0, 0x09, 0xb0, 0x49, 0x31, 0x2b, 0x72,
	0xb8, 0x98, 0xe1, 0x52, 0x4a, 0x53, 0x69, 0xd5, 0x0c, 0x91, 0x81, 0x0e, 0x62, 0x39, 0x23, 0xa0,
	0x77, 0x00, 0x08, 0x35, 0x03, 0x2a, 0x78, 0xb3, 0xb1, 0xbc, 0x79, 0xbe, 0x9a, 0xb3, 0xbe, 0x0b,
	0x85, 0x53, 0xdb, 0xb5, 0x45, 0x71, 0xc5, 0xc5, 0x5c, 0xfc, 0xbe, 0x62, 0x39, 0x67, 0x8e, 0xd4,
	0x81, 0x85, 0x99, 0xeb, 0xc0, 0xca, 0x30, 0x09, 0x17, 0x79, 0xda, 0x84, 0x99, 0xb5, 0x07, 0xf9,
	0x51, 0xf0, 0xbf, 0xc2, 0xc5, 0xc5, 0xf9, 0x61, 0x98, 0x18, 0xfa, 0x88, 0x15, 0x5d, 0x87, 0x82,
	0xe3, 0x75, 0x89, 0x21, 0x01, 0xc4, 0x33, 0xa2, 0xbc, 0x32, 0xd2, 0x8e, 0x00, 0x11, 0xdf, 0x80,
	0xcb, 0xc2, 0xed, 0x86, 0x1f, 0x78, 0x03, 0xec, 0x9a, 0x6e, 0x07, 0x17, 0x9f, 0xe5, 0x1b, 0x56,
	0x66, 0x0a, 0x9b, 0x07, 0x43, 0x36, 0x5d, 0x25, 0x13, 0x14, 0xb4, 0x0e, 0xaa, 0x28, 0x10, 0x11,
	0xcc, 0xb4, 0xc2, 0x75, 0x58, 0x6a, 0x47, 0xb0, 0xd7, 0xa1, 0x85, 0x6a, 0x90, 0xf5, 0x7c, 0x0e,
	0x22, 0x8b, 0xcf, 0xf1, 0xdd, 0x67, 0x4a, 0x8f, 0x13, 0xc1, 0xa2, 0x87, 0xbc, 0xe8, 0x39, 0xc8,
	0x3a, 0x5e, 0xd7, 0xe8, 0x07, 0x4e, 0x71, 0x55, 0xdc, 0x9a, 0x8e, 0xd7, 0x6d, 0x05, 0x0e, 0xfa,
	0x26, 0x2c, 0x92, 0x7e, 0x9b, 0x50, 0x9b, 0xf6, 0xc5, 0x2e, 0xd7, 0x78, 0x70, 0xdf, 0x99, 0x2d,
	0x09, 0xa3, 0x9c, 0x35, 0x76, 0x37, 0xe9, 0xe3, 0xd2, 0x58, 0xb1, 0xa5, 0x66, 0x97, 0x14, 0xaf,
	0x8b, 0x6b, 0x91, 0x3d, 0xb3, 0xab, 0x49, 0xdc, 0x53, 0xa4, 0xb8, 0x36, 0xd3, 0xd5, 0xd4, 0xe0,
	0xab, 0xf5, 0x90, 0x0b, 0x1d, 0x0c, 0xaf, 0xa6, 0x17, 0x39, 0xff, 0x5b, 0x33, 0x29, 0x2b, 0x2e,
	0x77, 0xa1, 0xa5, 0xe4, 0x2f, 0xdd, 0x07, 0x34, 0x7d, 0x06, 0x76, 0x6f, 0x9f, 0xe3, 0x0b, 0x59,
	0xc1, 0xd8, 0x23, 0xba, 0x02, 0xf3, 0x03, 0xd3, 0xe9, 0x87, 0x40, 0x4f, 0x0c, 0xb6, 0x52, 0x77,
	0x95, 0x52, 0x1b, 0x0a, 0x11, 0xc1, 0x8f, 0x60, 0x7d, 0x3f, 0xca, 0x9a, 0xe0, 0x1a, 0x1d, 0xed,
	0xa1, 0xfd, 0x00, 0x32, 0xa2, 0xdc, 0x21, 0x04, 0x4b, 0x8d, 0xe6, 0x76, 0xb3, 0xd5, 0x30, 0x5a,
	0xf5, 0x0f, 0xeb, 0x27, 0x1f, 0xd5, 0xd5, 0x4b, 0x08, 0x20, 0xf3, 0xd5, 0x56, 0xad, 0x55, 0xdb,
	0x55, 0x15, 0x54, 0x80, 0xec, 0x47, 0x27, 0xfa, 0x87, 0x87, 0xf5, 0x7d, 0x35, 0xc5, 0x06, 0x8d,
	0x56, 0xb5, 0x5a, 0x6b, 0x34, 0xd4, 0x34, 0x1b, 0xec, 0x6d, 0x1f, 0x1e, 0xb5, 0xf4, 0x9a, 0x3a,
	0xc7, 0xc4, 0x1c, 0xd6, 0x9b, 0x35, 0xbd, 0xbe, 0x7d, 0x64, 0xd4, 0x74, 0xfd, 0x44, 0x57, 0xe7,
	0xd9, 0x82, 0xe6, 0xe1, 0x71, 0xed, 0xa4, 0xd5, 0x54, 0x33, 0x68, 0x11, 0xf2, 0xd5, 0xed, 0x7a,
	0xb5, 0x76, 0x74, 0x54, 0xdb, 0x55, 0xb3, 0xda, 0x7f, 0x14, 0xc8, 0x0f, 0xd3, 0x28, 0x92, 0x9b,
	0xca, 0x58, 0x6e, 0xea, 0x90, 0x15, 0x48, 0x9b, 0xc8, 0xb3, 0xde, 0x9d, 0x35, 0x33, 0x87, 0x4f,
	0x27, 0x82, 0x5f, 0x0f, 0x05, 0x95, 0x7e, 0xa4, 0xc0, 0xf2, 0xc4, 0xe4, 0x97, 0xde, 0x66, 0x57,
	0x60, 0x9e, 0x5d, 0xe8, 0x44, 0x42, 0x33, 0x31, 0x88, 0x60, 0x99, 0xf4, 0x13, 0x61, 0x19, 0xed,
	0xfb, 0x90, 0x0b, 0x69, 0x13, 0x75, 0x54, 0x49, 0x52, 0x47, 0x6f, 0x43, 0x0e, 0xbb, 0x96, 0x60,
	0x4c, 0xc5, 0x32, 0x66, 0xb1, 0x6b, 0xb1, 0x91, 0xd6, 0x84, 0x15, 0x99, 0xd5, 0xb2, 0x55, 0x39,
	0xc6, 0xd4, 0xb4, 0x4c, 0x6a, 0xa2, 0x2d, 0x98, 0xe7, 0x4a, 0x4b, 0x35, 0x5e, 0x9e, 0x25, 0x11,
	0x74, 0xc1, 0xa2, 0xfd, 0x2e, 0x0d, 0xea, 0x64, 0xa9, 0x42, 0x16, 0x3c, 0x17, 0x60, 0xe2, 0x39,
	0x03, 0xcc, 0xc0, 0xcb, 0x58, 0xdf, 0x90, 0x4e, 0xde, 0x37, 0xe8, 0xcf, 0x86, 0xc2, 0xc6, 0x3b,
	0xb7, 0xaf, 0xc3, 0x95, 0xe1, 0x2e, 0xd1, 0x36, 0x22, 0x93, 0xb4, 0x37, 0x44, 0xa1, 0x98, 0x48,
	0xdf, 0xf6, 0x2d, 0x76, 0x59, 0x49, 0x40, 0x83, 0x49, 0x71, 0x8e, 0x97, 0x88, 0x7b, 0x09, 0x6b,
	0x76, 0x04, 0xe3, 0x88, 0x8a, 0x01, 0xa7, 0x43, 0x42, 0xe9, 0x0c, 0x96, 0x27, 0xa6, 0x1f, 0x91,
	0xf7, 0xf7, 0xc6, 0xf3, 0x3e, 0x01, 0xa6, 0x8a, 0x64, 0x7e, 0x1d, 0x60, 0x34, 0x81, 0xee, 0x47,
	0xa1, 0x9a, 0xc2, 0xcf, 0xf5, 0x52, 0x8c, 0x58, 0xc6, 0x19, 0x01, 0x69, 0x3f, 0x55, 0x60, 0x8e,
	0x3d, 0xa0, 0xfb, 0x30, 0x47, 0x2f, 0x7c, 0x11, 0xbe, 0x4b, 0xb1, 0x4e, 0x65, 0x2c, 0xfc, 0x4f,
	0xf3, 0xc2, 0xc7, 0x3a, 0xe7, 0x1c, 0x2f, 0x89, 0x0b, 0x52, 0x69, 0xed, 0x75, 0xc8, 0x85, 0xeb,
	0x50, 0x0e, 0xe6, 0xea, 0x27, 0xf5, 0x9a, 0x28, 0x51, 0x8d, 0x83, 0xed, 0xcd, 0xdb, 0x6f, 0xab,
	0x0a, 0xca, 0x42, 0xfa, 0x78, 0xf7, 0xb6, 0x9a, 0xd2, 0xbe, 0x60, 0x4d, 0x2a, 0xaf, 0xe8, 0x68,
	0x0d, 0x16, 0xce, 0x7b, 0xc4, 0x38, 0xc7, 0x17, 0x46, 0x04, 0xae, 0xc3, 0x79, 0x8f, 0x7c, 0x88,
	0x2f, 0x78, 0x43, 0xdc, 0x18, 0xeb, 0x76, 0xd2, 0xfc, 0xec, 0x5f, 0x99, 0xe9, 0xda, 0x90, 0xff,
	0x6a, 0xee, 0x40, 0x38, 0x72, 0xd4, 0x23, 0x95, 0xde, 0x83, 0xa5, 0xf1, 0xc9, 0xb8, 0xca, 0xbf,
	0x10, 0xf5, 0x8d, 0x07, 0xa8, 0xca, 0xd1, 0x55, 0x92, 0x17, 0x2e, 0xc3, 0x84, 0x4d, 0x25, 0x4f,
	0xd8, 0xfb, 0xb0, 0xbc, 0x8f, 0xe9, 0xd3, 0xbc, 0xde, 0xf9, 0x89, 0x02, 0x97, 0x8f, 0x6c, 0x22,
	0x64, 0x90, 0x19, 0x85, 0x5c, 0x85, 0xbc, 0xcf, 0xcb, 0x80, 0xfd, 0x89, 0xb0, 0xc2, 0xbc, 0x9e,
	0x63, 0x84, 0x86, 0xfd, 0x89, 0x78, 0x49, 0xc2, 0x26, 0xa9, 0x77, 0x8e, 0x5d, 0xd9, 0x90, 0xf3,
	0xe5, 0x4d, 0x46, 0x60, 0x57, 0xc5, 0xa9, 0xed, 0x50, 0x1c, 0x70, 0xcc, 0x98, 0xd7, 0xe5, 0x48,
	0xfb, 0x04, 0x50, 0x54, 0x0f, 0xe2, 0x7b, 0x2e, 0xc1, 0xe8, 0x3d, 0xc8, 0xf0, 0x93, 0x12, 0x19,
	0xdc, 0xb3, 0x59, 0x47, 0xf2, 0xa0, 0x57, 0x61, 0xd9, 0xc5, 0xdf, 0xa3, 0x46, 0x44, 0x1f, 0x71,
	0xf2, 0x45, 0x46, 0x7e, 0x10, 0xea, 0xa4, 0x55, 0x01, 0x55, 0x59, 0x8a, 0x3b, 0x4f, 0x63, 0xc9,
	0x1f, 0xcf, 0xc1, 0x42, 0xf4, 0x2d, 0xd9, 0x54, 0xd3, 0xb3, 0x06, 0x05, 0x0b, 0x93, 0x4e, 0x60,
	0x73, 0x00, 0xc6, 0x01, 0x7f, 0x5e, 0x8f, 0x92, 0x50, 0x13, 0xd4, 0x10, 0xfd, 0x51, 0xdc, 0xf3,
	0x1d, 0x93, 0x86, 0xa8, 0x3c, 0x41, 0x01, 0x5c, 0x96, 0x22, 0x9a, 0x52, 0x02, 0x7a, 0x2f, 0x0c,
	0xb0, 0xb9, 0xd9, 0x03, 0xec, 0xe0, 0x92, 0x0c, 0x31, 0xf4, 0x3c, 0xf0, 0x5a, 0xc1, 0x93, 0x30,
	0x27, 0xdf, 0x3a, 0x0d, 0x29, 0x93, 0xed, 0xc7, 0x7c, 0xa2, 0xf6, 0xa3, 0x04, 0x39, 0xcb, 0x26,
	0x66, 0xdb, 0xc1, 0x56, 0x31, 0xbf, 0xa6, 0xac, 0xe7, 0xf4, 0xe1, 0x18, 0x59, 0x93, 0x20, 0x54,
	0x74, 0x58, 0x1f, 0xcc, 0xa2, 0xbc, 0x74, 0x40, 0x3c, 0x16, 0x7d, 0x7a, 0xb0, 0xb7, 0xa3, 0xc2,
	0x92, 0x84, 0xed, 0xd2, 0xdc, 0xda, 0x0f, 0x15, 0x58, 0x8d, 0x54, 0x81, 0x64, 0xef, 0x4c, 0x6b,
	0x90, 0x95, 0xee, 0x93, 0xe5, 0xe0, 0x66, 0x82, 0x03, 0xeb, 0x21, 0xaf, 0xf6, 0x10, 0x56, 0xc2,
	0xba, 0xf0, 0xbf, 0x7c, 0x67, 0xab, 0xbd, 0x03, 0xc5, 0x61, 0x92, 0x4a, 0xc1, 0x33, 0xd6, 0x0c,
	0xcd, 0x82, 0xd5, 0x47, 0xb0, 0xca, 0x34, 0xdf, 0x87, 0x9c, 0xdc, 0x24, 0x4c, 0xf4, 0x44, 0xe7,
	0x1e, 0x32, 0x6b, 0x5f, 0x83, 0xd5, 0x5d, 0xec, 0xe0, 0x27, 0xb2, 0x7d, 0xcc, 0xd9, 0x7f, 0xab,
	0xc0, 0x6a, 0xcb, 0xb7, 0xcc, 0xff, 0x83, 0xec, 0xa8, 0xdb, 0xd3, 0x4f, 0xe1, 0xf6, 0xbf, 0x65,
	0x64, 0x09, 0x92, 0xcd, 0x1e, 0x6a, 0xc3, 0xca, 0x54, 0xcb, 0x3a, 0xc2, 0x0a, 0x49, 0x6f, 0xf9,
	0x2b, 0x93, 0x4d, 0x2b, 0xc7, 0x0d, 0x3e, 0xc3, 0x87, 0xdc, 0x08, 0xd8, 0x32, 0x06, 0x38, 0xb0,
	0x4f, 0x2f, 0x0c, 0xd1, 0x63, 0xca, 0xb7, 0x37, 0x77, 0x13, 0xb4, 0xa7, 0xe5, 0x87, 0x5c, 0x80,
	0x18, 0x31, 0xac, 0x28, 0x05, 0x47, 0xc9, 0xe8, 0x63, 0x58, 0xe8, 0x99, 0x9d, 0x33, 0xdb, 0xc5,
	0x06, 0x47, 0x2c, 0x69, 0xbe, 0xcd, 0x9d, 0x24, 0xdb, 0x1c, 0x0b, 0x7e, 0x7e, 0xac, 0x42, 0x6f,
	0x34, 0x60, 0xb8, 0xc3, 0xb2, 0xc9, 0x39, 0xbf, 0xda, 0x8c, 0x6e, 0x9b, 0xe3, 0xcf, 0xb4, 0x0e,
	0x8c, 0xc6, 0x6e, 0xb7, 0xfd, 0x36, 0xf2, 0xe0, 0x99, 0x68, 0x11, 0x09, 0xcf, 0x3a, 0xc7, 0x95,
	0xf8, 0x20, 0x89, 0x12, 0xd1, 0xd2, 0x23, 0x4f, 0x8c, 0xc8, 0x14, 0x0d, 0xf9, 0x70, 0x85, 0x35,
	0xea, 0x84, 0x06, 0xd8, 0x64, 0xad, 0x47, 0xb8, 0xe3, 0x7c, 0xf2, 0x1d, 0x8f, 0xbc, 0x6e, 0x23,
	0x14, 0x13, 0xee, 0xe8, 0x4c, 0xd1, 0xb4, 0x32, 0x2c, 0x8c, 0x19, 0x5c, 0x85, 0x85, 0xfa, 0x49,
	0xd3, 0x78, 0x58, 0xd3, 0x0f, 0xf7, 0x0e, 0x6b, 0xbb, 0xea, 0x25, 0xb4, 0x00, 0xb9, 0xe1, 0x48,
	0xd1, 0xaa, 0x50, 0x88, 0x18, 0x14, 0x2d, 0x43, 0xa1, 0x55, 0x6f, 0x3c, 0xa8, 0x55, 0xc3, 0xd5,
	0x8c, 0x7f, 0xc3, 0x38, 0x38, 0xdc, 0x3f, 0xa8, 0x3e, 0x68, 0x19, 0x77, 0x55, 0x05, 0x5d, 0x86,
	0xc5, 0x08, 0xe5, 0xd6, 0xa6, 0x9a, 0xd2, 0x6e, 0x8f, 0xd7, 0x62, 0xb9, 0xf5, 0x12, 0xc0, 0x71,
	0xab, 0xd1, 0x34, 0x8e, 0xb7, 0x9b, 0xd5, 0x03, 0xf5, 0x12, 0x93, 0xbd, 0x7d, 0x74, 0x74, 0xf2,
	0x91, 0x71, 0x74, 0x72, 0xd2, 0xa8, 0xa9, 0x8a, 0xb6, 0x0f, 0x68, 0xfa, 0x54, 0xa2, 0x2b, 0xd6,
	0x6b, 0xdb, 0xc7, 0xc6, 0x6e, 0x6d, 0x6f, 0xbb, 0x75, 0xd4, 0x54, 0x2f, 0xb1, 0x0e, 0x56, 0xd2,
	0x4e, 0xea, 0xaa, 0xc2, 0x24, 0x87, 0xc3, 0xbd, 0x3d, 0x35, 0xb5, 0xf9, 0x97, 0x25, 0x80, 0x2a,
	0x33, 0x9d, 0x78, 0x65, 0xf9, 0x73, 0x05, 0x0a, 0x91, 0x32, 0x8e, 0x36, 0x62, 0xec, 0x3c, 0x0d,
	0xfc, 0x4a, 0xd7, 0x42, 0x96, 0xc8, 0x27, 0xc0, 0xf2, 0xb0, 0x63, 0xd3, 0x2a, 0x9f, 0xff, 0xf3,
	0xdf, 0xbf, 0x48, 0xbd, 0xae, 0xad, 0x55, 0x06, 0x1b, 0x15, 0x59, 0x2a, 0x48, 0xe5, 0xd3, 0x51,
	0x19, 0xf9, 0xac, 0x22, 0x70, 0xcc, 0x96, 0xbc, 0x8a, 0x7f, 0xa6, 0x40, 0x2e, 0x2c, 0xeb, 0xa8,
	0x1c, 0xa3, 0xcf, 0x04, 0x2e, 0x2c, 0xcd, 0x74, 0xed, 0x6b, 0x6f, 0x72, 0x9d, 0x5e, 0x43, 0xaf,
	0xc4, 0xe9, 0x54, 0xf9, 0xd4, 0xb6, 0x3e, 0x43, 0xbf, 0x56, 0x00, 0x46, 0xa8, 0x0d, 0xc5, 0xbd,
	0x75, 0x99, 0x02, 0x9a, 0xa5, 0x8d, 0x04, 0x1c, 0xe2, 0xae, 0xd0, 0xd6, 0xb9, 0x8a, 0x1a, 0x8a,
	0x35, 0x1b, 0xfa, 0x0d, 0x73, 0xe1, 0x08, 0xd7, 0xc5, 0xbb, 0x70, 0x0a, 0x03, 0xce, 0x68, 0xb5,
	0x3b, 0x5c, 0xa5, 0x0d, 0xed, 0x8d, 0x99, 0xac, 0xb6, 0xd5, 0xe1, 0xfb, 0x6c, 0x29, 0x37, 0xd0,
	0x2f, 0xf9, 0xf7, 0xc5, 0xf0, 0x0b, 0x6d, 0xac, 0xfd, 0xa6, 0x3e, 0xe6, 0xc6, 0x85, 0xd8, 0xdb,
	0x5c, 0xb1, 0xb7, 0xb4, 0x9b, 0xb3, 0x29, 0x16, 0x30, 0xf9, 0x4c, 0xaf, 0x3f, 0x29, 0x63, 0x9d,
	0x4c, 0x88, 0x68, 0xef, 0xce, 0x9e, 0x03, 0xe3, 0xd7, 0x63, 0x29, 0xc9, 0x7d, 0xa6, 0xdd, 0xe2,
	0x5a, 0xbf, 0xa9, 0x69, 0x8f, 0xd7, 0x3a, 0xbc, 0xf0, 0xb7, 0xc2, 0xbb, 0x0f, 0xfd, 0x51, 0x19,
	0xf5, 0x42, 0xa1, 0xbe, 0xb7, 0x67, 0xcc, 0x91, 0xa7, 0x51, 0x56, 0xfa, 0x1e, 0x55, 0xe2, 0x95,
	0xad, 0x7c, 0x3a, 0xc2, 0x00, 0x9f, 0xa1, 0x3f, 0x47, 0x3b, 0xaf, 0x10, 0x11, 0xa1, 0x3b, 0xb3,
	0x26, 0xc4, 0x04, 0xfc, 0x2a, 0xdd, 0x4d, 0xce, 0x28, 0x13, 0xea, 0x06, 0x3f, 0xc1, 0xcb, 0x68,
	0x06, 0x73, 0xb3, 0x94, 0x42, 0xd3, 0x00, 0x2b, 0x36, 0x30, 0x1e, 0x8b, 0xc9, 0x4a, 0x2b, 0x53,
	0xbd, 0x42, 0xad, 0xe7, 0xd3, 0x8b, 0xd0, 0xac, 0x37, 0x12, 0x9b, 0xf5, 0x0b, 0x05, 0xd0, 0x34,
	0x4c, 0x8b, 0xd5, 0xf0, 0xb1, 0xc8, 0x2e, 0x59, 0x34, 0xdc, 0xe7, 0x6a, 0x6f, 0x6d, 0x26, 0x55,
	0x7b, 0x14, 0xc7, 0x7f, 0x50, 0x60, 0x79, 0xe2, 0xf7, 0x16, 0xb1, 0x71, 0xfc, 0xe8, 0xdf, 0x67,
	0xc4, 0x15, 0x87, 0x2a, 0xd7, 0xf5, 0x7d, 0xed, 0x56, 0x52, 0x5d, 0x83, 0xbe, 0xbb, 0x25, 0xbf,
	0x80, 0xed, 0x9c, 0x43, 0xb1, 0xe3, 0xf5, 0xc2, 0x8d, 0xc6, 0xd4, 0x7a, 0xa0, 0x7c, 0xbc, 0x2f,
	0xe9, 0x5d, 0xcf, 0x31, 0xdd, 0x6e, 0xd9, 0x0b, 0xba, 0x95, 0x2e, 0x76, 0xb9, 0xab, 0x2b, 0x62,
	0xca, 0xf4, 0x6d, 0xf2, 0x98, 0x9f, 0xf3, 0xbc, 0x3b, 0x1a, 0xfd, 0x3e, 0x95, 0xde, 0xaf, 0xee,
	0xb4, 0x33, 0x9c, 0xf3, 0xd6, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x25, 0xf1, 0x0e, 0xc9, 0x07,
	0x24, 0x00, 0x00,
}
