// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/containeranalysis/v1beta1/vulnerability/vulnerability.proto

package vulnerability

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/common"
	_package "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/package"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Note provider-assigned severity/impact ranking.
type Severity int32

const (
	// Unknown.
	Severity_SEVERITY_UNSPECIFIED Severity = 0
	// Minimal severity.
	Severity_MINIMAL Severity = 1
	// Low severity.
	Severity_LOW Severity = 2
	// Medium severity.
	Severity_MEDIUM Severity = 3
	// High severity.
	Severity_HIGH Severity = 4
	// Critical severity.
	Severity_CRITICAL Severity = 5
)

var Severity_name = map[int32]string{
	0: "SEVERITY_UNSPECIFIED",
	1: "MINIMAL",
	2: "LOW",
	3: "MEDIUM",
	4: "HIGH",
	5: "CRITICAL",
}

var Severity_value = map[string]int32{
	"SEVERITY_UNSPECIFIED": 0,
	"MINIMAL":              1,
	"LOW":                  2,
	"MEDIUM":               3,
	"HIGH":                 4,
	"CRITICAL":             5,
}

func (x Severity) String() string {
	return proto.EnumName(Severity_name, int32(x))
}

func (Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{0}
}

// Vulnerability provides metadata about a security vulnerability.
type Vulnerability struct {
	// The CVSS score for this vulnerability.
	CvssScore float32 `protobuf:"fixed32,1,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// Note provider assigned impact of the vulnerability.
	Severity Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1beta1.vulnerability.Severity" json:"severity,omitempty"`
	// All information about the package to specifically identify this
	// vulnerability. One entry per (version range and cpe_uri) the package
	// vulnerability has manifested in.
	Details              []*Vulnerability_Detail `protobuf:"bytes,3,rep,name=details,proto3" json:"details,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Vulnerability) Reset()         { *m = Vulnerability{} }
func (m *Vulnerability) String() string { return proto.CompactTextString(m) }
func (*Vulnerability) ProtoMessage()    {}
func (*Vulnerability) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{0}
}

func (m *Vulnerability) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Vulnerability.Unmarshal(m, b)
}
func (m *Vulnerability) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Vulnerability.Marshal(b, m, deterministic)
}
func (m *Vulnerability) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Vulnerability.Merge(m, src)
}
func (m *Vulnerability) XXX_Size() int {
	return xxx_messageInfo_Vulnerability.Size(m)
}
func (m *Vulnerability) XXX_DiscardUnknown() {
	xxx_messageInfo_Vulnerability.DiscardUnknown(m)
}

var xxx_messageInfo_Vulnerability proto.InternalMessageInfo

func (m *Vulnerability) GetCvssScore() float32 {
	if m != nil {
		return m.CvssScore
	}
	return 0
}

func (m *Vulnerability) GetSeverity() Severity {
	if m != nil {
		return m.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (m *Vulnerability) GetDetails() []*Vulnerability_Detail {
	if m != nil {
		return m.Details
	}
	return nil
}

// Identifies all occurrences of this vulnerability in the package for a
// specific distro/location. For example: glibc in
// cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
type Vulnerability_Detail struct {
	// The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) in
	// which the vulnerability manifests.  Examples include distro or storage
	// location for vulnerable jar.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// The name of the package where the vulnerability was found.
	Package string `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
	// The min version of the package in which the vulnerability exists.
	MinAffectedVersion *_package.Version `protobuf:"bytes,3,opt,name=min_affected_version,json=minAffectedVersion,proto3" json:"min_affected_version,omitempty"`
	// The max version of the package in which the vulnerability exists.
	MaxAffectedVersion *_package.Version `protobuf:"bytes,4,opt,name=max_affected_version,json=maxAffectedVersion,proto3" json:"max_affected_version,omitempty"`
	// The severity (eg: distro assigned severity) for this vulnerability.
	SeverityName string `protobuf:"bytes,5,opt,name=severity_name,json=severityName,proto3" json:"severity_name,omitempty"`
	// A vendor-specific description of this note.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// The fix for this specific package version.
	FixedLocation *VulnerabilityLocation `protobuf:"bytes,7,opt,name=fixed_location,json=fixedLocation,proto3" json:"fixed_location,omitempty"`
	// The type of package; whether native or non native(ruby gems, node.js
	// packages etc).
	PackageType string `protobuf:"bytes,8,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	// Whether this detail is obsolete. Occurrences are expected not to point to
	// obsolete details.
	IsObsolete           bool     `protobuf:"varint,9,opt,name=is_obsolete,json=isObsolete,proto3" json:"is_obsolete,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Vulnerability_Detail) Reset()         { *m = Vulnerability_Detail{} }
func (m *Vulnerability_Detail) String() string { return proto.CompactTextString(m) }
func (*Vulnerability_Detail) ProtoMessage()    {}
func (*Vulnerability_Detail) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{0, 0}
}

func (m *Vulnerability_Detail) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Vulnerability_Detail.Unmarshal(m, b)
}
func (m *Vulnerability_Detail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Vulnerability_Detail.Marshal(b, m, deterministic)
}
func (m *Vulnerability_Detail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Vulnerability_Detail.Merge(m, src)
}
func (m *Vulnerability_Detail) XXX_Size() int {
	return xxx_messageInfo_Vulnerability_Detail.Size(m)
}
func (m *Vulnerability_Detail) XXX_DiscardUnknown() {
	xxx_messageInfo_Vulnerability_Detail.DiscardUnknown(m)
}

var xxx_messageInfo_Vulnerability_Detail proto.InternalMessageInfo

func (m *Vulnerability_Detail) GetCpeUri() string {
	if m != nil {
		return m.CpeUri
	}
	return ""
}

func (m *Vulnerability_Detail) GetPackage() string {
	if m != nil {
		return m.Package
	}
	return ""
}

func (m *Vulnerability_Detail) GetMinAffectedVersion() *_package.Version {
	if m != nil {
		return m.MinAffectedVersion
	}
	return nil
}

func (m *Vulnerability_Detail) GetMaxAffectedVersion() *_package.Version {
	if m != nil {
		return m.MaxAffectedVersion
	}
	return nil
}

func (m *Vulnerability_Detail) GetSeverityName() string {
	if m != nil {
		return m.SeverityName
	}
	return ""
}

func (m *Vulnerability_Detail) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Vulnerability_Detail) GetFixedLocation() *VulnerabilityLocation {
	if m != nil {
		return m.FixedLocation
	}
	return nil
}

func (m *Vulnerability_Detail) GetPackageType() string {
	if m != nil {
		return m.PackageType
	}
	return ""
}

func (m *Vulnerability_Detail) GetIsObsolete() bool {
	if m != nil {
		return m.IsObsolete
	}
	return false
}

// Details of a vulnerability occurrence.
type Details struct {
	// The type of package; whether native or non native(ruby gems, node.js
	// packages etc)
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The note provider assigned Severity of the vulnerability.
	Severity Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1beta1.vulnerability.Severity" json:"severity,omitempty"`
	// Output only. The CVSS score of this vulnerability. CVSS score is on a
	// scale of 0-10 where 0 indicates low severity and 10 indicates high
	// severity.
	CvssScore float32 `protobuf:"fixed32,3,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// The set of affected locations and their fixes (if available) within the
	// associated resource.
	PackageIssue []*PackageIssue `protobuf:"bytes,4,rep,name=package_issue,json=packageIssue,proto3" json:"package_issue,omitempty"`
	// Output only. A one sentence description of this vulnerability.
	ShortDescription string `protobuf:"bytes,5,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// Output only. A detailed description of this vulnerability.
	LongDescription string `protobuf:"bytes,6,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Output only. URLs related to this vulnerability.
	RelatedUrls          []*common.RelatedUrl `protobuf:"bytes,7,rep,name=related_urls,json=relatedUrls,proto3" json:"related_urls,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Details) Reset()         { *m = Details{} }
func (m *Details) String() string { return proto.CompactTextString(m) }
func (*Details) ProtoMessage()    {}
func (*Details) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{1}
}

func (m *Details) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Details.Unmarshal(m, b)
}
func (m *Details) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Details.Marshal(b, m, deterministic)
}
func (m *Details) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Details.Merge(m, src)
}
func (m *Details) XXX_Size() int {
	return xxx_messageInfo_Details.Size(m)
}
func (m *Details) XXX_DiscardUnknown() {
	xxx_messageInfo_Details.DiscardUnknown(m)
}

var xxx_messageInfo_Details proto.InternalMessageInfo

func (m *Details) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Details) GetSeverity() Severity {
	if m != nil {
		return m.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (m *Details) GetCvssScore() float32 {
	if m != nil {
		return m.CvssScore
	}
	return 0
}

func (m *Details) GetPackageIssue() []*PackageIssue {
	if m != nil {
		return m.PackageIssue
	}
	return nil
}

func (m *Details) GetShortDescription() string {
	if m != nil {
		return m.ShortDescription
	}
	return ""
}

func (m *Details) GetLongDescription() string {
	if m != nil {
		return m.LongDescription
	}
	return ""
}

func (m *Details) GetRelatedUrls() []*common.RelatedUrl {
	if m != nil {
		return m.RelatedUrls
	}
	return nil
}

// This message wraps a location affected by a vulnerability and its
// associated fix (if one is available).
type PackageIssue struct {
	// The location of the vulnerability.
	AffectedLocation *VulnerabilityLocation `protobuf:"bytes,1,opt,name=affected_location,json=affectedLocation,proto3" json:"affected_location,omitempty"`
	// The location of the available fix for vulnerability.
	FixedLocation *VulnerabilityLocation `protobuf:"bytes,2,opt,name=fixed_location,json=fixedLocation,proto3" json:"fixed_location,omitempty"`
	// The severity (e.g., distro assigned severity) for this vulnerability.
	SeverityName         string   `protobuf:"bytes,3,opt,name=severity_name,json=severityName,proto3" json:"severity_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PackageIssue) Reset()         { *m = PackageIssue{} }
func (m *PackageIssue) String() string { return proto.CompactTextString(m) }
func (*PackageIssue) ProtoMessage()    {}
func (*PackageIssue) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{2}
}

func (m *PackageIssue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PackageIssue.Unmarshal(m, b)
}
func (m *PackageIssue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PackageIssue.Marshal(b, m, deterministic)
}
func (m *PackageIssue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PackageIssue.Merge(m, src)
}
func (m *PackageIssue) XXX_Size() int {
	return xxx_messageInfo_PackageIssue.Size(m)
}
func (m *PackageIssue) XXX_DiscardUnknown() {
	xxx_messageInfo_PackageIssue.DiscardUnknown(m)
}

var xxx_messageInfo_PackageIssue proto.InternalMessageInfo

func (m *PackageIssue) GetAffectedLocation() *VulnerabilityLocation {
	if m != nil {
		return m.AffectedLocation
	}
	return nil
}

func (m *PackageIssue) GetFixedLocation() *VulnerabilityLocation {
	if m != nil {
		return m.FixedLocation
	}
	return nil
}

func (m *PackageIssue) GetSeverityName() string {
	if m != nil {
		return m.SeverityName
	}
	return ""
}

// The location of the vulnerability.
type VulnerabilityLocation struct {
	// The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/)
	// format. Examples include distro or storage location for vulnerable jar.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// The package being described.
	Package string `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
	// The version of the package being described.
	Version              *_package.Version `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *VulnerabilityLocation) Reset()         { *m = VulnerabilityLocation{} }
func (m *VulnerabilityLocation) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityLocation) ProtoMessage()    {}
func (*VulnerabilityLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{3}
}

func (m *VulnerabilityLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerabilityLocation.Unmarshal(m, b)
}
func (m *VulnerabilityLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerabilityLocation.Marshal(b, m, deterministic)
}
func (m *VulnerabilityLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityLocation.Merge(m, src)
}
func (m *VulnerabilityLocation) XXX_Size() int {
	return xxx_messageInfo_VulnerabilityLocation.Size(m)
}
func (m *VulnerabilityLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityLocation.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityLocation proto.InternalMessageInfo

func (m *VulnerabilityLocation) GetCpeUri() string {
	if m != nil {
		return m.CpeUri
	}
	return ""
}

func (m *VulnerabilityLocation) GetPackage() string {
	if m != nil {
		return m.Package
	}
	return ""
}

func (m *VulnerabilityLocation) GetVersion() *_package.Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func init() {
	proto.RegisterType((*Vulnerability)(nil), "grafeas.v1beta1.vulnerability.Vulnerability")
	proto.RegisterType((*Vulnerability_Detail)(nil), "grafeas.v1beta1.vulnerability.Vulnerability.Detail")
	proto.RegisterType((*Details)(nil), "grafeas.v1beta1.vulnerability.Details")
	proto.RegisterType((*PackageIssue)(nil), "grafeas.v1beta1.vulnerability.PackageIssue")
	proto.RegisterType((*VulnerabilityLocation)(nil), "grafeas.v1beta1.vulnerability.VulnerabilityLocation")
	proto.RegisterEnum("grafeas.v1beta1.vulnerability.Severity", Severity_name, Severity_value)
}

func init() {
	proto.RegisterFile("google/devtools/containeranalysis/v1beta1/vulnerability/vulnerability.proto", fileDescriptor_2a1e5608ee0186b1)
}

var fileDescriptor_2a1e5608ee0186b1 = []byte{
	// 727 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xdd, 0x6e, 0xda, 0x48,
	0x14, 0x5e, 0x63, 0x82, 0xe1, 0x00, 0x59, 0x67, 0x94, 0xd5, 0x5a, 0x59, 0x45, 0xeb, 0x65, 0x2f,
	0x4a, 0x1b, 0xc9, 0x28, 0x49, 0xaf, 0x5a, 0xb5, 0x15, 0x05, 0x9a, 0x58, 0x85, 0x04, 0x99, 0x90,
	0xaa, 0xad, 0x54, 0x6b, 0x30, 0x83, 0x3b, 0xaa, 0xf1, 0x58, 0x1e, 0x83, 0xc2, 0x0b, 0xf4, 0x3a,
	0xcf, 0xd0, 0xd7, 0xe9, 0xa3, 0xf4, 0xb2, 0x2f, 0x50, 0x31, 0xb6, 0x11, 0x84, 0x2a, 0x3f, 0x6d,
	0xae, 0xec, 0xf3, 0xf9, 0x9c, 0x6f, 0xbe, 0x33, 0xe7, 0xf3, 0x0c, 0xbc, 0x76, 0x19, 0x73, 0x3d,
	0x52, 0x1b, 0x92, 0x69, 0xc4, 0x98, 0xc7, 0x6b, 0x0e, 0xf3, 0x23, 0x4c, 0x7d, 0x12, 0x62, 0x1f,
	0x7b, 0x33, 0x4e, 0x79, 0x6d, 0xba, 0x3f, 0x20, 0x11, 0xde, 0xaf, 0x4d, 0x27, 0xde, 0x1c, 0x1e,
	0x50, 0x8f, 0x46, 0xb3, 0xd5, 0xc8, 0x08, 0x42, 0x16, 0x31, 0xb4, 0xeb, 0x86, 0x78, 0x44, 0x30,
	0x37, 0x92, 0x12, 0x63, 0x25, 0x69, 0xe7, 0xd9, 0xed, 0xd7, 0x72, 0xd8, 0x78, 0xcc, 0xfc, 0xe4,
	0x11, 0xb3, 0xef, 0xbc, 0xb8, 0x7d, 0x79, 0x80, 0x9d, 0x4f, 0xd8, 0x25, 0xe9, 0x33, 0x26, 0xa8,
	0x5c, 0x6e, 0x40, 0xf9, 0x7c, 0x59, 0x11, 0xda, 0x05, 0x70, 0xa6, 0x9c, 0xdb, 0xdc, 0x61, 0x21,
	0xd1, 0x24, 0x5d, 0xaa, 0x66, 0xac, 0xc2, 0x1c, 0xe9, 0xcd, 0x01, 0xd4, 0x80, 0x3c, 0x27, 0x53,
	0x12, 0xd2, 0x68, 0xa6, 0x65, 0x74, 0xa9, 0xba, 0x79, 0xf0, 0xc0, 0xb8, 0xb6, 0x45, 0xa3, 0x97,
	0xa4, 0x5b, 0x8b, 0x42, 0xd4, 0x01, 0x65, 0x48, 0x22, 0x4c, 0x3d, 0xae, 0xc9, 0xba, 0x5c, 0x2d,
	0x1e, 0x1c, 0xde, 0xc0, 0xb1, 0x22, 0xd1, 0x68, 0x8a, 0x5a, 0x2b, 0xe5, 0xd8, 0xf9, 0x2a, 0x43,
	0x2e, 0xc6, 0xd0, 0xdf, 0xa0, 0x38, 0x01, 0xb1, 0x27, 0x21, 0x15, 0xd2, 0x0b, 0x56, 0xce, 0x09,
	0x48, 0x3f, 0xa4, 0x48, 0x03, 0x25, 0xe9, 0x5c, 0xc8, 0x2e, 0x58, 0x69, 0x88, 0x2c, 0xd8, 0x1e,
	0x53, 0xdf, 0xc6, 0xa3, 0x11, 0x71, 0x22, 0x32, 0xb4, 0xa7, 0x24, 0xe4, 0x94, 0xf9, 0x9a, 0xac,
	0x4b, 0xd5, 0xe2, 0x81, 0xbe, 0xa6, 0x2c, 0xdd, 0xc0, 0xf3, 0x38, 0xcf, 0x42, 0x63, 0xea, 0xd7,
	0x93, 0xe2, 0x04, 0x13, 0x9c, 0xf8, 0x62, 0x9d, 0x33, 0x7b, 0x6b, 0x4e, 0x7c, 0x71, 0x95, 0xf3,
	0x7f, 0x28, 0xa7, 0x1b, 0x68, 0xfb, 0x78, 0x4c, 0xb4, 0x0d, 0xd1, 0x47, 0x29, 0x05, 0x4f, 0xf0,
	0x98, 0x20, 0x1d, 0x8a, 0x43, 0xc2, 0x9d, 0x90, 0x06, 0xd1, 0x7c, 0xbd, 0x9c, 0x48, 0x59, 0x86,
	0xd0, 0x7b, 0xd8, 0x1c, 0xd1, 0x0b, 0x32, 0xb4, 0x3d, 0xe6, 0x60, 0x91, 0xa4, 0x08, 0x51, 0x8f,
	0xef, 0x32, 0x82, 0x76, 0x52, 0x6b, 0x95, 0x05, 0x57, 0x1a, 0xa2, 0xff, 0xa0, 0x94, 0xb4, 0x62,
	0x47, 0xb3, 0x80, 0x68, 0xf9, 0x78, 0xfd, 0x04, 0x3b, 0x9b, 0x05, 0x04, 0xfd, 0x0b, 0x45, 0xca,
	0x6d, 0x36, 0xe0, 0xcc, 0x23, 0x11, 0xd1, 0x0a, 0xba, 0x54, 0xcd, 0x5b, 0x40, 0xf9, 0x69, 0x82,
	0x54, 0xbe, 0x65, 0x40, 0x89, 0xa7, 0xc9, 0x11, 0x82, 0xac, 0xe0, 0x89, 0x67, 0x29, 0xde, 0xef,
	0xc7, 0x81, 0xab, 0x2e, 0x97, 0xaf, 0xba, 0xbc, 0x0b, 0xe5, 0xb4, 0x0f, 0xca, 0xf9, 0x84, 0x68,
	0x59, 0x61, 0xd3, 0xbd, 0x1b, 0x16, 0xea, 0xc6, 0x35, 0xe6, 0xbc, 0xc4, 0x4a, 0x77, 0x42, 0x44,
	0x68, 0x0f, 0xb6, 0xf8, 0x47, 0x16, 0x46, 0xf6, 0xf2, 0x78, 0xe2, 0x09, 0xaa, 0xe2, 0x43, 0x73,
	0x69, 0x46, 0x0f, 0x41, 0xf5, 0x98, 0xef, 0xda, 0xeb, 0xa3, 0xfc, 0x73, 0x8e, 0x2f, 0xa7, 0x3e,
	0x87, 0x52, 0x48, 0x3c, 0x3c, 0x37, 0xd9, 0x24, 0xf4, 0xb8, 0xa6, 0x08, 0xa1, 0xff, 0xac, 0x09,
	0xb5, 0xe2, 0xa4, 0x7e, 0xe8, 0x59, 0xc5, 0x70, 0xf1, 0xce, 0x2b, 0xdf, 0x25, 0x28, 0x2d, 0xcb,
	0x46, 0x18, 0xb6, 0x16, 0xb6, 0x5d, 0x58, 0x44, 0xfa, 0x0d, 0x8b, 0xa8, 0x29, 0xdd, 0xc2, 0x25,
	0xeb, 0x16, 0xcc, 0xdc, 0x9f, 0x05, 0xd7, 0x7e, 0x13, 0x79, 0xfd, 0x37, 0xa9, 0x7c, 0x96, 0xe0,
	0xaf, 0x9f, 0xb2, 0xfd, 0xca, 0x01, 0xf2, 0x04, 0x94, 0xbb, 0x9e, 0x19, 0x69, 0xc1, 0xa3, 0x0f,
	0x90, 0x4f, 0xdd, 0x89, 0x34, 0xd8, 0xee, 0xb5, 0xce, 0x5b, 0x96, 0x79, 0xf6, 0xd6, 0xee, 0x9f,
	0xf4, 0xba, 0xad, 0x86, 0xf9, 0xca, 0x6c, 0x35, 0xd5, 0x3f, 0x50, 0x11, 0x94, 0x8e, 0x79, 0x62,
	0x76, 0xea, 0x6d, 0x55, 0x42, 0x0a, 0xc8, 0xed, 0xd3, 0x37, 0x6a, 0x06, 0x01, 0xe4, 0x3a, 0xad,
	0xa6, 0xd9, 0xef, 0xa8, 0x32, 0xca, 0x43, 0xf6, 0xd8, 0x3c, 0x3a, 0x56, 0xb3, 0xa8, 0x04, 0xf9,
	0x86, 0x65, 0x9e, 0x99, 0x8d, 0x7a, 0x5b, 0xdd, 0x78, 0x79, 0x29, 0x81, 0x4e, 0xd9, 0xf5, 0xfb,
	0xda, 0x95, 0xde, 0x0d, 0xe3, 0x7b, 0xc4, 0x70, 0x99, 0x87, 0x7d, 0xd7, 0x60, 0xa1, 0x5b, 0x73,
	0x89, 0x2f, 0xae, 0x88, 0x5a, 0xfc, 0x09, 0x07, 0x94, 0xdf, 0xf9, 0x46, 0x7c, 0xba, 0x12, 0x7d,
	0xc9, 0xc8, 0x47, 0x56, 0x7d, 0x90, 0x13, 0xb4, 0x87, 0x3f, 0x02, 0x00, 0x00, 0xff, 0xff, 0xfd,
	0xfb, 0x4c, 0x27, 0x67, 0x07, 0x00, 0x00,
}
