package adhybridhealthservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ServicesClient is the REST APIs for Azure Active Directory Connect Health
type ServicesClient struct {
	BaseClient
}

// NewServicesClient creates an instance of the ServicesClient client.
func NewServicesClient() ServicesClient {
	return NewServicesClientWithBaseURI(DefaultBaseURI)
}

// NewServicesClientWithBaseURI creates an instance of the ServicesClient client.
func NewServicesClientWithBaseURI(baseURI string) ServicesClient {
	return ServicesClient{NewWithBaseURI(baseURI)}
}

// Add onboards a service for a given tenant in Azure Active Directory Connect Health.
// Parameters:
// service - the service object.
func (client ServicesClient) Add(ctx context.Context, service ServiceProperties) (result ServiceProperties, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.Add")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddPreparer(ctx, service)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Add", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Add", resp, "Failure sending request")
		return
	}

	result, err = client.AddResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Add", resp, "Failure responding to request")
	}

	return
}

// AddPreparer prepares the Add request.
func (client ServicesClient) AddPreparer(ctx context.Context, service ServiceProperties) (*http.Request, error) {
	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.ADHybridHealthService/services"),
		autorest.WithJSON(service),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSender sends the Add request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) AddSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddResponder handles the response to the Add request. The method always
// closes the http.Response Body.
func (client ServicesClient) AddResponder(resp *http.Response) (result ServiceProperties, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddAlertFeedback adds an alert feedback submitted by customer.
// Parameters:
// serviceName - the name of the service.
// alertFeedback - the alert feedback.
func (client ServicesClient) AddAlertFeedback(ctx context.Context, serviceName string, alertFeedback AlertFeedback) (result AlertFeedback, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.AddAlertFeedback")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddAlertFeedbackPreparer(ctx, serviceName, alertFeedback)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "AddAlertFeedback", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddAlertFeedbackSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "AddAlertFeedback", resp, "Failure sending request")
		return
	}

	result, err = client.AddAlertFeedbackResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "AddAlertFeedback", resp, "Failure responding to request")
	}

	return
}

// AddAlertFeedbackPreparer prepares the AddAlertFeedback request.
func (client ServicesClient) AddAlertFeedbackPreparer(ctx context.Context, serviceName string, alertFeedback AlertFeedback) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/feedbacktype/alerts/feedback", pathParameters),
		autorest.WithJSON(alertFeedback),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddAlertFeedbackSender sends the AddAlertFeedback request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) AddAlertFeedbackSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddAlertFeedbackResponder handles the response to the AddAlertFeedback request. The method always
// closes the http.Response Body.
func (client ServicesClient) AddAlertFeedbackResponder(resp *http.Response) (result AlertFeedback, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a service which is onboarded to Azure Active Directory Connect Health.
// Parameters:
// serviceName - the name of the service which needs to be deleted.
// confirm - indicates if the service will be permanently deleted or disabled. True indicates that the service
// will be permanently deleted and False indicates that the service will be marked disabled and then deleted
// after 30 days, if it is not re-registered.
func (client ServicesClient) Delete(ctx context.Context, serviceName string, confirm *bool) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, serviceName, confirm)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ServicesClient) DeletePreparer(ctx context.Context, serviceName string, confirm *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if confirm != nil {
		queryParameters["confirm"] = autorest.Encode("query", *confirm)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ServicesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the details of a service for a tenant having Azure AD Premium license and is onboarded to Azure Active
// Directory Connect Health.
// Parameters:
// serviceName - the name of the service.
func (client ServicesClient) Get(ctx context.Context, serviceName string) (result ServiceProperties, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, serviceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ServicesClient) GetPreparer(ctx context.Context, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ServicesClient) GetResponder(resp *http.Response) (result ServiceProperties, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFeatureAvailibility checks if the service has all the pre-requisites met to use a feature.
// Parameters:
// serviceName - the name of the service.
// featureName - the name of the feature.
func (client ServicesClient) GetFeatureAvailibility(ctx context.Context, serviceName string, featureName string) (result Result, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.GetFeatureAvailibility")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetFeatureAvailibilityPreparer(ctx, serviceName, featureName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetFeatureAvailibility", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetFeatureAvailibilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetFeatureAvailibility", resp, "Failure sending request")
		return
	}

	result, err = client.GetFeatureAvailibilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetFeatureAvailibility", resp, "Failure responding to request")
	}

	return
}

// GetFeatureAvailibilityPreparer prepares the GetFeatureAvailibility request.
func (client ServicesClient) GetFeatureAvailibilityPreparer(ctx context.Context, serviceName string, featureName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"featureName": autorest.Encode("path", featureName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/checkServiceFeatureAvailibility/{featureName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetFeatureAvailibilitySender sends the GetFeatureAvailibility request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) GetFeatureAvailibilitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetFeatureAvailibilityResponder handles the response to the GetFeatureAvailibility request. The method always
// closes the http.Response Body.
func (client ServicesClient) GetFeatureAvailibilityResponder(resp *http.Response) (result Result, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMetricMetadata gets the service related metrics information.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
func (client ServicesClient) GetMetricMetadata(ctx context.Context, serviceName string, metricName string) (result MetricMetadata, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.GetMetricMetadata")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMetricMetadataPreparer(ctx, serviceName, metricName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetMetricMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMetricMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetMetricMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.GetMetricMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetMetricMetadata", resp, "Failure responding to request")
	}

	return
}

// GetMetricMetadataPreparer prepares the GetMetricMetadata request.
func (client ServicesClient) GetMetricMetadataPreparer(ctx context.Context, serviceName string, metricName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"metricName":  autorest.Encode("path", metricName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metricmetadata/{metricName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMetricMetadataSender sends the GetMetricMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) GetMetricMetadataSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetMetricMetadataResponder handles the response to the GetMetricMetadata request. The method always
// closes the http.Response Body.
func (client ServicesClient) GetMetricMetadataResponder(resp *http.Response) (result MetricMetadata, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMetricMetadataForGroup gets the service related metrics for a given metric and group combination.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
// groupName - the group name
// groupKey - the group key
// fromDate - the start date.
// toDate - the end date.
func (client ServicesClient) GetMetricMetadataForGroup(ctx context.Context, serviceName string, metricName string, groupName string, groupKey string, fromDate *date.Time, toDate *date.Time) (result MetricSets, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.GetMetricMetadataForGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMetricMetadataForGroupPreparer(ctx, serviceName, metricName, groupName, groupKey, fromDate, toDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetMetricMetadataForGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMetricMetadataForGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetMetricMetadataForGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetMetricMetadataForGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetMetricMetadataForGroup", resp, "Failure responding to request")
	}

	return
}

// GetMetricMetadataForGroupPreparer prepares the GetMetricMetadataForGroup request.
func (client ServicesClient) GetMetricMetadataForGroupPreparer(ctx context.Context, serviceName string, metricName string, groupName string, groupKey string, fromDate *date.Time, toDate *date.Time) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"groupName":   autorest.Encode("path", groupName),
		"metricName":  autorest.Encode("path", metricName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(groupKey) > 0 {
		queryParameters["groupKey"] = autorest.Encode("query", groupKey)
	}
	if fromDate != nil {
		queryParameters["fromDate"] = autorest.Encode("query", *fromDate)
	}
	if toDate != nil {
		queryParameters["toDate"] = autorest.Encode("query", *toDate)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metricmetadata/{metricName}/groups/{groupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMetricMetadataForGroupSender sends the GetMetricMetadataForGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) GetMetricMetadataForGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetMetricMetadataForGroupResponder handles the response to the GetMetricMetadataForGroup request. The method always
// closes the http.Response Body.
func (client ServicesClient) GetMetricMetadataForGroupResponder(resp *http.Response) (result MetricSets, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTenantWhitelisting checks if the tenant, to which a service is registered, is whitelisted to use a feature.
// Parameters:
// serviceName - the name of the service.
// featureName - the name of the feature.
func (client ServicesClient) GetTenantWhitelisting(ctx context.Context, serviceName string, featureName string) (result Result, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.GetTenantWhitelisting")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetTenantWhitelistingPreparer(ctx, serviceName, featureName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetTenantWhitelisting", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTenantWhitelistingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetTenantWhitelisting", resp, "Failure sending request")
		return
	}

	result, err = client.GetTenantWhitelistingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "GetTenantWhitelisting", resp, "Failure responding to request")
	}

	return
}

// GetTenantWhitelistingPreparer prepares the GetTenantWhitelisting request.
func (client ServicesClient) GetTenantWhitelistingPreparer(ctx context.Context, serviceName string, featureName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"featureName": autorest.Encode("path", featureName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/TenantWhitelisting/{featureName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTenantWhitelistingSender sends the GetTenantWhitelisting request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) GetTenantWhitelistingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetTenantWhitelistingResponder handles the response to the GetTenantWhitelisting request. The method always
// closes the http.Response Body.
func (client ServicesClient) GetTenantWhitelistingResponder(resp *http.Response) (result Result, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List gets the details of services, for a tenant, that are onboarded to Azure Active Directory Connect Health.
// Parameters:
// filter - the service property filter to apply.
// serviceType - the service type for the services onboarded to Azure Active Directory Connect Health.
// Depending on whether the service is monitoring, ADFS, Sync or ADDS roles, the service type can either be
// AdFederationService or AadSyncService or AdDomainService.
// skipCount - the skip count, which specifies the number of elements that can be bypassed from a sequence and
// then return the remaining elements.
// takeCount - the take count , which specifies the number of elements that can be returned from a sequence.
func (client ServicesClient) List(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (result ServicesPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.List")
		defer func() {
			sc := -1
			if result.s.Response.Response != nil {
				sc = result.s.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, filter, serviceType, skipCount, takeCount)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.s.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "List", resp, "Failure sending request")
		return
	}

	result.s, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ServicesClient) ListPreparer(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (*http.Request, error) {
	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(serviceType) > 0 {
		queryParameters["serviceType"] = autorest.Encode("query", serviceType)
	}
	if skipCount != nil {
		queryParameters["skipCount"] = autorest.Encode("query", *skipCount)
	}
	if takeCount != nil {
		queryParameters["takeCount"] = autorest.Encode("query", *takeCount)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.ADHybridHealthService/services"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListResponder(resp *http.Response) (result Services, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ServicesClient) listNextResults(ctx context.Context, lastResults Services) (result Services, err error) {
	req, err := lastResults.servicesPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServicesClient) ListComplete(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (result ServicesIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, filter, serviceType, skipCount, takeCount)
	return
}

// ListAlertFeedback gets a list of all alert feedback for a given tenant and alert type.
// Parameters:
// serviceName - the name of the service.
// shortName - the name of the alert.
func (client ServicesClient) ListAlertFeedback(ctx context.Context, serviceName string, shortName string) (result AlertFeedbacks, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListAlertFeedback")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListAlertFeedbackPreparer(ctx, serviceName, shortName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListAlertFeedback", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAlertFeedbackSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListAlertFeedback", resp, "Failure sending request")
		return
	}

	result, err = client.ListAlertFeedbackResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListAlertFeedback", resp, "Failure responding to request")
	}

	return
}

// ListAlertFeedbackPreparer prepares the ListAlertFeedback request.
func (client ServicesClient) ListAlertFeedbackPreparer(ctx context.Context, serviceName string, shortName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
		"shortName":   autorest.Encode("path", shortName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/feedbacktype/alerts/{shortName}/alertfeedback", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAlertFeedbackSender sends the ListAlertFeedback request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListAlertFeedbackSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListAlertFeedbackResponder handles the response to the ListAlertFeedback request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListAlertFeedbackResponder(resp *http.Response) (result AlertFeedbacks, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAlerts gets the alerts for a given service.
// Parameters:
// serviceName - the name of the service.
// filter - the alert property filter to apply.
// state - the alert state to query for.
// from - the start date to query for.
// toParameter - the end date till when to query for.
func (client ServicesClient) ListAlerts(ctx context.Context, serviceName string, filter string, state string, from *date.Time, toParameter *date.Time) (result AlertsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListAlerts")
		defer func() {
			sc := -1
			if result.a.Response.Response != nil {
				sc = result.a.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listAlertsNextResults
	req, err := client.ListAlertsPreparer(ctx, serviceName, filter, state, from, toParameter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListAlerts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAlertsSender(req)
	if err != nil {
		result.a.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListAlerts", resp, "Failure sending request")
		return
	}

	result.a, err = client.ListAlertsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListAlerts", resp, "Failure responding to request")
	}

	return
}

// ListAlertsPreparer prepares the ListAlerts request.
func (client ServicesClient) ListAlertsPreparer(ctx context.Context, serviceName string, filter string, state string, from *date.Time, toParameter *date.Time) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(state) > 0 {
		queryParameters["state"] = autorest.Encode("query", state)
	}
	if from != nil {
		queryParameters["from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["to"] = autorest.Encode("query", *toParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAlertsSender sends the ListAlerts request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListAlertsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListAlertsResponder handles the response to the ListAlerts request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListAlertsResponder(resp *http.Response) (result Alerts, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listAlertsNextResults retrieves the next set of results, if any.
func (client ServicesClient) listAlertsNextResults(ctx context.Context, lastResults Alerts) (result Alerts, err error) {
	req, err := lastResults.alertsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listAlertsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListAlertsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listAlertsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListAlertsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listAlertsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListAlertsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServicesClient) ListAlertsComplete(ctx context.Context, serviceName string, filter string, state string, from *date.Time, toParameter *date.Time) (result AlertsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListAlerts")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListAlerts(ctx, serviceName, filter, state, from, toParameter)
	return
}

// ListExportErrors gets the count of latest AAD export errors.
// Parameters:
// serviceName - the name of the service.
func (client ServicesClient) ListExportErrors(ctx context.Context, serviceName string) (result ErrorCounts, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListExportErrors")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListExportErrorsPreparer(ctx, serviceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListExportErrors", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListExportErrorsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListExportErrors", resp, "Failure sending request")
		return
	}

	result, err = client.ListExportErrorsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListExportErrors", resp, "Failure responding to request")
	}

	return
}

// ListExportErrorsPreparer prepares the ListExportErrors request.
func (client ServicesClient) ListExportErrorsPreparer(ctx context.Context, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/exporterrors/counts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListExportErrorsSender sends the ListExportErrors request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListExportErrorsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListExportErrorsResponder handles the response to the ListExportErrors request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListExportErrorsResponder(resp *http.Response) (result ErrorCounts, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListExportErrorsV2 gets the categorized export errors.
// Parameters:
// serviceName - the name of the service.
// errorBucket - the error category to query for.
func (client ServicesClient) ListExportErrorsV2(ctx context.Context, serviceName string, errorBucket string) (result MergedExportErrors, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListExportErrorsV2")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListExportErrorsV2Preparer(ctx, serviceName, errorBucket)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListExportErrorsV2", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListExportErrorsV2Sender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListExportErrorsV2", resp, "Failure sending request")
		return
	}

	result, err = client.ListExportErrorsV2Responder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListExportErrorsV2", resp, "Failure responding to request")
	}

	return
}

// ListExportErrorsV2Preparer prepares the ListExportErrorsV2 request.
func (client ServicesClient) ListExportErrorsV2Preparer(ctx context.Context, serviceName string, errorBucket string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"errorBucket": autorest.Encode("query", errorBucket),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/exporterrors/listV2", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListExportErrorsV2Sender sends the ListExportErrorsV2 request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListExportErrorsV2Sender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListExportErrorsV2Responder handles the response to the ListExportErrorsV2 request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListExportErrorsV2Responder(resp *http.Response) (result MergedExportErrors, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListExportStatus gets the export status.
// Parameters:
// serviceName - the name of the service.
func (client ServicesClient) ListExportStatus(ctx context.Context, serviceName string) (result ExportStatusesPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListExportStatus")
		defer func() {
			sc := -1
			if result.es.Response.Response != nil {
				sc = result.es.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listExportStatusNextResults
	req, err := client.ListExportStatusPreparer(ctx, serviceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListExportStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListExportStatusSender(req)
	if err != nil {
		result.es.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListExportStatus", resp, "Failure sending request")
		return
	}

	result.es, err = client.ListExportStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListExportStatus", resp, "Failure responding to request")
	}

	return
}

// ListExportStatusPreparer prepares the ListExportStatus request.
func (client ServicesClient) ListExportStatusPreparer(ctx context.Context, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/exportstatus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListExportStatusSender sends the ListExportStatus request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListExportStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListExportStatusResponder handles the response to the ListExportStatus request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListExportStatusResponder(resp *http.Response) (result ExportStatuses, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listExportStatusNextResults retrieves the next set of results, if any.
func (client ServicesClient) listExportStatusNextResults(ctx context.Context, lastResults ExportStatuses) (result ExportStatuses, err error) {
	req, err := lastResults.exportStatusesPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listExportStatusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListExportStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listExportStatusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListExportStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listExportStatusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListExportStatusComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServicesClient) ListExportStatusComplete(ctx context.Context, serviceName string) (result ExportStatusesIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListExportStatus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListExportStatus(ctx, serviceName)
	return
}

// ListMetricMetadata gets the service related metrics information.
// Parameters:
// serviceName - the name of the service.
// filter - the metric metadata property filter to apply.
// perfCounter - indicates if only performance counter metrics are requested.
func (client ServicesClient) ListMetricMetadata(ctx context.Context, serviceName string, filter string, perfCounter *bool) (result MetricMetadataListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListMetricMetadata")
		defer func() {
			sc := -1
			if result.mml.Response.Response != nil {
				sc = result.mml.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listMetricMetadataNextResults
	req, err := client.ListMetricMetadataPreparer(ctx, serviceName, filter, perfCounter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMetricMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricMetadataSender(req)
	if err != nil {
		result.mml.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMetricMetadata", resp, "Failure sending request")
		return
	}

	result.mml, err = client.ListMetricMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMetricMetadata", resp, "Failure responding to request")
	}

	return
}

// ListMetricMetadataPreparer prepares the ListMetricMetadata request.
func (client ServicesClient) ListMetricMetadataPreparer(ctx context.Context, serviceName string, filter string, perfCounter *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if perfCounter != nil {
		queryParameters["perfCounter"] = autorest.Encode("query", *perfCounter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metricmetadata", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetricMetadataSender sends the ListMetricMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListMetricMetadataSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListMetricMetadataResponder handles the response to the ListMetricMetadata request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListMetricMetadataResponder(resp *http.Response) (result MetricMetadataList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMetricMetadataNextResults retrieves the next set of results, if any.
func (client ServicesClient) listMetricMetadataNextResults(ctx context.Context, lastResults MetricMetadataList) (result MetricMetadataList, err error) {
	req, err := lastResults.metricMetadataListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listMetricMetadataNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMetricMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listMetricMetadataNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMetricMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listMetricMetadataNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMetricMetadataComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServicesClient) ListMetricMetadataComplete(ctx context.Context, serviceName string, filter string, perfCounter *bool) (result MetricMetadataListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListMetricMetadata")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMetricMetadata(ctx, serviceName, filter, perfCounter)
	return
}

// ListMetricsAverage gets the average of the metric values for a given metric and group combination.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
// groupName - the group name
func (client ServicesClient) ListMetricsAverage(ctx context.Context, serviceName string, metricName string, groupName string) (result MetricsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListMetricsAverage")
		defer func() {
			sc := -1
			if result.mVar.Response.Response != nil {
				sc = result.mVar.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listMetricsAverageNextResults
	req, err := client.ListMetricsAveragePreparer(ctx, serviceName, metricName, groupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMetricsAverage", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsAverageSender(req)
	if err != nil {
		result.mVar.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMetricsAverage", resp, "Failure sending request")
		return
	}

	result.mVar, err = client.ListMetricsAverageResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMetricsAverage", resp, "Failure responding to request")
	}

	return
}

// ListMetricsAveragePreparer prepares the ListMetricsAverage request.
func (client ServicesClient) ListMetricsAveragePreparer(ctx context.Context, serviceName string, metricName string, groupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"groupName":   autorest.Encode("path", groupName),
		"metricName":  autorest.Encode("path", metricName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metrics/{metricName}/groups/{groupName}/average", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetricsAverageSender sends the ListMetricsAverage request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListMetricsAverageSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListMetricsAverageResponder handles the response to the ListMetricsAverage request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListMetricsAverageResponder(resp *http.Response) (result Metrics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMetricsAverageNextResults retrieves the next set of results, if any.
func (client ServicesClient) listMetricsAverageNextResults(ctx context.Context, lastResults Metrics) (result Metrics, err error) {
	req, err := lastResults.metricsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listMetricsAverageNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMetricsAverageSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listMetricsAverageNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMetricsAverageResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listMetricsAverageNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMetricsAverageComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServicesClient) ListMetricsAverageComplete(ctx context.Context, serviceName string, metricName string, groupName string) (result MetricsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListMetricsAverage")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMetricsAverage(ctx, serviceName, metricName, groupName)
	return
}

// ListMetricsSum gets the sum of the metric values for a given metric and group combination.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
// groupName - the group name
func (client ServicesClient) ListMetricsSum(ctx context.Context, serviceName string, metricName string, groupName string) (result MetricsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListMetricsSum")
		defer func() {
			sc := -1
			if result.mVar.Response.Response != nil {
				sc = result.mVar.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listMetricsSumNextResults
	req, err := client.ListMetricsSumPreparer(ctx, serviceName, metricName, groupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMetricsSum", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSumSender(req)
	if err != nil {
		result.mVar.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMetricsSum", resp, "Failure sending request")
		return
	}

	result.mVar, err = client.ListMetricsSumResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMetricsSum", resp, "Failure responding to request")
	}

	return
}

// ListMetricsSumPreparer prepares the ListMetricsSum request.
func (client ServicesClient) ListMetricsSumPreparer(ctx context.Context, serviceName string, metricName string, groupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"groupName":   autorest.Encode("path", groupName),
		"metricName":  autorest.Encode("path", metricName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metrics/{metricName}/groups/{groupName}/sum", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetricsSumSender sends the ListMetricsSum request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListMetricsSumSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListMetricsSumResponder handles the response to the ListMetricsSum request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListMetricsSumResponder(resp *http.Response) (result Metrics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMetricsSumNextResults retrieves the next set of results, if any.
func (client ServicesClient) listMetricsSumNextResults(ctx context.Context, lastResults Metrics) (result Metrics, err error) {
	req, err := lastResults.metricsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listMetricsSumNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMetricsSumSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listMetricsSumNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMetricsSumResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listMetricsSumNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMetricsSumComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServicesClient) ListMetricsSumComplete(ctx context.Context, serviceName string, metricName string, groupName string) (result MetricsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListMetricsSum")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMetricsSum(ctx, serviceName, metricName, groupName)
	return
}

// ListMonitoringConfigurations gets the service level monitoring configurations.
// Parameters:
// serviceName - the name of the service.
func (client ServicesClient) ListMonitoringConfigurations(ctx context.Context, serviceName string) (result Items, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListMonitoringConfigurations")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListMonitoringConfigurationsPreparer(ctx, serviceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMonitoringConfigurations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMonitoringConfigurationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMonitoringConfigurations", resp, "Failure sending request")
		return
	}

	result, err = client.ListMonitoringConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListMonitoringConfigurations", resp, "Failure responding to request")
	}

	return
}

// ListMonitoringConfigurationsPreparer prepares the ListMonitoringConfigurations request.
func (client ServicesClient) ListMonitoringConfigurationsPreparer(ctx context.Context, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/monitoringconfigurations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMonitoringConfigurationsSender sends the ListMonitoringConfigurations request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListMonitoringConfigurationsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListMonitoringConfigurationsResponder handles the response to the ListMonitoringConfigurations request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListMonitoringConfigurationsResponder(resp *http.Response) (result Items, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPremium gets the details of services for a tenant having Azure AD Premium license and is onboarded to Azure
// Active Directory Connect Health.
// Parameters:
// filter - the service property filter to apply.
// serviceType - the service type for the services onboarded to Azure Active Directory Connect Health.
// Depending on whether the service is monitoring, ADFS, Sync or ADDS roles, the service type can either be
// AdFederationService or AadSyncService or AdDomainService.
// skipCount - the skip count, which specifies the number of elements that can be bypassed from a sequence and
// then return the remaining elements.
// takeCount - the take count , which specifies the number of elements that can be returned from a sequence.
func (client ServicesClient) ListPremium(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (result ServicesPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListPremium")
		defer func() {
			sc := -1
			if result.s.Response.Response != nil {
				sc = result.s.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listPremiumNextResults
	req, err := client.ListPremiumPreparer(ctx, filter, serviceType, skipCount, takeCount)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListPremium", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPremiumSender(req)
	if err != nil {
		result.s.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListPremium", resp, "Failure sending request")
		return
	}

	result.s, err = client.ListPremiumResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListPremium", resp, "Failure responding to request")
	}

	return
}

// ListPremiumPreparer prepares the ListPremium request.
func (client ServicesClient) ListPremiumPreparer(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (*http.Request, error) {
	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(serviceType) > 0 {
		queryParameters["serviceType"] = autorest.Encode("query", serviceType)
	}
	if skipCount != nil {
		queryParameters["skipCount"] = autorest.Encode("query", *skipCount)
	}
	if takeCount != nil {
		queryParameters["takeCount"] = autorest.Encode("query", *takeCount)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.ADHybridHealthService/services/premiumCheck"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPremiumSender sends the ListPremium request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListPremiumSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListPremiumResponder handles the response to the ListPremium request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListPremiumResponder(resp *http.Response) (result Services, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listPremiumNextResults retrieves the next set of results, if any.
func (client ServicesClient) listPremiumNextResults(ctx context.Context, lastResults Services) (result Services, err error) {
	req, err := lastResults.servicesPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listPremiumNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListPremiumSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listPremiumNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListPremiumResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "listPremiumNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListPremiumComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServicesClient) ListPremiumComplete(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (result ServicesIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListPremium")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListPremium(ctx, filter, serviceType, skipCount, takeCount)
	return
}

// ListUserBadPasswordReport gets the bad password login attempt report for an user
// Parameters:
// serviceName - the name of the service.
// dataSource - the source of data, if its test data or customer data.
func (client ServicesClient) ListUserBadPasswordReport(ctx context.Context, serviceName string, dataSource string) (result ErrorReportUsersEntries, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.ListUserBadPasswordReport")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListUserBadPasswordReportPreparer(ctx, serviceName, dataSource)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListUserBadPasswordReport", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUserBadPasswordReportSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListUserBadPasswordReport", resp, "Failure sending request")
		return
	}

	result, err = client.ListUserBadPasswordReportResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "ListUserBadPasswordReport", resp, "Failure responding to request")
	}

	return
}

// ListUserBadPasswordReportPreparer prepares the ListUserBadPasswordReport request.
func (client ServicesClient) ListUserBadPasswordReportPreparer(ctx context.Context, serviceName string, dataSource string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(dataSource) > 0 {
		queryParameters["dataSource"] = autorest.Encode("query", dataSource)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/reports/badpassword/details/user", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListUserBadPasswordReportSender sends the ListUserBadPasswordReport request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) ListUserBadPasswordReportSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListUserBadPasswordReportResponder handles the response to the ListUserBadPasswordReport request. The method always
// closes the http.Response Body.
func (client ServicesClient) ListUserBadPasswordReportResponder(resp *http.Response) (result ErrorReportUsersEntries, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update updates the service properties of an onboarded service.
// Parameters:
// serviceName - the name of the service which needs to be deleted.
// service - the service object.
func (client ServicesClient) Update(ctx context.Context, serviceName string, service ServiceProperties) (result ServiceProperties, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, serviceName, service)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ServicesClient) UpdatePreparer(ctx context.Context, serviceName string, service ServiceProperties) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}", pathParameters),
		autorest.WithJSON(service),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ServicesClient) UpdateResponder(resp *http.Response) (result ServiceProperties, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateMonitoringConfiguration updates the service level monitoring configuration.
// Parameters:
// serviceName - the name of the service.
// configurationSetting - the monitoring configuration to update
func (client ServicesClient) UpdateMonitoringConfiguration(ctx context.Context, serviceName string, configurationSetting Item) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicesClient.UpdateMonitoringConfiguration")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateMonitoringConfigurationPreparer(ctx, serviceName, configurationSetting)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "UpdateMonitoringConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateMonitoringConfigurationSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "UpdateMonitoringConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateMonitoringConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServicesClient", "UpdateMonitoringConfiguration", resp, "Failure responding to request")
	}

	return
}

// UpdateMonitoringConfigurationPreparer prepares the UpdateMonitoringConfiguration request.
func (client ServicesClient) UpdateMonitoringConfigurationPreparer(ctx context.Context, serviceName string, configurationSetting Item) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/monitoringconfiguration", pathParameters),
		autorest.WithJSON(configurationSetting),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateMonitoringConfigurationSender sends the UpdateMonitoringConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client ServicesClient) UpdateMonitoringConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateMonitoringConfigurationResponder handles the response to the UpdateMonitoringConfiguration request. The method always
// closes the http.Response Body.
func (client ServicesClient) UpdateMonitoringConfigurationResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
