package apimanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/apimanagement/mgmt/2018-01-01/apimanagement"

// APIType enumerates the values for api type.
type APIType string

const (
	// HTTP ...
	HTTP APIType = "http"
	// Soap ...
	Soap APIType = "soap"
)

// PossibleAPITypeValues returns an array of possible values for the APIType const type.
func PossibleAPITypeValues() []APIType {
	return []APIType{HTTP, Soap}
}

// AsyncOperationStatus enumerates the values for async operation status.
type AsyncOperationStatus string

const (
	// Failed ...
	Failed AsyncOperationStatus = "Failed"
	// InProgress ...
	InProgress AsyncOperationStatus = "InProgress"
	// Started ...
	Started AsyncOperationStatus = "Started"
	// Succeeded ...
	Succeeded AsyncOperationStatus = "Succeeded"
)

// PossibleAsyncOperationStatusValues returns an array of possible values for the AsyncOperationStatus const type.
func PossibleAsyncOperationStatusValues() []AsyncOperationStatus {
	return []AsyncOperationStatus{Failed, InProgress, Started, Succeeded}
}

// AuthorizationMethod enumerates the values for authorization method.
type AuthorizationMethod string

const (
	// DELETE ...
	DELETE AuthorizationMethod = "DELETE"
	// GET ...
	GET AuthorizationMethod = "GET"
	// HEAD ...
	HEAD AuthorizationMethod = "HEAD"
	// OPTIONS ...
	OPTIONS AuthorizationMethod = "OPTIONS"
	// PATCH ...
	PATCH AuthorizationMethod = "PATCH"
	// POST ...
	POST AuthorizationMethod = "POST"
	// PUT ...
	PUT AuthorizationMethod = "PUT"
	// TRACE ...
	TRACE AuthorizationMethod = "TRACE"
)

// PossibleAuthorizationMethodValues returns an array of possible values for the AuthorizationMethod const type.
func PossibleAuthorizationMethodValues() []AuthorizationMethod {
	return []AuthorizationMethod{DELETE, GET, HEAD, OPTIONS, PATCH, POST, PUT, TRACE}
}

// BackendProtocol enumerates the values for backend protocol.
type BackendProtocol string

const (
	// BackendProtocolHTTP The Backend is a RESTful service.
	BackendProtocolHTTP BackendProtocol = "http"
	// BackendProtocolSoap The Backend is a SOAP service.
	BackendProtocolSoap BackendProtocol = "soap"
)

// PossibleBackendProtocolValues returns an array of possible values for the BackendProtocol const type.
func PossibleBackendProtocolValues() []BackendProtocol {
	return []BackendProtocol{BackendProtocolHTTP, BackendProtocolSoap}
}

// BearerTokenSendingMethod enumerates the values for bearer token sending method.
type BearerTokenSendingMethod string

const (
	// AuthorizationHeader ...
	AuthorizationHeader BearerTokenSendingMethod = "authorizationHeader"
	// Query ...
	Query BearerTokenSendingMethod = "query"
)

// PossibleBearerTokenSendingMethodValues returns an array of possible values for the BearerTokenSendingMethod const type.
func PossibleBearerTokenSendingMethodValues() []BearerTokenSendingMethod {
	return []BearerTokenSendingMethod{AuthorizationHeader, Query}
}

// BearerTokenSendingMethods enumerates the values for bearer token sending methods.
type BearerTokenSendingMethods string

const (
	// BearerTokenSendingMethodsAuthorizationHeader Access token will be transmitted in the Authorization
	// header using Bearer schema
	BearerTokenSendingMethodsAuthorizationHeader BearerTokenSendingMethods = "authorizationHeader"
	// BearerTokenSendingMethodsQuery Access token will be transmitted as query parameters.
	BearerTokenSendingMethodsQuery BearerTokenSendingMethods = "query"
)

// PossibleBearerTokenSendingMethodsValues returns an array of possible values for the BearerTokenSendingMethods const type.
func PossibleBearerTokenSendingMethodsValues() []BearerTokenSendingMethods {
	return []BearerTokenSendingMethods{BearerTokenSendingMethodsAuthorizationHeader, BearerTokenSendingMethodsQuery}
}

// ClientAuthenticationMethod enumerates the values for client authentication method.
type ClientAuthenticationMethod string

const (
	// Basic Basic Client Authentication method.
	Basic ClientAuthenticationMethod = "Basic"
	// Body Body based Authentication method.
	Body ClientAuthenticationMethod = "Body"
)

// PossibleClientAuthenticationMethodValues returns an array of possible values for the ClientAuthenticationMethod const type.
func PossibleClientAuthenticationMethodValues() []ClientAuthenticationMethod {
	return []ClientAuthenticationMethod{Basic, Body}
}

// Confirmation enumerates the values for confirmation.
type Confirmation string

const (
	// Invite Send an e-mail inviting the user to sign-up and complete registration.
	Invite Confirmation = "invite"
	// Signup Send an e-mail to the user confirming they have successfully signed up.
	Signup Confirmation = "signup"
)

// PossibleConfirmationValues returns an array of possible values for the Confirmation const type.
func PossibleConfirmationValues() []Confirmation {
	return []Confirmation{Invite, Signup}
}

// ConnectivityStatusType enumerates the values for connectivity status type.
type ConnectivityStatusType string

const (
	// Failure ...
	Failure ConnectivityStatusType = "failure"
	// Initializing ...
	Initializing ConnectivityStatusType = "initializing"
	// Success ...
	Success ConnectivityStatusType = "success"
)

// PossibleConnectivityStatusTypeValues returns an array of possible values for the ConnectivityStatusType const type.
func PossibleConnectivityStatusTypeValues() []ConnectivityStatusType {
	return []ConnectivityStatusType{Failure, Initializing, Success}
}

// ContentFormat enumerates the values for content format.
type ContentFormat string

const (
	// SwaggerJSON The contents are inline and Content Type is a OpenApi 2.0 Document.
	SwaggerJSON ContentFormat = "swagger-json"
	// SwaggerLinkJSON The Open Api 2.0 document is hosted on a publicly accessible internet address.
	SwaggerLinkJSON ContentFormat = "swagger-link-json"
	// WadlLinkJSON The WADL document is hosted on a publicly accessible internet address.
	WadlLinkJSON ContentFormat = "wadl-link-json"
	// WadlXML The contents are inline and Content type is a WADL document.
	WadlXML ContentFormat = "wadl-xml"
	// Wsdl The contents are inline and the document is a WSDL/Soap document.
	Wsdl ContentFormat = "wsdl"
	// WsdlLink The WSDL document is hosted on a publicly accessible internet address.
	WsdlLink ContentFormat = "wsdl-link"
)

// PossibleContentFormatValues returns an array of possible values for the ContentFormat const type.
func PossibleContentFormatValues() []ContentFormat {
	return []ContentFormat{SwaggerJSON, SwaggerLinkJSON, WadlLinkJSON, WadlXML, Wsdl, WsdlLink}
}

// ExportFormat enumerates the values for export format.
type ExportFormat string

const (
	// ExportFormatSwagger Export the Api Definition in OpenApi Specification 2.0 format to the Storage Blob.
	ExportFormatSwagger ExportFormat = "swagger-link"
	// ExportFormatWadl Export the Api Definition in WADL Schema to Storage Blob.
	ExportFormatWadl ExportFormat = "wadl-link"
	// ExportFormatWsdl Export the Api Definition in WSDL Schema to Storage Blob. This is only supported for
	// APIs of Type `soap`
	ExportFormatWsdl ExportFormat = "wsdl-link"
)

// PossibleExportFormatValues returns an array of possible values for the ExportFormat const type.
func PossibleExportFormatValues() []ExportFormat {
	return []ExportFormat{ExportFormatSwagger, ExportFormatWadl, ExportFormatWsdl}
}

// GrantType enumerates the values for grant type.
type GrantType string

const (
	// AuthorizationCode Authorization Code Grant flow as described
	// https://tools.ietf.org/html/rfc6749#section-4.1.
	AuthorizationCode GrantType = "authorizationCode"
	// ClientCredentials Client Credentials Grant flow as described
	// https://tools.ietf.org/html/rfc6749#section-4.4.
	ClientCredentials GrantType = "clientCredentials"
	// Implicit Implicit Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.2.
	Implicit GrantType = "implicit"
	// ResourceOwnerPassword Resource Owner Password Grant flow as described
	// https://tools.ietf.org/html/rfc6749#section-4.3.
	ResourceOwnerPassword GrantType = "resourceOwnerPassword"
)

// PossibleGrantTypeValues returns an array of possible values for the GrantType const type.
func PossibleGrantTypeValues() []GrantType {
	return []GrantType{AuthorizationCode, ClientCredentials, Implicit, ResourceOwnerPassword}
}

// GroupType enumerates the values for group type.
type GroupType string

const (
	// Custom ...
	Custom GroupType = "custom"
	// External ...
	External GroupType = "external"
	// System ...
	System GroupType = "system"
)

// PossibleGroupTypeValues returns an array of possible values for the GroupType const type.
func PossibleGroupTypeValues() []GroupType {
	return []GroupType{Custom, External, System}
}

// HostnameType enumerates the values for hostname type.
type HostnameType string

const (
	// Management ...
	Management HostnameType = "Management"
	// Portal ...
	Portal HostnameType = "Portal"
	// Proxy ...
	Proxy HostnameType = "Proxy"
	// Scm ...
	Scm HostnameType = "Scm"
)

// PossibleHostnameTypeValues returns an array of possible values for the HostnameType const type.
func PossibleHostnameTypeValues() []HostnameType {
	return []HostnameType{Management, Portal, Proxy, Scm}
}

// IdentityProviderType enumerates the values for identity provider type.
type IdentityProviderType string

const (
	// Aad Azure Active Directory as Identity provider.
	Aad IdentityProviderType = "aad"
	// AadB2C Azure Active Directory B2C as Identity provider.
	AadB2C IdentityProviderType = "aadB2C"
	// Facebook Facebook as Identity provider.
	Facebook IdentityProviderType = "facebook"
	// Google Google as Identity provider.
	Google IdentityProviderType = "google"
	// Microsoft Microsoft Live as Identity provider.
	Microsoft IdentityProviderType = "microsoft"
	// Twitter Twitter as Identity provider.
	Twitter IdentityProviderType = "twitter"
)

// PossibleIdentityProviderTypeValues returns an array of possible values for the IdentityProviderType const type.
func PossibleIdentityProviderTypeValues() []IdentityProviderType {
	return []IdentityProviderType{Aad, AadB2C, Facebook, Google, Microsoft, Twitter}
}

// KeyType enumerates the values for key type.
type KeyType string

const (
	// Primary ...
	Primary KeyType = "primary"
	// Secondary ...
	Secondary KeyType = "secondary"
)

// PossibleKeyTypeValues returns an array of possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{Primary, Secondary}
}

// LoggerType enumerates the values for logger type.
type LoggerType string

const (
	// ApplicationInsights Azure Application Insights as log destination.
	ApplicationInsights LoggerType = "applicationInsights"
	// AzureEventHub Azure Event Hub as log destination.
	AzureEventHub LoggerType = "azureEventHub"
)

// PossibleLoggerTypeValues returns an array of possible values for the LoggerType const type.
func PossibleLoggerTypeValues() []LoggerType {
	return []LoggerType{ApplicationInsights, AzureEventHub}
}

// NameAvailabilityReason enumerates the values for name availability reason.
type NameAvailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists NameAvailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid NameAvailabilityReason = "Invalid"
	// Valid ...
	Valid NameAvailabilityReason = "Valid"
)

// PossibleNameAvailabilityReasonValues returns an array of possible values for the NameAvailabilityReason const type.
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return []NameAvailabilityReason{AlreadyExists, Invalid, Valid}
}

// NotificationName enumerates the values for notification name.
type NotificationName string

const (
	// AccountClosedPublisher The following email recipients and users will receive email notifications when
	// developer closes his account.
	AccountClosedPublisher NotificationName = "AccountClosedPublisher"
	// BCC The following recipients will receive blind carbon copies of all emails sent to developers.
	BCC NotificationName = "BCC"
	// NewApplicationNotificationMessage The following email recipients and users will receive email
	// notifications when new applications are submitted to the application gallery.
	NewApplicationNotificationMessage NotificationName = "NewApplicationNotificationMessage"
	// NewIssuePublisherNotificationMessage The following email recipients and users will receive email
	// notifications when a new issue or comment is submitted on the developer portal.
	NewIssuePublisherNotificationMessage NotificationName = "NewIssuePublisherNotificationMessage"
	// PurchasePublisherNotificationMessage The following email recipients and users will receive email
	// notifications about new API product subscriptions.
	PurchasePublisherNotificationMessage NotificationName = "PurchasePublisherNotificationMessage"
	// QuotaLimitApproachingPublisherNotificationMessage The following email recipients and users will receive
	// email notifications when subscription usage gets close to usage quota.
	QuotaLimitApproachingPublisherNotificationMessage NotificationName = "QuotaLimitApproachingPublisherNotificationMessage"
	// RequestPublisherNotificationMessage The following email recipients and users will receive email
	// notifications about subscription requests for API products requiring approval.
	RequestPublisherNotificationMessage NotificationName = "RequestPublisherNotificationMessage"
)

// PossibleNotificationNameValues returns an array of possible values for the NotificationName const type.
func PossibleNotificationNameValues() []NotificationName {
	return []NotificationName{AccountClosedPublisher, BCC, NewApplicationNotificationMessage, NewIssuePublisherNotificationMessage, PurchasePublisherNotificationMessage, QuotaLimitApproachingPublisherNotificationMessage, RequestPublisherNotificationMessage}
}

// PolicyContentFormat enumerates the values for policy content format.
type PolicyContentFormat string

const (
	// Rawxml The contents are inline and Content type is a non XML encoded policy document.
	Rawxml PolicyContentFormat = "rawxml"
	// RawxmlLink The policy document is not Xml encoded and is hosted on a http endpoint accessible from the
	// API Management service.
	RawxmlLink PolicyContentFormat = "rawxml-link"
	// XML The contents are inline and Content type is an XML document.
	XML PolicyContentFormat = "xml"
	// XMLLink The policy XML document is hosted on a http endpoint accessible from the API Management service.
	XMLLink PolicyContentFormat = "xml-link"
)

// PossiblePolicyContentFormatValues returns an array of possible values for the PolicyContentFormat const type.
func PossiblePolicyContentFormatValues() []PolicyContentFormat {
	return []PolicyContentFormat{Rawxml, RawxmlLink, XML, XMLLink}
}

// PolicyScopeContract enumerates the values for policy scope contract.
type PolicyScopeContract string

const (
	// PolicyScopeContractAll ...
	PolicyScopeContractAll PolicyScopeContract = "All"
	// PolicyScopeContractAPI ...
	PolicyScopeContractAPI PolicyScopeContract = "Api"
	// PolicyScopeContractOperation ...
	PolicyScopeContractOperation PolicyScopeContract = "Operation"
	// PolicyScopeContractProduct ...
	PolicyScopeContractProduct PolicyScopeContract = "Product"
	// PolicyScopeContractTenant ...
	PolicyScopeContractTenant PolicyScopeContract = "Tenant"
)

// PossiblePolicyScopeContractValues returns an array of possible values for the PolicyScopeContract const type.
func PossiblePolicyScopeContractValues() []PolicyScopeContract {
	return []PolicyScopeContract{PolicyScopeContractAll, PolicyScopeContractAPI, PolicyScopeContractOperation, PolicyScopeContractProduct, PolicyScopeContractTenant}
}

// ProductState enumerates the values for product state.
type ProductState string

const (
	// NotPublished ...
	NotPublished ProductState = "notPublished"
	// Published ...
	Published ProductState = "published"
)

// PossibleProductStateValues returns an array of possible values for the ProductState const type.
func PossibleProductStateValues() []ProductState {
	return []ProductState{NotPublished, Published}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// ProtocolHTTP ...
	ProtocolHTTP Protocol = "http"
	// ProtocolHTTPS ...
	ProtocolHTTPS Protocol = "https"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{ProtocolHTTP, ProtocolHTTPS}
}

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// Automatic ...
	Automatic ResourceSkuCapacityScaleType = "automatic"
	// Manual ...
	Manual ResourceSkuCapacityScaleType = "manual"
	// None ...
	None ResourceSkuCapacityScaleType = "none"
)

// PossibleResourceSkuCapacityScaleTypeValues returns an array of possible values for the ResourceSkuCapacityScaleType const type.
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return []ResourceSkuCapacityScaleType{Automatic, Manual, None}
}

// SkuType enumerates the values for sku type.
type SkuType string

const (
	// SkuTypeBasic Basic SKU of Api Management.
	SkuTypeBasic SkuType = "Basic"
	// SkuTypeDeveloper Developer SKU of Api Management.
	SkuTypeDeveloper SkuType = "Developer"
	// SkuTypePremium Premium SKU of Api Management.
	SkuTypePremium SkuType = "Premium"
	// SkuTypeStandard Standard SKU of Api Management.
	SkuTypeStandard SkuType = "Standard"
)

// PossibleSkuTypeValues returns an array of possible values for the SkuType const type.
func PossibleSkuTypeValues() []SkuType {
	return []SkuType{SkuTypeBasic, SkuTypeDeveloper, SkuTypePremium, SkuTypeStandard}
}

// SoapAPIType enumerates the values for soap api type.
type SoapAPIType string

const (
	// SoapPassThrough Imports the Soap API having a SOAP front end.
	SoapPassThrough SoapAPIType = "soap"
	// SoapToRest Imports a SOAP API having a RESTful front end.
	SoapToRest SoapAPIType = "http"
)

// PossibleSoapAPITypeValues returns an array of possible values for the SoapAPIType const type.
func PossibleSoapAPITypeValues() []SoapAPIType {
	return []SoapAPIType{SoapPassThrough, SoapToRest}
}

// State enumerates the values for state.
type State string

const (
	// Closed The issue was closed.
	Closed State = "closed"
	// Open The issue is opened.
	Open State = "open"
	// Proposed The issue is proposed.
	Proposed State = "proposed"
	// Removed The issue was removed.
	Removed State = "removed"
	// Resolved The issue is now resolved.
	Resolved State = "resolved"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{Closed, Open, Proposed, Removed, Resolved}
}

// StoreName enumerates the values for store name.
type StoreName string

const (
	// CertificateAuthority ...
	CertificateAuthority StoreName = "CertificateAuthority"
	// Root ...
	Root StoreName = "Root"
)

// PossibleStoreNameValues returns an array of possible values for the StoreName const type.
func PossibleStoreNameValues() []StoreName {
	return []StoreName{CertificateAuthority, Root}
}

// SubscriptionState enumerates the values for subscription state.
type SubscriptionState string

const (
	// Active ...
	Active SubscriptionState = "active"
	// Cancelled ...
	Cancelled SubscriptionState = "cancelled"
	// Expired ...
	Expired SubscriptionState = "expired"
	// Rejected ...
	Rejected SubscriptionState = "rejected"
	// Submitted ...
	Submitted SubscriptionState = "submitted"
	// Suspended ...
	Suspended SubscriptionState = "suspended"
)

// PossibleSubscriptionStateValues returns an array of possible values for the SubscriptionState const type.
func PossibleSubscriptionStateValues() []SubscriptionState {
	return []SubscriptionState{Active, Cancelled, Expired, Rejected, Submitted, Suspended}
}

// TemplateName enumerates the values for template name.
type TemplateName string

const (
	// AccountClosedDeveloper ...
	AccountClosedDeveloper TemplateName = "accountClosedDeveloper"
	// ApplicationApprovedNotificationMessage ...
	ApplicationApprovedNotificationMessage TemplateName = "applicationApprovedNotificationMessage"
	// ConfirmSignUpIdentityDefault ...
	ConfirmSignUpIdentityDefault TemplateName = "confirmSignUpIdentityDefault"
	// EmailChangeIdentityDefault ...
	EmailChangeIdentityDefault TemplateName = "emailChangeIdentityDefault"
	// InviteUserNotificationMessage ...
	InviteUserNotificationMessage TemplateName = "inviteUserNotificationMessage"
	// NewCommentNotificationMessage ...
	NewCommentNotificationMessage TemplateName = "newCommentNotificationMessage"
	// NewDeveloperNotificationMessage ...
	NewDeveloperNotificationMessage TemplateName = "newDeveloperNotificationMessage"
	// NewIssueNotificationMessage ...
	NewIssueNotificationMessage TemplateName = "newIssueNotificationMessage"
	// PasswordResetByAdminNotificationMessage ...
	PasswordResetByAdminNotificationMessage TemplateName = "passwordResetByAdminNotificationMessage"
	// PasswordResetIdentityDefault ...
	PasswordResetIdentityDefault TemplateName = "passwordResetIdentityDefault"
	// PurchaseDeveloperNotificationMessage ...
	PurchaseDeveloperNotificationMessage TemplateName = "purchaseDeveloperNotificationMessage"
	// QuotaLimitApproachingDeveloperNotificationMessage ...
	QuotaLimitApproachingDeveloperNotificationMessage TemplateName = "quotaLimitApproachingDeveloperNotificationMessage"
	// RejectDeveloperNotificationMessage ...
	RejectDeveloperNotificationMessage TemplateName = "rejectDeveloperNotificationMessage"
	// RequestDeveloperNotificationMessage ...
	RequestDeveloperNotificationMessage TemplateName = "requestDeveloperNotificationMessage"
)

// PossibleTemplateNameValues returns an array of possible values for the TemplateName const type.
func PossibleTemplateNameValues() []TemplateName {
	return []TemplateName{AccountClosedDeveloper, ApplicationApprovedNotificationMessage, ConfirmSignUpIdentityDefault, EmailChangeIdentityDefault, InviteUserNotificationMessage, NewCommentNotificationMessage, NewDeveloperNotificationMessage, NewIssueNotificationMessage, PasswordResetByAdminNotificationMessage, PasswordResetIdentityDefault, PurchaseDeveloperNotificationMessage, QuotaLimitApproachingDeveloperNotificationMessage, RejectDeveloperNotificationMessage, RequestDeveloperNotificationMessage}
}

// UserState enumerates the values for user state.
type UserState string

const (
	// UserStateActive User state is active.
	UserStateActive UserState = "active"
	// UserStateBlocked User is blocked. Blocked users cannot authenticate at developer portal or call API.
	UserStateBlocked UserState = "blocked"
	// UserStateDeleted User account is closed. All identities and related entities are removed.
	UserStateDeleted UserState = "deleted"
	// UserStatePending User account is pending. Requires identity confirmation before it can be made active.
	UserStatePending UserState = "pending"
)

// PossibleUserStateValues returns an array of possible values for the UserState const type.
func PossibleUserStateValues() []UserState {
	return []UserState{UserStateActive, UserStateBlocked, UserStateDeleted, UserStatePending}
}

// VersioningScheme enumerates the values for versioning scheme.
type VersioningScheme string

const (
	// VersioningSchemeHeader The API Version is passed in a HTTP header.
	VersioningSchemeHeader VersioningScheme = "Header"
	// VersioningSchemeQuery The API Version is passed in a query parameter.
	VersioningSchemeQuery VersioningScheme = "Query"
	// VersioningSchemeSegment The API Version is passed in a path segment.
	VersioningSchemeSegment VersioningScheme = "Segment"
)

// PossibleVersioningSchemeValues returns an array of possible values for the VersioningScheme const type.
func PossibleVersioningSchemeValues() []VersioningScheme {
	return []VersioningScheme{VersioningSchemeHeader, VersioningSchemeQuery, VersioningSchemeSegment}
}

// VersioningScheme1 enumerates the values for versioning scheme 1.
type VersioningScheme1 string

const (
	// VersioningScheme1Header ...
	VersioningScheme1Header VersioningScheme1 = "Header"
	// VersioningScheme1Query ...
	VersioningScheme1Query VersioningScheme1 = "Query"
	// VersioningScheme1Segment ...
	VersioningScheme1Segment VersioningScheme1 = "Segment"
)

// PossibleVersioningScheme1Values returns an array of possible values for the VersioningScheme1 const type.
func PossibleVersioningScheme1Values() []VersioningScheme1 {
	return []VersioningScheme1{VersioningScheme1Header, VersioningScheme1Query, VersioningScheme1Segment}
}

// VirtualNetworkType enumerates the values for virtual network type.
type VirtualNetworkType string

const (
	// VirtualNetworkTypeExternal The service is part of Virtual Network and it is accessible from Internet.
	VirtualNetworkTypeExternal VirtualNetworkType = "External"
	// VirtualNetworkTypeInternal The service is part of Virtual Network and it is only accessible from within
	// the virtual network.
	VirtualNetworkTypeInternal VirtualNetworkType = "Internal"
	// VirtualNetworkTypeNone The service is not part of any Virtual Network.
	VirtualNetworkTypeNone VirtualNetworkType = "None"
)

// PossibleVirtualNetworkTypeValues returns an array of possible values for the VirtualNetworkType const type.
func PossibleVirtualNetworkTypeValues() []VirtualNetworkType {
	return []VirtualNetworkType{VirtualNetworkTypeExternal, VirtualNetworkTypeInternal, VirtualNetworkTypeNone}
}

// AccessInformationContract tenant access information contract of the API Management service.
type AccessInformationContract struct {
	autorest.Response `json:"-"`
	// ID - Identifier.
	ID *string `json:"id,omitempty"`
	// PrimaryKey - Primary access key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary access key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// Enabled - Tenant access information of the API Management service.
	Enabled *bool `json:"enabled,omitempty"`
}

// AccessInformationUpdateParameters tenant access information update parameters of the API Management
// service.
type AccessInformationUpdateParameters struct {
	// Enabled - Tenant access information of the API Management service.
	Enabled *bool `json:"enabled,omitempty"`
}

// AdditionalLocation description of an additional API Management resource location.
type AdditionalLocation struct {
	// Location - The location name of the additional region among Azure Data center regions.
	Location *string `json:"location,omitempty"`
	// Sku - SKU properties of the API Management service.
	Sku *ServiceSkuProperties `json:"sku,omitempty"`
	// PublicIPAddresses - Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard and Premium SKU.
	PublicIPAddresses *[]string `json:"publicIPAddresses,omitempty"`
	// PrivateIPAddresses - Private Static Load Balanced IP addresses of the API Management service which is deployed in an Internal Virtual Network in a particular additional location. Available only for Basic, Standard and Premium SKU.
	PrivateIPAddresses *[]string `json:"privateIPAddresses,omitempty"`
	// VirtualNetworkConfiguration - Virtual network configuration for the location.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`
	// GatewayRegionalURL - Gateway URL of the API Management service in the Region.
	GatewayRegionalURL *string `json:"gatewayRegionalUrl,omitempty"`
}

// APICollection paged Api list representation.
type APICollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]APIContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// APICollectionIterator provides access to a complete listing of APIContract values.
type APICollectionIterator struct {
	i    int
	page APICollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *APICollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APICollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *APICollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter APICollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter APICollectionIterator) Response() APICollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter APICollectionIterator) Value() APIContract {
	if !iter.page.NotDone() {
		return APIContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the APICollectionIterator type.
func NewAPICollectionIterator(page APICollectionPage) APICollectionIterator {
	return APICollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ac APICollection) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// aPICollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac APICollection) aPICollectionPreparer(ctx context.Context) (*http.Request, error) {
	if ac.NextLink == nil || len(to.String(ac.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.NextLink)))
}

// APICollectionPage contains a page of APIContract values.
type APICollectionPage struct {
	fn func(context.Context, APICollection) (APICollection, error)
	ac APICollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *APICollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APICollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ac)
	if err != nil {
		return err
	}
	page.ac = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *APICollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page APICollectionPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page APICollectionPage) Response() APICollection {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page APICollectionPage) Values() []APIContract {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// Creates a new instance of the APICollectionPage type.
func NewAPICollectionPage(getNextPage func(context.Context, APICollection) (APICollection, error)) APICollectionPage {
	return APICollectionPage{fn: getNextPage}
}

// APIContract API details.
type APIContract struct {
	autorest.Response `json:"-"`
	// APIContractProperties - Api entity contract properties.
	*APIContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for APIContract.
func (ac APIContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ac.APIContractProperties != nil {
		objectMap["properties"] = ac.APIContractProperties
	}
	if ac.ID != nil {
		objectMap["id"] = ac.ID
	}
	if ac.Name != nil {
		objectMap["name"] = ac.Name
	}
	if ac.Type != nil {
		objectMap["type"] = ac.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for APIContract struct.
func (ac *APIContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var APIContractProperties APIContractProperties
				err = json.Unmarshal(*v, &APIContractProperties)
				if err != nil {
					return err
				}
				ac.APIContractProperties = &APIContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ac.Type = &typeVar
			}
		}
	}

	return nil
}

// APIContractProperties api Entity Properties
type APIContractProperties struct {
	// DisplayName - API name.
	DisplayName *string `json:"displayName,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols     *[]Protocol                   `json:"protocols,omitempty"`
	APIVersionSet *APIVersionSetContractDetails `json:"apiVersionSet,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// APIType - Type of API. Possible values include: 'HTTP', 'Soap'
	APIType APIType `json:"type,omitempty"`
	// APIRevision - Describes the Revision of the Api. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`
	// APIVersion - Indicates the Version identifier of the API if the API is versioned
	APIVersion *string `json:"apiVersion,omitempty"`
	// IsCurrent - Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`
	// IsOnline - Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty"`
	// APIRevisionDescription - Description of the Api Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`
	// APIVersionDescription - Description of the Api Version.
	APIVersionDescription *string `json:"apiVersionDescription,omitempty"`
	// APIVersionSetID - A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string `json:"apiVersionSetId,omitempty"`
}

// APIContractUpdateProperties API update contract properties.
type APIContractUpdateProperties struct {
	// DisplayName - API name.
	DisplayName *string `json:"displayName,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols *[]Protocol `json:"protocols,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// APIType - Type of API. Possible values include: 'HTTP', 'Soap'
	APIType APIType `json:"type,omitempty"`
	// APIRevision - Describes the Revision of the Api. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`
	// APIVersion - Indicates the Version identifier of the API if the API is versioned
	APIVersion *string `json:"apiVersion,omitempty"`
	// IsCurrent - Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`
	// IsOnline - Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty"`
	// APIRevisionDescription - Description of the Api Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`
	// APIVersionDescription - Description of the Api Version.
	APIVersionDescription *string `json:"apiVersionDescription,omitempty"`
	// APIVersionSetID - A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string `json:"apiVersionSetId,omitempty"`
}

// APICreateOrUpdateParameter API Create or Update Parameters.
type APICreateOrUpdateParameter struct {
	// APICreateOrUpdateProperties - Api entity create of update properties.
	*APICreateOrUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for APICreateOrUpdateParameter.
func (acoup APICreateOrUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acoup.APICreateOrUpdateProperties != nil {
		objectMap["properties"] = acoup.APICreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for APICreateOrUpdateParameter struct.
func (acoup *APICreateOrUpdateParameter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var APICreateOrUpdateProperties APICreateOrUpdateProperties
				err = json.Unmarshal(*v, &APICreateOrUpdateProperties)
				if err != nil {
					return err
				}
				acoup.APICreateOrUpdateProperties = &APICreateOrUpdateProperties
			}
		}
	}

	return nil
}

// APICreateOrUpdateProperties api Create or Update Properties.
type APICreateOrUpdateProperties struct {
	// ContentValue - Content value when Importing an API.
	ContentValue *string `json:"contentValue,omitempty"`
	// ContentFormat - Format of the Content in which the API is getting imported. Possible values include: 'WadlXML', 'WadlLinkJSON', 'SwaggerJSON', 'SwaggerLinkJSON', 'Wsdl', 'WsdlLink'
	ContentFormat ContentFormat `json:"contentFormat,omitempty"`
	// WsdlSelector - Criteria to limit import of WSDL to a subset of the document.
	WsdlSelector *APICreateOrUpdatePropertiesWsdlSelector `json:"wsdlSelector,omitempty"`
	// SoapAPIType - Type of Api to create.
	//  * `http` creates a SOAP to REST API
	//  * `soap` creates a SOAP pass-through API. Possible values include: 'SoapToRest', 'SoapPassThrough'
	SoapAPIType SoapAPIType `json:"apiType,omitempty"`
	// DisplayName - API name.
	DisplayName *string `json:"displayName,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols     *[]Protocol                   `json:"protocols,omitempty"`
	APIVersionSet *APIVersionSetContractDetails `json:"apiVersionSet,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// APIType - Type of API. Possible values include: 'HTTP', 'Soap'
	APIType APIType `json:"type,omitempty"`
	// APIRevision - Describes the Revision of the Api. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`
	// APIVersion - Indicates the Version identifier of the API if the API is versioned
	APIVersion *string `json:"apiVersion,omitempty"`
	// IsCurrent - Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`
	// IsOnline - Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty"`
	// APIRevisionDescription - Description of the Api Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`
	// APIVersionDescription - Description of the Api Version.
	APIVersionDescription *string `json:"apiVersionDescription,omitempty"`
	// APIVersionSetID - A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string `json:"apiVersionSetId,omitempty"`
}

// APICreateOrUpdatePropertiesWsdlSelector criteria to limit import of WSDL to a subset of the document.
type APICreateOrUpdatePropertiesWsdlSelector struct {
	// WsdlServiceName - Name of service to import from WSDL
	WsdlServiceName *string `json:"wsdlServiceName,omitempty"`
	// WsdlEndpointName - Name of endpoint(port) to import from WSDL
	WsdlEndpointName *string `json:"wsdlEndpointName,omitempty"`
}

// APIEntityBaseContract API base contract details.
type APIEntityBaseContract struct {
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// APIType - Type of API. Possible values include: 'HTTP', 'Soap'
	APIType APIType `json:"type,omitempty"`
	// APIRevision - Describes the Revision of the Api. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`
	// APIVersion - Indicates the Version identifier of the API if the API is versioned
	APIVersion *string `json:"apiVersion,omitempty"`
	// IsCurrent - Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`
	// IsOnline - Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty"`
	// APIRevisionDescription - Description of the Api Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`
	// APIVersionDescription - Description of the Api Version.
	APIVersionDescription *string `json:"apiVersionDescription,omitempty"`
	// APIVersionSetID - A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string `json:"apiVersionSetId,omitempty"`
}

// APIExportResult API Export result Blob Uri.
type APIExportResult struct {
	autorest.Response `json:"-"`
	// Link - Link to the Storage Blob containing the result of the export operation. The Blob Uri is only valid for 5 minutes.
	Link *string `json:"link,omitempty"`
}

// ApimResource the Resource definition.
type ApimResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApimResource.
func (ar ApimResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.ID != nil {
		objectMap["id"] = ar.ID
	}
	if ar.Name != nil {
		objectMap["name"] = ar.Name
	}
	if ar.Type != nil {
		objectMap["type"] = ar.Type
	}
	if ar.Tags != nil {
		objectMap["tags"] = ar.Tags
	}
	return json.Marshal(objectMap)
}

// APIReleaseCollection paged Api Revision list representation.
type APIReleaseCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]APIReleaseContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// APIReleaseCollectionIterator provides access to a complete listing of APIReleaseContract values.
type APIReleaseCollectionIterator struct {
	i    int
	page APIReleaseCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *APIReleaseCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIReleaseCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *APIReleaseCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter APIReleaseCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter APIReleaseCollectionIterator) Response() APIReleaseCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter APIReleaseCollectionIterator) Value() APIReleaseContract {
	if !iter.page.NotDone() {
		return APIReleaseContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the APIReleaseCollectionIterator type.
func NewAPIReleaseCollectionIterator(page APIReleaseCollectionPage) APIReleaseCollectionIterator {
	return APIReleaseCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arc APIReleaseCollection) IsEmpty() bool {
	return arc.Value == nil || len(*arc.Value) == 0
}

// aPIReleaseCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arc APIReleaseCollection) aPIReleaseCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if arc.NextLink == nil || len(to.String(arc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arc.NextLink)))
}

// APIReleaseCollectionPage contains a page of APIReleaseContract values.
type APIReleaseCollectionPage struct {
	fn  func(context.Context, APIReleaseCollection) (APIReleaseCollection, error)
	arc APIReleaseCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *APIReleaseCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIReleaseCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.arc)
	if err != nil {
		return err
	}
	page.arc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *APIReleaseCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page APIReleaseCollectionPage) NotDone() bool {
	return !page.arc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page APIReleaseCollectionPage) Response() APIReleaseCollection {
	return page.arc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page APIReleaseCollectionPage) Values() []APIReleaseContract {
	if page.arc.IsEmpty() {
		return nil
	}
	return *page.arc.Value
}

// Creates a new instance of the APIReleaseCollectionPage type.
func NewAPIReleaseCollectionPage(getNextPage func(context.Context, APIReleaseCollection) (APIReleaseCollection, error)) APIReleaseCollectionPage {
	return APIReleaseCollectionPage{fn: getNextPage}
}

// APIReleaseContract api Release details.
type APIReleaseContract struct {
	autorest.Response `json:"-"`
	// APIReleaseContractProperties - Properties of the Api Release Contract.
	*APIReleaseContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for APIReleaseContract.
func (arc APIReleaseContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arc.APIReleaseContractProperties != nil {
		objectMap["properties"] = arc.APIReleaseContractProperties
	}
	if arc.ID != nil {
		objectMap["id"] = arc.ID
	}
	if arc.Name != nil {
		objectMap["name"] = arc.Name
	}
	if arc.Type != nil {
		objectMap["type"] = arc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for APIReleaseContract struct.
func (arc *APIReleaseContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var APIReleaseContractProperties APIReleaseContractProperties
				err = json.Unmarshal(*v, &APIReleaseContractProperties)
				if err != nil {
					return err
				}
				arc.APIReleaseContractProperties = &APIReleaseContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				arc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				arc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				arc.Type = &typeVar
			}
		}
	}

	return nil
}

// APIReleaseContractProperties API Release details
type APIReleaseContractProperties struct {
	// APIID - Identifier of the API the release belongs to.
	APIID *string `json:"apiId,omitempty"`
	// CreatedDateTime - The time the API was released. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	CreatedDateTime *date.Time `json:"createdDateTime,omitempty"`
	// UpdatedDateTime - The time the API release was updated.
	UpdatedDateTime *date.Time `json:"updatedDateTime,omitempty"`
	// Notes - Release Notes
	Notes *string `json:"notes,omitempty"`
}

// APIRevisionCollection paged Api Revision list representation.
type APIRevisionCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]APIRevisionContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// APIRevisionCollectionIterator provides access to a complete listing of APIRevisionContract values.
type APIRevisionCollectionIterator struct {
	i    int
	page APIRevisionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *APIRevisionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIRevisionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *APIRevisionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter APIRevisionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter APIRevisionCollectionIterator) Response() APIRevisionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter APIRevisionCollectionIterator) Value() APIRevisionContract {
	if !iter.page.NotDone() {
		return APIRevisionContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the APIRevisionCollectionIterator type.
func NewAPIRevisionCollectionIterator(page APIRevisionCollectionPage) APIRevisionCollectionIterator {
	return APIRevisionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arc APIRevisionCollection) IsEmpty() bool {
	return arc.Value == nil || len(*arc.Value) == 0
}

// aPIRevisionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arc APIRevisionCollection) aPIRevisionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if arc.NextLink == nil || len(to.String(arc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arc.NextLink)))
}

// APIRevisionCollectionPage contains a page of APIRevisionContract values.
type APIRevisionCollectionPage struct {
	fn  func(context.Context, APIRevisionCollection) (APIRevisionCollection, error)
	arc APIRevisionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *APIRevisionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIRevisionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.arc)
	if err != nil {
		return err
	}
	page.arc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *APIRevisionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page APIRevisionCollectionPage) NotDone() bool {
	return !page.arc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page APIRevisionCollectionPage) Response() APIRevisionCollection {
	return page.arc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page APIRevisionCollectionPage) Values() []APIRevisionContract {
	if page.arc.IsEmpty() {
		return nil
	}
	return *page.arc.Value
}

// Creates a new instance of the APIRevisionCollectionPage type.
func NewAPIRevisionCollectionPage(getNextPage func(context.Context, APIRevisionCollection) (APIRevisionCollection, error)) APIRevisionCollectionPage {
	return APIRevisionCollectionPage{fn: getNextPage}
}

// APIRevisionContract summary of revision metadata.
type APIRevisionContract struct {
	// APIID - Identifier of the API Revision.
	APIID *string `json:"apiId,omitempty"`
	// APIRevision - Revision number of API.
	APIRevision *string `json:"apiRevision,omitempty"`
	// CreatedDateTime - The time the API Revision was created. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	CreatedDateTime *date.Time `json:"createdDateTime,omitempty"`
	// UpdatedDateTime - The time the API Revision were updated. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
	UpdatedDateTime *date.Time `json:"updatedDateTime,omitempty"`
	// Description - Description of the API Revision.
	Description *string `json:"description,omitempty"`
	// PrivateURL - Gateway URL for accessing the non-current API Revision.
	PrivateURL *string `json:"privateUrl,omitempty"`
	// IsOnline - Indicates if API revision is the current api revision.
	IsOnline *bool `json:"isOnline,omitempty"`
	// IsCurrent - Indicates if API revision is accessible via the gateway.
	IsCurrent *bool `json:"isCurrent,omitempty"`
}

// APIRevisionInfoContract object used to create an API Revision or Version based on an existing API
// Revision
type APIRevisionInfoContract struct {
	// SourceAPIID - Resource identifier of API to be used to create the revision from.
	SourceAPIID *string `json:"sourceApiId,omitempty"`
	// APIVersionName - Version identifier for the new API Version.
	APIVersionName *string `json:"apiVersionName,omitempty"`
	// APIRevisionDescription - Description of new API Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`
	// APIVersionSet - Version set details
	APIVersionSet *APIVersionSetContractDetails `json:"apiVersionSet,omitempty"`
}

// APITagResourceContractProperties API contract properties for the Tag Resources.
type APITagResourceContractProperties struct {
	// ID - API identifier in the form /apis/{apiId}.
	ID *string `json:"id,omitempty"`
	// Name - API name.
	Name *string `json:"name,omitempty"`
	// ServiceURL - Absolute URL of the backend service implementing this API.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// Path - Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
	Path *string `json:"path,omitempty"`
	// Protocols - Describes on which protocols the operations in this API can be invoked.
	Protocols *[]Protocol `json:"protocols,omitempty"`
	// Description - Description of the API. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthenticationSettings - Collection of authentication settings included into this API.
	AuthenticationSettings *AuthenticationSettingsContract `json:"authenticationSettings,omitempty"`
	// SubscriptionKeyParameterNames - Protocols over which API is made available.
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	// APIType - Type of API. Possible values include: 'HTTP', 'Soap'
	APIType APIType `json:"type,omitempty"`
	// APIRevision - Describes the Revision of the Api. If no value is provided, default revision 1 is created
	APIRevision *string `json:"apiRevision,omitempty"`
	// APIVersion - Indicates the Version identifier of the API if the API is versioned
	APIVersion *string `json:"apiVersion,omitempty"`
	// IsCurrent - Indicates if API revision is current api revision.
	IsCurrent *bool `json:"isCurrent,omitempty"`
	// IsOnline - Indicates if API revision is accessible via the gateway.
	IsOnline *bool `json:"isOnline,omitempty"`
	// APIRevisionDescription - Description of the Api Revision.
	APIRevisionDescription *string `json:"apiRevisionDescription,omitempty"`
	// APIVersionDescription - Description of the Api Version.
	APIVersionDescription *string `json:"apiVersionDescription,omitempty"`
	// APIVersionSetID - A resource identifier for the related ApiVersionSet.
	APIVersionSetID *string `json:"apiVersionSetId,omitempty"`
}

// APIUpdateContract API update contract details.
type APIUpdateContract struct {
	// APIContractUpdateProperties - Properties of the API entity that can be updated.
	*APIContractUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for APIUpdateContract.
func (auc APIUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if auc.APIContractUpdateProperties != nil {
		objectMap["properties"] = auc.APIContractUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for APIUpdateContract struct.
func (auc *APIUpdateContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var APIContractUpdateProperties APIContractUpdateProperties
				err = json.Unmarshal(*v, &APIContractUpdateProperties)
				if err != nil {
					return err
				}
				auc.APIContractUpdateProperties = &APIContractUpdateProperties
			}
		}
	}

	return nil
}

// APIVersionSetCollection paged Api Version Set list representation.
type APIVersionSetCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]APIVersionSetContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// APIVersionSetCollectionIterator provides access to a complete listing of APIVersionSetContract values.
type APIVersionSetCollectionIterator struct {
	i    int
	page APIVersionSetCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *APIVersionSetCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIVersionSetCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *APIVersionSetCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter APIVersionSetCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter APIVersionSetCollectionIterator) Response() APIVersionSetCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter APIVersionSetCollectionIterator) Value() APIVersionSetContract {
	if !iter.page.NotDone() {
		return APIVersionSetContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the APIVersionSetCollectionIterator type.
func NewAPIVersionSetCollectionIterator(page APIVersionSetCollectionPage) APIVersionSetCollectionIterator {
	return APIVersionSetCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (avsc APIVersionSetCollection) IsEmpty() bool {
	return avsc.Value == nil || len(*avsc.Value) == 0
}

// aPIVersionSetCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (avsc APIVersionSetCollection) aPIVersionSetCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if avsc.NextLink == nil || len(to.String(avsc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(avsc.NextLink)))
}

// APIVersionSetCollectionPage contains a page of APIVersionSetContract values.
type APIVersionSetCollectionPage struct {
	fn   func(context.Context, APIVersionSetCollection) (APIVersionSetCollection, error)
	avsc APIVersionSetCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *APIVersionSetCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/APIVersionSetCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.avsc)
	if err != nil {
		return err
	}
	page.avsc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *APIVersionSetCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page APIVersionSetCollectionPage) NotDone() bool {
	return !page.avsc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page APIVersionSetCollectionPage) Response() APIVersionSetCollection {
	return page.avsc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page APIVersionSetCollectionPage) Values() []APIVersionSetContract {
	if page.avsc.IsEmpty() {
		return nil
	}
	return *page.avsc.Value
}

// Creates a new instance of the APIVersionSetCollectionPage type.
func NewAPIVersionSetCollectionPage(getNextPage func(context.Context, APIVersionSetCollection) (APIVersionSetCollection, error)) APIVersionSetCollectionPage {
	return APIVersionSetCollectionPage{fn: getNextPage}
}

// APIVersionSetContract api Version Set Contract details.
type APIVersionSetContract struct {
	autorest.Response `json:"-"`
	// APIVersionSetContractProperties - Api VersionSet contract properties.
	*APIVersionSetContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for APIVersionSetContract.
func (avsc APIVersionSetContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if avsc.APIVersionSetContractProperties != nil {
		objectMap["properties"] = avsc.APIVersionSetContractProperties
	}
	if avsc.ID != nil {
		objectMap["id"] = avsc.ID
	}
	if avsc.Name != nil {
		objectMap["name"] = avsc.Name
	}
	if avsc.Type != nil {
		objectMap["type"] = avsc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for APIVersionSetContract struct.
func (avsc *APIVersionSetContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var APIVersionSetContractProperties APIVersionSetContractProperties
				err = json.Unmarshal(*v, &APIVersionSetContractProperties)
				if err != nil {
					return err
				}
				avsc.APIVersionSetContractProperties = &APIVersionSetContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				avsc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				avsc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				avsc.Type = &typeVar
			}
		}
	}

	return nil
}

// APIVersionSetContractDetails an API Version Set contains the common configuration for a set of API
// Versions relating
type APIVersionSetContractDetails struct {
	// ID - Identifier for existing API Version Set. Omit this value to create a new Version Set.
	ID *string `json:"id,omitempty"`
	// Description - Description of API Version Set.
	Description *string `json:"description,omitempty"`
	// VersioningScheme - An value that determines where the API Version identifer will be located in a HTTP request. Possible values include: 'VersioningScheme1Segment', 'VersioningScheme1Query', 'VersioningScheme1Header'
	VersioningScheme VersioningScheme1 `json:"versioningScheme,omitempty"`
	// VersionQueryName - Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
	VersionQueryName *string `json:"versionQueryName,omitempty"`
	// VersionHeaderName - Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
	VersionHeaderName *string `json:"versionHeaderName,omitempty"`
}

// APIVersionSetContractProperties properties of an API Version Set.
type APIVersionSetContractProperties struct {
	// DisplayName - Name of API Version Set
	DisplayName *string `json:"displayName,omitempty"`
	// VersioningScheme - An value that determines where the API Version identifer will be located in a HTTP request. Possible values include: 'VersioningSchemeSegment', 'VersioningSchemeQuery', 'VersioningSchemeHeader'
	VersioningScheme VersioningScheme `json:"versioningScheme,omitempty"`
	// Description - Description of API Version Set.
	Description *string `json:"description,omitempty"`
	// VersionQueryName - Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
	VersionQueryName *string `json:"versionQueryName,omitempty"`
	// VersionHeaderName - Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
	VersionHeaderName *string `json:"versionHeaderName,omitempty"`
}

// APIVersionSetEntityBase api Version set base parameters
type APIVersionSetEntityBase struct {
	// Description - Description of API Version Set.
	Description *string `json:"description,omitempty"`
	// VersionQueryName - Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
	VersionQueryName *string `json:"versionQueryName,omitempty"`
	// VersionHeaderName - Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
	VersionHeaderName *string `json:"versionHeaderName,omitempty"`
}

// APIVersionSetUpdateParameters parameters to update or create an Api Version Set Contract.
type APIVersionSetUpdateParameters struct {
	// APIVersionSetUpdateParametersProperties - Parameters to update or create an Api Version Set Contract.
	*APIVersionSetUpdateParametersProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for APIVersionSetUpdateParameters.
func (avsup APIVersionSetUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if avsup.APIVersionSetUpdateParametersProperties != nil {
		objectMap["properties"] = avsup.APIVersionSetUpdateParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for APIVersionSetUpdateParameters struct.
func (avsup *APIVersionSetUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var APIVersionSetUpdateParametersProperties APIVersionSetUpdateParametersProperties
				err = json.Unmarshal(*v, &APIVersionSetUpdateParametersProperties)
				if err != nil {
					return err
				}
				avsup.APIVersionSetUpdateParametersProperties = &APIVersionSetUpdateParametersProperties
			}
		}
	}

	return nil
}

// APIVersionSetUpdateParametersProperties properties used to create or update an API Version Set.
type APIVersionSetUpdateParametersProperties struct {
	// DisplayName - Name of API Version Set
	DisplayName *string `json:"displayName,omitempty"`
	// VersioningScheme - An value that determines where the API Version identifer will be located in a HTTP request. Possible values include: 'VersioningSchemeSegment', 'VersioningSchemeQuery', 'VersioningSchemeHeader'
	VersioningScheme VersioningScheme `json:"versioningScheme,omitempty"`
	// Description - Description of API Version Set.
	Description *string `json:"description,omitempty"`
	// VersionQueryName - Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
	VersionQueryName *string `json:"versionQueryName,omitempty"`
	// VersionHeaderName - Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
	VersionHeaderName *string `json:"versionHeaderName,omitempty"`
}

// AuthenticationSettingsContract API Authentication Settings.
type AuthenticationSettingsContract struct {
	// OAuth2 - OAuth2 Authentication settings
	OAuth2 *OAuth2AuthenticationSettingsContract `json:"oAuth2,omitempty"`
	// Openid - OpenID Connect Authentication Settings
	Openid *OpenIDAuthenticationSettingsContract `json:"openid,omitempty"`
	// SubscriptionKeyRequired - Specifies whether subscription key is required during call to this API, true - API is included into closed products only, false - API is included into open products alone, null - there is a mix of products.
	SubscriptionKeyRequired *bool `json:"subscriptionKeyRequired,omitempty"`
}

// AuthorizationServerCollection paged OAuth2 Authorization Servers list representation.
type AuthorizationServerCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]AuthorizationServerContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// AuthorizationServerCollectionIterator provides access to a complete listing of
// AuthorizationServerContract values.
type AuthorizationServerCollectionIterator struct {
	i    int
	page AuthorizationServerCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AuthorizationServerCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationServerCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AuthorizationServerCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AuthorizationServerCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AuthorizationServerCollectionIterator) Response() AuthorizationServerCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AuthorizationServerCollectionIterator) Value() AuthorizationServerContract {
	if !iter.page.NotDone() {
		return AuthorizationServerContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AuthorizationServerCollectionIterator type.
func NewAuthorizationServerCollectionIterator(page AuthorizationServerCollectionPage) AuthorizationServerCollectionIterator {
	return AuthorizationServerCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asc AuthorizationServerCollection) IsEmpty() bool {
	return asc.Value == nil || len(*asc.Value) == 0
}

// authorizationServerCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asc AuthorizationServerCollection) authorizationServerCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if asc.NextLink == nil || len(to.String(asc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asc.NextLink)))
}

// AuthorizationServerCollectionPage contains a page of AuthorizationServerContract values.
type AuthorizationServerCollectionPage struct {
	fn  func(context.Context, AuthorizationServerCollection) (AuthorizationServerCollection, error)
	asc AuthorizationServerCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AuthorizationServerCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AuthorizationServerCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.asc)
	if err != nil {
		return err
	}
	page.asc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AuthorizationServerCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AuthorizationServerCollectionPage) NotDone() bool {
	return !page.asc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AuthorizationServerCollectionPage) Response() AuthorizationServerCollection {
	return page.asc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AuthorizationServerCollectionPage) Values() []AuthorizationServerContract {
	if page.asc.IsEmpty() {
		return nil
	}
	return *page.asc.Value
}

// Creates a new instance of the AuthorizationServerCollectionPage type.
func NewAuthorizationServerCollectionPage(getNextPage func(context.Context, AuthorizationServerCollection) (AuthorizationServerCollection, error)) AuthorizationServerCollectionPage {
	return AuthorizationServerCollectionPage{fn: getNextPage}
}

// AuthorizationServerContract external OAuth authorization server settings.
type AuthorizationServerContract struct {
	autorest.Response `json:"-"`
	// AuthorizationServerContractProperties - Properties of the External OAuth authorization server Contract.
	*AuthorizationServerContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AuthorizationServerContract.
func (asc AuthorizationServerContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asc.AuthorizationServerContractProperties != nil {
		objectMap["properties"] = asc.AuthorizationServerContractProperties
	}
	if asc.ID != nil {
		objectMap["id"] = asc.ID
	}
	if asc.Name != nil {
		objectMap["name"] = asc.Name
	}
	if asc.Type != nil {
		objectMap["type"] = asc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AuthorizationServerContract struct.
func (asc *AuthorizationServerContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationServerContractProperties AuthorizationServerContractProperties
				err = json.Unmarshal(*v, &authorizationServerContractProperties)
				if err != nil {
					return err
				}
				asc.AuthorizationServerContractProperties = &authorizationServerContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asc.Type = &typeVar
			}
		}
	}

	return nil
}

// AuthorizationServerContractBaseProperties external OAuth authorization server Update settings contract.
type AuthorizationServerContractBaseProperties struct {
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]AuthorizationMethod `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethod `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethod `json:"bearerTokenSendingMethods,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// AuthorizationServerContractProperties external OAuth authorization server settings Properties.
type AuthorizationServerContractProperties struct {
	// DisplayName - User-friendly authorization server name.
	DisplayName *string `json:"displayName,omitempty"`
	// ClientRegistrationEndpoint - Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`
	// AuthorizationEndpoint - OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`
	// GrantTypes - Form of an authorization grant, which the client uses to request the access token.
	GrantTypes *[]GrantType `json:"grantTypes,omitempty"`
	// ClientID - Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]AuthorizationMethod `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethod `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethod `json:"bearerTokenSendingMethods,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// AuthorizationServerUpdateContract external OAuth authorization server settings.
type AuthorizationServerUpdateContract struct {
	// AuthorizationServerUpdateContractProperties - Properties of the External OAuth authorization server update Contract.
	*AuthorizationServerUpdateContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AuthorizationServerUpdateContract.
func (asuc AuthorizationServerUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asuc.AuthorizationServerUpdateContractProperties != nil {
		objectMap["properties"] = asuc.AuthorizationServerUpdateContractProperties
	}
	if asuc.ID != nil {
		objectMap["id"] = asuc.ID
	}
	if asuc.Name != nil {
		objectMap["name"] = asuc.Name
	}
	if asuc.Type != nil {
		objectMap["type"] = asuc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AuthorizationServerUpdateContract struct.
func (asuc *AuthorizationServerUpdateContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authorizationServerUpdateContractProperties AuthorizationServerUpdateContractProperties
				err = json.Unmarshal(*v, &authorizationServerUpdateContractProperties)
				if err != nil {
					return err
				}
				asuc.AuthorizationServerUpdateContractProperties = &authorizationServerUpdateContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asuc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asuc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asuc.Type = &typeVar
			}
		}
	}

	return nil
}

// AuthorizationServerUpdateContractProperties external OAuth authorization server Update settings
// contract.
type AuthorizationServerUpdateContractProperties struct {
	// DisplayName - User-friendly authorization server name.
	DisplayName *string `json:"displayName,omitempty"`
	// ClientRegistrationEndpoint - Optional reference to a page where client or app registration for this authorization server is performed. Contains absolute URL to entity being referenced.
	ClientRegistrationEndpoint *string `json:"clientRegistrationEndpoint,omitempty"`
	// AuthorizationEndpoint - OAuth authorization endpoint. See http://tools.ietf.org/html/rfc6749#section-3.2.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`
	// GrantTypes - Form of an authorization grant, which the client uses to request the access token.
	GrantTypes *[]GrantType `json:"grantTypes,omitempty"`
	// ClientID - Client or app id registered with this authorization server.
	ClientID *string `json:"clientId,omitempty"`
	// Description - Description of the authorization server. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// AuthorizationMethods - HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
	AuthorizationMethods *[]AuthorizationMethod `json:"authorizationMethods,omitempty"`
	// ClientAuthenticationMethod - Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other parameters are passed within the request body in the application/x-www-form-urlencoded format.
	ClientAuthenticationMethod *[]ClientAuthenticationMethod `json:"clientAuthenticationMethod,omitempty"`
	// TokenBodyParameters - Additional parameters required by the token endpoint of this authorization server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
	TokenBodyParameters *[]TokenBodyParameterContract `json:"tokenBodyParameters,omitempty"`
	// TokenEndpoint - OAuth token endpoint. Contains absolute URI to entity being referenced.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`
	// SupportState - If true, authorization server will include state parameter from the authorization request to its response. Client may use state parameter to raise protocol security.
	SupportState *bool `json:"supportState,omitempty"`
	// DefaultScope - Access token scope that is going to be requested by default. Can be overridden at the API level. Should be provided in the form of a string containing space-delimited values.
	DefaultScope *string `json:"defaultScope,omitempty"`
	// BearerTokenSendingMethods - Specifies the mechanism by which access token is passed to the API.
	BearerTokenSendingMethods *[]BearerTokenSendingMethod `json:"bearerTokenSendingMethods,omitempty"`
	// ClientSecret - Client or app secret registered with this authorization server.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ResourceOwnerUsername - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner username.
	ResourceOwnerUsername *string `json:"resourceOwnerUsername,omitempty"`
	// ResourceOwnerPassword - Can be optionally specified when resource owner password grant type is supported by this authorization server. Default resource owner password.
	ResourceOwnerPassword *string `json:"resourceOwnerPassword,omitempty"`
}

// BackendAuthorizationHeaderCredentials authorization header information.
type BackendAuthorizationHeaderCredentials struct {
	// Scheme - Authentication Scheme name.
	Scheme *string `json:"scheme,omitempty"`
	// Parameter - Authentication Parameter value.
	Parameter *string `json:"parameter,omitempty"`
}

// BackendBaseParameters backend entity base Parameter set.
type BackendBaseParameters struct {
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID *string `json:"resourceId,omitempty"`
	// Properties - Backend Properties contract
	Properties *BackendProperties `json:"properties,omitempty"`
	// Credentials - Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract `json:"credentials,omitempty"`
	// Proxy - Backend Proxy Contract Properties
	Proxy *BackendProxyContract `json:"proxy,omitempty"`
	// TLS - Backend TLS Properties
	TLS *BackendTLSProperties `json:"tls,omitempty"`
}

// BackendCollection paged Backend list representation.
type BackendCollection struct {
	autorest.Response `json:"-"`
	// Value - Backend values.
	Value *[]BackendContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// BackendCollectionIterator provides access to a complete listing of BackendContract values.
type BackendCollectionIterator struct {
	i    int
	page BackendCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackendCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackendCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackendCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackendCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackendCollectionIterator) Response() BackendCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackendCollectionIterator) Value() BackendContract {
	if !iter.page.NotDone() {
		return BackendContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackendCollectionIterator type.
func NewBackendCollectionIterator(page BackendCollectionPage) BackendCollectionIterator {
	return BackendCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bc BackendCollection) IsEmpty() bool {
	return bc.Value == nil || len(*bc.Value) == 0
}

// backendCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bc BackendCollection) backendCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if bc.NextLink == nil || len(to.String(bc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bc.NextLink)))
}

// BackendCollectionPage contains a page of BackendContract values.
type BackendCollectionPage struct {
	fn func(context.Context, BackendCollection) (BackendCollection, error)
	bc BackendCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackendCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackendCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.bc)
	if err != nil {
		return err
	}
	page.bc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackendCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackendCollectionPage) NotDone() bool {
	return !page.bc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackendCollectionPage) Response() BackendCollection {
	return page.bc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackendCollectionPage) Values() []BackendContract {
	if page.bc.IsEmpty() {
		return nil
	}
	return *page.bc.Value
}

// Creates a new instance of the BackendCollectionPage type.
func NewBackendCollectionPage(getNextPage func(context.Context, BackendCollection) (BackendCollection, error)) BackendCollectionPage {
	return BackendCollectionPage{fn: getNextPage}
}

// BackendContract backend details.
type BackendContract struct {
	autorest.Response `json:"-"`
	// BackendContractProperties - Backend entity contract properties.
	*BackendContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendContract.
func (bc BackendContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bc.BackendContractProperties != nil {
		objectMap["properties"] = bc.BackendContractProperties
	}
	if bc.ID != nil {
		objectMap["id"] = bc.ID
	}
	if bc.Name != nil {
		objectMap["name"] = bc.Name
	}
	if bc.Type != nil {
		objectMap["type"] = bc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendContract struct.
func (bc *BackendContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendContractProperties BackendContractProperties
				err = json.Unmarshal(*v, &backendContractProperties)
				if err != nil {
					return err
				}
				bc.BackendContractProperties = &backendContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bc.Type = &typeVar
			}
		}
	}

	return nil
}

// BackendContractProperties parameters supplied to the Create Backend operation.
type BackendContractProperties struct {
	// URL - Runtime Url of the Backend.
	URL *string `json:"url,omitempty"`
	// Protocol - Backend communication protocol. Possible values include: 'BackendProtocolHTTP', 'BackendProtocolSoap'
	Protocol BackendProtocol `json:"protocol,omitempty"`
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID *string `json:"resourceId,omitempty"`
	// Properties - Backend Properties contract
	Properties *BackendProperties `json:"properties,omitempty"`
	// Credentials - Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract `json:"credentials,omitempty"`
	// Proxy - Backend Proxy Contract Properties
	Proxy *BackendProxyContract `json:"proxy,omitempty"`
	// TLS - Backend TLS Properties
	TLS *BackendTLSProperties `json:"tls,omitempty"`
}

// BackendCredentialsContract details of the Credentials used to connect to Backend.
type BackendCredentialsContract struct {
	// Certificate - List of Client Certificate Thumbprint.
	Certificate *[]string `json:"certificate,omitempty"`
	// Query - Query Parameter description.
	Query map[string][]string `json:"query"`
	// Header - Header Parameter description.
	Header map[string][]string `json:"header"`
	// Authorization - Authorization header authentication
	Authorization *BackendAuthorizationHeaderCredentials `json:"authorization,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendCredentialsContract.
func (bcc BackendCredentialsContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bcc.Certificate != nil {
		objectMap["certificate"] = bcc.Certificate
	}
	if bcc.Query != nil {
		objectMap["query"] = bcc.Query
	}
	if bcc.Header != nil {
		objectMap["header"] = bcc.Header
	}
	if bcc.Authorization != nil {
		objectMap["authorization"] = bcc.Authorization
	}
	return json.Marshal(objectMap)
}

// BackendProperties properties specific to the Backend Type.
type BackendProperties struct {
	// ServiceFabricCluster - Backend Service Fabric Cluster Properties
	ServiceFabricCluster *BackendServiceFabricClusterProperties `json:"serviceFabricCluster,omitempty"`
}

// BackendProxyContract details of the Backend WebProxy Server to use in the Request to Backend.
type BackendProxyContract struct {
	// URL - WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
	URL *string `json:"url,omitempty"`
	// Username - Username to connect to the WebProxy server
	Username *string `json:"username,omitempty"`
	// Password - Password to connect to the WebProxy Server
	Password *string `json:"password,omitempty"`
}

// BackendReconnectContract reconnect request parameters.
type BackendReconnectContract struct {
	// BackendReconnectProperties - Reconnect request properties.
	*BackendReconnectProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendReconnectContract.
func (brc BackendReconnectContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if brc.BackendReconnectProperties != nil {
		objectMap["properties"] = brc.BackendReconnectProperties
	}
	if brc.ID != nil {
		objectMap["id"] = brc.ID
	}
	if brc.Name != nil {
		objectMap["name"] = brc.Name
	}
	if brc.Type != nil {
		objectMap["type"] = brc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendReconnectContract struct.
func (brc *BackendReconnectContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendReconnectProperties BackendReconnectProperties
				err = json.Unmarshal(*v, &backendReconnectProperties)
				if err != nil {
					return err
				}
				brc.BackendReconnectProperties = &backendReconnectProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				brc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				brc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				brc.Type = &typeVar
			}
		}
	}

	return nil
}

// BackendReconnectProperties properties to control reconnect requests.
type BackendReconnectProperties struct {
	// After - Duration in ISO8601 format after which reconnect will be initiated. Minimum duration of the Reconnect is PT2M.
	After *string `json:"after,omitempty"`
}

// BackendServiceFabricClusterProperties properties of the Service Fabric Type Backend.
type BackendServiceFabricClusterProperties struct {
	// ClientCertificatethumbprint - The client certificate thumbprint for the management endpoint.
	ClientCertificatethumbprint *string `json:"clientCertificatethumbprint,omitempty"`
	// MaxPartitionResolutionRetries - Maximum number of retries while attempting resolve the partition.
	MaxPartitionResolutionRetries *int32 `json:"maxPartitionResolutionRetries,omitempty"`
	// ManagementEndpoints - The cluster management endpoint.
	ManagementEndpoints *[]string `json:"managementEndpoints,omitempty"`
	// ServerCertificateThumbprints - Thumbprints of certificates cluster management service uses for tls communication
	ServerCertificateThumbprints *[]string `json:"serverCertificateThumbprints,omitempty"`
	// ServerX509Names - Server X509 Certificate Names Collection
	ServerX509Names *[]X509CertificateName `json:"serverX509Names,omitempty"`
}

// BackendTLSProperties properties controlling TLS Certificate Validation.
type BackendTLSProperties struct {
	// ValidateCertificateChain - Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
	ValidateCertificateChain *bool `json:"validateCertificateChain,omitempty"`
	// ValidateCertificateName - Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
	ValidateCertificateName *bool `json:"validateCertificateName,omitempty"`
}

// BackendUpdateParameterProperties parameters supplied to the Update Backend operation.
type BackendUpdateParameterProperties struct {
	// URL - Runtime Url of the Backend.
	URL *string `json:"url,omitempty"`
	// Protocol - Backend communication protocol. Possible values include: 'BackendProtocolHTTP', 'BackendProtocolSoap'
	Protocol BackendProtocol `json:"protocol,omitempty"`
	// Title - Backend Title.
	Title *string `json:"title,omitempty"`
	// Description - Backend Description.
	Description *string `json:"description,omitempty"`
	// ResourceID - Management Uri of the Resource in External System. This url can be the Arm Resource Id of Logic Apps, Function Apps or Api Apps.
	ResourceID *string `json:"resourceId,omitempty"`
	// Properties - Backend Properties contract
	Properties *BackendProperties `json:"properties,omitempty"`
	// Credentials - Backend Credentials Contract Properties
	Credentials *BackendCredentialsContract `json:"credentials,omitempty"`
	// Proxy - Backend Proxy Contract Properties
	Proxy *BackendProxyContract `json:"proxy,omitempty"`
	// TLS - Backend TLS Properties
	TLS *BackendTLSProperties `json:"tls,omitempty"`
}

// BackendUpdateParameters backend update parameters.
type BackendUpdateParameters struct {
	// BackendUpdateParameterProperties - Backend entity update contract properties.
	*BackendUpdateParameterProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BackendUpdateParameters.
func (bup BackendUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bup.BackendUpdateParameterProperties != nil {
		objectMap["properties"] = bup.BackendUpdateParameterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackendUpdateParameters struct.
func (bup *BackendUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backendUpdateParameterProperties BackendUpdateParameterProperties
				err = json.Unmarshal(*v, &backendUpdateParameterProperties)
				if err != nil {
					return err
				}
				bup.BackendUpdateParameterProperties = &backendUpdateParameterProperties
			}
		}
	}

	return nil
}

// CertificateCollection paged Certificates list representation.
type CertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]CertificateContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateCollectionIterator provides access to a complete listing of CertificateContract values.
type CertificateCollectionIterator struct {
	i    int
	page CertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateCollectionIterator) Response() CertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateCollectionIterator) Value() CertificateContract {
	if !iter.page.NotDone() {
		return CertificateContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateCollectionIterator type.
func NewCertificateCollectionIterator(page CertificateCollectionPage) CertificateCollectionIterator {
	return CertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cc CertificateCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// certificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc CertificateCollection) certificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if cc.NextLink == nil || len(to.String(cc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// CertificateCollectionPage contains a page of CertificateContract values.
type CertificateCollectionPage struct {
	fn func(context.Context, CertificateCollection) (CertificateCollection, error)
	cc CertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cc)
	if err != nil {
		return err
	}
	page.cc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateCollectionPage) Response() CertificateCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateCollectionPage) Values() []CertificateContract {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// Creates a new instance of the CertificateCollectionPage type.
func NewCertificateCollectionPage(getNextPage func(context.Context, CertificateCollection) (CertificateCollection, error)) CertificateCollectionPage {
	return CertificateCollectionPage{fn: getNextPage}
}

// CertificateConfiguration certificate configuration which consist of non-trusted intermediates and root
// certificates.
type CertificateConfiguration struct {
	// EncodedCertificate - Base64 Encoded certificate.
	EncodedCertificate *string `json:"encodedCertificate,omitempty"`
	// CertificatePassword - Certificate Password.
	CertificatePassword *string `json:"certificatePassword,omitempty"`
	// StoreName - The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority are valid locations. Possible values include: 'CertificateAuthority', 'Root'
	StoreName StoreName `json:"storeName,omitempty"`
	// Certificate - Certificate information.
	Certificate *CertificateInformation `json:"certificate,omitempty"`
}

// CertificateContract certificate details.
type CertificateContract struct {
	autorest.Response `json:"-"`
	// CertificateContractProperties - Certificate properties details.
	*CertificateContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateContract.
func (cc CertificateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.CertificateContractProperties != nil {
		objectMap["properties"] = cc.CertificateContractProperties
	}
	if cc.ID != nil {
		objectMap["id"] = cc.ID
	}
	if cc.Name != nil {
		objectMap["name"] = cc.Name
	}
	if cc.Type != nil {
		objectMap["type"] = cc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateContract struct.
func (cc *CertificateContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateContractProperties CertificateContractProperties
				err = json.Unmarshal(*v, &certificateContractProperties)
				if err != nil {
					return err
				}
				cc.CertificateContractProperties = &certificateContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cc.Type = &typeVar
			}
		}
	}

	return nil
}

// CertificateContractProperties properties of the Certificate contract.
type CertificateContractProperties struct {
	// Subject - Subject attribute of the certificate.
	Subject *string `json:"subject,omitempty"`
	// Thumbprint - Thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ExpirationDate - Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
}

// CertificateCreateOrUpdateParameters certificate create or update details.
type CertificateCreateOrUpdateParameters struct {
	// CertificateCreateOrUpdateProperties - Certificate create or update properties details.
	*CertificateCreateOrUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateCreateOrUpdateParameters.
func (ccoup CertificateCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccoup.CertificateCreateOrUpdateProperties != nil {
		objectMap["properties"] = ccoup.CertificateCreateOrUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateCreateOrUpdateParameters struct.
func (ccoup *CertificateCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateCreateOrUpdateProperties CertificateCreateOrUpdateProperties
				err = json.Unmarshal(*v, &certificateCreateOrUpdateProperties)
				if err != nil {
					return err
				}
				ccoup.CertificateCreateOrUpdateProperties = &certificateCreateOrUpdateProperties
			}
		}
	}

	return nil
}

// CertificateCreateOrUpdateProperties parameters supplied to the CreateOrUpdate certificate operation.
type CertificateCreateOrUpdateProperties struct {
	// Data - Base 64 encoded certificate using the application/x-pkcs12 representation.
	Data *string `json:"data,omitempty"`
	// Password - Password for the Certificate
	Password *string `json:"password,omitempty"`
}

// CertificateInformation SSL certificate information.
type CertificateInformation struct {
	autorest.Response `json:"-"`
	// Expiry - Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Expiry *date.Time `json:"expiry,omitempty"`
	// Thumbprint - Thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Subject - Subject of the certificate.
	Subject *string `json:"subject,omitempty"`
}

// ConnectivityStatusContract details about connectivity to a resource.
type ConnectivityStatusContract struct {
	// Name - The hostname of the resource which the service depends on. This can be the database, storage or any other azure resource on which the service depends upon.
	Name *string `json:"name,omitempty"`
	// Status - Resource Connectivity Status Type identifier. Possible values include: 'Initializing', 'Success', 'Failure'
	Status ConnectivityStatusType `json:"status,omitempty"`
	// Error - Error details of the connectivity to the resource.
	Error *string `json:"error,omitempty"`
	// LastUpdated - The date when the resource connectivity status was last updated. This status should be updated every 15 minutes. If this status has not been updated, then it means that the service has lost network connectivity to the resource, from inside the Virtual Network.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// LastStatusChange - The date when the resource connectivity status last Changed from success to failure or vice-versa. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	LastStatusChange *date.Time `json:"lastStatusChange,omitempty"`
}

// CurrentUserIdentity ...
type CurrentUserIdentity struct {
	autorest.Response `json:"-"`
	// ID - API Management service user id.
	ID *string `json:"id,omitempty"`
}

// DeployConfigurationParameters parameters supplied to the Deploy Configuration operation.
type DeployConfigurationParameters struct {
	// Branch - The name of the Git branch from which the configuration is to be deployed to the configuration database.
	Branch *string `json:"branch,omitempty"`
	// Force - The value enforcing deleting subscriptions to products that are deleted in this update.
	Force *bool `json:"force,omitempty"`
}

// DiagnosticCollection paged Diagnostic list representation.
type DiagnosticCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]DiagnosticContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// DiagnosticCollectionIterator provides access to a complete listing of DiagnosticContract values.
type DiagnosticCollectionIterator struct {
	i    int
	page DiagnosticCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiagnosticCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiagnosticCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiagnosticCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiagnosticCollectionIterator) Response() DiagnosticCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiagnosticCollectionIterator) Value() DiagnosticContract {
	if !iter.page.NotDone() {
		return DiagnosticContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiagnosticCollectionIterator type.
func NewDiagnosticCollectionIterator(page DiagnosticCollectionPage) DiagnosticCollectionIterator {
	return DiagnosticCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dc DiagnosticCollection) IsEmpty() bool {
	return dc.Value == nil || len(*dc.Value) == 0
}

// diagnosticCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dc DiagnosticCollection) diagnosticCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if dc.NextLink == nil || len(to.String(dc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dc.NextLink)))
}

// DiagnosticCollectionPage contains a page of DiagnosticContract values.
type DiagnosticCollectionPage struct {
	fn func(context.Context, DiagnosticCollection) (DiagnosticCollection, error)
	dc DiagnosticCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiagnosticCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dc)
	if err != nil {
		return err
	}
	page.dc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiagnosticCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiagnosticCollectionPage) NotDone() bool {
	return !page.dc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiagnosticCollectionPage) Response() DiagnosticCollection {
	return page.dc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiagnosticCollectionPage) Values() []DiagnosticContract {
	if page.dc.IsEmpty() {
		return nil
	}
	return *page.dc.Value
}

// Creates a new instance of the DiagnosticCollectionPage type.
func NewDiagnosticCollectionPage(getNextPage func(context.Context, DiagnosticCollection) (DiagnosticCollection, error)) DiagnosticCollectionPage {
	return DiagnosticCollectionPage{fn: getNextPage}
}

// DiagnosticContract diagnostic details.
type DiagnosticContract struct {
	autorest.Response `json:"-"`
	// DiagnosticContractProperties - Diagnostic entity contract properties.
	*DiagnosticContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticContract.
func (dc DiagnosticContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.DiagnosticContractProperties != nil {
		objectMap["properties"] = dc.DiagnosticContractProperties
	}
	if dc.ID != nil {
		objectMap["id"] = dc.ID
	}
	if dc.Name != nil {
		objectMap["name"] = dc.Name
	}
	if dc.Type != nil {
		objectMap["type"] = dc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticContract struct.
func (dc *DiagnosticContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticContractProperties DiagnosticContractProperties
				err = json.Unmarshal(*v, &diagnosticContractProperties)
				if err != nil {
					return err
				}
				dc.DiagnosticContractProperties = &diagnosticContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dc.Type = &typeVar
			}
		}
	}

	return nil
}

// DiagnosticContractProperties diagnostic Entity Properties
type DiagnosticContractProperties struct {
	// Enabled - Indicates whether a diagnostic should receive data or not.
	Enabled *bool `json:"enabled,omitempty"`
}

// EmailTemplateCollection paged email template list representation.
type EmailTemplateCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]EmailTemplateContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// EmailTemplateCollectionIterator provides access to a complete listing of EmailTemplateContract values.
type EmailTemplateCollectionIterator struct {
	i    int
	page EmailTemplateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EmailTemplateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EmailTemplateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EmailTemplateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EmailTemplateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EmailTemplateCollectionIterator) Response() EmailTemplateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EmailTemplateCollectionIterator) Value() EmailTemplateContract {
	if !iter.page.NotDone() {
		return EmailTemplateContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EmailTemplateCollectionIterator type.
func NewEmailTemplateCollectionIterator(page EmailTemplateCollectionPage) EmailTemplateCollectionIterator {
	return EmailTemplateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (etc EmailTemplateCollection) IsEmpty() bool {
	return etc.Value == nil || len(*etc.Value) == 0
}

// emailTemplateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (etc EmailTemplateCollection) emailTemplateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if etc.NextLink == nil || len(to.String(etc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(etc.NextLink)))
}

// EmailTemplateCollectionPage contains a page of EmailTemplateContract values.
type EmailTemplateCollectionPage struct {
	fn  func(context.Context, EmailTemplateCollection) (EmailTemplateCollection, error)
	etc EmailTemplateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EmailTemplateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EmailTemplateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.etc)
	if err != nil {
		return err
	}
	page.etc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EmailTemplateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EmailTemplateCollectionPage) NotDone() bool {
	return !page.etc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EmailTemplateCollectionPage) Response() EmailTemplateCollection {
	return page.etc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EmailTemplateCollectionPage) Values() []EmailTemplateContract {
	if page.etc.IsEmpty() {
		return nil
	}
	return *page.etc.Value
}

// Creates a new instance of the EmailTemplateCollectionPage type.
func NewEmailTemplateCollectionPage(getNextPage func(context.Context, EmailTemplateCollection) (EmailTemplateCollection, error)) EmailTemplateCollectionPage {
	return EmailTemplateCollectionPage{fn: getNextPage}
}

// EmailTemplateContract email Template details.
type EmailTemplateContract struct {
	autorest.Response `json:"-"`
	// EmailTemplateContractProperties - Email Template entity contract properties.
	*EmailTemplateContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EmailTemplateContract.
func (etc EmailTemplateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if etc.EmailTemplateContractProperties != nil {
		objectMap["properties"] = etc.EmailTemplateContractProperties
	}
	if etc.ID != nil {
		objectMap["id"] = etc.ID
	}
	if etc.Name != nil {
		objectMap["name"] = etc.Name
	}
	if etc.Type != nil {
		objectMap["type"] = etc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EmailTemplateContract struct.
func (etc *EmailTemplateContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var emailTemplateContractProperties EmailTemplateContractProperties
				err = json.Unmarshal(*v, &emailTemplateContractProperties)
				if err != nil {
					return err
				}
				etc.EmailTemplateContractProperties = &emailTemplateContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				etc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				etc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				etc.Type = &typeVar
			}
		}
	}

	return nil
}

// EmailTemplateContractProperties email Template Contract properties.
type EmailTemplateContractProperties struct {
	// Subject - Subject of the Template.
	Subject *string `json:"subject,omitempty"`
	// Body - Email Template Body. This should be a valid XDocument
	Body *string `json:"body,omitempty"`
	// Title - Title of the Template.
	Title *string `json:"title,omitempty"`
	// Description - Description of the Email Template.
	Description *string `json:"description,omitempty"`
	// IsDefault - Whether the template is the default template provided by Api Management or has been edited.
	IsDefault *bool `json:"isDefault,omitempty"`
	// Parameters - Email Template Parameter values.
	Parameters *[]EmailTemplateParametersContractProperties `json:"parameters,omitempty"`
}

// EmailTemplateParametersContractProperties email Template Parameter contract.
type EmailTemplateParametersContractProperties struct {
	// Name - Template parameter name.
	Name *string `json:"name,omitempty"`
	// Title - Template parameter title.
	Title *string `json:"title,omitempty"`
	// Description - Template parameter description.
	Description *string `json:"description,omitempty"`
}

// EmailTemplateUpdateParameterProperties email Template Update Contract properties.
type EmailTemplateUpdateParameterProperties struct {
	// Subject - Subject of the Template.
	Subject *string `json:"subject,omitempty"`
	// Title - Title of the Template.
	Title *string `json:"title,omitempty"`
	// Description - Description of the Email Template.
	Description *string `json:"description,omitempty"`
	// Body - Email Template Body. This should be a valid XDocument
	Body *string `json:"body,omitempty"`
	// Parameters - Email Template Parameter values.
	Parameters *[]EmailTemplateParametersContractProperties `json:"parameters,omitempty"`
}

// EmailTemplateUpdateParameters email Template update Parameters.
type EmailTemplateUpdateParameters struct {
	// EmailTemplateUpdateParameterProperties - Email Template Update contract properties.
	*EmailTemplateUpdateParameterProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EmailTemplateUpdateParameters.
func (etup EmailTemplateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if etup.EmailTemplateUpdateParameterProperties != nil {
		objectMap["properties"] = etup.EmailTemplateUpdateParameterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EmailTemplateUpdateParameters struct.
func (etup *EmailTemplateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var emailTemplateUpdateParameterProperties EmailTemplateUpdateParameterProperties
				err = json.Unmarshal(*v, &emailTemplateUpdateParameterProperties)
				if err != nil {
					return err
				}
				etup.EmailTemplateUpdateParameterProperties = &emailTemplateUpdateParameterProperties
			}
		}
	}

	return nil
}

// ErrorFieldContract error Field contract.
type ErrorFieldContract struct {
	// Code - Property level error code.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of property-level error.
	Message *string `json:"message,omitempty"`
	// Target - Property name.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse error Response.
type ErrorResponse struct {
	// ErrorResponseBody - Properties of the Error Response.
	*ErrorResponseBody `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if er.ErrorResponseBody != nil {
		objectMap["error"] = er.ErrorResponseBody
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ErrorResponse struct.
func (er *ErrorResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "error":
			if v != nil {
				var errorResponseBody ErrorResponseBody
				err = json.Unmarshal(*v, &errorResponseBody)
				if err != nil {
					return err
				}
				er.ErrorResponseBody = &errorResponseBody
			}
		}
	}

	return nil
}

// ErrorResponseBody error Body contract.
type ErrorResponseBody struct {
	// Code - Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
	// Details - The list of invalid fields send in request, in case of validation error.
	Details *[]ErrorFieldContract `json:"details,omitempty"`
}

// GenerateSsoURLResult generate SSO Url operations response details.
type GenerateSsoURLResult struct {
	autorest.Response `json:"-"`
	// Value - Redirect Url containing the SSO URL value.
	Value *string `json:"value,omitempty"`
}

// GroupCollection paged Group list representation.
type GroupCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]GroupContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupCollectionIterator provides access to a complete listing of GroupContract values.
type GroupCollectionIterator struct {
	i    int
	page GroupCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GroupCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupCollectionIterator) Response() GroupCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupCollectionIterator) Value() GroupContract {
	if !iter.page.NotDone() {
		return GroupContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GroupCollectionIterator type.
func NewGroupCollectionIterator(page GroupCollectionPage) GroupCollectionIterator {
	return GroupCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (gc GroupCollection) IsEmpty() bool {
	return gc.Value == nil || len(*gc.Value) == 0
}

// groupCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gc GroupCollection) groupCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if gc.NextLink == nil || len(to.String(gc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gc.NextLink)))
}

// GroupCollectionPage contains a page of GroupContract values.
type GroupCollectionPage struct {
	fn func(context.Context, GroupCollection) (GroupCollection, error)
	gc GroupCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.gc)
	if err != nil {
		return err
	}
	page.gc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GroupCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupCollectionPage) NotDone() bool {
	return !page.gc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupCollectionPage) Response() GroupCollection {
	return page.gc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupCollectionPage) Values() []GroupContract {
	if page.gc.IsEmpty() {
		return nil
	}
	return *page.gc.Value
}

// Creates a new instance of the GroupCollectionPage type.
func NewGroupCollectionPage(getNextPage func(context.Context, GroupCollection) (GroupCollection, error)) GroupCollectionPage {
	return GroupCollectionPage{fn: getNextPage}
}

// GroupContract contract details.
type GroupContract struct {
	autorest.Response `json:"-"`
	// GroupContractProperties - Group entity contract properties.
	*GroupContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupContract.
func (gc GroupContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gc.GroupContractProperties != nil {
		objectMap["properties"] = gc.GroupContractProperties
	}
	if gc.ID != nil {
		objectMap["id"] = gc.ID
	}
	if gc.Name != nil {
		objectMap["name"] = gc.Name
	}
	if gc.Type != nil {
		objectMap["type"] = gc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GroupContract struct.
func (gc *GroupContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var groupContractProperties GroupContractProperties
				err = json.Unmarshal(*v, &groupContractProperties)
				if err != nil {
					return err
				}
				gc.GroupContractProperties = &groupContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gc.Type = &typeVar
			}
		}
	}

	return nil
}

// GroupContractProperties group contract Properties.
type GroupContractProperties struct {
	// DisplayName - Group name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Group description. Can contain HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// BuiltIn - true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
	BuiltIn *bool `json:"builtIn,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupType `json:"type,omitempty"`
	// ExternalID - For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// GroupCreateParameters parameters supplied to the Create Group operation.
type GroupCreateParameters struct {
	// GroupCreateParametersProperties - Properties supplied to Create Group operation.
	*GroupCreateParametersProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupCreateParameters.
func (gcp GroupCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gcp.GroupCreateParametersProperties != nil {
		objectMap["properties"] = gcp.GroupCreateParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GroupCreateParameters struct.
func (gcp *GroupCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var groupCreateParametersProperties GroupCreateParametersProperties
				err = json.Unmarshal(*v, &groupCreateParametersProperties)
				if err != nil {
					return err
				}
				gcp.GroupCreateParametersProperties = &groupCreateParametersProperties
			}
		}
	}

	return nil
}

// GroupCreateParametersProperties parameters supplied to the Create Group operation.
type GroupCreateParametersProperties struct {
	// DisplayName - Group name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Group description.
	Description *string `json:"description,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupType `json:"type,omitempty"`
	// ExternalID - Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// GroupUpdateParameters parameters supplied to the Update Group operation.
type GroupUpdateParameters struct {
	// GroupUpdateParametersProperties - Group entity update contract properties.
	*GroupUpdateParametersProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupUpdateParameters.
func (gup GroupUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gup.GroupUpdateParametersProperties != nil {
		objectMap["properties"] = gup.GroupUpdateParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GroupUpdateParameters struct.
func (gup *GroupUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var groupUpdateParametersProperties GroupUpdateParametersProperties
				err = json.Unmarshal(*v, &groupUpdateParametersProperties)
				if err != nil {
					return err
				}
				gup.GroupUpdateParametersProperties = &groupUpdateParametersProperties
			}
		}
	}

	return nil
}

// GroupUpdateParametersProperties parameters supplied to the Update Group operation.
type GroupUpdateParametersProperties struct {
	// DisplayName - Group name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Group description.
	Description *string `json:"description,omitempty"`
	// Type - Group type. Possible values include: 'Custom', 'System', 'External'
	Type GroupType `json:"type,omitempty"`
	// ExternalID - Identifier of the external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory aad://<tenant>.onmicrosoft.com/groups/<group object id>; otherwise the value is null.
	ExternalID *string `json:"externalId,omitempty"`
}

// HostnameConfiguration custom hostname configuration.
type HostnameConfiguration struct {
	// Type - Hostname type. Possible values include: 'Proxy', 'Portal', 'Management', 'Scm'
	Type HostnameType `json:"type,omitempty"`
	// HostName - Hostname to configure on the Api Management service.
	HostName *string `json:"hostName,omitempty"`
	// KeyVaultID - Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with MSI. The secret should be of type *application/x-pkcs12*
	KeyVaultID *string `json:"keyVaultId,omitempty"`
	// EncodedCertificate - Base64 Encoded certificate.
	EncodedCertificate *string `json:"encodedCertificate,omitempty"`
	// CertificatePassword - Certificate Password.
	CertificatePassword *string `json:"certificatePassword,omitempty"`
	// DefaultSslBinding - Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to Proxy Hostname Type.
	DefaultSslBinding *bool `json:"defaultSslBinding,omitempty"`
	// NegotiateClientCertificate - Specify true to always negotiate client certificate on the hostname. Default Value is false.
	NegotiateClientCertificate *bool `json:"negotiateClientCertificate,omitempty"`
	// Certificate - Certificate information.
	Certificate *CertificateInformation `json:"certificate,omitempty"`
}

// HostnameConfigurationOld custom hostname configuration.
type HostnameConfigurationOld struct {
	// Type - Hostname type. Possible values include: 'Proxy', 'Portal', 'Management', 'Scm'
	Type HostnameType `json:"type,omitempty"`
	// Hostname - Hostname to configure.
	Hostname *string `json:"hostname,omitempty"`
	// Certificate - Certificate information.
	Certificate *CertificateInformation `json:"certificate,omitempty"`
}

// IdentityProviderBaseParameters identity Provider Base Parameter Properties.
type IdentityProviderBaseParameters struct {
	// Type - Identity Provider Type identifier. Possible values include: 'Facebook', 'Google', 'Microsoft', 'Twitter', 'Aad', 'AadB2C'
	Type IdentityProviderType `json:"type,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
	// SignupPolicyName - Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`
	// SigninPolicyName - Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`
	// ProfileEditingPolicyName - Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`
	// PasswordResetPolicyName - Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`
}

// IdentityProviderContract identity Provider details.
type IdentityProviderContract struct {
	autorest.Response `json:"-"`
	// IdentityProviderContractProperties - Identity Provider contract properties.
	*IdentityProviderContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IdentityProviderContract.
func (ipc IdentityProviderContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipc.IdentityProviderContractProperties != nil {
		objectMap["properties"] = ipc.IdentityProviderContractProperties
	}
	if ipc.ID != nil {
		objectMap["id"] = ipc.ID
	}
	if ipc.Name != nil {
		objectMap["name"] = ipc.Name
	}
	if ipc.Type != nil {
		objectMap["type"] = ipc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IdentityProviderContract struct.
func (ipc *IdentityProviderContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var identityProviderContractProperties IdentityProviderContractProperties
				err = json.Unmarshal(*v, &identityProviderContractProperties)
				if err != nil {
					return err
				}
				ipc.IdentityProviderContractProperties = &identityProviderContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ipc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ipc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ipc.Type = &typeVar
			}
		}
	}

	return nil
}

// IdentityProviderContractProperties the external Identity Providers like Facebook, Google, Microsoft,
// Twitter or Azure Active Directory which can be used to enable access to the API Management service
// developer portal for all users.
type IdentityProviderContractProperties struct {
	// ClientID - Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Type - Identity Provider Type identifier. Possible values include: 'Facebook', 'Google', 'Microsoft', 'Twitter', 'Aad', 'AadB2C'
	Type IdentityProviderType `json:"type,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
	// SignupPolicyName - Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`
	// SigninPolicyName - Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`
	// ProfileEditingPolicyName - Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`
	// PasswordResetPolicyName - Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`
}

// IdentityProviderList list of all the Identity Providers configured on the service instance.
type IdentityProviderList struct {
	autorest.Response `json:"-"`
	// Value - Identity Provider configuration values.
	Value *[]IdentityProviderContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// IdentityProviderListIterator provides access to a complete listing of IdentityProviderContract values.
type IdentityProviderListIterator struct {
	i    int
	page IdentityProviderListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IdentityProviderListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IdentityProviderListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IdentityProviderListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IdentityProviderListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IdentityProviderListIterator) Response() IdentityProviderList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IdentityProviderListIterator) Value() IdentityProviderContract {
	if !iter.page.NotDone() {
		return IdentityProviderContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IdentityProviderListIterator type.
func NewIdentityProviderListIterator(page IdentityProviderListPage) IdentityProviderListIterator {
	return IdentityProviderListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ipl IdentityProviderList) IsEmpty() bool {
	return ipl.Value == nil || len(*ipl.Value) == 0
}

// identityProviderListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ipl IdentityProviderList) identityProviderListPreparer(ctx context.Context) (*http.Request, error) {
	if ipl.NextLink == nil || len(to.String(ipl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ipl.NextLink)))
}

// IdentityProviderListPage contains a page of IdentityProviderContract values.
type IdentityProviderListPage struct {
	fn  func(context.Context, IdentityProviderList) (IdentityProviderList, error)
	ipl IdentityProviderList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IdentityProviderListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IdentityProviderListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ipl)
	if err != nil {
		return err
	}
	page.ipl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IdentityProviderListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IdentityProviderListPage) NotDone() bool {
	return !page.ipl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IdentityProviderListPage) Response() IdentityProviderList {
	return page.ipl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IdentityProviderListPage) Values() []IdentityProviderContract {
	if page.ipl.IsEmpty() {
		return nil
	}
	return *page.ipl.Value
}

// Creates a new instance of the IdentityProviderListPage type.
func NewIdentityProviderListPage(getNextPage func(context.Context, IdentityProviderList) (IdentityProviderList, error)) IdentityProviderListPage {
	return IdentityProviderListPage{fn: getNextPage}
}

// IdentityProviderUpdateParameters parameters supplied to update Identity Provider
type IdentityProviderUpdateParameters struct {
	// IdentityProviderUpdateProperties - Identity Provider update properties.
	*IdentityProviderUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for IdentityProviderUpdateParameters.
func (ipup IdentityProviderUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipup.IdentityProviderUpdateProperties != nil {
		objectMap["properties"] = ipup.IdentityProviderUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IdentityProviderUpdateParameters struct.
func (ipup *IdentityProviderUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var identityProviderUpdateProperties IdentityProviderUpdateProperties
				err = json.Unmarshal(*v, &identityProviderUpdateProperties)
				if err != nil {
					return err
				}
				ipup.IdentityProviderUpdateProperties = &identityProviderUpdateProperties
			}
		}
	}

	return nil
}

// IdentityProviderUpdateProperties parameters supplied to the Update Identity Provider operation.
type IdentityProviderUpdateProperties struct {
	// ClientID - Client Id of the Application in the external Identity Provider. It is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret of the Application in external Identity Provider, used to authenticate login request. For example, it is App Secret for Facebook login, API Key for Google login, Public Key for Microsoft.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// Type - Identity Provider Type identifier. Possible values include: 'Facebook', 'Google', 'Microsoft', 'Twitter', 'Aad', 'AadB2C'
	Type IdentityProviderType `json:"type,omitempty"`
	// AllowedTenants - List of Allowed Tenants when configuring Azure Active Directory login.
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
	// SignupPolicyName - Signup Policy Name. Only applies to AAD B2C Identity Provider.
	SignupPolicyName *string `json:"signupPolicyName,omitempty"`
	// SigninPolicyName - Signin Policy Name. Only applies to AAD B2C Identity Provider.
	SigninPolicyName *string `json:"signinPolicyName,omitempty"`
	// ProfileEditingPolicyName - Profile Editing Policy Name. Only applies to AAD B2C Identity Provider.
	ProfileEditingPolicyName *string `json:"profileEditingPolicyName,omitempty"`
	// PasswordResetPolicyName - Password Reset Policy Name. Only applies to AAD B2C Identity Provider.
	PasswordResetPolicyName *string `json:"passwordResetPolicyName,omitempty"`
}

// IssueAttachmentCollection paged Issue Attachment list representation.
type IssueAttachmentCollection struct {
	autorest.Response `json:"-"`
	// Value - Issue Attachment values.
	Value *[]IssueAttachmentContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// IssueAttachmentCollectionIterator provides access to a complete listing of IssueAttachmentContract
// values.
type IssueAttachmentCollectionIterator struct {
	i    int
	page IssueAttachmentCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IssueAttachmentCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IssueAttachmentCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IssueAttachmentCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IssueAttachmentCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IssueAttachmentCollectionIterator) Response() IssueAttachmentCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IssueAttachmentCollectionIterator) Value() IssueAttachmentContract {
	if !iter.page.NotDone() {
		return IssueAttachmentContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IssueAttachmentCollectionIterator type.
func NewIssueAttachmentCollectionIterator(page IssueAttachmentCollectionPage) IssueAttachmentCollectionIterator {
	return IssueAttachmentCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iac IssueAttachmentCollection) IsEmpty() bool {
	return iac.Value == nil || len(*iac.Value) == 0
}

// issueAttachmentCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iac IssueAttachmentCollection) issueAttachmentCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if iac.NextLink == nil || len(to.String(iac.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iac.NextLink)))
}

// IssueAttachmentCollectionPage contains a page of IssueAttachmentContract values.
type IssueAttachmentCollectionPage struct {
	fn  func(context.Context, IssueAttachmentCollection) (IssueAttachmentCollection, error)
	iac IssueAttachmentCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IssueAttachmentCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IssueAttachmentCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.iac)
	if err != nil {
		return err
	}
	page.iac = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IssueAttachmentCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IssueAttachmentCollectionPage) NotDone() bool {
	return !page.iac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IssueAttachmentCollectionPage) Response() IssueAttachmentCollection {
	return page.iac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IssueAttachmentCollectionPage) Values() []IssueAttachmentContract {
	if page.iac.IsEmpty() {
		return nil
	}
	return *page.iac.Value
}

// Creates a new instance of the IssueAttachmentCollectionPage type.
func NewIssueAttachmentCollectionPage(getNextPage func(context.Context, IssueAttachmentCollection) (IssueAttachmentCollection, error)) IssueAttachmentCollectionPage {
	return IssueAttachmentCollectionPage{fn: getNextPage}
}

// IssueAttachmentContract issue Attachment Contract details.
type IssueAttachmentContract struct {
	autorest.Response `json:"-"`
	// IssueAttachmentContractProperties - Properties of the Issue Attachment.
	*IssueAttachmentContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IssueAttachmentContract.
func (iac IssueAttachmentContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iac.IssueAttachmentContractProperties != nil {
		objectMap["properties"] = iac.IssueAttachmentContractProperties
	}
	if iac.ID != nil {
		objectMap["id"] = iac.ID
	}
	if iac.Name != nil {
		objectMap["name"] = iac.Name
	}
	if iac.Type != nil {
		objectMap["type"] = iac.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IssueAttachmentContract struct.
func (iac *IssueAttachmentContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var issueAttachmentContractProperties IssueAttachmentContractProperties
				err = json.Unmarshal(*v, &issueAttachmentContractProperties)
				if err != nil {
					return err
				}
				iac.IssueAttachmentContractProperties = &issueAttachmentContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iac.Type = &typeVar
			}
		}
	}

	return nil
}

// IssueAttachmentContractProperties issue Attachment contract Properties.
type IssueAttachmentContractProperties struct {
	// Title - Filename by which the binary data will be saved.
	Title *string `json:"title,omitempty"`
	// ContentFormat - Either 'link' if content is provided via an HTTP link or the MIME type of the Base64-encoded binary data provided in the 'content' property.
	ContentFormat *string `json:"contentFormat,omitempty"`
	// Content - An HTTP link or Base64-encoded binary data.
	Content *string `json:"content,omitempty"`
}

// IssueCollection paged Issue list representation.
type IssueCollection struct {
	autorest.Response `json:"-"`
	// Value - Issue values.
	Value *[]IssueContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// IssueCollectionIterator provides access to a complete listing of IssueContract values.
type IssueCollectionIterator struct {
	i    int
	page IssueCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IssueCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IssueCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IssueCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IssueCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IssueCollectionIterator) Response() IssueCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IssueCollectionIterator) Value() IssueContract {
	if !iter.page.NotDone() {
		return IssueContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IssueCollectionIterator type.
func NewIssueCollectionIterator(page IssueCollectionPage) IssueCollectionIterator {
	return IssueCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ic IssueCollection) IsEmpty() bool {
	return ic.Value == nil || len(*ic.Value) == 0
}

// issueCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ic IssueCollection) issueCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if ic.NextLink == nil || len(to.String(ic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ic.NextLink)))
}

// IssueCollectionPage contains a page of IssueContract values.
type IssueCollectionPage struct {
	fn func(context.Context, IssueCollection) (IssueCollection, error)
	ic IssueCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IssueCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IssueCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ic)
	if err != nil {
		return err
	}
	page.ic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IssueCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IssueCollectionPage) NotDone() bool {
	return !page.ic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IssueCollectionPage) Response() IssueCollection {
	return page.ic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IssueCollectionPage) Values() []IssueContract {
	if page.ic.IsEmpty() {
		return nil
	}
	return *page.ic.Value
}

// Creates a new instance of the IssueCollectionPage type.
func NewIssueCollectionPage(getNextPage func(context.Context, IssueCollection) (IssueCollection, error)) IssueCollectionPage {
	return IssueCollectionPage{fn: getNextPage}
}

// IssueCommentCollection paged Issue Comment list representation.
type IssueCommentCollection struct {
	autorest.Response `json:"-"`
	// Value - Issue Comment values.
	Value *[]IssueCommentContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// IssueCommentCollectionIterator provides access to a complete listing of IssueCommentContract values.
type IssueCommentCollectionIterator struct {
	i    int
	page IssueCommentCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IssueCommentCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IssueCommentCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IssueCommentCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IssueCommentCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IssueCommentCollectionIterator) Response() IssueCommentCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IssueCommentCollectionIterator) Value() IssueCommentContract {
	if !iter.page.NotDone() {
		return IssueCommentContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IssueCommentCollectionIterator type.
func NewIssueCommentCollectionIterator(page IssueCommentCollectionPage) IssueCommentCollectionIterator {
	return IssueCommentCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (icc IssueCommentCollection) IsEmpty() bool {
	return icc.Value == nil || len(*icc.Value) == 0
}

// issueCommentCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (icc IssueCommentCollection) issueCommentCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if icc.NextLink == nil || len(to.String(icc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(icc.NextLink)))
}

// IssueCommentCollectionPage contains a page of IssueCommentContract values.
type IssueCommentCollectionPage struct {
	fn  func(context.Context, IssueCommentCollection) (IssueCommentCollection, error)
	icc IssueCommentCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IssueCommentCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IssueCommentCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.icc)
	if err != nil {
		return err
	}
	page.icc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IssueCommentCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IssueCommentCollectionPage) NotDone() bool {
	return !page.icc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IssueCommentCollectionPage) Response() IssueCommentCollection {
	return page.icc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IssueCommentCollectionPage) Values() []IssueCommentContract {
	if page.icc.IsEmpty() {
		return nil
	}
	return *page.icc.Value
}

// Creates a new instance of the IssueCommentCollectionPage type.
func NewIssueCommentCollectionPage(getNextPage func(context.Context, IssueCommentCollection) (IssueCommentCollection, error)) IssueCommentCollectionPage {
	return IssueCommentCollectionPage{fn: getNextPage}
}

// IssueCommentContract issue Comment Contract details.
type IssueCommentContract struct {
	autorest.Response `json:"-"`
	// IssueCommentContractProperties - Properties of the Issue Comment.
	*IssueCommentContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IssueCommentContract.
func (icc IssueCommentContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if icc.IssueCommentContractProperties != nil {
		objectMap["properties"] = icc.IssueCommentContractProperties
	}
	if icc.ID != nil {
		objectMap["id"] = icc.ID
	}
	if icc.Name != nil {
		objectMap["name"] = icc.Name
	}
	if icc.Type != nil {
		objectMap["type"] = icc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IssueCommentContract struct.
func (icc *IssueCommentContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var issueCommentContractProperties IssueCommentContractProperties
				err = json.Unmarshal(*v, &issueCommentContractProperties)
				if err != nil {
					return err
				}
				icc.IssueCommentContractProperties = &issueCommentContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				icc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				icc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				icc.Type = &typeVar
			}
		}
	}

	return nil
}

// IssueCommentContractProperties issue Comment contract Properties.
type IssueCommentContractProperties struct {
	// Text - Comment text.
	Text *string `json:"text,omitempty"`
	// CreatedDate - Date and time when the comment was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// UserID - A resource identifier for the user who left the comment.
	UserID *string `json:"userId,omitempty"`
}

// IssueContract issue Contract details.
type IssueContract struct {
	autorest.Response `json:"-"`
	// IssueContractProperties - Properties of the Issue.
	*IssueContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IssueContract.
func (ic IssueContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.IssueContractProperties != nil {
		objectMap["properties"] = ic.IssueContractProperties
	}
	if ic.ID != nil {
		objectMap["id"] = ic.ID
	}
	if ic.Name != nil {
		objectMap["name"] = ic.Name
	}
	if ic.Type != nil {
		objectMap["type"] = ic.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IssueContract struct.
func (ic *IssueContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var issueContractProperties IssueContractProperties
				err = json.Unmarshal(*v, &issueContractProperties)
				if err != nil {
					return err
				}
				ic.IssueContractProperties = &issueContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ic.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ic.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ic.Type = &typeVar
			}
		}
	}

	return nil
}

// IssueContractBaseProperties issue contract Base Properties.
type IssueContractBaseProperties struct {
	// CreatedDate - Date and time when the issue was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// State - Status of the issue. Possible values include: 'Proposed', 'Open', 'Removed', 'Resolved', 'Closed'
	State State `json:"state,omitempty"`
	// APIID - A resource identifier for the API the issue was created for.
	APIID *string `json:"apiId,omitempty"`
}

// IssueContractProperties issue contract Properties.
type IssueContractProperties struct {
	// Title - The issue title.
	Title *string `json:"title,omitempty"`
	// Description - Text describing the issue.
	Description *string `json:"description,omitempty"`
	// UserID - A resource identifier for the user created the issue.
	UserID *string `json:"userId,omitempty"`
	// CreatedDate - Date and time when the issue was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// State - Status of the issue. Possible values include: 'Proposed', 'Open', 'Removed', 'Resolved', 'Closed'
	State State `json:"state,omitempty"`
	// APIID - A resource identifier for the API the issue was created for.
	APIID *string `json:"apiId,omitempty"`
}

// IssueUpdateContract issue update Parameters.
type IssueUpdateContract struct {
	// IssueUpdateContractProperties - Issue entity Update contract properties.
	*IssueUpdateContractProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for IssueUpdateContract.
func (iuc IssueUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if iuc.IssueUpdateContractProperties != nil {
		objectMap["properties"] = iuc.IssueUpdateContractProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IssueUpdateContract struct.
func (iuc *IssueUpdateContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var issueUpdateContractProperties IssueUpdateContractProperties
				err = json.Unmarshal(*v, &issueUpdateContractProperties)
				if err != nil {
					return err
				}
				iuc.IssueUpdateContractProperties = &issueUpdateContractProperties
			}
		}
	}

	return nil
}

// IssueUpdateContractProperties issue contract Update Properties.
type IssueUpdateContractProperties struct {
	// Title - The issue title.
	Title *string `json:"title,omitempty"`
	// Description - Text describing the issue.
	Description *string `json:"description,omitempty"`
	// UserID - A resource identifier for the user created the issue.
	UserID *string `json:"userId,omitempty"`
	// CreatedDate - Date and time when the issue was created.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// State - Status of the issue. Possible values include: 'Proposed', 'Open', 'Removed', 'Resolved', 'Closed'
	State State `json:"state,omitempty"`
	// APIID - A resource identifier for the API the issue was created for.
	APIID *string `json:"apiId,omitempty"`
}

// ListNetworkStatusContractByLocation ...
type ListNetworkStatusContractByLocation struct {
	autorest.Response `json:"-"`
	Value             *[]NetworkStatusContractByLocation `json:"value,omitempty"`
}

// LoggerCollection paged Logger list representation.
type LoggerCollection struct {
	autorest.Response `json:"-"`
	// Value - Logger values.
	Value *[]LoggerContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// LoggerCollectionIterator provides access to a complete listing of LoggerContract values.
type LoggerCollectionIterator struct {
	i    int
	page LoggerCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LoggerCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoggerCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LoggerCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LoggerCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LoggerCollectionIterator) Response() LoggerCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LoggerCollectionIterator) Value() LoggerContract {
	if !iter.page.NotDone() {
		return LoggerContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LoggerCollectionIterator type.
func NewLoggerCollectionIterator(page LoggerCollectionPage) LoggerCollectionIterator {
	return LoggerCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lc LoggerCollection) IsEmpty() bool {
	return lc.Value == nil || len(*lc.Value) == 0
}

// loggerCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lc LoggerCollection) loggerCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if lc.NextLink == nil || len(to.String(lc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lc.NextLink)))
}

// LoggerCollectionPage contains a page of LoggerContract values.
type LoggerCollectionPage struct {
	fn func(context.Context, LoggerCollection) (LoggerCollection, error)
	lc LoggerCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LoggerCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LoggerCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lc)
	if err != nil {
		return err
	}
	page.lc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LoggerCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LoggerCollectionPage) NotDone() bool {
	return !page.lc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LoggerCollectionPage) Response() LoggerCollection {
	return page.lc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LoggerCollectionPage) Values() []LoggerContract {
	if page.lc.IsEmpty() {
		return nil
	}
	return *page.lc.Value
}

// Creates a new instance of the LoggerCollectionPage type.
func NewLoggerCollectionPage(getNextPage func(context.Context, LoggerCollection) (LoggerCollection, error)) LoggerCollectionPage {
	return LoggerCollectionPage{fn: getNextPage}
}

// LoggerContract logger details.
type LoggerContract struct {
	autorest.Response `json:"-"`
	// LoggerContractProperties - Logger entity contract properties.
	*LoggerContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerContract.
func (lc LoggerContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lc.LoggerContractProperties != nil {
		objectMap["properties"] = lc.LoggerContractProperties
	}
	if lc.ID != nil {
		objectMap["id"] = lc.ID
	}
	if lc.Name != nil {
		objectMap["name"] = lc.Name
	}
	if lc.Type != nil {
		objectMap["type"] = lc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoggerContract struct.
func (lc *LoggerContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loggerContractProperties LoggerContractProperties
				err = json.Unmarshal(*v, &loggerContractProperties)
				if err != nil {
					return err
				}
				lc.LoggerContractProperties = &loggerContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lc.Type = &typeVar
			}
		}
	}

	return nil
}

// LoggerContractProperties the Logger entity in API Management represents an event sink that you can use
// to log API Management events. Currently the Logger entity supports logging API Management events to
// Azure Event Hubs.
type LoggerContractProperties struct {
	// LoggerType - Logger type. Possible values include: 'AzureEventHub', 'ApplicationInsights'
	LoggerType LoggerType `json:"loggerType,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - The name and SendRule connection string of the event hub for azureEventHub logger.
	// Instrumentation key for applicationInsights logger.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerContractProperties.
func (lcp LoggerContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lcp.LoggerType != "" {
		objectMap["loggerType"] = lcp.LoggerType
	}
	if lcp.Description != nil {
		objectMap["description"] = lcp.Description
	}
	if lcp.Credentials != nil {
		objectMap["credentials"] = lcp.Credentials
	}
	if lcp.IsBuffered != nil {
		objectMap["isBuffered"] = lcp.IsBuffered
	}
	return json.Marshal(objectMap)
}

// LoggerUpdateContract logger update contract.
type LoggerUpdateContract struct {
	// LoggerUpdateParameters - Logger entity update contract properties.
	*LoggerUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerUpdateContract.
func (luc LoggerUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if luc.LoggerUpdateParameters != nil {
		objectMap["properties"] = luc.LoggerUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoggerUpdateContract struct.
func (luc *LoggerUpdateContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loggerUpdateParameters LoggerUpdateParameters
				err = json.Unmarshal(*v, &loggerUpdateParameters)
				if err != nil {
					return err
				}
				luc.LoggerUpdateParameters = &loggerUpdateParameters
			}
		}
	}

	return nil
}

// LoggerUpdateParameters parameters supplied to the Update Logger operation.
type LoggerUpdateParameters struct {
	// LoggerType - Logger type. Possible values include: 'AzureEventHub', 'ApplicationInsights'
	LoggerType LoggerType `json:"loggerType,omitempty"`
	// Description - Logger description.
	Description *string `json:"description,omitempty"`
	// Credentials - Logger credentials.
	Credentials map[string]*string `json:"credentials"`
	// IsBuffered - Whether records are buffered in the logger before publishing. Default is assumed to be true.
	IsBuffered *bool `json:"isBuffered,omitempty"`
}

// MarshalJSON is the custom marshaler for LoggerUpdateParameters.
func (lup LoggerUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lup.LoggerType != "" {
		objectMap["loggerType"] = lup.LoggerType
	}
	if lup.Description != nil {
		objectMap["description"] = lup.Description
	}
	if lup.Credentials != nil {
		objectMap["credentials"] = lup.Credentials
	}
	if lup.IsBuffered != nil {
		objectMap["isBuffered"] = lup.IsBuffered
	}
	return json.Marshal(objectMap)
}

// NetworkStatusContract network Status details.
type NetworkStatusContract struct {
	autorest.Response `json:"-"`
	// DNSServers - Gets the list of DNS servers IPV4 addresses.
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// ConnectivityStatus - Gets the list of Connectivity Status to the Resources on which the service depends upon.
	ConnectivityStatus *[]ConnectivityStatusContract `json:"connectivityStatus,omitempty"`
}

// NetworkStatusContractByLocation network Status in the Location
type NetworkStatusContractByLocation struct {
	// Location - Location of service
	Location *string `json:"location,omitempty"`
	// NetworkStatus - Network status in Location
	NetworkStatus *NetworkStatusContract `json:"networkStatus,omitempty"`
}

// NotificationCollection paged Notification list representation.
type NotificationCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]NotificationContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// NotificationCollectionIterator provides access to a complete listing of NotificationContract values.
type NotificationCollectionIterator struct {
	i    int
	page NotificationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NotificationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NotificationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NotificationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NotificationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NotificationCollectionIterator) Response() NotificationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NotificationCollectionIterator) Value() NotificationContract {
	if !iter.page.NotDone() {
		return NotificationContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NotificationCollectionIterator type.
func NewNotificationCollectionIterator(page NotificationCollectionPage) NotificationCollectionIterator {
	return NotificationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nc NotificationCollection) IsEmpty() bool {
	return nc.Value == nil || len(*nc.Value) == 0
}

// notificationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nc NotificationCollection) notificationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if nc.NextLink == nil || len(to.String(nc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nc.NextLink)))
}

// NotificationCollectionPage contains a page of NotificationContract values.
type NotificationCollectionPage struct {
	fn func(context.Context, NotificationCollection) (NotificationCollection, error)
	nc NotificationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NotificationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NotificationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.nc)
	if err != nil {
		return err
	}
	page.nc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NotificationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NotificationCollectionPage) NotDone() bool {
	return !page.nc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NotificationCollectionPage) Response() NotificationCollection {
	return page.nc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NotificationCollectionPage) Values() []NotificationContract {
	if page.nc.IsEmpty() {
		return nil
	}
	return *page.nc.Value
}

// Creates a new instance of the NotificationCollectionPage type.
func NewNotificationCollectionPage(getNextPage func(context.Context, NotificationCollection) (NotificationCollection, error)) NotificationCollectionPage {
	return NotificationCollectionPage{fn: getNextPage}
}

// NotificationContract notification details.
type NotificationContract struct {
	autorest.Response `json:"-"`
	// NotificationContractProperties - Notification entity contract properties.
	*NotificationContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NotificationContract.
func (nc NotificationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nc.NotificationContractProperties != nil {
		objectMap["properties"] = nc.NotificationContractProperties
	}
	if nc.ID != nil {
		objectMap["id"] = nc.ID
	}
	if nc.Name != nil {
		objectMap["name"] = nc.Name
	}
	if nc.Type != nil {
		objectMap["type"] = nc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NotificationContract struct.
func (nc *NotificationContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var notificationContractProperties NotificationContractProperties
				err = json.Unmarshal(*v, &notificationContractProperties)
				if err != nil {
					return err
				}
				nc.NotificationContractProperties = &notificationContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nc.Type = &typeVar
			}
		}
	}

	return nil
}

// NotificationContractProperties notification Contract properties.
type NotificationContractProperties struct {
	// Title - Title of the Notification.
	Title *string `json:"title,omitempty"`
	// Description - Description of the Notification.
	Description *string `json:"description,omitempty"`
	// Recipients - Recipient Parameter values.
	Recipients *RecipientsContractProperties `json:"recipients,omitempty"`
}

// OAuth2AuthenticationSettingsContract API OAuth2 Authentication settings details.
type OAuth2AuthenticationSettingsContract struct {
	// AuthorizationServerID - OAuth authorization server identifier.
	AuthorizationServerID *string `json:"authorizationServerId,omitempty"`
	// Scope - operations scope.
	Scope *string `json:"scope,omitempty"`
}

// OpenIDAuthenticationSettingsContract API OAuth2 Authentication settings details.
type OpenIDAuthenticationSettingsContract struct {
	// OpenidProviderID - OAuth authorization server identifier.
	OpenidProviderID *string `json:"openidProviderId,omitempty"`
	// BearerTokenSendingMethods - How to send token to the server.
	BearerTokenSendingMethods *[]BearerTokenSendingMethods `json:"bearerTokenSendingMethods,omitempty"`
}

// OpenIDConnectProviderCollection paged OpenIdProviders list representation.
type OpenIDConnectProviderCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]OpenidConnectProviderContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OpenIDConnectProviderCollectionIterator provides access to a complete listing of
// OpenidConnectProviderContract values.
type OpenIDConnectProviderCollectionIterator struct {
	i    int
	page OpenIDConnectProviderCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OpenIDConnectProviderCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OpenIDConnectProviderCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OpenIDConnectProviderCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OpenIDConnectProviderCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OpenIDConnectProviderCollectionIterator) Response() OpenIDConnectProviderCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OpenIDConnectProviderCollectionIterator) Value() OpenidConnectProviderContract {
	if !iter.page.NotDone() {
		return OpenidConnectProviderContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OpenIDConnectProviderCollectionIterator type.
func NewOpenIDConnectProviderCollectionIterator(page OpenIDConnectProviderCollectionPage) OpenIDConnectProviderCollectionIterator {
	return OpenIDConnectProviderCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oicpc OpenIDConnectProviderCollection) IsEmpty() bool {
	return oicpc.Value == nil || len(*oicpc.Value) == 0
}

// openIDConnectProviderCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oicpc OpenIDConnectProviderCollection) openIDConnectProviderCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if oicpc.NextLink == nil || len(to.String(oicpc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oicpc.NextLink)))
}

// OpenIDConnectProviderCollectionPage contains a page of OpenidConnectProviderContract values.
type OpenIDConnectProviderCollectionPage struct {
	fn    func(context.Context, OpenIDConnectProviderCollection) (OpenIDConnectProviderCollection, error)
	oicpc OpenIDConnectProviderCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OpenIDConnectProviderCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OpenIDConnectProviderCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.oicpc)
	if err != nil {
		return err
	}
	page.oicpc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OpenIDConnectProviderCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OpenIDConnectProviderCollectionPage) NotDone() bool {
	return !page.oicpc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OpenIDConnectProviderCollectionPage) Response() OpenIDConnectProviderCollection {
	return page.oicpc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OpenIDConnectProviderCollectionPage) Values() []OpenidConnectProviderContract {
	if page.oicpc.IsEmpty() {
		return nil
	}
	return *page.oicpc.Value
}

// Creates a new instance of the OpenIDConnectProviderCollectionPage type.
func NewOpenIDConnectProviderCollectionPage(getNextPage func(context.Context, OpenIDConnectProviderCollection) (OpenIDConnectProviderCollection, error)) OpenIDConnectProviderCollectionPage {
	return OpenIDConnectProviderCollectionPage{fn: getNextPage}
}

// OpenidConnectProviderContract openId Connect Provider details.
type OpenidConnectProviderContract struct {
	autorest.Response `json:"-"`
	// OpenidConnectProviderContractProperties - OpenId Connect Provider contract properties.
	*OpenidConnectProviderContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OpenidConnectProviderContract.
func (ocpc OpenidConnectProviderContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ocpc.OpenidConnectProviderContractProperties != nil {
		objectMap["properties"] = ocpc.OpenidConnectProviderContractProperties
	}
	if ocpc.ID != nil {
		objectMap["id"] = ocpc.ID
	}
	if ocpc.Name != nil {
		objectMap["name"] = ocpc.Name
	}
	if ocpc.Type != nil {
		objectMap["type"] = ocpc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OpenidConnectProviderContract struct.
func (ocpc *OpenidConnectProviderContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var openidConnectProviderContractProperties OpenidConnectProviderContractProperties
				err = json.Unmarshal(*v, &openidConnectProviderContractProperties)
				if err != nil {
					return err
				}
				ocpc.OpenidConnectProviderContractProperties = &openidConnectProviderContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ocpc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ocpc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ocpc.Type = &typeVar
			}
		}
	}

	return nil
}

// OpenidConnectProviderContractProperties openID Connect Providers Contract.
type OpenidConnectProviderContractProperties struct {
	// DisplayName - User-friendly OpenID Connect Provider name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// OpenidConnectProviderUpdateContract parameters supplied to the Update OpenID Connect Provider operation.
type OpenidConnectProviderUpdateContract struct {
	// OpenidConnectProviderUpdateContractProperties - OpenId Connect Provider Update contract properties.
	*OpenidConnectProviderUpdateContractProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OpenidConnectProviderUpdateContract.
func (ocpuc OpenidConnectProviderUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ocpuc.OpenidConnectProviderUpdateContractProperties != nil {
		objectMap["properties"] = ocpuc.OpenidConnectProviderUpdateContractProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OpenidConnectProviderUpdateContract struct.
func (ocpuc *OpenidConnectProviderUpdateContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var openidConnectProviderUpdateContractProperties OpenidConnectProviderUpdateContractProperties
				err = json.Unmarshal(*v, &openidConnectProviderUpdateContractProperties)
				if err != nil {
					return err
				}
				ocpuc.OpenidConnectProviderUpdateContractProperties = &openidConnectProviderUpdateContractProperties
			}
		}
	}

	return nil
}

// OpenidConnectProviderUpdateContractProperties parameters supplied to the Update OpenID Connect Provider
// operation.
type OpenidConnectProviderUpdateContractProperties struct {
	// DisplayName - User-friendly OpenID Connect Provider name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - User-friendly description of OpenID Connect Provider.
	Description *string `json:"description,omitempty"`
	// MetadataEndpoint - Metadata endpoint URI.
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	// ClientID - Client ID of developer console which is the client application.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client Secret of developer console which is the client application.
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The operation origin.
	Origin *string `json:"origin,omitempty"`
	// Properties - The operation properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationCollection paged Operation list representation.
type OperationCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]OperationContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationCollectionIterator provides access to a complete listing of OperationContract values.
type OperationCollectionIterator struct {
	i    int
	page OperationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationCollectionIterator) Response() OperationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationCollectionIterator) Value() OperationContract {
	if !iter.page.NotDone() {
		return OperationContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationCollectionIterator type.
func NewOperationCollectionIterator(page OperationCollectionPage) OperationCollectionIterator {
	return OperationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oc OperationCollection) IsEmpty() bool {
	return oc.Value == nil || len(*oc.Value) == 0
}

// operationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oc OperationCollection) operationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if oc.NextLink == nil || len(to.String(oc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oc.NextLink)))
}

// OperationCollectionPage contains a page of OperationContract values.
type OperationCollectionPage struct {
	fn func(context.Context, OperationCollection) (OperationCollection, error)
	oc OperationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.oc)
	if err != nil {
		return err
	}
	page.oc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationCollectionPage) NotDone() bool {
	return !page.oc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationCollectionPage) Response() OperationCollection {
	return page.oc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationCollectionPage) Values() []OperationContract {
	if page.oc.IsEmpty() {
		return nil
	}
	return *page.oc.Value
}

// Creates a new instance of the OperationCollectionPage type.
func NewOperationCollectionPage(getNextPage func(context.Context, OperationCollection) (OperationCollection, error)) OperationCollectionPage {
	return OperationCollectionPage{fn: getNextPage}
}

// OperationContract api Operation details.
type OperationContract struct {
	autorest.Response `json:"-"`
	// OperationContractProperties - Properties of the Operation Contract.
	*OperationContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationContract.
func (oc OperationContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oc.OperationContractProperties != nil {
		objectMap["properties"] = oc.OperationContractProperties
	}
	if oc.ID != nil {
		objectMap["id"] = oc.ID
	}
	if oc.Name != nil {
		objectMap["name"] = oc.Name
	}
	if oc.Type != nil {
		objectMap["type"] = oc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationContract struct.
func (oc *OperationContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var operationContractProperties OperationContractProperties
				err = json.Unmarshal(*v, &operationContractProperties)
				if err != nil {
					return err
				}
				oc.OperationContractProperties = &operationContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oc.Type = &typeVar
			}
		}
	}

	return nil
}

// OperationContractProperties operation Contract Properties
type OperationContractProperties struct {
	// DisplayName - Operation Name.
	DisplayName *string `json:"displayName,omitempty"`
	// Method - A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`
	// URLTemplate - Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResponseContract `json:"responses,omitempty"`
	// Policies - Operation Policies
	Policies *string `json:"policies,omitempty"`
}

// OperationDisplay the object that describes the operation.
type OperationDisplay struct {
	// Provider - Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`
	// Operation - Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`
	// Resource - Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Description - Friendly name of the operation
	Description *string `json:"description,omitempty"`
}

// OperationEntityBaseContract api Operation Entity Base Contract details.
type OperationEntityBaseContract struct {
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResponseContract `json:"responses,omitempty"`
	// Policies - Operation Policies
	Policies *string `json:"policies,omitempty"`
}

// OperationListResult result of the request to list REST API operations. It contains a list of operations
// and a URL nextLink to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// OperationResultContract operation Result.
type OperationResultContract struct {
	autorest.Response `json:"-"`
	// ID - Operation result identifier.
	ID *string `json:"id,omitempty"`
	// Status - Status of an async operation. Possible values include: 'Started', 'InProgress', 'Succeeded', 'Failed'
	Status AsyncOperationStatus `json:"status,omitempty"`
	// Started - Start time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Started *date.Time `json:"started,omitempty"`
	// Updated - Last update time of an async operation. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Updated *date.Time `json:"updated,omitempty"`
	// ResultInfo - Optional result info.
	ResultInfo *string `json:"resultInfo,omitempty"`
	// Error - Error Body Contract
	Error *ErrorResponseBody `json:"error,omitempty"`
	// ActionLog - This property if only provided as part of the TenantConfiguration_Validate operation. It contains the log the entities which will be updated/created/deleted as part of the TenantConfiguration_Deploy operation.
	ActionLog *[]OperationResultLogItemContract `json:"actionLog,omitempty"`
}

// OperationResultLogItemContract log of the entity being created, updated or deleted.
type OperationResultLogItemContract struct {
	// ObjectType - The type of entity contract.
	ObjectType *string `json:"objectType,omitempty"`
	// Action - Action like create/update/delete.
	Action *string `json:"action,omitempty"`
	// ObjectKey - Identifier of the entity being created/updated/deleted.
	ObjectKey *string `json:"objectKey,omitempty"`
}

// OperationTagResourceContractProperties operation Entity contract Properties.
type OperationTagResourceContractProperties struct {
	// ID - Identifier of the operation in form /operations/{operationId}.
	ID *string `json:"id,omitempty"`
	// Name - Operation name.
	Name *string `json:"name,omitempty"`
	// APIName - Api Name.
	APIName *string `json:"apiName,omitempty"`
	// APIRevision - Api Revision.
	APIRevision *string `json:"apiRevision,omitempty"`
	// APIVersion - Api Version.
	APIVersion *string `json:"apiVersion,omitempty"`
	// Description - Operation Description.
	Description *string `json:"description,omitempty"`
	// Method - A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`
	// URLTemplate - Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`
}

// OperationUpdateContract api Operation Update Contract details.
type OperationUpdateContract struct {
	// OperationUpdateContractProperties - Properties of the API Operation entity that can be updated.
	*OperationUpdateContractProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationUpdateContract.
func (ouc OperationUpdateContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ouc.OperationUpdateContractProperties != nil {
		objectMap["properties"] = ouc.OperationUpdateContractProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationUpdateContract struct.
func (ouc *OperationUpdateContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var operationUpdateContractProperties OperationUpdateContractProperties
				err = json.Unmarshal(*v, &operationUpdateContractProperties)
				if err != nil {
					return err
				}
				ouc.OperationUpdateContractProperties = &operationUpdateContractProperties
			}
		}
	}

	return nil
}

// OperationUpdateContractProperties operation Update Contract Properties.
type OperationUpdateContractProperties struct {
	// DisplayName - Operation Name.
	DisplayName *string `json:"displayName,omitempty"`
	// Method - A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
	Method *string `json:"method,omitempty"`
	// URLTemplate - Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
	URLTemplate *string `json:"urlTemplate,omitempty"`
	// TemplateParameters - Collection of URL template parameters.
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	// Description - Description of the operation. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Request - An entity containing request details.
	Request *RequestContract `json:"request,omitempty"`
	// Responses - Array of Operation responses.
	Responses *[]ResponseContract `json:"responses,omitempty"`
	// Policies - Operation Policies
	Policies *string `json:"policies,omitempty"`
}

// ParameterContract operation parameters details.
type ParameterContract struct {
	// Name - Parameter name.
	Name *string `json:"name,omitempty"`
	// Description - Parameter description.
	Description *string `json:"description,omitempty"`
	// Type - Parameter type.
	Type *string `json:"type,omitempty"`
	// DefaultValue - Default parameter value.
	DefaultValue *string `json:"defaultValue,omitempty"`
	// Required - whether parameter is required or not.
	Required *bool `json:"required,omitempty"`
	// Values - Parameter values.
	Values *[]string `json:"values,omitempty"`
}

// PolicyCollection the response of the list policy operation.
type PolicyCollection struct {
	autorest.Response `json:"-"`
	// Value - Policy Contract value.
	Value *[]PolicyContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// PolicyContract policy Contract details.
type PolicyContract struct {
	autorest.Response `json:"-"`
	// PolicyContractProperties - Properties of the Policy.
	*PolicyContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PolicyContract.
func (pc PolicyContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.PolicyContractProperties != nil {
		objectMap["properties"] = pc.PolicyContractProperties
	}
	if pc.ID != nil {
		objectMap["id"] = pc.ID
	}
	if pc.Name != nil {
		objectMap["name"] = pc.Name
	}
	if pc.Type != nil {
		objectMap["type"] = pc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PolicyContract struct.
func (pc *PolicyContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyContractProperties PolicyContractProperties
				err = json.Unmarshal(*v, &policyContractProperties)
				if err != nil {
					return err
				}
				pc.PolicyContractProperties = &policyContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pc.Type = &typeVar
			}
		}
	}

	return nil
}

// PolicyContractProperties policy contract Properties.
type PolicyContractProperties struct {
	// PolicyContent - Json escaped Xml Encoded contents of the Policy.
	PolicyContent *string `json:"policyContent,omitempty"`
	// ContentFormat - Format of the policyContent. Possible values include: 'XML', 'XMLLink', 'Rawxml', 'RawxmlLink'
	ContentFormat PolicyContentFormat `json:"contentFormat,omitempty"`
}

// PolicySnippetContract policy snippet.
type PolicySnippetContract struct {
	// Name - Snippet name.
	Name *string `json:"name,omitempty"`
	// Content - Snippet content.
	Content *string `json:"content,omitempty"`
	// ToolTip - Snippet toolTip.
	ToolTip *string `json:"toolTip,omitempty"`
	// Scope - Binary OR value of the Snippet scope.
	Scope *int32 `json:"scope,omitempty"`
}

// PolicySnippetsCollection the response of the list policy snippets operation.
type PolicySnippetsCollection struct {
	autorest.Response `json:"-"`
	// Value - Policy snippet value.
	Value *[]PolicySnippetContract `json:"value,omitempty"`
}

// PortalDelegationSettings delegation settings for a developer portal.
type PortalDelegationSettings struct {
	autorest.Response `json:"-"`
	// PortalDelegationSettingsProperties - Delegation settings contract properties.
	*PortalDelegationSettingsProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PortalDelegationSettings.
func (pds PortalDelegationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pds.PortalDelegationSettingsProperties != nil {
		objectMap["properties"] = pds.PortalDelegationSettingsProperties
	}
	if pds.ID != nil {
		objectMap["id"] = pds.ID
	}
	if pds.Name != nil {
		objectMap["name"] = pds.Name
	}
	if pds.Type != nil {
		objectMap["type"] = pds.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PortalDelegationSettings struct.
func (pds *PortalDelegationSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var portalDelegationSettingsProperties PortalDelegationSettingsProperties
				err = json.Unmarshal(*v, &portalDelegationSettingsProperties)
				if err != nil {
					return err
				}
				pds.PortalDelegationSettingsProperties = &portalDelegationSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pds.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pds.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pds.Type = &typeVar
			}
		}
	}

	return nil
}

// PortalDelegationSettingsProperties delegation settings contract properties.
type PortalDelegationSettingsProperties struct {
	// URL - A delegation Url.
	URL *string `json:"url,omitempty"`
	// ValidationKey - A base64-encoded validation key to validate, that a request is coming from Azure API Management.
	ValidationKey *string `json:"validationKey,omitempty"`
	// Subscriptions - Subscriptions delegation settings.
	Subscriptions *SubscriptionsDelegationSettingsProperties `json:"subscriptions,omitempty"`
	// UserRegistration - User registration delegation settings.
	UserRegistration *RegistrationDelegationSettingsProperties `json:"userRegistration,omitempty"`
}

// PortalSigninSettingProperties sign-in settings contract properties.
type PortalSigninSettingProperties struct {
	// Enabled - Redirect Anonymous users to the Sign-In page.
	Enabled *bool `json:"enabled,omitempty"`
}

// PortalSigninSettings sign-In settings for the Developer Portal.
type PortalSigninSettings struct {
	autorest.Response `json:"-"`
	// PortalSigninSettingProperties - Sign-in settings contract properties.
	*PortalSigninSettingProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PortalSigninSettings.
func (pss PortalSigninSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pss.PortalSigninSettingProperties != nil {
		objectMap["properties"] = pss.PortalSigninSettingProperties
	}
	if pss.ID != nil {
		objectMap["id"] = pss.ID
	}
	if pss.Name != nil {
		objectMap["name"] = pss.Name
	}
	if pss.Type != nil {
		objectMap["type"] = pss.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PortalSigninSettings struct.
func (pss *PortalSigninSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var portalSigninSettingProperties PortalSigninSettingProperties
				err = json.Unmarshal(*v, &portalSigninSettingProperties)
				if err != nil {
					return err
				}
				pss.PortalSigninSettingProperties = &portalSigninSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pss.Type = &typeVar
			}
		}
	}

	return nil
}

// PortalSignupSettings sign-Up settings for a developer portal.
type PortalSignupSettings struct {
	autorest.Response `json:"-"`
	// PortalSignupSettingsProperties - Sign-up settings contract properties.
	*PortalSignupSettingsProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PortalSignupSettings.
func (pss PortalSignupSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pss.PortalSignupSettingsProperties != nil {
		objectMap["properties"] = pss.PortalSignupSettingsProperties
	}
	if pss.ID != nil {
		objectMap["id"] = pss.ID
	}
	if pss.Name != nil {
		objectMap["name"] = pss.Name
	}
	if pss.Type != nil {
		objectMap["type"] = pss.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PortalSignupSettings struct.
func (pss *PortalSignupSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var portalSignupSettingsProperties PortalSignupSettingsProperties
				err = json.Unmarshal(*v, &portalSignupSettingsProperties)
				if err != nil {
					return err
				}
				pss.PortalSignupSettingsProperties = &portalSignupSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pss.Type = &typeVar
			}
		}
	}

	return nil
}

// PortalSignupSettingsProperties sign-up settings contract properties.
type PortalSignupSettingsProperties struct {
	// Enabled - Allow users to sign up on a developer portal.
	Enabled *bool `json:"enabled,omitempty"`
	// TermsOfService - Terms of service contract properties.
	TermsOfService *TermsOfServiceProperties `json:"termsOfService,omitempty"`
}

// ProductCollection paged Products list representation.
type ProductCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]ProductContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProductCollectionIterator provides access to a complete listing of ProductContract values.
type ProductCollectionIterator struct {
	i    int
	page ProductCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProductCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProductCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProductCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProductCollectionIterator) Response() ProductCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProductCollectionIterator) Value() ProductContract {
	if !iter.page.NotDone() {
		return ProductContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProductCollectionIterator type.
func NewProductCollectionIterator(page ProductCollectionPage) ProductCollectionIterator {
	return ProductCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pc ProductCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// productCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc ProductCollection) productCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if pc.NextLink == nil || len(to.String(pc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// ProductCollectionPage contains a page of ProductContract values.
type ProductCollectionPage struct {
	fn func(context.Context, ProductCollection) (ProductCollection, error)
	pc ProductCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProductCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pc)
	if err != nil {
		return err
	}
	page.pc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProductCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProductCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProductCollectionPage) Response() ProductCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProductCollectionPage) Values() []ProductContract {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// Creates a new instance of the ProductCollectionPage type.
func NewProductCollectionPage(getNextPage func(context.Context, ProductCollection) (ProductCollection, error)) ProductCollectionPage {
	return ProductCollectionPage{fn: getNextPage}
}

// ProductContract product details.
type ProductContract struct {
	autorest.Response `json:"-"`
	// ProductContractProperties - Product entity contract properties.
	*ProductContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductContract.
func (pc ProductContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.ProductContractProperties != nil {
		objectMap["properties"] = pc.ProductContractProperties
	}
	if pc.ID != nil {
		objectMap["id"] = pc.ID
	}
	if pc.Name != nil {
		objectMap["name"] = pc.Name
	}
	if pc.Type != nil {
		objectMap["type"] = pc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProductContract struct.
func (pc *ProductContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var productContractProperties ProductContractProperties
				err = json.Unmarshal(*v, &productContractProperties)
				if err != nil {
					return err
				}
				pc.ProductContractProperties = &productContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pc.Type = &typeVar
			}
		}
	}

	return nil
}

// ProductContractProperties product profile.
type ProductContractProperties struct {
	// DisplayName - Product name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished. Possible values include: 'NotPublished', 'Published'
	State ProductState `json:"state,omitempty"`
}

// ProductEntityBaseParameters product Entity Base Parameters
type ProductEntityBaseParameters struct {
	// Description - Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished. Possible values include: 'NotPublished', 'Published'
	State ProductState `json:"state,omitempty"`
}

// ProductTagResourceContractProperties product profile.
type ProductTagResourceContractProperties struct {
	// ID - Identifier of the product in the form of /products/{productId}
	ID *string `json:"id,omitempty"`
	// Name - Product name.
	Name *string `json:"name,omitempty"`
	// Description - Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished. Possible values include: 'NotPublished', 'Published'
	State ProductState `json:"state,omitempty"`
}

// ProductUpdateParameters product Update parameters.
type ProductUpdateParameters struct {
	// ProductUpdateProperties - Product entity Update contract properties.
	*ProductUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductUpdateParameters.
func (pup ProductUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pup.ProductUpdateProperties != nil {
		objectMap["properties"] = pup.ProductUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProductUpdateParameters struct.
func (pup *ProductUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var productUpdateProperties ProductUpdateProperties
				err = json.Unmarshal(*v, &productUpdateProperties)
				if err != nil {
					return err
				}
				pup.ProductUpdateProperties = &productUpdateProperties
			}
		}
	}

	return nil
}

// ProductUpdateProperties parameters supplied to the Update Product operation.
type ProductUpdateProperties struct {
	// DisplayName - Product name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Product description. May include HTML formatting tags.
	Description *string `json:"description,omitempty"`
	// Terms - Product terms of use. Developers trying to subscribe to the product will be presented and required to accept these terms before they can complete the subscription process.
	Terms *string `json:"terms,omitempty"`
	// SubscriptionRequired - Whether a product subscription is required for accessing APIs included in this product. If true, the product is referred to as "protected" and a valid subscription key is required for a request to an API included in the product to succeed. If false, the product is referred to as "open" and requests to an API included in the product can be made without a subscription key. If property is omitted when creating a new product it's value is assumed to be true.
	SubscriptionRequired *bool `json:"subscriptionRequired,omitempty"`
	// ApprovalRequired - whether subscription approval is required. If false, new subscriptions will be approved automatically enabling developers to call the product’s APIs immediately after subscribing. If true, administrators must manually approve the subscription before the developer can any of the product’s APIs. Can be present only if subscriptionRequired property is present and has a value of false.
	ApprovalRequired *bool `json:"approvalRequired,omitempty"`
	// SubscriptionsLimit - Whether the number of subscriptions a user can have to this product at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present only if subscriptionRequired property is present and has a value of false.
	SubscriptionsLimit *int32 `json:"subscriptionsLimit,omitempty"`
	// State - whether product is published or not. Published products are discoverable by users of developer portal. Non published products are visible only to administrators. Default state of Product is notPublished. Possible values include: 'NotPublished', 'Published'
	State ProductState `json:"state,omitempty"`
}

// PropertyCollection paged Property list representation.
type PropertyCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]PropertyContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// PropertyCollectionIterator provides access to a complete listing of PropertyContract values.
type PropertyCollectionIterator struct {
	i    int
	page PropertyCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PropertyCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PropertyCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PropertyCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PropertyCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PropertyCollectionIterator) Response() PropertyCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PropertyCollectionIterator) Value() PropertyContract {
	if !iter.page.NotDone() {
		return PropertyContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PropertyCollectionIterator type.
func NewPropertyCollectionIterator(page PropertyCollectionPage) PropertyCollectionIterator {
	return PropertyCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pc PropertyCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// propertyCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc PropertyCollection) propertyCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if pc.NextLink == nil || len(to.String(pc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// PropertyCollectionPage contains a page of PropertyContract values.
type PropertyCollectionPage struct {
	fn func(context.Context, PropertyCollection) (PropertyCollection, error)
	pc PropertyCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PropertyCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PropertyCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pc)
	if err != nil {
		return err
	}
	page.pc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PropertyCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PropertyCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PropertyCollectionPage) Response() PropertyCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PropertyCollectionPage) Values() []PropertyContract {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// Creates a new instance of the PropertyCollectionPage type.
func NewPropertyCollectionPage(getNextPage func(context.Context, PropertyCollection) (PropertyCollection, error)) PropertyCollectionPage {
	return PropertyCollectionPage{fn: getNextPage}
}

// PropertyContract property details.
type PropertyContract struct {
	autorest.Response `json:"-"`
	// PropertyContractProperties - Property entity contract properties.
	*PropertyContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PropertyContract.
func (pc PropertyContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.PropertyContractProperties != nil {
		objectMap["properties"] = pc.PropertyContractProperties
	}
	if pc.ID != nil {
		objectMap["id"] = pc.ID
	}
	if pc.Name != nil {
		objectMap["name"] = pc.Name
	}
	if pc.Type != nil {
		objectMap["type"] = pc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PropertyContract struct.
func (pc *PropertyContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var propertyContractProperties PropertyContractProperties
				err = json.Unmarshal(*v, &propertyContractProperties)
				if err != nil {
					return err
				}
				pc.PropertyContractProperties = &propertyContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pc.Type = &typeVar
			}
		}
	}

	return nil
}

// PropertyContractProperties property Contract properties.
type PropertyContractProperties struct {
	// DisplayName - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	DisplayName *string `json:"displayName,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// PropertyEntityBaseParameters property Entity Base Parameters set.
type PropertyEntityBaseParameters struct {
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// PropertyUpdateParameterProperties property Contract properties.
type PropertyUpdateParameterProperties struct {
	// DisplayName - Unique name of Property. It may contain only letters, digits, period, dash, and underscore characters.
	DisplayName *string `json:"displayName,omitempty"`
	// Value - Value of the property. Can contain policy expressions. It may not be empty or consist only of whitespace.
	Value *string `json:"value,omitempty"`
	// Tags - Optional tags that when provided can be used to filter the property list.
	Tags *[]string `json:"tags,omitempty"`
	// Secret - Determines whether the value is a secret and should be encrypted or not. Default value is false.
	Secret *bool `json:"secret,omitempty"`
}

// PropertyUpdateParameters property update Parameters.
type PropertyUpdateParameters struct {
	// PropertyUpdateParameterProperties - Property entity Update contract properties.
	*PropertyUpdateParameterProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PropertyUpdateParameters.
func (pup PropertyUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pup.PropertyUpdateParameterProperties != nil {
		objectMap["properties"] = pup.PropertyUpdateParameterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PropertyUpdateParameters struct.
func (pup *PropertyUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var propertyUpdateParameterProperties PropertyUpdateParameterProperties
				err = json.Unmarshal(*v, &propertyUpdateParameterProperties)
				if err != nil {
					return err
				}
				pup.PropertyUpdateParameterProperties = &propertyUpdateParameterProperties
			}
		}
	}

	return nil
}

// QuotaCounterCollection paged Quota Counter list representation.
type QuotaCounterCollection struct {
	autorest.Response `json:"-"`
	// Value - Quota counter values.
	Value *[]QuotaCounterContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// QuotaCounterContract quota counter details.
type QuotaCounterContract struct {
	autorest.Response `json:"-"`
	// CounterKey - The Key value of the Counter. Must not be empty.
	CounterKey *string `json:"counterKey,omitempty"`
	// PeriodKey - Identifier of the Period for which the counter was collected. Must not be empty.
	PeriodKey *string `json:"periodKey,omitempty"`
	// PeriodStartTime - The date of the start of Counter Period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	PeriodStartTime *date.Time `json:"periodStartTime,omitempty"`
	// PeriodEndTime - The date of the end of Counter Period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	PeriodEndTime *date.Time `json:"periodEndTime,omitempty"`
	// Value - Quota Value Properties
	Value *QuotaCounterValueContractProperties `json:"value,omitempty"`
}

// QuotaCounterValueContract quota counter value details.
type QuotaCounterValueContract struct {
	// QuotaCounterValueContractProperties - Quota counter Value Properties.
	*QuotaCounterValueContractProperties `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for QuotaCounterValueContract.
func (qcvc QuotaCounterValueContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qcvc.QuotaCounterValueContractProperties != nil {
		objectMap["value"] = qcvc.QuotaCounterValueContractProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QuotaCounterValueContract struct.
func (qcvc *QuotaCounterValueContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				var quotaCounterValueContractProperties QuotaCounterValueContractProperties
				err = json.Unmarshal(*v, &quotaCounterValueContractProperties)
				if err != nil {
					return err
				}
				qcvc.QuotaCounterValueContractProperties = &quotaCounterValueContractProperties
			}
		}
	}

	return nil
}

// QuotaCounterValueContractProperties quota counter value details.
type QuotaCounterValueContractProperties struct {
	// CallsCount - Number of times Counter was called.
	CallsCount *int32 `json:"callsCount,omitempty"`
	// KbTransferred - Data Transferred in KiloBytes.
	KbTransferred *float64 `json:"kbTransferred,omitempty"`
}

// RecipientEmailCollection paged Recipient User list representation.
type RecipientEmailCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]RecipientEmailContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecipientEmailContract recipient Email details.
type RecipientEmailContract struct {
	autorest.Response `json:"-"`
	// RecipientEmailContractProperties - Recipient Email contract properties.
	*RecipientEmailContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecipientEmailContract.
func (rec RecipientEmailContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rec.RecipientEmailContractProperties != nil {
		objectMap["properties"] = rec.RecipientEmailContractProperties
	}
	if rec.ID != nil {
		objectMap["id"] = rec.ID
	}
	if rec.Name != nil {
		objectMap["name"] = rec.Name
	}
	if rec.Type != nil {
		objectMap["type"] = rec.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecipientEmailContract struct.
func (rec *RecipientEmailContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recipientEmailContractProperties RecipientEmailContractProperties
				err = json.Unmarshal(*v, &recipientEmailContractProperties)
				if err != nil {
					return err
				}
				rec.RecipientEmailContractProperties = &recipientEmailContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rec.Type = &typeVar
			}
		}
	}

	return nil
}

// RecipientEmailContractProperties recipient Email Contract Properties.
type RecipientEmailContractProperties struct {
	// Email - User Email subscribed to notification.
	Email *string `json:"email,omitempty"`
}

// RecipientsContractProperties notification Parameter contract.
type RecipientsContractProperties struct {
	// Emails - List of Emails subscribed for the notification.
	Emails *[]string `json:"emails,omitempty"`
	// Users - List of Users subscribed for the notification.
	Users *[]string `json:"users,omitempty"`
}

// RecipientUserCollection paged Recipient User list representation.
type RecipientUserCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]RecipientUserContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecipientUserContract recipient User details.
type RecipientUserContract struct {
	autorest.Response `json:"-"`
	// RecipientUsersContractProperties - Recipient User entity contract properties.
	*RecipientUsersContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecipientUserContract.
func (ruc RecipientUserContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ruc.RecipientUsersContractProperties != nil {
		objectMap["properties"] = ruc.RecipientUsersContractProperties
	}
	if ruc.ID != nil {
		objectMap["id"] = ruc.ID
	}
	if ruc.Name != nil {
		objectMap["name"] = ruc.Name
	}
	if ruc.Type != nil {
		objectMap["type"] = ruc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecipientUserContract struct.
func (ruc *RecipientUserContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recipientUsersContractProperties RecipientUsersContractProperties
				err = json.Unmarshal(*v, &recipientUsersContractProperties)
				if err != nil {
					return err
				}
				ruc.RecipientUsersContractProperties = &recipientUsersContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ruc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ruc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ruc.Type = &typeVar
			}
		}
	}

	return nil
}

// RecipientUsersContractProperties recipient User Contract Properties.
type RecipientUsersContractProperties struct {
	// UserID - API Management UserId subscribed to notification.
	UserID *string `json:"userId,omitempty"`
}

// RegionContract region profile.
type RegionContract struct {
	// Name - Region name.
	Name *string `json:"name,omitempty"`
	// IsMasterRegion - whether Region is the master region.
	IsMasterRegion *bool `json:"isMasterRegion,omitempty"`
	// IsDeleted - whether Region is deleted.
	IsDeleted *bool `json:"isDeleted,omitempty"`
}

// RegionListResult lists Regions operation response details.
type RegionListResult struct {
	autorest.Response `json:"-"`
	// Value - Lists of Regions.
	Value *[]RegionContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegionListResultIterator provides access to a complete listing of RegionContract values.
type RegionListResultIterator struct {
	i    int
	page RegionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegionListResultIterator) Response() RegionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegionListResultIterator) Value() RegionContract {
	if !iter.page.NotDone() {
		return RegionContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegionListResultIterator type.
func NewRegionListResultIterator(page RegionListResultPage) RegionListResultIterator {
	return RegionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RegionListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// regionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RegionListResult) regionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rlr.NextLink == nil || len(to.String(rlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RegionListResultPage contains a page of RegionContract values.
type RegionListResultPage struct {
	fn  func(context.Context, RegionListResult) (RegionListResult, error)
	rlr RegionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rlr)
	if err != nil {
		return err
	}
	page.rlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegionListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegionListResultPage) Response() RegionListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegionListResultPage) Values() []RegionContract {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RegionListResultPage type.
func NewRegionListResultPage(getNextPage func(context.Context, RegionListResult) (RegionListResult, error)) RegionListResultPage {
	return RegionListResultPage{fn: getNextPage}
}

// RegistrationDelegationSettingsProperties user registration delegation settings properties.
type RegistrationDelegationSettingsProperties struct {
	// Enabled - Enable or disable delegation for user registration.
	Enabled *bool `json:"enabled,omitempty"`
}

// ReportCollection paged Report records list representation.
type ReportCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]ReportRecordContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReportCollectionIterator provides access to a complete listing of ReportRecordContract values.
type ReportCollectionIterator struct {
	i    int
	page ReportCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReportCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReportCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReportCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReportCollectionIterator) Response() ReportCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReportCollectionIterator) Value() ReportRecordContract {
	if !iter.page.NotDone() {
		return ReportRecordContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReportCollectionIterator type.
func NewReportCollectionIterator(page ReportCollectionPage) ReportCollectionIterator {
	return ReportCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rc ReportCollection) IsEmpty() bool {
	return rc.Value == nil || len(*rc.Value) == 0
}

// reportCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rc ReportCollection) reportCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if rc.NextLink == nil || len(to.String(rc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rc.NextLink)))
}

// ReportCollectionPage contains a page of ReportRecordContract values.
type ReportCollectionPage struct {
	fn func(context.Context, ReportCollection) (ReportCollection, error)
	rc ReportCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReportCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReportCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rc)
	if err != nil {
		return err
	}
	page.rc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReportCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReportCollectionPage) NotDone() bool {
	return !page.rc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReportCollectionPage) Response() ReportCollection {
	return page.rc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReportCollectionPage) Values() []ReportRecordContract {
	if page.rc.IsEmpty() {
		return nil
	}
	return *page.rc.Value
}

// Creates a new instance of the ReportCollectionPage type.
func NewReportCollectionPage(getNextPage func(context.Context, ReportCollection) (ReportCollection, error)) ReportCollectionPage {
	return ReportCollectionPage{fn: getNextPage}
}

// ReportRecordContract report data.
type ReportRecordContract struct {
	// Name - Name depending on report endpoint specifies product, API, operation or developer name.
	Name *string `json:"name,omitempty"`
	// Timestamp - Start of aggregation period. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Interval - Length of aggregation period.  Interval must be multiple of 15 minutes and may not be zero. The value should be in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).
	Interval *string `json:"interval,omitempty"`
	// Country - Country to which this record data is related.
	Country *string `json:"country,omitempty"`
	// Region - Country region to which this record data is related.
	Region *string `json:"region,omitempty"`
	// Zip - Zip code to which this record data is related.
	Zip *string `json:"zip,omitempty"`
	// UserID - User identifier path. /users/{userId}
	UserID *string `json:"userId,omitempty"`
	// ProductID - Product identifier path. /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// APIID - API identifier path. /apis/{apiId}
	APIID *string `json:"apiId,omitempty"`
	// OperationID - Operation identifier path. /apis/{apiId}/operations/{operationId}
	OperationID *string `json:"operationId,omitempty"`
	// APIRegion - API region identifier.
	APIRegion *string `json:"apiRegion,omitempty"`
	// SubscriptionID - Subscription identifier path. /subscriptions/{subscriptionId}
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// CallCountSuccess - Number of successful calls. This includes calls returning HttpStatusCode <= 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect
	CallCountSuccess *int32 `json:"callCountSuccess,omitempty"`
	// CallCountBlocked - Number of calls blocked due to invalid credentials. This includes calls returning HttpStatusCode.Unauthorized and HttpStatusCode.Forbidden and HttpStatusCode.TooManyRequests
	CallCountBlocked *int32 `json:"callCountBlocked,omitempty"`
	// CallCountFailed - Number of calls failed due to proxy or backend errors. This includes calls returning HttpStatusCode.BadRequest(400) and any Code between HttpStatusCode.InternalServerError (500) and 600
	CallCountFailed *int32 `json:"callCountFailed,omitempty"`
	// CallCountOther - Number of other calls.
	CallCountOther *int32 `json:"callCountOther,omitempty"`
	// CallCountTotal - Total number of calls.
	CallCountTotal *int32 `json:"callCountTotal,omitempty"`
	// Bandwidth - Bandwidth consumed.
	Bandwidth *int64 `json:"bandwidth,omitempty"`
	// CacheHitCount - Number of times when content was served from cache policy.
	CacheHitCount *int32 `json:"cacheHitCount,omitempty"`
	// CacheMissCount - Number of times content was fetched from backend.
	CacheMissCount *int32 `json:"cacheMissCount,omitempty"`
	// APITimeAvg - Average time it took to process request.
	APITimeAvg *float64 `json:"apiTimeAvg,omitempty"`
	// APITimeMin - Minimum time it took to process request.
	APITimeMin *float64 `json:"apiTimeMin,omitempty"`
	// APITimeMax - Maximum time it took to process request.
	APITimeMax *float64 `json:"apiTimeMax,omitempty"`
	// ServiceTimeAvg - Average time it took to process request on backend.
	ServiceTimeAvg *float64 `json:"serviceTimeAvg,omitempty"`
	// ServiceTimeMin - Minimum time it took to process request on backend.
	ServiceTimeMin *float64 `json:"serviceTimeMin,omitempty"`
	// ServiceTimeMax - Maximum time it took to process request on backend.
	ServiceTimeMax *float64 `json:"serviceTimeMax,omitempty"`
}

// RepresentationContract operation request/response representation details.
type RepresentationContract struct {
	// ContentType - Specifies a registered or custom content type for this representation, e.g. application/xml.
	ContentType *string `json:"contentType,omitempty"`
	// Sample - An example of the representation.
	Sample *string `json:"sample,omitempty"`
	// SchemaID - Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
	SchemaID *string `json:"schemaId,omitempty"`
	// TypeName - Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
	TypeName *string `json:"typeName,omitempty"`
	// FormParameters - Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
	FormParameters *[]ParameterContract `json:"formParameters,omitempty"`
}

// RequestContract operation request details.
type RequestContract struct {
	// Description - Operation request description.
	Description *string `json:"description,omitempty"`
	// QueryParameters - Collection of operation request query parameters.
	QueryParameters *[]ParameterContract `json:"queryParameters,omitempty"`
	// Headers - Collection of operation request headers.
	Headers *[]ParameterContract `json:"headers,omitempty"`
	// Representations - Collection of operation request representations.
	Representations *[]RepresentationContract `json:"representations,omitempty"`
}

// RequestReportCollection paged Report records list representation.
type RequestReportCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]RequestReportRecordContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
}

// RequestReportRecordContract request Report data.
type RequestReportRecordContract struct {
	// APIID - API identifier path. /apis/{apiId}
	APIID *string `json:"apiId,omitempty"`
	// OperationID - Operation identifier path. /apis/{apiId}/operations/{operationId}
	OperationID *string `json:"operationId,omitempty"`
	// ProductID - Product identifier path. /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// UserID - User identifier path. /users/{userId}
	UserID *string `json:"userId,omitempty"`
	// Method - The HTTP method associated with this request..
	Method *string `json:"method,omitempty"`
	// URL - The full URL associated with this request.
	URL *string `json:"url,omitempty"`
	// IPAddress - The client IP address associated with this request.
	IPAddress *string `json:"ipAddress,omitempty"`
	// BackendResponseCode - The HTTP status code received by the gateway as a result of forwarding this request to the backend.
	BackendResponseCode *string `json:"backendResponseCode,omitempty"`
	// ResponseCode - The HTTP status code returned by the gateway.
	ResponseCode *int32 `json:"responseCode,omitempty"`
	// ResponseSize - The size of the response returned by the gateway.
	ResponseSize *int32 `json:"responseSize,omitempty"`
	// Timestamp - The date and time when this request was received by the gateway in ISO 8601 format.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Cache - Specifies if response cache was involved in generating the response. If the value is none, the cache was not used. If the value is hit, cached response was returned. If the value is miss, the cache was used but lookup resulted in a miss and request was fulfilled by the backend.
	Cache *string `json:"cache,omitempty"`
	// APITime - The total time it took to process this request.
	APITime *float64 `json:"apiTime,omitempty"`
	// ServiceTime - he time it took to forward this request to the backend and get the response back.
	ServiceTime *float64 `json:"serviceTime,omitempty"`
	// APIRegion - Azure region where the gateway that processed this request is located.
	APIRegion *string `json:"apiRegion,omitempty"`
	// SubscriptionID - Subscription identifier path. /subscriptions/{subscriptionId}
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// RequestID - Request Identifier.
	RequestID *string `json:"requestId,omitempty"`
	// RequestSize - The size of this request..
	RequestSize *int32 `json:"requestSize,omitempty"`
}

// Resource the Resource definition.
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// ResourceSku describes an available API Management SKU.
type ResourceSku struct {
	// Name - Name of the Sku. Possible values include: 'SkuTypeDeveloper', 'SkuTypeStandard', 'SkuTypePremium', 'SkuTypeBasic'
	Name SkuType `json:"name,omitempty"`
}

// ResourceSkuCapacity describes scaling information of a SKU.
type ResourceSkuCapacity struct {
	// Minimum - The minimum capacity.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - The maximum capacity that can be set.
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - The default capacity.
	Default *int32 `json:"default,omitempty"`
	// ScaleType - The scale type applicable to the sku. Possible values include: 'Automatic', 'Manual', 'None'
	ScaleType ResourceSkuCapacityScaleType `json:"scaleType,omitempty"`
}

// ResourceSkuResult describes an available API Management service SKU.
type ResourceSkuResult struct {
	// ResourceType - The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - Specifies API Management SKU.
	Sku *ResourceSku `json:"sku,omitempty"`
	// Capacity - Specifies the number of API Management units.
	Capacity *ResourceSkuCapacity `json:"capacity,omitempty"`
}

// ResourceSkuResults the API Management service SKUs operation response.
type ResourceSkuResults struct {
	autorest.Response `json:"-"`
	// Value - The list of skus available for the service.
	Value *[]ResourceSkuResult `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of API Management service Skus.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceSkuResultsIterator provides access to a complete listing of ResourceSkuResult values.
type ResourceSkuResultsIterator struct {
	i    int
	page ResourceSkuResultsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceSkuResultsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkuResultsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceSkuResultsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceSkuResultsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceSkuResultsIterator) Response() ResourceSkuResults {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceSkuResultsIterator) Value() ResourceSkuResult {
	if !iter.page.NotDone() {
		return ResourceSkuResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceSkuResultsIterator type.
func NewResourceSkuResultsIterator(page ResourceSkuResultsPage) ResourceSkuResultsIterator {
	return ResourceSkuResultsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rsr ResourceSkuResults) IsEmpty() bool {
	return rsr.Value == nil || len(*rsr.Value) == 0
}

// resourceSkuResultsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rsr ResourceSkuResults) resourceSkuResultsPreparer(ctx context.Context) (*http.Request, error) {
	if rsr.NextLink == nil || len(to.String(rsr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rsr.NextLink)))
}

// ResourceSkuResultsPage contains a page of ResourceSkuResult values.
type ResourceSkuResultsPage struct {
	fn  func(context.Context, ResourceSkuResults) (ResourceSkuResults, error)
	rsr ResourceSkuResults
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceSkuResultsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkuResultsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rsr)
	if err != nil {
		return err
	}
	page.rsr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceSkuResultsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceSkuResultsPage) NotDone() bool {
	return !page.rsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceSkuResultsPage) Response() ResourceSkuResults {
	return page.rsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceSkuResultsPage) Values() []ResourceSkuResult {
	if page.rsr.IsEmpty() {
		return nil
	}
	return *page.rsr.Value
}

// Creates a new instance of the ResourceSkuResultsPage type.
func NewResourceSkuResultsPage(getNextPage func(context.Context, ResourceSkuResults) (ResourceSkuResults, error)) ResourceSkuResultsPage {
	return ResourceSkuResultsPage{fn: getNextPage}
}

// ResponseContract operation response details.
type ResponseContract struct {
	// StatusCode - Operation response HTTP status code.
	StatusCode *int32 `json:"statusCode,omitempty"`
	// Description - Operation response description.
	Description *string `json:"description,omitempty"`
	// Representations - Collection of operation response representations.
	Representations *[]RepresentationContract `json:"representations,omitempty"`
	// Headers - Collection of operation response headers.
	Headers *[]ParameterContract `json:"headers,omitempty"`
}

// SaveConfigurationParameter parameters supplied to the Save Tenant Configuration operation.
type SaveConfigurationParameter struct {
	// Branch - The name of the Git branch in which to commit the current configuration snapshot.
	Branch *string `json:"branch,omitempty"`
	// Force - The value if true, the current configuration database is committed to the Git repository, even if the Git repository has newer changes that would be overwritten.
	Force *bool `json:"force,omitempty"`
}

// SchemaCollection the response of the list schema operation.
type SchemaCollection struct {
	autorest.Response `json:"-"`
	// Value - Api Schema Contract value.
	Value *[]SchemaContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// SchemaCollectionIterator provides access to a complete listing of SchemaContract values.
type SchemaCollectionIterator struct {
	i    int
	page SchemaCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SchemaCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SchemaCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SchemaCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SchemaCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SchemaCollectionIterator) Response() SchemaCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SchemaCollectionIterator) Value() SchemaContract {
	if !iter.page.NotDone() {
		return SchemaContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SchemaCollectionIterator type.
func NewSchemaCollectionIterator(page SchemaCollectionPage) SchemaCollectionIterator {
	return SchemaCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sc SchemaCollection) IsEmpty() bool {
	return sc.Value == nil || len(*sc.Value) == 0
}

// schemaCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sc SchemaCollection) schemaCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if sc.NextLink == nil || len(to.String(sc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sc.NextLink)))
}

// SchemaCollectionPage contains a page of SchemaContract values.
type SchemaCollectionPage struct {
	fn func(context.Context, SchemaCollection) (SchemaCollection, error)
	sc SchemaCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SchemaCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SchemaCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sc)
	if err != nil {
		return err
	}
	page.sc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SchemaCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SchemaCollectionPage) NotDone() bool {
	return !page.sc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SchemaCollectionPage) Response() SchemaCollection {
	return page.sc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SchemaCollectionPage) Values() []SchemaContract {
	if page.sc.IsEmpty() {
		return nil
	}
	return *page.sc.Value
}

// Creates a new instance of the SchemaCollectionPage type.
func NewSchemaCollectionPage(getNextPage func(context.Context, SchemaCollection) (SchemaCollection, error)) SchemaCollectionPage {
	return SchemaCollectionPage{fn: getNextPage}
}

// SchemaContract schema Contract details.
type SchemaContract struct {
	autorest.Response `json:"-"`
	// SchemaContractProperties - Properties of the Schema.
	*SchemaContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SchemaContract.
func (sc SchemaContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.SchemaContractProperties != nil {
		objectMap["properties"] = sc.SchemaContractProperties
	}
	if sc.ID != nil {
		objectMap["id"] = sc.ID
	}
	if sc.Name != nil {
		objectMap["name"] = sc.Name
	}
	if sc.Type != nil {
		objectMap["type"] = sc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SchemaContract struct.
func (sc *SchemaContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var schemaContractProperties SchemaContractProperties
				err = json.Unmarshal(*v, &schemaContractProperties)
				if err != nil {
					return err
				}
				sc.SchemaContractProperties = &schemaContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sc.Type = &typeVar
			}
		}
	}

	return nil
}

// SchemaContractProperties schema contract Properties.
type SchemaContractProperties struct {
	// ContentType - Must be a valid a media type used in a Content-Type header as defined in the RFC 2616. Media type of the schema document (e.g. application/json, application/xml).
	ContentType *string `json:"contentType,omitempty"`
	// SchemaDocumentProperties - Properties of the Schema Document.
	*SchemaDocumentProperties `json:"document,omitempty"`
}

// MarshalJSON is the custom marshaler for SchemaContractProperties.
func (scp SchemaContractProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.ContentType != nil {
		objectMap["contentType"] = scp.ContentType
	}
	if scp.SchemaDocumentProperties != nil {
		objectMap["document"] = scp.SchemaDocumentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SchemaContractProperties struct.
func (scp *SchemaContractProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "contentType":
			if v != nil {
				var contentType string
				err = json.Unmarshal(*v, &contentType)
				if err != nil {
					return err
				}
				scp.ContentType = &contentType
			}
		case "document":
			if v != nil {
				var schemaDocumentProperties SchemaDocumentProperties
				err = json.Unmarshal(*v, &schemaDocumentProperties)
				if err != nil {
					return err
				}
				scp.SchemaDocumentProperties = &schemaDocumentProperties
			}
		}
	}

	return nil
}

// SchemaDocumentProperties schema Document Properties.
type SchemaDocumentProperties struct {
	// Value - Json escaped string defining the document representing the Schema.
	Value *string `json:"value,omitempty"`
}

// ServiceApplyNetworkConfigurationParameters parameter supplied to the Apply Network configuration
// operation.
type ServiceApplyNetworkConfigurationParameters struct {
	// Location - Location of the Api Management service to update for a multi-region service. For a service deployed in a single region, this parameter is not required.
	Location *string `json:"location,omitempty"`
}

// ServiceApplyNetworkConfigurationUpdatesFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ServiceApplyNetworkConfigurationUpdatesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceApplyNetworkConfigurationUpdatesFuture) Result(client ServiceClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServiceApplyNetworkConfigurationUpdatesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.ServiceApplyNetworkConfigurationUpdatesFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.ApplyNetworkConfigurationUpdatesResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServiceApplyNetworkConfigurationUpdatesFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceBackupFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceBackupFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceBackupFuture) Result(client ServiceClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServiceBackupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.ServiceBackupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.BackupResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServiceBackupFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceBackupRestoreParameters parameters supplied to the Backup/Restore of an API Management service
// operation.
type ServiceBackupRestoreParameters struct {
	// StorageAccount - Azure Cloud Storage account (used to place/retrieve the backup) name.
	StorageAccount *string `json:"storageAccount,omitempty"`
	// AccessKey - Azure Cloud Storage account (used to place/retrieve the backup) access key.
	AccessKey *string `json:"accessKey,omitempty"`
	// ContainerName - Azure Cloud Storage blob container name used to place/retrieve the backup.
	ContainerName *string `json:"containerName,omitempty"`
	// BackupName - The name of the backup file to create.
	BackupName *string `json:"backupName,omitempty"`
}

// ServiceBaseProperties base Properties of an API Management service resource description.
type ServiceBaseProperties struct {
	// NotificationSenderEmail - Email address from which the notification will be sent.
	NotificationSenderEmail *string `json:"notificationSenderEmail,omitempty"`
	// ProvisioningState - The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// TargetProvisioningState - The provisioning state of the API Management service, which is targeted by the long running operation started on the service.
	TargetProvisioningState *string `json:"targetProvisioningState,omitempty"`
	// CreatedAtUtc - Creation UTC date of the API Management service.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	CreatedAtUtc *date.Time `json:"createdAtUtc,omitempty"`
	// GatewayURL - Gateway URL of the API Management service.
	GatewayURL *string `json:"gatewayUrl,omitempty"`
	// GatewayRegionalURL - Gateway URL of the API Management service in the Default Region.
	GatewayRegionalURL *string `json:"gatewayRegionalUrl,omitempty"`
	// PortalURL - Publisher portal endpoint Url of the API Management service.
	PortalURL *string `json:"portalUrl,omitempty"`
	// ManagementAPIURL - Management API endpoint URL of the API Management service.
	ManagementAPIURL *string `json:"managementApiUrl,omitempty"`
	// ScmURL - SCM endpoint URL of the API Management service.
	ScmURL *string `json:"scmUrl,omitempty"`
	// HostnameConfigurations - Custom hostname configuration of the API Management service.
	HostnameConfigurations *[]HostnameConfiguration `json:"hostnameConfigurations,omitempty"`
	// PublicIPAddresses - Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for Basic, Standard and Premium SKU.
	PublicIPAddresses *[]string `json:"publicIPAddresses,omitempty"`
	// PrivateIPAddresses - Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed in an Internal Virtual Network. Available only for Basic, Standard and Premium SKU.
	PrivateIPAddresses *[]string `json:"privateIPAddresses,omitempty"`
	// VirtualNetworkConfiguration - Virtual network configuration of the API Management service.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`
	// AdditionalLocations - Additional datacenter locations of the API Management service.
	AdditionalLocations *[]AdditionalLocation `json:"additionalLocations,omitempty"`
	// CustomProperties - Custom properties of the API Management service. Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2). Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS 1.1 and setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to disable TLS 1.0 on an API Management service.
	CustomProperties map[string]*string `json:"customProperties"`
	// Certificates - List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
	Certificates *[]CertificateConfiguration `json:"certificates,omitempty"`
	// VirtualNetworkType - The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only. Possible values include: 'VirtualNetworkTypeNone', 'VirtualNetworkTypeExternal', 'VirtualNetworkTypeInternal'
	VirtualNetworkType VirtualNetworkType `json:"virtualNetworkType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBaseProperties.
func (sbp ServiceBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbp.NotificationSenderEmail != nil {
		objectMap["notificationSenderEmail"] = sbp.NotificationSenderEmail
	}
	if sbp.ProvisioningState != nil {
		objectMap["provisioningState"] = sbp.ProvisioningState
	}
	if sbp.TargetProvisioningState != nil {
		objectMap["targetProvisioningState"] = sbp.TargetProvisioningState
	}
	if sbp.CreatedAtUtc != nil {
		objectMap["createdAtUtc"] = sbp.CreatedAtUtc
	}
	if sbp.GatewayURL != nil {
		objectMap["gatewayUrl"] = sbp.GatewayURL
	}
	if sbp.GatewayRegionalURL != nil {
		objectMap["gatewayRegionalUrl"] = sbp.GatewayRegionalURL
	}
	if sbp.PortalURL != nil {
		objectMap["portalUrl"] = sbp.PortalURL
	}
	if sbp.ManagementAPIURL != nil {
		objectMap["managementApiUrl"] = sbp.ManagementAPIURL
	}
	if sbp.ScmURL != nil {
		objectMap["scmUrl"] = sbp.ScmURL
	}
	if sbp.HostnameConfigurations != nil {
		objectMap["hostnameConfigurations"] = sbp.HostnameConfigurations
	}
	if sbp.PublicIPAddresses != nil {
		objectMap["publicIPAddresses"] = sbp.PublicIPAddresses
	}
	if sbp.PrivateIPAddresses != nil {
		objectMap["privateIPAddresses"] = sbp.PrivateIPAddresses
	}
	if sbp.VirtualNetworkConfiguration != nil {
		objectMap["virtualNetworkConfiguration"] = sbp.VirtualNetworkConfiguration
	}
	if sbp.AdditionalLocations != nil {
		objectMap["additionalLocations"] = sbp.AdditionalLocations
	}
	if sbp.CustomProperties != nil {
		objectMap["customProperties"] = sbp.CustomProperties
	}
	if sbp.Certificates != nil {
		objectMap["certificates"] = sbp.Certificates
	}
	if sbp.VirtualNetworkType != "" {
		objectMap["virtualNetworkType"] = sbp.VirtualNetworkType
	}
	return json.Marshal(objectMap)
}

// ServiceCheckNameAvailabilityParameters parameters supplied to the CheckNameAvailability operation.
type ServiceCheckNameAvailabilityParameters struct {
	// Name - The name to check for availability.
	Name *string `json:"name,omitempty"`
}

// ServiceCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceCreateOrUpdateFuture) Result(client ServiceClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServiceCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.ServiceCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.CreateOrUpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServiceCreateOrUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceGetSsoTokenResult the response of the GetSsoToken operation.
type ServiceGetSsoTokenResult struct {
	autorest.Response `json:"-"`
	// RedirectURI - Redirect URL to the Publisher Portal containing the SSO token.
	RedirectURI *string `json:"redirectUri,omitempty"`
}

// ServiceIdentity identity properties of the Api Management service resource.
type ServiceIdentity struct {
	// Type - The identity type. Currently the only supported type is 'SystemAssigned'.
	Type *string `json:"type,omitempty"`
	// PrincipalID - The principal id of the identity.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// TenantID - The client tenant id of the identity.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// ServiceListResult the response of the List API Management services operation.
type ServiceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List API Management services operation.
	Value *[]ServiceResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of API Management services.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceListResultIterator provides access to a complete listing of ServiceResource values.
type ServiceListResultIterator struct {
	i    int
	page ServiceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceListResultIterator) Response() ServiceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceListResultIterator) Value() ServiceResource {
	if !iter.page.NotDone() {
		return ServiceResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceListResultIterator type.
func NewServiceListResultIterator(page ServiceListResultPage) ServiceListResultIterator {
	return ServiceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ServiceListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// serviceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ServiceListResult) serviceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ServiceListResultPage contains a page of ServiceResource values.
type ServiceListResultPage struct {
	fn  func(context.Context, ServiceListResult) (ServiceListResult, error)
	slr ServiceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceListResultPage) Response() ServiceListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceListResultPage) Values() []ServiceResource {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the ServiceListResultPage type.
func NewServiceListResultPage(getNextPage func(context.Context, ServiceListResult) (ServiceListResult, error)) ServiceListResultPage {
	return ServiceListResultPage{fn: getNextPage}
}

// ServiceNameAvailabilityResult response of the CheckNameAvailability operation.
type ServiceNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - True if the name is available and can be used to create a new API Management service; otherwise false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Message - If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements so that the user can select a valid name. If reason == AlreadyExists, explain that <resourceName> is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`
	// Reason - Invalid indicates the name provided does not match the resource provider’s naming requirements (incorrect length, unsupported characters, etc.)  AlreadyExists indicates that the name is already in use and is therefore unavailable. Possible values include: 'Valid', 'Invalid', 'AlreadyExists'
	Reason NameAvailabilityReason `json:"reason,omitempty"`
}

// ServiceProperties properties of an API Management service resource description.
type ServiceProperties struct {
	// PublisherEmail - Publisher email.
	PublisherEmail *string `json:"publisherEmail,omitempty"`
	// PublisherName - Publisher name.
	PublisherName *string `json:"publisherName,omitempty"`
	// NotificationSenderEmail - Email address from which the notification will be sent.
	NotificationSenderEmail *string `json:"notificationSenderEmail,omitempty"`
	// ProvisioningState - The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// TargetProvisioningState - The provisioning state of the API Management service, which is targeted by the long running operation started on the service.
	TargetProvisioningState *string `json:"targetProvisioningState,omitempty"`
	// CreatedAtUtc - Creation UTC date of the API Management service.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	CreatedAtUtc *date.Time `json:"createdAtUtc,omitempty"`
	// GatewayURL - Gateway URL of the API Management service.
	GatewayURL *string `json:"gatewayUrl,omitempty"`
	// GatewayRegionalURL - Gateway URL of the API Management service in the Default Region.
	GatewayRegionalURL *string `json:"gatewayRegionalUrl,omitempty"`
	// PortalURL - Publisher portal endpoint Url of the API Management service.
	PortalURL *string `json:"portalUrl,omitempty"`
	// ManagementAPIURL - Management API endpoint URL of the API Management service.
	ManagementAPIURL *string `json:"managementApiUrl,omitempty"`
	// ScmURL - SCM endpoint URL of the API Management service.
	ScmURL *string `json:"scmUrl,omitempty"`
	// HostnameConfigurations - Custom hostname configuration of the API Management service.
	HostnameConfigurations *[]HostnameConfiguration `json:"hostnameConfigurations,omitempty"`
	// PublicIPAddresses - Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for Basic, Standard and Premium SKU.
	PublicIPAddresses *[]string `json:"publicIPAddresses,omitempty"`
	// PrivateIPAddresses - Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed in an Internal Virtual Network. Available only for Basic, Standard and Premium SKU.
	PrivateIPAddresses *[]string `json:"privateIPAddresses,omitempty"`
	// VirtualNetworkConfiguration - Virtual network configuration of the API Management service.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`
	// AdditionalLocations - Additional datacenter locations of the API Management service.
	AdditionalLocations *[]AdditionalLocation `json:"additionalLocations,omitempty"`
	// CustomProperties - Custom properties of the API Management service. Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2). Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS 1.1 and setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to disable TLS 1.0 on an API Management service.
	CustomProperties map[string]*string `json:"customProperties"`
	// Certificates - List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
	Certificates *[]CertificateConfiguration `json:"certificates,omitempty"`
	// VirtualNetworkType - The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only. Possible values include: 'VirtualNetworkTypeNone', 'VirtualNetworkTypeExternal', 'VirtualNetworkTypeInternal'
	VirtualNetworkType VirtualNetworkType `json:"virtualNetworkType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProperties.
func (sp ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.PublisherEmail != nil {
		objectMap["publisherEmail"] = sp.PublisherEmail
	}
	if sp.PublisherName != nil {
		objectMap["publisherName"] = sp.PublisherName
	}
	if sp.NotificationSenderEmail != nil {
		objectMap["notificationSenderEmail"] = sp.NotificationSenderEmail
	}
	if sp.ProvisioningState != nil {
		objectMap["provisioningState"] = sp.ProvisioningState
	}
	if sp.TargetProvisioningState != nil {
		objectMap["targetProvisioningState"] = sp.TargetProvisioningState
	}
	if sp.CreatedAtUtc != nil {
		objectMap["createdAtUtc"] = sp.CreatedAtUtc
	}
	if sp.GatewayURL != nil {
		objectMap["gatewayUrl"] = sp.GatewayURL
	}
	if sp.GatewayRegionalURL != nil {
		objectMap["gatewayRegionalUrl"] = sp.GatewayRegionalURL
	}
	if sp.PortalURL != nil {
		objectMap["portalUrl"] = sp.PortalURL
	}
	if sp.ManagementAPIURL != nil {
		objectMap["managementApiUrl"] = sp.ManagementAPIURL
	}
	if sp.ScmURL != nil {
		objectMap["scmUrl"] = sp.ScmURL
	}
	if sp.HostnameConfigurations != nil {
		objectMap["hostnameConfigurations"] = sp.HostnameConfigurations
	}
	if sp.PublicIPAddresses != nil {
		objectMap["publicIPAddresses"] = sp.PublicIPAddresses
	}
	if sp.PrivateIPAddresses != nil {
		objectMap["privateIPAddresses"] = sp.PrivateIPAddresses
	}
	if sp.VirtualNetworkConfiguration != nil {
		objectMap["virtualNetworkConfiguration"] = sp.VirtualNetworkConfiguration
	}
	if sp.AdditionalLocations != nil {
		objectMap["additionalLocations"] = sp.AdditionalLocations
	}
	if sp.CustomProperties != nil {
		objectMap["customProperties"] = sp.CustomProperties
	}
	if sp.Certificates != nil {
		objectMap["certificates"] = sp.Certificates
	}
	if sp.VirtualNetworkType != "" {
		objectMap["virtualNetworkType"] = sp.VirtualNetworkType
	}
	return json.Marshal(objectMap)
}

// ServiceResource a single API Management service resource in List or Get response.
type ServiceResource struct {
	autorest.Response `json:"-"`
	// ServiceProperties - Properties of the API Management service.
	*ServiceProperties `json:"properties,omitempty"`
	// Sku - SKU properties of the API Management service.
	Sku *ServiceSkuProperties `json:"sku,omitempty"`
	// Identity - Managed service identity of the Api Management service.
	Identity *ServiceIdentity `json:"identity,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Etag - ETag of the resource.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServiceResource.
func (sr ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.ServiceProperties != nil {
		objectMap["properties"] = sr.ServiceProperties
	}
	if sr.Sku != nil {
		objectMap["sku"] = sr.Sku
	}
	if sr.Identity != nil {
		objectMap["identity"] = sr.Identity
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Etag != nil {
		objectMap["etag"] = sr.Etag
	}
	if sr.ID != nil {
		objectMap["id"] = sr.ID
	}
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Type != nil {
		objectMap["type"] = sr.Type
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceResource struct.
func (sr *ServiceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				sr.ServiceProperties = &serviceProperties
			}
		case "sku":
			if v != nil {
				var sku ServiceSkuProperties
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sr.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity ServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sr.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sr.Location = &location
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sr.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sr.Tags = tags
			}
		}
	}

	return nil
}

// ServiceRestoreFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceRestoreFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceRestoreFuture) Result(client ServiceClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServiceRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.ServiceRestoreFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.RestoreResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServiceRestoreFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceSkuProperties API Management service resource SKU properties.
type ServiceSkuProperties struct {
	// Name - Name of the Sku. Possible values include: 'SkuTypeDeveloper', 'SkuTypeStandard', 'SkuTypePremium', 'SkuTypeBasic'
	Name SkuType `json:"name,omitempty"`
	// Capacity - Capacity of the SKU (number of deployed units of the SKU). The default value is 1.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ServiceUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceUpdateFuture) Result(client ServiceClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServiceUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.ServiceUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.UpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServiceUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceUpdateHostnameFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServiceUpdateHostnameFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceUpdateHostnameFuture) Result(client ServiceClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.ServiceUpdateHostnameFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.ServiceUpdateHostnameFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.UpdateHostnameResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.ServiceUpdateHostnameFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceUpdateHostnameParameters parameters supplied to the UpdateHostname operation.
type ServiceUpdateHostnameParameters struct {
	// Update - Hostnames to create or update.
	Update *[]HostnameConfigurationOld `json:"update,omitempty"`
	// Delete - Hostnames types to delete.
	Delete *[]HostnameType `json:"delete,omitempty"`
}

// ServiceUpdateParameters parameter supplied to Update Api Management Service.
type ServiceUpdateParameters struct {
	// ServiceUpdateProperties - Properties of the API Management service.
	*ServiceUpdateProperties `json:"properties,omitempty"`
	// Sku - SKU properties of the API Management service.
	Sku *ServiceSkuProperties `json:"sku,omitempty"`
	// Identity - Managed service identity of the Api Management service.
	Identity *ServiceIdentity `json:"identity,omitempty"`
	// Etag - ETag of the resource.
	Etag *string `json:"etag,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource is set to Microsoft.ApiManagement.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServiceUpdateParameters.
func (sup ServiceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sup.ServiceUpdateProperties != nil {
		objectMap["properties"] = sup.ServiceUpdateProperties
	}
	if sup.Sku != nil {
		objectMap["sku"] = sup.Sku
	}
	if sup.Identity != nil {
		objectMap["identity"] = sup.Identity
	}
	if sup.Etag != nil {
		objectMap["etag"] = sup.Etag
	}
	if sup.ID != nil {
		objectMap["id"] = sup.ID
	}
	if sup.Name != nil {
		objectMap["name"] = sup.Name
	}
	if sup.Type != nil {
		objectMap["type"] = sup.Type
	}
	if sup.Tags != nil {
		objectMap["tags"] = sup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceUpdateParameters struct.
func (sup *ServiceUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceUpdateProperties ServiceUpdateProperties
				err = json.Unmarshal(*v, &serviceUpdateProperties)
				if err != nil {
					return err
				}
				sup.ServiceUpdateProperties = &serviceUpdateProperties
			}
		case "sku":
			if v != nil {
				var sku ServiceSkuProperties
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				sup.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity ServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				sup.Identity = &identity
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sup.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sup.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sup.Tags = tags
			}
		}
	}

	return nil
}

// ServiceUpdateProperties properties of an API Management service resource description.
type ServiceUpdateProperties struct {
	// PublisherEmail - Publisher email.
	PublisherEmail *string `json:"publisherEmail,omitempty"`
	// PublisherName - Publisher name.
	PublisherName *string `json:"publisherName,omitempty"`
	// NotificationSenderEmail - Email address from which the notification will be sent.
	NotificationSenderEmail *string `json:"notificationSenderEmail,omitempty"`
	// ProvisioningState - The current provisioning state of the API Management service which can be one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// TargetProvisioningState - The provisioning state of the API Management service, which is targeted by the long running operation started on the service.
	TargetProvisioningState *string `json:"targetProvisioningState,omitempty"`
	// CreatedAtUtc - Creation UTC date of the API Management service.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	CreatedAtUtc *date.Time `json:"createdAtUtc,omitempty"`
	// GatewayURL - Gateway URL of the API Management service.
	GatewayURL *string `json:"gatewayUrl,omitempty"`
	// GatewayRegionalURL - Gateway URL of the API Management service in the Default Region.
	GatewayRegionalURL *string `json:"gatewayRegionalUrl,omitempty"`
	// PortalURL - Publisher portal endpoint Url of the API Management service.
	PortalURL *string `json:"portalUrl,omitempty"`
	// ManagementAPIURL - Management API endpoint URL of the API Management service.
	ManagementAPIURL *string `json:"managementApiUrl,omitempty"`
	// ScmURL - SCM endpoint URL of the API Management service.
	ScmURL *string `json:"scmUrl,omitempty"`
	// HostnameConfigurations - Custom hostname configuration of the API Management service.
	HostnameConfigurations *[]HostnameConfiguration `json:"hostnameConfigurations,omitempty"`
	// PublicIPAddresses - Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for Basic, Standard and Premium SKU.
	PublicIPAddresses *[]string `json:"publicIPAddresses,omitempty"`
	// PrivateIPAddresses - Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed in an Internal Virtual Network. Available only for Basic, Standard and Premium SKU.
	PrivateIPAddresses *[]string `json:"privateIPAddresses,omitempty"`
	// VirtualNetworkConfiguration - Virtual network configuration of the API Management service.
	VirtualNetworkConfiguration *VirtualNetworkConfiguration `json:"virtualNetworkConfiguration,omitempty"`
	// AdditionalLocations - Additional datacenter locations of the API Management service.
	AdditionalLocations *[]AdditionalLocation `json:"additionalLocations,omitempty"`
	// CustomProperties - Custom properties of the API Management service. Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2). Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS 1.1 and setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to disable TLS 1.0 on an API Management service.
	CustomProperties map[string]*string `json:"customProperties"`
	// Certificates - List of Certificates that need to be installed in the API Management service. Max supported certificates that can be installed is 10.
	Certificates *[]CertificateConfiguration `json:"certificates,omitempty"`
	// VirtualNetworkType - The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API Management service is not part of any Virtual Network, External means the API Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only. Possible values include: 'VirtualNetworkTypeNone', 'VirtualNetworkTypeExternal', 'VirtualNetworkTypeInternal'
	VirtualNetworkType VirtualNetworkType `json:"virtualNetworkType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceUpdateProperties.
func (sup ServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sup.PublisherEmail != nil {
		objectMap["publisherEmail"] = sup.PublisherEmail
	}
	if sup.PublisherName != nil {
		objectMap["publisherName"] = sup.PublisherName
	}
	if sup.NotificationSenderEmail != nil {
		objectMap["notificationSenderEmail"] = sup.NotificationSenderEmail
	}
	if sup.ProvisioningState != nil {
		objectMap["provisioningState"] = sup.ProvisioningState
	}
	if sup.TargetProvisioningState != nil {
		objectMap["targetProvisioningState"] = sup.TargetProvisioningState
	}
	if sup.CreatedAtUtc != nil {
		objectMap["createdAtUtc"] = sup.CreatedAtUtc
	}
	if sup.GatewayURL != nil {
		objectMap["gatewayUrl"] = sup.GatewayURL
	}
	if sup.GatewayRegionalURL != nil {
		objectMap["gatewayRegionalUrl"] = sup.GatewayRegionalURL
	}
	if sup.PortalURL != nil {
		objectMap["portalUrl"] = sup.PortalURL
	}
	if sup.ManagementAPIURL != nil {
		objectMap["managementApiUrl"] = sup.ManagementAPIURL
	}
	if sup.ScmURL != nil {
		objectMap["scmUrl"] = sup.ScmURL
	}
	if sup.HostnameConfigurations != nil {
		objectMap["hostnameConfigurations"] = sup.HostnameConfigurations
	}
	if sup.PublicIPAddresses != nil {
		objectMap["publicIPAddresses"] = sup.PublicIPAddresses
	}
	if sup.PrivateIPAddresses != nil {
		objectMap["privateIPAddresses"] = sup.PrivateIPAddresses
	}
	if sup.VirtualNetworkConfiguration != nil {
		objectMap["virtualNetworkConfiguration"] = sup.VirtualNetworkConfiguration
	}
	if sup.AdditionalLocations != nil {
		objectMap["additionalLocations"] = sup.AdditionalLocations
	}
	if sup.CustomProperties != nil {
		objectMap["customProperties"] = sup.CustomProperties
	}
	if sup.Certificates != nil {
		objectMap["certificates"] = sup.Certificates
	}
	if sup.VirtualNetworkType != "" {
		objectMap["virtualNetworkType"] = sup.VirtualNetworkType
	}
	return json.Marshal(objectMap)
}

// ServiceUploadCertificateParameters parameters supplied to the Upload SSL certificate for an API
// Management service operation.
type ServiceUploadCertificateParameters struct {
	// Type - Hostname type. Possible values include: 'Proxy', 'Portal', 'Management', 'Scm'
	Type HostnameType `json:"type,omitempty"`
	// Certificate - Base64 Encoded certificate.
	Certificate *string `json:"certificate,omitempty"`
	// CertificatePassword - Certificate password.
	CertificatePassword *string `json:"certificate_password,omitempty"`
}

// SubscriptionCollection paged Subscriptions list representation.
type SubscriptionCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]SubscriptionContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionCollectionIterator provides access to a complete listing of SubscriptionContract values.
type SubscriptionCollectionIterator struct {
	i    int
	page SubscriptionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionCollectionIterator) Response() SubscriptionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionCollectionIterator) Value() SubscriptionContract {
	if !iter.page.NotDone() {
		return SubscriptionContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionCollectionIterator type.
func NewSubscriptionCollectionIterator(page SubscriptionCollectionPage) SubscriptionCollectionIterator {
	return SubscriptionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sc SubscriptionCollection) IsEmpty() bool {
	return sc.Value == nil || len(*sc.Value) == 0
}

// subscriptionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sc SubscriptionCollection) subscriptionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if sc.NextLink == nil || len(to.String(sc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sc.NextLink)))
}

// SubscriptionCollectionPage contains a page of SubscriptionContract values.
type SubscriptionCollectionPage struct {
	fn func(context.Context, SubscriptionCollection) (SubscriptionCollection, error)
	sc SubscriptionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sc)
	if err != nil {
		return err
	}
	page.sc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionCollectionPage) NotDone() bool {
	return !page.sc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionCollectionPage) Response() SubscriptionCollection {
	return page.sc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionCollectionPage) Values() []SubscriptionContract {
	if page.sc.IsEmpty() {
		return nil
	}
	return *page.sc.Value
}

// Creates a new instance of the SubscriptionCollectionPage type.
func NewSubscriptionCollectionPage(getNextPage func(context.Context, SubscriptionCollection) (SubscriptionCollection, error)) SubscriptionCollectionPage {
	return SubscriptionCollectionPage{fn: getNextPage}
}

// SubscriptionContract subscription details.
type SubscriptionContract struct {
	autorest.Response `json:"-"`
	// SubscriptionContractProperties - Subscription contract properties.
	*SubscriptionContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionContract.
func (sc SubscriptionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.SubscriptionContractProperties != nil {
		objectMap["properties"] = sc.SubscriptionContractProperties
	}
	if sc.ID != nil {
		objectMap["id"] = sc.ID
	}
	if sc.Name != nil {
		objectMap["name"] = sc.Name
	}
	if sc.Type != nil {
		objectMap["type"] = sc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionContract struct.
func (sc *SubscriptionContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionContractProperties SubscriptionContractProperties
				err = json.Unmarshal(*v, &subscriptionContractProperties)
				if err != nil {
					return err
				}
				sc.SubscriptionContractProperties = &subscriptionContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sc.Type = &typeVar
			}
		}
	}

	return nil
}

// SubscriptionContractProperties subscription details.
type SubscriptionContractProperties struct {
	// UserID - The user resource identifier of the subscription owner. The value is a valid relative URL in the format of /users/{uid} where {uid} is a user identifier.
	UserID *string `json:"userId,omitempty"`
	// ProductID - The product resource identifier of the subscribed product. The value is a valid relative URL in the format of /products/{productId} where {productId} is a product identifier.
	ProductID *string `json:"productId,omitempty"`
	// DisplayName - The name of the subscription, or null if the subscription has no name.
	DisplayName *string `json:"displayName,omitempty"`
	// State - Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionState `json:"state,omitempty"`
	// CreatedDate - Subscription creation date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// StartDate - Subscription activation date. The setting is for audit purposes only and the subscription is not automatically activated. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	StartDate *date.Time `json:"startDate,omitempty"`
	// ExpirationDate - Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically expired. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// EndDate - Date when subscription was cancelled or expired. The setting is for audit purposes only and the subscription is not automatically cancelled. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	EndDate *date.Time `json:"endDate,omitempty"`
	// NotificationDate - Upcoming subscription expiration notification date. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	NotificationDate *date.Time `json:"notificationDate,omitempty"`
	// PrimaryKey - Subscription primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Subscription secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// StateComment - Optional subscription comment added by an administrator.
	StateComment *string `json:"stateComment,omitempty"`
}

// SubscriptionCreateParameterProperties parameters supplied to the Create subscription operation.
type SubscriptionCreateParameterProperties struct {
	// UserID - User (user id path) for whom subscription is being created in form /users/{uid}
	UserID *string `json:"userId,omitempty"`
	// ProductID - Product (product id path) for which subscription is being created in form /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// DisplayName - Subscription name.
	DisplayName *string `json:"displayName,omitempty"`
	// PrimaryKey - Primary subscription key. If not specified during request key will be generated automatically.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary subscription key. If not specified during request key will be generated automatically.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// State - Initial subscription state. If no value is specified, subscription is created with Submitted state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionState `json:"state,omitempty"`
}

// SubscriptionCreateParameters subscription create details.
type SubscriptionCreateParameters struct {
	// SubscriptionCreateParameterProperties - Subscription contract properties.
	*SubscriptionCreateParameterProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionCreateParameters.
func (scp SubscriptionCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.SubscriptionCreateParameterProperties != nil {
		objectMap["properties"] = scp.SubscriptionCreateParameterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionCreateParameters struct.
func (scp *SubscriptionCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionCreateParameterProperties SubscriptionCreateParameterProperties
				err = json.Unmarshal(*v, &subscriptionCreateParameterProperties)
				if err != nil {
					return err
				}
				scp.SubscriptionCreateParameterProperties = &subscriptionCreateParameterProperties
			}
		}
	}

	return nil
}

// SubscriptionKeyParameterNamesContract subscription key parameter names details.
type SubscriptionKeyParameterNamesContract struct {
	// Header - Subscription key header name.
	Header *string `json:"header,omitempty"`
	// Query - Subscription key query string parameter name.
	Query *string `json:"query,omitempty"`
}

// SubscriptionsDelegationSettingsProperties subscriptions delegation settings properties.
type SubscriptionsDelegationSettingsProperties struct {
	// Enabled - Enable or disable delegation for subscriptions.
	Enabled *bool `json:"enabled,omitempty"`
}

// SubscriptionUpdateParameterProperties parameters supplied to the Update subscription operation.
type SubscriptionUpdateParameterProperties struct {
	// UserID - User identifier path: /users/{uid}
	UserID *string `json:"userId,omitempty"`
	// ProductID - Product identifier path: /products/{productId}
	ProductID *string `json:"productId,omitempty"`
	// ExpirationDate - Subscription expiration date. The setting is for audit purposes only and the subscription is not automatically expired. The subscription lifecycle can be managed by using the `state` property. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// DisplayName - Subscription name.
	DisplayName *string `json:"displayName,omitempty"`
	// PrimaryKey - Primary subscription key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary subscription key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// State - Subscription state. Possible states are * active – the subscription is active, * suspended – the subscription is blocked, and the subscriber cannot call any APIs of the product, * submitted – the subscription request has been made by the developer, but has not yet been approved or rejected, * rejected – the subscription request has been denied by an administrator, * cancelled – the subscription has been cancelled by the developer or administrator, * expired – the subscription reached its expiration date and was deactivated. Possible values include: 'Suspended', 'Active', 'Expired', 'Submitted', 'Rejected', 'Cancelled'
	State SubscriptionState `json:"state,omitempty"`
	// StateComment - Comments describing subscription state change by the administrator.
	StateComment *string `json:"stateComment,omitempty"`
}

// SubscriptionUpdateParameters subscription update details.
type SubscriptionUpdateParameters struct {
	// SubscriptionUpdateParameterProperties - Subscription Update contract properties.
	*SubscriptionUpdateParameterProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionUpdateParameters.
func (sup SubscriptionUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sup.SubscriptionUpdateParameterProperties != nil {
		objectMap["properties"] = sup.SubscriptionUpdateParameterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionUpdateParameters struct.
func (sup *SubscriptionUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionUpdateParameterProperties SubscriptionUpdateParameterProperties
				err = json.Unmarshal(*v, &subscriptionUpdateParameterProperties)
				if err != nil {
					return err
				}
				sup.SubscriptionUpdateParameterProperties = &subscriptionUpdateParameterProperties
			}
		}
	}

	return nil
}

// TagCollection paged Tag list representation.
type TagCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]TagContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// TagCollectionIterator provides access to a complete listing of TagContract values.
type TagCollectionIterator struct {
	i    int
	page TagCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TagCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TagCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TagCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TagCollectionIterator) Response() TagCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TagCollectionIterator) Value() TagContract {
	if !iter.page.NotDone() {
		return TagContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TagCollectionIterator type.
func NewTagCollectionIterator(page TagCollectionPage) TagCollectionIterator {
	return TagCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tc TagCollection) IsEmpty() bool {
	return tc.Value == nil || len(*tc.Value) == 0
}

// tagCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tc TagCollection) tagCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if tc.NextLink == nil || len(to.String(tc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tc.NextLink)))
}

// TagCollectionPage contains a page of TagContract values.
type TagCollectionPage struct {
	fn func(context.Context, TagCollection) (TagCollection, error)
	tc TagCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TagCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tc)
	if err != nil {
		return err
	}
	page.tc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TagCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TagCollectionPage) NotDone() bool {
	return !page.tc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TagCollectionPage) Response() TagCollection {
	return page.tc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TagCollectionPage) Values() []TagContract {
	if page.tc.IsEmpty() {
		return nil
	}
	return *page.tc.Value
}

// Creates a new instance of the TagCollectionPage type.
func NewTagCollectionPage(getNextPage func(context.Context, TagCollection) (TagCollection, error)) TagCollectionPage {
	return TagCollectionPage{fn: getNextPage}
}

// TagContract tag Contract details.
type TagContract struct {
	autorest.Response `json:"-"`
	// TagContractProperties - Tag entity contract properties.
	*TagContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TagContract.
func (tc TagContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tc.TagContractProperties != nil {
		objectMap["properties"] = tc.TagContractProperties
	}
	if tc.ID != nil {
		objectMap["id"] = tc.ID
	}
	if tc.Name != nil {
		objectMap["name"] = tc.Name
	}
	if tc.Type != nil {
		objectMap["type"] = tc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TagContract struct.
func (tc *TagContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tagContractProperties TagContractProperties
				err = json.Unmarshal(*v, &tagContractProperties)
				if err != nil {
					return err
				}
				tc.TagContractProperties = &tagContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tc.Type = &typeVar
			}
		}
	}

	return nil
}

// TagContractProperties tag contract Properties.
type TagContractProperties struct {
	// DisplayName - Tag name.
	DisplayName *string `json:"displayName,omitempty"`
}

// TagCreateUpdateParameters parameters supplied to Create/Update Tag operations.
type TagCreateUpdateParameters struct {
	// TagContractProperties - Properties supplied to Create Tag operation.
	*TagContractProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TagCreateUpdateParameters.
func (tcup TagCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tcup.TagContractProperties != nil {
		objectMap["properties"] = tcup.TagContractProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TagCreateUpdateParameters struct.
func (tcup *TagCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tagContractProperties TagContractProperties
				err = json.Unmarshal(*v, &tagContractProperties)
				if err != nil {
					return err
				}
				tcup.TagContractProperties = &tagContractProperties
			}
		}
	}

	return nil
}

// TagDescriptionBaseProperties parameters supplied to the Create TagDescription operation.
type TagDescriptionBaseProperties struct {
	// Description - Description of the Tag.
	Description *string `json:"description,omitempty"`
	// ExternalDocsURL - Absolute URL of external resources describing the tag.
	ExternalDocsURL *string `json:"externalDocsUrl,omitempty"`
	// ExternalDocsDescription - Description of the external resources describing the tag.
	ExternalDocsDescription *string `json:"externalDocsDescription,omitempty"`
}

// TagDescriptionCollection paged TagDescription list representation.
type TagDescriptionCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]TagDescriptionContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// TagDescriptionCollectionIterator provides access to a complete listing of TagDescriptionContract values.
type TagDescriptionCollectionIterator struct {
	i    int
	page TagDescriptionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TagDescriptionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagDescriptionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TagDescriptionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TagDescriptionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TagDescriptionCollectionIterator) Response() TagDescriptionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TagDescriptionCollectionIterator) Value() TagDescriptionContract {
	if !iter.page.NotDone() {
		return TagDescriptionContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TagDescriptionCollectionIterator type.
func NewTagDescriptionCollectionIterator(page TagDescriptionCollectionPage) TagDescriptionCollectionIterator {
	return TagDescriptionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tdc TagDescriptionCollection) IsEmpty() bool {
	return tdc.Value == nil || len(*tdc.Value) == 0
}

// tagDescriptionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tdc TagDescriptionCollection) tagDescriptionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if tdc.NextLink == nil || len(to.String(tdc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tdc.NextLink)))
}

// TagDescriptionCollectionPage contains a page of TagDescriptionContract values.
type TagDescriptionCollectionPage struct {
	fn  func(context.Context, TagDescriptionCollection) (TagDescriptionCollection, error)
	tdc TagDescriptionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TagDescriptionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagDescriptionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tdc)
	if err != nil {
		return err
	}
	page.tdc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TagDescriptionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TagDescriptionCollectionPage) NotDone() bool {
	return !page.tdc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TagDescriptionCollectionPage) Response() TagDescriptionCollection {
	return page.tdc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TagDescriptionCollectionPage) Values() []TagDescriptionContract {
	if page.tdc.IsEmpty() {
		return nil
	}
	return *page.tdc.Value
}

// Creates a new instance of the TagDescriptionCollectionPage type.
func NewTagDescriptionCollectionPage(getNextPage func(context.Context, TagDescriptionCollection) (TagDescriptionCollection, error)) TagDescriptionCollectionPage {
	return TagDescriptionCollectionPage{fn: getNextPage}
}

// TagDescriptionContract contract details.
type TagDescriptionContract struct {
	autorest.Response `json:"-"`
	// TagDescriptionContractProperties - TagDescription entity contract properties.
	*TagDescriptionContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TagDescriptionContract.
func (tdc TagDescriptionContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tdc.TagDescriptionContractProperties != nil {
		objectMap["properties"] = tdc.TagDescriptionContractProperties
	}
	if tdc.ID != nil {
		objectMap["id"] = tdc.ID
	}
	if tdc.Name != nil {
		objectMap["name"] = tdc.Name
	}
	if tdc.Type != nil {
		objectMap["type"] = tdc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TagDescriptionContract struct.
func (tdc *TagDescriptionContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tagDescriptionContractProperties TagDescriptionContractProperties
				err = json.Unmarshal(*v, &tagDescriptionContractProperties)
				if err != nil {
					return err
				}
				tdc.TagDescriptionContractProperties = &tagDescriptionContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tdc.Type = &typeVar
			}
		}
	}

	return nil
}

// TagDescriptionContractProperties tagDescription contract Properties.
type TagDescriptionContractProperties struct {
	// DisplayName - Tag name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of the Tag.
	Description *string `json:"description,omitempty"`
	// ExternalDocsURL - Absolute URL of external resources describing the tag.
	ExternalDocsURL *string `json:"externalDocsUrl,omitempty"`
	// ExternalDocsDescription - Description of the external resources describing the tag.
	ExternalDocsDescription *string `json:"externalDocsDescription,omitempty"`
}

// TagDescriptionCreateParameters parameters supplied to the Create TagDescription operation.
type TagDescriptionCreateParameters struct {
	// TagDescriptionBaseProperties - Properties supplied to Create TagDescription operation.
	*TagDescriptionBaseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TagDescriptionCreateParameters.
func (tdcp TagDescriptionCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tdcp.TagDescriptionBaseProperties != nil {
		objectMap["properties"] = tdcp.TagDescriptionBaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TagDescriptionCreateParameters struct.
func (tdcp *TagDescriptionCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tagDescriptionBaseProperties TagDescriptionBaseProperties
				err = json.Unmarshal(*v, &tagDescriptionBaseProperties)
				if err != nil {
					return err
				}
				tdcp.TagDescriptionBaseProperties = &tagDescriptionBaseProperties
			}
		}
	}

	return nil
}

// TagResourceCollection paged Tag list representation.
type TagResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]TagResourceContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// TagResourceCollectionIterator provides access to a complete listing of TagResourceContract values.
type TagResourceCollectionIterator struct {
	i    int
	page TagResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TagResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TagResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TagResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TagResourceCollectionIterator) Response() TagResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TagResourceCollectionIterator) Value() TagResourceContract {
	if !iter.page.NotDone() {
		return TagResourceContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TagResourceCollectionIterator type.
func NewTagResourceCollectionIterator(page TagResourceCollectionPage) TagResourceCollectionIterator {
	return TagResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (trc TagResourceCollection) IsEmpty() bool {
	return trc.Value == nil || len(*trc.Value) == 0
}

// tagResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (trc TagResourceCollection) tagResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if trc.NextLink == nil || len(to.String(trc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(trc.NextLink)))
}

// TagResourceCollectionPage contains a page of TagResourceContract values.
type TagResourceCollectionPage struct {
	fn  func(context.Context, TagResourceCollection) (TagResourceCollection, error)
	trc TagResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TagResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.trc)
	if err != nil {
		return err
	}
	page.trc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TagResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TagResourceCollectionPage) NotDone() bool {
	return !page.trc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TagResourceCollectionPage) Response() TagResourceCollection {
	return page.trc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TagResourceCollectionPage) Values() []TagResourceContract {
	if page.trc.IsEmpty() {
		return nil
	}
	return *page.trc.Value
}

// Creates a new instance of the TagResourceCollectionPage type.
func NewTagResourceCollectionPage(getNextPage func(context.Context, TagResourceCollection) (TagResourceCollection, error)) TagResourceCollectionPage {
	return TagResourceCollectionPage{fn: getNextPage}
}

// TagResourceContract tagResource contract properties.
type TagResourceContract struct {
	// Tag - Tag associated with the resource.
	Tag *TagTagResourceContractProperties `json:"tag,omitempty"`
	// API - Api associated with the tag.
	API *APITagResourceContractProperties `json:"api,omitempty"`
	// Operation - Operation associated with the tag.
	Operation *OperationTagResourceContractProperties `json:"operation,omitempty"`
	// Product - Product associated with the tag.
	Product *ProductTagResourceContractProperties `json:"product,omitempty"`
}

// TagTagResourceContractProperties contract defining the Tag property in the Tag Resource Contract
type TagTagResourceContractProperties struct {
	// ID - Tag identifier
	ID *string `json:"id,omitempty"`
	// Name - Tag Name
	Name *string `json:"name,omitempty"`
}

// TenantConfigurationDeployFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type TenantConfigurationDeployFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TenantConfigurationDeployFuture) Result(client TenantConfigurationClient) (orc OperationResultContract, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationDeployFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.TenantConfigurationDeployFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if orc.Response.Response, err = future.GetResult(sender); err == nil && orc.Response.Response.StatusCode != http.StatusNoContent {
		orc, err = client.DeployResponder(orc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationDeployFuture", "Result", orc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TenantConfigurationSaveFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TenantConfigurationSaveFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TenantConfigurationSaveFuture) Result(client TenantConfigurationClient) (orc OperationResultContract, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationSaveFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.TenantConfigurationSaveFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if orc.Response.Response, err = future.GetResult(sender); err == nil && orc.Response.Response.StatusCode != http.StatusNoContent {
		orc, err = client.SaveResponder(orc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationSaveFuture", "Result", orc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TenantConfigurationSyncStateContract tenant Configuration Synchronization State.
type TenantConfigurationSyncStateContract struct {
	autorest.Response `json:"-"`
	// Branch - The name of Git branch.
	Branch *string `json:"branch,omitempty"`
	// CommitID - The latest commit Id.
	CommitID *string `json:"commitId,omitempty"`
	// IsExport - value indicating if last sync was save (true) or deploy (false) operation.
	IsExport *bool `json:"isExport,omitempty"`
	// IsSynced - value indicating if last synchronization was later than the configuration change.
	IsSynced *bool `json:"isSynced,omitempty"`
	// IsGitEnabled - value indicating whether Git configuration access is enabled.
	IsGitEnabled *bool `json:"isGitEnabled,omitempty"`
	// SyncDate - The date of the latest synchronization. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	SyncDate *date.Time `json:"syncDate,omitempty"`
	// ConfigurationChangeDate - The date of the latest configuration change. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	ConfigurationChangeDate *date.Time `json:"configurationChangeDate,omitempty"`
}

// TenantConfigurationValidateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type TenantConfigurationValidateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TenantConfigurationValidateFuture) Result(client TenantConfigurationClient) (orc OperationResultContract, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationValidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("apimanagement.TenantConfigurationValidateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if orc.Response.Response, err = future.GetResult(sender); err == nil && orc.Response.Response.StatusCode != http.StatusNoContent {
		orc, err = client.ValidateResponder(orc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "apimanagement.TenantConfigurationValidateFuture", "Result", orc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TermsOfServiceProperties terms of service contract properties.
type TermsOfServiceProperties struct {
	// Text - A terms of service text.
	Text *string `json:"text,omitempty"`
	// Enabled - Display terms of service during a sign-up process.
	Enabled *bool `json:"enabled,omitempty"`
	// ConsentRequired - Ask user for consent to the terms of service.
	ConsentRequired *bool `json:"consentRequired,omitempty"`
}

// TokenBodyParameterContract oAuth acquire token request body parameter (www-url-form-encoded).
type TokenBodyParameterContract struct {
	// Name - body parameter name.
	Name *string `json:"name,omitempty"`
	// Value - body parameter value.
	Value *string `json:"value,omitempty"`
}

// UserCollection paged Users list representation.
type UserCollection struct {
	autorest.Response `json:"-"`
	// Value - Page values.
	Value *[]UserContract `json:"value,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserCollectionIterator provides access to a complete listing of UserContract values.
type UserCollectionIterator struct {
	i    int
	page UserCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserCollectionIterator) Response() UserCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserCollectionIterator) Value() UserContract {
	if !iter.page.NotDone() {
		return UserContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserCollectionIterator type.
func NewUserCollectionIterator(page UserCollectionPage) UserCollectionIterator {
	return UserCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uc UserCollection) IsEmpty() bool {
	return uc.Value == nil || len(*uc.Value) == 0
}

// userCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uc UserCollection) userCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if uc.NextLink == nil || len(to.String(uc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uc.NextLink)))
}

// UserCollectionPage contains a page of UserContract values.
type UserCollectionPage struct {
	fn func(context.Context, UserCollection) (UserCollection, error)
	uc UserCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.uc)
	if err != nil {
		return err
	}
	page.uc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserCollectionPage) NotDone() bool {
	return !page.uc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserCollectionPage) Response() UserCollection {
	return page.uc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserCollectionPage) Values() []UserContract {
	if page.uc.IsEmpty() {
		return nil
	}
	return *page.uc.Value
}

// Creates a new instance of the UserCollectionPage type.
func NewUserCollectionPage(getNextPage func(context.Context, UserCollection) (UserCollection, error)) UserCollectionPage {
	return UserCollectionPage{fn: getNextPage}
}

// UserContract user details.
type UserContract struct {
	autorest.Response `json:"-"`
	// UserContractProperties - User entity contract properties.
	*UserContractProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type for API Management resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for UserContract.
func (uc UserContract) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uc.UserContractProperties != nil {
		objectMap["properties"] = uc.UserContractProperties
	}
	if uc.ID != nil {
		objectMap["id"] = uc.ID
	}
	if uc.Name != nil {
		objectMap["name"] = uc.Name
	}
	if uc.Type != nil {
		objectMap["type"] = uc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserContract struct.
func (uc *UserContract) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userContractProperties UserContractProperties
				err = json.Unmarshal(*v, &userContractProperties)
				if err != nil {
					return err
				}
				uc.UserContractProperties = &userContractProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				uc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				uc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				uc.Type = &typeVar
			}
		}
	}

	return nil
}

// UserContractProperties user profile.
type UserContractProperties struct {
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// Email - Email address.
	Email *string `json:"email,omitempty"`
	// RegistrationDate - Date of user registration. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	RegistrationDate *date.Time `json:"registrationDate,omitempty"`
	// Groups - Collection of groups user is part of.
	Groups *[]GroupContractProperties `json:"groups,omitempty"`
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateActive', 'UserStateBlocked', 'UserStatePending', 'UserStateDeleted'
	State UserState `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
	// Identities - Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// UserCreateParameterProperties parameters supplied to the Create User operation.
type UserCreateParameterProperties struct {
	// Email - Email address. Must not be empty and must be unique within the service instance.
	Email *string `json:"email,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// Password - User Password. If no value is provided, a default password is generated.
	Password *string `json:"password,omitempty"`
	// Confirmation - Determines the type of confirmation e-mail that will be sent to the newly created user. Possible values include: 'Signup', 'Invite'
	Confirmation Confirmation `json:"confirmation,omitempty"`
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateActive', 'UserStateBlocked', 'UserStatePending', 'UserStateDeleted'
	State UserState `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
	// Identities - Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// UserCreateParameters user create details.
type UserCreateParameters struct {
	// UserCreateParameterProperties - User entity create contract properties.
	*UserCreateParameterProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UserCreateParameters.
func (ucp UserCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucp.UserCreateParameterProperties != nil {
		objectMap["properties"] = ucp.UserCreateParameterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserCreateParameters struct.
func (ucp *UserCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userCreateParameterProperties UserCreateParameterProperties
				err = json.Unmarshal(*v, &userCreateParameterProperties)
				if err != nil {
					return err
				}
				ucp.UserCreateParameterProperties = &userCreateParameterProperties
			}
		}
	}

	return nil
}

// UserEntityBaseParameters user Entity Base Parameters set.
type UserEntityBaseParameters struct {
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateActive', 'UserStateBlocked', 'UserStatePending', 'UserStateDeleted'
	State UserState `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
	// Identities - Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// UserIdentityCollection list of Users Identity list representation.
type UserIdentityCollection struct {
	autorest.Response `json:"-"`
	// Value - User Identity values.
	Value *[]UserIdentityContract `json:"value,omitempty"`
	// Count - Total record count number across all pages.
	Count *int64 `json:"count,omitempty"`
	// NextLink - Next page link if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserIdentityCollectionIterator provides access to a complete listing of UserIdentityContract values.
type UserIdentityCollectionIterator struct {
	i    int
	page UserIdentityCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserIdentityCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserIdentityCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserIdentityCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserIdentityCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserIdentityCollectionIterator) Response() UserIdentityCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserIdentityCollectionIterator) Value() UserIdentityContract {
	if !iter.page.NotDone() {
		return UserIdentityContract{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserIdentityCollectionIterator type.
func NewUserIdentityCollectionIterator(page UserIdentityCollectionPage) UserIdentityCollectionIterator {
	return UserIdentityCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uic UserIdentityCollection) IsEmpty() bool {
	return uic.Value == nil || len(*uic.Value) == 0
}

// userIdentityCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uic UserIdentityCollection) userIdentityCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if uic.NextLink == nil || len(to.String(uic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uic.NextLink)))
}

// UserIdentityCollectionPage contains a page of UserIdentityContract values.
type UserIdentityCollectionPage struct {
	fn  func(context.Context, UserIdentityCollection) (UserIdentityCollection, error)
	uic UserIdentityCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserIdentityCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserIdentityCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.uic)
	if err != nil {
		return err
	}
	page.uic = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserIdentityCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserIdentityCollectionPage) NotDone() bool {
	return !page.uic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserIdentityCollectionPage) Response() UserIdentityCollection {
	return page.uic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserIdentityCollectionPage) Values() []UserIdentityContract {
	if page.uic.IsEmpty() {
		return nil
	}
	return *page.uic.Value
}

// Creates a new instance of the UserIdentityCollectionPage type.
func NewUserIdentityCollectionPage(getNextPage func(context.Context, UserIdentityCollection) (UserIdentityCollection, error)) UserIdentityCollectionPage {
	return UserIdentityCollectionPage{fn: getNextPage}
}

// UserIdentityContract user identity details.
type UserIdentityContract struct {
	// Provider - Identity provider name.
	Provider *string `json:"provider,omitempty"`
	// ID - Identifier value within provider.
	ID *string `json:"id,omitempty"`
}

// UserTokenParameters parameters supplied to the Get User Token operation.
type UserTokenParameters struct {
	// KeyType - The Key to be used to generate token for user. Possible values include: 'Primary', 'Secondary'
	KeyType KeyType `json:"keyType,omitempty"`
	// Expiry - The Expiry time of the Token. Maximum token expiry time is set to 30 days. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
	Expiry *date.Time `json:"expiry,omitempty"`
}

// UserTokenResult get User Token response details.
type UserTokenResult struct {
	autorest.Response `json:"-"`
	// Value - Shared Access Authorization token for the User.
	Value *string `json:"value,omitempty"`
}

// UserUpdateParameters user update parameters.
type UserUpdateParameters struct {
	// UserUpdateParametersProperties - User entity update contract properties.
	*UserUpdateParametersProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UserUpdateParameters.
func (uup UserUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uup.UserUpdateParametersProperties != nil {
		objectMap["properties"] = uup.UserUpdateParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserUpdateParameters struct.
func (uup *UserUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userUpdateParametersProperties UserUpdateParametersProperties
				err = json.Unmarshal(*v, &userUpdateParametersProperties)
				if err != nil {
					return err
				}
				uup.UserUpdateParametersProperties = &userUpdateParametersProperties
			}
		}
	}

	return nil
}

// UserUpdateParametersProperties parameters supplied to the Update User operation.
type UserUpdateParametersProperties struct {
	// Email - Email address. Must not be empty and must be unique within the service instance.
	Email *string `json:"email,omitempty"`
	// Password - User Password.
	Password *string `json:"password,omitempty"`
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// State - Account state. Specifies whether the user is active or not. Blocked users are unable to sign into the developer portal or call any APIs of subscribed products. Default state is Active. Possible values include: 'UserStateActive', 'UserStateBlocked', 'UserStatePending', 'UserStateDeleted'
	State UserState `json:"state,omitempty"`
	// Note - Optional note about a user set by the administrator.
	Note *string `json:"note,omitempty"`
	// Identities - Collection of user identities.
	Identities *[]UserIdentityContract `json:"identities,omitempty"`
}

// VirtualNetworkConfiguration configuration of a virtual network to which API Management service is
// deployed.
type VirtualNetworkConfiguration struct {
	// Vnetid - The virtual network ID. This is typically a GUID. Expect a null GUID by default.
	Vnetid *string `json:"vnetid,omitempty"`
	// Subnetname - The name of the subnet.
	Subnetname *string `json:"subnetname,omitempty"`
	// SubnetResourceID - The full resource ID of a subnet in a virtual network to deploy the API Management service in.
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`
}

// X509CertificateName properties of server X509Names.
type X509CertificateName struct {
	// Name - Common Name of the Certificate.
	Name *string `json:"name,omitempty"`
	// IssuerCertificateThumbprint - Thumbprint for the Issuer of the Certificate.
	IssuerCertificateThumbprint *string `json:"issuerCertificateThumbprint,omitempty"`
}
