package datamigration

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/datamigration/mgmt/2017-11-15-preview/datamigration"

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// ActiveDirectoryIntegrated ...
	ActiveDirectoryIntegrated AuthenticationType = "ActiveDirectoryIntegrated"
	// ActiveDirectoryPassword ...
	ActiveDirectoryPassword AuthenticationType = "ActiveDirectoryPassword"
	// None ...
	None AuthenticationType = "None"
	// SQLAuthentication ...
	SQLAuthentication AuthenticationType = "SqlAuthentication"
	// WindowsAuthentication ...
	WindowsAuthentication AuthenticationType = "WindowsAuthentication"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{ActiveDirectoryIntegrated, ActiveDirectoryPassword, None, SQLAuthentication, WindowsAuthentication}
}

// DatabaseCompatLevel enumerates the values for database compat level.
type DatabaseCompatLevel string

const (
	// CompatLevel100 ...
	CompatLevel100 DatabaseCompatLevel = "CompatLevel100"
	// CompatLevel110 ...
	CompatLevel110 DatabaseCompatLevel = "CompatLevel110"
	// CompatLevel120 ...
	CompatLevel120 DatabaseCompatLevel = "CompatLevel120"
	// CompatLevel130 ...
	CompatLevel130 DatabaseCompatLevel = "CompatLevel130"
	// CompatLevel140 ...
	CompatLevel140 DatabaseCompatLevel = "CompatLevel140"
	// CompatLevel80 ...
	CompatLevel80 DatabaseCompatLevel = "CompatLevel80"
	// CompatLevel90 ...
	CompatLevel90 DatabaseCompatLevel = "CompatLevel90"
)

// PossibleDatabaseCompatLevelValues returns an array of possible values for the DatabaseCompatLevel const type.
func PossibleDatabaseCompatLevelValues() []DatabaseCompatLevel {
	return []DatabaseCompatLevel{CompatLevel100, CompatLevel110, CompatLevel120, CompatLevel130, CompatLevel140, CompatLevel80, CompatLevel90}
}

// DatabaseFileType enumerates the values for database file type.
type DatabaseFileType string

const (
	// Filestream ...
	Filestream DatabaseFileType = "Filestream"
	// Fulltext ...
	Fulltext DatabaseFileType = "Fulltext"
	// Log ...
	Log DatabaseFileType = "Log"
	// NotSupported ...
	NotSupported DatabaseFileType = "NotSupported"
	// Rows ...
	Rows DatabaseFileType = "Rows"
)

// PossibleDatabaseFileTypeValues returns an array of possible values for the DatabaseFileType const type.
func PossibleDatabaseFileTypeValues() []DatabaseFileType {
	return []DatabaseFileType{Filestream, Fulltext, Log, NotSupported, Rows}
}

// DatabaseMigrationStage enumerates the values for database migration stage.
type DatabaseMigrationStage string

const (
	// DatabaseMigrationStageBackup ...
	DatabaseMigrationStageBackup DatabaseMigrationStage = "Backup"
	// DatabaseMigrationStageCompleted ...
	DatabaseMigrationStageCompleted DatabaseMigrationStage = "Completed"
	// DatabaseMigrationStageFileCopy ...
	DatabaseMigrationStageFileCopy DatabaseMigrationStage = "FileCopy"
	// DatabaseMigrationStageInitialize ...
	DatabaseMigrationStageInitialize DatabaseMigrationStage = "Initialize"
	// DatabaseMigrationStageNone ...
	DatabaseMigrationStageNone DatabaseMigrationStage = "None"
	// DatabaseMigrationStageRestore ...
	DatabaseMigrationStageRestore DatabaseMigrationStage = "Restore"
)

// PossibleDatabaseMigrationStageValues returns an array of possible values for the DatabaseMigrationStage const type.
func PossibleDatabaseMigrationStageValues() []DatabaseMigrationStage {
	return []DatabaseMigrationStage{DatabaseMigrationStageBackup, DatabaseMigrationStageCompleted, DatabaseMigrationStageFileCopy, DatabaseMigrationStageInitialize, DatabaseMigrationStageNone, DatabaseMigrationStageRestore}
}

// DatabaseState enumerates the values for database state.
type DatabaseState string

const (
	// Copying ...
	Copying DatabaseState = "Copying"
	// Emergency ...
	Emergency DatabaseState = "Emergency"
	// Offline ...
	Offline DatabaseState = "Offline"
	// OfflineSecondary ...
	OfflineSecondary DatabaseState = "OfflineSecondary"
	// Online ...
	Online DatabaseState = "Online"
	// Recovering ...
	Recovering DatabaseState = "Recovering"
	// RecoveryPending ...
	RecoveryPending DatabaseState = "RecoveryPending"
	// Restoring ...
	Restoring DatabaseState = "Restoring"
	// Suspect ...
	Suspect DatabaseState = "Suspect"
)

// PossibleDatabaseStateValues returns an array of possible values for the DatabaseState const type.
func PossibleDatabaseStateValues() []DatabaseState {
	return []DatabaseState{Copying, Emergency, Offline, OfflineSecondary, Online, Recovering, RecoveryPending, Restoring, Suspect}
}

// ErrorType enumerates the values for error type.
type ErrorType string

const (
	// ErrorTypeDefault ...
	ErrorTypeDefault ErrorType = "Default"
	// ErrorTypeError ...
	ErrorTypeError ErrorType = "Error"
	// ErrorTypeWarning ...
	ErrorTypeWarning ErrorType = "Warning"
)

// PossibleErrorTypeValues returns an array of possible values for the ErrorType const type.
func PossibleErrorTypeValues() []ErrorType {
	return []ErrorType{ErrorTypeDefault, ErrorTypeError, ErrorTypeWarning}
}

// MigrationState enumerates the values for migration state.
type MigrationState string

const (
	// MigrationStateCompleted ...
	MigrationStateCompleted MigrationState = "Completed"
	// MigrationStateFailed ...
	MigrationStateFailed MigrationState = "Failed"
	// MigrationStateInProgress ...
	MigrationStateInProgress MigrationState = "InProgress"
	// MigrationStateNone ...
	MigrationStateNone MigrationState = "None"
	// MigrationStateSkipped ...
	MigrationStateSkipped MigrationState = "Skipped"
	// MigrationStateStopped ...
	MigrationStateStopped MigrationState = "Stopped"
	// MigrationStateWarning ...
	MigrationStateWarning MigrationState = "Warning"
)

// PossibleMigrationStateValues returns an array of possible values for the MigrationState const type.
func PossibleMigrationStateValues() []MigrationState {
	return []MigrationState{MigrationStateCompleted, MigrationStateFailed, MigrationStateInProgress, MigrationStateNone, MigrationStateSkipped, MigrationStateStopped, MigrationStateWarning}
}

// MigrationStatus enumerates the values for migration status.
type MigrationStatus string

const (
	// MigrationStatusCompleted ...
	MigrationStatusCompleted MigrationStatus = "Completed"
	// MigrationStatusCompletedWithWarnings ...
	MigrationStatusCompletedWithWarnings MigrationStatus = "CompletedWithWarnings"
	// MigrationStatusConfigured ...
	MigrationStatusConfigured MigrationStatus = "Configured"
	// MigrationStatusConnecting ...
	MigrationStatusConnecting MigrationStatus = "Connecting"
	// MigrationStatusDefault ...
	MigrationStatusDefault MigrationStatus = "Default"
	// MigrationStatusError ...
	MigrationStatusError MigrationStatus = "Error"
	// MigrationStatusRunning ...
	MigrationStatusRunning MigrationStatus = "Running"
	// MigrationStatusSelectLogins ...
	MigrationStatusSelectLogins MigrationStatus = "SelectLogins"
	// MigrationStatusSourceAndTargetSelected ...
	MigrationStatusSourceAndTargetSelected MigrationStatus = "SourceAndTargetSelected"
	// MigrationStatusStopped ...
	MigrationStatusStopped MigrationStatus = "Stopped"
)

// PossibleMigrationStatusValues returns an array of possible values for the MigrationStatus const type.
func PossibleMigrationStatusValues() []MigrationStatus {
	return []MigrationStatus{MigrationStatusCompleted, MigrationStatusCompletedWithWarnings, MigrationStatusConfigured, MigrationStatusConnecting, MigrationStatusDefault, MigrationStatusError, MigrationStatusRunning, MigrationStatusSelectLogins, MigrationStatusSourceAndTargetSelected, MigrationStatusStopped}
}

// NameCheckFailureReason enumerates the values for name check failure reason.
type NameCheckFailureReason string

const (
	// AlreadyExists ...
	AlreadyExists NameCheckFailureReason = "AlreadyExists"
	// Invalid ...
	Invalid NameCheckFailureReason = "Invalid"
)

// PossibleNameCheckFailureReasonValues returns an array of possible values for the NameCheckFailureReason const type.
func PossibleNameCheckFailureReasonValues() []NameCheckFailureReason {
	return []NameCheckFailureReason{AlreadyExists, Invalid}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// Function ...
	Function ObjectType = "Function"
	// StoredProcedures ...
	StoredProcedures ObjectType = "StoredProcedures"
	// Table ...
	Table ObjectType = "Table"
	// User ...
	User ObjectType = "User"
	// View ...
	View ObjectType = "View"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{Function, StoredProcedures, Table, User, View}
}

// ProjectProvisioningState enumerates the values for project provisioning state.
type ProjectProvisioningState string

const (
	// Deleting ...
	Deleting ProjectProvisioningState = "Deleting"
	// Succeeded ...
	Succeeded ProjectProvisioningState = "Succeeded"
)

// PossibleProjectProvisioningStateValues returns an array of possible values for the ProjectProvisioningState const type.
func PossibleProjectProvisioningStateValues() []ProjectProvisioningState {
	return []ProjectProvisioningState{Deleting, Succeeded}
}

// ProjectSourcePlatform enumerates the values for project source platform.
type ProjectSourcePlatform string

const (
	// SQL ...
	SQL ProjectSourcePlatform = "SQL"
	// Unknown ...
	Unknown ProjectSourcePlatform = "Unknown"
)

// PossibleProjectSourcePlatformValues returns an array of possible values for the ProjectSourcePlatform const type.
func PossibleProjectSourcePlatformValues() []ProjectSourcePlatform {
	return []ProjectSourcePlatform{SQL, Unknown}
}

// ProjectTargetPlatform enumerates the values for project target platform.
type ProjectTargetPlatform string

const (
	// ProjectTargetPlatformSQLDB ...
	ProjectTargetPlatformSQLDB ProjectTargetPlatform = "SQLDB"
	// ProjectTargetPlatformUnknown ...
	ProjectTargetPlatformUnknown ProjectTargetPlatform = "Unknown"
)

// PossibleProjectTargetPlatformValues returns an array of possible values for the ProjectTargetPlatform const type.
func PossibleProjectTargetPlatformValues() []ProjectTargetPlatform {
	return []ProjectTargetPlatform{ProjectTargetPlatformSQLDB, ProjectTargetPlatformUnknown}
}

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// ResourceSkuCapacityScaleTypeAutomatic ...
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = "Automatic"
	// ResourceSkuCapacityScaleTypeManual ...
	ResourceSkuCapacityScaleTypeManual ResourceSkuCapacityScaleType = "Manual"
	// ResourceSkuCapacityScaleTypeNone ...
	ResourceSkuCapacityScaleTypeNone ResourceSkuCapacityScaleType = "None"
)

// PossibleResourceSkuCapacityScaleTypeValues returns an array of possible values for the ResourceSkuCapacityScaleType const type.
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return []ResourceSkuCapacityScaleType{ResourceSkuCapacityScaleTypeAutomatic, ResourceSkuCapacityScaleTypeManual, ResourceSkuCapacityScaleTypeNone}
}

// ResourceSkuRestrictionsReasonCode enumerates the values for resource sku restrictions reason code.
type ResourceSkuRestrictionsReasonCode string

const (
	// NotAvailableForSubscription ...
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// QuotaID ...
	QuotaID ResourceSkuRestrictionsReasonCode = "QuotaId"
)

// PossibleResourceSkuRestrictionsReasonCodeValues returns an array of possible values for the ResourceSkuRestrictionsReasonCode const type.
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return []ResourceSkuRestrictionsReasonCode{NotAvailableForSubscription, QuotaID}
}

// ResourceSkuRestrictionsType enumerates the values for resource sku restrictions type.
type ResourceSkuRestrictionsType string

const (
	// Location ...
	Location ResourceSkuRestrictionsType = "location"
)

// PossibleResourceSkuRestrictionsTypeValues returns an array of possible values for the ResourceSkuRestrictionsType const type.
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return []ResourceSkuRestrictionsType{Location}
}

// ResultType enumerates the values for result type.
type ResultType string

const (
	// ResultTypeDatabaseLevelOutput ...
	ResultTypeDatabaseLevelOutput ResultType = "DatabaseLevelOutput"
	// ResultTypeErrorOutput ...
	ResultTypeErrorOutput ResultType = "ErrorOutput"
	// ResultTypeMigrateSQLServerSQLDbTaskOutput ...
	ResultTypeMigrateSQLServerSQLDbTaskOutput ResultType = "MigrateSqlServerSqlDbTaskOutput"
	// ResultTypeMigrationLevelOutput ...
	ResultTypeMigrationLevelOutput ResultType = "MigrationLevelOutput"
	// ResultTypeTableLevelOutput ...
	ResultTypeTableLevelOutput ResultType = "TableLevelOutput"
)

// PossibleResultTypeValues returns an array of possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{ResultTypeDatabaseLevelOutput, ResultTypeErrorOutput, ResultTypeMigrateSQLServerSQLDbTaskOutput, ResultTypeMigrationLevelOutput, ResultTypeTableLevelOutput}
}

// ResultTypeBasicConnectToSourceSQLServerTaskOutput enumerates the values for result type basic connect to
// source sql server task output.
type ResultTypeBasicConnectToSourceSQLServerTaskOutput string

const (
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "ConnectToSourceSqlServerTaskOutput"
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "TaskLevelOutput"
)

// PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues returns an array of possible values for the ResultTypeBasicConnectToSourceSQLServerTaskOutput const type.
func PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues() []ResultTypeBasicConnectToSourceSQLServerTaskOutput {
	return []ResultTypeBasicConnectToSourceSQLServerTaskOutput{ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput, ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput}
}

// ServerLevelPermissionsGroup enumerates the values for server level permissions group.
type ServerLevelPermissionsGroup string

const (
	// Default ...
	Default ServerLevelPermissionsGroup = "Default"
	// MigrationFromSQLServerToAzureDB ...
	MigrationFromSQLServerToAzureDB ServerLevelPermissionsGroup = "MigrationFromSqlServerToAzureDB"
)

// PossibleServerLevelPermissionsGroupValues returns an array of possible values for the ServerLevelPermissionsGroup const type.
func PossibleServerLevelPermissionsGroupValues() []ServerLevelPermissionsGroup {
	return []ServerLevelPermissionsGroup{Default, MigrationFromSQLServerToAzureDB}
}

// ServiceProvisioningState enumerates the values for service provisioning state.
type ServiceProvisioningState string

const (
	// ServiceProvisioningStateAccepted ...
	ServiceProvisioningStateAccepted ServiceProvisioningState = "Accepted"
	// ServiceProvisioningStateDeleting ...
	ServiceProvisioningStateDeleting ServiceProvisioningState = "Deleting"
	// ServiceProvisioningStateDeploying ...
	ServiceProvisioningStateDeploying ServiceProvisioningState = "Deploying"
	// ServiceProvisioningStateFailed ...
	ServiceProvisioningStateFailed ServiceProvisioningState = "Failed"
	// ServiceProvisioningStateFailedToStart ...
	ServiceProvisioningStateFailedToStart ServiceProvisioningState = "FailedToStart"
	// ServiceProvisioningStateFailedToStop ...
	ServiceProvisioningStateFailedToStop ServiceProvisioningState = "FailedToStop"
	// ServiceProvisioningStateStarting ...
	ServiceProvisioningStateStarting ServiceProvisioningState = "Starting"
	// ServiceProvisioningStateStopped ...
	ServiceProvisioningStateStopped ServiceProvisioningState = "Stopped"
	// ServiceProvisioningStateStopping ...
	ServiceProvisioningStateStopping ServiceProvisioningState = "Stopping"
	// ServiceProvisioningStateSucceeded ...
	ServiceProvisioningStateSucceeded ServiceProvisioningState = "Succeeded"
)

// PossibleServiceProvisioningStateValues returns an array of possible values for the ServiceProvisioningState const type.
func PossibleServiceProvisioningStateValues() []ServiceProvisioningState {
	return []ServiceProvisioningState{ServiceProvisioningStateAccepted, ServiceProvisioningStateDeleting, ServiceProvisioningStateDeploying, ServiceProvisioningStateFailed, ServiceProvisioningStateFailedToStart, ServiceProvisioningStateFailedToStop, ServiceProvisioningStateStarting, ServiceProvisioningStateStopped, ServiceProvisioningStateStopping, ServiceProvisioningStateSucceeded}
}

// ServiceScalability enumerates the values for service scalability.
type ServiceScalability string

const (
	// ServiceScalabilityAutomatic ...
	ServiceScalabilityAutomatic ServiceScalability = "automatic"
	// ServiceScalabilityManual ...
	ServiceScalabilityManual ServiceScalability = "manual"
	// ServiceScalabilityNone ...
	ServiceScalabilityNone ServiceScalability = "none"
)

// PossibleServiceScalabilityValues returns an array of possible values for the ServiceScalability const type.
func PossibleServiceScalabilityValues() []ServiceScalability {
	return []ServiceScalability{ServiceScalabilityAutomatic, ServiceScalabilityManual, ServiceScalabilityNone}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityError ...
	SeverityError Severity = "Error"
	// SeverityMessage ...
	SeverityMessage Severity = "Message"
	// SeverityWarning ...
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityError, SeverityMessage, SeverityWarning}
}

// TaskState enumerates the values for task state.
type TaskState string

const (
	// TaskStateCanceled ...
	TaskStateCanceled TaskState = "Canceled"
	// TaskStateFailed ...
	TaskStateFailed TaskState = "Failed"
	// TaskStateFailedInputValidation ...
	TaskStateFailedInputValidation TaskState = "FailedInputValidation"
	// TaskStateFaulted ...
	TaskStateFaulted TaskState = "Faulted"
	// TaskStateQueued ...
	TaskStateQueued TaskState = "Queued"
	// TaskStateRunning ...
	TaskStateRunning TaskState = "Running"
	// TaskStateSucceeded ...
	TaskStateSucceeded TaskState = "Succeeded"
	// TaskStateUnknown ...
	TaskStateUnknown TaskState = "Unknown"
)

// PossibleTaskStateValues returns an array of possible values for the TaskState const type.
func PossibleTaskStateValues() []TaskState {
	return []TaskState{TaskStateCanceled, TaskStateFailed, TaskStateFailedInputValidation, TaskStateFaulted, TaskStateQueued, TaskStateRunning, TaskStateSucceeded, TaskStateUnknown}
}

// TaskType enumerates the values for task type.
type TaskType string

const (
	// TaskTypeConnectToSourceSQLServer ...
	TaskTypeConnectToSourceSQLServer TaskType = "ConnectToSource.SqlServer"
	// TaskTypeConnectToTargetSQLDb ...
	TaskTypeConnectToTargetSQLDb TaskType = "ConnectToTarget.SqlDb"
	// TaskTypeGetUserTablesSQL ...
	TaskTypeGetUserTablesSQL TaskType = "GetUserTables.Sql"
	// TaskTypeMigrateSQLServerSQLDb ...
	TaskTypeMigrateSQLServerSQLDb TaskType = "Migrate.SqlServer.SqlDb"
	// TaskTypeUnknown ...
	TaskTypeUnknown TaskType = "Unknown"
)

// PossibleTaskTypeValues returns an array of possible values for the TaskType const type.
func PossibleTaskTypeValues() []TaskType {
	return []TaskType{TaskTypeConnectToSourceSQLServer, TaskTypeConnectToTargetSQLDb, TaskTypeGetUserTablesSQL, TaskTypeMigrateSQLServerSQLDb, TaskTypeUnknown}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeSQLConnectionInfo ...
	TypeSQLConnectionInfo Type = "SqlConnectionInfo"
	// TypeUnknown ...
	TypeUnknown Type = "Unknown"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeSQLConnectionInfo, TypeUnknown}
}

// UpdateActionType enumerates the values for update action type.
type UpdateActionType string

const (
	// AddedOnTarget ...
	AddedOnTarget UpdateActionType = "AddedOnTarget"
	// ChangedOnTarget ...
	ChangedOnTarget UpdateActionType = "ChangedOnTarget"
	// DeletedOnTarget ...
	DeletedOnTarget UpdateActionType = "DeletedOnTarget"
)

// PossibleUpdateActionTypeValues returns an array of possible values for the UpdateActionType const type.
func PossibleUpdateActionTypeValues() []UpdateActionType {
	return []UpdateActionType{AddedOnTarget, ChangedOnTarget, DeletedOnTarget}
}

// ValidationStatus enumerates the values for validation status.
type ValidationStatus string

const (
	// ValidationStatusCompleted ...
	ValidationStatusCompleted ValidationStatus = "Completed"
	// ValidationStatusCompletedWithIssues ...
	ValidationStatusCompletedWithIssues ValidationStatus = "CompletedWithIssues"
	// ValidationStatusDefault ...
	ValidationStatusDefault ValidationStatus = "Default"
	// ValidationStatusFailed ...
	ValidationStatusFailed ValidationStatus = "Failed"
	// ValidationStatusInitialized ...
	ValidationStatusInitialized ValidationStatus = "Initialized"
	// ValidationStatusInProgress ...
	ValidationStatusInProgress ValidationStatus = "InProgress"
	// ValidationStatusNotStarted ...
	ValidationStatusNotStarted ValidationStatus = "NotStarted"
	// ValidationStatusStopped ...
	ValidationStatusStopped ValidationStatus = "Stopped"
)

// PossibleValidationStatusValues returns an array of possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{ValidationStatusCompleted, ValidationStatusCompletedWithIssues, ValidationStatusDefault, ValidationStatusFailed, ValidationStatusInitialized, ValidationStatusInProgress, ValidationStatusNotStarted, ValidationStatusStopped}
}

// APIError error information.
type APIError struct {
	// Error - Error information in OData format
	Error *ODataError `json:"error,omitempty"`
}

// AvailableServiceSku describes the available service SKU.
type AvailableServiceSku struct {
	// ResourceType - The resource type, including the provider namespace
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - SKU name, tier, etc.
	Sku *AvailableServiceSkuSku `json:"sku,omitempty"`
	// Capacity - A description of the scaling capacities of the SKU
	Capacity *AvailableServiceSkuCapacity `json:"capacity,omitempty"`
}

// AvailableServiceSkuCapacity a description of the scaling capacities of the SKU
type AvailableServiceSkuCapacity struct {
	// Minimum - The minimum capacity, usually 0 or 1.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - The maximum capacity
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - The default capacity
	Default *int32 `json:"default,omitempty"`
	// ScaleType - The scalability approach. Possible values include: 'ServiceScalabilityNone', 'ServiceScalabilityManual', 'ServiceScalabilityAutomatic'
	ScaleType ServiceScalability `json:"scaleType,omitempty"`
}

// AvailableServiceSkuSku SKU name, tier, etc.
type AvailableServiceSkuSku struct {
	// Name - The name of the SKU
	Name *string `json:"name,omitempty"`
	// Family - SKU family
	Family *string `json:"family,omitempty"`
	// Size - SKU size
	Size *string `json:"size,omitempty"`
	// Tier - The tier of the SKU, such as "Free", "Basic", "Standard", or "Premium"
	Tier *string `json:"tier,omitempty"`
}

// BasicConnectionInfo defines the connection properties of a server
type BasicConnectionInfo interface {
	AsSQLConnectionInfo() (*SQLConnectionInfo, bool)
	AsConnectionInfo() (*ConnectionInfo, bool)
}

// ConnectionInfo defines the connection properties of a server
type ConnectionInfo struct {
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeUnknown', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicConnectionInfo(body []byte) (BasicConnectionInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeSQLConnectionInfo):
		var sci SQLConnectionInfo
		err := json.Unmarshal(body, &sci)
		return sci, err
	default:
		var ci ConnectionInfo
		err := json.Unmarshal(body, &ci)
		return ci, err
	}
}
func unmarshalBasicConnectionInfoArray(body []byte) ([]BasicConnectionInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ciArray := make([]BasicConnectionInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ci, err := unmarshalBasicConnectionInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		ciArray[index] = ci
	}
	return ciArray, nil
}

// MarshalJSON is the custom marshaler for ConnectionInfo.
func (ci ConnectionInfo) MarshalJSON() ([]byte, error) {
	ci.Type = TypeUnknown
	objectMap := make(map[string]interface{})
	if ci.UserName != nil {
		objectMap["userName"] = ci.UserName
	}
	if ci.Password != nil {
		objectMap["password"] = ci.Password
	}
	if ci.Type != "" {
		objectMap["type"] = ci.Type
	}
	return json.Marshal(objectMap)
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return &ci, true
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &ci, true
}

// ConnectToSourceSQLServerTaskInput input for the task that validates connection to SQL Server and also
// validates source server requirements
type ConnectToSourceSQLServerTaskInput struct {
	// SourceConnectionInfo - Connection information for Source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// CheckPermissionsGroup - Permission group for validations. Possible values include: 'Default', 'MigrationFromSQLServerToAzureDB'
	CheckPermissionsGroup ServerLevelPermissionsGroup `json:"checkPermissionsGroup,omitempty"`
}

// BasicConnectToSourceSQLServerTaskOutput output for the task that validates connection to SQL Server and also
// validates source server requirements
type BasicConnectToSourceSQLServerTaskOutput interface {
	AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool)
	AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool)
	AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool)
}

// ConnectToSourceSQLServerTaskOutput output for the task that validates connection to SQL Server and also
// validates source server requirements
type ConnectToSourceSQLServerTaskOutput struct {
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicConnectToSourceSQLServerTaskOutput(body []byte) (BasicConnectToSourceSQLServerTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput):
		var ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &ctssstodl)
		return ctssstodl, err
	case string(ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput):
		var ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel
		err := json.Unmarshal(body, &ctssstotl)
		return ctssstotl, err
	default:
		var ctsssto ConnectToSourceSQLServerTaskOutput
		err := json.Unmarshal(body, &ctsssto)
		return ctsssto, err
	}
}
func unmarshalBasicConnectToSourceSQLServerTaskOutputArray(body []byte) ([]BasicConnectToSourceSQLServerTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ctssstoArray := make([]BasicConnectToSourceSQLServerTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ctsssto, err := unmarshalBasicConnectToSourceSQLServerTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		ctssstoArray[index] = ctsssto
	}
	return ctssstoArray, nil
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) MarshalJSON() ([]byte, error) {
	ctsssto.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput
	objectMap := make(map[string]interface{})
	if ctsssto.ID != nil {
		objectMap["id"] = ctsssto.ID
	}
	if ctsssto.ResultType != "" {
		objectMap["resultType"] = ctsssto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return &ctsssto, true
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctsssto, true
}

// ConnectToSourceSQLServerTaskOutputDatabaseLevel database level output for the task that validates
// connection to SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputDatabaseLevel struct {
	// Name - Database name
	Name *string `json:"name,omitempty"`
	// SizeMB - Size of the file in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// DatabaseFiles - The list of database files
	DatabaseFiles *[]DatabaseFileInfo `json:"databaseFiles,omitempty"`
	// CompatibilityLevel - SQL Server compatibility level of database. Possible values include: 'CompatLevel80', 'CompatLevel90', 'CompatLevel100', 'CompatLevel110', 'CompatLevel120', 'CompatLevel130', 'CompatLevel140'
	CompatibilityLevel DatabaseCompatLevel `json:"compatibilityLevel,omitempty"`
	// DatabaseState - State of the database. Possible values include: 'Online', 'Restoring', 'Recovering', 'RecoveryPending', 'Suspect', 'Emergency', 'Offline', 'Copying', 'OfflineSecondary'
	DatabaseState DatabaseState `json:"databaseState,omitempty"`
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	ctssstodl.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstodl.Name != nil {
		objectMap["name"] = ctssstodl.Name
	}
	if ctssstodl.SizeMB != nil {
		objectMap["sizeMB"] = ctssstodl.SizeMB
	}
	if ctssstodl.DatabaseFiles != nil {
		objectMap["databaseFiles"] = ctssstodl.DatabaseFiles
	}
	if ctssstodl.CompatibilityLevel != "" {
		objectMap["compatibilityLevel"] = ctssstodl.CompatibilityLevel
	}
	if ctssstodl.DatabaseState != "" {
		objectMap["databaseState"] = ctssstodl.DatabaseState
	}
	if ctssstodl.ID != nil {
		objectMap["id"] = ctssstodl.ID
	}
	if ctssstodl.ResultType != "" {
		objectMap["resultType"] = ctssstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return &ctssstodl, true
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstodl, true
}

// ConnectToSourceSQLServerTaskOutputTaskLevel task level output for the task that validates connection to
// SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputTaskLevel struct {
	// Databases - Source databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// SourceServerVersion - Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// ValidationErrors - Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) MarshalJSON() ([]byte, error) {
	ctssstotl.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstotl.Databases != nil {
		objectMap["databases"] = ctssstotl.Databases
	}
	if ctssstotl.SourceServerVersion != nil {
		objectMap["sourceServerVersion"] = ctssstotl.SourceServerVersion
	}
	if ctssstotl.SourceServerBrandVersion != nil {
		objectMap["sourceServerBrandVersion"] = ctssstotl.SourceServerBrandVersion
	}
	if ctssstotl.ValidationErrors != nil {
		objectMap["validationErrors"] = ctssstotl.ValidationErrors
	}
	if ctssstotl.ID != nil {
		objectMap["id"] = ctssstotl.ID
	}
	if ctssstotl.ResultType != "" {
		objectMap["resultType"] = ctssstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return &ctssstotl, true
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstotl, true
}

// ConnectToSourceSQLServerTaskProperties properties for the task that validates connection to SQL Server
// and also validates source server requirements
type ConnectToSourceSQLServerTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourceSQLServerTaskInput `json:"input,omitempty"`
	// Output - Task output. This is ignored if submitted.
	Output *[]BasicConnectToSourceSQLServerTaskOutput `json:"output,omitempty"`
	// Errors - Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) MarshalJSON() ([]byte, error) {
	ctssstp.TaskType = TaskTypeConnectToSourceSQLServer
	objectMap := make(map[string]interface{})
	if ctssstp.Input != nil {
		objectMap["input"] = ctssstp.Input
	}
	if ctssstp.Output != nil {
		objectMap["output"] = ctssstp.Output
	}
	if ctssstp.Errors != nil {
		objectMap["errors"] = ctssstp.Errors
	}
	if ctssstp.State != "" {
		objectMap["state"] = ctssstp.State
	}
	if ctssstp.TaskType != "" {
		objectMap["taskType"] = ctssstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return &ctssstp, true
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctssstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourceSQLServerTaskProperties struct.
func (ctssstp *ConnectToSourceSQLServerTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourceSQLServerTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctssstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicConnectToSourceSQLServerTaskOutputArray(*v)
				if err != nil {
					return err
				}
				ctssstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctssstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctssstp.State = state
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctssstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetSQLDbTaskInput input for the task that validates connection to SQL DB and target server
// requirements
type ConnectToTargetSQLDbTaskInput struct {
	// TargetConnectionInfo - Connection information for target SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLDbTaskOutput output for the task that validates connection to SQL DB and target server
// requirements
type ConnectToTargetSQLDbTaskOutput struct {
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// Databases - Source databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// TargetServerVersion - Version of the target server
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLDbTaskOutput.
func (cttsdto ConnectToTargetSQLDbTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cttsdto.ID != nil {
		objectMap["id"] = cttsdto.ID
	}
	if cttsdto.Databases != nil {
		objectMap["databases"] = cttsdto.Databases
	}
	if cttsdto.TargetServerVersion != nil {
		objectMap["targetServerVersion"] = cttsdto.TargetServerVersion
	}
	if cttsdto.TargetServerBrandVersion != nil {
		objectMap["targetServerBrandVersion"] = cttsdto.TargetServerBrandVersion
	}
	return json.Marshal(objectMap)
}

// ConnectToTargetSQLDbTaskProperties properties for the task that validates connection to SQL DB and
// target server requirements
type ConnectToTargetSQLDbTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLDbTaskInput `json:"input,omitempty"`
	// Output - Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	cttsdtp.TaskType = TaskTypeConnectToTargetSQLDb
	objectMap := make(map[string]interface{})
	if cttsdtp.Input != nil {
		objectMap["input"] = cttsdtp.Input
	}
	if cttsdtp.Output != nil {
		objectMap["output"] = cttsdtp.Output
	}
	if cttsdtp.Errors != nil {
		objectMap["errors"] = cttsdtp.Errors
	}
	if cttsdtp.State != "" {
		objectMap["state"] = cttsdtp.State
	}
	if cttsdtp.TaskType != "" {
		objectMap["taskType"] = cttsdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return &cttsdtp, true
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttsdtp, true
}

// Database information about a single database
type Database struct {
	// ID - Unique identifier for the database
	ID *string `json:"id,omitempty"`
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// CompatibilityLevel - SQL Server compatibility level of database. Possible values include: 'CompatLevel80', 'CompatLevel90', 'CompatLevel100', 'CompatLevel110', 'CompatLevel120', 'CompatLevel130', 'CompatLevel140'
	CompatibilityLevel DatabaseCompatLevel `json:"compatibilityLevel,omitempty"`
	// Collation - Collation name of the database
	Collation *string `json:"collation,omitempty"`
	// ServerName - Name of the server
	ServerName *string `json:"serverName,omitempty"`
	// Fqdn - Fully qualified name
	Fqdn *string `json:"fqdn,omitempty"`
	// InstallID - Install id of the database
	InstallID *string `json:"installId,omitempty"`
	// ServerVersion - Version of the server
	ServerVersion *string `json:"serverVersion,omitempty"`
	// ServerEdition - Edition of the server
	ServerEdition *string `json:"serverEdition,omitempty"`
	// ServerLevel - Product level of the server (RTM, SP, CTP).
	ServerLevel *string `json:"serverLevel,omitempty"`
	// ServerDefaultDataPath - Default path of the data files
	ServerDefaultDataPath *string `json:"serverDefaultDataPath,omitempty"`
	// ServerDefaultLogPath - Default path of the log files
	ServerDefaultLogPath *string `json:"serverDefaultLogPath,omitempty"`
	// ServerDefaultBackupPath - Default path of the backup folder
	ServerDefaultBackupPath *string `json:"serverDefaultBackupPath,omitempty"`
	// ServerCoreCount - Number of cores on the server
	ServerCoreCount *int32 `json:"serverCoreCount,omitempty"`
	// ServerVisibleOnlineCoreCount - Number of cores on the server that have VISIBLE ONLINE status
	ServerVisibleOnlineCoreCount *int32 `json:"serverVisibleOnlineCoreCount,omitempty"`
	// DatabaseState - State of the database. Possible values include: 'Online', 'Restoring', 'Recovering', 'RecoveryPending', 'Suspect', 'Emergency', 'Offline', 'Copying', 'OfflineSecondary'
	DatabaseState DatabaseState `json:"databaseState,omitempty"`
	// ServerID - The unique Server Id
	ServerID *string `json:"serverId,omitempty"`
}

// DatabaseFileInfo database file specific information
type DatabaseFileInfo struct {
	// DatabaseName - Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// ID - Unique identifier for database file
	ID *string `json:"id,omitempty"`
	// LogicalName - Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`
	// PhysicalFullName - Operating-system full path of the file
	PhysicalFullName *string `json:"physicalFullName,omitempty"`
	// RestoreFullName - Suggested full path of the file for restoring
	RestoreFullName *string `json:"restoreFullName,omitempty"`
	// FileType - Database file type. Possible values include: 'Rows', 'Log', 'Filestream', 'NotSupported', 'Fulltext'
	FileType DatabaseFileType `json:"fileType,omitempty"`
	// SizeMB - Size of the file in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
}

// DatabaseFileInput database file specific information for input
type DatabaseFileInput struct {
	// ID - Unique identifier for database file
	ID *string `json:"id,omitempty"`
	// LogicalName - Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`
	// PhysicalFullName - Operating-system full path of the file
	PhysicalFullName *string `json:"physicalFullName,omitempty"`
	// RestoreFullName - Suggested full path of the file for restoring
	RestoreFullName *string `json:"restoreFullName,omitempty"`
	// FileType - Database file type. Possible values include: 'Rows', 'Log', 'Filestream', 'NotSupported', 'Fulltext'
	FileType DatabaseFileType `json:"fileType,omitempty"`
}

// DatabaseInfo project Database Details
type DatabaseInfo struct {
	// SourceDatabaseName - Name of the database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
}

// DatabaseObjectName a representation of the name of an object in a database
type DatabaseObjectName struct {
	// DatabaseName - The unescaped name of the database containing the object
	DatabaseName *string `json:"databaseName,omitempty"`
	// ObjectName - The unescaped name of the object
	ObjectName *string `json:"objectName,omitempty"`
	// SchemaName - The unescaped name of the schema containing the object
	SchemaName *string `json:"schemaName,omitempty"`
	// ObjectType - Type of the object in the database. Possible values include: 'StoredProcedures', 'Table', 'User', 'View', 'Function'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// DatabaseSummaryResult summary of database results in the migration
type DatabaseSummaryResult struct {
	// SizeMB - Size of the database in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// Name - Name of the item
	Name *string `json:"name,omitempty"`
	// StartedOn - Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
}

// DatabaseTable table properties
type DatabaseTable struct {
	// HasRows - Indicates whether table is empty or not
	HasRows *bool `json:"hasRows,omitempty"`
	// Name - Schema-qualified name of the table
	Name *string `json:"name,omitempty"`
}

// DataIntegrityValidationResult results for checksum based Data Integrity validation results
type DataIntegrityValidationResult struct {
	// FailedObjects - List of failed table names of source and target pair
	FailedObjects map[string]*string `json:"failedObjects"`
	// ValidationErrors - List of errors that happened while performing data integrity validation
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for DataIntegrityValidationResult.
func (divr DataIntegrityValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if divr.FailedObjects != nil {
		objectMap["failedObjects"] = divr.FailedObjects
	}
	if divr.ValidationErrors != nil {
		objectMap["validationErrors"] = divr.ValidationErrors
	}
	return json.Marshal(objectMap)
}

// DataItemMigrationSummaryResult basic summary of a data item migration
type DataItemMigrationSummaryResult struct {
	// Name - Name of the item
	Name *string `json:"name,omitempty"`
	// StartedOn - Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
}

// Error migration Task errors
type Error struct {
	// Message - Error description
	Message *string `json:"message,omitempty"`
	// Type - Possible values include: 'ErrorTypeDefault', 'ErrorTypeWarning', 'ErrorTypeError'
	Type ErrorType `json:"type,omitempty"`
}

// ExecutionStatistics description about the errors happen while performing migration validation
type ExecutionStatistics struct {
	// ExecutionCount - No. of query executions
	ExecutionCount *int64 `json:"executionCount,omitempty"`
	// CPUTimeMs - CPU Time in millisecond(s) for the query execution
	CPUTimeMs *float64 `json:"cpuTimeMs,omitempty"`
	// ElapsedTimeMs - Time taken in millisecond(s) for executing the query
	ElapsedTimeMs *float64 `json:"elapsedTimeMs,omitempty"`
	// WaitStats - Dictionary of sql query execution wait types and the respective statistics
	WaitStats map[string]*WaitStatistics `json:"waitStats"`
	// HasErrors - Indicates whether the query resulted in an error
	HasErrors *bool `json:"hasErrors,omitempty"`
	// SQLErrors - List of sql Errors
	SQLErrors *[]string `json:"sqlErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for ExecutionStatistics.
func (es ExecutionStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.ExecutionCount != nil {
		objectMap["executionCount"] = es.ExecutionCount
	}
	if es.CPUTimeMs != nil {
		objectMap["cpuTimeMs"] = es.CPUTimeMs
	}
	if es.ElapsedTimeMs != nil {
		objectMap["elapsedTimeMs"] = es.ElapsedTimeMs
	}
	if es.WaitStats != nil {
		objectMap["waitStats"] = es.WaitStats
	}
	if es.HasErrors != nil {
		objectMap["hasErrors"] = es.HasErrors
	}
	if es.SQLErrors != nil {
		objectMap["sqlErrors"] = es.SQLErrors
	}
	return json.Marshal(objectMap)
}

// GetUserTablesSQLTaskInput input for the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskInput struct {
	// ConnectionInfo - Connection information for SQL Server
	ConnectionInfo *SQLConnectionInfo `json:"connectionInfo,omitempty"`
	// SelectedDatabases - List of database names to collect tables for
	SelectedDatabases *[]string `json:"selectedDatabases,omitempty"`
}

// GetUserTablesSQLTaskOutput output of the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskOutput struct {
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// DatabasesToTables - Mapping from database name to list of tables
	DatabasesToTables map[string][]DatabaseTable `json:"databasesToTables"`
	// ValidationErrors - Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLTaskOutput.
func (gutsto GetUserTablesSQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gutsto.ID != nil {
		objectMap["id"] = gutsto.ID
	}
	if gutsto.DatabasesToTables != nil {
		objectMap["databasesToTables"] = gutsto.DatabasesToTables
	}
	if gutsto.ValidationErrors != nil {
		objectMap["validationErrors"] = gutsto.ValidationErrors
	}
	return json.Marshal(objectMap)
}

// GetUserTablesSQLTaskProperties properties for the task that collects user tables for the given list of
// databases
type GetUserTablesSQLTaskProperties struct {
	// Input - Task input
	Input *GetUserTablesSQLTaskInput `json:"input,omitempty"`
	// Output - Task output. This is ignored if submitted.
	Output *[]GetUserTablesSQLTaskOutput `json:"output,omitempty"`
	// Errors - Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) MarshalJSON() ([]byte, error) {
	gutstp.TaskType = TaskTypeGetUserTablesSQL
	objectMap := make(map[string]interface{})
	if gutstp.Input != nil {
		objectMap["input"] = gutstp.Input
	}
	if gutstp.Output != nil {
		objectMap["output"] = gutstp.Output
	}
	if gutstp.Errors != nil {
		objectMap["errors"] = gutstp.Errors
	}
	if gutstp.State != "" {
		objectMap["state"] = gutstp.State
	}
	if gutstp.TaskType != "" {
		objectMap["taskType"] = gutstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return &gutstp, true
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &gutstp, true
}

// MigrateSQLServerSQLDbDatabaseInput database specific information for SQL to Azure SQL DB migration task
// inputs
type MigrateSQLServerSQLDbDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// MakeSourceDbReadOnly - Whether to set database read only before migration
	MakeSourceDbReadOnly *bool `json:"makeSourceDbReadOnly,omitempty"`
	// TableMap - Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbDatabaseInput.
func (msssddi MigrateSQLServerSQLDbDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msssddi.Name != nil {
		objectMap["name"] = msssddi.Name
	}
	if msssddi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = msssddi.TargetDatabaseName
	}
	if msssddi.MakeSourceDbReadOnly != nil {
		objectMap["makeSourceDbReadOnly"] = msssddi.MakeSourceDbReadOnly
	}
	if msssddi.TableMap != nil {
		objectMap["tableMap"] = msssddi.TableMap
	}
	return json.Marshal(objectMap)
}

// MigrateSQLServerSQLDbTaskInput input for the task that migrates on-prem SQL Server databases to Azure
// SQL Database
type MigrateSQLServerSQLDbTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLDbDatabaseInput `json:"selectedDatabases,omitempty"`
	// ValidationOptions - Options for enabling various post migration validations. Available options,
	//  1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data.
	//  2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
	ValidationOptions *MigrationValidationOptions `json:"validationOptions,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSQLServerSQLDbTaskOutput output for the task that migrates on-prem SQL Server databases to Azure SQL
// Database
type BasicMigrateSQLServerSQLDbTaskOutput interface {
	AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool)
	AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool)
}

// MigrateSQLServerSQLDbTaskOutput output for the task that migrates on-prem SQL Server databases to Azure SQL
// Database
type MigrateSQLServerSQLDbTaskOutput struct {
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLDbTaskOutput(body []byte) (BasicMigrateSQLServerSQLDbTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeErrorOutput):
		var msssdtoe MigrateSQLServerSQLDbTaskOutputError
		err := json.Unmarshal(body, &msssdtoe)
		return msssdtoe, err
	case string(ResultTypeTableLevelOutput):
		var msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel
		err := json.Unmarshal(body, &msssdtotl)
		return msssdtotl, err
	case string(ResultTypeDatabaseLevelOutput):
		var msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssdtodl)
		return msssdtodl, err
	case string(ResultTypeMigrationLevelOutput):
		var msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssdtoml)
		return msssdtoml, err
	default:
		var msssdto MigrateSQLServerSQLDbTaskOutput
		err := json.Unmarshal(body, &msssdto)
		return msssdto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLDbTaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLDbTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssdtoArray := make([]BasicMigrateSQLServerSQLDbTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssdto, err := unmarshalBasicMigrateSQLServerSQLDbTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssdtoArray[index] = msssdto
	}
	return msssdtoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) MarshalJSON() ([]byte, error) {
	msssdto.ResultType = ResultTypeMigrateSQLServerSQLDbTaskOutput
	objectMap := make(map[string]interface{})
	if msssdto.ID != nil {
		objectMap["id"] = msssdto.ID
	}
	if msssdto.ResultType != "" {
		objectMap["resultType"] = msssdto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdto, true
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdto, true
}

// MigrateSQLServerSQLDbTaskOutputDatabaseLevel database level result for Sql Server to Azure Sql DB
// migration.
type MigrateSQLServerSQLDbTaskOutputDatabaseLevel struct {
	// DatabaseName - Name of the item
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - Migration stage that this database is in. Possible values include: 'DatabaseMigrationStageNone', 'DatabaseMigrationStageInitialize', 'DatabaseMigrationStageBackup', 'DatabaseMigrationStageFileCopy', 'DatabaseMigrationStageRestore', 'DatabaseMigrationStageCompleted'
	Stage DatabaseMigrationStage `json:"stage,omitempty"`
	// StatusMessage - Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// Message - Migration progress message
	Message *string `json:"message,omitempty"`
	// NumberOfObjects - Number of objects
	NumberOfObjects *int64 `json:"numberOfObjects,omitempty"`
	// NumberOfObjectsCompleted - Number of successfully completed objects
	NumberOfObjectsCompleted *int64 `json:"numberOfObjectsCompleted,omitempty"`
	// ErrorCount - Number of database/object errors.
	ErrorCount *int64 `json:"errorCount,omitempty"`
	// ErrorPrefix - Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
	// ExceptionsAndWarnings - Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ObjectSummary - Summary of object results in the migration
	ObjectSummary map[string]*DataItemMigrationSummaryResult `json:"objectSummary"`
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssdtodl.ResultType = ResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtodl.DatabaseName != nil {
		objectMap["databaseName"] = msssdtodl.DatabaseName
	}
	if msssdtodl.StartedOn != nil {
		objectMap["startedOn"] = msssdtodl.StartedOn
	}
	if msssdtodl.EndedOn != nil {
		objectMap["endedOn"] = msssdtodl.EndedOn
	}
	if msssdtodl.State != "" {
		objectMap["state"] = msssdtodl.State
	}
	if msssdtodl.Stage != "" {
		objectMap["stage"] = msssdtodl.Stage
	}
	if msssdtodl.StatusMessage != nil {
		objectMap["statusMessage"] = msssdtodl.StatusMessage
	}
	if msssdtodl.Message != nil {
		objectMap["message"] = msssdtodl.Message
	}
	if msssdtodl.NumberOfObjects != nil {
		objectMap["numberOfObjects"] = msssdtodl.NumberOfObjects
	}
	if msssdtodl.NumberOfObjectsCompleted != nil {
		objectMap["numberOfObjectsCompleted"] = msssdtodl.NumberOfObjectsCompleted
	}
	if msssdtodl.ErrorCount != nil {
		objectMap["errorCount"] = msssdtodl.ErrorCount
	}
	if msssdtodl.ErrorPrefix != nil {
		objectMap["errorPrefix"] = msssdtodl.ErrorPrefix
	}
	if msssdtodl.ResultPrefix != nil {
		objectMap["resultPrefix"] = msssdtodl.ResultPrefix
	}
	if msssdtodl.ExceptionsAndWarnings != nil {
		objectMap["exceptionsAndWarnings"] = msssdtodl.ExceptionsAndWarnings
	}
	if msssdtodl.ObjectSummary != nil {
		objectMap["objectSummary"] = msssdtodl.ObjectSummary
	}
	if msssdtodl.ID != nil {
		objectMap["id"] = msssdtodl.ID
	}
	if msssdtodl.ResultType != "" {
		objectMap["resultType"] = msssdtodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return &msssdtodl, true
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtodl, true
}

// MigrateSQLServerSQLDbTaskOutputError task errors for Sql Server to Azure Sql DB migration.
type MigrateSQLServerSQLDbTaskOutputError struct {
	// Error - Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) MarshalJSON() ([]byte, error) {
	msssdtoe.ResultType = ResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssdtoe.Error != nil {
		objectMap["error"] = msssdtoe.Error
	}
	if msssdtoe.ID != nil {
		objectMap["id"] = msssdtoe.ID
	}
	if msssdtoe.ResultType != "" {
		objectMap["resultType"] = msssdtoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return &msssdtoe, true
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtoe, true
}

// MigrateSQLServerSQLDbTaskOutputMigrationLevel migration level result for Sql server to Azure Sql DB
// migration.
type MigrateSQLServerSQLDbTaskOutputMigrationLevel struct {
	// StartedOn - Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// DurationInSeconds - Duration of task execution in seconds.
	DurationInSeconds *int64 `json:"durationInSeconds,omitempty"`
	// Status - Current status of migration. Possible values include: 'MigrationStatusDefault', 'MigrationStatusConnecting', 'MigrationStatusSourceAndTargetSelected', 'MigrationStatusSelectLogins', 'MigrationStatusConfigured', 'MigrationStatusRunning', 'MigrationStatusError', 'MigrationStatusStopped', 'MigrationStatusCompleted', 'MigrationStatusCompletedWithWarnings'
	Status MigrationStatus `json:"status,omitempty"`
	// StatusMessage - Migration status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// Message - Migration progress message
	Message *string `json:"message,omitempty"`
	// Databases - Selected databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// DatabaseSummary - Summary of database results in the migration
	DatabaseSummary map[string]*DatabaseSummaryResult `json:"databaseSummary"`
	// MigrationReportResult - Migration Report Result, provides unique url for downloading your migration report.
	MigrationReportResult *MigrationReportResult `json:"migrationReportResult,omitempty"`
	// SourceServerVersion - Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerVersion - Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ExceptionsAndWarnings - Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssdtoml.ResultType = ResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtoml.StartedOn != nil {
		objectMap["startedOn"] = msssdtoml.StartedOn
	}
	if msssdtoml.EndedOn != nil {
		objectMap["endedOn"] = msssdtoml.EndedOn
	}
	if msssdtoml.DurationInSeconds != nil {
		objectMap["durationInSeconds"] = msssdtoml.DurationInSeconds
	}
	if msssdtoml.Status != "" {
		objectMap["status"] = msssdtoml.Status
	}
	if msssdtoml.StatusMessage != nil {
		objectMap["statusMessage"] = msssdtoml.StatusMessage
	}
	if msssdtoml.Message != nil {
		objectMap["message"] = msssdtoml.Message
	}
	if msssdtoml.Databases != nil {
		objectMap["databases"] = msssdtoml.Databases
	}
	if msssdtoml.DatabaseSummary != nil {
		objectMap["databaseSummary"] = msssdtoml.DatabaseSummary
	}
	if msssdtoml.MigrationReportResult != nil {
		objectMap["migrationReportResult"] = msssdtoml.MigrationReportResult
	}
	if msssdtoml.SourceServerVersion != nil {
		objectMap["sourceServerVersion"] = msssdtoml.SourceServerVersion
	}
	if msssdtoml.SourceServerBrandVersion != nil {
		objectMap["sourceServerBrandVersion"] = msssdtoml.SourceServerBrandVersion
	}
	if msssdtoml.TargetServerVersion != nil {
		objectMap["targetServerVersion"] = msssdtoml.TargetServerVersion
	}
	if msssdtoml.TargetServerBrandVersion != nil {
		objectMap["targetServerBrandVersion"] = msssdtoml.TargetServerBrandVersion
	}
	if msssdtoml.ExceptionsAndWarnings != nil {
		objectMap["exceptionsAndWarnings"] = msssdtoml.ExceptionsAndWarnings
	}
	if msssdtoml.ID != nil {
		objectMap["id"] = msssdtoml.ID
	}
	if msssdtoml.ResultType != "" {
		objectMap["resultType"] = msssdtoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return &msssdtoml, true
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtoml, true
}

// MigrateSQLServerSQLDbTaskOutputTableLevel table level result for Sql Server to Azure Sql DB migration.
type MigrateSQLServerSQLDbTaskOutputTableLevel struct {
	// ObjectName - Name of the item
	ObjectName *string `json:"objectName,omitempty"`
	// StartedOn - Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	msssdtotl.ResultType = ResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtotl.ObjectName != nil {
		objectMap["objectName"] = msssdtotl.ObjectName
	}
	if msssdtotl.StartedOn != nil {
		objectMap["startedOn"] = msssdtotl.StartedOn
	}
	if msssdtotl.EndedOn != nil {
		objectMap["endedOn"] = msssdtotl.EndedOn
	}
	if msssdtotl.State != "" {
		objectMap["state"] = msssdtotl.State
	}
	if msssdtotl.StatusMessage != nil {
		objectMap["statusMessage"] = msssdtotl.StatusMessage
	}
	if msssdtotl.ItemsCount != nil {
		objectMap["itemsCount"] = msssdtotl.ItemsCount
	}
	if msssdtotl.ItemsCompletedCount != nil {
		objectMap["itemsCompletedCount"] = msssdtotl.ItemsCompletedCount
	}
	if msssdtotl.ErrorPrefix != nil {
		objectMap["errorPrefix"] = msssdtotl.ErrorPrefix
	}
	if msssdtotl.ResultPrefix != nil {
		objectMap["resultPrefix"] = msssdtotl.ResultPrefix
	}
	if msssdtotl.ID != nil {
		objectMap["id"] = msssdtotl.ID
	}
	if msssdtotl.ResultType != "" {
		objectMap["resultType"] = msssdtotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return &msssdtotl, true
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtotl, true
}

// MigrateSQLServerSQLDbTaskProperties properties for the task that migrates on-prem SQL Server databases
// to Azure SQL Database
type MigrateSQLServerSQLDbTaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLDbTaskInput `json:"input,omitempty"`
	// Output - Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	msssdtp.TaskType = TaskTypeMigrateSQLServerSQLDb
	objectMap := make(map[string]interface{})
	if msssdtp.Input != nil {
		objectMap["input"] = msssdtp.Input
	}
	if msssdtp.Output != nil {
		objectMap["output"] = msssdtp.Output
	}
	if msssdtp.Errors != nil {
		objectMap["errors"] = msssdtp.Errors
	}
	if msssdtp.State != "" {
		objectMap["state"] = msssdtp.State
	}
	if msssdtp.TaskType != "" {
		objectMap["taskType"] = msssdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return &msssdtp, true
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssdtp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLDbTaskProperties struct.
func (msssdtp *MigrateSQLServerSQLDbTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLDbTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssdtp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLDbTaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssdtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssdtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssdtp.State = state
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssdtp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrationReportResult migration validation report result, contains the url for downloading the generated
// report.
type MigrationReportResult struct {
	// ID - Migration validation result identifier
	ID *string `json:"id,omitempty"`
	// ReportURL - The url of the report.
	ReportURL *string `json:"reportUrl,omitempty"`
}

// MigrationTableMetadata metadata for tables selected in migration project
type MigrationTableMetadata struct {
	// SourceTableName - Source table name
	SourceTableName *string `json:"sourceTableName,omitempty"`
	// TargetTableName - Target table name
	TargetTableName *string `json:"targetTableName,omitempty"`
}

// MigrationValidationDatabaseLevelResult database level validation results
type MigrationValidationDatabaseLevelResult struct {
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// MigrationID - Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SourceDatabaseName - Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// TargetDatabaseName - Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// StartedOn - Validation start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - Validation end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// DataIntegrityValidationResult - Provides data integrity validation result between the source and target tables that are migrated.
	DataIntegrityValidationResult *DataIntegrityValidationResult `json:"dataIntegrityValidationResult,omitempty"`
	// SchemaValidationResult - Provides schema comparison result between source and target database
	SchemaValidationResult *SchemaComparisonValidationResult `json:"schemaValidationResult,omitempty"`
	// QueryAnalysisValidationResult - Results of some of the query execution result between source and target database
	QueryAnalysisValidationResult *QueryAnalysisValidationResult `json:"queryAnalysisValidationResult,omitempty"`
	// Status - Current status of validation at the database level. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusFailed', 'ValidationStatusStopped'
	Status ValidationStatus `json:"status,omitempty"`
}

// MigrationValidationDatabaseSummaryResult migration Validation Database level summary result
type MigrationValidationDatabaseSummaryResult struct {
	// ID - Result identifier
	ID *string `json:"id,omitempty"`
	// MigrationID - Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SourceDatabaseName - Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// TargetDatabaseName - Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// StartedOn - Validation start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - Validation end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Status - Current status of validation at the database level. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusFailed', 'ValidationStatusStopped'
	Status ValidationStatus `json:"status,omitempty"`
}

// MigrationValidationOptions types of validations to run after the migration
type MigrationValidationOptions struct {
	// EnableSchemaValidation - Allows to compare the schema information between source and target.
	EnableSchemaValidation *bool `json:"enableSchemaValidation,omitempty"`
	// EnableDataIntegrityValidation - Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
	EnableDataIntegrityValidation *bool `json:"enableDataIntegrityValidation,omitempty"`
	// EnableQueryAnalysisValidation - Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
	EnableQueryAnalysisValidation *bool `json:"enableQueryAnalysisValidation,omitempty"`
}

// MigrationValidationResult migration Validation Result
type MigrationValidationResult struct {
	// ID - Migration validation result identifier
	ID *string `json:"id,omitempty"`
	// MigrationID - Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SummaryResults - Validation summary results for each database
	SummaryResults map[string]*MigrationValidationDatabaseSummaryResult `json:"summaryResults"`
	// Status - Current status of validation at the migration level. Status from the database validation result status will be aggregated here. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusFailed', 'ValidationStatusStopped'
	Status ValidationStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrationValidationResult.
func (mvr MigrationValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mvr.ID != nil {
		objectMap["id"] = mvr.ID
	}
	if mvr.MigrationID != nil {
		objectMap["migrationId"] = mvr.MigrationID
	}
	if mvr.SummaryResults != nil {
		objectMap["summaryResults"] = mvr.SummaryResults
	}
	if mvr.Status != "" {
		objectMap["status"] = mvr.Status
	}
	return json.Marshal(objectMap)
}

// NameAvailabilityRequest a resource type and proposed name
type NameAvailabilityRequest struct {
	// Name - The proposed resource name
	Name *string `json:"name,omitempty"`
	// Type - The resource type chain (e.g. virtualMachines/extensions)
	Type *string `json:"type,omitempty"`
}

// NameAvailabilityResponse indicates whether a proposed resource name is available
type NameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// NameAvailable - If true, the name is valid and available. If false, 'reason' describes why not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason why the name is not available, if nameAvailable is false. Possible values include: 'AlreadyExists', 'Invalid'
	Reason NameCheckFailureReason `json:"reason,omitempty"`
	// Message - The localized reason why the name is not available, if nameAvailable is false
	Message *string `json:"message,omitempty"`
}

// ODataError error information in OData format.
type ODataError struct {
	// Code - The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
	Code *string `json:"code,omitempty"`
	// Message - The human-readable description of the error
	Message *string `json:"message,omitempty"`
	// Details - Inner errors that caused this error
	Details *[]ODataError `json:"details,omitempty"`
}

// Project a project resource
type Project struct {
	autorest.Response `json:"-"`
	// ProjectProperties - Project properties
	*ProjectProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Project.
func (p Project) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProjectProperties != nil {
		objectMap["properties"] = p.ProjectProperties
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Type != nil {
		objectMap["type"] = p.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Project struct.
func (p *Project) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var projectProperties ProjectProperties
				err = json.Unmarshal(*v, &projectProperties)
				if err != nil {
					return err
				}
				p.ProjectProperties = &projectProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProjectList oData page of project resources
type ProjectList struct {
	autorest.Response `json:"-"`
	// Value - List of projects
	Value *[]Project `json:"value,omitempty"`
	// NextLink - URL to load the next page of projects
	NextLink *string `json:"nextLink,omitempty"`
}

// ProjectListIterator provides access to a complete listing of Project values.
type ProjectListIterator struct {
	i    int
	page ProjectListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProjectListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProjectListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProjectListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProjectListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProjectListIterator) Response() ProjectList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProjectListIterator) Value() Project {
	if !iter.page.NotDone() {
		return Project{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProjectListIterator type.
func NewProjectListIterator(page ProjectListPage) ProjectListIterator {
	return ProjectListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pl ProjectList) IsEmpty() bool {
	return pl.Value == nil || len(*pl.Value) == 0
}

// projectListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pl ProjectList) projectListPreparer(ctx context.Context) (*http.Request, error) {
	if pl.NextLink == nil || len(to.String(pl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pl.NextLink)))
}

// ProjectListPage contains a page of Project values.
type ProjectListPage struct {
	fn func(context.Context, ProjectList) (ProjectList, error)
	pl ProjectList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProjectListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProjectListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pl)
	if err != nil {
		return err
	}
	page.pl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProjectListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProjectListPage) NotDone() bool {
	return !page.pl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProjectListPage) Response() ProjectList {
	return page.pl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProjectListPage) Values() []Project {
	if page.pl.IsEmpty() {
		return nil
	}
	return *page.pl.Value
}

// Creates a new instance of the ProjectListPage type.
func NewProjectListPage(getNextPage func(context.Context, ProjectList) (ProjectList, error)) ProjectListPage {
	return ProjectListPage{fn: getNextPage}
}

// ProjectMetadata common metadata for migration projects
type ProjectMetadata struct {
	// SourceServerName - Source server name
	SourceServerName *string `json:"sourceServerName,omitempty"`
	// SourceServerPort - Source server port number
	SourceServerPort *string `json:"sourceServerPort,omitempty"`
	// SourceUsername - Source username
	SourceUsername *string `json:"sourceUsername,omitempty"`
	// TargetServerName - Target server name
	TargetServerName *string `json:"targetServerName,omitempty"`
	// TargetUsername - Target username
	TargetUsername *string `json:"targetUsername,omitempty"`
	// TargetDbName - Target database name
	TargetDbName *string `json:"targetDbName,omitempty"`
	// TargetUsingWinAuth - Whether target connection is Windows authentication
	TargetUsingWinAuth *bool `json:"targetUsingWinAuth,omitempty"`
	// SelectedMigrationTables - List of tables selected for migration
	SelectedMigrationTables *[]MigrationTableMetadata `json:"selectedMigrationTables,omitempty"`
}

// ProjectProperties project-specific properties
type ProjectProperties struct {
	// SourcePlatform - Source platform for the project. Possible values include: 'SQL', 'Unknown'
	SourcePlatform ProjectSourcePlatform `json:"sourcePlatform,omitempty"`
	// TargetPlatform - Target platform for the project. Possible values include: 'ProjectTargetPlatformSQLDB', 'ProjectTargetPlatformUnknown'
	TargetPlatform ProjectTargetPlatform `json:"targetPlatform,omitempty"`
	// CreationTime - UTC Date and time when project was created
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo BasicConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo BasicConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// DatabasesInfo - List of DatabaseInfo
	DatabasesInfo *[]DatabaseInfo `json:"databasesInfo,omitempty"`
	// ProvisioningState - The project's provisioning state. Possible values include: 'Deleting', 'Succeeded'
	ProvisioningState ProjectProvisioningState `json:"provisioningState,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProjectProperties struct.
func (pp *ProjectProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sourcePlatform":
			if v != nil {
				var sourcePlatform ProjectSourcePlatform
				err = json.Unmarshal(*v, &sourcePlatform)
				if err != nil {
					return err
				}
				pp.SourcePlatform = sourcePlatform
			}
		case "targetPlatform":
			if v != nil {
				var targetPlatform ProjectTargetPlatform
				err = json.Unmarshal(*v, &targetPlatform)
				if err != nil {
					return err
				}
				pp.TargetPlatform = targetPlatform
			}
		case "creationTime":
			if v != nil {
				var creationTime date.Time
				err = json.Unmarshal(*v, &creationTime)
				if err != nil {
					return err
				}
				pp.CreationTime = &creationTime
			}
		case "sourceConnectionInfo":
			if v != nil {
				sourceConnectionInfo, err := unmarshalBasicConnectionInfo(*v)
				if err != nil {
					return err
				}
				pp.SourceConnectionInfo = sourceConnectionInfo
			}
		case "targetConnectionInfo":
			if v != nil {
				targetConnectionInfo, err := unmarshalBasicConnectionInfo(*v)
				if err != nil {
					return err
				}
				pp.TargetConnectionInfo = targetConnectionInfo
			}
		case "databasesInfo":
			if v != nil {
				var databasesInfo []DatabaseInfo
				err = json.Unmarshal(*v, &databasesInfo)
				if err != nil {
					return err
				}
				pp.DatabasesInfo = &databasesInfo
			}
		case "provisioningState":
			if v != nil {
				var provisioningState ProjectProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				pp.ProvisioningState = provisioningState
			}
		}
	}

	return nil
}

// ProjectTask a task resource
type ProjectTask struct {
	autorest.Response `json:"-"`
	// Etag - HTTP strong entity tag value. This is ignored if submitted.
	Etag *string `json:"etag,omitempty"`
	// Properties - Custom task properties
	Properties BasicProjectTaskProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProjectTask struct.
func (pt *ProjectTask) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pt.Etag = &etag
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProjectTaskProperties(*v)
				if err != nil {
					return err
				}
				pt.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pt.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicProjectTaskProperties base class for all types of DMS task properties. If task is not supported by current
// client, this object is returned.
type BasicProjectTaskProperties interface {
	AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool)
	AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool)
	AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool)
	AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool)
	AsProjectTaskProperties() (*ProjectTaskProperties, bool)
}

// ProjectTaskProperties base class for all types of DMS task properties. If task is not supported by current
// client, this object is returned.
type ProjectTaskProperties struct {
	// Errors - Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceSQLServer'
	TaskType TaskType `json:"taskType,omitempty"`
}

func unmarshalBasicProjectTaskProperties(body []byte) (BasicProjectTaskProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["taskType"] {
	case string(TaskTypeMigrateSQLServerSQLDb):
		var msssdtp MigrateSQLServerSQLDbTaskProperties
		err := json.Unmarshal(body, &msssdtp)
		return msssdtp, err
	case string(TaskTypeGetUserTablesSQL):
		var gutstp GetUserTablesSQLTaskProperties
		err := json.Unmarshal(body, &gutstp)
		return gutstp, err
	case string(TaskTypeConnectToTargetSQLDb):
		var cttsdtp ConnectToTargetSQLDbTaskProperties
		err := json.Unmarshal(body, &cttsdtp)
		return cttsdtp, err
	case string(TaskTypeConnectToSourceSQLServer):
		var ctssstp ConnectToSourceSQLServerTaskProperties
		err := json.Unmarshal(body, &ctssstp)
		return ctssstp, err
	default:
		var ptp ProjectTaskProperties
		err := json.Unmarshal(body, &ptp)
		return ptp, err
	}
}
func unmarshalBasicProjectTaskPropertiesArray(body []byte) ([]BasicProjectTaskProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ptpArray := make([]BasicProjectTaskProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ptp, err := unmarshalBasicProjectTaskProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		ptpArray[index] = ptp
	}
	return ptpArray, nil
}

// MarshalJSON is the custom marshaler for ProjectTaskProperties.
func (ptp ProjectTaskProperties) MarshalJSON() ([]byte, error) {
	ptp.TaskType = TaskTypeUnknown
	objectMap := make(map[string]interface{})
	if ptp.Errors != nil {
		objectMap["errors"] = ptp.Errors
	}
	if ptp.State != "" {
		objectMap["state"] = ptp.State
	}
	if ptp.TaskType != "" {
		objectMap["taskType"] = ptp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return &ptp, true
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ptp, true
}

// QueryAnalysisValidationResult results for query analysis comparison between the source and target
type QueryAnalysisValidationResult struct {
	// QueryResults - List of queries executed and it's execution results in source and target
	QueryResults *QueryExecutionResult `json:"queryResults,omitempty"`
	// ValidationErrors - Errors that are part of the execution
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
}

// QueryExecutionResult describes query analysis results for execution in source and target
type QueryExecutionResult struct {
	// QueryText - Query text retrieved from the source server
	QueryText *string `json:"queryText,omitempty"`
	// StatementsInBatch - Total no. of statements in the batch
	StatementsInBatch *int64 `json:"statementsInBatch,omitempty"`
	// SourceResult - Query analysis result from the source
	SourceResult *ExecutionStatistics `json:"sourceResult,omitempty"`
	// TargetResult - Query analysis result from the target
	TargetResult *ExecutionStatistics `json:"targetResult,omitempty"`
}

// Quota describes a quota for or usage details about a resource
type Quota struct {
	// CurrentValue - The current value of the quota. If null or missing, the current value cannot be determined in the context of the request.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// ID - The resource ID of the quota object
	ID *string `json:"id,omitempty"`
	// Limit - The maximum value of the quota. If null or missing, the quota has no maximum, in which case it merely tracks usage.
	Limit *float64 `json:"limit,omitempty"`
	// Name - The name of the quota
	Name *QuotaName `json:"name,omitempty"`
	// Unit - The unit for the quota, such as Count, Bytes, BytesPerSecond, etc.
	Unit *string `json:"unit,omitempty"`
}

// QuotaList oData page of quota objects
type QuotaList struct {
	autorest.Response `json:"-"`
	// Value - List of quotas
	Value *[]Quota `json:"value,omitempty"`
	// NextLink - URL to load the next page of quotas, or null or missing if this is the last page
	NextLink *string `json:"nextLink,omitempty"`
}

// QuotaListIterator provides access to a complete listing of Quota values.
type QuotaListIterator struct {
	i    int
	page QuotaListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *QuotaListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *QuotaListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter QuotaListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter QuotaListIterator) Response() QuotaList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter QuotaListIterator) Value() Quota {
	if !iter.page.NotDone() {
		return Quota{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the QuotaListIterator type.
func NewQuotaListIterator(page QuotaListPage) QuotaListIterator {
	return QuotaListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ql QuotaList) IsEmpty() bool {
	return ql.Value == nil || len(*ql.Value) == 0
}

// quotaListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ql QuotaList) quotaListPreparer(ctx context.Context) (*http.Request, error) {
	if ql.NextLink == nil || len(to.String(ql.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ql.NextLink)))
}

// QuotaListPage contains a page of Quota values.
type QuotaListPage struct {
	fn func(context.Context, QuotaList) (QuotaList, error)
	ql QuotaList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *QuotaListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ql)
	if err != nil {
		return err
	}
	page.ql = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *QuotaListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page QuotaListPage) NotDone() bool {
	return !page.ql.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page QuotaListPage) Response() QuotaList {
	return page.ql
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page QuotaListPage) Values() []Quota {
	if page.ql.IsEmpty() {
		return nil
	}
	return *page.ql.Value
}

// Creates a new instance of the QuotaListPage type.
func NewQuotaListPage(getNextPage func(context.Context, QuotaList) (QuotaList, error)) QuotaListPage {
	return QuotaListPage{fn: getNextPage}
}

// QuotaName the name of the quota
type QuotaName struct {
	// LocalizedValue - The localized name of the quota
	LocalizedValue *string `json:"localizedValue,omitempty"`
	// Value - The unlocalized name (or ID) of the quota
	Value *string `json:"value,omitempty"`
}

// ReportableException exception object for all custom exceptions
type ReportableException struct {
	// Message - Error message
	Message *string `json:"message,omitempty"`
	// FilePath - The path to the file where exception occurred
	FilePath *string `json:"filePath,omitempty"`
	// LineNumber - The line number where exception occurred
	LineNumber *string `json:"lineNumber,omitempty"`
	// HResult - Coded numerical value that is assigned to a specific exception
	HResult *int32 `json:"hResult,omitempty"`
	// StackTrace - Stack trace
	StackTrace *string `json:"stackTrace,omitempty"`
}

// Resource ARM resource.
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// ResourceSku describes an available DMS SKU.
type ResourceSku struct {
	// ResourceType - The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - The name of SKU.
	Name *string `json:"name,omitempty"`
	// Tier - Specifies the tier of DMS in a scale set.
	Tier *string `json:"tier,omitempty"`
	// Size - The Size of the SKU.
	Size *string `json:"size,omitempty"`
	// Family - The Family of this particular SKU.
	Family *string `json:"family,omitempty"`
	// Kind - The Kind of resources that are supported in this SKU.
	Kind *string `json:"kind,omitempty"`
	// Capacity - Not used.
	Capacity *ResourceSkuCapacity `json:"capacity,omitempty"`
	// Locations - The set of locations that the SKU is available.
	Locations *[]string `json:"locations,omitempty"`
	// APIVersions - The api versions that support this SKU.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// Costs - Metadata for retrieving price info.
	Costs *[]ResourceSkuCosts `json:"costs,omitempty"`
	// Capabilities - A name value pair to describe the capability.
	Capabilities *[]ResourceSkuCapabilities `json:"capabilities,omitempty"`
	// Restrictions - The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]ResourceSkuRestrictions `json:"restrictions,omitempty"`
}

// ResourceSkuCapabilities describes The SKU capabilities object.
type ResourceSkuCapabilities struct {
	// Name - An invariant to describe the feature.
	Name *string `json:"name,omitempty"`
	// Value - An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

// ResourceSkuCapacity describes scaling information of a SKU.
type ResourceSkuCapacity struct {
	// Minimum - The minimum capacity.
	Minimum *int64 `json:"minimum,omitempty"`
	// Maximum - The maximum capacity.
	Maximum *int64 `json:"maximum,omitempty"`
	// Default - The default capacity.
	Default *int64 `json:"default,omitempty"`
	// ScaleType - The scale type applicable to the SKU. Possible values include: 'ResourceSkuCapacityScaleTypeAutomatic', 'ResourceSkuCapacityScaleTypeManual', 'ResourceSkuCapacityScaleTypeNone'
	ScaleType ResourceSkuCapacityScaleType `json:"scaleType,omitempty"`
}

// ResourceSkuCosts describes metadata for retrieving price info.
type ResourceSkuCosts struct {
	// MeterID - Used for querying price from commerce.
	MeterID *string `json:"meterID,omitempty"`
	// Quantity - The multiplier is needed to extend the base metered cost.
	Quantity *int64 `json:"quantity,omitempty"`
	// ExtendedUnit - An invariant to show the extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty"`
}

// ResourceSkuRestrictions describes scaling information of a SKU.
type ResourceSkuRestrictions struct {
	// Type - The type of restrictions. Possible values include: 'Location'
	Type ResourceSkuRestrictionsType `json:"type,omitempty"`
	// Values - The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - The reason code for restriction. Possible values include: 'QuotaID', 'NotAvailableForSubscription'
	ReasonCode ResourceSkuRestrictionsReasonCode `json:"reasonCode,omitempty"`
}

// ResourceSkusResult the DMS List SKUs operation response.
type ResourceSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The list of SKUs available for the subscription.
	Value *[]ResourceSku `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of DMS SKUs. Call ListNext() with this to fetch the next page of DMS SKUs.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceSkusResultIterator provides access to a complete listing of ResourceSku values.
type ResourceSkusResultIterator struct {
	i    int
	page ResourceSkusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceSkusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceSkusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceSkusResultIterator) Response() ResourceSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceSkusResultIterator) Value() ResourceSku {
	if !iter.page.NotDone() {
		return ResourceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceSkusResultIterator type.
func NewResourceSkusResultIterator(page ResourceSkusResultPage) ResourceSkusResultIterator {
	return ResourceSkusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rsr ResourceSkusResult) IsEmpty() bool {
	return rsr.Value == nil || len(*rsr.Value) == 0
}

// resourceSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rsr ResourceSkusResult) resourceSkusResultPreparer(ctx context.Context) (*http.Request, error) {
	if rsr.NextLink == nil || len(to.String(rsr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rsr.NextLink)))
}

// ResourceSkusResultPage contains a page of ResourceSku values.
type ResourceSkusResultPage struct {
	fn  func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)
	rsr ResourceSkusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceSkusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rsr)
	if err != nil {
		return err
	}
	page.rsr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceSkusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceSkusResultPage) NotDone() bool {
	return !page.rsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceSkusResultPage) Response() ResourceSkusResult {
	return page.rsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceSkusResultPage) Values() []ResourceSku {
	if page.rsr.IsEmpty() {
		return nil
	}
	return *page.rsr.Value
}

// Creates a new instance of the ResourceSkusResultPage type.
func NewResourceSkusResultPage(getNextPage func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)) ResourceSkusResultPage {
	return ResourceSkusResultPage{fn: getNextPage}
}

// SchemaComparisonValidationResult results for schema comparison between the source and target
type SchemaComparisonValidationResult struct {
	// SchemaDifferences - List of schema differences between the source and target databases
	SchemaDifferences *SchemaComparisonValidationResultType `json:"schemaDifferences,omitempty"`
	// ValidationErrors - List of errors that happened while performing schema compare validation
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
	// SourceDatabaseObjectCount - Count of source database objects
	SourceDatabaseObjectCount map[string]*int64 `json:"sourceDatabaseObjectCount"`
	// TargetDatabaseObjectCount - Count of target database objects
	TargetDatabaseObjectCount map[string]*int64 `json:"targetDatabaseObjectCount"`
}

// MarshalJSON is the custom marshaler for SchemaComparisonValidationResult.
func (scvr SchemaComparisonValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scvr.SchemaDifferences != nil {
		objectMap["schemaDifferences"] = scvr.SchemaDifferences
	}
	if scvr.ValidationErrors != nil {
		objectMap["validationErrors"] = scvr.ValidationErrors
	}
	if scvr.SourceDatabaseObjectCount != nil {
		objectMap["sourceDatabaseObjectCount"] = scvr.SourceDatabaseObjectCount
	}
	if scvr.TargetDatabaseObjectCount != nil {
		objectMap["targetDatabaseObjectCount"] = scvr.TargetDatabaseObjectCount
	}
	return json.Marshal(objectMap)
}

// SchemaComparisonValidationResultType description about the errors happen while performing migration
// validation
type SchemaComparisonValidationResultType struct {
	// ObjectName - Name of the object that has the difference
	ObjectName *string `json:"objectName,omitempty"`
	// ObjectType - Type of the object that has the difference. e.g (Table/View/StoredProcedure). Possible values include: 'StoredProcedures', 'Table', 'User', 'View', 'Function'
	ObjectType ObjectType `json:"objectType,omitempty"`
	// UpdateAction - Update action type with respect to target. Possible values include: 'DeletedOnTarget', 'ChangedOnTarget', 'AddedOnTarget'
	UpdateAction UpdateActionType `json:"updateAction,omitempty"`
}

// Service a Data Migration Service resource
type Service struct {
	autorest.Response `json:"-"`
	// Etag - HTTP strong entity tag value. Ignored if submitted
	Etag *string `json:"etag,omitempty"`
	// Kind - The resource kind. Only 'vm' (the default) is supported.
	Kind *string `json:"kind,omitempty"`
	// ServiceProperties - Custom service properties
	*ServiceProperties `json:"properties,omitempty"`
	// Sku - Service SKU
	Sku *ServiceSku `json:"sku,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.Kind != nil {
		objectMap["kind"] = s.Kind
	}
	if s.ServiceProperties != nil {
		objectMap["properties"] = s.ServiceProperties
	}
	if s.Sku != nil {
		objectMap["sku"] = s.Sku
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Type != nil {
		objectMap["type"] = s.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Service struct.
func (s *Service) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				s.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				s.ServiceProperties = &serviceProperties
			}
		case "sku":
			if v != nil {
				var sku ServiceSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				s.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceList oData page of service objects
type ServiceList struct {
	autorest.Response `json:"-"`
	// Value - List of services
	Value *[]Service `json:"value,omitempty"`
	// NextLink - URL to load the next page of services
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceListIterator provides access to a complete listing of Service values.
type ServiceListIterator struct {
	i    int
	page ServiceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceListIterator) Response() ServiceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceListIterator) Value() Service {
	if !iter.page.NotDone() {
		return Service{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceListIterator type.
func NewServiceListIterator(page ServiceListPage) ServiceListIterator {
	return ServiceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl ServiceList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// serviceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl ServiceList) serviceListPreparer(ctx context.Context) (*http.Request, error) {
	if sl.NextLink == nil || len(to.String(sl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// ServiceListPage contains a page of Service values.
type ServiceListPage struct {
	fn func(context.Context, ServiceList) (ServiceList, error)
	sl ServiceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sl)
	if err != nil {
		return err
	}
	page.sl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceListPage) Response() ServiceList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceListPage) Values() []Service {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the ServiceListPage type.
func NewServiceListPage(getNextPage func(context.Context, ServiceList) (ServiceList, error)) ServiceListPage {
	return ServiceListPage{fn: getNextPage}
}

// ServiceOperation description of an action supported by the Data Migration Service
type ServiceOperation struct {
	// Name - The fully qualified action name, e.g. Microsoft.DataMigration/services/read
	Name *string `json:"name,omitempty"`
	// Display - Localized display text
	Display *ServiceOperationDisplay `json:"display,omitempty"`
}

// ServiceOperationDisplay localized display text
type ServiceOperationDisplay struct {
	// Provider - The localized resource provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - The localized resource type name
	Resource *string `json:"resource,omitempty"`
	// Operation - The localized operation name
	Operation *string `json:"operation,omitempty"`
	// Description - The localized operation description
	Description *string `json:"description,omitempty"`
}

// ServiceOperationList oData page of action (operation) objects
type ServiceOperationList struct {
	autorest.Response `json:"-"`
	// Value - List of actions
	Value *[]ServiceOperation `json:"value,omitempty"`
	// NextLink - URL to load the next page of actions
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceOperationListIterator provides access to a complete listing of ServiceOperation values.
type ServiceOperationListIterator struct {
	i    int
	page ServiceOperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceOperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceOperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceOperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceOperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceOperationListIterator) Response() ServiceOperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceOperationListIterator) Value() ServiceOperation {
	if !iter.page.NotDone() {
		return ServiceOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceOperationListIterator type.
func NewServiceOperationListIterator(page ServiceOperationListPage) ServiceOperationListIterator {
	return ServiceOperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sol ServiceOperationList) IsEmpty() bool {
	return sol.Value == nil || len(*sol.Value) == 0
}

// serviceOperationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sol ServiceOperationList) serviceOperationListPreparer(ctx context.Context) (*http.Request, error) {
	if sol.NextLink == nil || len(to.String(sol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sol.NextLink)))
}

// ServiceOperationListPage contains a page of ServiceOperation values.
type ServiceOperationListPage struct {
	fn  func(context.Context, ServiceOperationList) (ServiceOperationList, error)
	sol ServiceOperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceOperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceOperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sol)
	if err != nil {
		return err
	}
	page.sol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceOperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceOperationListPage) NotDone() bool {
	return !page.sol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceOperationListPage) Response() ServiceOperationList {
	return page.sol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceOperationListPage) Values() []ServiceOperation {
	if page.sol.IsEmpty() {
		return nil
	}
	return *page.sol.Value
}

// Creates a new instance of the ServiceOperationListPage type.
func NewServiceOperationListPage(getNextPage func(context.Context, ServiceOperationList) (ServiceOperationList, error)) ServiceOperationListPage {
	return ServiceOperationListPage{fn: getNextPage}
}

// ServiceProperties properties of the Data Migration service instance
type ServiceProperties struct {
	// ProvisioningState - The resource's provisioning state. Possible values include: 'ServiceProvisioningStateAccepted', 'ServiceProvisioningStateDeleting', 'ServiceProvisioningStateDeploying', 'ServiceProvisioningStateStopped', 'ServiceProvisioningStateStopping', 'ServiceProvisioningStateStarting', 'ServiceProvisioningStateFailedToStart', 'ServiceProvisioningStateFailedToStop', 'ServiceProvisioningStateSucceeded', 'ServiceProvisioningStateFailed'
	ProvisioningState ServiceProvisioningState `json:"provisioningState,omitempty"`
	// PublicKey - The public key of the service, used to encrypt secrets sent to the service
	PublicKey *string `json:"publicKey,omitempty"`
	// VirtualSubnetID - The ID of the Microsoft.Network/virtualNetworks/subnets resource to which the service should be joined
	VirtualSubnetID *string `json:"virtualSubnetId,omitempty"`
}

// ServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesCreateOrUpdateFuture) Result(client ServicesClient) (s Service, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datamigration.ServicesCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesDeleteFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceSku an Azure SKU instance
type ServiceSku struct {
	// Name - The unique name of the SKU, such as 'P3'
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the SKU, such as 'Free', 'Basic', 'Standard', or 'Premium'
	Tier *string `json:"tier,omitempty"`
	// Family - The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
	Family *string `json:"family,omitempty"`
	// Size - The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
	Size *string `json:"size,omitempty"`
	// Capacity - The capacity of the SKU, if it supports scaling
	Capacity *int32 `json:"capacity,omitempty"`
}

// ServiceSkuList oData page of available SKUs
type ServiceSkuList struct {
	autorest.Response `json:"-"`
	// Value - List of service SKUs
	Value *[]AvailableServiceSku `json:"value,omitempty"`
	// NextLink - URL to load the next page of service SKUs
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceSkuListIterator provides access to a complete listing of AvailableServiceSku values.
type ServiceSkuListIterator struct {
	i    int
	page ServiceSkuListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceSkuListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceSkuListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceSkuListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceSkuListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceSkuListIterator) Response() ServiceSkuList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceSkuListIterator) Value() AvailableServiceSku {
	if !iter.page.NotDone() {
		return AvailableServiceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceSkuListIterator type.
func NewServiceSkuListIterator(page ServiceSkuListPage) ServiceSkuListIterator {
	return ServiceSkuListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssl ServiceSkuList) IsEmpty() bool {
	return ssl.Value == nil || len(*ssl.Value) == 0
}

// serviceSkuListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssl ServiceSkuList) serviceSkuListPreparer(ctx context.Context) (*http.Request, error) {
	if ssl.NextLink == nil || len(to.String(ssl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssl.NextLink)))
}

// ServiceSkuListPage contains a page of AvailableServiceSku values.
type ServiceSkuListPage struct {
	fn  func(context.Context, ServiceSkuList) (ServiceSkuList, error)
	ssl ServiceSkuList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceSkuListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceSkuListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ssl)
	if err != nil {
		return err
	}
	page.ssl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceSkuListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceSkuListPage) NotDone() bool {
	return !page.ssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceSkuListPage) Response() ServiceSkuList {
	return page.ssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceSkuListPage) Values() []AvailableServiceSku {
	if page.ssl.IsEmpty() {
		return nil
	}
	return *page.ssl.Value
}

// Creates a new instance of the ServiceSkuListPage type.
func NewServiceSkuListPage(getNextPage func(context.Context, ServiceSkuList) (ServiceSkuList, error)) ServiceSkuListPage {
	return ServiceSkuListPage{fn: getNextPage}
}

// ServicesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesStartFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServicesStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesStopFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceStatusResponse service health status
type ServiceStatusResponse struct {
	autorest.Response `json:"-"`
	// AgentVersion - The DMS instance agent version
	AgentVersion *string `json:"agentVersion,omitempty"`
	// Status - The machine-readable status, such as 'Initializing', 'Offline', 'Online', 'Deploying', 'Deleting', 'Stopped', 'Stopping', 'Starting', 'FailedToStart', 'FailedToStop' or 'Failed'
	Status *string `json:"status,omitempty"`
	// VMSize - The services virtual machine size, such as 'Standard_D2_v2'
	VMSize *string `json:"vmSize,omitempty"`
	// SupportedTaskTypes - The list of supported task types
	SupportedTaskTypes *[]string `json:"supportedTaskTypes,omitempty"`
}

// ServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesUpdateFuture) Result(client ServicesClient) (s Service, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.UpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datamigration.ServicesUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLConnectionInfo information for connecting to SQL database server
type SQLConnectionInfo struct {
	// DataSource - Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
	DataSource *string `json:"dataSource,omitempty"`
	// Authentication - Authentication type to use for connection. Possible values include: 'None', 'WindowsAuthentication', 'SQLAuthentication', 'ActiveDirectoryIntegrated', 'ActiveDirectoryPassword'
	Authentication AuthenticationType `json:"authentication,omitempty"`
	// EncryptConnection - Whether to encrypt the connection
	EncryptConnection *bool `json:"encryptConnection,omitempty"`
	// AdditionalSettings - Additional connection settings
	AdditionalSettings *string `json:"additionalSettings,omitempty"`
	// TrustServerCertificate - Whether to trust the server certificate
	TrustServerCertificate *bool `json:"trustServerCertificate,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeUnknown', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLConnectionInfo.
func (sci SQLConnectionInfo) MarshalJSON() ([]byte, error) {
	sci.Type = TypeSQLConnectionInfo
	objectMap := make(map[string]interface{})
	if sci.DataSource != nil {
		objectMap["dataSource"] = sci.DataSource
	}
	if sci.Authentication != "" {
		objectMap["authentication"] = sci.Authentication
	}
	if sci.EncryptConnection != nil {
		objectMap["encryptConnection"] = sci.EncryptConnection
	}
	if sci.AdditionalSettings != nil {
		objectMap["additionalSettings"] = sci.AdditionalSettings
	}
	if sci.TrustServerCertificate != nil {
		objectMap["trustServerCertificate"] = sci.TrustServerCertificate
	}
	if sci.UserName != nil {
		objectMap["userName"] = sci.UserName
	}
	if sci.Password != nil {
		objectMap["password"] = sci.Password
	}
	if sci.Type != "" {
		objectMap["type"] = sci.Type
	}
	return json.Marshal(objectMap)
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return &sci, true
}

// AsConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &sci, true
}

// SQLMigrationTaskInput base class for migration task input
type SQLMigrationTaskInput struct {
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// TaskList oData page of tasks
type TaskList struct {
	autorest.Response `json:"-"`
	// Value - List of tasks
	Value *[]ProjectTask `json:"value,omitempty"`
	// NextLink - URL to load the next page of tasks
	NextLink *string `json:"nextLink,omitempty"`
}

// TaskListIterator provides access to a complete listing of ProjectTask values.
type TaskListIterator struct {
	i    int
	page TaskListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TaskListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TaskListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TaskListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TaskListIterator) Response() TaskList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TaskListIterator) Value() ProjectTask {
	if !iter.page.NotDone() {
		return ProjectTask{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TaskListIterator type.
func NewTaskListIterator(page TaskListPage) TaskListIterator {
	return TaskListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TaskList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// taskListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TaskList) taskListPreparer(ctx context.Context) (*http.Request, error) {
	if tl.NextLink == nil || len(to.String(tl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TaskListPage contains a page of ProjectTask values.
type TaskListPage struct {
	fn func(context.Context, TaskList) (TaskList, error)
	tl TaskList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TaskListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tl)
	if err != nil {
		return err
	}
	page.tl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TaskListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TaskListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TaskListPage) Response() TaskList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TaskListPage) Values() []ProjectTask {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TaskListPage type.
func NewTaskListPage(getNextPage func(context.Context, TaskList) (TaskList, error)) TaskListPage {
	return TaskListPage{fn: getNextPage}
}

// TrackedResource ARM tracked top level resource.
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}

// ValidationError description about the errors happen while performing migration validation
type ValidationError struct {
	// Text - Error Text
	Text *string `json:"text,omitempty"`
	// Severity - Severity of the error. Possible values include: 'SeverityMessage', 'SeverityWarning', 'SeverityError'
	Severity Severity `json:"severity,omitempty"`
}

// WaitStatistics wait statistics gathered during query batch execution
type WaitStatistics struct {
	// WaitType - Type of the Wait
	WaitType *string `json:"waitType,omitempty"`
	// WaitTimeMs - Total wait time in millisecond(s)
	WaitTimeMs *float64 `json:"waitTimeMs,omitempty"`
	// WaitCount - Total no. of waits
	WaitCount *int64 `json:"waitCount,omitempty"`
}
