package netapp

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/netapp/mgmt/2017-08-15/netapp"

// ServiceLevel enumerates the values for service level.
type ServiceLevel string

const (
	// Extreme Extreme service level
	Extreme ServiceLevel = "Extreme"
	// Premium Premium service level
	Premium ServiceLevel = "Premium"
	// Standard Standard service level
	Standard ServiceLevel = "Standard"
)

// PossibleServiceLevelValues returns an array of possible values for the ServiceLevel const type.
func PossibleServiceLevelValues() []ServiceLevel {
	return []ServiceLevel{Extreme, Premium, Standard}
}

// Account netApp account resource
type Account struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// AccountProperties - NetApp Account properties
	*AccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		}
	}

	return nil
}

// AccountList list of NetApp account resources
type AccountList struct {
	autorest.Response `json:"-"`
	// Value - Multiple NetApp accounts
	Value *[]Account `json:"value,omitempty"`
}

// AccountPatch netApp account patch resource
type AccountPatch struct {
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
}

// AccountProperties netApp account properties
type AccountProperties struct {
	// ProvisioningState - Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// AccountsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AccountsCreateOrUpdateFuture) Result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.AccountsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.AccountsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateOrUpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "netapp.AccountsCreateOrUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AccountsDeleteFuture) Result(client AccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.AccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.AccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CapacityPool capacity pool resource
type CapacityPool struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// PoolProperties - Capacity pool properties
	*PoolProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CapacityPool.
func (cp CapacityPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Location != nil {
		objectMap["location"] = cp.Location
	}
	if cp.ID != nil {
		objectMap["id"] = cp.ID
	}
	if cp.Name != nil {
		objectMap["name"] = cp.Name
	}
	if cp.Type != nil {
		objectMap["type"] = cp.Type
	}
	if cp.Tags != nil {
		objectMap["tags"] = cp.Tags
	}
	if cp.PoolProperties != nil {
		objectMap["properties"] = cp.PoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CapacityPool struct.
func (cp *CapacityPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cp.Tags = tags
			}
		case "properties":
			if v != nil {
				var poolProperties PoolProperties
				err = json.Unmarshal(*v, &poolProperties)
				if err != nil {
					return err
				}
				cp.PoolProperties = &poolProperties
			}
		}
	}

	return nil
}

// CapacityPoolList list of capacity pool resources
type CapacityPoolList struct {
	autorest.Response `json:"-"`
	// Value - List of Capacity pools
	Value *[]CapacityPool `json:"value,omitempty"`
}

// CapacityPoolPatch capacity pool patch resource
type CapacityPoolPatch struct {
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
}

// Dimension dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Name - Display name of dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`
}

// Error error response describing why the operation failed.
type Error struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Detailed error message
	Message *string `json:"message,omitempty"`
}

// MetricSpecification metric specification of operation.
type MetricSpecification struct {
	// Name - Name of metric specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit could be Bytes or Count.
	Unit *string `json:"unit,omitempty"`
	// Dimensions - Dimensions of blobs, including blob type and access tier.
	Dimensions *[]Dimension `json:"dimensions,omitempty"`
	// AggregationType - Aggregation type could be Average.
	AggregationType *string `json:"aggregationType,omitempty"`
	// FillGapWithZero - The property to decide fill gap with zero or not.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Category - The category this metric specification belong to, could be Capacity.
	Category *string `json:"category,omitempty"`
	// ResourceIDDimensionNameOverride - Account Resource Id.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`
}

// MountTarget mount Target
type MountTarget struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// MountTargetProperties - Mount Target Properties
	*MountTargetProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MountTarget.
func (mt MountTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mt.Location != nil {
		objectMap["location"] = mt.Location
	}
	if mt.ID != nil {
		objectMap["id"] = mt.ID
	}
	if mt.Name != nil {
		objectMap["name"] = mt.Name
	}
	if mt.Tags != nil {
		objectMap["tags"] = mt.Tags
	}
	if mt.MountTargetProperties != nil {
		objectMap["properties"] = mt.MountTargetProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MountTarget struct.
func (mt *MountTarget) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mt.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mt.Name = &name
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mt.Tags = tags
			}
		case "properties":
			if v != nil {
				var mountTargetProperties MountTargetProperties
				err = json.Unmarshal(*v, &mountTargetProperties)
				if err != nil {
					return err
				}
				mt.MountTargetProperties = &mountTargetProperties
			}
		}
	}

	return nil
}

// MountTargetList list of Mount Targets
type MountTargetList struct {
	autorest.Response `json:"-"`
	// Value - A list of Mount targets
	Value *[]MountTarget `json:"value,omitempty"`
}

// MountTargetProperties mount target properties
type MountTargetProperties struct {
	// MountTargetID - UUID v4 used to identify the MountTarget
	MountTargetID *string `json:"mountTargetId,omitempty"`
	// FileSystemID - UUID v4 used to identify the MountTarget
	FileSystemID *string `json:"fileSystemId,omitempty"`
	// IPAddress - The mount target's IPv4 address
	IPAddress *string `json:"ipAddress,omitempty"`
	// VlanID - Vlan Id
	VlanID *int32 `json:"vlanId,omitempty"`
	// StartIP - The start of IPv4 address range to use when creating a new mount target
	StartIP *string `json:"startIp,omitempty"`
	// EndIP - The end of IPv4 address range to use when creating a new mount target
	EndIP *string `json:"endIp,omitempty"`
	// Gateway - The gateway of the IPv4 address range to use when creating a new mount target
	Gateway *string `json:"gateway,omitempty"`
	// Netmask - The netmask of the IPv4 address range to use when creating a new mount target
	Netmask *string `json:"netmask,omitempty"`
	// ProvisioningState - Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Operation microsoft.NetApp REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The origin of operations.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Properties of operation, include metric specifications.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft NetApp.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Cloud Volume operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Storage operations supported by the Storage resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationProperties properties of operation, include metric specifications.
type OperationProperties struct {
	// ServiceSpecification - One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PoolProperties pool properties
type PoolProperties struct {
	// PoolID - UUID v4 used to identify the Pool
	PoolID *string `json:"poolId,omitempty"`
	// Size - Provisioned size of the pool (in bytes). Allowed values are in 4TiB chunks (value must be multiply of 4398046511104).
	Size *int64 `json:"size,omitempty"`
	// ServiceLevel - The service level of the file system. Possible values include: 'Standard', 'Premium', 'Extreme'
	ServiceLevel ServiceLevel `json:"serviceLevel,omitempty"`
	// ProvisioningState - Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// PoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PoolsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PoolsCreateOrUpdateFuture) Result(client PoolsClient) (cp CapacityPool, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.PoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.PoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cp.Response.Response, err = future.GetResult(sender); err == nil && cp.Response.Response.StatusCode != http.StatusNoContent {
		cp, err = client.CreateOrUpdateResponder(cp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "netapp.PoolsCreateOrUpdateFuture", "Result", cp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type PoolsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PoolsDeleteFuture) Result(client PoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.PoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.PoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceSpecification one property of operation, include metric specifications.
type ServiceSpecification struct {
	// MetricSpecifications - Metric specifications of operation.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Snapshot snapshot of a Volume
type Snapshot struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// SnapshotProperties - Snapshot Properties
	*SnapshotProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Type != nil {
		objectMap["type"] = s.Type
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.SnapshotProperties != nil {
		objectMap["properties"] = s.SnapshotProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Snapshot struct.
func (s *Snapshot) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "properties":
			if v != nil {
				var snapshotProperties SnapshotProperties
				err = json.Unmarshal(*v, &snapshotProperties)
				if err != nil {
					return err
				}
				s.SnapshotProperties = &snapshotProperties
			}
		}
	}

	return nil
}

// SnapshotPatch snapshot patch
type SnapshotPatch struct {
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
}

// SnapshotProperties snapshot properties
type SnapshotProperties struct {
	// SnapshotID - UUID v4 used to identify the Snapshot
	SnapshotID *string `json:"snapshotId,omitempty"`
	// FileSystemID - UUID v4 used to identify the FileSystem
	FileSystemID *string `json:"fileSystemId,omitempty"`
	// CreationDate - The creation date of the snapshot
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ProvisioningState - Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// SnapshotsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SnapshotsCreateFuture) Result(client SnapshotsClient) (s Snapshot, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.SnapshotsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.SnapshotsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "netapp.SnapshotsCreateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SnapshotsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SnapshotsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SnapshotsDeleteFuture) Result(client SnapshotsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.SnapshotsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.SnapshotsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SnapshotsList list of Snapshots
type SnapshotsList struct {
	autorest.Response `json:"-"`
	// Value - A list of Snapshots
	Value *[]Snapshot `json:"value,omitempty"`
}

// Volume volume resource
type Volume struct {
	autorest.Response `json:"-"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// VolumeProperties - Volume properties
	*VolumeProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Volume.
func (vVar Volume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.Location != nil {
		objectMap["location"] = vVar.Location
	}
	if vVar.ID != nil {
		objectMap["id"] = vVar.ID
	}
	if vVar.Name != nil {
		objectMap["name"] = vVar.Name
	}
	if vVar.Type != nil {
		objectMap["type"] = vVar.Type
	}
	if vVar.Tags != nil {
		objectMap["tags"] = vVar.Tags
	}
	if vVar.VolumeProperties != nil {
		objectMap["properties"] = vVar.VolumeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Volume struct.
func (vVar *Volume) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vVar.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vVar.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vVar.Tags = tags
			}
		case "properties":
			if v != nil {
				var volumeProperties VolumeProperties
				err = json.Unmarshal(*v, &volumeProperties)
				if err != nil {
					return err
				}
				vVar.VolumeProperties = &volumeProperties
			}
		}
	}

	return nil
}

// VolumeList list of volume resources
type VolumeList struct {
	autorest.Response `json:"-"`
	// Value - List of volumes
	Value *[]Volume `json:"value,omitempty"`
}

// VolumePatch volume patch resource
type VolumePatch struct {
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags interface{} `json:"tags,omitempty"`
	// VolumePatchProperties - Patchable volume properties
	*VolumePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VolumePatch.
func (vp VolumePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.Location != nil {
		objectMap["location"] = vp.Location
	}
	if vp.ID != nil {
		objectMap["id"] = vp.ID
	}
	if vp.Name != nil {
		objectMap["name"] = vp.Name
	}
	if vp.Type != nil {
		objectMap["type"] = vp.Type
	}
	if vp.Tags != nil {
		objectMap["tags"] = vp.Tags
	}
	if vp.VolumePatchProperties != nil {
		objectMap["properties"] = vp.VolumePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VolumePatch struct.
func (vp *VolumePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vp.Tags = tags
			}
		case "properties":
			if v != nil {
				var volumePatchProperties VolumePatchProperties
				err = json.Unmarshal(*v, &volumePatchProperties)
				if err != nil {
					return err
				}
				vp.VolumePatchProperties = &volumePatchProperties
			}
		}
	}

	return nil
}

// VolumePatchProperties patchable volume properties
type VolumePatchProperties struct {
	// ServiceLevel - The service level of the file system. Possible values include: 'Standard', 'Premium', 'Extreme'
	ServiceLevel ServiceLevel `json:"serviceLevel,omitempty"`
	// UsageThreshold - Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB.
	UsageThreshold *int64 `json:"usageThreshold,omitempty"`
}

// VolumeProperties volume properties
type VolumeProperties struct {
	// FileSystemID - Unique FileSystem Identifier.
	FileSystemID *string `json:"fileSystemId,omitempty"`
	// CreationToken - A unique file path for the volume. Used when creating mount targets
	CreationToken *string `json:"creationToken,omitempty"`
	// ServiceLevel - The service level of the file system. Possible values include: 'Standard', 'Premium', 'Extreme'
	ServiceLevel ServiceLevel `json:"serviceLevel,omitempty"`
	// UsageThreshold - Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB.
	UsageThreshold *int64 `json:"usageThreshold,omitempty"`
	// ProvisioningState - Azure lifecycle management
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// SubnetID - The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
	SubnetID *string `json:"subnetId,omitempty"`
}

// VolumesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VolumesCreateOrUpdateFuture) Result(client VolumesClient) (vVar Volume, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.VolumesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.VolumesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vVar.Response.Response, err = future.GetResult(sender); err == nil && vVar.Response.Response.StatusCode != http.StatusNoContent {
		vVar, err = client.CreateOrUpdateResponder(vVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "netapp.VolumesCreateOrUpdateFuture", "Result", vVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VolumesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VolumesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VolumesDeleteFuture) Result(client VolumesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "netapp.VolumesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("netapp.VolumesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}
