// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/cloud/irm/v1alpha2/incidents_service.proto

package irm

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request for the CreateIncident method.
type CreateIncidentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The incident to create.
	Incident *Incident `protobuf:"bytes,1,opt,name=incident,proto3" json:"incident,omitempty"`
	// Required. The resource name of the hosting Stackdriver project which the incident
	// belongs to.
	// The name is of the form `projects/{project_id_or_number}`
	// .
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateIncidentRequest) Reset() {
	*x = CreateIncidentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIncidentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIncidentRequest) ProtoMessage() {}

func (x *CreateIncidentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIncidentRequest.ProtoReflect.Descriptor instead.
func (*CreateIncidentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateIncidentRequest) GetIncident() *Incident {
	if x != nil {
		return x.Incident
	}
	return nil
}

func (x *CreateIncidentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request for the GetIncident method.
type GetIncidentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIncidentRequest) Reset() {
	*x = GetIncidentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIncidentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIncidentRequest) ProtoMessage() {}

func (x *GetIncidentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIncidentRequest.ProtoReflect.Descriptor instead.
func (*GetIncidentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetIncidentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the UpdateIncident method.
type UpdateIncidentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The incident to update with the new values.
	Incident *Incident `protobuf:"bytes,1,opt,name=incident,proto3" json:"incident,omitempty"`
	// List of fields that should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIncidentRequest) Reset() {
	*x = UpdateIncidentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIncidentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIncidentRequest) ProtoMessage() {}

func (x *UpdateIncidentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIncidentRequest.ProtoReflect.Descriptor instead.
func (*UpdateIncidentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateIncidentRequest) GetIncident() *Incident {
	if x != nil {
		return x.Incident
	}
	return nil
}

func (x *UpdateIncidentRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the SearchSimilarIncidents method.
type SearchSimilarIncidentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident or signal, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Number of similar incidents to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in 'next_page_token'.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchSimilarIncidentsRequest) Reset() {
	*x = SearchSimilarIncidentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchSimilarIncidentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchSimilarIncidentsRequest) ProtoMessage() {}

func (x *SearchSimilarIncidentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchSimilarIncidentsRequest.ProtoReflect.Descriptor instead.
func (*SearchSimilarIncidentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{3}
}

func (x *SearchSimilarIncidentsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchSimilarIncidentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchSimilarIncidentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the SearchSimilarIncidents method.
type SearchSimilarIncidentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The search results, ordered by descending relevance.
	Results []*SearchSimilarIncidentsResponse_Result `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Page token to fetch the next set of similar incidents.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchSimilarIncidentsResponse) Reset() {
	*x = SearchSimilarIncidentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchSimilarIncidentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchSimilarIncidentsResponse) ProtoMessage() {}

func (x *SearchSimilarIncidentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchSimilarIncidentsResponse.ProtoReflect.Descriptor instead.
func (*SearchSimilarIncidentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{4}
}

func (x *SearchSimilarIncidentsResponse) GetResults() []*SearchSimilarIncidentsResponse_Result {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchSimilarIncidentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the CreateAnnotation method.
type CreateAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Only annotation.content is an input argument.
	Annotation *Annotation `protobuf:"bytes,2,opt,name=annotation,proto3" json:"annotation,omitempty"`
}

func (x *CreateAnnotationRequest) Reset() {
	*x = CreateAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnnotationRequest) ProtoMessage() {}

func (x *CreateAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnnotationRequest.ProtoReflect.Descriptor instead.
func (*CreateAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateAnnotationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnnotationRequest) GetAnnotation() *Annotation {
	if x != nil {
		return x.Annotation
	}
	return nil
}

// Request for the ListAnnotations method.
type ListAnnotationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of annotations to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAnnotationsRequest) Reset() {
	*x = ListAnnotationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationsRequest) ProtoMessage() {}

func (x *ListAnnotationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationsRequest.ProtoReflect.Descriptor instead.
func (*ListAnnotationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListAnnotationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnnotationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnnotationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the ListAnnotations method.
type ListAnnotationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of annotations.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Page token to fetch the next set of annotations.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnnotationsResponse) Reset() {
	*x = ListAnnotationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationsResponse) ProtoMessage() {}

func (x *ListAnnotationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationsResponse.ProtoReflect.Descriptor instead.
func (*ListAnnotationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{7}
}

func (x *ListAnnotationsResponse) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ListAnnotationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the CreateTag method.
type CreateTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Tag to create. Only tag.display_name is an input argument.
	Tag *Tag `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *CreateTagRequest) Reset() {
	*x = CreateTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTagRequest) ProtoMessage() {}

func (x *CreateTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTagRequest.ProtoReflect.Descriptor instead.
func (*CreateTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{8}
}

func (x *CreateTagRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTagRequest) GetTag() *Tag {
	if x != nil {
		return x.Tag
	}
	return nil
}

// Request for the DeleteTag method.
type DeleteTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the tag.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTagRequest) Reset() {
	*x = DeleteTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTagRequest) ProtoMessage() {}

func (x *DeleteTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTagRequest.ProtoReflect.Descriptor instead.
func (*DeleteTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteTagRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the ListTagsForIncident method.
type ListTagsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of tags to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTagsRequest) Reset() {
	*x = ListTagsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTagsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTagsRequest) ProtoMessage() {}

func (x *ListTagsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTagsRequest.ProtoReflect.Descriptor instead.
func (*ListTagsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListTagsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTagsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTagsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the ListTagsForIncident method.
type ListTagsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tags.
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// Page token to fetch the next set of tags.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTagsResponse) Reset() {
	*x = ListTagsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTagsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTagsResponse) ProtoMessage() {}

func (x *ListTagsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTagsResponse.ProtoReflect.Descriptor instead.
func (*ListTagsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListTagsResponse) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *ListTagsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the CreateSignal method.
type CreateSignalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the hosting Stackdriver project which requested
	// signal belongs to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The signal to create.
	Signal *Signal `protobuf:"bytes,2,opt,name=signal,proto3" json:"signal,omitempty"`
}

func (x *CreateSignalRequest) Reset() {
	*x = CreateSignalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSignalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSignalRequest) ProtoMessage() {}

func (x *CreateSignalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSignalRequest.ProtoReflect.Descriptor instead.
func (*CreateSignalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{12}
}

func (x *CreateSignalRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSignalRequest) GetSignal() *Signal {
	if x != nil {
		return x.Signal
	}
	return nil
}

// Request for the SearchSignals method.
type SearchSignalsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the hosting Stackdriver project which requested
	// incidents belong to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression that defines which signals to return.
	//
	// Search atoms can be used to match certain specific fields.  Otherwise,
	// plain text will match text fields in the signal.
	//
	// Search atoms:
	//
	// * `start` - (timestamp) The time the signal was created.
	// * `title` - The title of the signal.
	// * `signal_state` - `open` or `closed`. State of the signal.
	//   (e.g., `signal_state:open`)
	//
	// Timestamp formats:
	//
	// * yyyy-MM-dd - an absolute date, treated as a calendar-day-wide window.
	//   In other words, the "<" operator will match dates before that date, the
	//   ">" operator will match dates after that date, and the ":" operator will
	//   match the entire day.
	// * yyyy-MM-ddTHH:mm - Same as above, but with minute resolution.
	// * yyyy-MM-ddTHH:mm:ss - Same as above, but with second resolution.
	// * Nd (e.g. 7d) - a relative number of days ago, treated as a moment in time
	//   (as opposed to a day-wide span) a multiple of 24 hours ago (as opposed to
	//   calendar days).  In the case of daylight savings time, it will apply the
	//   current timezone to both ends of the range.  Note that exact matching
	//   (e.g. `start:7d`) is unlikely to be useful because that would only match
	//   signals created precisely at a particular instant in time.
	//
	// The absolute timestamp formats (everything starting with a year) can
	// optionally be followed with a UTC offset in +/-hh:mm format.  Also, the 'T'
	// separating dates and times can optionally be replaced with a space. Note
	// that any timestamp containing a space or colon will need to be quoted.
	//
	// Examples:
	//
	// * `foo` - matches signals containing the word "foo"
	// * `"foo bar"` - matches signals containing the phrase "foo bar"
	// * `foo bar` or `foo AND bar` - matches signals containing the words
	//   "foo" and "bar"
	// * `foo -bar` or `foo AND NOT bar` - matches signals containing the
	//   word
	//   "foo" but not the word "bar"
	// * `foo OR bar` - matches signals containing the word "foo" or the
	//   word "bar"
	// * `start>2018-11-28` - matches signals which started after November
	//   11, 2018.
	// * `start<=2018-11-28` - matches signals which started on or before
	//   November 11, 2018.
	// * `start:2018-11-28` - matches signals which started on November 11,
	//   2018.
	// * `start>"2018-11-28 01:02:03+04:00"` - matches signals which started
	//   after November 11, 2018 at 1:02:03 AM according to the UTC+04 time
	//   zone.
	// * `start>7d` - matches signals which started after the point in time
	//   7*24 hours ago
	// * `start>180d` - similar to 7d, but likely to cross the daylight savings
	//   time boundary, so the end time will be 1 hour different from "now."
	// * `foo AND start>90d AND stage<resolved` - unresolved signals from
	//   the past 90 days containing the word "foo"
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Maximum number of `signals` to return in the response.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`. All
	// field values except for page_size and page_token should be the same as the
	// original query (may return an error or unexpected data otherwise).
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchSignalsRequest) Reset() {
	*x = SearchSignalsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchSignalsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchSignalsRequest) ProtoMessage() {}

func (x *SearchSignalsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchSignalsRequest.ProtoReflect.Descriptor instead.
func (*SearchSignalsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{13}
}

func (x *SearchSignalsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchSignalsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchSignalsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchSignalsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the SearchSignals method.
type SearchSignalsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Signals that matched the query in the request.
	Signals []*Signal `protobuf:"bytes,1,rep,name=signals,proto3" json:"signals,omitempty"`
	// Page token to fetch the next set of signals.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchSignalsResponse) Reset() {
	*x = SearchSignalsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchSignalsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchSignalsResponse) ProtoMessage() {}

func (x *SearchSignalsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchSignalsResponse.ProtoReflect.Descriptor instead.
func (*SearchSignalsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{14}
}

func (x *SearchSignalsResponse) GetSignals() []*Signal {
	if x != nil {
		return x.Signals
	}
	return nil
}

func (x *SearchSignalsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the GetSignal method.
type GetSignalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the Signal resource, for example,
	// "projects/{project_id_or_number}/signals/{signal_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSignalRequest) Reset() {
	*x = GetSignalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSignalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSignalRequest) ProtoMessage() {}

func (x *GetSignalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSignalRequest.ProtoReflect.Descriptor instead.
func (*GetSignalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{15}
}

func (x *GetSignalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the LookupSignal method.
type LookupSignalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID to use for lookup.
	//
	// Types that are assignable to AlternateId:
	//	*LookupSignalRequest_CsccFinding
	//	*LookupSignalRequest_StackdriverNotificationId
	AlternateId isLookupSignalRequest_AlternateId `protobuf_oneof:"alternate_id"`
}

func (x *LookupSignalRequest) Reset() {
	*x = LookupSignalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LookupSignalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupSignalRequest) ProtoMessage() {}

func (x *LookupSignalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupSignalRequest.ProtoReflect.Descriptor instead.
func (*LookupSignalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{16}
}

func (m *LookupSignalRequest) GetAlternateId() isLookupSignalRequest_AlternateId {
	if m != nil {
		return m.AlternateId
	}
	return nil
}

func (x *LookupSignalRequest) GetCsccFinding() string {
	if x, ok := x.GetAlternateId().(*LookupSignalRequest_CsccFinding); ok {
		return x.CsccFinding
	}
	return ""
}

func (x *LookupSignalRequest) GetStackdriverNotificationId() string {
	if x, ok := x.GetAlternateId().(*LookupSignalRequest_StackdriverNotificationId); ok {
		return x.StackdriverNotificationId
	}
	return ""
}

type isLookupSignalRequest_AlternateId interface {
	isLookupSignalRequest_AlternateId()
}

type LookupSignalRequest_CsccFinding struct {
	// Required. Full resource name of the CSCC finding id this signal refers to (e.g.
	// "organizations/abc/sources/123/findings/xyz")
	CsccFinding string `protobuf:"bytes,2,opt,name=cscc_finding,json=csccFinding,proto3,oneof"`
}

type LookupSignalRequest_StackdriverNotificationId struct {
	// The ID from the Stackdriver Alerting notification.
	StackdriverNotificationId string `protobuf:"bytes,3,opt,name=stackdriver_notification_id,json=stackdriverNotificationId,proto3,oneof"`
}

func (*LookupSignalRequest_CsccFinding) isLookupSignalRequest_AlternateId() {}

func (*LookupSignalRequest_StackdriverNotificationId) isLookupSignalRequest_AlternateId() {}

// Request for the UpdateSignal method.
type UpdateSignalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The signal to update with the new values.
	Signal *Signal `protobuf:"bytes,1,opt,name=signal,proto3" json:"signal,omitempty"`
	// List of fields that should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSignalRequest) Reset() {
	*x = UpdateSignalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSignalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSignalRequest) ProtoMessage() {}

func (x *UpdateSignalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSignalRequest.ProtoReflect.Descriptor instead.
func (*UpdateSignalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{17}
}

func (x *UpdateSignalRequest) GetSignal() *Signal {
	if x != nil {
		return x.Signal
	}
	return nil
}

func (x *UpdateSignalRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the SearchIncidents method.
type SearchIncidentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the hosting Stackdriver project which requested
	// incidents belong to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression that defines which incidents to return.
	//
	// Search atoms can be used to match certain specific fields.  Otherwise,
	// plain text will match text fields in the incident.
	//
	// Search atoms:
	// * `start` - (timestamp) The time the incident started.
	// * `stage` - The stage of the incident, one of detected, triaged, mitigated,
	//   resolved, documented, or duplicate (which correspond to values in the
	//   Incident.Stage enum). These are ordered, so `stage<resolved` is
	//   equivalent to `stage:detected OR stage:triaged OR stage:mitigated`.
	// * `severity` - (Incident.Severity) The severity of the incident.
	//    + Supports matching on a specific severity (for example,
	//    `severity:major`) or on a range (for example, `severity>medium`,
	//    `severity<=minor`, etc.).
	//
	// Timestamp formats:
	// * yyyy-MM-dd - an absolute date, treated as a calendar-day-wide window.
	//   In other words, the "<" operator will match dates before that date, the
	//   ">" operator will match dates after that date, and the ":" or "="
	//   operators will match the entire day.
	// * Nd (for example, 7d) - a relative number of days ago, treated as a moment
	//   in time (as opposed to a day-wide span). A multiple of 24 hours ago (as
	//   opposed to calendar days).  In the case of daylight savings time, it will
	//   apply the current timezone to both ends of the range.  Note that exact
	//   matching (for example, `start:7d`) is unlikely to be useful because that
	//   would only match incidents created precisely at a particular instant in
	//   time.
	//
	// Examples:
	//
	// * `foo` - matches incidents containing the word "foo"
	// * `"foo bar"` - matches incidents containing the phrase "foo bar"
	// * `foo bar` or `foo AND bar` - matches incidents containing the words "foo"
	//   and "bar"
	// * `foo -bar` or `foo AND NOT bar` - matches incidents containing the word
	//   "foo" but not the word "bar"
	// * `foo OR bar` - matches incidents containing the word "foo" or the word
	//   "bar"
	// * `start>2018-11-28` - matches incidents which started after November 11,
	//   2018.
	// * `start<=2018-11-28` - matches incidents which started on or before
	//   November 11, 2018.
	// * `start:2018-11-28` - matches incidents which started on November 11,
	//   2018.
	// * `start>7d` - matches incidents which started after the point in time 7*24
	//   hours ago
	// * `start>180d` - similar to 7d, but likely to cross the daylight savings
	//   time boundary, so the end time will be 1 hour different from "now."
	// * `foo AND start>90d AND stage<resolved` - unresolved incidents from the
	//   past 90 days containing the word "foo"
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Number of incidents to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The time zone name. It should be an IANA TZ name, such as
	// "America/Los_Angeles". For more information,
	// see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones.
	// If no time zone is specified, the default is UTC.
	TimeZone string `protobuf:"bytes,5,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
}

func (x *SearchIncidentsRequest) Reset() {
	*x = SearchIncidentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchIncidentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchIncidentsRequest) ProtoMessage() {}

func (x *SearchIncidentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchIncidentsRequest.ProtoReflect.Descriptor instead.
func (*SearchIncidentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{18}
}

func (x *SearchIncidentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchIncidentsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchIncidentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchIncidentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchIncidentsRequest) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

// Response for the SearchIncidents method.
type SearchIncidentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Incidents.
	Incidents []*Incident `protobuf:"bytes,1,rep,name=incidents,proto3" json:"incidents,omitempty"`
	// Page token to fetch the next set of incidents.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchIncidentsResponse) Reset() {
	*x = SearchIncidentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchIncidentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchIncidentsResponse) ProtoMessage() {}

func (x *SearchIncidentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchIncidentsResponse.ProtoReflect.Descriptor instead.
func (*SearchIncidentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{19}
}

func (x *SearchIncidentsResponse) GetIncidents() []*Incident {
	if x != nil {
		return x.Incidents
	}
	return nil
}

func (x *SearchIncidentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to escalate an incident.
type EscalateIncidentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The incident to escalate with the new values.
	Incident *Incident `protobuf:"bytes,1,opt,name=incident,proto3" json:"incident,omitempty"`
	// List of fields that should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Subscriptions to add or update. Existing subscriptions with the same
	// channel and address as a subscription in the list will be updated.
	Subscriptions []*Subscription `protobuf:"bytes,3,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// Tags to add. Tags identical to existing tags will be ignored.
	Tags []*Tag `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
	// Roles to add or update. Existing roles with the same type (and title, for
	// TYPE_OTHER roles) will be updated.
	Roles []*IncidentRoleAssignment `protobuf:"bytes,5,rep,name=roles,proto3" json:"roles,omitempty"`
	// Artifacts to add. All artifacts are added without checking for duplicates.
	Artifacts []*Artifact `protobuf:"bytes,6,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
}

func (x *EscalateIncidentRequest) Reset() {
	*x = EscalateIncidentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EscalateIncidentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EscalateIncidentRequest) ProtoMessage() {}

func (x *EscalateIncidentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EscalateIncidentRequest.ProtoReflect.Descriptor instead.
func (*EscalateIncidentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{20}
}

func (x *EscalateIncidentRequest) GetIncident() *Incident {
	if x != nil {
		return x.Incident
	}
	return nil
}

func (x *EscalateIncidentRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *EscalateIncidentRequest) GetSubscriptions() []*Subscription {
	if x != nil {
		return x.Subscriptions
	}
	return nil
}

func (x *EscalateIncidentRequest) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *EscalateIncidentRequest) GetRoles() []*IncidentRoleAssignment {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *EscalateIncidentRequest) GetArtifacts() []*Artifact {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

// Response for EscalateIncident.
type EscalateIncidentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The escalated incident.
	Incident *Incident `protobuf:"bytes,1,opt,name=incident,proto3" json:"incident,omitempty"`
	// New or modified subscriptions.
	Subscriptions []*Subscription `protobuf:"bytes,2,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// New or modified tags.
	Tags []*Tag `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`
	// New or modified roles.
	Roles []*IncidentRole `protobuf:"bytes,4,rep,name=roles,proto3" json:"roles,omitempty"`
	// New or modified artifacts.
	Artifacts []*Artifact `protobuf:"bytes,5,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
}

func (x *EscalateIncidentResponse) Reset() {
	*x = EscalateIncidentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EscalateIncidentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EscalateIncidentResponse) ProtoMessage() {}

func (x *EscalateIncidentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EscalateIncidentResponse.ProtoReflect.Descriptor instead.
func (*EscalateIncidentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{21}
}

func (x *EscalateIncidentResponse) GetIncident() *Incident {
	if x != nil {
		return x.Incident
	}
	return nil
}

func (x *EscalateIncidentResponse) GetSubscriptions() []*Subscription {
	if x != nil {
		return x.Subscriptions
	}
	return nil
}

func (x *EscalateIncidentResponse) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *EscalateIncidentResponse) GetRoles() []*IncidentRole {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *EscalateIncidentResponse) GetArtifacts() []*Artifact {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

// Request for the CreateArtifact method.
type CreateArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The artifact to create.
	Artifact *Artifact `protobuf:"bytes,2,opt,name=artifact,proto3" json:"artifact,omitempty"`
}

func (x *CreateArtifactRequest) Reset() {
	*x = CreateArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateArtifactRequest) ProtoMessage() {}

func (x *CreateArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateArtifactRequest.ProtoReflect.Descriptor instead.
func (*CreateArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{22}
}

func (x *CreateArtifactRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateArtifactRequest) GetArtifact() *Artifact {
	if x != nil {
		return x.Artifact
	}
	return nil
}

// Request for the ListArtifacts method.
type ListArtifactsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of artifacts to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListArtifactsRequest) Reset() {
	*x = ListArtifactsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListArtifactsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListArtifactsRequest) ProtoMessage() {}

func (x *ListArtifactsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListArtifactsRequest.ProtoReflect.Descriptor instead.
func (*ListArtifactsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{23}
}

func (x *ListArtifactsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListArtifactsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListArtifactsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the ListArtifacts method.
type ListArtifactsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of artifacts.
	Artifacts []*Artifact `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	// Page token to fetch the next set of artifacts.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListArtifactsResponse) Reset() {
	*x = ListArtifactsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListArtifactsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListArtifactsResponse) ProtoMessage() {}

func (x *ListArtifactsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListArtifactsResponse.ProtoReflect.Descriptor instead.
func (*ListArtifactsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{24}
}

func (x *ListArtifactsResponse) GetArtifacts() []*Artifact {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

func (x *ListArtifactsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the UpdateArtifact method.
type UpdateArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The artifact to update with the new values.
	Artifact *Artifact `protobuf:"bytes,1,opt,name=artifact,proto3" json:"artifact,omitempty"`
	// List of fields that should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateArtifactRequest) Reset() {
	*x = UpdateArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateArtifactRequest) ProtoMessage() {}

func (x *UpdateArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateArtifactRequest.ProtoReflect.Descriptor instead.
func (*UpdateArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{25}
}

func (x *UpdateArtifactRequest) GetArtifact() *Artifact {
	if x != nil {
		return x.Artifact
	}
	return nil
}

func (x *UpdateArtifactRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for deleting an artifact.
type DeleteArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the artifact.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteArtifactRequest) Reset() {
	*x = DeleteArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteArtifactRequest) ProtoMessage() {}

func (x *DeleteArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteArtifactRequest.ProtoReflect.Descriptor instead.
func (*DeleteArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteArtifactRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SendShiftHandoff and PreviewShiftHandoff RPC request.
type SendShiftHandoffRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Stackdriver project that the handoff is being sent
	// from. for example, `projects/{project_id_or_number}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Email addresses of the recipients of the handoff, for example,
	// "user@example.com". Must contain at least one entry.
	Recipients []string `protobuf:"bytes,2,rep,name=recipients,proto3" json:"recipients,omitempty"`
	// Optional. Email addresses that should be CC'd on the handoff.
	Cc []string `protobuf:"bytes,3,rep,name=cc,proto3" json:"cc,omitempty"`
	// Required. The subject of the email.
	Subject string `protobuf:"bytes,4,opt,name=subject,proto3" json:"subject,omitempty"`
	// Content type string, for example, 'text/plain' or 'text/html'.
	NotesContentType string `protobuf:"bytes,5,opt,name=notes_content_type,json=notesContentType,proto3" json:"notes_content_type,omitempty"`
	// Optional. Additional notes to be included in the handoff.
	NotesContent string `protobuf:"bytes,6,opt,name=notes_content,json=notesContent,proto3" json:"notes_content,omitempty"`
	// Optional. The set of incidents that should be included in the handoff.
	Incidents []*SendShiftHandoffRequest_Incident `protobuf:"bytes,7,rep,name=incidents,proto3" json:"incidents,omitempty"`
	// If set to true a ShiftHandoffResponse will be returned but the handoff
	// will not actually be sent.
	PreviewOnly bool `protobuf:"varint,8,opt,name=preview_only,json=previewOnly,proto3" json:"preview_only,omitempty"`
}

func (x *SendShiftHandoffRequest) Reset() {
	*x = SendShiftHandoffRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendShiftHandoffRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendShiftHandoffRequest) ProtoMessage() {}

func (x *SendShiftHandoffRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendShiftHandoffRequest.ProtoReflect.Descriptor instead.
func (*SendShiftHandoffRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{27}
}

func (x *SendShiftHandoffRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SendShiftHandoffRequest) GetRecipients() []string {
	if x != nil {
		return x.Recipients
	}
	return nil
}

func (x *SendShiftHandoffRequest) GetCc() []string {
	if x != nil {
		return x.Cc
	}
	return nil
}

func (x *SendShiftHandoffRequest) GetSubject() string {
	if x != nil {
		return x.Subject
	}
	return ""
}

func (x *SendShiftHandoffRequest) GetNotesContentType() string {
	if x != nil {
		return x.NotesContentType
	}
	return ""
}

func (x *SendShiftHandoffRequest) GetNotesContent() string {
	if x != nil {
		return x.NotesContent
	}
	return ""
}

func (x *SendShiftHandoffRequest) GetIncidents() []*SendShiftHandoffRequest_Incident {
	if x != nil {
		return x.Incidents
	}
	return nil
}

func (x *SendShiftHandoffRequest) GetPreviewOnly() bool {
	if x != nil {
		return x.PreviewOnly
	}
	return false
}

// SendShiftHandoff and PreviewShiftHandoff RPC response.
type SendShiftHandoffResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content type string, for example, 'text/plain' or 'text/html'.
	ContentType string `protobuf:"bytes,1,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// The contents of the handoff that was sent or would have been sent (if the
	// request was preview_only).
	// This will typically contain a full HTML document.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *SendShiftHandoffResponse) Reset() {
	*x = SendShiftHandoffResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendShiftHandoffResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendShiftHandoffResponse) ProtoMessage() {}

func (x *SendShiftHandoffResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendShiftHandoffResponse.ProtoReflect.Descriptor instead.
func (*SendShiftHandoffResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{28}
}

func (x *SendShiftHandoffResponse) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

func (x *SendShiftHandoffResponse) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

// Request for the CreateSubscription method.
type CreateSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The subscription to create.
	Subscription *Subscription `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *CreateSubscriptionRequest) Reset() {
	*x = CreateSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSubscriptionRequest) ProtoMessage() {}

func (x *CreateSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*CreateSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{29}
}

func (x *CreateSubscriptionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSubscriptionRequest) GetSubscription() *Subscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

// Request for the UpdateSubscription method.
type UpdateSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The subscription to update, with new values.
	Subscription *Subscription `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// List of fields that should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSubscriptionRequest) Reset() {
	*x = UpdateSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSubscriptionRequest) ProtoMessage() {}

func (x *UpdateSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*UpdateSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateSubscriptionRequest) GetSubscription() *Subscription {
	if x != nil {
		return x.Subscription
	}
	return nil
}

func (x *UpdateSubscriptionRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the ListSubscriptions method.
type ListSubscriptionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of subscriptions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSubscriptionsRequest) Reset() {
	*x = ListSubscriptionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubscriptionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubscriptionsRequest) ProtoMessage() {}

func (x *ListSubscriptionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubscriptionsRequest.ProtoReflect.Descriptor instead.
func (*ListSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{31}
}

func (x *ListSubscriptionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSubscriptionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSubscriptionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the ListSubscriptions method.
type ListSubscriptionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of subscriptions.
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// Page token to fetch the next set of subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSubscriptionsResponse) Reset() {
	*x = ListSubscriptionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubscriptionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubscriptionsResponse) ProtoMessage() {}

func (x *ListSubscriptionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubscriptionsResponse.ProtoReflect.Descriptor instead.
func (*ListSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{32}
}

func (x *ListSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if x != nil {
		return x.Subscriptions
	}
	return nil
}

func (x *ListSubscriptionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for deleting a subscription.
type DeleteSubscriptionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the subscription.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSubscriptionRequest) Reset() {
	*x = DeleteSubscriptionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSubscriptionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSubscriptionRequest) ProtoMessage() {}

func (x *DeleteSubscriptionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSubscriptionRequest.ProtoReflect.Descriptor instead.
func (*DeleteSubscriptionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{33}
}

func (x *DeleteSubscriptionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for creating a role assignment.
type CreateIncidentRoleAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Role assignment to create.
	IncidentRoleAssignment *IncidentRoleAssignment `protobuf:"bytes,2,opt,name=incident_role_assignment,json=incidentRoleAssignment,proto3" json:"incident_role_assignment,omitempty"`
}

func (x *CreateIncidentRoleAssignmentRequest) Reset() {
	*x = CreateIncidentRoleAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIncidentRoleAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIncidentRoleAssignmentRequest) ProtoMessage() {}

func (x *CreateIncidentRoleAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIncidentRoleAssignmentRequest.ProtoReflect.Descriptor instead.
func (*CreateIncidentRoleAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{34}
}

func (x *CreateIncidentRoleAssignmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateIncidentRoleAssignmentRequest) GetIncidentRoleAssignment() *IncidentRoleAssignment {
	if x != nil {
		return x.IncidentRoleAssignment
	}
	return nil
}

// Request for deleting a role assignment.
type DeleteIncidentRoleAssignmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the role assignment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIncidentRoleAssignmentRequest) Reset() {
	*x = DeleteIncidentRoleAssignmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIncidentRoleAssignmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIncidentRoleAssignmentRequest) ProtoMessage() {}

func (x *DeleteIncidentRoleAssignmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIncidentRoleAssignmentRequest.ProtoReflect.Descriptor instead.
func (*DeleteIncidentRoleAssignmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteIncidentRoleAssignmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list role assignments of an incident.
type ListIncidentRoleAssignmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of assignments to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListIncidentRoleAssignmentsRequest) Reset() {
	*x = ListIncidentRoleAssignmentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIncidentRoleAssignmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIncidentRoleAssignmentsRequest) ProtoMessage() {}

func (x *ListIncidentRoleAssignmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIncidentRoleAssignmentsRequest.ProtoReflect.Descriptor instead.
func (*ListIncidentRoleAssignmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{36}
}

func (x *ListIncidentRoleAssignmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListIncidentRoleAssignmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListIncidentRoleAssignmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the ListIncidentRoleAssignments method.
type ListIncidentRoleAssignmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of assignments.
	IncidentRoleAssignments []*IncidentRoleAssignment `protobuf:"bytes,1,rep,name=incident_role_assignments,json=incidentRoleAssignments,proto3" json:"incident_role_assignments,omitempty"`
	// Page token to fetch the next set of assignments.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListIncidentRoleAssignmentsResponse) Reset() {
	*x = ListIncidentRoleAssignmentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIncidentRoleAssignmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIncidentRoleAssignmentsResponse) ProtoMessage() {}

func (x *ListIncidentRoleAssignmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIncidentRoleAssignmentsResponse.ProtoReflect.Descriptor instead.
func (*ListIncidentRoleAssignmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{37}
}

func (x *ListIncidentRoleAssignmentsResponse) GetIncidentRoleAssignments() []*IncidentRoleAssignment {
	if x != nil {
		return x.IncidentRoleAssignments
	}
	return nil
}

func (x *ListIncidentRoleAssignmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to start a role handover.
type RequestIncidentRoleHandoverRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the role assignment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The proposed assignee.
	NewAssignee *User `protobuf:"bytes,2,opt,name=new_assignee,json=newAssignee,proto3" json:"new_assignee,omitempty"`
}

func (x *RequestIncidentRoleHandoverRequest) Reset() {
	*x = RequestIncidentRoleHandoverRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestIncidentRoleHandoverRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestIncidentRoleHandoverRequest) ProtoMessage() {}

func (x *RequestIncidentRoleHandoverRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestIncidentRoleHandoverRequest.ProtoReflect.Descriptor instead.
func (*RequestIncidentRoleHandoverRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{38}
}

func (x *RequestIncidentRoleHandoverRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RequestIncidentRoleHandoverRequest) GetNewAssignee() *User {
	if x != nil {
		return x.NewAssignee
	}
	return nil
}

// Request to confirm a role handover.
type ConfirmIncidentRoleHandoverRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the role assignment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The proposed assignee, who will now be the assignee. This should be the
	// current user; otherwise ForceRoleHandover should be called.
	NewAssignee *User `protobuf:"bytes,2,opt,name=new_assignee,json=newAssignee,proto3" json:"new_assignee,omitempty"`
}

func (x *ConfirmIncidentRoleHandoverRequest) Reset() {
	*x = ConfirmIncidentRoleHandoverRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfirmIncidentRoleHandoverRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfirmIncidentRoleHandoverRequest) ProtoMessage() {}

func (x *ConfirmIncidentRoleHandoverRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfirmIncidentRoleHandoverRequest.ProtoReflect.Descriptor instead.
func (*ConfirmIncidentRoleHandoverRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{39}
}

func (x *ConfirmIncidentRoleHandoverRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConfirmIncidentRoleHandoverRequest) GetNewAssignee() *User {
	if x != nil {
		return x.NewAssignee
	}
	return nil
}

// Request to force a role handover.
type ForceIncidentRoleHandoverRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the role assignment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The proposed assignee, who will now be the assignee. This should not be
	// the current user; otherwise ConfirmRoleHandover should be called.
	NewAssignee *User `protobuf:"bytes,2,opt,name=new_assignee,json=newAssignee,proto3" json:"new_assignee,omitempty"`
}

func (x *ForceIncidentRoleHandoverRequest) Reset() {
	*x = ForceIncidentRoleHandoverRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForceIncidentRoleHandoverRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForceIncidentRoleHandoverRequest) ProtoMessage() {}

func (x *ForceIncidentRoleHandoverRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForceIncidentRoleHandoverRequest.ProtoReflect.Descriptor instead.
func (*ForceIncidentRoleHandoverRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{40}
}

func (x *ForceIncidentRoleHandoverRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ForceIncidentRoleHandoverRequest) GetNewAssignee() *User {
	if x != nil {
		return x.NewAssignee
	}
	return nil
}

// Request to cancel a role handover.
type CancelIncidentRoleHandoverRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the role assignment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Person who was proposed as the next assignee (i.e.
	// IncidentRoleAssignment.proposed_assignee) and whose proposal is being
	// cancelled.
	NewAssignee *User `protobuf:"bytes,2,opt,name=new_assignee,json=newAssignee,proto3" json:"new_assignee,omitempty"`
}

func (x *CancelIncidentRoleHandoverRequest) Reset() {
	*x = CancelIncidentRoleHandoverRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelIncidentRoleHandoverRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelIncidentRoleHandoverRequest) ProtoMessage() {}

func (x *CancelIncidentRoleHandoverRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelIncidentRoleHandoverRequest.ProtoReflect.Descriptor instead.
func (*CancelIncidentRoleHandoverRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{41}
}

func (x *CancelIncidentRoleHandoverRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CancelIncidentRoleHandoverRequest) GetNewAssignee() *User {
	if x != nil {
		return x.NewAssignee
	}
	return nil
}

// A single search result, i.e. an incident with (potentially) additional
// information.
type SearchSimilarIncidentsResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An incident that is "similar" to the incident or signal specified in the
	// request.
	Incident *Incident `protobuf:"bytes,1,opt,name=incident,proto3" json:"incident,omitempty"`
}

func (x *SearchSimilarIncidentsResponse_Result) Reset() {
	*x = SearchSimilarIncidentsResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchSimilarIncidentsResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchSimilarIncidentsResponse_Result) ProtoMessage() {}

func (x *SearchSimilarIncidentsResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchSimilarIncidentsResponse_Result.ProtoReflect.Descriptor instead.
func (*SearchSimilarIncidentsResponse_Result) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{4, 0}
}

func (x *SearchSimilarIncidentsResponse_Result) GetIncident() *Incident {
	if x != nil {
		return x.Incident
	}
	return nil
}

// Describes an incident for inclusion in the handoff.
// This is wrapped in a message to provide flexibility for potentially
// attaching additional data to each incident in the future.
type SendShiftHandoffRequest_Incident struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SendShiftHandoffRequest_Incident) Reset() {
	*x = SendShiftHandoffRequest_Incident{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SendShiftHandoffRequest_Incident) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SendShiftHandoffRequest_Incident) ProtoMessage() {}

func (x *SendShiftHandoffRequest_Incident) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SendShiftHandoffRequest_Incident.ProtoReflect.Descriptor instead.
func (*SendShiftHandoffRequest_Incident) Descriptor() ([]byte, []int) {
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP(), []int{27, 0}
}

func (x *SendShiftHandoffRequest_Incident) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_irm_v1alpha2_incidents_service_proto protoreflect.FileDescriptor

var file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x69, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x69, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x69, 0x6e, 0x63,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaa, 0x01, 0x0a,
	0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x08, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x4d, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x08, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x94, 0x01, 0x0a, 0x1d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xef, 0x01, 0x0a,
	0x1e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x49, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5a, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x1a, 0x49, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3f, 0x0a,
	0x08, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x22, 0xa2,
	0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x86, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x54, 0x61, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x74, 0x61, 0x67, 0x22, 0x46, 0x0a,
	0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x32, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x1e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x18, 0x0a, 0x16, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8a, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x6e, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x54, 0x61, 0x67, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x22, 0xb5, 0x01, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x7c, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x07, 0x73, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x07, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x49, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8c, 0x01, 0x0a, 0x13, 0x4c, 0x6f, 0x6f,
	0x6b, 0x75, 0x70, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x23, 0x0a, 0x0c, 0x63, 0x73, 0x63, 0x63, 0x5f, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x73, 0x63, 0x63, 0x46, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x0a, 0x1b, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x19, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x61, 0x6c, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x22, 0x92, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x06, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xd4, 0x01, 0x0a,
	0x16, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a,
	0x6f, 0x6e, 0x65, 0x22, 0x84, 0x01, 0x0a, 0x17, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x41, 0x0a, 0x09, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49,
	0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xab, 0x03, 0x0a, 0x17, 0x45,
	0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x08, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4d, 0x0a, 0x0d, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x32, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x54, 0x61, 0x67, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x47, 0x0a, 0x05,
	0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x05,
	0x72, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x09, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x22, 0xe0, 0x02, 0x0a, 0x18, 0x45, 0x73, 0x63,
	0x61, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x69, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x32, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x54, 0x61, 0x67, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x3d, 0x0a, 0x05, 0x72, 0x6f, 0x6c,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c,
	0x65, 0x52, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x52, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x22, 0x9a, 0x01, 0x0a, 0x15,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x44, 0x0a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x22, 0x8f, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x09, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x9a, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x08, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x50, 0x0a, 0x15,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdc,
	0x03, 0x0a, 0x17, 0x53, 0x65, 0x6e, 0x64, 0x53, 0x68, 0x69, 0x66, 0x74, 0x48, 0x61, 0x6e, 0x64,
	0x6f, 0x66, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x69, 0x70,
	0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x72, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x13, 0x0a, 0x02,
	0x63, 0x63, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x02, 0x63,
	0x63, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6e, 0x6f,
	0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28,
	0x0a, 0x0d, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x65,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x09, 0x69, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x53, 0x68, 0x69, 0x66,
	0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x69,
	0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4f, 0x6e, 0x6c, 0x79, 0x1a, 0x40, 0x0a, 0x08, 0x49,
	0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49,
	0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x57, 0x0a,
	0x18, 0x53, 0x65, 0x6e, 0x64, 0x53, 0x68, 0x69, 0x66, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66,
	0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0xaa, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x50, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xaa, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x50, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0x93, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x92, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x58, 0x0a, 0x19, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x23, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x70, 0x0a, 0x18, 0x69, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x16, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f,
	0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x5e, 0x0a, 0x23,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f,
	0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9d, 0x01, 0x0a,
	0x22, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c,
	0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x69, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbc, 0x01, 0x0a,
	0x23, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c,
	0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6d, 0x0a, 0x19, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x17, 0x69, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x86, 0x01, 0x0a, 0x22,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52,
	0x6f, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x6e,
	0x65, 0x77, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x22, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d,
	0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64,
	0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2b, 0x0a, 0x29, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f,
	0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x6e, 0x65, 0x77, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x6e, 0x65, 0x77, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x22, 0xb2, 0x01, 0x0a, 0x20,
	0x46, 0x6f, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c,
	0x65, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x69, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x6e, 0x65, 0x77, 0x5f, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65,
	0x22, 0xb3, 0x01, 0x0a, 0x21, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x69, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a,
	0x0c, 0x6e, 0x65, 0x77, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x32, 0xb9, 0x32, 0x0a, 0x0f, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb4, 0x01, 0x0a, 0x0e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x12, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x22, 0x27, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x08, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0xda,
	0x41, 0x0f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x99, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x47, 0x65,
	0x74, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x22, 0x36, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x12, 0x27, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc9, 0x01,
	0x0a, 0x0f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30,
	0x12, 0x2e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0xc2, 0x01, 0x0a, 0x0e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x12, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x32, 0x30, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x08, 0x69,
	0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x14, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x94,
	0x02, 0x0a, 0x16, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72,
	0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x69, 0x6d, 0x69,
	0x6c, 0x61, 0x72, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x49, 0x6e, 0x63,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x84,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x77, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x5a, 0x3e,
	0x12, 0x3c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x69,
	0x6d, 0x69, 0x6c, 0x61, 0x72, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xcc, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x22, 0x35, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0xc0, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa2, 0x01, 0x0a, 0x09, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x54,
	0x61, 0x67, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x3a, 0x03, 0x74, 0x61, 0x67, 0xda,
	0x41, 0x0a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x67, 0x12, 0x8f, 0x01, 0x0a,
	0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x61, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa4,
	0x01, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x67, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa8, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2f, 0x22, 0x25, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x3a, 0x06, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c,
	0x12, 0xb7, 0x01, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0xda, 0x41, 0x0c, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x83, 0x01, 0x0a, 0x0c, 0x4c,
	0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x22, 0x20,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1a, 0x12, 0x18, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x3a, 0x6c, 0x6f, 0x6f, 0x6b, 0x75, 0x70,
	0x12, 0x91, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x22, 0x34,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb4, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36,
	0x32, 0x2c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x73, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x06,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0xda, 0x41, 0x12, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xc1, 0x01, 0x0a, 0x10,
	0x45, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x45, 0x73, 0x63,
	0x61, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x45, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3e, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x69, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12,
	0xc0, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3f, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x3a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x12, 0xb8, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12,
	0x33, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xce, 0x01,
	0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x22, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x32,
	0x3c, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x08, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0xda, 0x41, 0x14, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x9e,
	0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x42, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xb7, 0x01, 0x0a, 0x10, 0x53, 0x65, 0x6e, 0x64, 0x53, 0x68, 0x69, 0x66, 0x74, 0x48, 0x61, 0x6e,
	0x64, 0x6f, 0x66, 0x66, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x53, 0x65, 0x6e, 0x64, 0x53, 0x68, 0x69, 0x66, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66,
	0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x64, 0x53, 0x68, 0x69, 0x66, 0x74, 0x48, 0x61,
	0x6e, 0x64, 0x6f, 0x66, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3a, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x34, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x68, 0x69, 0x66, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66,
	0x66, 0x3a, 0x73, 0x65, 0x6e, 0x64, 0x3a, 0x01, 0x2a, 0x12, 0xd8, 0x01, 0x0a, 0x12, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x3a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41,
	0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0xea, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x54, 0x32, 0x44, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x18, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x12, 0xc8, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xaa, 0x01, 0x0a,
	0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf9, 0x01, 0x0a, 0x1c, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x63,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52,
	0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x66, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x63,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xc0, 0x01, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x48,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe8, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12,
	0x39, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0xf9, 0x01, 0x0a, 0x1b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6f,
	0x76, 0x65, 0x72, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52,
	0x6f, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49,
	0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x68, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x22, 0x49, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x48, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x11, 0x6e, 0x61,
	0x6d, 0x65, 0x2c, 0x6e, 0x65, 0x77, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x12,
	0xf9, 0x01, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x72, 0x6d, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x48,
	0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x68, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x48, 0x61, 0x6e, 0x64,
	0x6f, 0x76, 0x65, 0x72, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x11, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6e,
	0x65, 0x77, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x12, 0xf3, 0x01, 0x0a, 0x19,
	0x46, 0x6f, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c,
	0x65, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x66, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4c, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x11,
	0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6e, 0x65, 0x77, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x65, 0x12, 0xf6, 0x01, 0x0a, 0x1a, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x49, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72,
	0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x49, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x48,
	0x61, 0x6e, 0x64, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x63, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x6f, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x48, 0x61, 0x6e, 0x64, 0x6f,
	0x76, 0x65, 0x72, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x11, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6e, 0x65,
	0x77, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x65, 0x1a, 0x46, 0xca, 0x41, 0x12, 0x69,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x68, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x72, 0x6d, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x61, 0x70, 0x69, 0x50, 0x01, 0x5a, 0x3c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x3b, 0x69, 0x72, 0x6d, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescOnce sync.Once
	file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescData = file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDesc
)

func file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescGZIP() []byte {
	file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescData)
	})
	return file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDescData
}

var file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes = make([]protoimpl.MessageInfo, 44)
var file_google_cloud_irm_v1alpha2_incidents_service_proto_goTypes = []interface{}{
	(*CreateIncidentRequest)(nil),                 // 0: google.cloud.irm.v1alpha2.CreateIncidentRequest
	(*GetIncidentRequest)(nil),                    // 1: google.cloud.irm.v1alpha2.GetIncidentRequest
	(*UpdateIncidentRequest)(nil),                 // 2: google.cloud.irm.v1alpha2.UpdateIncidentRequest
	(*SearchSimilarIncidentsRequest)(nil),         // 3: google.cloud.irm.v1alpha2.SearchSimilarIncidentsRequest
	(*SearchSimilarIncidentsResponse)(nil),        // 4: google.cloud.irm.v1alpha2.SearchSimilarIncidentsResponse
	(*CreateAnnotationRequest)(nil),               // 5: google.cloud.irm.v1alpha2.CreateAnnotationRequest
	(*ListAnnotationsRequest)(nil),                // 6: google.cloud.irm.v1alpha2.ListAnnotationsRequest
	(*ListAnnotationsResponse)(nil),               // 7: google.cloud.irm.v1alpha2.ListAnnotationsResponse
	(*CreateTagRequest)(nil),                      // 8: google.cloud.irm.v1alpha2.CreateTagRequest
	(*DeleteTagRequest)(nil),                      // 9: google.cloud.irm.v1alpha2.DeleteTagRequest
	(*ListTagsRequest)(nil),                       // 10: google.cloud.irm.v1alpha2.ListTagsRequest
	(*ListTagsResponse)(nil),                      // 11: google.cloud.irm.v1alpha2.ListTagsResponse
	(*CreateSignalRequest)(nil),                   // 12: google.cloud.irm.v1alpha2.CreateSignalRequest
	(*SearchSignalsRequest)(nil),                  // 13: google.cloud.irm.v1alpha2.SearchSignalsRequest
	(*SearchSignalsResponse)(nil),                 // 14: google.cloud.irm.v1alpha2.SearchSignalsResponse
	(*GetSignalRequest)(nil),                      // 15: google.cloud.irm.v1alpha2.GetSignalRequest
	(*LookupSignalRequest)(nil),                   // 16: google.cloud.irm.v1alpha2.LookupSignalRequest
	(*UpdateSignalRequest)(nil),                   // 17: google.cloud.irm.v1alpha2.UpdateSignalRequest
	(*SearchIncidentsRequest)(nil),                // 18: google.cloud.irm.v1alpha2.SearchIncidentsRequest
	(*SearchIncidentsResponse)(nil),               // 19: google.cloud.irm.v1alpha2.SearchIncidentsResponse
	(*EscalateIncidentRequest)(nil),               // 20: google.cloud.irm.v1alpha2.EscalateIncidentRequest
	(*EscalateIncidentResponse)(nil),              // 21: google.cloud.irm.v1alpha2.EscalateIncidentResponse
	(*CreateArtifactRequest)(nil),                 // 22: google.cloud.irm.v1alpha2.CreateArtifactRequest
	(*ListArtifactsRequest)(nil),                  // 23: google.cloud.irm.v1alpha2.ListArtifactsRequest
	(*ListArtifactsResponse)(nil),                 // 24: google.cloud.irm.v1alpha2.ListArtifactsResponse
	(*UpdateArtifactRequest)(nil),                 // 25: google.cloud.irm.v1alpha2.UpdateArtifactRequest
	(*DeleteArtifactRequest)(nil),                 // 26: google.cloud.irm.v1alpha2.DeleteArtifactRequest
	(*SendShiftHandoffRequest)(nil),               // 27: google.cloud.irm.v1alpha2.SendShiftHandoffRequest
	(*SendShiftHandoffResponse)(nil),              // 28: google.cloud.irm.v1alpha2.SendShiftHandoffResponse
	(*CreateSubscriptionRequest)(nil),             // 29: google.cloud.irm.v1alpha2.CreateSubscriptionRequest
	(*UpdateSubscriptionRequest)(nil),             // 30: google.cloud.irm.v1alpha2.UpdateSubscriptionRequest
	(*ListSubscriptionsRequest)(nil),              // 31: google.cloud.irm.v1alpha2.ListSubscriptionsRequest
	(*ListSubscriptionsResponse)(nil),             // 32: google.cloud.irm.v1alpha2.ListSubscriptionsResponse
	(*DeleteSubscriptionRequest)(nil),             // 33: google.cloud.irm.v1alpha2.DeleteSubscriptionRequest
	(*CreateIncidentRoleAssignmentRequest)(nil),   // 34: google.cloud.irm.v1alpha2.CreateIncidentRoleAssignmentRequest
	(*DeleteIncidentRoleAssignmentRequest)(nil),   // 35: google.cloud.irm.v1alpha2.DeleteIncidentRoleAssignmentRequest
	(*ListIncidentRoleAssignmentsRequest)(nil),    // 36: google.cloud.irm.v1alpha2.ListIncidentRoleAssignmentsRequest
	(*ListIncidentRoleAssignmentsResponse)(nil),   // 37: google.cloud.irm.v1alpha2.ListIncidentRoleAssignmentsResponse
	(*RequestIncidentRoleHandoverRequest)(nil),    // 38: google.cloud.irm.v1alpha2.RequestIncidentRoleHandoverRequest
	(*ConfirmIncidentRoleHandoverRequest)(nil),    // 39: google.cloud.irm.v1alpha2.ConfirmIncidentRoleHandoverRequest
	(*ForceIncidentRoleHandoverRequest)(nil),      // 40: google.cloud.irm.v1alpha2.ForceIncidentRoleHandoverRequest
	(*CancelIncidentRoleHandoverRequest)(nil),     // 41: google.cloud.irm.v1alpha2.CancelIncidentRoleHandoverRequest
	(*SearchSimilarIncidentsResponse_Result)(nil), // 42: google.cloud.irm.v1alpha2.SearchSimilarIncidentsResponse.Result
	(*SendShiftHandoffRequest_Incident)(nil),      // 43: google.cloud.irm.v1alpha2.SendShiftHandoffRequest.Incident
	(*Incident)(nil),                              // 44: google.cloud.irm.v1alpha2.Incident
	(*field_mask.FieldMask)(nil),                  // 45: google.protobuf.FieldMask
	(*Annotation)(nil),                            // 46: google.cloud.irm.v1alpha2.Annotation
	(*Tag)(nil),                                   // 47: google.cloud.irm.v1alpha2.Tag
	(*Signal)(nil),                                // 48: google.cloud.irm.v1alpha2.Signal
	(*Subscription)(nil),                          // 49: google.cloud.irm.v1alpha2.Subscription
	(*IncidentRoleAssignment)(nil),                // 50: google.cloud.irm.v1alpha2.IncidentRoleAssignment
	(*Artifact)(nil),                              // 51: google.cloud.irm.v1alpha2.Artifact
	(*IncidentRole)(nil),                          // 52: google.cloud.irm.v1alpha2.IncidentRole
	(*User)(nil),                                  // 53: google.cloud.irm.v1alpha2.User
	(*empty.Empty)(nil),                           // 54: google.protobuf.Empty
}
var file_google_cloud_irm_v1alpha2_incidents_service_proto_depIdxs = []int32{
	44, // 0: google.cloud.irm.v1alpha2.CreateIncidentRequest.incident:type_name -> google.cloud.irm.v1alpha2.Incident
	44, // 1: google.cloud.irm.v1alpha2.UpdateIncidentRequest.incident:type_name -> google.cloud.irm.v1alpha2.Incident
	45, // 2: google.cloud.irm.v1alpha2.UpdateIncidentRequest.update_mask:type_name -> google.protobuf.FieldMask
	42, // 3: google.cloud.irm.v1alpha2.SearchSimilarIncidentsResponse.results:type_name -> google.cloud.irm.v1alpha2.SearchSimilarIncidentsResponse.Result
	46, // 4: google.cloud.irm.v1alpha2.CreateAnnotationRequest.annotation:type_name -> google.cloud.irm.v1alpha2.Annotation
	46, // 5: google.cloud.irm.v1alpha2.ListAnnotationsResponse.annotations:type_name -> google.cloud.irm.v1alpha2.Annotation
	47, // 6: google.cloud.irm.v1alpha2.CreateTagRequest.tag:type_name -> google.cloud.irm.v1alpha2.Tag
	47, // 7: google.cloud.irm.v1alpha2.ListTagsResponse.tags:type_name -> google.cloud.irm.v1alpha2.Tag
	48, // 8: google.cloud.irm.v1alpha2.CreateSignalRequest.signal:type_name -> google.cloud.irm.v1alpha2.Signal
	48, // 9: google.cloud.irm.v1alpha2.SearchSignalsResponse.signals:type_name -> google.cloud.irm.v1alpha2.Signal
	48, // 10: google.cloud.irm.v1alpha2.UpdateSignalRequest.signal:type_name -> google.cloud.irm.v1alpha2.Signal
	45, // 11: google.cloud.irm.v1alpha2.UpdateSignalRequest.update_mask:type_name -> google.protobuf.FieldMask
	44, // 12: google.cloud.irm.v1alpha2.SearchIncidentsResponse.incidents:type_name -> google.cloud.irm.v1alpha2.Incident
	44, // 13: google.cloud.irm.v1alpha2.EscalateIncidentRequest.incident:type_name -> google.cloud.irm.v1alpha2.Incident
	45, // 14: google.cloud.irm.v1alpha2.EscalateIncidentRequest.update_mask:type_name -> google.protobuf.FieldMask
	49, // 15: google.cloud.irm.v1alpha2.EscalateIncidentRequest.subscriptions:type_name -> google.cloud.irm.v1alpha2.Subscription
	47, // 16: google.cloud.irm.v1alpha2.EscalateIncidentRequest.tags:type_name -> google.cloud.irm.v1alpha2.Tag
	50, // 17: google.cloud.irm.v1alpha2.EscalateIncidentRequest.roles:type_name -> google.cloud.irm.v1alpha2.IncidentRoleAssignment
	51, // 18: google.cloud.irm.v1alpha2.EscalateIncidentRequest.artifacts:type_name -> google.cloud.irm.v1alpha2.Artifact
	44, // 19: google.cloud.irm.v1alpha2.EscalateIncidentResponse.incident:type_name -> google.cloud.irm.v1alpha2.Incident
	49, // 20: google.cloud.irm.v1alpha2.EscalateIncidentResponse.subscriptions:type_name -> google.cloud.irm.v1alpha2.Subscription
	47, // 21: google.cloud.irm.v1alpha2.EscalateIncidentResponse.tags:type_name -> google.cloud.irm.v1alpha2.Tag
	52, // 22: google.cloud.irm.v1alpha2.EscalateIncidentResponse.roles:type_name -> google.cloud.irm.v1alpha2.IncidentRole
	51, // 23: google.cloud.irm.v1alpha2.EscalateIncidentResponse.artifacts:type_name -> google.cloud.irm.v1alpha2.Artifact
	51, // 24: google.cloud.irm.v1alpha2.CreateArtifactRequest.artifact:type_name -> google.cloud.irm.v1alpha2.Artifact
	51, // 25: google.cloud.irm.v1alpha2.ListArtifactsResponse.artifacts:type_name -> google.cloud.irm.v1alpha2.Artifact
	51, // 26: google.cloud.irm.v1alpha2.UpdateArtifactRequest.artifact:type_name -> google.cloud.irm.v1alpha2.Artifact
	45, // 27: google.cloud.irm.v1alpha2.UpdateArtifactRequest.update_mask:type_name -> google.protobuf.FieldMask
	43, // 28: google.cloud.irm.v1alpha2.SendShiftHandoffRequest.incidents:type_name -> google.cloud.irm.v1alpha2.SendShiftHandoffRequest.Incident
	49, // 29: google.cloud.irm.v1alpha2.CreateSubscriptionRequest.subscription:type_name -> google.cloud.irm.v1alpha2.Subscription
	49, // 30: google.cloud.irm.v1alpha2.UpdateSubscriptionRequest.subscription:type_name -> google.cloud.irm.v1alpha2.Subscription
	45, // 31: google.cloud.irm.v1alpha2.UpdateSubscriptionRequest.update_mask:type_name -> google.protobuf.FieldMask
	49, // 32: google.cloud.irm.v1alpha2.ListSubscriptionsResponse.subscriptions:type_name -> google.cloud.irm.v1alpha2.Subscription
	50, // 33: google.cloud.irm.v1alpha2.CreateIncidentRoleAssignmentRequest.incident_role_assignment:type_name -> google.cloud.irm.v1alpha2.IncidentRoleAssignment
	50, // 34: google.cloud.irm.v1alpha2.ListIncidentRoleAssignmentsResponse.incident_role_assignments:type_name -> google.cloud.irm.v1alpha2.IncidentRoleAssignment
	53, // 35: google.cloud.irm.v1alpha2.RequestIncidentRoleHandoverRequest.new_assignee:type_name -> google.cloud.irm.v1alpha2.User
	53, // 36: google.cloud.irm.v1alpha2.ConfirmIncidentRoleHandoverRequest.new_assignee:type_name -> google.cloud.irm.v1alpha2.User
	53, // 37: google.cloud.irm.v1alpha2.ForceIncidentRoleHandoverRequest.new_assignee:type_name -> google.cloud.irm.v1alpha2.User
	53, // 38: google.cloud.irm.v1alpha2.CancelIncidentRoleHandoverRequest.new_assignee:type_name -> google.cloud.irm.v1alpha2.User
	44, // 39: google.cloud.irm.v1alpha2.SearchSimilarIncidentsResponse.Result.incident:type_name -> google.cloud.irm.v1alpha2.Incident
	0,  // 40: google.cloud.irm.v1alpha2.IncidentService.CreateIncident:input_type -> google.cloud.irm.v1alpha2.CreateIncidentRequest
	1,  // 41: google.cloud.irm.v1alpha2.IncidentService.GetIncident:input_type -> google.cloud.irm.v1alpha2.GetIncidentRequest
	18, // 42: google.cloud.irm.v1alpha2.IncidentService.SearchIncidents:input_type -> google.cloud.irm.v1alpha2.SearchIncidentsRequest
	2,  // 43: google.cloud.irm.v1alpha2.IncidentService.UpdateIncident:input_type -> google.cloud.irm.v1alpha2.UpdateIncidentRequest
	3,  // 44: google.cloud.irm.v1alpha2.IncidentService.SearchSimilarIncidents:input_type -> google.cloud.irm.v1alpha2.SearchSimilarIncidentsRequest
	5,  // 45: google.cloud.irm.v1alpha2.IncidentService.CreateAnnotation:input_type -> google.cloud.irm.v1alpha2.CreateAnnotationRequest
	6,  // 46: google.cloud.irm.v1alpha2.IncidentService.ListAnnotations:input_type -> google.cloud.irm.v1alpha2.ListAnnotationsRequest
	8,  // 47: google.cloud.irm.v1alpha2.IncidentService.CreateTag:input_type -> google.cloud.irm.v1alpha2.CreateTagRequest
	9,  // 48: google.cloud.irm.v1alpha2.IncidentService.DeleteTag:input_type -> google.cloud.irm.v1alpha2.DeleteTagRequest
	10, // 49: google.cloud.irm.v1alpha2.IncidentService.ListTags:input_type -> google.cloud.irm.v1alpha2.ListTagsRequest
	12, // 50: google.cloud.irm.v1alpha2.IncidentService.CreateSignal:input_type -> google.cloud.irm.v1alpha2.CreateSignalRequest
	13, // 51: google.cloud.irm.v1alpha2.IncidentService.SearchSignals:input_type -> google.cloud.irm.v1alpha2.SearchSignalsRequest
	16, // 52: google.cloud.irm.v1alpha2.IncidentService.LookupSignal:input_type -> google.cloud.irm.v1alpha2.LookupSignalRequest
	15, // 53: google.cloud.irm.v1alpha2.IncidentService.GetSignal:input_type -> google.cloud.irm.v1alpha2.GetSignalRequest
	17, // 54: google.cloud.irm.v1alpha2.IncidentService.UpdateSignal:input_type -> google.cloud.irm.v1alpha2.UpdateSignalRequest
	20, // 55: google.cloud.irm.v1alpha2.IncidentService.EscalateIncident:input_type -> google.cloud.irm.v1alpha2.EscalateIncidentRequest
	22, // 56: google.cloud.irm.v1alpha2.IncidentService.CreateArtifact:input_type -> google.cloud.irm.v1alpha2.CreateArtifactRequest
	23, // 57: google.cloud.irm.v1alpha2.IncidentService.ListArtifacts:input_type -> google.cloud.irm.v1alpha2.ListArtifactsRequest
	25, // 58: google.cloud.irm.v1alpha2.IncidentService.UpdateArtifact:input_type -> google.cloud.irm.v1alpha2.UpdateArtifactRequest
	26, // 59: google.cloud.irm.v1alpha2.IncidentService.DeleteArtifact:input_type -> google.cloud.irm.v1alpha2.DeleteArtifactRequest
	27, // 60: google.cloud.irm.v1alpha2.IncidentService.SendShiftHandoff:input_type -> google.cloud.irm.v1alpha2.SendShiftHandoffRequest
	29, // 61: google.cloud.irm.v1alpha2.IncidentService.CreateSubscription:input_type -> google.cloud.irm.v1alpha2.CreateSubscriptionRequest
	30, // 62: google.cloud.irm.v1alpha2.IncidentService.UpdateSubscription:input_type -> google.cloud.irm.v1alpha2.UpdateSubscriptionRequest
	31, // 63: google.cloud.irm.v1alpha2.IncidentService.ListSubscriptions:input_type -> google.cloud.irm.v1alpha2.ListSubscriptionsRequest
	33, // 64: google.cloud.irm.v1alpha2.IncidentService.DeleteSubscription:input_type -> google.cloud.irm.v1alpha2.DeleteSubscriptionRequest
	34, // 65: google.cloud.irm.v1alpha2.IncidentService.CreateIncidentRoleAssignment:input_type -> google.cloud.irm.v1alpha2.CreateIncidentRoleAssignmentRequest
	35, // 66: google.cloud.irm.v1alpha2.IncidentService.DeleteIncidentRoleAssignment:input_type -> google.cloud.irm.v1alpha2.DeleteIncidentRoleAssignmentRequest
	36, // 67: google.cloud.irm.v1alpha2.IncidentService.ListIncidentRoleAssignments:input_type -> google.cloud.irm.v1alpha2.ListIncidentRoleAssignmentsRequest
	38, // 68: google.cloud.irm.v1alpha2.IncidentService.RequestIncidentRoleHandover:input_type -> google.cloud.irm.v1alpha2.RequestIncidentRoleHandoverRequest
	39, // 69: google.cloud.irm.v1alpha2.IncidentService.ConfirmIncidentRoleHandover:input_type -> google.cloud.irm.v1alpha2.ConfirmIncidentRoleHandoverRequest
	40, // 70: google.cloud.irm.v1alpha2.IncidentService.ForceIncidentRoleHandover:input_type -> google.cloud.irm.v1alpha2.ForceIncidentRoleHandoverRequest
	41, // 71: google.cloud.irm.v1alpha2.IncidentService.CancelIncidentRoleHandover:input_type -> google.cloud.irm.v1alpha2.CancelIncidentRoleHandoverRequest
	44, // 72: google.cloud.irm.v1alpha2.IncidentService.CreateIncident:output_type -> google.cloud.irm.v1alpha2.Incident
	44, // 73: google.cloud.irm.v1alpha2.IncidentService.GetIncident:output_type -> google.cloud.irm.v1alpha2.Incident
	19, // 74: google.cloud.irm.v1alpha2.IncidentService.SearchIncidents:output_type -> google.cloud.irm.v1alpha2.SearchIncidentsResponse
	44, // 75: google.cloud.irm.v1alpha2.IncidentService.UpdateIncident:output_type -> google.cloud.irm.v1alpha2.Incident
	4,  // 76: google.cloud.irm.v1alpha2.IncidentService.SearchSimilarIncidents:output_type -> google.cloud.irm.v1alpha2.SearchSimilarIncidentsResponse
	46, // 77: google.cloud.irm.v1alpha2.IncidentService.CreateAnnotation:output_type -> google.cloud.irm.v1alpha2.Annotation
	7,  // 78: google.cloud.irm.v1alpha2.IncidentService.ListAnnotations:output_type -> google.cloud.irm.v1alpha2.ListAnnotationsResponse
	47, // 79: google.cloud.irm.v1alpha2.IncidentService.CreateTag:output_type -> google.cloud.irm.v1alpha2.Tag
	54, // 80: google.cloud.irm.v1alpha2.IncidentService.DeleteTag:output_type -> google.protobuf.Empty
	11, // 81: google.cloud.irm.v1alpha2.IncidentService.ListTags:output_type -> google.cloud.irm.v1alpha2.ListTagsResponse
	48, // 82: google.cloud.irm.v1alpha2.IncidentService.CreateSignal:output_type -> google.cloud.irm.v1alpha2.Signal
	14, // 83: google.cloud.irm.v1alpha2.IncidentService.SearchSignals:output_type -> google.cloud.irm.v1alpha2.SearchSignalsResponse
	48, // 84: google.cloud.irm.v1alpha2.IncidentService.LookupSignal:output_type -> google.cloud.irm.v1alpha2.Signal
	48, // 85: google.cloud.irm.v1alpha2.IncidentService.GetSignal:output_type -> google.cloud.irm.v1alpha2.Signal
	48, // 86: google.cloud.irm.v1alpha2.IncidentService.UpdateSignal:output_type -> google.cloud.irm.v1alpha2.Signal
	21, // 87: google.cloud.irm.v1alpha2.IncidentService.EscalateIncident:output_type -> google.cloud.irm.v1alpha2.EscalateIncidentResponse
	51, // 88: google.cloud.irm.v1alpha2.IncidentService.CreateArtifact:output_type -> google.cloud.irm.v1alpha2.Artifact
	24, // 89: google.cloud.irm.v1alpha2.IncidentService.ListArtifacts:output_type -> google.cloud.irm.v1alpha2.ListArtifactsResponse
	51, // 90: google.cloud.irm.v1alpha2.IncidentService.UpdateArtifact:output_type -> google.cloud.irm.v1alpha2.Artifact
	54, // 91: google.cloud.irm.v1alpha2.IncidentService.DeleteArtifact:output_type -> google.protobuf.Empty
	28, // 92: google.cloud.irm.v1alpha2.IncidentService.SendShiftHandoff:output_type -> google.cloud.irm.v1alpha2.SendShiftHandoffResponse
	49, // 93: google.cloud.irm.v1alpha2.IncidentService.CreateSubscription:output_type -> google.cloud.irm.v1alpha2.Subscription
	49, // 94: google.cloud.irm.v1alpha2.IncidentService.UpdateSubscription:output_type -> google.cloud.irm.v1alpha2.Subscription
	32, // 95: google.cloud.irm.v1alpha2.IncidentService.ListSubscriptions:output_type -> google.cloud.irm.v1alpha2.ListSubscriptionsResponse
	54, // 96: google.cloud.irm.v1alpha2.IncidentService.DeleteSubscription:output_type -> google.protobuf.Empty
	50, // 97: google.cloud.irm.v1alpha2.IncidentService.CreateIncidentRoleAssignment:output_type -> google.cloud.irm.v1alpha2.IncidentRoleAssignment
	54, // 98: google.cloud.irm.v1alpha2.IncidentService.DeleteIncidentRoleAssignment:output_type -> google.protobuf.Empty
	37, // 99: google.cloud.irm.v1alpha2.IncidentService.ListIncidentRoleAssignments:output_type -> google.cloud.irm.v1alpha2.ListIncidentRoleAssignmentsResponse
	50, // 100: google.cloud.irm.v1alpha2.IncidentService.RequestIncidentRoleHandover:output_type -> google.cloud.irm.v1alpha2.IncidentRoleAssignment
	50, // 101: google.cloud.irm.v1alpha2.IncidentService.ConfirmIncidentRoleHandover:output_type -> google.cloud.irm.v1alpha2.IncidentRoleAssignment
	50, // 102: google.cloud.irm.v1alpha2.IncidentService.ForceIncidentRoleHandover:output_type -> google.cloud.irm.v1alpha2.IncidentRoleAssignment
	50, // 103: google.cloud.irm.v1alpha2.IncidentService.CancelIncidentRoleHandover:output_type -> google.cloud.irm.v1alpha2.IncidentRoleAssignment
	72, // [72:104] is the sub-list for method output_type
	40, // [40:72] is the sub-list for method input_type
	40, // [40:40] is the sub-list for extension type_name
	40, // [40:40] is the sub-list for extension extendee
	0,  // [0:40] is the sub-list for field type_name
}

func init() { file_google_cloud_irm_v1alpha2_incidents_service_proto_init() }
func file_google_cloud_irm_v1alpha2_incidents_service_proto_init() {
	if File_google_cloud_irm_v1alpha2_incidents_service_proto != nil {
		return
	}
	file_google_cloud_irm_v1alpha2_incidents_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIncidentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIncidentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIncidentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchSimilarIncidentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchSimilarIncidentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTagsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTagsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSignalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchSignalsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchSignalsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSignalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LookupSignalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSignalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchIncidentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchIncidentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EscalateIncidentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EscalateIncidentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListArtifactsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListArtifactsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendShiftHandoffRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendShiftHandoffResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubscriptionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubscriptionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSubscriptionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIncidentRoleAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIncidentRoleAssignmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIncidentRoleAssignmentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIncidentRoleAssignmentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestIncidentRoleHandoverRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfirmIncidentRoleHandoverRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForceIncidentRoleHandoverRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelIncidentRoleHandoverRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchSimilarIncidentsResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SendShiftHandoffRequest_Incident); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*LookupSignalRequest_CsccFinding)(nil),
		(*LookupSignalRequest_StackdriverNotificationId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   44,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_irm_v1alpha2_incidents_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_irm_v1alpha2_incidents_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_irm_v1alpha2_incidents_service_proto_msgTypes,
	}.Build()
	File_google_cloud_irm_v1alpha2_incidents_service_proto = out.File
	file_google_cloud_irm_v1alpha2_incidents_service_proto_rawDesc = nil
	file_google_cloud_irm_v1alpha2_incidents_service_proto_goTypes = nil
	file_google_cloud_irm_v1alpha2_incidents_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IncidentServiceClient is the client API for IncidentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IncidentServiceClient interface {
	// Creates a new incident.
	CreateIncident(ctx context.Context, in *CreateIncidentRequest, opts ...grpc.CallOption) (*Incident, error)
	// Returns an incident by name.
	GetIncident(ctx context.Context, in *GetIncidentRequest, opts ...grpc.CallOption) (*Incident, error)
	// Returns a list of incidents.
	// Incidents are ordered by start time, with the most recent incidents first.
	SearchIncidents(ctx context.Context, in *SearchIncidentsRequest, opts ...grpc.CallOption) (*SearchIncidentsResponse, error)
	// Updates an existing incident.
	UpdateIncident(ctx context.Context, in *UpdateIncidentRequest, opts ...grpc.CallOption) (*Incident, error)
	// Returns a list of incidents that are "similar" to the specified incident
	// or signal. This functionality is provided on a best-effort basis and the
	// definition of "similar" is subject to change.
	SearchSimilarIncidents(ctx context.Context, in *SearchSimilarIncidentsRequest, opts ...grpc.CallOption) (*SearchSimilarIncidentsResponse, error)
	// Creates an annotation on an existing incident. Only 'text/plain' and
	// 'text/markdown' annotations can be created via this method.
	CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Lists annotations that are part of an incident. No assumptions should be
	// made on the content-type of the annotation returned.
	ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error)
	// Creates a tag on an existing incident.
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deletes an existing tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists tags that are part of an incident.
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Creates a new signal.
	CreateSignal(ctx context.Context, in *CreateSignalRequest, opts ...grpc.CallOption) (*Signal, error)
	// Lists signals that are part of an incident.
	// Signals are returned in reverse chronological order.
	// Note that search should not be relied on for critical functionality.  It
	// has lower availability guarantees and might fail to return valid results.
	// Returned results might include stale or extraneous entries.
	SearchSignals(ctx context.Context, in *SearchSignalsRequest, opts ...grpc.CallOption) (*SearchSignalsResponse, error)
	// Finds a signal by other unique IDs.
	LookupSignal(ctx context.Context, in *LookupSignalRequest, opts ...grpc.CallOption) (*Signal, error)
	// Returns a signal by name.
	GetSignal(ctx context.Context, in *GetSignalRequest, opts ...grpc.CallOption) (*Signal, error)
	// Updates an existing signal (for example, to assign/unassign it to an
	// incident).
	UpdateSignal(ctx context.Context, in *UpdateSignalRequest, opts ...grpc.CallOption) (*Signal, error)
	// Escalates an incident.
	EscalateIncident(ctx context.Context, in *EscalateIncidentRequest, opts ...grpc.CallOption) (*EscalateIncidentResponse, error)
	// Creates a new artifact.
	CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Returns a list of artifacts for an incident.
	ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error)
	// Updates an existing artifact.
	UpdateArtifact(ctx context.Context, in *UpdateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Deletes an existing artifact.
	DeleteArtifact(ctx context.Context, in *DeleteArtifactRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Sends a summary of the shift for oncall handoff.
	SendShiftHandoff(ctx context.Context, in *SendShiftHandoffRequest, opts ...grpc.CallOption) (*SendShiftHandoffResponse, error)
	// Creates a new subscription.
	// This will fail if:
	//    a. there are too many (50) subscriptions in the incident already
	//    b. a subscription using the given channel already exists
	CreateSubscription(ctx context.Context, in *CreateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Updates a subscription.
	UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Returns a list of subscriptions for an incident.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a role assignment on an existing incident. Normally, the user field
	// will be set when assigning a role to oneself, and the next field will be
	// set when proposing another user as the assignee. Setting the next field
	// directly to a user other than oneself is equivalent to proposing and
	// force-assigning the role to the user.
	CreateIncidentRoleAssignment(ctx context.Context, in *CreateIncidentRoleAssignmentRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error)
	// Deletes an existing role assignment.
	DeleteIncidentRoleAssignment(ctx context.Context, in *DeleteIncidentRoleAssignmentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists role assignments that are part of an incident.
	ListIncidentRoleAssignments(ctx context.Context, in *ListIncidentRoleAssignmentsRequest, opts ...grpc.CallOption) (*ListIncidentRoleAssignmentsResponse, error)
	// Starts a role handover. The proposed assignee will receive an email
	// notifying them of the assignment. This will fail if a role handover is
	// already pending.
	// Handover to an oncall ladder is not permitted. Use
	// CreateIncidentRoleAssignment instead.
	RequestIncidentRoleHandover(ctx context.Context, in *RequestIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error)
	// Confirms a role handover. This will fail if the 'proposed_assignee' field
	// of the IncidentRoleAssignment is not equal to the 'new_assignee' field of
	// the request. If the caller is not the new_assignee,
	// ForceIncidentRoleHandover should be used instead.
	ConfirmIncidentRoleHandover(ctx context.Context, in *ConfirmIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error)
	// Forces a role handover. This will fail if the 'proposed_assignee' field of
	// the IncidentRoleAssignment is not equal to the 'new_assignee' field of the
	// request. If the caller is the new_assignee, ConfirmIncidentRoleHandover
	// should be used instead.
	ForceIncidentRoleHandover(ctx context.Context, in *ForceIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error)
	// Cancels a role handover. This will fail if the 'proposed_assignee' field of
	// the IncidentRoleAssignment is not equal to the 'new_assignee' field of the
	// request.
	CancelIncidentRoleHandover(ctx context.Context, in *CancelIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error)
}

type incidentServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewIncidentServiceClient(cc grpc.ClientConnInterface) IncidentServiceClient {
	return &incidentServiceClient{cc}
}

func (c *incidentServiceClient) CreateIncident(ctx context.Context, in *CreateIncidentRequest, opts ...grpc.CallOption) (*Incident, error) {
	out := new(Incident)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateIncident", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) GetIncident(ctx context.Context, in *GetIncidentRequest, opts ...grpc.CallOption) (*Incident, error) {
	out := new(Incident)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/GetIncident", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) SearchIncidents(ctx context.Context, in *SearchIncidentsRequest, opts ...grpc.CallOption) (*SearchIncidentsResponse, error) {
	out := new(SearchIncidentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/SearchIncidents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) UpdateIncident(ctx context.Context, in *UpdateIncidentRequest, opts ...grpc.CallOption) (*Incident, error) {
	out := new(Incident)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/UpdateIncident", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) SearchSimilarIncidents(ctx context.Context, in *SearchSimilarIncidentsRequest, opts ...grpc.CallOption) (*SearchSimilarIncidentsResponse, error) {
	out := new(SearchSimilarIncidentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/SearchSimilarIncidents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error) {
	out := new(ListAnnotationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListAnnotations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/DeleteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListTags", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateSignal(ctx context.Context, in *CreateSignalRequest, opts ...grpc.CallOption) (*Signal, error) {
	out := new(Signal)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateSignal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) SearchSignals(ctx context.Context, in *SearchSignalsRequest, opts ...grpc.CallOption) (*SearchSignalsResponse, error) {
	out := new(SearchSignalsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/SearchSignals", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) LookupSignal(ctx context.Context, in *LookupSignalRequest, opts ...grpc.CallOption) (*Signal, error) {
	out := new(Signal)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/LookupSignal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) GetSignal(ctx context.Context, in *GetSignalRequest, opts ...grpc.CallOption) (*Signal, error) {
	out := new(Signal)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/GetSignal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) UpdateSignal(ctx context.Context, in *UpdateSignalRequest, opts ...grpc.CallOption) (*Signal, error) {
	out := new(Signal)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/UpdateSignal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) EscalateIncident(ctx context.Context, in *EscalateIncidentRequest, opts ...grpc.CallOption) (*EscalateIncidentResponse, error) {
	out := new(EscalateIncidentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/EscalateIncident", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error) {
	out := new(ListArtifactsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListArtifacts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) UpdateArtifact(ctx context.Context, in *UpdateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/UpdateArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) DeleteArtifact(ctx context.Context, in *DeleteArtifactRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/DeleteArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) SendShiftHandoff(ctx context.Context, in *SendShiftHandoffRequest, opts ...grpc.CallOption) (*SendShiftHandoffResponse, error) {
	out := new(SendShiftHandoffResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/SendShiftHandoff", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateSubscription(ctx context.Context, in *CreateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) UpdateSubscription(ctx context.Context, in *UpdateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/UpdateSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListSubscriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/DeleteSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateIncidentRoleAssignment(ctx context.Context, in *CreateIncidentRoleAssignmentRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error) {
	out := new(IncidentRoleAssignment)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateIncidentRoleAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) DeleteIncidentRoleAssignment(ctx context.Context, in *DeleteIncidentRoleAssignmentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/DeleteIncidentRoleAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListIncidentRoleAssignments(ctx context.Context, in *ListIncidentRoleAssignmentsRequest, opts ...grpc.CallOption) (*ListIncidentRoleAssignmentsResponse, error) {
	out := new(ListIncidentRoleAssignmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListIncidentRoleAssignments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) RequestIncidentRoleHandover(ctx context.Context, in *RequestIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error) {
	out := new(IncidentRoleAssignment)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/RequestIncidentRoleHandover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ConfirmIncidentRoleHandover(ctx context.Context, in *ConfirmIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error) {
	out := new(IncidentRoleAssignment)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ConfirmIncidentRoleHandover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ForceIncidentRoleHandover(ctx context.Context, in *ForceIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error) {
	out := new(IncidentRoleAssignment)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ForceIncidentRoleHandover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CancelIncidentRoleHandover(ctx context.Context, in *CancelIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error) {
	out := new(IncidentRoleAssignment)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CancelIncidentRoleHandover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IncidentServiceServer is the server API for IncidentService service.
type IncidentServiceServer interface {
	// Creates a new incident.
	CreateIncident(context.Context, *CreateIncidentRequest) (*Incident, error)
	// Returns an incident by name.
	GetIncident(context.Context, *GetIncidentRequest) (*Incident, error)
	// Returns a list of incidents.
	// Incidents are ordered by start time, with the most recent incidents first.
	SearchIncidents(context.Context, *SearchIncidentsRequest) (*SearchIncidentsResponse, error)
	// Updates an existing incident.
	UpdateIncident(context.Context, *UpdateIncidentRequest) (*Incident, error)
	// Returns a list of incidents that are "similar" to the specified incident
	// or signal. This functionality is provided on a best-effort basis and the
	// definition of "similar" is subject to change.
	SearchSimilarIncidents(context.Context, *SearchSimilarIncidentsRequest) (*SearchSimilarIncidentsResponse, error)
	// Creates an annotation on an existing incident. Only 'text/plain' and
	// 'text/markdown' annotations can be created via this method.
	CreateAnnotation(context.Context, *CreateAnnotationRequest) (*Annotation, error)
	// Lists annotations that are part of an incident. No assumptions should be
	// made on the content-type of the annotation returned.
	ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error)
	// Creates a tag on an existing incident.
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Deletes an existing tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*empty.Empty, error)
	// Lists tags that are part of an incident.
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Creates a new signal.
	CreateSignal(context.Context, *CreateSignalRequest) (*Signal, error)
	// Lists signals that are part of an incident.
	// Signals are returned in reverse chronological order.
	// Note that search should not be relied on for critical functionality.  It
	// has lower availability guarantees and might fail to return valid results.
	// Returned results might include stale or extraneous entries.
	SearchSignals(context.Context, *SearchSignalsRequest) (*SearchSignalsResponse, error)
	// Finds a signal by other unique IDs.
	LookupSignal(context.Context, *LookupSignalRequest) (*Signal, error)
	// Returns a signal by name.
	GetSignal(context.Context, *GetSignalRequest) (*Signal, error)
	// Updates an existing signal (for example, to assign/unassign it to an
	// incident).
	UpdateSignal(context.Context, *UpdateSignalRequest) (*Signal, error)
	// Escalates an incident.
	EscalateIncident(context.Context, *EscalateIncidentRequest) (*EscalateIncidentResponse, error)
	// Creates a new artifact.
	CreateArtifact(context.Context, *CreateArtifactRequest) (*Artifact, error)
	// Returns a list of artifacts for an incident.
	ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error)
	// Updates an existing artifact.
	UpdateArtifact(context.Context, *UpdateArtifactRequest) (*Artifact, error)
	// Deletes an existing artifact.
	DeleteArtifact(context.Context, *DeleteArtifactRequest) (*empty.Empty, error)
	// Sends a summary of the shift for oncall handoff.
	SendShiftHandoff(context.Context, *SendShiftHandoffRequest) (*SendShiftHandoffResponse, error)
	// Creates a new subscription.
	// This will fail if:
	//    a. there are too many (50) subscriptions in the incident already
	//    b. a subscription using the given channel already exists
	CreateSubscription(context.Context, *CreateSubscriptionRequest) (*Subscription, error)
	// Updates a subscription.
	UpdateSubscription(context.Context, *UpdateSubscriptionRequest) (*Subscription, error)
	// Returns a list of subscriptions for an incident.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*empty.Empty, error)
	// Creates a role assignment on an existing incident. Normally, the user field
	// will be set when assigning a role to oneself, and the next field will be
	// set when proposing another user as the assignee. Setting the next field
	// directly to a user other than oneself is equivalent to proposing and
	// force-assigning the role to the user.
	CreateIncidentRoleAssignment(context.Context, *CreateIncidentRoleAssignmentRequest) (*IncidentRoleAssignment, error)
	// Deletes an existing role assignment.
	DeleteIncidentRoleAssignment(context.Context, *DeleteIncidentRoleAssignmentRequest) (*empty.Empty, error)
	// Lists role assignments that are part of an incident.
	ListIncidentRoleAssignments(context.Context, *ListIncidentRoleAssignmentsRequest) (*ListIncidentRoleAssignmentsResponse, error)
	// Starts a role handover. The proposed assignee will receive an email
	// notifying them of the assignment. This will fail if a role handover is
	// already pending.
	// Handover to an oncall ladder is not permitted. Use
	// CreateIncidentRoleAssignment instead.
	RequestIncidentRoleHandover(context.Context, *RequestIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error)
	// Confirms a role handover. This will fail if the 'proposed_assignee' field
	// of the IncidentRoleAssignment is not equal to the 'new_assignee' field of
	// the request. If the caller is not the new_assignee,
	// ForceIncidentRoleHandover should be used instead.
	ConfirmIncidentRoleHandover(context.Context, *ConfirmIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error)
	// Forces a role handover. This will fail if the 'proposed_assignee' field of
	// the IncidentRoleAssignment is not equal to the 'new_assignee' field of the
	// request. If the caller is the new_assignee, ConfirmIncidentRoleHandover
	// should be used instead.
	ForceIncidentRoleHandover(context.Context, *ForceIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error)
	// Cancels a role handover. This will fail if the 'proposed_assignee' field of
	// the IncidentRoleAssignment is not equal to the 'new_assignee' field of the
	// request.
	CancelIncidentRoleHandover(context.Context, *CancelIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error)
}

// UnimplementedIncidentServiceServer can be embedded to have forward compatible implementations.
type UnimplementedIncidentServiceServer struct {
}

func (*UnimplementedIncidentServiceServer) CreateIncident(context.Context, *CreateIncidentRequest) (*Incident, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIncident not implemented")
}
func (*UnimplementedIncidentServiceServer) GetIncident(context.Context, *GetIncidentRequest) (*Incident, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIncident not implemented")
}
func (*UnimplementedIncidentServiceServer) SearchIncidents(context.Context, *SearchIncidentsRequest) (*SearchIncidentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchIncidents not implemented")
}
func (*UnimplementedIncidentServiceServer) UpdateIncident(context.Context, *UpdateIncidentRequest) (*Incident, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIncident not implemented")
}
func (*UnimplementedIncidentServiceServer) SearchSimilarIncidents(context.Context, *SearchSimilarIncidentsRequest) (*SearchSimilarIncidentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchSimilarIncidents not implemented")
}
func (*UnimplementedIncidentServiceServer) CreateAnnotation(context.Context, *CreateAnnotationRequest) (*Annotation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAnnotation not implemented")
}
func (*UnimplementedIncidentServiceServer) ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnnotations not implemented")
}
func (*UnimplementedIncidentServiceServer) CreateTag(context.Context, *CreateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTag not implemented")
}
func (*UnimplementedIncidentServiceServer) DeleteTag(context.Context, *DeleteTagRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTag not implemented")
}
func (*UnimplementedIncidentServiceServer) ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTags not implemented")
}
func (*UnimplementedIncidentServiceServer) CreateSignal(context.Context, *CreateSignalRequest) (*Signal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSignal not implemented")
}
func (*UnimplementedIncidentServiceServer) SearchSignals(context.Context, *SearchSignalsRequest) (*SearchSignalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchSignals not implemented")
}
func (*UnimplementedIncidentServiceServer) LookupSignal(context.Context, *LookupSignalRequest) (*Signal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupSignal not implemented")
}
func (*UnimplementedIncidentServiceServer) GetSignal(context.Context, *GetSignalRequest) (*Signal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSignal not implemented")
}
func (*UnimplementedIncidentServiceServer) UpdateSignal(context.Context, *UpdateSignalRequest) (*Signal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSignal not implemented")
}
func (*UnimplementedIncidentServiceServer) EscalateIncident(context.Context, *EscalateIncidentRequest) (*EscalateIncidentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EscalateIncident not implemented")
}
func (*UnimplementedIncidentServiceServer) CreateArtifact(context.Context, *CreateArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateArtifact not implemented")
}
func (*UnimplementedIncidentServiceServer) ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListArtifacts not implemented")
}
func (*UnimplementedIncidentServiceServer) UpdateArtifact(context.Context, *UpdateArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateArtifact not implemented")
}
func (*UnimplementedIncidentServiceServer) DeleteArtifact(context.Context, *DeleteArtifactRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteArtifact not implemented")
}
func (*UnimplementedIncidentServiceServer) SendShiftHandoff(context.Context, *SendShiftHandoffRequest) (*SendShiftHandoffResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendShiftHandoff not implemented")
}
func (*UnimplementedIncidentServiceServer) CreateSubscription(context.Context, *CreateSubscriptionRequest) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSubscription not implemented")
}
func (*UnimplementedIncidentServiceServer) UpdateSubscription(context.Context, *UpdateSubscriptionRequest) (*Subscription, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSubscription not implemented")
}
func (*UnimplementedIncidentServiceServer) ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubscriptions not implemented")
}
func (*UnimplementedIncidentServiceServer) DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSubscription not implemented")
}
func (*UnimplementedIncidentServiceServer) CreateIncidentRoleAssignment(context.Context, *CreateIncidentRoleAssignmentRequest) (*IncidentRoleAssignment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIncidentRoleAssignment not implemented")
}
func (*UnimplementedIncidentServiceServer) DeleteIncidentRoleAssignment(context.Context, *DeleteIncidentRoleAssignmentRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIncidentRoleAssignment not implemented")
}
func (*UnimplementedIncidentServiceServer) ListIncidentRoleAssignments(context.Context, *ListIncidentRoleAssignmentsRequest) (*ListIncidentRoleAssignmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIncidentRoleAssignments not implemented")
}
func (*UnimplementedIncidentServiceServer) RequestIncidentRoleHandover(context.Context, *RequestIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RequestIncidentRoleHandover not implemented")
}
func (*UnimplementedIncidentServiceServer) ConfirmIncidentRoleHandover(context.Context, *ConfirmIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfirmIncidentRoleHandover not implemented")
}
func (*UnimplementedIncidentServiceServer) ForceIncidentRoleHandover(context.Context, *ForceIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForceIncidentRoleHandover not implemented")
}
func (*UnimplementedIncidentServiceServer) CancelIncidentRoleHandover(context.Context, *CancelIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelIncidentRoleHandover not implemented")
}

func RegisterIncidentServiceServer(s *grpc.Server, srv IncidentServiceServer) {
	s.RegisterService(&_IncidentService_serviceDesc, srv)
}

func _IncidentService_CreateIncident_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIncidentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateIncident(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateIncident",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateIncident(ctx, req.(*CreateIncidentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_GetIncident_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIncidentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).GetIncident(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/GetIncident",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).GetIncident(ctx, req.(*GetIncidentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_SearchIncidents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchIncidentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).SearchIncidents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/SearchIncidents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).SearchIncidents(ctx, req.(*SearchIncidentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_UpdateIncident_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIncidentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).UpdateIncident(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/UpdateIncident",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).UpdateIncident(ctx, req.(*UpdateIncidentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_SearchSimilarIncidents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchSimilarIncidentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).SearchSimilarIncidents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/SearchSimilarIncidents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).SearchSimilarIncidents(ctx, req.(*SearchSimilarIncidentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateAnnotation(ctx, req.(*CreateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListAnnotations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListAnnotations(ctx, req.(*ListAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/DeleteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateSignal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateSignal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateSignal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateSignal(ctx, req.(*CreateSignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_SearchSignals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchSignalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).SearchSignals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/SearchSignals",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).SearchSignals(ctx, req.(*SearchSignalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_LookupSignal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupSignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).LookupSignal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/LookupSignal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).LookupSignal(ctx, req.(*LookupSignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_GetSignal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).GetSignal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/GetSignal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).GetSignal(ctx, req.(*GetSignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_UpdateSignal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).UpdateSignal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/UpdateSignal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).UpdateSignal(ctx, req.(*UpdateSignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_EscalateIncident_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EscalateIncidentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).EscalateIncident(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/EscalateIncident",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).EscalateIncident(ctx, req.(*EscalateIncidentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateArtifact(ctx, req.(*CreateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListArtifacts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListArtifacts(ctx, req.(*ListArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_UpdateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).UpdateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/UpdateArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).UpdateArtifact(ctx, req.(*UpdateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_DeleteArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).DeleteArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/DeleteArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).DeleteArtifact(ctx, req.(*DeleteArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_SendShiftHandoff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendShiftHandoffRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).SendShiftHandoff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/SendShiftHandoff",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).SendShiftHandoff(ctx, req.(*SendShiftHandoffRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateSubscription(ctx, req.(*CreateSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_UpdateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).UpdateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/UpdateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).UpdateSubscription(ctx, req.(*UpdateSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/DeleteSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateIncidentRoleAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIncidentRoleAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateIncidentRoleAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateIncidentRoleAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateIncidentRoleAssignment(ctx, req.(*CreateIncidentRoleAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_DeleteIncidentRoleAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIncidentRoleAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).DeleteIncidentRoleAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/DeleteIncidentRoleAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).DeleteIncidentRoleAssignment(ctx, req.(*DeleteIncidentRoleAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListIncidentRoleAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIncidentRoleAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListIncidentRoleAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListIncidentRoleAssignments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListIncidentRoleAssignments(ctx, req.(*ListIncidentRoleAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_RequestIncidentRoleHandover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequestIncidentRoleHandoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).RequestIncidentRoleHandover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/RequestIncidentRoleHandover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).RequestIncidentRoleHandover(ctx, req.(*RequestIncidentRoleHandoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ConfirmIncidentRoleHandover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfirmIncidentRoleHandoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ConfirmIncidentRoleHandover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ConfirmIncidentRoleHandover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ConfirmIncidentRoleHandover(ctx, req.(*ConfirmIncidentRoleHandoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ForceIncidentRoleHandover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForceIncidentRoleHandoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ForceIncidentRoleHandover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ForceIncidentRoleHandover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ForceIncidentRoleHandover(ctx, req.(*ForceIncidentRoleHandoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CancelIncidentRoleHandover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelIncidentRoleHandoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CancelIncidentRoleHandover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CancelIncidentRoleHandover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CancelIncidentRoleHandover(ctx, req.(*CancelIncidentRoleHandoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IncidentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.irm.v1alpha2.IncidentService",
	HandlerType: (*IncidentServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateIncident",
			Handler:    _IncidentService_CreateIncident_Handler,
		},
		{
			MethodName: "GetIncident",
			Handler:    _IncidentService_GetIncident_Handler,
		},
		{
			MethodName: "SearchIncidents",
			Handler:    _IncidentService_SearchIncidents_Handler,
		},
		{
			MethodName: "UpdateIncident",
			Handler:    _IncidentService_UpdateIncident_Handler,
		},
		{
			MethodName: "SearchSimilarIncidents",
			Handler:    _IncidentService_SearchSimilarIncidents_Handler,
		},
		{
			MethodName: "CreateAnnotation",
			Handler:    _IncidentService_CreateAnnotation_Handler,
		},
		{
			MethodName: "ListAnnotations",
			Handler:    _IncidentService_ListAnnotations_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _IncidentService_CreateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _IncidentService_DeleteTag_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _IncidentService_ListTags_Handler,
		},
		{
			MethodName: "CreateSignal",
			Handler:    _IncidentService_CreateSignal_Handler,
		},
		{
			MethodName: "SearchSignals",
			Handler:    _IncidentService_SearchSignals_Handler,
		},
		{
			MethodName: "LookupSignal",
			Handler:    _IncidentService_LookupSignal_Handler,
		},
		{
			MethodName: "GetSignal",
			Handler:    _IncidentService_GetSignal_Handler,
		},
		{
			MethodName: "UpdateSignal",
			Handler:    _IncidentService_UpdateSignal_Handler,
		},
		{
			MethodName: "EscalateIncident",
			Handler:    _IncidentService_EscalateIncident_Handler,
		},
		{
			MethodName: "CreateArtifact",
			Handler:    _IncidentService_CreateArtifact_Handler,
		},
		{
			MethodName: "ListArtifacts",
			Handler:    _IncidentService_ListArtifacts_Handler,
		},
		{
			MethodName: "UpdateArtifact",
			Handler:    _IncidentService_UpdateArtifact_Handler,
		},
		{
			MethodName: "DeleteArtifact",
			Handler:    _IncidentService_DeleteArtifact_Handler,
		},
		{
			MethodName: "SendShiftHandoff",
			Handler:    _IncidentService_SendShiftHandoff_Handler,
		},
		{
			MethodName: "CreateSubscription",
			Handler:    _IncidentService_CreateSubscription_Handler,
		},
		{
			MethodName: "UpdateSubscription",
			Handler:    _IncidentService_UpdateSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _IncidentService_ListSubscriptions_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _IncidentService_DeleteSubscription_Handler,
		},
		{
			MethodName: "CreateIncidentRoleAssignment",
			Handler:    _IncidentService_CreateIncidentRoleAssignment_Handler,
		},
		{
			MethodName: "DeleteIncidentRoleAssignment",
			Handler:    _IncidentService_DeleteIncidentRoleAssignment_Handler,
		},
		{
			MethodName: "ListIncidentRoleAssignments",
			Handler:    _IncidentService_ListIncidentRoleAssignments_Handler,
		},
		{
			MethodName: "RequestIncidentRoleHandover",
			Handler:    _IncidentService_RequestIncidentRoleHandover_Handler,
		},
		{
			MethodName: "ConfirmIncidentRoleHandover",
			Handler:    _IncidentService_ConfirmIncidentRoleHandover_Handler,
		},
		{
			MethodName: "ForceIncidentRoleHandover",
			Handler:    _IncidentService_ForceIncidentRoleHandover_Handler,
		},
		{
			MethodName: "CancelIncidentRoleHandover",
			Handler:    _IncidentService_CancelIncidentRoleHandover_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/irm/v1alpha2/incidents_service.proto",
}
