// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package xrayiface provides an interface to enable mocking the AWS X-Ray service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package xrayiface

import (
	"github.com/aws/aws-sdk-go-v2/service/xray"
)

// ClientAPI provides an interface to enable mocking the
// xray.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS X-Ray.
//    func myFunc(svc xrayiface.ClientAPI) bool {
//        // Make svc.BatchGetTraces request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := xray.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        xrayiface.ClientPI
//    }
//    func (m *mockClientClient) BatchGetTraces(input *xray.BatchGetTracesInput) (*xray.BatchGetTracesOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	BatchGetTracesRequest(*xray.BatchGetTracesInput) xray.BatchGetTracesRequest

	CreateGroupRequest(*xray.CreateGroupInput) xray.CreateGroupRequest

	CreateSamplingRuleRequest(*xray.CreateSamplingRuleInput) xray.CreateSamplingRuleRequest

	DeleteGroupRequest(*xray.DeleteGroupInput) xray.DeleteGroupRequest

	DeleteSamplingRuleRequest(*xray.DeleteSamplingRuleInput) xray.DeleteSamplingRuleRequest

	GetEncryptionConfigRequest(*xray.GetEncryptionConfigInput) xray.GetEncryptionConfigRequest

	GetGroupRequest(*xray.GetGroupInput) xray.GetGroupRequest

	GetGroupsRequest(*xray.GetGroupsInput) xray.GetGroupsRequest

	GetSamplingRulesRequest(*xray.GetSamplingRulesInput) xray.GetSamplingRulesRequest

	GetSamplingStatisticSummariesRequest(*xray.GetSamplingStatisticSummariesInput) xray.GetSamplingStatisticSummariesRequest

	GetSamplingTargetsRequest(*xray.GetSamplingTargetsInput) xray.GetSamplingTargetsRequest

	GetServiceGraphRequest(*xray.GetServiceGraphInput) xray.GetServiceGraphRequest

	GetTimeSeriesServiceStatisticsRequest(*xray.GetTimeSeriesServiceStatisticsInput) xray.GetTimeSeriesServiceStatisticsRequest

	GetTraceGraphRequest(*xray.GetTraceGraphInput) xray.GetTraceGraphRequest

	GetTraceSummariesRequest(*xray.GetTraceSummariesInput) xray.GetTraceSummariesRequest

	PutEncryptionConfigRequest(*xray.PutEncryptionConfigInput) xray.PutEncryptionConfigRequest

	PutTelemetryRecordsRequest(*xray.PutTelemetryRecordsInput) xray.PutTelemetryRecordsRequest

	PutTraceSegmentsRequest(*xray.PutTraceSegmentsInput) xray.PutTraceSegmentsRequest

	UpdateGroupRequest(*xray.UpdateGroupInput) xray.UpdateGroupRequest

	UpdateSamplingRuleRequest(*xray.UpdateSamplingRuleInput) xray.UpdateSamplingRuleRequest
}

var _ ClientAPI = (*xray.Client)(nil)
