// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListBulkDeploymentsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *string `location:"querystring" locationName:"MaxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListBulkDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBulkDeploymentsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListBulkDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of bulk deployments.
	BulkDeployments []BulkDeployment `type:"list"`

	// The token for the next set of results, or ''null'' if there are no additional
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListBulkDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListBulkDeploymentsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BulkDeployments != nil {
		v := s.BulkDeployments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "BulkDeployments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListBulkDeployments = "ListBulkDeployments"

// ListBulkDeploymentsRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Returns a list of bulk deployments.
//
//    // Example sending a request using ListBulkDeploymentsRequest.
//    req := client.ListBulkDeploymentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments
func (c *Client) ListBulkDeploymentsRequest(input *ListBulkDeploymentsInput) ListBulkDeploymentsRequest {
	op := &aws.Operation{
		Name:       opListBulkDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/bulk/deployments",
	}

	if input == nil {
		input = &ListBulkDeploymentsInput{}
	}

	req := c.newRequest(op, input, &ListBulkDeploymentsOutput{})
	return ListBulkDeploymentsRequest{Request: req, Input: input, Copy: c.ListBulkDeploymentsRequest}
}

// ListBulkDeploymentsRequest is the request type for the
// ListBulkDeployments API operation.
type ListBulkDeploymentsRequest struct {
	*aws.Request
	Input *ListBulkDeploymentsInput
	Copy  func(*ListBulkDeploymentsInput) ListBulkDeploymentsRequest
}

// Send marshals and sends the ListBulkDeployments API request.
func (r ListBulkDeploymentsRequest) Send(ctx context.Context) (*ListBulkDeploymentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBulkDeploymentsResponse{
		ListBulkDeploymentsOutput: r.Request.Data.(*ListBulkDeploymentsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListBulkDeploymentsResponse is the response type for the
// ListBulkDeployments API operation.
type ListBulkDeploymentsResponse struct {
	*ListBulkDeploymentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBulkDeployments request.
func (r *ListBulkDeploymentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
