// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateDataSetInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// Groupings of columns that work together in certain QuickSight features. Currently,
	// only geospatial hierarchy is supported.
	ColumnGroups []ColumnGroup `min:"1" type:"list"`

	// An ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// Indicates whether you want to import the data into SPICE.
	//
	// ImportMode is a required field
	ImportMode DataSetImportMode `type:"string" required:"true" enum:"true"`

	// Configures the combination and transformation of the data from the physical
	// tables.
	LogicalTableMap map[string]LogicalTable `min:"1" type:"map"`

	// The display name for the dataset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of resource permissions on the dataset.
	Permissions []ResourcePermission `min:"1" type:"list"`

	// Declares the physical tables that are available in the underlying data sources.
	//
	// PhysicalTableMap is a required field
	PhysicalTableMap map[string]PhysicalTable `min:"1" type:"map" required:"true"`

	// The row-level security configuration for the data that you want to create.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the dataset.
	Tags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDataSetInput"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ColumnGroups != nil && len(s.ColumnGroups) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ColumnGroups", 1))
	}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}
	if len(s.ImportMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ImportMode"))
	}
	if s.LogicalTableMap != nil && len(s.LogicalTableMap) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogicalTableMap", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Permissions", 1))
	}

	if s.PhysicalTableMap == nil {
		invalidParams.Add(aws.NewErrParamRequired("PhysicalTableMap"))
	}
	if s.PhysicalTableMap != nil && len(s.PhysicalTableMap) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PhysicalTableMap", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.ColumnGroups != nil {
		for i, v := range s.ColumnGroups {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnGroups", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.LogicalTableMap != nil {
		for i, v := range s.LogicalTableMap {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogicalTableMap", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.PhysicalTableMap != nil {
		for i, v := range s.PhysicalTableMap {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PhysicalTableMap", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.RowLevelPermissionDataSet != nil {
		if err := s.RowLevelPermissionDataSet.Validate(); err != nil {
			invalidParams.AddNested("RowLevelPermissionDataSet", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDataSetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ColumnGroups != nil {
		v := s.ColumnGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ColumnGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ImportMode) > 0 {
		v := s.ImportMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImportMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LogicalTableMap != nil {
		v := s.LogicalTableMap

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "LogicalTableMap", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Permissions != nil {
		v := s.Permissions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Permissions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.PhysicalTableMap != nil {
		v := s.PhysicalTableMap

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "PhysicalTableMap", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RowLevelPermissionDataSet != nil {
		v := s.RowLevelPermissionDataSet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RowLevelPermissionDataSet", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateDataSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	Arn *string `type:"string"`

	// The ID for the dataset that you want to create. This ID is unique per AWS
	// Region for each AWS account.
	DataSetId *string `type:"string"`

	// The ARN for the ingestion, which is triggered as a result of dataset creation
	// if the import mode is SPICE.
	IngestionArn *string `type:"string"`

	// The ID of the ingestion, which is triggered as a result of dataset creation
	// if the import mode is SPICE.
	IngestionId *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s CreateDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDataSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IngestionArn != nil {
		v := *s.IngestionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IngestionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IngestionId != nil {
		v := *s.IngestionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IngestionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opCreateDataSet = "CreateDataSet"

// CreateDataSetRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Creates a dataset.
//
//    // Example sending a request using CreateDataSetRequest.
//    req := client.CreateDataSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet
func (c *Client) CreateDataSetRequest(input *CreateDataSetInput) CreateDataSetRequest {
	op := &aws.Operation{
		Name:       opCreateDataSet,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets",
	}

	if input == nil {
		input = &CreateDataSetInput{}
	}

	req := c.newRequest(op, input, &CreateDataSetOutput{})
	return CreateDataSetRequest{Request: req, Input: input, Copy: c.CreateDataSetRequest}
}

// CreateDataSetRequest is the request type for the
// CreateDataSet API operation.
type CreateDataSetRequest struct {
	*aws.Request
	Input *CreateDataSetInput
	Copy  func(*CreateDataSetInput) CreateDataSetRequest
}

// Send marshals and sends the CreateDataSet API request.
func (r CreateDataSetRequest) Send(ctx context.Context) (*CreateDataSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDataSetResponse{
		CreateDataSetOutput: r.Request.Data.(*CreateDataSetOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDataSetResponse is the response type for the
// CreateDataSet API operation.
type CreateDataSetResponse struct {
	*CreateDataSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDataSet request.
func (r *CreateDataSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
