// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartInstancesInput struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `locationName:"additionalInfo" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The IDs of the instances.
	//
	// InstanceIds is a required field
	InstanceIds []string `locationName:"InstanceId" locationNameList:"InstanceId" type:"list" required:"true"`
}

// String returns the string representation
func (s StartInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartInstancesInput"}

	if s.InstanceIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the started instances.
	StartingInstances []InstanceStateChange `locationName:"instancesSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s StartInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartInstances = "StartInstances"

// StartInstancesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Starts an Amazon EBS-backed instance that you've previously stopped.
//
// Instances that use Amazon EBS volumes as their root devices can be quickly
// stopped and started. When an instance is stopped, the compute resources are
// released and you are not billed for instance usage. However, your root partition
// Amazon EBS volume remains and continues to persist your data, and you are
// charged for Amazon EBS volume usage. You can restart your instance at any
// time. Every time you start your Windows instance, Amazon EC2 charges you
// for a full instance hour. If you stop and restart your Windows instance,
// a new instance hour begins and Amazon EC2 charges you for another full instance
// hour even if you are still within the same 60-minute period when it was stopped.
// Every time you start your Linux instance, Amazon EC2 charges a one-minute
// minimum for instance usage, and thereafter charges per second for instance
// usage.
//
// Before stopping an instance, make sure it is in a state from which it can
// be restarted. Stopping an instance does not preserve data stored in RAM.
//
// Performing this operation on an instance that uses an instance store as its
// root device returns an error.
//
// For more information, see Stopping Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using StartInstancesRequest.
//    req := client.StartInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/StartInstances
func (c *Client) StartInstancesRequest(input *StartInstancesInput) StartInstancesRequest {
	op := &aws.Operation{
		Name:       opStartInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstancesInput{}
	}

	req := c.newRequest(op, input, &StartInstancesOutput{})
	return StartInstancesRequest{Request: req, Input: input, Copy: c.StartInstancesRequest}
}

// StartInstancesRequest is the request type for the
// StartInstances API operation.
type StartInstancesRequest struct {
	*aws.Request
	Input *StartInstancesInput
	Copy  func(*StartInstancesInput) StartInstancesRequest
}

// Send marshals and sends the StartInstances API request.
func (r StartInstancesRequest) Send(ctx context.Context) (*StartInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartInstancesResponse{
		StartInstancesOutput: r.Request.Data.(*StartInstancesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartInstancesResponse is the response type for the
// StartInstances API operation.
type StartInstancesResponse struct {
	*StartInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartInstances request.
func (r *StartInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
