// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Represents the input of a GetApiCache operation.
type GetApiCacheInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApiCacheInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApiCacheInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetApiCacheInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApiCacheInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the output of a GetApiCache operation.
type GetApiCacheOutput struct {
	_ struct{} `type:"structure"`

	ApiCache *ApiCache `locationName:"apiCache" type:"structure"`
}

// String returns the string representation
func (s GetApiCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApiCacheOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiCache != nil {
		v := s.ApiCache

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "apiCache", v, metadata)
	}
	return nil
}

const opGetApiCache = "GetApiCache"

// GetApiCacheRequest returns a request value for making API operation for
// AWS AppSync.
//
// Retrieves an ApiCache object.
//
//    // Example sending a request using GetApiCacheRequest.
//    req := client.GetApiCacheRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetApiCache
func (c *Client) GetApiCacheRequest(input *GetApiCacheInput) GetApiCacheRequest {
	op := &aws.Operation{
		Name:       opGetApiCache,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/ApiCaches",
	}

	if input == nil {
		input = &GetApiCacheInput{}
	}

	req := c.newRequest(op, input, &GetApiCacheOutput{})
	return GetApiCacheRequest{Request: req, Input: input, Copy: c.GetApiCacheRequest}
}

// GetApiCacheRequest is the request type for the
// GetApiCache API operation.
type GetApiCacheRequest struct {
	*aws.Request
	Input *GetApiCacheInput
	Copy  func(*GetApiCacheInput) GetApiCacheRequest
}

// Send marshals and sends the GetApiCache API request.
func (r GetApiCacheRequest) Send(ctx context.Context) (*GetApiCacheResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetApiCacheResponse{
		GetApiCacheOutput: r.Request.Data.(*GetApiCacheOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetApiCacheResponse is the response type for the
// GetApiCache API operation.
type GetApiCacheResponse struct {
	*GetApiCacheOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetApiCache request.
func (r *GetApiCacheResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
