// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/autoscaling"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To attach an instance to an Auto Scaling group
//
// This example attaches the specified instance to the specified Auto Scaling group.
func ExampleClient_AttachInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.AttachInstancesInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []string{
			"i-93633f9b",
		},
	}

	req := svc.AttachInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a target group to an Auto Scaling group
//
// This example attaches the specified target group to the specified Auto Scaling group.
func ExampleClient_AttachLoadBalancerTargetGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.AttachLoadBalancerTargetGroupsInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		TargetGroupARNs: []string{
			"arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067",
		},
	}

	req := svc.AttachLoadBalancerTargetGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a load balancer to an Auto Scaling group
//
// This example attaches the specified load balancer to the specified Auto Scaling group.
func ExampleClient_AttachLoadBalancersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.AttachLoadBalancersInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		LoadBalancerNames: []string{
			"my-load-balancer",
		},
	}

	req := svc.AttachLoadBalancersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To complete the lifecycle action
//
// This example notifies Auto Scaling that the specified lifecycle action is complete
// so that it can finish launching or terminating the instance.
func ExampleClient_CompleteLifecycleActionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.CompleteLifecycleActionInput{
		AutoScalingGroupName:  aws.String("my-auto-scaling-group"),
		LifecycleActionResult: aws.String("CONTINUE"),
		LifecycleActionToken:  aws.String("bcd2f1b8-9a78-44d3-8a7a-4dd07d7cf635"),
		LifecycleHookName:     aws.String("my-lifecycle-hook"),
	}

	req := svc.CompleteLifecycleActionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an Auto Scaling group
//
// This example creates an Auto Scaling group.
func ExampleClient_CreateAutoScalingGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.CreateAutoScalingGroupInput{
		AutoScalingGroupName:    aws.String("my-auto-scaling-group"),
		LaunchConfigurationName: aws.String("my-launch-config"),
		MaxSize:                 aws.Int64(3),
		MinSize:                 aws.Int64(1),
		VPCZoneIdentifier:       aws.String("subnet-4176792c"),
	}

	req := svc.CreateAutoScalingGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an Auto Scaling group with an attached load balancer
//
// This example creates an Auto Scaling group and attaches the specified Classic Load
// Balancer.
func ExampleClient_CreateAutoScalingGroupRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.CreateAutoScalingGroupInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		AvailabilityZones: []string{
			"us-west-2c",
		},
		HealthCheckGracePeriod:  aws.Int64(120),
		HealthCheckType:         aws.String("ELB"),
		LaunchConfigurationName: aws.String("my-launch-config"),
		LoadBalancerNames: []string{
			"my-load-balancer",
		},
		MaxSize: aws.Int64(3),
		MinSize: aws.Int64(1),
	}

	req := svc.CreateAutoScalingGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an Auto Scaling group with an attached target group
//
// This example creates an Auto Scaling group and attaches the specified target group.
func ExampleClient_CreateAutoScalingGroupRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.CreateAutoScalingGroupInput{
		AutoScalingGroupName:    aws.String("my-auto-scaling-group"),
		HealthCheckGracePeriod:  aws.Int64(120),
		HealthCheckType:         aws.String("ELB"),
		LaunchConfigurationName: aws.String("my-launch-config"),
		MaxSize:                 aws.Int64(3),
		MinSize:                 aws.Int64(1),
		TargetGroupARNs: []string{
			"arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067",
		},
		VPCZoneIdentifier: aws.String("subnet-4176792c, subnet-65ea5f08"),
	}

	req := svc.CreateAutoScalingGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a launch configuration
//
// This example creates a launch configuration.
func ExampleClient_CreateLaunchConfigurationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.CreateLaunchConfigurationInput{
		IamInstanceProfile:      aws.String("my-iam-role"),
		ImageId:                 aws.String("ami-12345678"),
		InstanceType:            aws.String("m3.medium"),
		LaunchConfigurationName: aws.String("my-launch-config"),
		SecurityGroups: []string{
			"sg-eb2af88e",
		},
	}

	req := svc.CreateLaunchConfigurationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create or update tags for an Auto Scaling group
//
// This example adds two tags to the specified Auto Scaling group.
func ExampleClient_CreateOrUpdateTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.CreateOrUpdateTagsInput{
		Tags: []autoscaling.Tag{
			{
				Key:               aws.String("Role"),
				PropagateAtLaunch: aws.Bool(true),
				ResourceId:        aws.String("my-auto-scaling-group"),
				ResourceType:      aws.String("auto-scaling-group"),
				Value:             aws.String("WebServer"),
			},
			{
				Key:               aws.String("Dept"),
				PropagateAtLaunch: aws.Bool(true),
				ResourceId:        aws.String("my-auto-scaling-group"),
				ResourceType:      aws.String("auto-scaling-group"),
				Value:             aws.String("Research"),
			},
		},
	}

	req := svc.CreateOrUpdateTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Auto Scaling group
//
// This example deletes the specified Auto Scaling group.
func ExampleClient_DeleteAutoScalingGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DeleteAutoScalingGroupInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	req := svc.DeleteAutoScalingGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Auto Scaling group and all its instances
//
// This example deletes the specified Auto Scaling group and all its instances.
func ExampleClient_DeleteAutoScalingGroupRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DeleteAutoScalingGroupInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		ForceDelete:          aws.Bool(true),
	}

	req := svc.DeleteAutoScalingGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a launch configuration
//
// This example deletes the specified launch configuration.
func ExampleClient_DeleteLaunchConfigurationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DeleteLaunchConfigurationInput{
		LaunchConfigurationName: aws.String("my-launch-config"),
	}

	req := svc.DeleteLaunchConfigurationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a lifecycle hook
//
// This example deletes the specified lifecycle hook.
func ExampleClient_DeleteLifecycleHookRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DeleteLifecycleHookInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		LifecycleHookName:    aws.String("my-lifecycle-hook"),
	}

	req := svc.DeleteLifecycleHookRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Auto Scaling notification
//
// This example deletes the specified notification from the specified Auto Scaling group.
func ExampleClient_DeleteNotificationConfigurationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DeleteNotificationConfigurationInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		TopicARN:             aws.String("arn:aws:sns:us-west-2:123456789012:my-sns-topic"),
	}

	req := svc.DeleteNotificationConfigurationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Auto Scaling policy
//
// This example deletes the specified Auto Scaling policy.
func ExampleClient_DeletePolicyRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DeletePolicyInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		PolicyName:           aws.String("ScaleIn"),
	}

	req := svc.DeletePolicyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a scheduled action from an Auto Scaling group
//
// This example deletes the specified scheduled action from the specified Auto Scaling
// group.
func ExampleClient_DeleteScheduledActionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DeleteScheduledActionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		ScheduledActionName:  aws.String("my-scheduled-action"),
	}

	req := svc.DeleteScheduledActionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a tag from an Auto Scaling group
//
// This example deletes the specified tag from the specified Auto Scaling group.
func ExampleClient_DeleteTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DeleteTagsInput{
		Tags: []autoscaling.Tag{
			{
				Key:          aws.String("Dept"),
				ResourceId:   aws.String("my-auto-scaling-group"),
				ResourceType: aws.String("auto-scaling-group"),
				Value:        aws.String("Research"),
			},
		},
	}

	req := svc.DeleteTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Auto Scaling account limits
//
// This example describes the Auto Scaling limits for your AWS account.
func ExampleClient_DescribeAccountLimitsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeAccountLimitsInput{}

	req := svc.DescribeAccountLimitsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Auto Scaling adjustment types
//
// This example describes the available adjustment types.
func ExampleClient_DescribeAdjustmentTypesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeAdjustmentTypesInput{}

	req := svc.DescribeAdjustmentTypesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an Auto Scaling group
//
// This example describes the specified Auto Scaling group.
func ExampleClient_DescribeAutoScalingGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeAutoScalingGroupsInput{
		AutoScalingGroupNames: []string{
			"my-auto-scaling-group",
		},
	}

	req := svc.DescribeAutoScalingGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe one or more Auto Scaling instances
//
// This example describes the specified Auto Scaling instance.
func ExampleClient_DescribeAutoScalingInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeAutoScalingInstancesInput{
		InstanceIds: []string{
			"i-4ba0837f",
		},
	}

	req := svc.DescribeAutoScalingInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Auto Scaling notification types
//
// This example describes the available notification types.
func ExampleClient_DescribeAutoScalingNotificationTypesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeAutoScalingNotificationTypesInput{}

	req := svc.DescribeAutoScalingNotificationTypesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Auto Scaling launch configurations
//
// This example describes the specified launch configuration.
func ExampleClient_DescribeLaunchConfigurationsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeLaunchConfigurationsInput{
		LaunchConfigurationNames: []string{
			"my-launch-config",
		},
	}

	req := svc.DescribeLaunchConfigurationsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the available types of lifecycle hooks
//
// This example describes the available lifecycle hook types.
func ExampleClient_DescribeLifecycleHookTypesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeLifecycleHookTypesInput{}

	req := svc.DescribeLifecycleHookTypesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your lifecycle hooks
//
// This example describes the lifecycle hooks for the specified Auto Scaling group.
func ExampleClient_DescribeLifecycleHooksRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeLifecycleHooksInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	req := svc.DescribeLifecycleHooksRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the target groups for an Auto Scaling group
//
// This example describes the target groups attached to the specified Auto Scaling group.
func ExampleClient_DescribeLoadBalancerTargetGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeLoadBalancerTargetGroupsInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	req := svc.DescribeLoadBalancerTargetGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the load balancers for an Auto Scaling group
//
// This example describes the load balancers attached to the specified Auto Scaling
// group.
func ExampleClient_DescribeLoadBalancersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeLoadBalancersInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	req := svc.DescribeLoadBalancersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Auto Scaling metric collection types
//
// This example describes the available metric collection types.
func ExampleClient_DescribeMetricCollectionTypesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeMetricCollectionTypesInput{}

	req := svc.DescribeMetricCollectionTypesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Auto Scaling notification configurations
//
// This example describes the notification configurations for the specified Auto Scaling
// group.
func ExampleClient_DescribeNotificationConfigurationsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeNotificationConfigurationsInput{
		AutoScalingGroupNames: []string{
			"my-auto-scaling-group",
		},
	}

	req := svc.DescribeNotificationConfigurationsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Auto Scaling policies
//
// This example describes the policies for the specified Auto Scaling group.
func ExampleClient_DescribePoliciesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribePoliciesInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	req := svc.DescribePoliciesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the scaling activities for an Auto Scaling group
//
// This example describes the scaling activities for the specified Auto Scaling group.
func ExampleClient_DescribeScalingActivitiesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeScalingActivitiesInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	req := svc.DescribeScalingActivitiesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Auto Scaling process types
//
// This example describes the Auto Scaling process types.
func ExampleClient_DescribeScalingProcessTypesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeScalingProcessTypesInput{}

	req := svc.DescribeScalingProcessTypesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe scheduled actions
//
// This example describes the scheduled actions for the specified Auto Scaling group.
func ExampleClient_DescribeScheduledActionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeScheduledActionsInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	req := svc.DescribeScheduledActionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe tags
//
// This example describes the tags for the specified Auto Scaling group.
func ExampleClient_DescribeTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeTagsInput{
		Filters: []autoscaling.Filter{
			{
				Name: aws.String("auto-scaling-group"),
				Values: []string{
					"my-auto-scaling-group",
				},
			},
		},
	}

	req := svc.DescribeTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe termination policy types
//
// This example describes the available termination policy types.
func ExampleClient_DescribeTerminationPolicyTypesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DescribeTerminationPolicyTypesInput{}

	req := svc.DescribeTerminationPolicyTypesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach an instance from an Auto Scaling group
//
// This example detaches the specified instance from the specified Auto Scaling group.
func ExampleClient_DetachInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DetachInstancesInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []string{
			"i-93633f9b",
		},
		ShouldDecrementDesiredCapacity: aws.Bool(true),
	}

	req := svc.DetachInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a target group from an Auto Scaling group
//
// This example detaches the specified target group from the specified Auto Scaling
// group
func ExampleClient_DetachLoadBalancerTargetGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DetachLoadBalancerTargetGroupsInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		TargetGroupARNs: []string{
			"arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067",
		},
	}

	req := svc.DetachLoadBalancerTargetGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a load balancer from an Auto Scaling group
//
// This example detaches the specified load balancer from the specified Auto Scaling
// group.
func ExampleClient_DetachLoadBalancersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DetachLoadBalancersInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		LoadBalancerNames: []string{
			"my-load-balancer",
		},
	}

	req := svc.DetachLoadBalancersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable metrics collection for an Auto Scaling group
//
// This example disables collecting data for the GroupDesiredCapacity metric for the
// specified Auto Scaling group.
func ExampleClient_DisableMetricsCollectionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.DisableMetricsCollectionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		Metrics: []string{
			"GroupDesiredCapacity",
		},
	}

	req := svc.DisableMetricsCollectionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable metrics collection for an Auto Scaling group
//
// This example enables data collection for the specified Auto Scaling group.
func ExampleClient_EnableMetricsCollectionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.EnableMetricsCollectionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		Granularity:          aws.String("1Minute"),
	}

	req := svc.EnableMetricsCollectionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To move instances into standby mode
//
// This example puts the specified instance into standby mode.
func ExampleClient_EnterStandbyRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.EnterStandbyInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []string{
			"i-93633f9b",
		},
		ShouldDecrementDesiredCapacity: aws.Bool(true),
	}

	req := svc.EnterStandbyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To execute an Auto Scaling policy
//
// This example executes the specified Auto Scaling policy for the specified Auto Scaling
// group.
func ExampleClient_ExecutePolicyRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.ExecutePolicyInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		HonorCooldown:        aws.Bool(true),
		PolicyName:           aws.String("ScaleIn"),
	}

	req := svc.ExecutePolicyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To move instances out of standby mode
//
// This example moves the specified instance out of standby mode.
func ExampleClient_ExitStandbyRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.ExitStandbyInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []string{
			"i-93633f9b",
		},
	}

	req := svc.ExitStandbyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a lifecycle hook
//
// This example creates a lifecycle hook.
func ExampleClient_PutLifecycleHookRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.PutLifecycleHookInput{
		AutoScalingGroupName:  aws.String("my-auto-scaling-group"),
		LifecycleHookName:     aws.String("my-lifecycle-hook"),
		LifecycleTransition:   aws.String("autoscaling:EC2_INSTANCE_LAUNCHING"),
		NotificationTargetARN: aws.String("arn:aws:sns:us-west-2:123456789012:my-sns-topic --role-arn"),
		RoleARN:               aws.String("arn:aws:iam::123456789012:role/my-auto-scaling-role"),
	}

	req := svc.PutLifecycleHookRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add an Auto Scaling notification
//
// This example adds the specified notification to the specified Auto Scaling group.
func ExampleClient_PutNotificationConfigurationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.PutNotificationConfigurationInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		NotificationTypes: []string{
			"autoscaling:TEST_NOTIFICATION",
		},
		TopicARN: aws.String("arn:aws:sns:us-west-2:123456789012:my-sns-topic"),
	}

	req := svc.PutNotificationConfigurationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a scaling policy to an Auto Scaling group
//
// This example adds the specified policy to the specified Auto Scaling group.
func ExampleClient_PutScalingPolicyRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.PutScalingPolicyInput{
		AdjustmentType:       aws.String("ChangeInCapacity"),
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		PolicyName:           aws.String("ScaleIn"),
		ScalingAdjustment:    aws.Int64(-1),
	}

	req := svc.PutScalingPolicyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a scheduled action to an Auto Scaling group
//
// This example adds the specified scheduled action to the specified Auto Scaling group.
func ExampleClient_PutScheduledUpdateGroupActionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.PutScheduledUpdateGroupActionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		DesiredCapacity:      aws.Int64(4),
		EndTime:              parseTime("2006-01-02T15:04:05Z", "2014-05-12T08:00:00Z"),
		MaxSize:              aws.Int64(6),
		MinSize:              aws.Int64(2),
		ScheduledActionName:  aws.String("my-scheduled-action"),
		StartTime:            parseTime("2006-01-02T15:04:05Z", "2014-05-12T08:00:00Z"),
	}

	req := svc.PutScheduledUpdateGroupActionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To record a lifecycle action heartbeat
//
// This example records a lifecycle action heartbeat to keep the instance in a pending
// state.
func ExampleClient_RecordLifecycleActionHeartbeatRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.RecordLifecycleActionHeartbeatInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		LifecycleActionToken: aws.String("bcd2f1b8-9a78-44d3-8a7a-4dd07d7cf635"),
		LifecycleHookName:    aws.String("my-lifecycle-hook"),
	}

	req := svc.RecordLifecycleActionHeartbeatRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To resume Auto Scaling processes
//
// This example resumes the specified suspended scaling process for the specified Auto
// Scaling group.
func ExampleClient_ResumeProcessesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.ResumeProcessesInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		ScalingProcesses: []string{
			"AlarmNotification",
		},
	}

	req := svc.ResumeProcessesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To set the desired capacity for an Auto Scaling group
//
// This example sets the desired capacity for the specified Auto Scaling group.
func ExampleClient_SetDesiredCapacityRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.SetDesiredCapacityInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		DesiredCapacity:      aws.Int64(2),
		HonorCooldown:        aws.Bool(true),
	}

	req := svc.SetDesiredCapacityRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To set the health status of an instance
//
// This example sets the health status of the specified instance to Unhealthy.
func ExampleClient_SetInstanceHealthRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.SetInstanceHealthInput{
		HealthStatus: aws.String("Unhealthy"),
		InstanceId:   aws.String("i-93633f9b"),
	}

	req := svc.SetInstanceHealthRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable instance protection for an instance
//
// This example enables instance protection for the specified instance.
func ExampleClient_SetInstanceProtectionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.SetInstanceProtectionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []string{
			"i-93633f9b",
		},
		ProtectedFromScaleIn: aws.Bool(true),
	}

	req := svc.SetInstanceProtectionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable instance protection for an instance
//
// This example disables instance protection for the specified instance.
func ExampleClient_SetInstanceProtectionRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.SetInstanceProtectionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []string{
			"i-93633f9b",
		},
		ProtectedFromScaleIn: aws.Bool(false),
	}

	req := svc.SetInstanceProtectionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To suspend Auto Scaling processes
//
// This example suspends the specified scaling process for the specified Auto Scaling
// group.
func ExampleClient_SuspendProcessesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.SuspendProcessesInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		ScalingProcesses: []string{
			"AlarmNotification",
		},
	}

	req := svc.SuspendProcessesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To terminate an instance in an Auto Scaling group
//
// This example terminates the specified instance from the specified Auto Scaling group
// without updating the size of the group. Auto Scaling launches a replacement instance
// after the specified instance terminates.
func ExampleClient_TerminateInstanceInAutoScalingGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.TerminateInstanceInAutoScalingGroupInput{
		InstanceId:                     aws.String("i-93633f9b"),
		ShouldDecrementDesiredCapacity: aws.Bool(false),
	}

	req := svc.TerminateInstanceInAutoScalingGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the launch configuration
//
// This example updates the launch configuration of the specified Auto Scaling group.
func ExampleClient_UpdateAutoScalingGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.UpdateAutoScalingGroupInput{
		AutoScalingGroupName:    aws.String("my-auto-scaling-group"),
		LaunchConfigurationName: aws.String("new-launch-config"),
	}

	req := svc.UpdateAutoScalingGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the minimum and maximum size
//
// This example updates the minimum size and maximum size of the specified Auto Scaling
// group.
func ExampleClient_UpdateAutoScalingGroupRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.UpdateAutoScalingGroupInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		MaxSize:              aws.Int64(3),
		MinSize:              aws.Int64(1),
	}

	req := svc.UpdateAutoScalingGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable instance protection
//
// This example enables instance protection for the specified Auto Scaling group.
func ExampleClient_UpdateAutoScalingGroupRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := autoscaling.New(cfg)
	input := &autoscaling.UpdateAutoScalingGroupInput{
		AutoScalingGroupName:             aws.String("my-auto-scaling-group"),
		NewInstancesProtectedFromScaleIn: aws.Bool(true),
	}

	req := svc.UpdateAutoScalingGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeServiceLinkedRoleFailure:
				fmt.Println(autoscaling.ErrCodeServiceLinkedRoleFailure, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
