// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetFieldLevelEncryptionConfigInput struct {
	_ struct{} `type:"structure"`

	// Request the ID for the field-level encryption configuration information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFieldLevelEncryptionConfigInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFieldLevelEncryptionConfigInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

type GetFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionConfig"`

	// The current version of the field level encryption configuration. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the field-level encryption configuration information.
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `type:"structure"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFieldLevelEncryptionConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.FieldLevelEncryptionConfig != nil {
		v := s.FieldLevelEncryptionConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "FieldLevelEncryptionConfig", v, metadata)
	}
	return nil
}

const opGetFieldLevelEncryptionConfig = "GetFieldLevelEncryptionConfig2019_03_26"

// GetFieldLevelEncryptionConfigRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Get the field-level encryption configuration information.
//
//    // Example sending a request using GetFieldLevelEncryptionConfigRequest.
//    req := client.GetFieldLevelEncryptionConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionConfig
func (c *Client) GetFieldLevelEncryptionConfigRequest(input *GetFieldLevelEncryptionConfigInput) GetFieldLevelEncryptionConfigRequest {
	op := &aws.Operation{
		Name:       opGetFieldLevelEncryptionConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/field-level-encryption/{Id}/config",
	}

	if input == nil {
		input = &GetFieldLevelEncryptionConfigInput{}
	}

	req := c.newRequest(op, input, &GetFieldLevelEncryptionConfigOutput{})
	return GetFieldLevelEncryptionConfigRequest{Request: req, Input: input, Copy: c.GetFieldLevelEncryptionConfigRequest}
}

// GetFieldLevelEncryptionConfigRequest is the request type for the
// GetFieldLevelEncryptionConfig API operation.
type GetFieldLevelEncryptionConfigRequest struct {
	*aws.Request
	Input *GetFieldLevelEncryptionConfigInput
	Copy  func(*GetFieldLevelEncryptionConfigInput) GetFieldLevelEncryptionConfigRequest
}

// Send marshals and sends the GetFieldLevelEncryptionConfig API request.
func (r GetFieldLevelEncryptionConfigRequest) Send(ctx context.Context) (*GetFieldLevelEncryptionConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetFieldLevelEncryptionConfigResponse{
		GetFieldLevelEncryptionConfigOutput: r.Request.Data.(*GetFieldLevelEncryptionConfigOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetFieldLevelEncryptionConfigResponse is the response type for the
// GetFieldLevelEncryptionConfig API operation.
type GetFieldLevelEncryptionConfigResponse struct {
	*GetFieldLevelEncryptionConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetFieldLevelEncryptionConfig request.
func (r *GetFieldLevelEncryptionConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
