// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// The identity provider name.
	//
	// ProviderName is a required field
	ProviderName *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityProviderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeIdentityProviderInput"}

	if s.ProviderName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProviderName"))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProviderName", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider that was deleted.
	//
	// IdentityProvider is a required field
	IdentityProvider *IdentityProviderType `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeIdentityProvider = "DescribeIdentityProvider"

// DescribeIdentityProviderRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Gets information about a specific identity provider.
//
//    // Example sending a request using DescribeIdentityProviderRequest.
//    req := client.DescribeIdentityProviderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/DescribeIdentityProvider
func (c *Client) DescribeIdentityProviderRequest(input *DescribeIdentityProviderInput) DescribeIdentityProviderRequest {
	op := &aws.Operation{
		Name:       opDescribeIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityProviderInput{}
	}

	req := c.newRequest(op, input, &DescribeIdentityProviderOutput{})
	return DescribeIdentityProviderRequest{Request: req, Input: input, Copy: c.DescribeIdentityProviderRequest}
}

// DescribeIdentityProviderRequest is the request type for the
// DescribeIdentityProvider API operation.
type DescribeIdentityProviderRequest struct {
	*aws.Request
	Input *DescribeIdentityProviderInput
	Copy  func(*DescribeIdentityProviderInput) DescribeIdentityProviderRequest
}

// Send marshals and sends the DescribeIdentityProvider API request.
func (r DescribeIdentityProviderRequest) Send(ctx context.Context) (*DescribeIdentityProviderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeIdentityProviderResponse{
		DescribeIdentityProviderOutput: r.Request.Data.(*DescribeIdentityProviderOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeIdentityProviderResponse is the response type for the
// DescribeIdentityProvider API operation.
type DescribeIdentityProviderResponse struct {
	*DescribeIdentityProviderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeIdentityProvider request.
func (r *DescribeIdentityProviderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
