// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeConfigurationAggregatorSourcesStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// The maximum number of AggregatorSourceStatus returned on each page. The default
	// is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Filters the status type.
	//
	//    * Valid value FAILED indicates errors while moving data.
	//
	//    * Valid value SUCCEEDED indicates the data was successfully moved.
	//
	//    * Valid value OUTDATED indicates the data is not the most recent.
	UpdateStatus []AggregatedSourceStatusType `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationAggregatorSourcesStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeConfigurationAggregatorSourcesStatusInput"}

	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.UpdateStatus != nil && len(s.UpdateStatus) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UpdateStatus", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeConfigurationAggregatorSourcesStatusOutput struct {
	_ struct{} `type:"structure"`

	// Returns an AggregatedSourceStatus object.
	AggregatedSourceStatusList []AggregatedSourceStatus `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationAggregatorSourcesStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeConfigurationAggregatorSourcesStatus = "DescribeConfigurationAggregatorSourcesStatus"

// DescribeConfigurationAggregatorSourcesStatusRequest returns a request value for making API operation for
// AWS Config.
//
// Returns status information for sources within an aggregator. The status includes
// information about the last time AWS Config verified authorization between
// the source account and an aggregator account. In case of a failure, the status
// contains the related error code or message.
//
//    // Example sending a request using DescribeConfigurationAggregatorSourcesStatusRequest.
//    req := client.DescribeConfigurationAggregatorSourcesStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus
func (c *Client) DescribeConfigurationAggregatorSourcesStatusRequest(input *DescribeConfigurationAggregatorSourcesStatusInput) DescribeConfigurationAggregatorSourcesStatusRequest {
	op := &aws.Operation{
		Name:       opDescribeConfigurationAggregatorSourcesStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationAggregatorSourcesStatusInput{}
	}

	req := c.newRequest(op, input, &DescribeConfigurationAggregatorSourcesStatusOutput{})
	return DescribeConfigurationAggregatorSourcesStatusRequest{Request: req, Input: input, Copy: c.DescribeConfigurationAggregatorSourcesStatusRequest}
}

// DescribeConfigurationAggregatorSourcesStatusRequest is the request type for the
// DescribeConfigurationAggregatorSourcesStatus API operation.
type DescribeConfigurationAggregatorSourcesStatusRequest struct {
	*aws.Request
	Input *DescribeConfigurationAggregatorSourcesStatusInput
	Copy  func(*DescribeConfigurationAggregatorSourcesStatusInput) DescribeConfigurationAggregatorSourcesStatusRequest
}

// Send marshals and sends the DescribeConfigurationAggregatorSourcesStatus API request.
func (r DescribeConfigurationAggregatorSourcesStatusRequest) Send(ctx context.Context) (*DescribeConfigurationAggregatorSourcesStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConfigurationAggregatorSourcesStatusResponse{
		DescribeConfigurationAggregatorSourcesStatusOutput: r.Request.Data.(*DescribeConfigurationAggregatorSourcesStatusOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConfigurationAggregatorSourcesStatusResponse is the response type for the
// DescribeConfigurationAggregatorSourcesStatus API operation.
type DescribeConfigurationAggregatorSourcesStatusResponse struct {
	*DescribeConfigurationAggregatorSourcesStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConfigurationAggregatorSourcesStatus request.
func (r *DescribeConfigurationAggregatorSourcesStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
