// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package firehose

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutRecordInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The record.
	//
	// Record is a required field
	Record *Record `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutRecordInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutRecordInput"}

	if s.DeliveryStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeliveryStreamName", 1))
	}

	if s.Record == nil {
		invalidParams.Add(aws.NewErrParamRequired("Record"))
	}
	if s.Record != nil {
		if err := s.Record.Validate(); err != nil {
			invalidParams.AddNested("Record", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutRecordOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether server-side encryption (SSE) was enabled during this operation.
	Encrypted *bool `type:"boolean"`

	// The ID of the record.
	//
	// RecordId is a required field
	RecordId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRecordOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutRecord = "PutRecord"

// PutRecordRequest returns a request value for making API operation for
// Amazon Kinesis Firehose.
//
// Writes a single data record into an Amazon Kinesis Data Firehose delivery
// stream. To write multiple data records into a delivery stream, use PutRecordBatch.
// Applications using these operations are referred to as producers.
//
// By default, each delivery stream can take in up to 2,000 transactions per
// second, 5,000 records per second, or 5 MB per second. If you use PutRecord
// and PutRecordBatch, the limits are an aggregate across these two operations
// for each delivery stream. For more information about limits and how to request
// an increase, see Amazon Kinesis Data Firehose Limits (https://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// You must specify the name of the delivery stream and the data record when
// using PutRecord. The data record consists of a data blob that can be up to
// 1,000 KB in size, and any kind of data. For example, it can be a segment
// from a log file, geographic location data, website clickstream data, and
// so on.
//
// Kinesis Data Firehose buffers records before delivering them to the destination.
// To disambiguate the data blobs at the destination, a common solution is to
// use delimiters in the data, such as a newline (\n) or some other character
// unique within the data. This allows the consumer application to parse individual
// data items when reading the data from the destination.
//
// The PutRecord operation returns a RecordId, which is a unique string assigned
// to each record. Producer applications can use this ID for purposes such as
// auditability and investigation.
//
// If the PutRecord operation throws a ServiceUnavailableException, back off
// and retry. If the exception persists, it is possible that the throughput
// limits have been exceeded for the delivery stream.
//
// Data records sent to Kinesis Data Firehose are stored for 24 hours from the
// time they are added to a delivery stream as it tries to send the records
// to the destination. If the destination is unreachable for more than 24 hours,
// the data is no longer available.
//
// Don't concatenate two or more base64 strings to form the data fields of your
// records. Instead, concatenate the raw data, then perform base64 encoding.
//
//    // Example sending a request using PutRecordRequest.
//    req := client.PutRecordRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/PutRecord
func (c *Client) PutRecordRequest(input *PutRecordInput) PutRecordRequest {
	op := &aws.Operation{
		Name:       opPutRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordInput{}
	}

	req := c.newRequest(op, input, &PutRecordOutput{})
	return PutRecordRequest{Request: req, Input: input, Copy: c.PutRecordRequest}
}

// PutRecordRequest is the request type for the
// PutRecord API operation.
type PutRecordRequest struct {
	*aws.Request
	Input *PutRecordInput
	Copy  func(*PutRecordInput) PutRecordRequest
}

// Send marshals and sends the PutRecord API request.
func (r PutRecordRequest) Send(ctx context.Context) (*PutRecordResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutRecordResponse{
		PutRecordOutput: r.Request.Data.(*PutRecordOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutRecordResponse is the response type for the
// PutRecord API operation.
type PutRecordResponse struct {
	*PutRecordOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutRecord request.
func (r *PutRecordResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
