// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type DeleteSigningCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the signing certificate to delete.
	//
	// The format of this parameter, as described by its regex (http://wikipedia.org/wiki/regex)
	// pattern, is a string of characters that can be upper- or lower-cased letters
	// or digits.
	//
	// CertificateId is a required field
	CertificateId *string `min:"24" type:"string" required:"true"`

	// The name of the user the signing certificate belongs to.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSigningCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSigningCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSigningCertificateInput"}

	if s.CertificateId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 24 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateId", 24))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteSigningCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSigningCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSigningCertificate = "DeleteSigningCertificate"

// DeleteSigningCertificateRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Deletes a signing certificate associated with the specified IAM user.
//
// If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID signing the request. This operation works
// for access keys under the AWS account. Consequently, you can use this operation
// to manage AWS account root user credentials even if the AWS account has no
// associated IAM users.
//
//    // Example sending a request using DeleteSigningCertificateRequest.
//    req := client.DeleteSigningCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificate
func (c *Client) DeleteSigningCertificateRequest(input *DeleteSigningCertificateInput) DeleteSigningCertificateRequest {
	op := &aws.Operation{
		Name:       opDeleteSigningCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSigningCertificateInput{}
	}

	req := c.newRequest(op, input, &DeleteSigningCertificateOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteSigningCertificateRequest{Request: req, Input: input, Copy: c.DeleteSigningCertificateRequest}
}

// DeleteSigningCertificateRequest is the request type for the
// DeleteSigningCertificate API operation.
type DeleteSigningCertificateRequest struct {
	*aws.Request
	Input *DeleteSigningCertificateInput
	Copy  func(*DeleteSigningCertificateInput) DeleteSigningCertificateRequest
}

// Send marshals and sends the DeleteSigningCertificate API request.
func (r DeleteSigningCertificateRequest) Send(ctx context.Context) (*DeleteSigningCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSigningCertificateResponse{
		DeleteSigningCertificateOutput: r.Request.Data.(*DeleteSigningCertificateOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSigningCertificateResponse is the response type for the
// DeleteSigningCertificate API operation.
type DeleteSigningCertificateResponse struct {
	*DeleteSigningCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSigningCertificate request.
func (r *DeleteSigningCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
