// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutImageRecipePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe that this policy should
	// be applied to.
	//
	// ImageRecipeArn is a required field
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string" required:"true"`

	// The policy to apply.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutImageRecipePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutImageRecipePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutImageRecipePolicyInput"}

	if s.ImageRecipeArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageRecipeArn"))
	}

	if s.Policy == nil {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutImageRecipePolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ImageRecipeArn != nil {
		v := *s.ImageRecipeArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageRecipeArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutImageRecipePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe that this policy was applied
	// to.
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s PutImageRecipePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutImageRecipePolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ImageRecipeArn != nil {
		v := *s.ImageRecipeArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageRecipeArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opPutImageRecipePolicy = "PutImageRecipePolicy"

// PutImageRecipePolicyRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Applies a policy to an image recipe.
//
//    // Example sending a request using PutImageRecipePolicyRequest.
//    req := client.PutImageRecipePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImageRecipePolicy
func (c *Client) PutImageRecipePolicyRequest(input *PutImageRecipePolicyInput) PutImageRecipePolicyRequest {
	op := &aws.Operation{
		Name:       opPutImageRecipePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/PutImageRecipePolicy",
	}

	if input == nil {
		input = &PutImageRecipePolicyInput{}
	}

	req := c.newRequest(op, input, &PutImageRecipePolicyOutput{})
	return PutImageRecipePolicyRequest{Request: req, Input: input, Copy: c.PutImageRecipePolicyRequest}
}

// PutImageRecipePolicyRequest is the request type for the
// PutImageRecipePolicy API operation.
type PutImageRecipePolicyRequest struct {
	*aws.Request
	Input *PutImageRecipePolicyInput
	Copy  func(*PutImageRecipePolicyInput) PutImageRecipePolicyRequest
}

// Send marshals and sends the PutImageRecipePolicy API request.
func (r PutImageRecipePolicyRequest) Send(ctx context.Context) (*PutImageRecipePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutImageRecipePolicyResponse{
		PutImageRecipePolicyOutput: r.Request.Data.(*PutImageRecipePolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutImageRecipePolicyResponse is the response type for the
// PutImageRecipePolicy API operation.
type PutImageRecipePolicyResponse struct {
	*PutImageRecipePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutImageRecipePolicy request.
func (r *PutImageRecipePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
