// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []string `type:"list"`

	// Identifies the asymmetric CMK that includes the public key.
	//
	// To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name,
	// or alias ARN. When using an alias name, prefix it with "alias/". To specify
	// a CMK in a different AWS account, you must use the key ARN or alias ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
	// get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPublicKeyInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// The type of the of the public key that was downloaded.
	CustomerMasterKeySpec CustomerMasterKeySpec `type:"string" enum:"true"`

	// The encryption algorithms that AWS KMS supports for this key.
	//
	// This information is critical. If a public key encrypts data outside of AWS
	// KMS by using an unsupported encryption algorithm, the ciphertext cannot be
	// decrypted.
	//
	// This field appears in the response only when the KeyUsage of the public key
	// is ENCRYPT_DECRYPT.
	EncryptionAlgorithms []EncryptionAlgorithmSpec `type:"list"`

	// The identifier of the asymmetric CMK from which the public key was downloaded.
	KeyId *string `min:"1" type:"string"`

	// The permitted use of the public key. Valid values are ENCRYPT_DECRYPT or
	// SIGN_VERIFY.
	//
	// This information is critical. If a public key with SIGN_VERIFY key usage
	// encrypts data outside of AWS KMS, the ciphertext cannot be decrypted.
	KeyUsage KeyUsageType `type:"string" enum:"true"`

	// The exported public key.
	//
	// This value is returned as a binary Distinguished Encoding Rules (https://www.itu.int/ITU-T/studygroups/com17/languages/X.690-0207.pdf)
	// (DER)-encoded object. To decode it, use an ASN.1 parsing tool, such as OpenSSL
	// asn1parse (https://www.openssl.org/docs/man1.0.2/man1/asn1parse.html).
	//
	// PublicKey is automatically base64 encoded/decoded by the SDK.
	PublicKey []byte `min:"1" type:"blob"`

	// The signing algorithms that AWS KMS supports for this key.
	//
	// This field appears in the response only when the KeyUsage of the public key
	// is SIGN_VERIFY.
	SigningAlgorithms []SigningAlgorithmSpec `type:"list"`
}

// String returns the string representation
func (s GetPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetPublicKey = "GetPublicKey"

// GetPublicKeyRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Returns the public key of an asymmetric CMK. Unlike the private key of a
// asymmetric CMK, which never leaves AWS KMS unencrypted, callers with kms:GetPublicKey
// permission can download the public key of an asymmetric CMK. You can share
// the public key to allow others to encrypt messages and verify signatures
// outside of AWS KMS. For information about symmetric and asymmetric CMKs,
// see Using Symmetric and Asymmetric CMKs (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
// in the AWS Key Management Service Developer Guide.
//
// You do not need to download the public key. Instead, you can use the public
// key within AWS KMS by calling the Encrypt, ReEncrypt, or Verify operations
// with the identifier of an asymmetric CMK. When you use the public key within
// AWS KMS, you benefit from the authentication, authorization, and logging
// that are part of every AWS KMS operation. You also reduce of risk of encrypting
// data that cannot be decrypted. These features are not effective outside of
// AWS KMS. For details, see Special Considerations for Downloading Public Keys
// (https://docs.aws.amazon.com/kms/latest/developerguide/download-public-key.html#download-public-key-considerations).
//
// To help you use the public key safely outside of AWS KMS, GetPublicKey returns
// important information about the public key in the response, including:
//
//    * CustomerMasterKeySpec (https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-CustomerMasterKeySpec):
//    The type of key material in the public key, such as RSA_4096 or ECC_NIST_P521.
//
//    * KeyUsage (https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-KeyUsage):
//    Whether the key is used for encryption or signing.
//
//    * EncryptionAlgorithms (https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-EncryptionAlgorithms)
//    or SigningAlgorithms (https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-SigningAlgorithms):
//    A list of the encryption algorithms or the signing algorithms for the
//    key.
//
// Although AWS KMS cannot enforce these restrictions on external operations,
// it is crucial that you use this information to prevent the public key from
// being used improperly. For example, you can prevent a public signing key
// from being used encrypt data, or prevent a public key from being used with
// an encryption algorithm that is not supported by AWS KMS. You can also avoid
// errors, such as using the wrong signing algorithm in a verification operation.
//
// The CMK that you use for this operation must be in a compatible key state.
// For details, see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
//    // Example sending a request using GetPublicKeyRequest.
//    req := client.GetPublicKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetPublicKey
func (c *Client) GetPublicKeyRequest(input *GetPublicKeyInput) GetPublicKeyRequest {
	op := &aws.Operation{
		Name:       opGetPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPublicKeyInput{}
	}

	req := c.newRequest(op, input, &GetPublicKeyOutput{})
	return GetPublicKeyRequest{Request: req, Input: input, Copy: c.GetPublicKeyRequest}
}

// GetPublicKeyRequest is the request type for the
// GetPublicKey API operation.
type GetPublicKeyRequest struct {
	*aws.Request
	Input *GetPublicKeyInput
	Copy  func(*GetPublicKeyInput) GetPublicKeyRequest
}

// Send marshals and sends the GetPublicKey API request.
func (r GetPublicKeyRequest) Send(ctx context.Context) (*GetPublicKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPublicKeyResponse{
		GetPublicKeyOutput: r.Request.Data.(*GetPublicKeyOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPublicKeyResponse is the response type for the
// GetPublicKey API operation.
type GetPublicKeyResponse struct {
	*GetPublicKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPublicKey request.
func (r *GetPublicKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
