// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package machinelearning

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteEvaluationInput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the Evaluation to delete.
	//
	// EvaluationId is a required field
	EvaluationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEvaluationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEvaluationInput"}

	if s.EvaluationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EvaluationId"))
	}
	if s.EvaluationId != nil && len(*s.EvaluationId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EvaluationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a DeleteEvaluation operation. The output indicates
// that Amazon Machine Learning (Amazon ML) received the request.
//
// You can use the GetEvaluation operation and check the value of the Status
// parameter to see whether an Evaluation is marked as DELETED.
type DeleteEvaluationOutput struct {
	_ struct{} `type:"structure"`

	// A user-supplied ID that uniquely identifies the Evaluation. This value should
	// be identical to the value of the EvaluationId in the request.
	EvaluationId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteEvaluation = "DeleteEvaluation"

// DeleteEvaluationRequest returns a request value for making API operation for
// Amazon Machine Learning.
//
// Assigns the DELETED status to an Evaluation, rendering it unusable.
//
// After invoking the DeleteEvaluation operation, you can use the GetEvaluation
// operation to verify that the status of the Evaluation changed to DELETED.
//  Caution
// The results of the DeleteEvaluation operation are irreversible.
//
//    // Example sending a request using DeleteEvaluationRequest.
//    req := client.DeleteEvaluationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteEvaluationRequest(input *DeleteEvaluationInput) DeleteEvaluationRequest {
	op := &aws.Operation{
		Name:       opDeleteEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEvaluationInput{}
	}

	req := c.newRequest(op, input, &DeleteEvaluationOutput{})
	return DeleteEvaluationRequest{Request: req, Input: input, Copy: c.DeleteEvaluationRequest}
}

// DeleteEvaluationRequest is the request type for the
// DeleteEvaluation API operation.
type DeleteEvaluationRequest struct {
	*aws.Request
	Input *DeleteEvaluationInput
	Copy  func(*DeleteEvaluationInput) DeleteEvaluationRequest
}

// Send marshals and sends the DeleteEvaluation API request.
func (r DeleteEvaluationRequest) Send(ctx context.Context) (*DeleteEvaluationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEvaluationResponse{
		DeleteEvaluationOutput: r.Request.Data.(*DeleteEvaluationOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEvaluationResponse is the response type for the
// DeleteEvaluation API operation.
type DeleteEvaluationResponse struct {
	*DeleteEvaluationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEvaluation request.
func (r *DeleteEvaluationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
