// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ram

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListPendingInvitationResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the invitation.
	//
	// ResourceShareInvitationArn is a required field
	ResourceShareInvitationArn *string `locationName:"resourceShareInvitationArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPendingInvitationResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPendingInvitationResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPendingInvitationResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ResourceShareInvitationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceShareInvitationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPendingInvitationResourcesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceShareInvitationArn != nil {
		v := *s.ResourceShareInvitationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceShareInvitationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListPendingInvitationResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the resources included the resource share.
	Resources []Resource `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s ListPendingInvitationResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPendingInvitationResourcesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Resources != nil {
		v := s.Resources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "resources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListPendingInvitationResources = "ListPendingInvitationResources"

// ListPendingInvitationResourcesRequest returns a request value for making API operation for
// AWS Resource Access Manager.
//
// Lists the resources in a resource share that is shared with you but that
// the invitation is still pending for.
//
//    // Example sending a request using ListPendingInvitationResourcesRequest.
//    req := client.ListPendingInvitationResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ram-2018-01-04/ListPendingInvitationResources
func (c *Client) ListPendingInvitationResourcesRequest(input *ListPendingInvitationResourcesInput) ListPendingInvitationResourcesRequest {
	op := &aws.Operation{
		Name:       opListPendingInvitationResources,
		HTTPMethod: "POST",
		HTTPPath:   "/listpendinginvitationresources",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPendingInvitationResourcesInput{}
	}

	req := c.newRequest(op, input, &ListPendingInvitationResourcesOutput{})
	return ListPendingInvitationResourcesRequest{Request: req, Input: input, Copy: c.ListPendingInvitationResourcesRequest}
}

// ListPendingInvitationResourcesRequest is the request type for the
// ListPendingInvitationResources API operation.
type ListPendingInvitationResourcesRequest struct {
	*aws.Request
	Input *ListPendingInvitationResourcesInput
	Copy  func(*ListPendingInvitationResourcesInput) ListPendingInvitationResourcesRequest
}

// Send marshals and sends the ListPendingInvitationResources API request.
func (r ListPendingInvitationResourcesRequest) Send(ctx context.Context) (*ListPendingInvitationResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPendingInvitationResourcesResponse{
		ListPendingInvitationResourcesOutput: r.Request.Data.(*ListPendingInvitationResourcesOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPendingInvitationResourcesRequestPaginator returns a paginator for ListPendingInvitationResources.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPendingInvitationResourcesRequest(input)
//   p := ram.NewListPendingInvitationResourcesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPendingInvitationResourcesPaginator(req ListPendingInvitationResourcesRequest) ListPendingInvitationResourcesPaginator {
	return ListPendingInvitationResourcesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPendingInvitationResourcesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPendingInvitationResourcesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPendingInvitationResourcesPaginator struct {
	aws.Pager
}

func (p *ListPendingInvitationResourcesPaginator) CurrentPage() *ListPendingInvitationResourcesOutput {
	return p.Pager.CurrentPage().(*ListPendingInvitationResourcesOutput)
}

// ListPendingInvitationResourcesResponse is the response type for the
// ListPendingInvitationResources API operation.
type ListPendingInvitationResourcesResponse struct {
	*ListPendingInvitationResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPendingInvitationResources request.
func (r *ListPendingInvitationResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
