// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CopyDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether to copy all tags from the source DB cluster
	// snapshot to the target DB cluster snapshot. By default, tags are not copied.
	CopyTags *bool `type:"boolean"`

	// DestinationRegion is used for presigning the request to a given region.
	DestinationRegion *string `type:"string"`

	// The AWS AWS KMS key ID for an encrypted DB cluster snapshot. The KMS key
	// ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key
	// alias for the KMS encryption key.
	//
	// If you copy an encrypted DB cluster snapshot from your AWS account, you can
	// specify a value for KmsKeyId to encrypt the copy with a new KMS encryption
	// key. If you don't specify a value for KmsKeyId, then the copy of the DB cluster
	// snapshot is encrypted with the same KMS key as the source DB cluster snapshot.
	//
	// If you copy an encrypted DB cluster snapshot that is shared from another
	// AWS account, then you must specify a value for KmsKeyId.
	//
	// To copy an encrypted DB cluster snapshot to another AWS Region, you must
	// set KmsKeyId to the KMS key ID you want to use to encrypt the copy of the
	// DB cluster snapshot in the destination AWS Region. KMS encryption keys are
	// specific to the AWS Region that they are created in, and you can't use encryption
	// keys from one AWS Region in another AWS Region.
	//
	// If you copy an unencrypted DB cluster snapshot and specify a value for the
	// KmsKeyId parameter, an error is returned.
	KmsKeyId *string `type:"string"`

	// The URL that contains a Signature Version 4 signed request for the CopyDBClusterSnapshot
	// API action in the AWS Region that contains the source DB cluster snapshot
	// to copy. The PreSignedUrl parameter must be used when copying an encrypted
	// DB cluster snapshot from another AWS Region. Don't specify PreSignedUrl when
	// you are copying an encrypted DB cluster snapshot in the same AWS Region.
	//
	// The pre-signed URL must be a valid request for the CopyDBSClusterSnapshot
	// API action that can be executed in the source AWS Region that contains the
	// encrypted DB cluster snapshot to be copied. The pre-signed URL request must
	// contain the following parameter values:
	//
	//    * KmsKeyId - The AWS KMS key identifier for the key to use to encrypt
	//    the copy of the DB cluster snapshot in the destination AWS Region. This
	//    is the same identifier for both the CopyDBClusterSnapshot action that
	//    is called in the destination AWS Region, and the action contained in the
	//    pre-signed URL.
	//
	//    * DestinationRegion - The name of the AWS Region that the DB cluster snapshot
	//    will be created in.
	//
	//    * SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier
	//    for the encrypted DB cluster snapshot to be copied. This identifier must
	//    be in the Amazon Resource Name (ARN) format for the source AWS Region.
	//    For example, if you are copying an encrypted DB cluster snapshot from
	//    the us-west-2 AWS Region, then your SourceDBClusterSnapshotIdentifier
	//    looks like the following example: arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115.
	//
	// To learn how to generate a Signature Version 4 signed request, see Authenticating
	// Requests: Using Query Parameters (AWS Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// and Signature Version 4 Signing Process (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	//
	// If you are using an AWS SDK tool or the AWS CLI, you can specify SourceRegion
	// (or --source-region for the AWS CLI) instead of specifying PreSignedUrl manually.
	// Specifying SourceRegion autogenerates a pre-signed URL that is a valid request
	// for the operation that can be executed in the source AWS Region.
	PreSignedUrl *string `type:"string"`

	// The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.
	//
	// You can't copy an encrypted, shared DB cluster snapshot from one AWS Region
	// to another.
	//
	// Constraints:
	//
	//    * Must specify a valid system snapshot in the "available" state.
	//
	//    * If the source snapshot is in the same AWS Region as the copy, specify
	//    a valid DB snapshot identifier.
	//
	//    * If the source snapshot is in a different AWS Region than the copy, specify
	//    a valid DB cluster snapshot ARN. For more information, go to Copying Snapshots
	//    Across AWS Regions (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions)
	//    in the Amazon Aurora User Guide.
	//
	// Example: my-cluster-snapshot1
	//
	// SourceDBClusterSnapshotIdentifier is a required field
	SourceDBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// SourceRegion is the source region where the resource exists. This is not
	// sent over the wire and is only used for presigning. This value should always
	// have the same region as the source ARN.
	SourceRegion *string `type:"string" ignore:"true"`

	// A list of tags. For more information, see Tagging Amazon RDS Resources (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
	// in the Amazon RDS User Guide.
	Tags []Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the new DB cluster snapshot to create from the source DB
	// cluster snapshot. This parameter isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster-snapshot2
	//
	// TargetDBClusterSnapshotIdentifier is a required field
	TargetDBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBClusterSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CopyDBClusterSnapshotInput"}

	if s.SourceDBClusterSnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceDBClusterSnapshotIdentifier"))
	}

	if s.TargetDBClusterSnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetDBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CopyDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details for an Amazon RDS DB cluster snapshot
	//
	// This data type is used as a response element in the DescribeDBClusterSnapshots
	// action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opCopyDBClusterSnapshot = "CopyDBClusterSnapshot"

// CopyDBClusterSnapshotRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Copies a snapshot of a DB cluster.
//
// To copy a DB cluster snapshot from a shared manual DB cluster snapshot, SourceDBClusterSnapshotIdentifier
// must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.
//
// You can copy an encrypted DB cluster snapshot from another AWS Region. In
// that case, the AWS Region where you call the CopyDBClusterSnapshot action
// is the destination AWS Region for the encrypted DB cluster snapshot to be
// copied to. To copy an encrypted DB cluster snapshot from another AWS Region,
// you must provide the following values:
//
//    * KmsKeyId - The AWS Key Management System (AWS KMS) key identifier for
//    the key to use to encrypt the copy of the DB cluster snapshot in the destination
//    AWS Region.
//
//    * PreSignedUrl - A URL that contains a Signature Version 4 signed request
//    for the CopyDBClusterSnapshot action to be called in the source AWS Region
//    where the DB cluster snapshot is copied from. The pre-signed URL must
//    be a valid request for the CopyDBClusterSnapshot API action that can be
//    executed in the source AWS Region that contains the encrypted DB cluster
//    snapshot to be copied. The pre-signed URL request must contain the following
//    parameter values: KmsKeyId - The KMS key identifier for the key to use
//    to encrypt the copy of the DB cluster snapshot in the destination AWS
//    Region. This is the same identifier for both the CopyDBClusterSnapshot
//    action that is called in the destination AWS Region, and the action contained
//    in the pre-signed URL. DestinationRegion - The name of the AWS Region
//    that the DB cluster snapshot will be created in. SourceDBClusterSnapshotIdentifier
//    - The DB cluster snapshot identifier for the encrypted DB cluster snapshot
//    to be copied. This identifier must be in the Amazon Resource Name (ARN)
//    format for the source AWS Region. For example, if you are copying an encrypted
//    DB cluster snapshot from the us-west-2 AWS Region, then your SourceDBClusterSnapshotIdentifier
//    looks like the following example: arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115.
//    To learn how to generate a Signature Version 4 signed request, see Authenticating
//    Requests: Using Query Parameters (AWS Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
//    and Signature Version 4 Signing Process (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//    If you are using an AWS SDK tool or the AWS CLI, you can specify SourceRegion
//    (or --source-region for the AWS CLI) instead of specifying PreSignedUrl
//    manually. Specifying SourceRegion autogenerates a pre-signed URL that
//    is a valid request for the operation that can be executed in the source
//    AWS Region.
//
//    * TargetDBClusterSnapshotIdentifier - The identifier for the new copy
//    of the DB cluster snapshot in the destination AWS Region.
//
//    * SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier
//    for the encrypted DB cluster snapshot to be copied. This identifier must
//    be in the ARN format for the source AWS Region and is the same value as
//    the SourceDBClusterSnapshotIdentifier in the pre-signed URL.
//
// To cancel the copy operation once it is in progress, delete the target DB
// cluster snapshot identified by TargetDBClusterSnapshotIdentifier while that
// DB cluster snapshot is in "copying" status.
//
// For more information on copying encrypted DB cluster snapshots from one AWS
// Region to another, see Copying a Snapshot (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html)
// in the Amazon Aurora User Guide.
//
// For more information on Amazon Aurora, see What Is Amazon Aurora? (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
// in the Amazon Aurora User Guide.
//
// This action only applies to Aurora DB clusters.
//
//    // Example sending a request using CopyDBClusterSnapshotRequest.
//    req := client.CopyDBClusterSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot
func (c *Client) CopyDBClusterSnapshotRequest(input *CopyDBClusterSnapshotInput) CopyDBClusterSnapshotRequest {
	op := &aws.Operation{
		Name:       opCopyDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBClusterSnapshotInput{}
	}

	req := c.newRequest(op, input, &CopyDBClusterSnapshotOutput{})
	return CopyDBClusterSnapshotRequest{Request: req, Input: input, Copy: c.CopyDBClusterSnapshotRequest}
}

// CopyDBClusterSnapshotRequest is the request type for the
// CopyDBClusterSnapshot API operation.
type CopyDBClusterSnapshotRequest struct {
	*aws.Request
	Input *CopyDBClusterSnapshotInput
	Copy  func(*CopyDBClusterSnapshotInput) CopyDBClusterSnapshotRequest
}

// Send marshals and sends the CopyDBClusterSnapshot API request.
func (r CopyDBClusterSnapshotRequest) Send(ctx context.Context) (*CopyDBClusterSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CopyDBClusterSnapshotResponse{
		CopyDBClusterSnapshotOutput: r.Request.Data.(*CopyDBClusterSnapshotOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CopyDBClusterSnapshotResponse is the response type for the
// CopyDBClusterSnapshot API operation.
type CopyDBClusterSnapshotResponse struct {
	*CopyDBClusterSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CopyDBClusterSnapshot request.
func (r *CopyDBClusterSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
