// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteMonitoringScheduleInput struct {
	_ struct{} `type:"structure"`

	// The name of the monitoring schedule to delete.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMonitoringScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMonitoringScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMonitoringScheduleInput"}

	if s.MonitoringScheduleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringScheduleName"))
	}
	if s.MonitoringScheduleName != nil && len(*s.MonitoringScheduleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MonitoringScheduleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteMonitoringScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMonitoringScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteMonitoringSchedule = "DeleteMonitoringSchedule"

// DeleteMonitoringScheduleRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Deletes a monitoring schedule. Also stops the schedule had not already been
// stopped. This does not delete the job execution history of the monitoring
// schedule.
//
//    // Example sending a request using DeleteMonitoringScheduleRequest.
//    req := client.DeleteMonitoringScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule
func (c *Client) DeleteMonitoringScheduleRequest(input *DeleteMonitoringScheduleInput) DeleteMonitoringScheduleRequest {
	op := &aws.Operation{
		Name:       opDeleteMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMonitoringScheduleInput{}
	}

	req := c.newRequest(op, input, &DeleteMonitoringScheduleOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteMonitoringScheduleRequest{Request: req, Input: input, Copy: c.DeleteMonitoringScheduleRequest}
}

// DeleteMonitoringScheduleRequest is the request type for the
// DeleteMonitoringSchedule API operation.
type DeleteMonitoringScheduleRequest struct {
	*aws.Request
	Input *DeleteMonitoringScheduleInput
	Copy  func(*DeleteMonitoringScheduleInput) DeleteMonitoringScheduleRequest
}

// Send marshals and sends the DeleteMonitoringSchedule API request.
func (r DeleteMonitoringScheduleRequest) Send(ctx context.Context) (*DeleteMonitoringScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMonitoringScheduleResponse{
		DeleteMonitoringScheduleOutput: r.Request.Data.(*DeleteMonitoringScheduleOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMonitoringScheduleResponse is the response type for the
// DeleteMonitoringSchedule API operation.
type DeleteMonitoringScheduleResponse struct {
	*DeleteMonitoringScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMonitoringSchedule request.
func (r *DeleteMonitoringScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
