// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RenderUiTemplateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that has access to the S3 objects that are
	// used by the template.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// A RenderableTask object containing a representative task to render.
	//
	// Task is a required field
	Task *RenderableTask `type:"structure" required:"true"`

	// A Template object containing the worker UI template to render.
	//
	// UiTemplate is a required field
	UiTemplate *UiTemplate `type:"structure" required:"true"`
}

// String returns the string representation
func (s RenderUiTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenderUiTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RenderUiTemplateInput"}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if s.Task == nil {
		invalidParams.Add(aws.NewErrParamRequired("Task"))
	}

	if s.UiTemplate == nil {
		invalidParams.Add(aws.NewErrParamRequired("UiTemplate"))
	}
	if s.Task != nil {
		if err := s.Task.Validate(); err != nil {
			invalidParams.AddNested("Task", err.(aws.ErrInvalidParams))
		}
	}
	if s.UiTemplate != nil {
		if err := s.UiTemplate.Validate(); err != nil {
			invalidParams.AddNested("UiTemplate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RenderUiTemplateOutput struct {
	_ struct{} `type:"structure"`

	// A list of one or more RenderingError objects if any were encountered while
	// rendering the template. If there were no errors, the list is empty.
	//
	// Errors is a required field
	Errors []RenderingError `type:"list" required:"true"`

	// A Liquid template that renders the HTML for the worker UI.
	//
	// RenderedContent is a required field
	RenderedContent *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RenderUiTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opRenderUiTemplate = "RenderUiTemplate"

// RenderUiTemplateRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Renders the UI template so that you can preview the worker's experience.
//
//    // Example sending a request using RenderUiTemplateRequest.
//    req := client.RenderUiTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderUiTemplate
func (c *Client) RenderUiTemplateRequest(input *RenderUiTemplateInput) RenderUiTemplateRequest {
	op := &aws.Operation{
		Name:       opRenderUiTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RenderUiTemplateInput{}
	}

	req := c.newRequest(op, input, &RenderUiTemplateOutput{})
	return RenderUiTemplateRequest{Request: req, Input: input, Copy: c.RenderUiTemplateRequest}
}

// RenderUiTemplateRequest is the request type for the
// RenderUiTemplate API operation.
type RenderUiTemplateRequest struct {
	*aws.Request
	Input *RenderUiTemplateInput
	Copy  func(*RenderUiTemplateInput) RenderUiTemplateRequest
}

// Send marshals and sends the RenderUiTemplate API request.
func (r RenderUiTemplateRequest) Send(ctx context.Context) (*RenderUiTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RenderUiTemplateResponse{
		RenderUiTemplateOutput: r.Request.Data.(*RenderUiTemplateOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RenderUiTemplateResponse is the response type for the
// RenderUiTemplate API operation.
type RenderUiTemplateResponse struct {
	*RenderUiTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RenderUiTemplate request.
func (r *RenderUiTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
