// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ScanProvisionedProductsInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The access level to use to obtain results. The default is User.
	AccessLevelFilter *AccessLevelFilter `type:"structure"`

	// The maximum number of items to return with this call.
	PageSize *int64 `type:"integer"`

	// The page token for the next set of results. To retrieve the first set of
	// results, use null.
	PageToken *string `type:"string"`
}

// String returns the string representation
func (s ScanProvisionedProductsInput) String() string {
	return awsutil.Prettify(s)
}

type ScanProvisionedProductsOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string `type:"string"`

	// Information about the provisioned products.
	ProvisionedProducts []ProvisionedProductDetail `type:"list"`
}

// String returns the string representation
func (s ScanProvisionedProductsOutput) String() string {
	return awsutil.Prettify(s)
}

const opScanProvisionedProducts = "ScanProvisionedProducts"

// ScanProvisionedProductsRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Lists the provisioned products that are available (not terminated).
//
// To use additional filtering, see SearchProvisionedProducts.
//
//    // Example sending a request using ScanProvisionedProductsRequest.
//    req := client.ScanProvisionedProductsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ScanProvisionedProducts
func (c *Client) ScanProvisionedProductsRequest(input *ScanProvisionedProductsInput) ScanProvisionedProductsRequest {
	op := &aws.Operation{
		Name:       opScanProvisionedProducts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScanProvisionedProductsInput{}
	}

	req := c.newRequest(op, input, &ScanProvisionedProductsOutput{})
	return ScanProvisionedProductsRequest{Request: req, Input: input, Copy: c.ScanProvisionedProductsRequest}
}

// ScanProvisionedProductsRequest is the request type for the
// ScanProvisionedProducts API operation.
type ScanProvisionedProductsRequest struct {
	*aws.Request
	Input *ScanProvisionedProductsInput
	Copy  func(*ScanProvisionedProductsInput) ScanProvisionedProductsRequest
}

// Send marshals and sends the ScanProvisionedProducts API request.
func (r ScanProvisionedProductsRequest) Send(ctx context.Context) (*ScanProvisionedProductsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ScanProvisionedProductsResponse{
		ScanProvisionedProductsOutput: r.Request.Data.(*ScanProvisionedProductsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ScanProvisionedProductsResponse is the response type for the
// ScanProvisionedProducts API operation.
type ScanProvisionedProductsResponse struct {
	*ScanProvisionedProductsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ScanProvisionedProducts request.
func (r *ScanProvisionedProductsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
