// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sqs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type TagQueueInput struct {
	_ struct{} `type:"structure"`

	// The URL of the queue.
	//
	// QueueUrl is a required field
	QueueUrl *string `type:"string" required:"true"`

	// The list of tags to be added to the specified queue.
	//
	// Tags is a required field
	Tags map[string]string `locationName:"Tag" locationNameKey:"Key" locationNameValue:"Value" type:"map" flattened:"true" required:"true"`
}

// String returns the string representation
func (s TagQueueInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagQueueInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TagQueueInput"}

	if s.QueueUrl == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueueUrl"))
	}

	if s.Tags == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type TagQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagQueueOutput) String() string {
	return awsutil.Prettify(s)
}

const opTagQueue = "TagQueue"

// TagQueueRequest returns a request value for making API operation for
// Amazon Simple Queue Service.
//
// Add cost allocation tags to the specified Amazon SQS queue. For an overview,
// see Tagging Your Amazon SQS Queues (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html)
// in the Amazon Simple Queue Service Developer Guide.
//
// When you use queue tags, keep the following guidelines in mind:
//
//    * Adding more than 50 tags to a queue isn't recommended.
//
//    * Tags don't have any semantic meaning. Amazon SQS interprets tags as
//    character strings.
//
//    * Tags are case-sensitive.
//
//    * A new tag with a key identical to that of an existing tag overwrites
//    the existing tag.
//
// For a full list of tag restrictions, see Limits Related to Queues (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-limits.html#limits-queues)
// in the Amazon Simple Queue Service Developer Guide.
//
// Cross-account permissions don't apply to this action. For more information,
// see Grant Cross-Account Permissions to a Role and a User Name (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name)
// in the Amazon Simple Queue Service Developer Guide.
//
//    // Example sending a request using TagQueueRequest.
//    req := client.TagQueueRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sqs-2012-11-05/TagQueue
func (c *Client) TagQueueRequest(input *TagQueueInput) TagQueueRequest {
	op := &aws.Operation{
		Name:       opTagQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagQueueInput{}
	}

	req := c.newRequest(op, input, &TagQueueOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return TagQueueRequest{Request: req, Input: input, Copy: c.TagQueueRequest}
}

// TagQueueRequest is the request type for the
// TagQueue API operation.
type TagQueueRequest struct {
	*aws.Request
	Input *TagQueueInput
	Copy  func(*TagQueueInput) TagQueueRequest
}

// Send marshals and sends the TagQueue API request.
func (r TagQueueRequest) Send(ctx context.Context) (*TagQueueResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TagQueueResponse{
		TagQueueOutput: r.Request.Data.(*TagQueueOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TagQueueResponse is the response type for the
// TagQueue API operation.
type TagQueueResponse struct {
	*TagQueueOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TagQueue request.
func (r *TagQueueResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
