# Changelog

- June 1, 2016 - **Breaking Change!**
  - [#172](https://github.com/sourcegraph/appdash/pull/171) Fixed `appdash serve` (assets were not served properly).
  - [#172](https://github.com/sourcegraph/appdash/pull/171) Removes display/serving of Dashboard page except when using InfluxDBStore (not the default).
  - [#172](https://github.com/sourcegraph/appdash/pull/171) Move InfluxDBStore into experimental subpackage.
  - [#172](https://github.com/sourcegraph/appdash/pull/171) We no longer incorrectly vendor libraries (we're a library, see #163).
- May 26, 2016 - **Action Required!**
  - [#171](https://github.com/sourcegraph/appdash/pull/171) Fixed an index out of bounds panic when viewing the /traces page.
  - [#171](https://github.com/sourcegraph/appdash/pull/171) InfluxDBStore uses a less memory intensive DB schema (users will need to `rm -rf ~/.influxdb` to remove the old DB).
  - [#171](https://github.com/sourcegraph/appdash/pull/171) InfluxDBStore now uses InfluxDB client v2.
- Apr 29, 2016 - **Breaking Change!**
  - [#162](https://github.com/sourcegraph/appdash/pull/162) `traceapp.New` now requires a base URL parameter for compatability with HTTPS in trace permalinks.
- Apr 26, 2016
  - [#153](https://github.com/sourcegraph/appdash/pull/153) Added a Recorder.Logger field which, when non-nil, causes errors to be logged instead of checked explicitly via the Errors method.
  - [#154](https://github.com/sourcegraph/appdash/pull/154) Added trace permalinks which encode the trace within the URL.
  - [#155](https://github.com/sourcegraph/appdash/pull/155) Cleaned up InfluxDBStore configuration by adding sane defaults.
  - [#156](https://github.com/sourcegraph/appdash/pull/156) Fixed an index out of bounds panic on the Dashboard.
  - [#157](https://github.com/sourcegraph/appdash/pull/157) Added proper point-batching support to InfluxDBStore.
  - [#157](https://github.com/sourcegraph/appdash/pull/157) Changed `ChunkedCollector.FlushTimeout` default from 50ms to 2s.
  - [#158](https://github.com/sourcegraph/appdash/pull/158) Made InfluxDBStore use Continuous Queries so the Dashboard is very responsive.
  - [#159](https://github.com/sourcegraph/appdash/pull/159) InfluxDBStore no longer uses the deprecated `IF NOT EXISTS` condition when creating the DB.
- Apr 15, 2016 - **Breaking Changes!**
  - [#136](https://github.com/sourcegraph/appdash/pull/136) Users must now call `Recorder.Finish` when finished recording, or else data    will not be collected.
  - [#136](https://github.com/sourcegraph/appdash/pull/136) AggregateStore is removed in favor of InfluxDBStore, which is also embeddable, and is generally faster and more reliable. Refer to the [cmd/webapp-influxdb](https://github.com/sourcegraph/appdash/blob/master/examples/cmd/webapp-influxdb/main.go#L50) for further information on how to migrate to `InfluxDBStore`, or [read more about why this change was made](https://github.com/sourcegraph/appdash/issues/137).
  - [#136](https://github.com/sourcegraph/appdash/issues/136) `AggregateEvent`, `Trace.IsAggregate` and `Trace.Aggregated` are removed.
- Mar 28, 2016
  - [#110](https://github.com/sourcegraph/appdash/pull/110) Added support for the [OpenTracing API](http://opentracing.io/).
- Mar 9 2016
  - [#99](https://github.com/sourcegraph/appdash/pull/99) Added an embeddable InfluxDB storage engine.
