// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input of an update default branch operation.
type UpdateDefaultBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the branch to set as the default.
	//
	// DefaultBranchName is a required field
	DefaultBranchName *string `locationName:"defaultBranchName" min:"1" type:"string" required:"true"`

	// The name of the repository to set or change the default branch for.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDefaultBranchInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDefaultBranchInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDefaultBranchInput"}

	if s.DefaultBranchName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DefaultBranchName"))
	}
	if s.DefaultBranchName != nil && len(*s.DefaultBranchName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DefaultBranchName", 1))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateDefaultBranchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDefaultBranchOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDefaultBranch = "UpdateDefaultBranch"

// UpdateDefaultBranchRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Sets or changes the default branch name for the specified repository.
//
// If you use this operation to change the default branch name to the current
// default branch name, a success message is returned even though the default
// branch did not change.
//
//    // Example sending a request using UpdateDefaultBranchRequest.
//    req := client.UpdateDefaultBranchRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranch
func (c *Client) UpdateDefaultBranchRequest(input *UpdateDefaultBranchInput) UpdateDefaultBranchRequest {
	op := &aws.Operation{
		Name:       opUpdateDefaultBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDefaultBranchInput{}
	}

	req := c.newRequest(op, input, &UpdateDefaultBranchOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateDefaultBranchRequest{Request: req, Input: input, Copy: c.UpdateDefaultBranchRequest}
}

// UpdateDefaultBranchRequest is the request type for the
// UpdateDefaultBranch API operation.
type UpdateDefaultBranchRequest struct {
	*aws.Request
	Input *UpdateDefaultBranchInput
	Copy  func(*UpdateDefaultBranchInput) UpdateDefaultBranchRequest
}

// Send marshals and sends the UpdateDefaultBranch API request.
func (r UpdateDefaultBranchRequest) Send(ctx context.Context) (*UpdateDefaultBranchResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDefaultBranchResponse{
		UpdateDefaultBranchOutput: r.Request.Data.(*UpdateDefaultBranchOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDefaultBranchResponse is the response type for the
// UpdateDefaultBranch API operation.
type UpdateDefaultBranchResponse struct {
	*UpdateDefaultBranchOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDefaultBranch request.
func (r *UpdateDefaultBranchResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
