// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDeploymentTargetInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The unique ID of a deployment target.
	TargetId *string `locationName:"targetId" type:"string"`
}

// String returns the string representation
func (s GetDeploymentTargetInput) String() string {
	return awsutil.Prettify(s)
}

type GetDeploymentTargetOutput struct {
	_ struct{} `type:"structure"`

	// A deployment target that contains information about a deployment such as
	// its status, lifecyle events, and when it was last updated. It also contains
	// metadata about the deployment target. The deployment target metadata depends
	// on the deployment target's type (instanceTarget, lambdaTarget, or ecsTarget).
	DeploymentTarget *DeploymentTarget `locationName:"deploymentTarget" type:"structure"`
}

// String returns the string representation
func (s GetDeploymentTargetOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDeploymentTarget = "GetDeploymentTarget"

// GetDeploymentTargetRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Returns information about a deployment target.
//
//    // Example sending a request using GetDeploymentTargetRequest.
//    req := client.GetDeploymentTargetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentTarget
func (c *Client) GetDeploymentTargetRequest(input *GetDeploymentTargetInput) GetDeploymentTargetRequest {
	op := &aws.Operation{
		Name:       opGetDeploymentTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentTargetInput{}
	}

	req := c.newRequest(op, input, &GetDeploymentTargetOutput{})
	return GetDeploymentTargetRequest{Request: req, Input: input, Copy: c.GetDeploymentTargetRequest}
}

// GetDeploymentTargetRequest is the request type for the
// GetDeploymentTarget API operation.
type GetDeploymentTargetRequest struct {
	*aws.Request
	Input *GetDeploymentTargetInput
	Copy  func(*GetDeploymentTargetInput) GetDeploymentTargetRequest
}

// Send marshals and sends the GetDeploymentTarget API request.
func (r GetDeploymentTargetRequest) Send(ctx context.Context) (*GetDeploymentTargetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDeploymentTargetResponse{
		GetDeploymentTargetOutput: r.Request.Data.(*GetDeploymentTargetOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDeploymentTargetResponse is the response type for the
// GetDeploymentTarget API operation.
type GetDeploymentTargetResponse struct {
	*GetDeploymentTargetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDeploymentTarget request.
func (r *GetDeploymentTargetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
