// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CopySnapshotInput struct {
	_ struct{} `type:"structure"`

	// A description for the EBS snapshot.
	Description *string `type:"string"`

	// The destination Region to use in the PresignedUrl parameter of a snapshot
	// copy operation. This parameter is only valid for specifying the destination
	// Region in a PresignedUrl parameter, where it is required.
	//
	// The snapshot copy is sent to the regional endpoint that you sent the HTTP
	// request to (for example, ec2.us-east-1.amazonaws.com). With the AWS CLI,
	// this is specified using the --region parameter or the default Region in your
	// AWS configuration file.
	DestinationRegion *string `locationName:"destinationRegion" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// To encrypt a copy of an unencrypted snapshot if encryption by default is
	// not enabled, enable encryption using this parameter. Otherwise, omit this
	// parameter. Encrypted snapshots are encrypted, even if you omit this parameter
	// and encryption by default is not enabled. You cannot set this parameter to
	// false. For more information, see Amazon EBS Encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The identifier of the AWS Key Management Service (AWS KMS) customer master
	// key (CMK) to use for Amazon EBS encryption. If this parameter is not specified,
	// your AWS managed CMK for EBS is used. If KmsKeyId is specified, the encrypted
	// state must be true.
	//
	// You can specify the CMK using any of the following:
	//
	//    * Key ID. For example, key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	//    * Key alias. For example, alias/ExampleAlias.
	//
	//    * Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.
	//
	//    * Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
	//
	// AWS authenticates the CMK asynchronously. Therefore, if you specify an ID,
	// alias, or ARN that is not valid, the action can appear to complete, but eventually
	// fails.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// When you copy an encrypted source snapshot using the Amazon EC2 Query API,
	// you must supply a pre-signed URL. This parameter is optional for unencrypted
	// snapshots. For more information, see Query Requests (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html).
	//
	// The PresignedUrl should use the snapshot source endpoint, the CopySnapshot
	// action, and include the SourceRegion, SourceSnapshotId, and DestinationRegion
	// parameters. The PresignedUrl must be signed using AWS Signature Version 4.
	// Because EBS snapshots are stored in Amazon S3, the signing algorithm for
	// this parameter uses the same logic that is described in Authenticating Requests
	// by Using Query Parameters (AWS Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// in the Amazon Simple Storage Service API Reference. An invalid or improperly
	// signed PresignedUrl will cause the copy operation to fail asynchronously,
	// and the snapshot will move to an error state.
	PresignedUrl *string `locationName:"presignedUrl" type:"string"`

	// The ID of the Region that contains the snapshot to be copied.
	//
	// SourceRegion is a required field
	SourceRegion *string `type:"string" required:"true"`

	// The ID of the EBS snapshot to copy.
	//
	// SourceSnapshotId is a required field
	SourceSnapshotId *string `type:"string" required:"true"`

	// The tags to apply to the new snapshot.
	TagSpecifications []TagSpecification `locationName:"TagSpecification" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CopySnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopySnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CopySnapshotInput"}

	if s.SourceRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceRegion"))
	}

	if s.SourceSnapshotId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceSnapshotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CopySnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the new snapshot.
	SnapshotId *string `locationName:"snapshotId" type:"string"`

	// Any tags applied to the new snapshot.
	Tags []Tag `locationName:"tagSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s CopySnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opCopySnapshot = "CopySnapshot"

// CopySnapshotRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
// S3. You can copy the snapshot within the same Region or from one Region to
// another. You can use the snapshot to create EBS volumes or Amazon Machine
// Images (AMIs).
//
// Copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
// snapshots remain unencrypted, unless you enable encryption for the snapshot
// copy operation. By default, encrypted snapshot copies use the default AWS
// Key Management Service (AWS KMS) customer master key (CMK); however, you
// can specify a different CMK.
//
// To copy an encrypted snapshot that has been shared from another account,
// you must have permissions for the CMK used to encrypt the snapshot.
//
// Snapshots created by copying another snapshot have an arbitrary volume ID
// that should not be used for any purpose.
//
// For more information, see Copying an Amazon EBS Snapshot (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using CopySnapshotRequest.
//    req := client.CopySnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot
func (c *Client) CopySnapshotRequest(input *CopySnapshotInput) CopySnapshotRequest {
	op := &aws.Operation{
		Name:       opCopySnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopySnapshotInput{}
	}

	req := c.newRequest(op, input, &CopySnapshotOutput{})
	return CopySnapshotRequest{Request: req, Input: input, Copy: c.CopySnapshotRequest}
}

// CopySnapshotRequest is the request type for the
// CopySnapshot API operation.
type CopySnapshotRequest struct {
	*aws.Request
	Input *CopySnapshotInput
	Copy  func(*CopySnapshotInput) CopySnapshotRequest
}

// Send marshals and sends the CopySnapshot API request.
func (r CopySnapshotRequest) Send(ctx context.Context) (*CopySnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CopySnapshotResponse{
		CopySnapshotOutput: r.Request.Data.(*CopySnapshotOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CopySnapshotResponse is the response type for the
// CopySnapshot API operation.
type CopySnapshotResponse struct {
	*CopySnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CopySnapshot request.
func (r *CopySnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
