// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeFargateProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster associated with the Fargate profile.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile to describe.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `location:"uri" locationName:"fargateProfileName" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFargateProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeFargateProfileInput"}

	if s.ClusterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterName"))
	}

	if s.FargateProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FargateProfileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeFargateProfileInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ClusterName != nil {
		v := *s.ClusterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FargateProfileName != nil {
		v := *s.FargateProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "fargateProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation
func (s DescribeFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeFargateProfileOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FargateProfile != nil {
		v := s.FargateProfile

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "fargateProfile", v, metadata)
	}
	return nil
}

const opDescribeFargateProfile = "DescribeFargateProfile"

// DescribeFargateProfileRequest returns a request value for making API operation for
// Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an AWS Fargate profile.
//
//    // Example sending a request using DescribeFargateProfileRequest.
//    req := client.DescribeFargateProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeFargateProfile
func (c *Client) DescribeFargateProfileRequest(input *DescribeFargateProfileInput) DescribeFargateProfileRequest {
	op := &aws.Operation{
		Name:       opDescribeFargateProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/fargate-profiles/{fargateProfileName}",
	}

	if input == nil {
		input = &DescribeFargateProfileInput{}
	}

	req := c.newRequest(op, input, &DescribeFargateProfileOutput{})
	return DescribeFargateProfileRequest{Request: req, Input: input, Copy: c.DescribeFargateProfileRequest}
}

// DescribeFargateProfileRequest is the request type for the
// DescribeFargateProfile API operation.
type DescribeFargateProfileRequest struct {
	*aws.Request
	Input *DescribeFargateProfileInput
	Copy  func(*DescribeFargateProfileInput) DescribeFargateProfileRequest
}

// Send marshals and sends the DescribeFargateProfile API request.
func (r DescribeFargateProfileRequest) Send(ctx context.Context) (*DescribeFargateProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeFargateProfileResponse{
		DescribeFargateProfileOutput: r.Request.Data.(*DescribeFargateProfileOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeFargateProfileResponse is the response type for the
// DescribeFargateProfile API operation.
type DescribeFargateProfileResponse struct {
	*DescribeFargateProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeFargateProfile request.
func (r *DescribeFargateProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
