// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request to list an environment's upcoming and in-progress managed actions.
type DescribeEnvironmentManagedActionsInput struct {
	_ struct{} `type:"structure"`

	// The environment ID of the target environment.
	EnvironmentId *string `type:"string"`

	// The name of the target environment.
	EnvironmentName *string `type:"string"`

	// To show only actions with a particular status, specify a status.
	Status ActionStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeEnvironmentManagedActionsInput) String() string {
	return awsutil.Prettify(s)
}

// The result message containing a list of managed actions.
type DescribeEnvironmentManagedActionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of upcoming and in-progress managed actions.
	ManagedActions []ManagedAction `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeEnvironmentManagedActionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEnvironmentManagedActions = "DescribeEnvironmentManagedActions"

// DescribeEnvironmentManagedActionsRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Lists an environment's upcoming and in-progress managed actions.
//
//    // Example sending a request using DescribeEnvironmentManagedActionsRequest.
//    req := client.DescribeEnvironmentManagedActionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/DescribeEnvironmentManagedActions
func (c *Client) DescribeEnvironmentManagedActionsRequest(input *DescribeEnvironmentManagedActionsInput) DescribeEnvironmentManagedActionsRequest {
	op := &aws.Operation{
		Name:       opDescribeEnvironmentManagedActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentManagedActionsInput{}
	}

	req := c.newRequest(op, input, &DescribeEnvironmentManagedActionsOutput{})
	return DescribeEnvironmentManagedActionsRequest{Request: req, Input: input, Copy: c.DescribeEnvironmentManagedActionsRequest}
}

// DescribeEnvironmentManagedActionsRequest is the request type for the
// DescribeEnvironmentManagedActions API operation.
type DescribeEnvironmentManagedActionsRequest struct {
	*aws.Request
	Input *DescribeEnvironmentManagedActionsInput
	Copy  func(*DescribeEnvironmentManagedActionsInput) DescribeEnvironmentManagedActionsRequest
}

// Send marshals and sends the DescribeEnvironmentManagedActions API request.
func (r DescribeEnvironmentManagedActionsRequest) Send(ctx context.Context) (*DescribeEnvironmentManagedActionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEnvironmentManagedActionsResponse{
		DescribeEnvironmentManagedActionsOutput: r.Request.Data.(*DescribeEnvironmentManagedActionsOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeEnvironmentManagedActionsResponse is the response type for the
// DescribeEnvironmentManagedActions API operation.
type DescribeEnvironmentManagedActionsResponse struct {
	*DescribeEnvironmentManagedActionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEnvironmentManagedActions request.
func (r *DescribeEnvironmentManagedActionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
