// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeletePublishingDestinationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the publishing destination to delete.
	//
	// DestinationId is a required field
	DestinationId *string `location:"uri" locationName:"destinationId" type:"string" required:"true"`

	// The unique ID of the detector associated with the publishing destination
	// to delete.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePublishingDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublishingDestinationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePublishingDestinationInput"}

	if s.DestinationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationId"))
	}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePublishingDestinationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DestinationId != nil {
		v := *s.DestinationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "destinationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeletePublishingDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePublishingDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePublishingDestinationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeletePublishingDestination = "DeletePublishingDestination"

// DeletePublishingDestinationRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Deletes the publishing definition with the specified destinationId.
//
//    // Example sending a request using DeletePublishingDestinationRequest.
//    req := client.DeletePublishingDestinationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeletePublishingDestination
func (c *Client) DeletePublishingDestinationRequest(input *DeletePublishingDestinationInput) DeletePublishingDestinationRequest {
	op := &aws.Operation{
		Name:       opDeletePublishingDestination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}/publishingDestination/{destinationId}",
	}

	if input == nil {
		input = &DeletePublishingDestinationInput{}
	}

	req := c.newRequest(op, input, &DeletePublishingDestinationOutput{})
	return DeletePublishingDestinationRequest{Request: req, Input: input, Copy: c.DeletePublishingDestinationRequest}
}

// DeletePublishingDestinationRequest is the request type for the
// DeletePublishingDestination API operation.
type DeletePublishingDestinationRequest struct {
	*aws.Request
	Input *DeletePublishingDestinationInput
	Copy  func(*DeletePublishingDestinationInput) DeletePublishingDestinationRequest
}

// Send marshals and sends the DeletePublishingDestination API request.
func (r DeletePublishingDestinationRequest) Send(ctx context.Context) (*DeletePublishingDestinationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePublishingDestinationResponse{
		DeletePublishingDestinationOutput: r.Request.Data.(*DeletePublishingDestinationOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePublishingDestinationResponse is the response type for the
// DeletePublishingDestination API operation.
type DeletePublishingDestinationResponse struct {
	*DeletePublishingDestinationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePublishingDestination request.
func (r *DeletePublishingDestinationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
