// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteFunctionConcurrencyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFunctionConcurrencyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionConcurrencyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFunctionConcurrencyInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFunctionConcurrencyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteFunctionConcurrencyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionConcurrencyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFunctionConcurrencyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteFunctionConcurrency = "DeleteFunctionConcurrency"

// DeleteFunctionConcurrencyRequest returns a request value for making API operation for
// AWS Lambda.
//
// Removes a concurrent execution limit from a function.
//
//    // Example sending a request using DeleteFunctionConcurrencyRequest.
//    req := client.DeleteFunctionConcurrencyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency
func (c *Client) DeleteFunctionConcurrencyRequest(input *DeleteFunctionConcurrencyInput) DeleteFunctionConcurrencyRequest {
	op := &aws.Operation{
		Name:       opDeleteFunctionConcurrency,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2017-10-31/functions/{FunctionName}/concurrency",
	}

	if input == nil {
		input = &DeleteFunctionConcurrencyInput{}
	}

	req := c.newRequest(op, input, &DeleteFunctionConcurrencyOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteFunctionConcurrencyRequest{Request: req, Input: input, Copy: c.DeleteFunctionConcurrencyRequest}
}

// DeleteFunctionConcurrencyRequest is the request type for the
// DeleteFunctionConcurrency API operation.
type DeleteFunctionConcurrencyRequest struct {
	*aws.Request
	Input *DeleteFunctionConcurrencyInput
	Copy  func(*DeleteFunctionConcurrencyInput) DeleteFunctionConcurrencyRequest
}

// Send marshals and sends the DeleteFunctionConcurrency API request.
func (r DeleteFunctionConcurrencyRequest) Send(ctx context.Context) (*DeleteFunctionConcurrencyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFunctionConcurrencyResponse{
		DeleteFunctionConcurrencyOutput: r.Request.Data.(*DeleteFunctionConcurrencyOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFunctionConcurrencyResponse is the response type for the
// DeleteFunctionConcurrency API operation.
type DeleteFunctionConcurrencyResponse struct {
	*DeleteFunctionConcurrencyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFunctionConcurrency request.
func (r *DeleteFunctionConcurrencyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
