// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain name for which your want to return information about.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDomainInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetDomainOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your get domain
	// request.
	Domain *Domain `locationName:"domain" type:"structure"`
}

// String returns the string representation
func (s GetDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDomain = "GetDomain"

// GetDomainRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about a specific domain recordset.
//
//    // Example sending a request using GetDomainRequest.
//    req := client.GetDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain
func (c *Client) GetDomainRequest(input *GetDomainInput) GetDomainRequest {
	op := &aws.Operation{
		Name:       opGetDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainInput{}
	}

	req := c.newRequest(op, input, &GetDomainOutput{})
	return GetDomainRequest{Request: req, Input: input, Copy: c.GetDomainRequest}
}

// GetDomainRequest is the request type for the
// GetDomain API operation.
type GetDomainRequest struct {
	*aws.Request
	Input *GetDomainInput
	Copy  func(*GetDomainInput) GetDomainRequest
}

// Send marshals and sends the GetDomain API request.
func (r GetDomainRequest) Send(ctx context.Context) (*GetDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDomainResponse{
		GetDomainOutput: r.Request.Data.(*GetDomainOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDomainResponse is the response type for the
// GetDomain API operation.
type GetDomainResponse struct {
	*GetDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDomain request.
func (r *GetDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
