// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateS3ResourcesInput struct {
	_ struct{} `type:"structure"`

	// The S3 resources (buckets or prefixes) that you want to remove from being
	// monitored and classified by Amazon Macie.
	//
	// AssociatedS3Resources is a required field
	AssociatedS3Resources []S3Resource `locationName:"associatedS3Resources" type:"list" required:"true"`

	// The ID of the Amazon Macie member account whose resources you want to remove
	// from being monitored by Amazon Macie.
	MemberAccountId *string `locationName:"memberAccountId" type:"string"`
}

// String returns the string representation
func (s DisassociateS3ResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateS3ResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateS3ResourcesInput"}

	if s.AssociatedS3Resources == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssociatedS3Resources"))
	}
	if s.AssociatedS3Resources != nil {
		for i, v := range s.AssociatedS3Resources {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssociatedS3Resources", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateS3ResourcesOutput struct {
	_ struct{} `type:"structure"`

	// S3 resources that couldn't be removed from being monitored and classified
	// by Amazon Macie. An error code and an error message are provided for each
	// failed item.
	FailedS3Resources []FailedS3Resource `locationName:"failedS3Resources" type:"list"`
}

// String returns the string representation
func (s DisassociateS3ResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateS3Resources = "DisassociateS3Resources"

// DisassociateS3ResourcesRequest returns a request value for making API operation for
// Amazon Macie.
//
// Removes specified S3 resources from being monitored by Amazon Macie. If memberAccountId
// isn't specified, the action removes specified S3 resources from Macie for
// the current master account. If memberAccountId is specified, the action removes
// specified S3 resources from Macie for the specified member account.
//
//    // Example sending a request using DisassociateS3ResourcesRequest.
//    req := client.DisassociateS3ResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/DisassociateS3Resources
func (c *Client) DisassociateS3ResourcesRequest(input *DisassociateS3ResourcesInput) DisassociateS3ResourcesRequest {
	op := &aws.Operation{
		Name:       opDisassociateS3Resources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateS3ResourcesInput{}
	}

	req := c.newRequest(op, input, &DisassociateS3ResourcesOutput{})
	return DisassociateS3ResourcesRequest{Request: req, Input: input, Copy: c.DisassociateS3ResourcesRequest}
}

// DisassociateS3ResourcesRequest is the request type for the
// DisassociateS3Resources API operation.
type DisassociateS3ResourcesRequest struct {
	*aws.Request
	Input *DisassociateS3ResourcesInput
	Copy  func(*DisassociateS3ResourcesInput) DisassociateS3ResourcesRequest
}

// Send marshals and sends the DisassociateS3Resources API request.
func (r DisassociateS3ResourcesRequest) Send(ctx context.Context) (*DisassociateS3ResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateS3ResourcesResponse{
		DisassociateS3ResourcesOutput: r.Request.Data.(*DisassociateS3ResourcesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateS3ResourcesResponse is the response type for the
// DisassociateS3Resources API operation.
type DisassociateS3ResourcesResponse struct {
	*DisassociateS3ResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateS3Resources request.
func (r *DisassociateS3ResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
