// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteCustomAvailabilityZoneInput struct {
	_ struct{} `type:"structure"`

	// The custom AZ identifier.
	//
	// CustomAvailabilityZoneId is a required field
	CustomAvailabilityZoneId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCustomAvailabilityZoneInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomAvailabilityZoneInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCustomAvailabilityZoneInput"}

	if s.CustomAvailabilityZoneId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CustomAvailabilityZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteCustomAvailabilityZoneOutput struct {
	_ struct{} `type:"structure"`

	// A custom Availability Zone (AZ) is an on-premises AZ that is integrated with
	// a VMware vSphere cluster.
	//
	// For more information about RDS on VMware, see the RDS on VMware User Guide.
	// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
	CustomAvailabilityZone *CustomAvailabilityZone `type:"structure"`
}

// String returns the string representation
func (s DeleteCustomAvailabilityZoneOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteCustomAvailabilityZone = "DeleteCustomAvailabilityZone"

// DeleteCustomAvailabilityZoneRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Deletes a custom Availability Zone (AZ).
//
// A custom AZ is an on-premises AZ that is integrated with a VMware vSphere
// cluster.
//
// For more information about RDS on VMware, see the RDS on VMware User Guide.
// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
//
//    // Example sending a request using DeleteCustomAvailabilityZoneRequest.
//    req := client.DeleteCustomAvailabilityZoneRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomAvailabilityZone
func (c *Client) DeleteCustomAvailabilityZoneRequest(input *DeleteCustomAvailabilityZoneInput) DeleteCustomAvailabilityZoneRequest {
	op := &aws.Operation{
		Name:       opDeleteCustomAvailabilityZone,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomAvailabilityZoneInput{}
	}

	req := c.newRequest(op, input, &DeleteCustomAvailabilityZoneOutput{})
	return DeleteCustomAvailabilityZoneRequest{Request: req, Input: input, Copy: c.DeleteCustomAvailabilityZoneRequest}
}

// DeleteCustomAvailabilityZoneRequest is the request type for the
// DeleteCustomAvailabilityZone API operation.
type DeleteCustomAvailabilityZoneRequest struct {
	*aws.Request
	Input *DeleteCustomAvailabilityZoneInput
	Copy  func(*DeleteCustomAvailabilityZoneInput) DeleteCustomAvailabilityZoneRequest
}

// Send marshals and sends the DeleteCustomAvailabilityZone API request.
func (r DeleteCustomAvailabilityZoneRequest) Send(ctx context.Context) (*DeleteCustomAvailabilityZoneResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCustomAvailabilityZoneResponse{
		DeleteCustomAvailabilityZoneOutput: r.Request.Data.(*DeleteCustomAvailabilityZoneOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCustomAvailabilityZoneResponse is the response type for the
// DeleteCustomAvailabilityZone API operation.
type DeleteCustomAvailabilityZoneResponse struct {
	*DeleteCustomAvailabilityZoneOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCustomAvailabilityZone request.
func (r *DeleteCustomAvailabilityZoneResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
