// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53domains

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type EnableDomainAutoRenewInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that you want to enable automatic renewal for.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDomainAutoRenewInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableDomainAutoRenewInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableDomainAutoRenewInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableDomainAutoRenewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableDomainAutoRenewOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableDomainAutoRenew = "EnableDomainAutoRenew"

// EnableDomainAutoRenewRequest returns a request value for making API operation for
// Amazon Route 53 Domains.
//
// This operation configures Amazon Route 53 to automatically renew the specified
// domain before the domain registration expires. The cost of renewing your
// domain registration is billed to your AWS account.
//
// The period during which you can renew a domain name varies by TLD. For a
// list of TLDs and their renewal policies, see "Renewal, restoration, and deletion
// times" (http://wiki.gandi.net/en/domains/renew#renewal_restoration_and_deletion_times)
// on the website for our registrar associate, Gandi. Amazon Route 53 requires
// that you renew before the end of the renewal period that is listed on the
// Gandi website so we can complete processing before the deadline.
//
//    // Example sending a request using EnableDomainAutoRenewRequest.
//    req := client.EnableDomainAutoRenewRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/EnableDomainAutoRenew
func (c *Client) EnableDomainAutoRenewRequest(input *EnableDomainAutoRenewInput) EnableDomainAutoRenewRequest {
	op := &aws.Operation{
		Name:       opEnableDomainAutoRenew,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableDomainAutoRenewInput{}
	}

	req := c.newRequest(op, input, &EnableDomainAutoRenewOutput{})
	return EnableDomainAutoRenewRequest{Request: req, Input: input, Copy: c.EnableDomainAutoRenewRequest}
}

// EnableDomainAutoRenewRequest is the request type for the
// EnableDomainAutoRenew API operation.
type EnableDomainAutoRenewRequest struct {
	*aws.Request
	Input *EnableDomainAutoRenewInput
	Copy  func(*EnableDomainAutoRenewInput) EnableDomainAutoRenewRequest
}

// Send marshals and sends the EnableDomainAutoRenew API request.
func (r EnableDomainAutoRenewRequest) Send(ctx context.Context) (*EnableDomainAutoRenewResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableDomainAutoRenewResponse{
		EnableDomainAutoRenewOutput: r.Request.Data.(*EnableDomainAutoRenewOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableDomainAutoRenewResponse is the response type for the
// EnableDomainAutoRenew API operation.
type EnableDomainAutoRenewResponse struct {
	*EnableDomainAutoRenewOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableDomainAutoRenew request.
func (r *EnableDomainAutoRenewResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
