// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type StopTransformJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the transform job to stop.
	//
	// TransformJobName is a required field
	TransformJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopTransformJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTransformJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopTransformJobInput"}

	if s.TransformJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformJobName"))
	}
	if s.TransformJobName != nil && len(*s.TransformJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TransformJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopTransformJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopTransformJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopTransformJob = "StopTransformJob"

// StopTransformJobRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Stops a transform job.
//
// When Amazon SageMaker receives a StopTransformJob request, the status of
// the job changes to Stopping. After Amazon SageMaker stops the job, the status
// is set to Stopped. When you stop a transform job before it is completed,
// Amazon SageMaker doesn't store the job's output in Amazon S3.
//
//    // Example sending a request using StopTransformJobRequest.
//    req := client.StopTransformJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTransformJob
func (c *Client) StopTransformJobRequest(input *StopTransformJobInput) StopTransformJobRequest {
	op := &aws.Operation{
		Name:       opStopTransformJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTransformJobInput{}
	}

	req := c.newRequest(op, input, &StopTransformJobOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return StopTransformJobRequest{Request: req, Input: input, Copy: c.StopTransformJobRequest}
}

// StopTransformJobRequest is the request type for the
// StopTransformJob API operation.
type StopTransformJobRequest struct {
	*aws.Request
	Input *StopTransformJobInput
	Copy  func(*StopTransformJobInput) StopTransformJobRequest
}

// Send marshals and sends the StopTransformJob API request.
func (r StopTransformJobRequest) Send(ctx context.Context) (*StopTransformJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopTransformJobResponse{
		StopTransformJobOutput: r.Request.Data.(*StopTransformJobOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopTransformJobResponse is the response type for the
// StopTransformJob API operation.
type StopTransformJobResponse struct {
	*StopTransformJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopTransformJob request.
func (r *StopTransformJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
