// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateMonitoringScheduleInput struct {
	_ struct{} `type:"structure"`

	// The configuration object that specifies the monitoring schedule and defines
	// the monitoring job.
	//
	// MonitoringScheduleConfig is a required field
	MonitoringScheduleConfig *MonitoringScheduleConfig `type:"structure" required:"true"`

	// The name of the monitoring schedule. The name must be unique within an AWS
	// Region within an AWS account.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMonitoringScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMonitoringScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateMonitoringScheduleInput"}

	if s.MonitoringScheduleConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringScheduleConfig"))
	}

	if s.MonitoringScheduleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringScheduleName"))
	}
	if s.MonitoringScheduleName != nil && len(*s.MonitoringScheduleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MonitoringScheduleName", 1))
	}
	if s.MonitoringScheduleConfig != nil {
		if err := s.MonitoringScheduleConfig.Validate(); err != nil {
			invalidParams.AddNested("MonitoringScheduleConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateMonitoringScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the monitoring schedule.
	//
	// MonitoringScheduleArn is a required field
	MonitoringScheduleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMonitoringScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateMonitoringSchedule = "UpdateMonitoringSchedule"

// UpdateMonitoringScheduleRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Updates a previously created schedule.
//
//    // Example sending a request using UpdateMonitoringScheduleRequest.
//    req := client.UpdateMonitoringScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateMonitoringSchedule
func (c *Client) UpdateMonitoringScheduleRequest(input *UpdateMonitoringScheduleInput) UpdateMonitoringScheduleRequest {
	op := &aws.Operation{
		Name:       opUpdateMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMonitoringScheduleInput{}
	}

	req := c.newRequest(op, input, &UpdateMonitoringScheduleOutput{})
	return UpdateMonitoringScheduleRequest{Request: req, Input: input, Copy: c.UpdateMonitoringScheduleRequest}
}

// UpdateMonitoringScheduleRequest is the request type for the
// UpdateMonitoringSchedule API operation.
type UpdateMonitoringScheduleRequest struct {
	*aws.Request
	Input *UpdateMonitoringScheduleInput
	Copy  func(*UpdateMonitoringScheduleInput) UpdateMonitoringScheduleRequest
}

// Send marshals and sends the UpdateMonitoringSchedule API request.
func (r UpdateMonitoringScheduleRequest) Send(ctx context.Context) (*UpdateMonitoringScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateMonitoringScheduleResponse{
		UpdateMonitoringScheduleOutput: r.Request.Data.(*UpdateMonitoringScheduleOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateMonitoringScheduleResponse is the response type for the
// UpdateMonitoringSchedule API operation.
type UpdateMonitoringScheduleResponse struct {
	*UpdateMonitoringScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateMonitoringSchedule request.
func (r *UpdateMonitoringScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
