// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package savingsplans

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeSavingsPlanRatesInput struct {
	_ struct{} `type:"structure"`

	// The filters.
	Filters []SavingsPlanRateFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return with a single call. To retrieve additional
	// results, make another call with the returned token value.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the Savings Plan.
	//
	// SavingsPlanId is a required field
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSavingsPlanRatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSavingsPlanRatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeSavingsPlanRatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.SavingsPlanId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SavingsPlanId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeSavingsPlanRatesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "filters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SavingsPlanId != nil {
		v := *s.SavingsPlanId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "savingsPlanId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeSavingsPlanRatesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the Savings Plan.
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string"`

	// Information about the Savings Plans rates.
	SearchResults []SavingsPlanRate `locationName:"searchResults" type:"list"`
}

// String returns the string representation
func (s DescribeSavingsPlanRatesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeSavingsPlanRatesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SavingsPlanId != nil {
		v := *s.SavingsPlanId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "savingsPlanId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SearchResults != nil {
		v := s.SearchResults

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "searchResults", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDescribeSavingsPlanRates = "DescribeSavingsPlanRates"

// DescribeSavingsPlanRatesRequest returns a request value for making API operation for
// AWS Savings Plans.
//
// Describes the specified Savings Plans rates.
//
//    // Example sending a request using DescribeSavingsPlanRatesRequest.
//    req := client.DescribeSavingsPlanRatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlanRates
func (c *Client) DescribeSavingsPlanRatesRequest(input *DescribeSavingsPlanRatesInput) DescribeSavingsPlanRatesRequest {
	op := &aws.Operation{
		Name:       opDescribeSavingsPlanRates,
		HTTPMethod: "POST",
		HTTPPath:   "/DescribeSavingsPlanRates",
	}

	if input == nil {
		input = &DescribeSavingsPlanRatesInput{}
	}

	req := c.newRequest(op, input, &DescribeSavingsPlanRatesOutput{})
	return DescribeSavingsPlanRatesRequest{Request: req, Input: input, Copy: c.DescribeSavingsPlanRatesRequest}
}

// DescribeSavingsPlanRatesRequest is the request type for the
// DescribeSavingsPlanRates API operation.
type DescribeSavingsPlanRatesRequest struct {
	*aws.Request
	Input *DescribeSavingsPlanRatesInput
	Copy  func(*DescribeSavingsPlanRatesInput) DescribeSavingsPlanRatesRequest
}

// Send marshals and sends the DescribeSavingsPlanRates API request.
func (r DescribeSavingsPlanRatesRequest) Send(ctx context.Context) (*DescribeSavingsPlanRatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSavingsPlanRatesResponse{
		DescribeSavingsPlanRatesOutput: r.Request.Data.(*DescribeSavingsPlanRatesOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeSavingsPlanRatesResponse is the response type for the
// DescribeSavingsPlanRates API operation.
type DescribeSavingsPlanRatesResponse struct {
	*DescribeSavingsPlanRatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSavingsPlanRates request.
func (r *DescribeSavingsPlanRatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
