// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type InviteMembersInput struct {
	_ struct{} `type:"structure"`

	// A list of IDs of the AWS accounts that you want to invite to Security Hub
	// as members.
	AccountIds []string `type:"list"`
}

// String returns the string representation
func (s InviteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InviteMembersInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountIds != nil {
		v := s.AccountIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AccountIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type InviteMembersOutput struct {
	_ struct{} `type:"structure"`

	// A list of account ID and email address pairs of the AWS accounts that couldn't
	// be processed.
	UnprocessedAccounts []Result `type:"list"`
}

// String returns the string representation
func (s InviteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InviteMembersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.UnprocessedAccounts != nil {
		v := s.UnprocessedAccounts

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "UnprocessedAccounts", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opInviteMembers = "InviteMembers"

// InviteMembersRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Invites other AWS accounts to become member accounts for the Security Hub
// master account that the invitation is sent from. Before you can use this
// action to invite a member, you must first create the member account in Security
// Hub by using the CreateMembers action. When the account owner accepts the
// invitation to become a member account and enables Security Hub, the master
// account can view the findings generated from member account.
//
//    // Example sending a request using InviteMembersRequest.
//    req := client.InviteMembersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers
func (c *Client) InviteMembersRequest(input *InviteMembersInput) InviteMembersRequest {
	op := &aws.Operation{
		Name:       opInviteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/members/invite",
	}

	if input == nil {
		input = &InviteMembersInput{}
	}

	req := c.newRequest(op, input, &InviteMembersOutput{})
	return InviteMembersRequest{Request: req, Input: input, Copy: c.InviteMembersRequest}
}

// InviteMembersRequest is the request type for the
// InviteMembers API operation.
type InviteMembersRequest struct {
	*aws.Request
	Input *InviteMembersInput
	Copy  func(*InviteMembersInput) InviteMembersRequest
}

// Send marshals and sends the InviteMembers API request.
func (r InviteMembersRequest) Send(ctx context.Context) (*InviteMembersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &InviteMembersResponse{
		InviteMembersOutput: r.Request.Data.(*InviteMembersOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// InviteMembersResponse is the response type for the
// InviteMembers API operation.
type InviteMembersResponse struct {
	*InviteMembersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// InviteMembers request.
func (r *InviteMembersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
