// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopTrainingDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier currently
	// being trained.
	//
	// DocumentClassifierArn is a required field
	DocumentClassifierArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopTrainingDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTrainingDocumentClassifierInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopTrainingDocumentClassifierInput"}

	if s.DocumentClassifierArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentClassifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopTrainingDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopTrainingDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopTrainingDocumentClassifier = "StopTrainingDocumentClassifier"

// StopTrainingDocumentClassifierRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Stops a document classifier training job while in progress.
//
// If the training job state is TRAINING, the job is marked for termination
// and put into the STOP_REQUESTED state. If the training job completes before
// it can be stopped, it is put into the TRAINED; otherwise the training job
// is stopped and put into the STOPPED state and the service sends back an HTTP
// 200 response with an empty HTTP body.
//
//    // Example sending a request using StopTrainingDocumentClassifierRequest.
//    req := client.StopTrainingDocumentClassifierRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier
func (c *Client) StopTrainingDocumentClassifierRequest(input *StopTrainingDocumentClassifierInput) StopTrainingDocumentClassifierRequest {
	op := &aws.Operation{
		Name:       opStopTrainingDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTrainingDocumentClassifierInput{}
	}

	req := c.newRequest(op, input, &StopTrainingDocumentClassifierOutput{})
	return StopTrainingDocumentClassifierRequest{Request: req, Input: input, Copy: c.StopTrainingDocumentClassifierRequest}
}

// StopTrainingDocumentClassifierRequest is the request type for the
// StopTrainingDocumentClassifier API operation.
type StopTrainingDocumentClassifierRequest struct {
	*aws.Request
	Input *StopTrainingDocumentClassifierInput
	Copy  func(*StopTrainingDocumentClassifierInput) StopTrainingDocumentClassifierRequest
}

// Send marshals and sends the StopTrainingDocumentClassifier API request.
func (r StopTrainingDocumentClassifierRequest) Send(ctx context.Context) (*StopTrainingDocumentClassifierResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopTrainingDocumentClassifierResponse{
		StopTrainingDocumentClassifierOutput: r.Request.Data.(*StopTrainingDocumentClassifierOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopTrainingDocumentClassifierResponse is the response type for the
// StopTrainingDocumentClassifier API operation.
type StopTrainingDocumentClassifierResponse struct {
	*StopTrainingDocumentClassifierOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopTrainingDocumentClassifier request.
func (r *StopTrainingDocumentClassifierResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
